CREATE TABLE `almacenes` (
  `id` int(11) NOT NULL,
  `idEmpresa` int(11) DEFAULT '1',
  `idPaquete` int(11) DEFAULT NULL,
  `nombre` varchar(60) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `nombre_abrev` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `ciudad` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `cp` varchar(10) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `telefono1` varchar(12) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `telefono2` varchar(12) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

CREATE TABLE `autenticacion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idProspecto` int(11) DEFAULT '0',
  `token` text,
  `expired_at` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT '1',
  `updated_by` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

CREATE TABLE `bonificaciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `bonificacion` decimal(10,2) DEFAULT '0.00',
  `fechaPago` date DEFAULT NULL,
  `idTipo` int(11) DEFAULT NULL,
  `tipo` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `statusAutorizado` tinyint(1) DEFAULT '0',
  `fechaAutorizado` date DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT '1',
  `updated_by` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

CREATE TABLE `bonificaciones_descuentos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idBonificacion` int(11) DEFAULT NULL,
  `concepto` varchar(250) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT '1',
  `updated_by` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

CREATE TABLE `comisiones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `fechaDetonacion` date DEFAULT NULL,
  `precioVenta` decimal(10,2) DEFAULT NULL,
  `tipoComision` varchar(20) DEFAULT 'Matriz' COMMENT 'Matriz, Fija',
  `porcentajeComision` decimal(10,2) DEFAULT NULL,
  `comision` decimal(10,2) DEFAULT NULL,
  `porcentajePago1` decimal(10,2) DEFAULT NULL,
  `pago1` decimal(10,2) DEFAULT NULL,
  `porcentajeImptoPago1` decimal(10,2) DEFAULT NULL,
  `imptoPago1` decimal(10,2) DEFAULT NULL,
  `totalPago1` decimal(10,2) DEFAULT NULL,
  `fechaPago1` date DEFAULT NULL,
  `statusAutorizacionPago1` int(11) DEFAULT NULL,
  `fechaAutorizacionPago1` date DEFAULT NULL,
  `saldo` decimal(10,2) DEFAULT NULL,
  `diferenciaAsesorPago1` decimal(10,2) DEFAULT NULL,
  `formaPago1` varchar(20) DEFAULT NULL,
  `porcentajeComisionAjuste` decimal(10,2) DEFAULT NULL,
  `comisionAjuste` decimal(10,2) DEFAULT NULL,
  `porcentajeAjuste` decimal(10,2) DEFAULT NULL,
  `ajuste` decimal(10,2) DEFAULT NULL,
  `porcentajeImptoAjuste` decimal(10,2) DEFAULT NULL,
  `imptoAjuste` decimal(10,2) DEFAULT NULL,
  `totalAjuste` decimal(10,2) DEFAULT NULL,
  `fechaAjuste` date DEFAULT NULL,
  `statusAutorizacionAjuste` int(11) DEFAULT NULL,
  `fechaAutorizacionAjuste` date DEFAULT NULL,
  `saldoAjuste` decimal(10,2) DEFAULT NULL,
  `diferenciaAsesorAjuste` decimal(10,2) DEFAULT NULL,
  `formaPagoAjuste` varchar(20) DEFAULT NULL,
  `porcentajePago2` decimal(10,2) DEFAULT NULL,
  `pago2` decimal(10,2) DEFAULT NULL,
  `porcentajeImptoPago2` decimal(10,2) DEFAULT NULL,
  `imptoPago2` decimal(10,2) DEFAULT NULL,
  `totalPago2` decimal(10,2) DEFAULT NULL,
  `fechaPago2` date DEFAULT NULL,
  `statusAutorizacionPago2` int(11) DEFAULT NULL,
  `fechaAutorizacionPago2` date DEFAULT NULL,
  `diferenciaAsesorPago2` decimal(10,2) DEFAULT NULL,
  `formaPago2` varchar(20) DEFAULT NULL,
  `statusEntrega` int(11) DEFAULT '0',
  `asistioEntregaAsesor` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

CREATE TABLE `comisiones_fraccionamientos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(11) DEFAULT NULL,
  `porcentajeComision` decimal(10,2) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `compra` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_orden_compra` int(11) DEFAULT '0',
  `id_proveedor` int(11) DEFAULT '0',
  `id_almacen` int(11) DEFAULT '0',
  `id_moneda` int(11) DEFAULT '0',
  `idEmpresa` int(11) DEFAULT NULL,
  `folio` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fecha` datetime DEFAULT NULL,
  `importe_neto` decimal(20,2) DEFAULT '0.00',
  `fecha_entrega` datetime DEFAULT NULL,
  `numero_articulos` int(11) DEFAULT '0',
  `estatus` varchar(10) DEFAULT NULL COMMENT 'PENDIENTE, RECIBIDA, CANCELADO',
  `status` int(11) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT '0',
  `updated_by` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `contado_cuentas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) NOT NULL,
  `fecha` date DEFAULT NULL,
  `monto` decimal(11,2) NOT NULL,
  `saldo` decimal(11,2) NOT NULL,
  `plazos` int(11) NOT NULL,
  `pagos` decimal(11,2) NOT NULL,
  `interes` decimal(5,2) NOT NULL,
  `statusCuenta` tinyint(1) NOT NULL COMMENT '0: por liquidar | 1: liquidada | 2:cancelada',
  `statusObra` tinyint(1) NOT NULL COMMENT '1:pendiente | 2:en construccion',
  `status` tinyint(1) NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

CREATE TABLE `contado_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `formaPago` varchar(20) NOT NULL,
  `comprobante` varchar(20) NOT NULL,
  `idCuenta` int(11) NOT NULL,
  `cuenta` varchar(20) DEFAULT NULL,
  `tipo` tinyint(1) NOT NULL COMMENT '1:deposito | 2:retiro',
  `descripcion` varchar(200) NOT NULL,
  `importe` decimal(11,2) NOT NULL,
  `saldo` decimal(11,2) NOT NULL,
  `statusDetalle` tinyint(1) DEFAULT NULL COMMENT '1: en tiempo | 2:vencido | 3:penalizacion',
  `movimiento` int(11) NOT NULL,
  `fecha` date NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

CREATE TABLE `detalle_compra` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_compra` int(11) DEFAULT '0',
  `id_articulo` int(11) DEFAULT '0',
  `clave_articulo` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `unidades` int(11) DEFAULT '0',
  `precio_unitario` decimal(11,2) DEFAULT '0.00',
  `descuento_art` decimal(11,2) DEFAULT '0.00',
  `status` int(11) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT '0',
  `updated_by` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `detalle_orden` (
  `id` int(11) NOT NULL,
  `idPresupuestoMat` int(11) DEFAULT NULL,
  `semana` int(11) DEFAULT NULL,
  `id_orden_compra` int(11) DEFAULT NULL,
  `clave_articulo` varchar(20) COLLATE utf8_swedish_ci DEFAULT NULL,
  `id_articulo` int(11) DEFAULT NULL,
  `unidades` int(11) DEFAULT NULL,
  `precio_unitario` decimal(11,2) DEFAULT NULL,
  `descuento_art` decimal(11,2) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_swedish_ci;

CREATE TABLE `detalle_orden_viv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idPresupuestoMat` int(11) DEFAULT NULL,
  `semana` int(11) DEFAULT NULL,
  `id_orden_compra` int(11) DEFAULT NULL,
  `clave_articulo` varchar(20) COLLATE utf8_swedish_ci DEFAULT NULL,
  `id_articulo` int(11) DEFAULT NULL,
  `unidades` int(11) DEFAULT NULL,
  `precio_unitario` decimal(11,2) DEFAULT NULL,
  `descuento_art` decimal(11,2) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_swedish_ci;

CREATE TABLE `detalle_recepcion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_recepcion` int(11) DEFAULT '0',
  `id_articulo` int(11) DEFAULT '0',
  `clave_articulo` varchar(20) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `unidades` int(11) DEFAULT '0',
  `precio_unitario` decimal(11,2) DEFAULT '0.00',
  `descuento_art` decimal(11,2) DEFAULT '0.00',
  `status` int(11) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT '0',
  `updated_by` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `diferencia_promotores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `idPromotor` int(11) NOT NULL,
  `cargo` decimal(10,2) DEFAULT NULL,
  `abono` decimal(10,2) DEFAULT NULL,
  `saldo` decimal(10,2) DEFAULT NULL,
  `descripcion` text,
  `status` int(11) DEFAULT NULL,
  `created` date DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `empresas` (
  `id` int(11) NOT NULL,
  `abrev` varchar(10) DEFAULT NULL,
  `titulo` varchar(100) DEFAULT NULL,
  `bdServer` varchar(100) DEFAULT NULL,
  `foto` varchar(45) DEFAULT NULL,
  `thumbnail` varchar(45) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `empresas` VALUES (1, 'SAL', 'SALI EDIFICACIONES, S.A. DE C.V.', 'SALI 2017.FDB', '2_0.jpg', NULL, 1, '2021-01-22 10:35:30', '2021-01-22 10:35:51', NULL, NULL);
INSERT INTO `empresas` VALUES (2, 'CIT', 'CITY HOMES S.A. DE C.V.', 'CITY HOMES SA DE CV.FDB', '2_0.png', NULL, 1, '2021-01-22 10:35:36', '2021-01-22 10:35:53', NULL, NULL);
INSERT INTO `empresas` VALUES (3, 'CTR', 'CONTROL', 'CONTROL.FDB', '2_0.jpg', NULL, 1, '2021-01-22 10:35:39', '2021-01-22 10:35:56', NULL, NULL);
INSERT INTO `empresas` VALUES (4, 'FYP', 'FERRETERIA Y PANES DE MEXICO', 'FERETERIA.FDB', '2_0.jpg', NULL, 1, '2021-01-22 10:35:42', '2021-01-22 10:35:58', NULL, NULL);
INSERT INTO `empresas` VALUES (5, 'PRO', 'PROINSA', 'PROINSA.FDB', '2_0.jpg', NULL, 1, '2021-01-22 10:35:45', '2021-01-22 10:36:00', NULL, NULL);
INSERT INTO `empresas` VALUES (6, 'VIV', 'VIVIEND INMOBILIARIA S.A. DE C.V.', 'VIVIEND INMOBILIARIA.FDB', '6_0.jpg', NULL, 1, '2021-01-22 10:35:48', '2021-01-22 10:36:02', NULL, NULL);

CREATE TABLE `fotosvivienda` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idSupercategoria` int(11) DEFAULT NULL,
  `idProyecto` int(11) DEFAULT NULL,
  `tipo` varchar(150) DEFAULT NULL,
  `foto` varchar(150) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT '1',
  `updated_by` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `garantias` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(150) DEFAULT NULL,
  `abreviacion` varchar(150) DEFAULT NULL,
  `descripcion` text,
  `vigencia` int(11) DEFAULT '0' COMMENT 'Es No. de días',
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

INSERT INTO `garantias` VALUES (1, 'Instalación Eléctricas ', 'instElectricas', NULL, 91, 1, NULL, NULL, NULL, NULL);
INSERT INTO `garantias` VALUES (2, 'Instalación Hidráulicas', 'instHidraulicas', NULL, 91, 1, NULL, NULL, NULL, NULL);
INSERT INTO `garantias` VALUES (3, 'Instalación Sanitarias', 'instSanitarias', NULL, 61, 1, NULL, NULL, NULL, NULL);
INSERT INTO `garantias` VALUES (4, 'Instalación Gas', 'instGas', NULL, 61, 1, NULL, NULL, NULL, NULL);
INSERT INTO `garantias` VALUES (5, 'Cancelería', 'canceleria', NULL, 0, 1, NULL, NULL, NULL, NULL);
INSERT INTO `garantias` VALUES (6, 'Impermeabilización', 'impermeabilizacion', NULL, 1825, 1, NULL, NULL, NULL, NULL);
INSERT INTO `garantias` VALUES (7, 'Acabados', 'acabados', NULL, 182, 1, NULL, NULL, NULL, NULL);
INSERT INTO `garantias` VALUES (8, 'Estructural', 'estructural', NULL, 730, 1, NULL, NULL, NULL, NULL);
INSERT INTO `garantias` VALUES (9, 'Accesorios ', 'accesorios', NULL, 61, 1, NULL, NULL, NULL, NULL);
INSERT INTO `garantias` VALUES (10, 'Calentador Agua ', 'calentadorAgua', NULL, 730, 1, NULL, NULL, NULL, NULL);

CREATE TABLE `logs_comisiones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idComision` int(11) DEFAULT NULL,
  `comisionAnterior` decimal(10,2) DEFAULT NULL,
  `comisionNueva` decimal(10,2) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `logs_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idProyecto` int(11) DEFAULT NULL,
  `idProspecto` int(11) DEFAULT NULL,
  `tipo` varchar(150) DEFAULT NULL COMMENT 'arranque, obra negra, acabados, entrega',
  `via` varchar(150) DEFAULT NULL COMMENT 'whatsapp, email',
  `enviado` int(11) DEFAULT NULL,
  `http_code` int(11) DEFAULT NULL,
  `json` text,
  `json2` text,
  `jsonMessage` text,
  `jsonMedia` text,
  `status` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

CREATE TABLE `logs_ws` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idEmpresa` int(11) DEFAULT '0',
  `nombreTabla` varchar(20) DEFAULT NULL,
  `funcion` varchar(50) DEFAULT NULL,
  `http_code` int(11) DEFAULT '0',
  `insertados` int(11) DEFAULT '0',
  `actualizados` int(11) DEFAULT '0',
  `totalRegistros` int(11) DEFAULT '0',
  `json` text CHARACTER SET utf8 COLLATE utf8_spanish2_ci,
  `time` float DEFAULT '0',
  `status` tinyint(1) DEFAULT '0',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

CREATE TABLE `material` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idEmpresa` int(11) DEFAULT '1',
  `idFraccionamiento` int(11) DEFAULT NULL,
  `idPrototipo` int(11) DEFAULT NULL,
  `idPaquete` int(11) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

CREATE TABLE `materiales` (
  `id` int(11) NOT NULL,
  `idEmpresa` int(11) DEFAULT '1',
  `clave` varchar(150) CHARACTER SET utf8 DEFAULT NULL,
  `nombre` varchar(500) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `id_linea_art` int(11) DEFAULT NULL,
  `linea_art` varchar(30) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `unidad_venta` varchar(20) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `unidad_compra` varchar(20) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `contenido_unidad_compra` varchar(20) COLLATE utf8_spanish2_ci NOT NULL,
  `notas_ventas` varchar(100) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `notas_compras` varchar(100) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `estatus` varchar(30) COLLATE utf8_spanish2_ci NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

INSERT INTO `materiales` VALUES (10398, 1, 'EU-019', ' FOTOSELDA', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:13', '2020-10-19 11:15:02', 5, 5);
INSERT INTO `materiales` VALUES (11349, 1, 'I-003', ' IMPERMEABILIZACION', 816, 'IMPERMEABILIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:13', '2020-10-19 11:15:02', 5, 5);
INSERT INTO `materiales` VALUES (13015, 1, 'O-261', '49931', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:13', '2020-10-19 11:15:03', 5, 5);
INSERT INTO `materiales` VALUES (13018, 1, 'O-262', 'A5000-GALON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:13', '2020-10-19 11:15:03', 5, 5);
INSERT INTO `materiales` VALUES (19261, 1, 'ABA-SEG', 'ABA SEGUROS, S.A. DE.C.V', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:13', '2020-10-19 11:15:03', 5, 5);
INSERT INTO `materiales` VALUES (10262, 1, 'E-035', 'ABRAZADERA 1/2\"', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:14', '2020-10-19 11:15:03', 5, 5);
INSERT INTO `materiales` VALUES (13039, 1, 'O-269', 'ABRAZADERA 2\" PARA MALLA CICLONICA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:14', '2020-10-19 11:15:03', 5, 5);
INSERT INTO `materiales` VALUES (10266, 1, 'E-036', 'ABRAZADERA 3/4\"', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:14', '2020-10-19 11:15:03', 5, 5);
INSERT INTO `materiales` VALUES (10566, 1, 'H-034', 'ABRAZADERA DE 1/2\" ROSCABLE BOLSA CON 10', 786, 'HIDRAULICA', 'BOLSA', 'BOLSA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:14', '2020-10-19 11:15:03', 5, 5);
INSERT INTO `materiales` VALUES (12822, 1, 'E-70', 'ABRAZADERAS PARA REJA DE ACERO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:14', '2020-10-19 11:15:03', 5, 5);
INSERT INTO `materiales` VALUES (26041, 1, 'MO-109', 'ACABADOS', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:14', '2020-10-19 11:15:04', 5, 5);
INSERT INTO `materiales` VALUES (13453, 1, 'V-006', 'ACARREO DE POLVILLO', 794, 'ACABADOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:14', '2020-10-19 11:15:04', 5, 5);
INSERT INTO `materiales` VALUES (34249, 1, 'ACP-100', 'ACCESO PEATONAL DE 1.15X2.10 FABRICADO EN R-300 POSTE BASTIDORES', 25899, 'HERRAMIENTA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:14', '2020-10-19 11:15:04', 5, 5);
INSERT INTO `materiales` VALUES (34246, 1, 'ACV-100', 'ACCESO VEHICULAR PARA UN CLARO DE 5.50X2.15 FABRICADO CON PTR 3X3 ABATIBLE', 25899, 'HERRAMIENTA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:14', '2020-10-19 11:15:04', 5, 5);
INSERT INTO `materiales` VALUES (12368, 1, 'S-044', 'ACCESORIOS DE BAÑO MARCA CATO BLANCOS', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:15', '2020-10-19 11:15:04', 5, 5);
INSERT INTO `materiales` VALUES (30864, 1, 'ACD-100', 'ACCESORIOS PARA BAÑO CROMADOS DICA', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:15', '2020-10-19 11:15:04', 5, 5);
INSERT INTO `materiales` VALUES (31510, 1, 'ACR-100', 'ACCESORIOS PARA BAÑO CROMADOS RUGO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:15', '2020-10-19 11:15:04', 5, 5);
INSERT INTO `materiales` VALUES (9906, 1, 'AC-015', 'ACCESORIOS PARA BAÑO MARCA CATOS COLOR BLANCO', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:15', '2020-10-19 11:15:04', 5, 5);
INSERT INTO `materiales` VALUES (25481, 1, 'ACC-131', 'ACCESS POINT UBIQUITI PoE CON ADAPTADOR', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:15', '2020-10-19 11:15:05', 5, 5);
INSERT INTO `materiales` VALUES (13738, 1, 'AC-1000', 'ACEITE PARA CAMION 5 LTS', 794, 'ACABADOS', 'LTS', 'LTS', '1', '', '', 'ACTIVO                      ', '2020-10-19 11:01:15', '2021-02-23 15:54:00', 5, 0);
INSERT INTO `materiales` VALUES (11172, 1, 'C-013', 'ACELERANTE 24 HRS', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:15', '2020-10-19 11:15:05', 5, 5);
INSERT INTO `materiales` VALUES (9946, 1, 'AD-002', 'ACELERANTE PARA CONCRETO A 24 HORAS', 811, 'ADITIVOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:15', '2020-10-19 11:15:05', 5, 5);
INSERT INTO `materiales` VALUES (9942, 1, 'AD-001', 'ACELERANTE PARA CONCRETO TANQUE 200 LTS.', 811, 'ADITIVOS', 'TANQUE', 'TANQUE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:15', '2020-10-19 11:15:05', 5, 5);
INSERT INTO `materiales` VALUES (9610, 1, 'ACE-003', 'ACERO ALAMBRE RECOCIDO CAL. 16', 809, 'ACERO', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:16', '2020-10-19 11:15:05', 5, 5);
INSERT INTO `materiales` VALUES (11417, 1, 'ACE-017', 'ACERO DE REFUERZO #6 3/4', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:16', '2020-10-19 11:15:05', 5, 5);
INSERT INTO `materiales` VALUES (9606, 1, 'ACE-001', 'ACERO DE REFUERZO NO. 3 3/8\" TRAMO DE 12 MTS.', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:16', '2020-10-19 11:15:05', 5, 5);
INSERT INTO `materiales` VALUES (9914, 1, 'ACE-002', 'ACERO DE REFUERZO NO. 4 1/2\" TRAMO DE 12 MTS.', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:16', '2020-10-19 11:15:05', 5, 5);
INSERT INTO `materiales` VALUES (10550, 1, 'ACE-013', 'ACERO DE REFUERZO NO. 5 5/8\" TRAMO DE 12 MTS.', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:16', '2020-10-19 11:15:06', 5, 5);
INSERT INTO `materiales` VALUES (26990, 1, 'ACE-616', 'ACERO DE REFUERZO NO. 6 3/4\" TRAMO DE 12 MTS.', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:16', '2020-10-19 11:15:06', 5, 5);
INSERT INTO `materiales` VALUES (31660, 1, 'ACM-100', 'ACIDO MURIATICO SULTAN BLANCO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:16', '2020-10-19 11:15:06', 5, 5);
INSERT INTO `materiales` VALUES (34167, 1, 'ACE-200', 'ACRILICO PARA ESCRITORIO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:16', '2020-10-19 11:15:06', 5, 5);
INSERT INTO `materiales` VALUES (12281, 1, 'O-127', 'ACTA NOTARIAL', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:16', '2020-10-19 11:15:06', 5, 5);
INSERT INTO `materiales` VALUES (24881, 1, 'AF-305', 'ACTIVOS FIJOS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:16', '2020-10-19 11:15:06', 5, 5);
INSERT INTO `materiales` VALUES (31567, 1, 'ACT-100', 'ACTUALIZACION', 794, 'ACABADOS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:17', '2020-10-19 11:15:06', 5, 5);
INSERT INTO `materiales` VALUES (34705, 1, '', 'ACTUAZALIZACIONES', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:17', '2020-10-19 11:15:06', 5, 5);
INSERT INTO `materiales` VALUES (12708, 1, 'O-187', 'ACUMULADOR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:17', '2020-10-19 11:15:07', 5, 5);
INSERT INTO `materiales` VALUES (15181, 1, 'MO6', 'AD MATERIAL Y MANO DE OBRA', 15165, 'MATERIAL Y MANO DE OBRA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:17', '2020-10-19 11:15:07', 5, 5);
INSERT INTO `materiales` VALUES (34595, 1, 'MO77', 'AD MATERIALES Y MANO DE OBRA', 15165, 'MATERIAL Y MANO DE OBRA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:17', '2020-10-19 11:15:07', 5, 5);
INSERT INTO `materiales` VALUES (13369, 1, '0-317', 'ADAPTACION Y CAMBIOS SEMBRADO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:17', '2020-10-19 11:15:07', 5, 5);
INSERT INTO `materiales` VALUES (10797, 1, 'H-052', 'ADAPTADOR MACHO DE INSERCION DE 1/2\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:17', '2020-10-19 11:15:07', 5, 5);
INSERT INTO `materiales` VALUES (25907, 1, 'MV18', 'ADAPTADOR PARA FLOTA DE MAGNESIO', 25899, 'HERRAMIENTA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:17', '2020-10-19 11:15:07', 5, 5);
INSERT INTO `materiales` VALUES (35538, 1, 'ADP-101', 'ADAPTADOR PVC MACHO CEM R-EXT 1 1/2\" CED 40', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:17', '2020-10-19 11:15:07', 5, 5);
INSERT INTO `materiales` VALUES (35592, 1, 'ADP-114', 'ADAPTADOR PVC MACHO CEM R-EXT 1 1/4\" CED 40', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:18', '2020-10-19 11:15:07', 5, 5);
INSERT INTO `materiales` VALUES (34934, 1, 'ADP-040', 'ADAPTADOR PVC MACHO CEM R-EXT 1\" CED 40', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:18', '2020-10-19 11:15:08', 5, 5);
INSERT INTO `materiales` VALUES (35607, 1, 'ADP-120', 'ADAPTADOR PVC MACHO CEM R-EXT 2\" CED 40', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:18', '2020-10-19 11:15:08', 5, 5);
INSERT INTO `materiales` VALUES (24346, 1, 'AU-300', 'ADAPTADOR USB', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:18', '2020-10-19 11:15:08', 5, 5);
INSERT INTO `materiales` VALUES (9565, 1, 'P-001', 'ADHESIVO CEMIX SACO 20 KG', 795, 'PISOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:18', '2020-10-19 11:15:08', 5, 5);
INSERT INTO `materiales` VALUES (10809, 1, 'P-010', 'ADHESIVO PISO SOBRE PISO CEMIX ', 795, 'PISOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:18', '2020-10-19 11:15:08', 5, 5);
INSERT INTO `materiales` VALUES (10908, 1, 'P-018', 'ADHESIVO PSP GRIS SACO DE 10 KG', 795, 'PISOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:18', '2020-10-19 11:15:08', 5, 5);
INSERT INTO `materiales` VALUES (30781, 1, 'P-102', 'ADHESIVO RESILAG  SACO 20 KG', 794, 'ACABADOS', 'SACO', 'SACO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:18', '2020-10-19 11:15:09', 5, 5);
INSERT INTO `materiales` VALUES (13783, 1, 'AD-010', 'ADMINISTRACION ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:19', '2020-10-19 11:15:09', 5, 5);
INSERT INTO `materiales` VALUES (33581, 1, 'ARS-180', 'ADMINISTRACION DE REDES SOCIALES', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:19', '2020-10-19 11:15:09', 5, 5);
INSERT INTO `materiales` VALUES (11717, 1, 'O-064', 'ADOBON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:19', '2020-10-19 11:15:09', 5, 5);
INSERT INTO `materiales` VALUES (35867, 1, 'ADB-200', 'ADOBON BALLENA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:19', '2020-10-19 11:15:09', 5, 5);
INSERT INTO `materiales` VALUES (36472, 1, 'A-264', 'ADOBON DE MATAMOROS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:19', '2020-10-19 11:15:09', 5, 5);
INSERT INTO `materiales` VALUES (33754, 1, 'APS-100', 'ADOPASTO GRIS 30X45', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:19', '2020-10-19 11:15:09', 5, 5);
INSERT INTO `materiales` VALUES (30921, 1, 'AG-600', 'AGUA 600 ML', 803, 'EXTRAS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:19', '2020-10-19 11:15:09', 5, 5);
INSERT INTO `materiales` VALUES (24466, 1, 'MP-102', 'AGUA DE OSMOSIS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:19', '2020-10-19 11:15:09', 5, 5);
INSERT INTO `materiales` VALUES (30917, 1, 'AGM-600', 'AGUA MINERAL 600 ML', 803, 'EXTRAS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:19', '2020-10-19 11:15:10', 5, 5);
INSERT INTO `materiales` VALUES (25712, 1, 'AGP-102', 'AGUA POTABLE', 808, 'OTROS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:20', '2020-10-19 11:15:10', 5, 5);
INSERT INTO `materiales` VALUES (31481, 1, 'AGP-100', 'AGUA PURIFICADA DE 19 LITROS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:20', '2020-10-19 11:15:10', 5, 5);
INSERT INTO `materiales` VALUES (13048, 1, 'A-83', 'AGUARRAS SINTETICO', 794, 'ACABADOS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:20', '2020-10-19 11:15:10', 5, 5);
INSERT INTO `materiales` VALUES (24105, 1, 'AHV-001', 'AHORRO VOLUNTARIO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:20', '2020-10-19 11:15:10', 5, 5);
INSERT INTO `materiales` VALUES (13372, 1, '0-318', 'AJILLO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:20', '2020-10-19 11:15:10', 5, 5);
INSERT INTO `materiales` VALUES (27754, 1, 'AJU-185', 'AJUSTE POR REDONDEO ART. 25 C.F.E)', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:20', '2020-10-19 11:15:10', 5, 5);
INSERT INTO `materiales` VALUES (10354, 1, 'EU-008', 'ALAMBRE DESNUDO 1/0 COBRE', 785, 'ELECTRIFICACION URB', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:20', '2020-10-19 11:15:10', 5, 5);
INSERT INTO `materiales` VALUES (10226, 1, 'E-026', 'ALAMBRE DESNUDO COBRE NO. 6', 791, 'ELECTRIFICACION', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:20', '2020-10-19 11:15:11', 5, 5);
INSERT INTO `materiales` VALUES (12909, 1, 'ACE-024', 'ALAMBRE GALVANIZADO CALIBRE 12', 809, 'ACERO', 'KILO', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:20', '2020-10-19 11:15:11', 5, 5);
INSERT INTO `materiales` VALUES (11365, 1, 'ACE-016', 'ALAMBRE GALVANIZADO CALIBRE 16', 809, 'ACERO', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:20', '2020-10-19 11:15:11', 5, 5);
INSERT INTO `materiales` VALUES (16918, 1, 'AGAL-18', 'ALAMBRE GALVANIZADO CALIBRE 18', 809, 'ACERO', 'KILOS', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:21', '2020-10-19 11:15:11', 5, 5);
INSERT INTO `materiales` VALUES (13390, 1, 'EU-040', 'ALAMBRE RECOCIDO  CAL 16', 791, 'ELECTRIFICACION', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:21', '2020-10-19 11:15:11', 5, 5);
INSERT INTO `materiales` VALUES (9926, 1, 'ACE-009', 'ALAMBRON #2 EQ DE 1/4', 809, 'ACERO', 'KG', 'KG', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:21', '2020-10-19 11:15:11', 5, 5);
INSERT INTO `materiales` VALUES (12552, 1, 'O-165', 'ALAMO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:21', '2020-10-19 11:15:11', 5, 5);
INSERT INTO `materiales` VALUES (24478, 1, 'MP-106', 'ALIMENTADOR PARA CORALES', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:21', '2020-10-19 11:15:12', 5, 5);
INSERT INTO `materiales` VALUES (12287, 1, 'O-129', 'ALIMENTO PARA PERROS', 808, 'OTROS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:21', '2020-10-19 11:15:12', 5, 5);
INSERT INTO `materiales` VALUES (25900, 1, 'MV16', 'ALLANADORA HONDA GAX160 DE 36\"', 25899, 'HERRAMIENTA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:21', '2020-10-19 11:15:12', 5, 5);
INSERT INTO `materiales` VALUES (26924, 1, 'ALT-174', 'ALTAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:21', '2020-10-19 11:15:12', 5, 5);
INSERT INTO `materiales` VALUES (13375, 1, '0-319', 'ALTERNATERA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:21', '2020-10-19 11:15:12', 5, 5);
INSERT INTO `materiales` VALUES (12669, 1, 'EU-039', 'ALUMBRADO PUBLICO', 785, 'ELECTRIFICACION URB', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:21', '2020-10-19 11:15:12', 5, 5);
INSERT INTO `materiales` VALUES (25506, 1, 'ELT-103', 'ALUMBRADO PUBLICO  LEDS', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:22', '2020-10-19 11:15:13', 5, 5);
INSERT INTO `materiales` VALUES (11791, 1, 'CA-032', 'ALUMINIO LINEA 1 1/2 PULGADA', 796, 'CANCELERIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:22', '2020-10-19 11:15:13', 5, 5);
INSERT INTO `materiales` VALUES (21442, 1, '', 'AMORTIZACION P.134', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:22', '2020-10-19 11:15:13', 5, 5);
INSERT INTO `materiales` VALUES (24714, 1, 'ALC-101', 'AMPLIACION DE LICENCIA DE CONSTRUCCION', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:22', '2020-10-19 11:15:13', 5, 5);
INSERT INTO `materiales` VALUES (25318, 1, 'AMP-104', 'AMPLIACION DE POZO DE 12\" A 16\"DE DIAMETRO EN MATERIAL TIPO II DE 0.00 A 60 m DE PROFUNDIDAD', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:22', '2020-10-19 11:15:13', 5, 5);
INSERT INTO `materiales` VALUES (25321, 1, 'AMP-105', 'AMPLIACION DE POZO DE 16\" A 24\"DE DIAMETRO EN MATERIAL TIPO II DE 0.00 A 60 m DE PROFUNDIDAD', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:22', '2020-10-19 11:15:14', 5, 5);
INSERT INTO `materiales` VALUES (24481, 1, 'MP-107', 'AMPOYETA DE BACTERIA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:22', '2020-10-19 11:15:14', 5, 5);
INSERT INTO `materiales` VALUES (10940, 1, 'O-010', 'ANALISIS DE ACERO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:22', '2020-10-19 11:15:14', 5, 5);
INSERT INTO `materiales` VALUES (13558, 1, 'E-088', 'ANALISIS DE CARPETAS ASFALTICAS ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:22', '2020-10-19 11:15:14', 5, 5);
INSERT INTO `materiales` VALUES (12720, 1, 'CS-002', 'ANDY 16, FREGADERO DOBLE TARJA 100CM', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:22', '2020-10-19 11:15:14', 5, 5);
INSERT INTO `materiales` VALUES (12723, 1, 'CS-003', 'ANDY 19, GABINETE ESQUINERO  80CM x 80 CM', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:23', '2020-10-19 11:15:14', 5, 5);
INSERT INTO `materiales` VALUES (12717, 1, 'CS-001', 'ANDY 25, ALACENA PORTAMICRO  80CM', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:23', '2020-10-19 11:15:14', 5, 5);
INSERT INTO `materiales` VALUES (13645, 1, '0-039', 'ANTICIPO', 794, 'ACABADOS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:23', '2020-10-19 11:15:14', 5, 5);
INSERT INTO `materiales` VALUES (29984, 1, 'ADV-001', 'ANTICIPO DE VIVIENDA', 818, 'VENTAS', 'ACTIVIDAD', 'ACTIVIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:23', '2020-10-19 11:15:15', 5, 5);
INSERT INTO `materiales` VALUES (35842, 1, 'ANV-100', 'ANTIVIRUS P/ SERVIDOR SVRCICAEDR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:23', '2020-10-19 11:15:15', 5, 5);
INSERT INTO `materiales` VALUES (25558, 1, 'APL-102', 'ANUNCIO PUBLICITARIO', 804, 'PUBLICIDAD', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:23', '2020-10-19 11:15:15', 5, 5);
INSERT INTO `materiales` VALUES (11823, 1, 'E-061', 'APAGADOR ESCALERA ', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:24', '2020-10-19 11:15:15', 5, 5);
INSERT INTO `materiales` VALUES (11128, 1, 'E-052', 'APAGADOR ESCALERA 3 VIAS BTICINO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:24', '2020-10-19 11:15:15', 5, 5);
INSERT INTO `materiales` VALUES (18918, 1, '', 'APAGADOR ESCALERA 3 VIAS MARFIL SIMON 25', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:24', '2020-10-19 11:15:15', 5, 5);
INSERT INTO `materiales` VALUES (10198, 1, 'E-019', 'APAGADOR SENCILLO ', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:24', '2020-10-19 11:15:15', 5, 5);
INSERT INTO `materiales` VALUES (32822, 1, 'APP-100', 'APLICACION DE POLIURETANO ESPREADO A 1\" EN PARTE BAJA DE LAMIMA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:24', '2020-10-19 11:15:16', 5, 5);
INSERT INTO `materiales` VALUES (36699, 1, 'IPA', 'APPLE CARE+ PARA IPHONE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2020-10-19 11:01:24', '2021-02-23 15:54:02', 5, 0);
INSERT INTO `materiales` VALUES (26239, 1, 'ARA-100', 'ARBOL ALAMILLO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:24', '2020-10-19 11:15:16', 5, 5);
INSERT INTO `materiales` VALUES (36504, 1, 'ARB-100', 'ARBOL ENCINO SIEMPRE VERDE 2\"', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:24', '2020-10-19 11:15:16', 5, 5);
INSERT INTO `materiales` VALUES (10382, 1, 'EU-015', 'ARBOTANTE OCTAGONAL DE 7.50 MTS DE ALTURA', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:24', '2020-10-19 11:15:16', 5, 5);
INSERT INTO `materiales` VALUES (12861, 1, 'O-208', 'ARCHIVERO COLGANTE', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:16', 5, 5);
INSERT INTO `materiales` VALUES (18907, 1, 'ARCH-4G', 'ARCHIVERO DE 4G NOVA NEGRO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:16', 5, 5);
INSERT INTO `materiales` VALUES (13837, 1, 'AR-50', 'ARCHIVERO HORIZONTAL 60X50X75', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:16', 5, 5);
INSERT INTO `materiales` VALUES (31213, 1, 'ARC-100', 'ARCO TUBULAR P/SEGUETA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:17', 5, 5);
INSERT INTO `materiales` VALUES (19258, 1, 'ARE-VER', 'AREAS VERDES', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:17', 5, 5);
INSERT INTO `materiales` VALUES (10980, 1, 'O-083', 'ARENA', 808, 'OTROS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:17', 5, 5);
INSERT INTO `materiales` VALUES (17886, 1, 'ACE-028', 'ARMEX MEDIDA 10-10-4', 809, 'ACERO', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:17', 5, 5);
INSERT INTO `materiales` VALUES (9618, 1, 'ACE-006', 'ARMEX MEDIDA 12-12-4', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:17', 5, 5);
INSERT INTO `materiales` VALUES (9922, 1, 'ACE-007', 'ARMEX MEDIDA 12-20-4', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:17', 5, 5);
INSERT INTO `materiales` VALUES (11234, 1, 'ACE-015', 'ARMEX MEDIDA 15-15-4', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:17', 5, 5);
INSERT INTO `materiales` VALUES (13840, 1, 'ACE-520', 'ARMEX MEDIDA 15-20-4', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:18', 5, 5);
INSERT INTO `materiales` VALUES (35707, 1, 'ACE-530', 'ARMEX MEDIDA 15-30-4', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:18', 5, 5);
INSERT INTO `materiales` VALUES (30723, 1, '1201-128-024', 'AROMATIZANTE EN AEROSOL', 803, 'EXTRAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:25', '2020-10-19 11:15:18', 5, 5);
INSERT INTO `materiales` VALUES (33522, 1, 'HER-300', 'AROS PARA ESCALAR FABRICADOS CON TUBO DE 3/4 CED 30 Y TUBO DE 1 CED 30.', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:18', 5, 5);
INSERT INTO `materiales` VALUES (12525, 1, 'O-157', 'ARRAYAN ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:18', 5, 5);
INSERT INTO `materiales` VALUES (23922, 1, 'AR-012', 'ARRENDAMIENTO', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:18', 5, 5);
INSERT INTO `materiales` VALUES (13672, 1, 'AR-010', 'ARTICULOS DE LIMPIEZA', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:18', 5, 5);
INSERT INTO `materiales` VALUES (35959, 1, 'AEF-152', 'ARTICULOS ESPECIALES EXTREMO FOFO 152mm 6\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:19', 5, 5);
INSERT INTO `materiales` VALUES (35947, 1, 'ARE-200', 'ARTICULOS ESPECIALES JUNTA DRESSER 6\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:19', 5, 5);
INSERT INTO `materiales` VALUES (19221, 1, 'AT/01', 'ASCESORIA TECNICAS / RET', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:19', 5, 5);
INSERT INTO `materiales` VALUES (13222, 1, '0-289', 'ASESIORIA DE MICROSIP', 808, 'OTROS', 'HORA', 'HORA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:19', 5, 5);
INSERT INTO `materiales` VALUES (10669, 1, 'O-006', 'ASESORIAS', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:19', 5, 5);
INSERT INTO `materiales` VALUES (13396, 1, '0-324', 'ASIENTO PARA SANITARIO T/ESTANDAR  COLOR BEIGE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:19', 5, 5);
INSERT INTO `materiales` VALUES (24723, 1, 'AN-101', 'ASIGNACION DE NUMEROS OFICIALES', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:26', '2020-10-19 11:15:19', 5, 5);
INSERT INTO `materiales` VALUES (23996, 1, '1', 'ASIMILADOS A SALARIOS', 794, 'ACABADOS', 'SERVICIO', 'SERVICIO', '1', 'COMISIONES', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:19', 5, 5);
INSERT INTO `materiales` VALUES (34912, 1, 'ASP-100', 'ASPERSOR 1804 4\"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:20', 5, 5);
INSERT INTO `materiales` VALUES (11655, 1, 'O-057', 'ASTRO BPL BLUSA C PINZA MANGA LARGA TALLA XL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:20', 5, 5);
INSERT INTO `materiales` VALUES (11651, 1, 'O-056', 'ASTRO BPL BLUSA C PINZAS MANGA LARGA TALLA MEDIANA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:20', 5, 5);
INSERT INTO `materiales` VALUES (11914, 1, 'O-087', 'ASTRO BPL BLUSA C/PINZA MANGA CORTA TALLA L', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:20', 5, 5);
INSERT INTO `materiales` VALUES (11635, 1, 'O-052', 'ASTRO BPL BLUSA CON PINZAS MANGA LARGA TALLA CHICA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:20', 5, 5);
INSERT INTO `materiales` VALUES (13870, 1, 'O-340', 'ASTRO CL CAMISA  MANGA LARGA CABALLERO EXTRACHICA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:20', 5, 5);
INSERT INTO `materiales` VALUES (18874, 1, 'ASCAMSXS-89', 'ASTRO CL CAMISA CAMISA S/ XS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:21', 5, 5);
INSERT INTO `materiales` VALUES (13096, 1, 'O-271', 'ASTRO CL CAMISA MANGA  LARGA  TALLA EXTRA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:21', 5, 5);
INSERT INTO `materiales` VALUES (13786, 1, 'O056', 'ASTRO CL CAMISA MANGA LARGA TALLA 4XL DAMA', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:21', 5, 5);
INSERT INTO `materiales` VALUES (11639, 1, 'O-053', 'ASTRO CL CAMISA MANGA LARGA TALLA CHICA DAMA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:27', '2020-10-19 11:15:21', 5, 5);
INSERT INTO `materiales` VALUES (11647, 1, 'O-055', 'ASTRO CL CAMISA MANGA LARGA TALLA GRANDE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:21', 5, 5);
INSERT INTO `materiales` VALUES (11643, 1, 'O-054', 'ASTRO CL CAMISA MANGA LARGA TALLA MEDIANA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:21', 5, 5);
INSERT INTO `materiales` VALUES (13654, 1, 'O059', 'ASTRO CL CAMISA MANGA LARGA TALLA XL DAMA', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:21', 5, 5);
INSERT INTO `materiales` VALUES (12801, 1, 'O-194', 'ASTRO CL CAMISA MANGA LARGA TALLA XS DAMA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:21', 5, 5);
INSERT INTO `materiales` VALUES (25888, 1, 'U-031', 'ATRAQUE DE CONCRETO SIMPLE FC: 100 KG/CM2', 806, 'URBANIZACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:22', 5, 5);
INSERT INTO `materiales` VALUES (23822, 1, '', 'AUTOMOVIL NISSAN 2018 BLANCO', 794, 'ACABADOS', 'ACTIVIDAD', '', '1', 'NUMERO DE SERIE: 3N1CK3CD8JL242176\r\nNo MOTOTR: HR16794151P\r\nTIPO: MARCH ACTIVE T/M AC', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:22', 5, 5);
INSERT INTO `materiales` VALUES (24447, 1, 'AT-001', 'AVALUO DE TERRENO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:22', 5, 5);
INSERT INTO `materiales` VALUES (11995, 1, 'O-094', 'AVALUOS', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:22', 5, 5);
INSERT INTO `materiales` VALUES (30990, 1, 'AZD-100', 'AZADON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:22', 5, 5);
INSERT INTO `materiales` VALUES (11160, 1, 'O-027', 'AZALEA GRANDE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:22', 5, 5);
INSERT INTO `materiales` VALUES (26037, 1, 'MO-108', 'AZOTEA ALBAÑILERIA', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:28', '2020-10-19 11:15:22', 5, 5);
INSERT INTO `materiales` VALUES (27234, 1, 'AZU-121', 'AZUCARERA RECTANGULAR 12X6', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:22', 5, 5);
INSERT INTO `materiales` VALUES (30121, 1, 'MV212', 'AZULEJO IMAN BLANCO DE 20.1X30.19 DE 1.52 m2 X CAJA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:23', 5, 5);
INSERT INTO `materiales` VALUES (31379, 1, 'ACE-154', 'Armex 15-15-4 Cerramientos', 787, 'CIMENTACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:23', 5, 5);
INSERT INTO `materiales` VALUES (15169, 1, 'MO2', 'B MATERIAL Y MANO DE OBRA', 15165, 'MATERIAL Y MANO DE OBRA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:23', 5, 5);
INSERT INTO `materiales` VALUES (12573, 1, 'O-169', 'BACHEO DE CARPETA ASFALTICA', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:23', 5, 5);
INSERT INTO `materiales` VALUES (25239, 1, 'BAS-120', 'BACHEO Y APLICACION DE SELLO EN ACCESO', 806, 'URBANIZACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:23', 5, 5);
INSERT INTO `materiales` VALUES (25503, 1, 'ELT-102', 'BAJA TENSION SUBTERRANEA', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:23', 5, 5);
INSERT INTO `materiales` VALUES (27119, 1, 'BL-104', 'BALA MEDIANA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:24', 5, 5);
INSERT INTO `materiales` VALUES (13480, 1, 'N1723', 'BALASTRO  T8 P/1 O 2LAMPARAS 17W', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:24', 5, 5);
INSERT INTO `materiales` VALUES (12052, 1, 'EU-032', 'BALASTRO MAGNETICO ADITIVO METALICO AFP 250W 127/220V', 785, 'ELECTRIFICACION URB', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:24', 5, 5);
INSERT INTO `materiales` VALUES (13810, 1, 'N1815', 'BALASTRO1 O 2 LAMPARA DE 32 W', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:24', 5, 5);
INSERT INTO `materiales` VALUES (27415, 1, 'BAN-146', 'BANCA DE MEZQUITE', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:29', '2020-10-19 11:15:25', 5, 5);
INSERT INTO `materiales` VALUES (29272, 1, 'BAN-100', 'BANCA METALICA', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:25', 5, 5);
INSERT INTO `materiales` VALUES (28027, 1, 'BAN-129', 'BANCO ALTO LUCINDA NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:25', 5, 5);
INSERT INTO `materiales` VALUES (29293, 1, 'BDC-100', 'BANCO DUKATI CON RESPALDO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:25', 5, 5);
INSERT INTO `materiales` VALUES (27385, 1, 'BAN-136', 'BANCOS CROSS C/REMACHE VINIL CAFE', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:25', 5, 5);
INSERT INTO `materiales` VALUES (27388, 1, 'BAN-137', 'BANCOS CROSS S/REMACHE VINIL NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:25', 5, 5);
INSERT INTO `materiales` VALUES (11546, 1, 'BA-01', 'BARANDAL PARA CERRADA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:25', 5, 5);
INSERT INTO `materiales` VALUES (10442, 1, 'HE-002', 'BARANDAL PARA ESCALERA ', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:25', 5, 5);
INSERT INTO `materiales` VALUES (34758, 1, 'BDP-100', 'BARDA ENTRADA PERIFERICO ( CURVA ) 21.5X3.00 mts', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:26', 5, 5);
INSERT INTO `materiales` VALUES (34755, 1, 'BEP-100', 'BARDA ENTRADA PERIFERICO 33X2.80 mts.', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:26', 5, 5);
INSERT INTO `materiales` VALUES (26047, 1, 'MO-111', 'BARDAS MEDIANERAS', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:26', 5, 5);
INSERT INTO `materiales` VALUES (30692, 1, 'BZC-100', 'BARNIZ MANCHA COLOR CHOCOLATE', 794, 'ACABADOS', 'LTO', 'LTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:26', 5, 5);
INSERT INTO `materiales` VALUES (33731, 1, 'BAR-300', 'BARRA GRANDE C10762', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:30', '2020-10-19 11:15:26', 5, 5);
INSERT INTO `materiales` VALUES (36936, 1, 'COA-200', 'BARRAS DE SEGURIDAD ( CONTROL DE ACCESO )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:31', '2020-10-19 11:15:26', 5, 5);
INSERT INTO `materiales` VALUES (33519, 1, 'HER-200', 'BARRAS HORIZONTALES FABRICADAS CON TUBO 111/2 CED 30.', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:31', '2020-10-19 11:15:26', 5, 5);
INSERT INTO `materiales` VALUES (13867, 1, '0-375', 'BASCULA ROMANA DE RESORTE 100 KG', 803, 'EXTRAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:31', '2020-10-19 11:15:26', 5, 5);
INSERT INTO `materiales` VALUES (24524, 1, 'U-007', 'BASE CON 60%  BASE INDUSTRIAL DE 1 1/2\" A FINOS Y 40% CALICHE CRIBADO EN UNA CAPA DE 20 CM DE ESPESOR PROMEDIO. INCLUYE: SUMINISTRO DE MATERIAL, HUMECTACION, MEZCLADO, TENDIDO Y COMPACTADO AL 95% DE S', 806, 'URBANIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:31', '2020-10-19 11:15:27', 5, 5);
INSERT INTO `materiales` VALUES (27406, 1, 'BSC-144', 'BASE DE CACTUS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:31', '2020-10-19 11:15:27', 5, 5);
INSERT INTO `materiales` VALUES (27199, 1, 'BSH-120', 'BASE DE HERRERIA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:31', '2020-10-19 11:15:27', 5, 5);
INSERT INTO `materiales` VALUES (13483, 1, '1K-ALPLT8D', 'BASE G13 T8 SIN PUENTERA DESLIZABLE PERFIL BAJO MEDIA  600V ALCO', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:31', '2020-10-19 11:15:27', 5, 5);
INSERT INTO `materiales` VALUES (25530, 1, 'U-011', 'BASE INDUSTRIAL DE 1 1/2\" A FINOS EN UNA CAPA DE 20CM DE ESPESOR PROMEDIO. INCLUYE: SUMINISTRO DE MATERIAL HUMECTACION, MEZCLADO, TENDIDO Y COMPACTADO AL 95% DE SU PVSM', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:31', '2020-10-19 11:15:27', 5, 5);
INSERT INTO `materiales` VALUES (10218, 1, 'E-024', 'BASE MEDIDOR 4X100 IUSA', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:31', '2020-10-19 11:15:27', 5, 5);
INSERT INTO `materiales` VALUES (10390, 1, 'EU-017', 'BASE PIRAMIDAL 35X68X62  PARA ARBOTANTE', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:31', '2020-10-19 11:15:27', 5, 5);
INSERT INTO `materiales` VALUES (12420, 1, 'PUBLI-007', 'BASTIDOR', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:27', 5, 5);
INSERT INTO `materiales` VALUES (34752, 1, 'BST-100', 'BASTIDORES DE 4X2', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:28', 5, 5);
INSERT INTO `materiales` VALUES (31669, 1, 'BAS-100', 'BASTON DE LAMINA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:28', 5, 5);
INSERT INTO `materiales` VALUES (33289, 1, 'BAS-200', 'BASTON DE LAMINA 1.20 MTS AZUL', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:28', 5, 5);
INSERT INTO `materiales` VALUES (13447, 1, '0-339', 'BATA PARA LIMPIEZA AZUL MARINO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:28', 5, 5);
INSERT INTO `materiales` VALUES (24210, 1, 'BT-LTH', 'BATERIA 47-550  LTH', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:28', 5, 5);
INSERT INTO `materiales` VALUES (12254, 1, 'O-118', 'BIGA DE MADERA DE 1 1/2\" X 15CM X 4.90MTS DE SEGUNDA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:28', 5, 5);
INSERT INTO `materiales` VALUES (34496, 1, '', 'BIOLIM LIMPIA SARRO 4 LTS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:28', 5, 5);
INSERT INTO `materiales` VALUES (11905, 1, 'O-81', 'BISAGRA 3.5 X 3.5 CROMO MATE CAB REDONDA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:29', 5, 5);
INSERT INTO `materiales` VALUES (12411, 1, 'O-146', 'BITACORA DE OBRA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:29', 5, 5);
INSERT INTO `materiales` VALUES (20256, 1, 'B-007', 'BLOCK 20X20X40', 814, 'BLOCK', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:29', 5, 5);
INSERT INTO `materiales` VALUES (12333, 1, 'B-006', 'BLOCK CELOSIA CUADRO GRANDE 10x30x30 COLOR', 814, 'BLOCK', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:32', '2020-10-19 11:15:29', 5, 5);
INSERT INTO `materiales` VALUES (9954, 1, 'B-002', 'BLOCK MEDIDA 10X20X40', 814, 'BLOCK', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:29', 5, 5);
INSERT INTO `materiales` VALUES (9950, 1, 'B-001', 'BLOCK MEDIDA 12X20X40', 814, 'BLOCK', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:29', 5, 5);
INSERT INTO `materiales` VALUES (10554, 1, 'B-004', 'BLOCK MEDIDA 15X20X40', 814, 'BLOCK', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:29', 5, 5);
INSERT INTO `materiales` VALUES (34522, 1, 'BCH-100', 'BLOCK PLIZA DE CHEQUE 1/2 OFI C/CARBON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:29', 5, 5);
INSERT INTO `materiales` VALUES (9958, 1, 'B-003', 'BLOCK TIPO U MEDIDA 12X20X40', 814, 'BLOCK', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:30', 5, 5);
INSERT INTO `materiales` VALUES (10582, 1, 'B-005', 'BLOCK TIPO U MEDIDA 15X20X40', 789, 'PRIMER NIVEL', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:30', 5, 5);
INSERT INTO `materiales` VALUES (26028, 1, 'MO-105', 'BLOQUERO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:30', 5, 5);
INSERT INTO `materiales` VALUES (10629, 1, 'O-005', 'BOCINA- BAFLE AMP 12 2500 W SD/USB SALIDA P/BAFLE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:30', 5, 5);
INSERT INTO `materiales` VALUES (35386, 1, 'BOB-100', 'BOLIGRAFO BIC M-250', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:30', 5, 5);
INSERT INTO `materiales` VALUES (33361, 1, 'BOL-150', 'BOLSA BLANCA CON SERIGRAFIA DE VIVIEND', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:30', 5, 5);
INSERT INTO `materiales` VALUES (33510, 1, 'BOL-250', 'BOLSA CIMBOA IMPRESA', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:30', 5, 5);
INSERT INTO `materiales` VALUES (13159, 1, '0-273', 'BOLSA DE CELOFAN  EXTRA GRANDE COD.354092', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:33', '2020-10-19 11:15:30', 5, 5);
INSERT INTO `materiales` VALUES (13162, 1, '0-274', 'BOLSA DE MOÑOS AMARILLOS GDE', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:34', '2020-10-19 11:15:31', 5, 5);
INSERT INTO `materiales` VALUES (31774, 1, 'BOL-120', 'BOLSA NEGRA PARA BASURA', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:34', '2020-10-19 11:15:31', 5, 5);
INSERT INTO `materiales` VALUES (33587, 1, 'BKF-100', 'BOLSAS KRAFT REGALO IMPRESA EN SERIGRAFIA', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:34', '2020-10-19 11:15:31', 5, 5);
INSERT INTO `materiales` VALUES (35535, 1, 'BMB-020', 'BOMBA CENTRIFUGA MCA EVANS 2 HP', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:34', '2020-10-19 11:15:31', 5, 5);
INSERT INTO `materiales` VALUES (11593, 1, 'H-070', 'BOMBA CON SALIDA DE 1/2', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:34', '2020-10-19 11:15:31', 5, 5);
INSERT INTO `materiales` VALUES (13279, 1, '0-302', 'BOMBA DE VACIO  1/4 HP', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:34', '2020-10-19 11:15:31', 5, 5);
INSERT INTO `materiales` VALUES (34429, 1, 'BOM-150', 'BOMBA P/INFLAR NEUMATICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:34', '2020-10-19 11:15:31', 5, 5);
INSERT INTO `materiales` VALUES (34915, 1, 'BOQ-10V', 'BOQUILLA AJSUTABLE 10 VAN', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:35', '2020-10-19 11:15:32', 5, 5);
INSERT INTO `materiales` VALUES (35565, 1, 'BOQ-15V', 'BOQUILLA AJSUTABLE 15 VAN', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:35', '2020-10-19 11:15:32', 5, 5);
INSERT INTO `materiales` VALUES (13282, 1, '0-303', 'BOQUILLA CON PERILLA DE BRONVE Y AUTOENCEDIDO ELECTRONICO TURNER', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:35', '2020-10-19 11:15:32', 5, 5);
INSERT INTO `materiales` VALUES (10618, 1, 'P-009', 'BOQUILLA SELLADOR INT OYSTER GRAY SACO 10K', 795, 'PISOS', 'SACO', 'SACO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:35', '2020-10-19 11:15:32', 5, 5);
INSERT INTO `materiales` VALUES (33900, 1, 'BOA-100', 'BOQUILLA SIN ARENA BLANCA', 794, 'ACABADOS', 'SACO', 'SACO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:35', '2020-10-19 11:15:32', 5, 5);
INSERT INTO `materiales` VALUES (10912, 1, 'P-019', 'BOQUILLA SIN ARENA CHOCOLAT SACO 5KG', 795, 'PISOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:35', '2020-10-19 11:15:32', 5, 5);
INSERT INTO `materiales` VALUES (12083, 1, 'A-032', 'BOQUILLA SIN ARENA GRAY SACO 5 KGS', 794, 'ACABADOS', 'SACO', 'SACO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:35', '2020-10-19 11:15:32', 5, 5);
INSERT INTO `materiales` VALUES (10916, 1, 'P-020', 'BOQUILLA SIN ARENA WHITE PEARL SACO 5KG', 795, 'PISOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:35', '2020-10-19 11:15:33', 5, 5);
INSERT INTO `materiales` VALUES (12711, 1, 'O-189', 'BORDADOS E IMPRESIONES', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:35', '2020-10-19 11:15:33', 5, 5);
INSERT INTO `materiales` VALUES (27483, 1, 'BPJ-174', 'BORDE PARA JARDIN', 794, 'ACABADOS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:35', '2020-10-19 11:15:33', 5, 5);
INSERT INTO `materiales` VALUES (33869, 1, 'BOT-158', 'BOTA TACTICA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:33', 5, 5);
INSERT INTO `materiales` VALUES (12241, 1, 'O-114', 'BOTAGUAS EN BODEGA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:33', 5, 5);
INSERT INTO `materiales` VALUES (31620, 1, 'BOT-100', 'BOTAS C/CASCO ELECTRICO ( USO RUDO )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:33', 5, 5);
INSERT INTO `materiales` VALUES (13153, 1, 'E-075', 'BOTE P/SPOT  COIMBRA  H-600/ACI', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:33', 5, 5);
INSERT INTO `materiales` VALUES (10749, 1, 'E-042', 'BOTE PARA SPOT 4 1/2', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:34', 5, 5);
INSERT INTO `materiales` VALUES (11132, 1, 'E-053', 'BOTON TIMBRE BTICINO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:34', 5, 5);
INSERT INTO `materiales` VALUES (10194, 1, 'E-018', 'BOTON TIMBRE MARCA SCUDETTO COLOR  BLANCO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:34', 5, 5);
INSERT INTO `materiales` VALUES (27243, 1, 'BOW-124', 'BOWL ABIERTO ESPECIAL 17X4.5', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:34', 5, 5);
INSERT INTO `materiales` VALUES (27269, 1, 'BOW-132', 'BOWL EXTENDIDO CONO 25X5.5 CMS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:34', 5, 5);
INSERT INTO `materiales` VALUES (10386, 1, 'EU-016', 'BRAZO DE 2\"X1.80 PARA LUMINARIA', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:34', 5, 5);
INSERT INTO `materiales` VALUES (13903, 1, 'O-347', 'BROCHA  CHICA NUM 4', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:36', '2020-10-19 11:15:34', 5, 5);
INSERT INTO `materiales` VALUES (12447, 1, 'A-078', 'BROCHA 1\" ', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:35', 5, 5);
INSERT INTO `materiales` VALUES (11831, 1, 'A-070', 'BROCHA 2\"', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:35', 5, 5);
INSERT INTO `materiales` VALUES (11827, 1, 'A-069', 'BROCHA 3\"', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:35', 5, 5);
INSERT INTO `materiales` VALUES (12444, 1, 'A-77', 'BROCHA DE 0.5\" ', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:35', 5, 5);
INSERT INTO `materiales` VALUES (19590, 1, 'BRO-17', 'BROCHA IXTLE', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:36', 5, 5);
INSERT INTO `materiales` VALUES (9842, 1, 'A-016', 'BROCHA MED. 6\"', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:36', 5, 5);
INSERT INTO `materiales` VALUES (12537, 1, 'O-160', 'BROCHE BACO NO 8', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:36', 5, 5);
INSERT INTO `materiales` VALUES (33892, 1, 'BUG-100', 'BUGAMBILIAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:36', 5, 5);
INSERT INTO `materiales` VALUES (27122, 1, 'BUL-105', 'BULE CHICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:36', 5, 5);
INSERT INTO `materiales` VALUES (27952, 1, 'BUR-104', 'BURO EVO ENCINO NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:36', 5, 5);
INSERT INTO `materiales` VALUES (28006, 1, 'LAM-122', 'BURO YAAX NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:37', '2020-10-19 11:15:36', 5, 5);
INSERT INTO `materiales` VALUES (11136, 1, 'O-022', 'BURRITO MULTIUSOS 29', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:37', 5, 5);
INSERT INTO `materiales` VALUES (25040, 1, 'BC-149', 'Buró Cobá - Azul', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:37', 5, 5);
INSERT INTO `materiales` VALUES (24926, 1, 'BN-112', 'Buró Nahil - Negro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:37', 5, 5);
INSERT INTO `materiales` VALUES (25025, 1, 'BSD-144', 'Buró Santo Domingo - Blanco', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:37', 5, 5);
INSERT INTO `materiales` VALUES (15166, 1, 'MO1', 'C MATERIAL Y MANO DE OBRA', 15165, 'MATERIAL Y MANO DE OBRA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:37', 5, 5);
INSERT INTO `materiales` VALUES (33811, 1, 'CAB-100', 'CABINA SANITIZANTE INC MATERIAL', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:37', 5, 5);
INSERT INTO `materiales` VALUES (13114, 1, 'E-073', 'CABLE  CALIBRE 6 DE 3 HILOS', 791, 'ELECTRIFICACION', 'MTO', 'MTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:37', 5, 5);
INSERT INTO `materiales` VALUES (12462, 1, 'E-068', 'CABLE CAL. 6 SUBTERRANEO 2 HILOS', 791, 'ELECTRIFICACION', 'M.L.', 'M.L.', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:37', 5, 5);
INSERT INTO `materiales` VALUES (13609, 1, 'E-090', 'CABLE DE ALUMINIO CALIBRE N 6 2X1', 794, 'ACABADOS', 'MTS', 'MTS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:38', 5, 5);
INSERT INTO `materiales` VALUES (10426, 1, 'EU-026', 'CABLE DE COBRE THW DESNUDO CALIBRE 1/0', 785, 'ELECTRIFICACION URB', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:38', 5, 5);
INSERT INTO `materiales` VALUES (13246, 1, 'E-079', 'CABLE DE USO RUDO  2X12 ', 791, 'ELECTRIFICACION', 'MTS', 'MTS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:38', 5, 5);
INSERT INTO `materiales` VALUES (13792, 1, 'CG-012', 'CABLE GALVANIZADO #12 PARA GUIA', 794, 'ACABADOS', 'KG', 'KG', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:38', '2020-10-19 11:15:38', 5, 5);
INSERT INTO `materiales` VALUES (12852, 1, 'O-205', 'CABLE HDMI', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:38', 5, 5);
INSERT INTO `materiales` VALUES (13198, 1, '0-283', 'CABLE IMPRESORA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:38', 5, 5);
INSERT INTO `materiales` VALUES (11589, 1, 'E-065', 'CABLE PRS 1+1 CALIBRE 6', 791, 'ELECTRIFICACION', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:38', 5, 5);
INSERT INTO `materiales` VALUES (10166, 1, 'E-011', 'CABLE THW 08\"  MARCA IUSA', 791, 'ELECTRIFICACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:39', 5, 5);
INSERT INTO `materiales` VALUES (10150, 1, 'E-007', 'CABLE THW 10\"  MARCA IUSA', 791, 'ELECTRIFICACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:39', 5, 5);
INSERT INTO `materiales` VALUES (10154, 1, 'E-008', 'CABLE THW 12\"  MARCA IUSA', 791, 'ELECTRIFICACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:39', 5, 5);
INSERT INTO `materiales` VALUES (10158, 1, 'E-009', 'CABLE THW 14\"  MARCA IUSA', 791, 'ELECTRIFICACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:39', 5, 5);
INSERT INTO `materiales` VALUES (10162, 1, 'E-010', 'CABLE THW 16\"  MARCA IUSA', 791, 'ELECTRIFICACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:39', 5, 5);
INSERT INTO `materiales` VALUES (35586, 1, 'E-118', 'CABLE THW 18\"  MARCA IUSA', 791, 'ELECTRIFICACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:39', 5, 5);
INSERT INTO `materiales` VALUES (12982, 1, 'O-251', 'CABLE VGA 2MTS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:39', 5, 5);
INSERT INTO `materiales` VALUES (11222, 1, 'E-056', 'CABLE XLP CALIBRE 6', 791, 'ELECTRIFICACION', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:39', '2020-10-19 11:15:39', 5, 5);
INSERT INTO `materiales` VALUES (11586, 1, 'E-060', 'CABLE XLP CALIBRE 6 PRS 2+1 ', 791, 'ELECTRIFICACION', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:40', 5, 5);
INSERT INTO `materiales` VALUES (27430, 1, 'CAC-150', 'CACTUS DE 3 A 3.5 MTS DE ALTURA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:40', 5, 5);
INSERT INTO `materiales` VALUES (13813, 1, 'E-1218', 'CADENA ', 791, 'ELECTRIFICACION', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:40', 5, 5);
INSERT INTO `materiales` VALUES (19651, 1, '', 'CADENA 3/8', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:40', 5, 5);
INSERT INTO `materiales` VALUES (13420, 1, '0-330', 'CAJA ARCHIVO OFICIO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:40', 5, 5);
INSERT INTO `materiales` VALUES (34949, 1, 'REG-600', 'CAJA DE REGISTRO DE 6\" PVB6RND RAINBIRD', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:40', 5, 5);
INSERT INTO `materiales` VALUES (13228, 1, '0-291', 'CAJA FUERTE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:40', 5, 5);
INSERT INTO `materiales` VALUES (13432, 1, '0-334', 'CAJA PAPEL CTA C/5000', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:41', 5, 5);
INSERT INTO `materiales` VALUES (10074, 1, 'C-010', 'CAL BULTO DE 25 KG.', 810, 'CONCRETOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:41', 5, 5);
INSERT INTO `materiales` VALUES (27137, 1, 'CAB-109', 'CALABERA - BRUJA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:41', 5, 5);
INSERT INTO `materiales` VALUES (12753, 1, 'CS-013', 'CALAIS A:110 CM VINIPIEL CREMA BRILLOSO', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:40', '2020-10-19 11:15:41', 5, 5);
INSERT INTO `materiales` VALUES (12756, 1, 'CS-014', 'CALAIS A:110 CM VINIPIEL ESPRESSO BRILLOSO', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:41', 5, 5);
INSERT INTO `materiales` VALUES (10757, 1, 'O-008', 'CALAS VOLUMETRICAS', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:41', 5, 5);
INSERT INTO `materiales` VALUES (35915, 1, 'CAL-100', 'CALCULADORA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:41', 5, 5);
INSERT INTO `materiales` VALUES (9602, 1, 'ADM-002', 'CALCULO ESTRUCTURAL', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:41', 5, 5);
INSERT INTO `materiales` VALUES (12095, 1, 'O-107', 'CALCULO Y ELABORACION DE PLANOS PARA VIVIENDA', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:42', 5, 5);
INSERT INTO `materiales` VALUES (11028, 1, 'O-019', 'CALENTADOR AUTOMATICO 132 LTS G40 LP CALOREX', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:42', 5, 5);
INSERT INTO `materiales` VALUES (10102, 1, 'T-007', 'CALENTADOR DE PASO MARCA OPTIMUS 5L', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:42', 5, 5);
INSERT INTO `materiales` VALUES (13123, 1, 'T-025', 'CALENTADOR SOLAR  REDUGAX 150 LITROS', 801, 'ECOTECNOLOGIAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:42', 5, 5);
INSERT INTO `materiales` VALUES (11911, 1, 'O-086', 'CALICHE', 808, 'OTROS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:42', 5, 5);
INSERT INTO `materiales` VALUES (27994, 1, 'CAM-118', 'CAMA MATRIMONIAL NAHIL NATURAL', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:42', 5, 5);
INSERT INTO `materiales` VALUES (28015, 1, 'CAM-125', 'CAMARA INDIVIDUAL KLIT GRIS CLARO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:43', 5, 5);
INSERT INTO `materiales` VALUES (11762, 1, 'O-066', 'CAMARA LLANTA P/ CARRETILLA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:41', '2020-10-19 11:15:43', 5, 5);
INSERT INTO `materiales` VALUES (28012, 1, 'CAM-124', 'CAMARA MATRIMONIAL YAAX NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:43', 5, 5);
INSERT INTO `materiales` VALUES (27627, 1, 'CPT-185', 'CAMBIO DE PILA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:43', 5, 5);
INSERT INTO `materiales` VALUES (22282, 1, '', 'CAMIONETA SIENNA XLE LTD MINI-VAN 6AT V6 MOB 2017 SERIE 5TDYZ3DC5HS767107 EN LAS CONDICIONES QUE SE ENCUENTRE', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:43', 5, 5);
INSERT INTO `materiales` VALUES (33496, 1, 'CAM-100', 'CAMISA DE MEZCLILLA ( VARIAS TALLAS )', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:43', 5, 5);
INSERT INTO `materiales` VALUES (11472, 1, 'O-039', 'CAMISA OXFORD PARA CABALLERO MANGA CORTA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:43', 5, 5);
INSERT INTO `materiales` VALUES (33872, 1, 'CAM-174', 'CAMISA TACTICA TIPO POLO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:44', 5, 5);
INSERT INTO `materiales` VALUES (11428, 1, 'O-037', 'CAMISAS DE BEISBOL Y GORRA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:44', 5, 5);
INSERT INTO `materiales` VALUES (33667, 1, 'CAM-830', 'CAMPANA MABE DE 50\" COLOR NEGRO ( SKU 31830 )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:44', 5, 5);
INSERT INTO `materiales` VALUES (33670, 1, 'CAM-409', 'CAMPANA MABE DE 76cm COLOR NEGRO ( SKU 27409 )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:44', 5, 5);
INSERT INTO `materiales` VALUES (33673, 1, 'CAM-539', 'CAMPANA MABE DE 80cm SILVER ( SKU 55539 )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:44', 5, 5);
INSERT INTO `materiales` VALUES (13474, 1, '1K-GCNA232', 'CANAL 2X32W ALCO', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:44', 5, 5);
INSERT INTO `materiales` VALUES (12946, 1, 'ACE-025', 'CANALETA 3/4 DE 3MTS', 809, 'ACERO', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:42', '2020-10-19 11:15:45', 5, 5);
INSERT INTO `materiales` VALUES (10824, 1, 'ACE-020', 'CANALETA 3MTS CAL.22 3/4 PLAFONERA', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:43', '2020-10-19 11:15:45', 5, 5);
INSERT INTO `materiales` VALUES (9938, 1, 'ACE-012', 'CANALETA DE 1/2\" TRAMO DE 3 MTS.', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:43', '2020-10-19 11:15:45', 5, 5);
INSERT INTO `materiales` VALUES (31995, 1, 'TEM-G6', 'CANCEL Med. 1.20 x 2.08, Aluminio G2 Perfil 1 1/2¨. Cristal 3 mm.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:43', '2020-10-19 11:15:45', 5, 5);
INSERT INTO `materiales` VALUES (31358, 1, 'CG2-206', 'CANCEL Med. 1.20 x 2.09, Aluminio G2 SIN PROTECCIONES Perfil 1 1/2¨. Cristal 3 mm.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:43', '2020-10-19 11:15:46', 5, 5);
INSERT INTO `materiales` VALUES (26622, 1, 'CG2-06', 'CANCEL Med. 1.49 x 2.08, Aluminio G2 SIN PROTECCIONES Perfil 1 1/2¨. Cristal 3 mm.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:43', '2020-10-19 11:15:46', 5, 5);
INSERT INTO `materiales` VALUES (31920, 1, 'VEN-7', 'CANCEL Med. 1.50 x 2.08 Aluminio G2 Perfil 1 1/2¨. Cristal 3 mm.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:43', '2020-10-19 11:15:46', 5, 5);
INSERT INTO `materiales` VALUES (32033, 1, 'MES-6', 'CANCEL Med. 1.50 x 2.08, Aluminio G2  Perfil 1 1/2¨. Cristal 3 mm.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:43', '2020-10-19 11:15:46', 5, 5);
INSERT INTO `materiales` VALUES (30503, 1, 'CG2-106', 'CANCEL Med. 1.55 x 2.08, Aluminio G2 SIN PROTECCIONES Perfil 1 1/2¨. Cristal 3 mm.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:43', '2020-10-19 11:15:46', 5, 5);
INSERT INTO `materiales` VALUES (33326, 1, 'CON-5', 'CANCEL Med. 1.55 x 2.08, Aluminio G2 SIN PROTECCIONES Perfil 1 1/2¨. Cristal 3 mm. CON', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:43', '2020-10-19 11:15:47', 5, 5);
INSERT INTO `materiales` VALUES (19653, 1, 'CAND-85', 'CANDADOS', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:47', 5, 5);
INSERT INTO `materiales` VALUES (37152, 1, 'TE-ACC-CANDE18', 'CANDELABRO ALANEA MARMOL Y CRISTAL 18977', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:47', 5, 5);
INSERT INTO `materiales` VALUES (27172, 1, 'CAN-112', 'CANDIL CUADRADO NEGRO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:47', 5, 5);
INSERT INTO `materiales` VALUES (27409, 1, 'CND-145', 'CANDIL CUERNOS DE VENADO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:47', 5, 5);
INSERT INTO `materiales` VALUES (12750, 1, 'CS-012', 'CANES 4P A:76 L:100 F:100 CM CUBIERTA MARMOL', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:47', 5, 5);
INSERT INTO `materiales` VALUES (13516, 1, '01-CAN', 'CANTERA MODERNA BLANCA TINAJERA ', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:48', 5, 5);
INSERT INTO `materiales` VALUES (13042, 1, 'O-270', 'CAPUCHA MARCO 2\" X 1 5/8\"', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:48', 5, 5);
INSERT INTO `materiales` VALUES (24472, 1, 'MP-104', 'CARBON ACTIVADO', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:48', 5, 5);
INSERT INTO `materiales` VALUES (33091, 1, 'CAR-B10', 'CARDIAL B-10', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:48', 5, 5);
INSERT INTO `materiales` VALUES (9790, 1, 'A-003', 'CARGA SACO DE 20KG', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:48', 5, 5);
INSERT INTO `materiales` VALUES (34557, 1, 'CDP-100', 'CARGADOR DE CORRIENTE ( P/ LAPTOP )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:48', 5, 5);
INSERT INTO `materiales` VALUES (12627, 1, 'O-170', 'CARP PANORAMICA 362 O 2 BCA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:49', 5, 5);
INSERT INTO `materiales` VALUES (12630, 1, 'O-171', 'CARP PANORAMICA 386 D 1.5 BC', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:44', '2020-10-19 11:15:49', 5, 5);
INSERT INTO `materiales` VALUES (12356, 1, 'O-139', 'CARP VINIL 285 2 D BLANCA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:45', '2020-10-19 11:15:49', 5, 5);
INSERT INTO `materiales` VALUES (13303, 1, '0-310', 'CARPETA AMARILLAS CARTA C/50', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:45', '2020-10-19 11:15:49', 5, 5);
INSERT INTO `materiales` VALUES (13105, 1, '0-215', 'CARPETA BLANCA  2 PULGADAS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:45', '2020-10-19 11:15:49', 5, 5);
INSERT INTO `materiales` VALUES (13309, 1, '0-313', 'CARPETA OFICIO AMARILLA C/100', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:45', '2020-10-19 11:15:49', 5, 5);
INSERT INTO `materiales` VALUES (12813, 1, 'O-196', 'CARPETA PLASTICA 3 AROS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:45', '2020-10-19 11:15:49', 5, 5);
INSERT INTO `materiales` VALUES (35719, 1, 'O-296', 'CARPETA PLASTICA 3 AROS DE 5 \"', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:45', '2020-10-19 11:15:49', 5, 5);
INSERT INTO `materiales` VALUES (12696, 1, 'O-184', 'CARPETA ROJA TAMAÑO CARTA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:46', '2020-10-19 11:15:50', 5, 5);
INSERT INTO `materiales` VALUES (12804, 1, 'O-195', 'CARPETAS CON LOGOTIPO SALI', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:46', '2020-10-19 11:15:50', 5, 5);
INSERT INTO `materiales` VALUES (26034, 1, 'MO-107', 'CARPINTERO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:46', '2020-10-19 11:15:50', 5, 5);
INSERT INTO `materiales` VALUES (19645, 1, '', 'CARRETILLA', 809, 'ACERO', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:46', '2020-10-19 11:15:50', 5, 5);
INSERT INTO `materiales` VALUES (25669, 1, 'CNA-105', 'CARTA DE NO ADEUDO Y EDO. DE CUENTA', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:46', '2020-10-19 11:15:50', 5, 5);
INSERT INTO `materiales` VALUES (12979, 1, 'O146', 'CARTA RESPONSIVA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:46', '2020-10-19 11:15:50', 5, 5);
INSERT INTO `materiales` VALUES (12293, 1, 'O-131', 'CARTAS NO ADEUDO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:46', '2020-10-19 11:15:50', 5, 5);
INSERT INTO `materiales` VALUES (32216, 1, 'CBR-100', 'CARTUCHO BROTHER COMPATIBLE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:46', '2020-10-19 11:15:51', 5, 5);
INSERT INTO `materiales` VALUES (32223, 1, 'CAR-200', 'CARTUCHO HP 664 BLACK', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:46', '2020-10-19 11:15:51', 5, 5);
INSERT INTO `materiales` VALUES (13255, 1, '0-295', 'CARTUCHO HP 711 NEGRO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:46', '2020-10-19 11:15:51', 5, 5);
INSERT INTO `materiales` VALUES (32235, 1, 'CAR-204', 'CARTUCHO HP 954  CIAN', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:51', 5, 5);
INSERT INTO `materiales` VALUES (32232, 1, 'CAR-203', 'CARTUCHO HP 954 AMARILLO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:51', 5, 5);
INSERT INTO `materiales` VALUES (32238, 1, 'CAR-205', 'CARTUCHO HP 954 MAGENTA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:51', 5, 5);
INSERT INTO `materiales` VALUES (32229, 1, 'CAR-954', 'CARTUCHO HP 954 NEGRO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:51', 5, 5);
INSERT INTO `materiales` VALUES (32213, 1, 'CHP-', 'CARTUCHO HP COMPATIBLE 05X80', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:52', 5, 5);
INSERT INTO `materiales` VALUES (32226, 1, 'CAR-202', 'CARTUCHO P 664 COLOR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:52', 5, 5);
INSERT INTO `materiales` VALUES (21407, 1, 'CASA1', 'CASA HABITACION', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:52', 5, 5);
INSERT INTO `materiales` VALUES (13168, 1, '0-276', 'CASCARA DE HUEVO', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:52', 5, 5);
INSERT INTO `materiales` VALUES (13165, 1, '0-275', 'CASCARON DE HUEVO', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:52', 5, 5);
INSERT INTO `materiales` VALUES (11278, 1, 'POL-022', 'CASETON  MEDIDA .46X.60 ESPESOR DE 7CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:52', 5, 5);
INSERT INTO `materiales` VALUES (12145, 1, 'POL-032', 'CASETON .16X .60 ESPESOR DE 12 CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:47', '2020-10-19 11:15:53', 5, 5);
INSERT INTO `materiales` VALUES (12137, 1, 'POL-030', 'CASETON .25 X .60 ESPESOR DE 12 CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:48', '2020-10-19 11:15:53', 5, 5);
INSERT INTO `materiales` VALUES (12141, 1, 'POL-031', 'CASETON .26 X .50 ESPESOR DE 12 CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:48', '2020-10-19 11:15:53', 5, 5);
INSERT INTO `materiales` VALUES (12157, 1, 'POL-035', 'CASETON .48 X .60 ESPESOR DE 10 CM DENSIDAD DE 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:48', '2020-10-19 11:15:53', 5, 5);
INSERT INTO `materiales` VALUES (12177, 1, 'POL-040', 'CASETON .50 X .23 ESPESOR DE 10 CM DENSIDAD DE 10', 812, 'POLIESTIRENO', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:48', '2020-10-19 11:15:53', 5, 5);
INSERT INTO `materiales` VALUES (12133, 1, 'POL-029', 'CASETON .50 X .52 ESPESOR DE 12 CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:48', '2020-10-19 11:15:53', 5, 5);
INSERT INTO `materiales` VALUES (12165, 1, 'POL-037', 'CASETON .50 X .54 ESPESOR DE 10 CM DENSIDAD DE 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:48', '2020-10-19 11:15:53', 5, 5);
INSERT INTO `materiales` VALUES (12153, 1, 'POL-034', 'CASETON .50 X .60 ESPESOR DE 10 CM DENSIDAD DE 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:48', '2020-10-19 11:15:53', 5, 5);
INSERT INTO `materiales` VALUES (12173, 1, 'POL-039', 'CASETON .54 X .20 ESPESOR DE 10 CM DENSIDAD DE 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:48', '2020-10-19 11:15:54', 5, 5);
INSERT INTO `materiales` VALUES (12169, 1, 'POL-038', 'CASETON .60 X .20 ESPESOR DE 10 CM DENSIDAD DE 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:48', '2020-10-19 11:15:54', 5, 5);
INSERT INTO `materiales` VALUES (12161, 1, 'POL-036', 'CASETON .60 X .28 ESPESOR DE 10 CM DENSIDAD DE 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:49', '2020-10-19 11:15:54', 5, 5);
INSERT INTO `materiales` VALUES (12125, 1, 'POL-027', 'CASETON .60 X .45 ESPESOR DE 12 CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:49', '2020-10-19 11:15:54', 5, 5);
INSERT INTO `materiales` VALUES (12129, 1, 'POL-028', 'CASETON .60 X .48 ESPESOR DE 12 CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:49', '2020-10-19 11:15:54', 5, 5);
INSERT INTO `materiales` VALUES (12149, 1, 'POL-033', 'CASETON .60 X.27 ESPESOR DE 12 CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:49', '2020-10-19 11:15:54', 5, 5);
INSERT INTO `materiales` VALUES (11258, 1, 'POL-017', 'CASETON MEDIDA  .22X.50 ESPESOR DE .12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:49', '2020-10-19 11:15:55', 5, 5);
INSERT INTO `materiales` VALUES (11266, 1, 'POL-019', 'CASETON MEDIDA .16X.50 ESPESOR DE .12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:49', '2020-10-19 11:15:55', 5, 5);
INSERT INTO `materiales` VALUES (11262, 1, 'POL-018', 'CASETON MEDIDA .28X.50 ESPESOR DE .12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:49', '2020-10-19 11:15:55', 5, 5);
INSERT INTO `materiales` VALUES (11246, 1, 'POL-014', 'CASETON MEDIDA .32X.50 ESPESOR DE .12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:50', '2020-10-19 11:15:55', 5, 5);
INSERT INTO `materiales` VALUES (10282, 1, 'POL-006', 'CASETON MEDIDA .34X.60 ESPESOR DE 10 DENSIDAD 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:50', '2020-10-19 11:15:55', 5, 5);
INSERT INTO `materiales` VALUES (10596, 1, 'POL-011', 'CASETON MEDIDA .34X.60 ESPESOR DE 12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:50', '2020-10-19 11:15:55', 5, 5);
INSERT INTO `materiales` VALUES (11250, 1, 'POL-015', 'CASETON MEDIDA .49X.50 ESPESOR DE .12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:50', '2020-10-19 11:15:55', 5, 5);
INSERT INTO `materiales` VALUES (10278, 1, 'POL-005', 'CASETON MEDIDA .50X.50 ESPESOR DE 10 DENSIDAD 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:50', '2020-10-19 11:15:55', 5, 5);
INSERT INTO `materiales` VALUES (10593, 1, 'POL-010', 'CASETON MEDIDA .50X.50 ESPESOR DE 12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:50', '2020-10-19 11:15:56', 5, 5);
INSERT INTO `materiales` VALUES (12663, 1, 'POL-043', 'CASETON MEDIDA .50X.57 ESPESOR DE 10 DENSIDAD DE 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:50', '2020-10-19 11:15:56', 5, 5);
INSERT INTO `materiales` VALUES (11274, 1, 'POL-021', 'CASETON MEDIDA .50X.60 ESPESOR DE 7CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:50', '2020-10-19 11:15:56', 5, 5);
INSERT INTO `materiales` VALUES (26597, 1, 'POL-045', 'CASETON MEDIDA .60 X .50 ESPESOR DE 07 CM', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:51', '2020-10-19 11:15:56', 5, 5);
INSERT INTO `materiales` VALUES (11254, 1, 'POL-016', 'CASETON MEDIDA .60X.26 ESPESOR DE .12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:51', '2020-10-19 11:15:57', 5, 5);
INSERT INTO `materiales` VALUES (11282, 1, 'POL-023', 'CASETON MEDIDA .60X.26 ESPESOR DE 7CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:51', '2020-10-19 11:15:57', 5, 5);
INSERT INTO `materiales` VALUES (11270, 1, 'POL-020', 'CASETON MEDIDA .60X.28 ESPESOR DE .12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:51', '2020-10-19 11:15:57', 5, 5);
INSERT INTO `materiales` VALUES (11238, 1, 'POL-012', 'CASETON MEDIDA .60X.46 ESPESOR DE .12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:51', '2020-10-19 11:15:58', 5, 5);
INSERT INTO `materiales` VALUES (11242, 1, 'POL-013', 'CASETON MEDIDA .60X.48 ESPESOR DE .12', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:51', '2020-10-19 11:15:58', 5, 5);
INSERT INTO `materiales` VALUES (10274, 1, 'POL-004', 'CASETON MEDIDA .60X.50 ESOESIR DE 10 DENSIDAD 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:51', '2020-10-19 11:15:58', 5, 5);
INSERT INTO `materiales` VALUES (10590, 1, 'POL-009', 'CASETON MEDIDA .60X.50 ESPESOR DE 12 CM', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:51', '2020-10-19 11:15:58', 5, 5);
INSERT INTO `materiales` VALUES (27486, 1, 'POL-100', 'CASETON MEDIDA .60X.50 ESPESOR DE 15 CM', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:51', '2020-10-19 11:15:58', 5, 5);
INSERT INTO `materiales` VALUES (12666, 1, 'POL-044', 'CASETON MEDIDA .75X.50 ESPESOR DE 10 DENSIDAD DE 10', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:52', '2020-10-19 11:15:58', 5, 5);
INSERT INTO `materiales` VALUES (27249, 1, 'CAZ-126', 'CAZUELITA BAJA REDONDEADA 16CM', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:52', '2020-10-19 11:15:58', 5, 5);
INSERT INTO `materiales` VALUES (12687, 1, 'O-175', 'CEDULA CATASTRAL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:52', '2020-10-19 11:15:59', 5, 5);
INSERT INTO `materiales` VALUES (13174, 1, '0-278', 'CELOFAN BOLSA XGDE', 794, 'ACABADOS', 'BOLSA', 'BOLSA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:52', '2020-10-19 11:15:59', 5, 5);
INSERT INTO `materiales` VALUES (12849, 1, 'O-204', 'CELULAR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:52', '2020-10-19 11:15:59', 5, 5);
INSERT INTO `materiales` VALUES (12079, 1, 'A-031', 'CEMENTINE CONTRAST CIRCOLI  40 X 40 PRIMERA', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:52', '2020-10-19 11:15:59', 5, 5);
INSERT INTO `materiales` VALUES (13465, 1, '01-CROCE', 'CEMENTINE CONTRAST CROCE 40X40', 794, 'ACABADOS', 'CAJS', 'CAJS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:52', '2020-10-19 11:15:59', 5, 5);
INSERT INTO `materiales` VALUES (11864, 1, 'P-022', 'CEMENTO BLANCO BULTO 50KG', 795, 'PISOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:52', '2020-10-19 11:15:59', 5, 5);
INSERT INTO `materiales` VALUES (9561, 1, 'P-002', 'CEMENTO BLANCO SACO DE 25 KG', 795, 'PISOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:52', '2020-10-19 11:15:59', 5, 5);
INSERT INTO `materiales` VALUES (11785, 1, 'C-16', 'CEMENTO CREST', 810, 'CONCRETOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:52', '2020-10-19 11:16:00', 5, 5);
INSERT INTO `materiales` VALUES (9634, 1, 'C-007', 'CEMENTO GRIS 50 KG', 810, 'CONCRETOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:53', '2020-10-19 11:16:00', 5, 5);
INSERT INTO `materiales` VALUES (29328, 1, 'CEM-852', 'CEMENTO PLASTICO', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:53', '2020-10-19 11:16:00', 5, 5);
INSERT INTO `materiales` VALUES (29163, 1, 'CEM-96', 'CEMENTO PLASTICO GAL. DE 4 LTS', 794, 'ACABADOS', 'GALON', 'GALON', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:53', '2020-10-19 11:16:00', 5, 5);
INSERT INTO `materiales` VALUES (27252, 1, 'CEN-127', 'CENICERO MEDIANO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:53', '2020-10-19 11:16:00', 5, 5);
INSERT INTO `materiales` VALUES (36176, 1, 'CPA-150', 'CENTRAL INTERCEPT X ADVANCED10 - 24  P/ 12 MESES', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:53', '2020-10-19 11:16:00', 5, 5);
INSERT INTO `materiales` VALUES (11108, 1, 'E-047', 'CENTRO DE CARGA 4X30', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:53', '2020-10-19 11:16:00', 5, 5);
INSERT INTO `materiales` VALUES (10558, 1, 'E-037', 'CENTRO DE CARGA 8 CIRCUITOS', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:53', '2020-10-19 11:16:01', 5, 5);
INSERT INTO `materiales` VALUES (10130, 1, 'E-002', 'CENTRO DE CARGA DE 1 CIRCUITO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:53', '2020-10-19 11:16:01', 5, 5);
INSERT INTO `materiales` VALUES (10126, 1, 'E-001', 'CENTRO DE CARGA DE 2 CIRCUITOS', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:53', '2020-10-19 11:16:01', 5, 5);
INSERT INTO `materiales` VALUES (13243, 1, 'E-078', 'CENTRO DE CARGA DE 6 CIRCUITOS  NO EMPOTRABLE', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:54', '2020-10-19 11:16:01', 5, 5);
INSERT INTO `materiales` VALUES (10733, 1, 'E-039', 'CENTRO DE CARGA DE 8 CIRCUITOS', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:54', '2020-10-19 11:16:01', 5, 5);
INSERT INTO `materiales` VALUES (19593, 1, 'BRO-18', 'CEPILLO DE ALAMBRE', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:54', '2020-10-19 11:16:01', 5, 5);
INSERT INTO `materiales` VALUES (10625, 1, 'A-020', 'CEPILLO DE ALAMBRE (METAL)', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:54', '2020-10-19 11:16:01', 5, 5);
INSERT INTO `materiales` VALUES (31252, 1, 'CEP-100', 'CEPILLO P/IMPER DE IXTLE C/MANGO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:54', '2020-10-19 11:16:02', 5, 5);
INSERT INTO `materiales` VALUES (37195, 1, 'CEF-100', 'CERA CUENTA FACIL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:54', '2020-10-19 11:16:02', 5, 5);
INSERT INTO `materiales` VALUES (13126, 1, 'CA-042', 'CERRADURA EXTERIOR C/LLAVE MARCA DETER CODIGO 6603', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:54', '2020-10-19 11:16:02', 5, 5);
INSERT INTO `materiales` VALUES (9986, 1, 'CA-007', 'CERRADURA EXTERIOR LLAVE CROMO SATIN', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:54', '2020-10-19 11:16:02', 5, 5);
INSERT INTO `materiales` VALUES (13129, 1, 'CA-41', 'CERRADURA EXTERIOR MARCA DEXTER C/LLAVE CODIGO 6603', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:55', '2020-10-19 11:16:02', 5, 5);
INSERT INTO `materiales` VALUES (13135, 1, 'CA-043', 'CERRADURA INTERIOR  S/LLAVE  LATON ANTIGUO', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:55', '2020-10-19 11:16:02', 5, 5);
INSERT INTO `materiales` VALUES (9982, 1, 'CA-006', 'CERRADURA INTERIOR CROMO SATIN BOTON', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:55', '2020-10-19 11:16:02', 5, 5);
INSERT INTO `materiales` VALUES (30465, 1, 'CER-100', 'CERROJO DE SEGURIDAD', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:55', '2020-10-19 11:16:03', 5, 5);
INSERT INTO `materiales` VALUES (31392, 1, 'CER-1000', 'CERTIFICACION', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:55', '2020-10-19 11:16:03', 5, 5);
INSERT INTO `materiales` VALUES (22135, 1, 'C-2', 'CERTIFICACION AVALUOS', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:55', '2020-10-19 11:16:03', 5, 5);
INSERT INTO `materiales` VALUES (35022, 1, 'CEC-100', 'CERTIFICACION CATASTRAL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:56', '2020-10-19 11:16:03', 5, 5);
INSERT INTO `materiales` VALUES (24290, 1, 'C-097', 'CERTIFICADO DE LIBERTAD DE GRAVAMEN', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:56', '2020-10-19 11:16:03', 5, 5);
INSERT INTO `materiales` VALUES (13033, 1, 'O-267', 'CERTIFICADOS', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:56', '2020-10-19 11:16:03', 5, 5);
INSERT INTO `materiales` VALUES (9878, 1, 'AC-008', 'CESPOL RIGIDO P/LAVABO', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:57', '2020-10-19 11:16:03', 5, 5);
INSERT INTO `materiales` VALUES (9874, 1, 'AC-007', 'CESPOL RIGIDO PARA FREGADERO', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:57', '2020-10-19 11:16:04', 5, 5);
INSERT INTO `materiales` VALUES (12714, 1, 'O-190', 'CESTO DE BASURA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:57', '2020-10-19 11:16:04', 5, 5);
INSERT INTO `materiales` VALUES (30816, 1, 'CHS-104', 'CHALECO DE SEGURIDAD NARANJA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:57', '2020-10-19 11:16:04', 5, 5);
INSERT INTO `materiales` VALUES (30819, 1, 'CHS-105', 'CHALECO DE SEGURIDAD NARANJA C/CIERRE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:57', '2020-10-19 11:16:04', 5, 5);
INSERT INTO `materiales` VALUES (13462, 1, 'CH-006', 'CHALPUA CAJA REGISTRO 6*6', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:57', '2020-10-19 11:16:04', 5, 5);
INSERT INTO `materiales` VALUES (13090, 1, 'E-071', 'CHALUPA 2X4  REFORZADA PLASTICA BTICINO', 794, 'ACABADOS', 'PZA', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:57', '2020-10-19 11:16:04', 5, 5);
INSERT INTO `materiales` VALUES (13093, 1, 'E-072', 'CHALUPA 2X4 LIGERA TROQUELADA', 791, 'ELECTRIFICACION', 'PZA', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:57', '2020-10-19 11:16:04', 5, 5);
INSERT INTO `materiales` VALUES (10142, 1, 'E-005', 'CHALUPA CAJA REGISTRO MEDIDA 2\"X4\"', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:57', '2020-10-19 11:16:05', 5, 5);
INSERT INTO `materiales` VALUES (11468, 1, 'E-058', 'CHALUPA CAJA REGISTRO MEDIDA 4\"X4\"', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:57', '2020-10-19 11:16:05', 5, 5);
INSERT INTO `materiales` VALUES (10138, 1, 'E-004', 'CHALUPA CAJA REGISTRO MEDIDA DE 3\"X3\"', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:58', '2020-10-19 11:16:05', 5, 5);
INSERT INTO `materiales` VALUES (13735, 1, 'CH-001', 'CHAMARRAS CON CAPUCHA ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:58', '2020-10-19 11:16:05', 5, 5);
INSERT INTO `materiales` VALUES (20208, 1, 'CHAP', 'CHAPETON', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:58', '2020-10-19 11:16:05', 5, 5);
INSERT INTO `materiales` VALUES (13429, 1, '0-333', 'CHAROLA 3 NIVELES T/C MESH', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:58', '2020-10-19 11:16:05', 5, 5);
INSERT INTO `materiales` VALUES (25484, 1, 'CHP-135', 'CHAROLA PARA PARED', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:58', '2020-10-19 11:16:05', 5, 5);
INSERT INTO `materiales` VALUES (12789, 1, 'A-81', 'CHAROLA PARA PINTAR', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:58', '2020-10-19 11:16:06', 5, 5);
INSERT INTO `materiales` VALUES (27275, 1, 'CHR-133', 'CHAROLA RECTANGULAR No. 5 GDE 29X15 CMS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:58', '2020-10-19 11:16:06', 5, 5);
INSERT INTO `materiales` VALUES (13069, 1, 'O-305', 'CHAROLAS DE 35 X 80 CM', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:58', '2020-10-19 11:16:06', 5, 5);
INSERT INTO `materiales` VALUES (30793, 1, 'CHS-202', 'CHECAR SISTEMA DE AIRE ( CLIMA )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:58', '2020-10-19 11:16:06', 5, 5);
INSERT INTO `materiales` VALUES (30617, 1, 'CHS-100', 'CHECAR SISTEMA ELECTRICO DE CARGA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:06', 5, 5);
INSERT INTO `materiales` VALUES (12741, 1, 'CS-009', 'CHESLON A:90  L:88   F:150', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:06', 5, 5);
INSERT INTO `materiales` VALUES (36598, 1, 'CHI-100', 'CHINCHETAS TRANSPARENTES  C/100', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:06', 5, 5);
INSERT INTO `materiales` VALUES (26680, 1, 'ACC-251', 'CHUPON P/LAVABO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:06', 5, 5);
INSERT INTO `materiales` VALUES (18912, 1, 'CHUPLA-16', 'CHUPONES P/LAVAVO', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:07', 5, 5);
INSERT INTO `materiales` VALUES (32843, 1, 'CRP-100', 'CIERRA PUERTAS HIDRAULICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:07', 5, 5);
INSERT INTO `materiales` VALUES (27125, 1, 'CIL-105', 'CILINDRITO MEDIANO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:07', 5, 5);
INSERT INTO `materiales` VALUES (13285, 1, '0-304', 'CILINDRO DE GAS MAPP AMARILLO 16 ONZAS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:07', 5, 5);
INSERT INTO `materiales` VALUES (10944, 1, 'O-011', 'CILINDROS DE CONCRETO PROBADOS', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:07', 5, 5);
INSERT INTO `materiales` VALUES (31216, 1, 'CIN-100', 'CINCEL CORTE FRIO CON GRIP', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:07', 5, 5);
INSERT INTO `materiales` VALUES (10146, 1, 'E-006', 'CINTA DE  AISLAR NEGRA', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:08', 5, 5);
INSERT INTO `materiales` VALUES (12450, 1, 'A-079', 'CINTA MASKING', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:01:59', '2020-10-19 11:16:09', 5, 5);
INSERT INTO `materiales` VALUES (13906, 1, 'O-348', 'CINTA MASTEYN 1', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:09', 5, 5);
INSERT INTO `materiales` VALUES (13036, 1, 'O-268', 'CINTA PLASTICA PARA MALLA CICLONICA VERDE', 808, 'OTROS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:09', 5, 5);
INSERT INTO `materiales` VALUES (11492, 1, 'O-43', 'CINTA ROJA DE PRECAUCION', 808, 'OTROS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:09', 5, 5);
INSERT INTO `materiales` VALUES (12510, 1, 'O-152', 'CINTA SCOTCH ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:09', 5, 5);
INSERT INTO `materiales` VALUES (13321, 1, 'H-120', 'CINTA TEFLON 3/4', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:10', 5, 5);
INSERT INTO `materiales` VALUES (9686, 1, 'H-018', 'CINTA TEFLON DE 3/4\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:10', 5, 5);
INSERT INTO `materiales` VALUES (34286, 1, 'CBR-200', 'CINTILLA DE BARRO RUSTY ( CAJA C-54 PIEZAS )', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:10', 5, 5);
INSERT INTO `materiales` VALUES (26499, 1, 'CIP-100', 'CIPRES', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:10', 5, 5);
INSERT INTO `materiales` VALUES (12903, 1, 'O-214', 'CIRCULOS PARA SEMBRADO', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:10', 5, 5);
INSERT INTO `materiales` VALUES (12392, 1, 'AC-020', 'CISTERNA 1,100LT C/VALV Y FLOTADOR MARCA AQUAPLAS', 800, 'ACCESORIOS', 'Pieza', 'Pieza', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:10', 5, 5);
INSERT INTO `materiales` VALUES (13312, 1, 'AC-275', 'CISTERNA 2500 LITROS', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:10', 5, 5);
INSERT INTO `materiales` VALUES (34865, 1, 'CIS-1000', 'CISTERNA DE 10,000 LTS. MCA. ROTOPLAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:00', '2020-10-19 11:16:11', 5, 5);
INSERT INTO `materiales` VALUES (28840, 1, 'CIS-280', 'CISTERNA DE 2800 LTS. MCA. ROTOPLAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:11', 5, 5);
INSERT INTO `materiales` VALUES (35131, 1, 'CIS-5000', 'CISTERNA DE 5,000 LTS. MCA. ROTOPLAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:11', 5, 5);
INSERT INTO `materiales` VALUES (13729, 1, 'AC-2800', 'CISTERNA ROTOPLAS DE 2800 LI', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:11', 5, 5);
INSERT INTO `materiales` VALUES (20161, 1, 'CCG', 'CLAUDIA CONTRERAS GOMEZ', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:11', 5, 5);
INSERT INTO `materiales` VALUES (32184, 1, 'CLC-100', 'CLAVE CATASTRAL', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:11', 5, 5);
INSERT INTO `materiales` VALUES (13414, 1, 'ACE-027', 'CLAVO 2 1/2 PULGADA SIN CABEZA', 809, 'ACERO', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:11', 5, 5);
INSERT INTO `materiales` VALUES (10673, 1, 'ACE-014', 'CLAVO DE 1 1/2\" PARA CONCRETO', 809, 'ACERO', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:12', 5, 5);
INSERT INTO `materiales` VALUES (9934, 1, 'ACE-011', 'CLAVO DE 2 1/2\" PARA CONCRETO', 809, 'ACERO', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:12', 5, 5);
INSERT INTO `materiales` VALUES (9930, 1, 'ACE-010', 'CLAVO DE 2 1/2\" PARA MADERA', 809, 'ACERO', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:12', 5, 5);
INSERT INTO `materiales` VALUES (32330, 1, 'ACE-100', 'CLAVO DE 2 1/2\" PARA MADERA ( KILO )', 809, 'ACERO', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:12', 5, 5);
INSERT INTO `materiales` VALUES (26591, 1, 'ACE-084', 'CLAVO DE 2\" PARA CONCRETO', 808, 'OTROS', 'KG', 'KG', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:12', 5, 5);
INSERT INTO `materiales` VALUES (12269, 1, 'O-123', 'CLAVO DE 4\" PARA MADERA', 808, 'OTROS', 'KG', 'KG', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:01', '2020-10-19 11:16:12', 5, 5);
INSERT INTO `materiales` VALUES (13411, 1, 'ACE-026', 'CLAVO DE1 1/2 PULGADA SIN CABEZA', 809, 'ACERO', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:16:12', 5, 5);
INSERT INTO `materiales` VALUES (19805, 1, 'CPC-02', 'CLAVO P/CONCRETO 2\"', 808, 'OTROS', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:16:13', 5, 5);
INSERT INTO `materiales` VALUES (27695, 1, 'ACE-030', 'CLAVO PARA CONCRETO 2\" dala +castillos+cimbra', 809, 'ACERO', 'KG', 'KG', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:16:13', 5, 5);
INSERT INTO `materiales` VALUES (11318, 1, 'ACE-021', 'CLAVOS DE 1\" PARA CONCRETO', 809, 'ACERO', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:06:53', 5, 5);
INSERT INTO `materiales` VALUES (32258, 1, 'CLI-100', 'CLIP SUJETADOCUMENTOS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:06:54', 5, 5);
INSERT INTO `materiales` VALUES (13294, 1, '0-307', 'CLIPS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:06:54', 5, 5);
INSERT INTO `materiales` VALUES (30949, 1, 'CLORO-20L', 'CLORO 20 L', 803, 'EXTRAS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:06:54', 5, 5);
INSERT INTO `materiales` VALUES (15178, 1, 'MO5', 'CO MATERIAL Y MANO DE OBRA', 15165, 'MATERIAL Y MANO DE OBRA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:06:54', 5, 5);
INSERT INTO `materiales` VALUES (21633, 1, 'COC-240', 'COCINA 2.40 MOD.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:06:55', 5, 5);
INSERT INTO `materiales` VALUES (34220, 1, 'CIN-200', 'COCINA INTEGRAL COLOR CHOCOLATE', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:06:55', 5, 5);
INSERT INTO `materiales` VALUES (10952, 1, 'O-013', 'COCINETA INTEGRAL CON ESQUINERO COMPLETO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:02', '2020-10-19 11:06:55', 5, 5);
INSERT INTO `materiales` VALUES (36846, 1, 'COD-456', 'CODO 45 A.C. SOLD. R.L. CED-40 6\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:55', 5, 5);
INSERT INTO `materiales` VALUES (12967, 1, 'H-114', 'CODO 90  CPVC 3/4', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:55', 5, 5);
INSERT INTO `materiales` VALUES (12471, 1, 'H-090', 'CODO 90 1/2\" IUSAPLUS.', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:55', 5, 5);
INSERT INTO `materiales` VALUES (12970, 1, 'H-115', 'CODO 90 3/4 CPVC', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:56', 5, 5);
INSERT INTO `materiales` VALUES (12474, 1, 'H-091', 'CODO 90 3/4\" IUSAPLUS.', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:56', 5, 5);
INSERT INTO `materiales` VALUES (11397, 1, 'S-039', 'CODO 90° 4\" CON SALIDA LATERAL 2\"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:57', 5, 5);
INSERT INTO `materiales` VALUES (11333, 1, 'S-037', 'CODO 90° DE 4\" SALIDA TRASERA A 2\" PVC', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:57', 5, 5);
INSERT INTO `materiales` VALUES (10848, 1, 'H-054', 'CODO 90° DE COBRE 1/2\" PARA AGUA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:57', 5, 5);
INSERT INTO `materiales` VALUES (12642, 1, 'H-109', 'CODO 90° OREJA CPVC ROSCA INTERIOR DE 1/2 PARA REGADERA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:57', 5, 5);
INSERT INTO `materiales` VALUES (13666, 1, 'S-100', 'CODO CONDUIT PARED DELGADA C/V 031MM 1/2 KOBREX', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:57', 5, 5);
INSERT INTO `materiales` VALUES (10586, 1, 'H-036', 'CODO CPVC 90° DE 1/2 DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:03', '2020-10-19 11:06:57', 5, 5);
INSERT INTO `materiales` VALUES (11583, 1, 'H-065', 'CODO CPVC DE 1/2', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:57', 5, 5);
INSERT INTO `materiales` VALUES (11620, 1, 'H-079', 'CODO CPVC DE 90 DE 1 PULGADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:58', 5, 5);
INSERT INTO `materiales` VALUES (10641, 1, 'G-011', 'CODO DE 45° COBRE 3/4', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:58', 5, 5);
INSERT INTO `materiales` VALUES (9758, 1, 'S-022', 'CODO DE 45° DE 3\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:58', 5, 5);
INSERT INTO `materiales` VALUES (13219, 1, 'E-077', 'CODO DE 90 POLIDUCTO 3/4', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:58', 5, 5);
INSERT INTO `materiales` VALUES (10637, 1, 'G-010', 'CODO DE 90° COBRE 3/4', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:58', 5, 5);
INSERT INTO `materiales` VALUES (9742, 1, 'S-012', 'CODO DE 90° DE 2\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:58', 5, 5);
INSERT INTO `materiales` VALUES (10653, 1, 'H-039', 'CODO DE 90° DE COBRE DE 1/2', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:58', 5, 5);
INSERT INTO `materiales` VALUES (10478, 1, 'H-017', 'CODO DE 90° GALVANIZADO DE 1/2\" DE  DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:58', 5, 5);
INSERT INTO `materiales` VALUES (10246, 1, 'E-031', 'CODO DE 90° POLIDUCTO DE 1/2\"', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:59', 5, 5);
INSERT INTO `materiales` VALUES (9666, 1, 'H-005', 'CODO DE 90° TUBOPLUS DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:59', 5, 5);
INSERT INTO `materiales` VALUES (10450, 1, 'H-006', 'CODO DE 90° TUBOPLUS ROSCA INTERIOR DE 1/2\" PARA REGADERA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:59', 5, 5);
INSERT INTO `materiales` VALUES (11068, 1, 'G-021', 'CODO DE COBRE 1\"', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:04', '2020-10-19 11:06:59', 5, 5);
INSERT INTO `materiales` VALUES (35550, 1, 'COD-050', 'CODO DE INSERCION  1/2 \" SBE-050', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:06:59', 5, 5);
INSERT INTO `materiales` VALUES (35562, 1, 'COD-075', 'CODO DE INSERCION  3/4 \" SBE-075', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:06:59', 5, 5);
INSERT INTO `materiales` VALUES (34921, 1, 'COI-100', 'CODO DE INSERCION 1/2 \" SBE-050', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:06:59', 5, 5);
INSERT INTO `materiales` VALUES (12302, 1, 'H-084', 'CODO HIDRAULICO MEDIDA C/1C 45° - 200 MM', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:07:00', 5, 5);
INSERT INTO `materiales` VALUES (10534, 1, 'H-032', 'CODO OREJA CPVC ROSCA INTERNA HEMBRA DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:07:00', 5, 5);
INSERT INTO `materiales` VALUES (35574, 1, 'CPV-245', 'CODO PVC  CEM 2\" X 45', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:07:00', 5, 5);
INSERT INTO `materiales` VALUES (10562, 1, 'E-038', 'CODO PVC 1 1/4\" ELECTRICO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:07:00', 5, 5);
INSERT INTO `materiales` VALUES (9738, 1, 'S-011', 'CODO PVC 45° DE 2\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:07:00', 5, 5);
INSERT INTO `materiales` VALUES (12603, 1, 'H-108', 'CODO PVC 90 2\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:07:00', 5, 5);
INSERT INTO `materiales` VALUES (26594, 1, 'S-091', 'CODO PVC 90X4 SALIDA LATERAL A 2\"', 783, 'SANITARIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:07:00', 5, 5);
INSERT INTO `materiales` VALUES (9706, 1, 'S-003', 'CODO PVC DE 45° DE 4\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:05', '2020-10-19 11:07:01', 5, 5);
INSERT INTO `materiales` VALUES (9702, 1, 'S-002', 'CODO PVC DE 90° DE 4\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:01', 5, 5);
INSERT INTO `materiales` VALUES (9762, 1, 'S-023', 'CODO PVC DE 90° MACHO DE 3\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:01', 5, 5);
INSERT INTO `materiales` VALUES (35577, 1, 'COD-114', 'CODO PVC HID CED 40 CEM 1 1/4\" X 90', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:01', 5, 5);
INSERT INTO `materiales` VALUES (35580, 1, 'COD-190', 'CODO PVC HID CED 40 CEM 1\" X 90', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:01', 5, 5);
INSERT INTO `materiales` VALUES (34927, 1, 'CHC-040', 'CODO PVC HID CED 40 CEM 1\" X1/2 \"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:01', 5, 5);
INSERT INTO `materiales` VALUES (35571, 1, 'CHC-C42', 'CODO PVC HID CED 40 CEM 2\" X 90', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:01', 5, 5);
INSERT INTO `materiales` VALUES (35044, 1, 'COD-090', 'CODO PVC HID RED CEM X R- INT. DE 1\"X1/2 DE 90º', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:02', 5, 5);
INSERT INTO `materiales` VALUES (35544, 1, 'CHC-090', 'CODO PVC HID RED CEM X R-INT 1 X 1/2 DE 90', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:02', 5, 5);
INSERT INTO `materiales` VALUES (10502, 1, 'H-024', 'CODO PVC HIDRAULICO DE 90° DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:02', 5, 5);
INSERT INTO `materiales` VALUES (10258, 1, 'E-034', 'CODO TIMBOL  GALVANIZADO DE 1/2\"', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:02', 5, 5);
INSERT INTO `materiales` VALUES (9886, 1, 'AC-010', 'COFLEX MANGUERA ALUMINIO P/LAVABO MARCA RUGO', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:06', '2020-10-19 11:07:02', 5, 5);
INSERT INTO `materiales` VALUES (9890, 1, 'AC-011', 'COFLEX MANGUERA DE ALUMINIO P/FREGADERO MARCA RUGO', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:07', '2020-10-19 11:07:02', 5, 5);
INSERT INTO `materiales` VALUES (9882, 1, 'AC-009', 'COFLEX MANGUERA DE ALUMINIO PARA WC MARCA RUGO', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:07', '2020-10-19 11:07:02', 5, 5);
INSERT INTO `materiales` VALUES (27979, 1, 'COJ-112', 'COJIN KIWU', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:07', '2020-10-19 11:07:03', 5, 5);
INSERT INTO `materiales` VALUES (13264, 1, '0-298', 'COJIN NO.1 PLASTICO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:07', '2020-10-19 11:07:03', 5, 5);
INSERT INTO `materiales` VALUES (27970, 1, 'COJ-110', 'COJIN PARRAS 50X50 VINO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:07', '2020-10-19 11:07:03', 5, 5);
INSERT INTO `materiales` VALUES (28000, 1, 'COJ-120', 'COJIN PAWAH 45X45 VERDE OSCURO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:07', '2020-10-19 11:07:03', 5, 5);
INSERT INTO `materiales` VALUES (27955, 1, 'COJ-105', 'COJIN TEJIDO BOKOBA 45X45  AZUL MARINO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:08', '2020-10-19 11:07:03', 5, 5);
INSERT INTO `materiales` VALUES (27982, 1, 'COJ-113', 'COJIN UNIWA 45X45 AZUL', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:08', '2020-10-19 11:07:03', 5, 5);
INSERT INTO `materiales` VALUES (27946, 1, 'COJ-101', 'COJINJ FRESNILLO 45X45 AMARILLO', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:08', '2020-10-19 11:07:03', 5, 5);
INSERT INTO `materiales` VALUES (10298, 1, 'S-013', 'COLADERA UNIVERSAL DE 4\" RUGO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:09', '2020-10-19 11:07:04', 5, 5);
INSERT INTO `materiales` VALUES (10302, 1, 'S-014', 'COLADERA UNIVERSAL MARCA FAMA MODELO 9688 CON SALIDA DE 2\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:09', '2020-10-19 11:07:04', 5, 5);
INSERT INTO `materiales` VALUES (12768, 1, 'CS-019', 'COLCHON MATRIMONIAL PRIMO ALTO 23 CM ', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:09', '2020-10-19 11:07:04', 5, 5);
INSERT INTO `materiales` VALUES (25603, 1, 'U-017', 'COLCHON Y ACOSTILLADO DE  TUBERIA CON MATERIAL DE BANCO ARENA GRUESA HASTA 20 CM ARRIBA DE LA TUBERIA, INCLUYE SUMINISTRO DE MATERIAL Y MANO DE OBRA', 806, 'URBANIZACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:09', '2020-10-19 11:07:04', 5, 5);
INSERT INTO `materiales` VALUES (13552, 1, 'EU-082', 'COLGNTE QUINTUPLE PIANELA ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:09', '2020-10-19 11:07:04', 5, 5);
INSERT INTO `materiales` VALUES (25337, 1, 'COL-110', 'COLOCACION DE TUBERI SOLDADA AL ARCO ELECTRICO', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:09', '2020-10-19 11:07:04', 5, 5);
INSERT INTO `materiales` VALUES (9798, 1, 'A-005', 'COLOR REAL ANTILOPE', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:09', '2020-10-19 11:07:04', 5, 5);
INSERT INTO `materiales` VALUES (9806, 1, 'A-007', 'COLOR REAL ARCILLA', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:09', '2020-10-19 11:07:05', 5, 5);
INSERT INTO `materiales` VALUES (10717, 1, 'A-022', 'COLOR REAL COLOR CAMELLO', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:05', 5, 5);
INSERT INTO `materiales` VALUES (10713, 1, 'A-021', 'COLOR REAL CREMA INGLESA', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:05', 5, 5);
INSERT INTO `materiales` VALUES (9802, 1, 'A-006', 'COLOR REAL HABANO', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:05', 5, 5);
INSERT INTO `materiales` VALUES (9794, 1, 'A-004', 'COLOR REAL INCIENSO', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:05', 5, 5);
INSERT INTO `materiales` VALUES (12882, 1, 'AV-002', 'COLUMPIO ARCO TRIPLE ', 821, 'AREA VERDE', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:05', 5, 5);
INSERT INTO `materiales` VALUES (33525, 1, 'HER-400', 'COLUMPIO DE 4 ASIENTOS FABRICADO CON TUBO DE 2 CED 30, TUBO DE 21/2 CED 30, ÁNGULO 1/8*1, TUBO 3/4 CED 30 Y SOLERA 1/8*3/4, CADENA DE 1/4 GALVANIZADA Y BISAGRAS TUBULARES.', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:05', 5, 5);
INSERT INTO `materiales` VALUES (34869, 1, 'COM-250', 'COMBO TECLADO Y MOUSE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:06', 5, 5);
INSERT INTO `materiales` VALUES (13768, 1, 'COM-001', 'COMISION POR VENTA ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:06', 5, 5);
INSERT INTO `materiales` VALUES (35465, 1, 'COM-050', 'COMPOSTA DE 50 kg.', 808, 'OTROS', 'SACO', 'SACO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:06', 5, 5);
INSERT INTO `materiales` VALUES (13612, 1, 'O-361', 'COMPRA DE LLANTA ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:06', 5, 5);
INSERT INTO `materiales` VALUES (13543, 1, 'O-359', 'COMPRA E INSTALACION DE AMORTIGUADOR DE LA SIERRA', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:10', '2020-10-19 11:07:06', 5, 5);
INSERT INTO `materiales` VALUES (34717, 1, '', 'COMPRAS VARIAS HECTOR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:07', 5, 5);
INSERT INTO `materiales` VALUES (34719, 1, '', 'COMPRAS VARIAS HECTOR TASA 0%', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:07', 5, 5);
INSERT INTO `materiales` VALUES (13648, 1, '0-355', 'COMPRESOR DE AIRE  CODIGO 19391', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:07', 5, 5);
INSERT INTO `materiales` VALUES (12906, 1, 'O-215', 'COMPUTRADORA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:08', 5, 5);
INSERT INTO `materiales` VALUES (32297, 1, 'COM-100', 'COMUNICADOR UNIVERSAL PARA ALARMAS GSM/GPRS/TECNOLOGIA 3G REQUIERE SIM CARD', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:08', 5, 5);
INSERT INTO `materiales` VALUES (11431, 1, 'C-015', 'CONCRETO CONVENCIONAL FC=150 TIRO DIRECTO', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:08', 5, 5);
INSERT INTO `materiales` VALUES (11434, 1, 'C-016', 'CONCRETO CONVENCIONAL FC=200 TIRO DIRECTO', 794, 'ACABADOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:08', 5, 5);
INSERT INTO `materiales` VALUES (13117, 1, 'E-074', 'CONECTOR  C/ MANGA', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:08', 5, 5);
INSERT INTO `materiales` VALUES (10378, 1, 'EU-014', 'CONECTOR  GAR', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:09', 5, 5);
INSERT INTO `materiales` VALUES (12922, 1, 'H-200', 'CONECTOR 1/2 PE-AL-PE', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:09', 5, 5);
INSERT INTO `materiales` VALUES (11040, 1, 'G-014', 'CONECTOR BRONCE 1/2\" A 3/8\" ROSCA EXTERIOR', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:11', '2020-10-19 11:07:09', 5, 5);
INSERT INTO `materiales` VALUES (33991, 1, 'CON-112', 'CONECTOR CONDUIT DE 1/2', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:09', 5, 5);
INSERT INTO `materiales` VALUES (11611, 1, 'H-076', 'CONECTOR CPVC  DE 1 PULGADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:09', 5, 5);
INSERT INTO `materiales` VALUES (13573, 1, 'EU-084', 'CONECTOR CPVC 3/4 ROSACA EXTERIOR ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:09', 5, 5);
INSERT INTO `materiales` VALUES (10522, 1, 'H-029', 'CONECTOR CPVC ROSCA EXTERNA MACHO DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:10', 5, 5);
INSERT INTO `materiales` VALUES (10474, 1, 'H-016', 'CONECTOR CPVC ROSCA INTERIOR DE 1/2', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:10', 5, 5);
INSERT INTO `materiales` VALUES (10526, 1, 'H-030', 'CONECTOR CPVC ROSCA INTERNA HEMBRA DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:10', 5, 5);
INSERT INTO `materiales` VALUES (11839, 1, 'H-064', 'CONECTOR DE BONCE DOBLE ESPIGA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:11', 5, 5);
INSERT INTO `materiales` VALUES (11044, 1, 'G-015', 'CONECTOR DE BRONCE DE 1/2\" A 3/8\" ROSCA INTERIOR', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:11', 5, 5);
INSERT INTO `materiales` VALUES (11064, 1, 'G-020', 'CONECTOR DE COBRE ROSCA EXTERIOR DE 1\"', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:11', 5, 5);
INSERT INTO `materiales` VALUES (34415, 1, 'COE-200', 'CONECTOR DE CPVC  ROSCA EXTERIOR DE 1\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:11', 5, 5);
INSERT INTO `materiales` VALUES (11188, 1, 'H-060', 'CONECTOR ESPIGA BRONCE 1/2', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:12', '2020-10-19 11:07:11', 5, 5);
INSERT INTO `materiales` VALUES (33997, 1, 'CON-100', 'CONECTOR FLEXIBLE RECTO DE 1/2', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:12', 5, 5);
INSERT INTO `materiales` VALUES (13576, 1, 'EU-085', 'CONECTOR HEMBRA 1/2', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:12', 5, 5);
INSERT INTO `materiales` VALUES (20578, 1, 'H-316', 'CONECTOR HEMBRA 3/4', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:12', 5, 5);
INSERT INTO `materiales` VALUES (13087, 1, 'E-070', 'CONECTOR HERMETICO VOLTECH', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:12', 5, 5);
INSERT INTO `materiales` VALUES (20384, 1, 'H-80', 'CONECTOR MACHO 1/2', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:12', 5, 5);
INSERT INTO `materiales` VALUES (15055, 1, 'E-076', 'CONECTOR MACHO CPVC 3/4 PULGADAS', 791, 'ELECTRIFICACION', '1', '1', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:12', 5, 5);
INSERT INTO `materiales` VALUES (10374, 1, 'EU-013', 'CONECTOR MULTIPLE DE  10 VIAS', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:13', 5, 5);
INSERT INTO `materiales` VALUES (10366, 1, 'EU-011', 'CONECTOR MULTIPLE DE  6 VIAS', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:13', 5, 5);
INSERT INTO `materiales` VALUES (10370, 1, 'EU-012', 'CONECTOR MULTIPLE DE  8 VIAS', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:13', 5, 5);
INSERT INTO `materiales` VALUES (10801, 1, 'EU-029', 'CONECTOR MULTIPLE DE 4 VIAS', 785, 'ELECTRIFICACION URB', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:13', 5, 5);
INSERT INTO `materiales` VALUES (10230, 1, 'E-027', 'CONECTOR PARA ALAMBRE DESNUDO COBRE NO. 6', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:13', 5, 5);
INSERT INTO `materiales` VALUES (10422, 1, 'EU-025', 'CONECTOR PARA VARILLA DE TIERRA DE 5/8\"  GAR', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:13', '2020-10-19 11:07:14', 5, 5);
INSERT INTO `materiales` VALUES (10510, 1, 'H-026', 'CONECTOR PVC HIDRAULICO ROSCA EXTERNA MACHO DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:14', 5, 5);
INSERT INTO `materiales` VALUES (10506, 1, 'H-025', 'CONECTOR PVC HIDRAULICO ROSCA INTERNA HEMBRA DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:14', 5, 5);
INSERT INTO `materiales` VALUES (12591, 1, 'H-104', 'CONECTOR ROSCA EXTERIOR 3/4\" IUSAPLUS', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:14', 5, 5);
INSERT INTO `materiales` VALUES (10657, 1, 'H-040', 'CONECTOR ROSCA EXTERIOR DE 1/2 COBRE', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:14', 5, 5);
INSERT INTO `materiales` VALUES (10434, 1, 'G-004', 'CONECTOR ROSCA EXTERIOR MULTICAPA MARCA DURMAN DE 1/2\" DE DIAMETRO', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:14', 5, 5);
INSERT INTO `materiales` VALUES (10603, 1, 'G-007', 'CONECTOR ROSCA EXTERIOR MULTICAPA MARCA DURMAN DE 3/8\"', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:14', 5, 5);
INSERT INTO `materiales` VALUES (12480, 1, 'H-093', 'CONECTOR ROSCA EXTERNA 1/2\" IUSAPLUS', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:15', 5, 5);
INSERT INTO `materiales` VALUES (13315, 1, 'E-081', 'CONECTOR ROSCA INT 1/2 COBRE', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:15', 5, 5);
INSERT INTO `materiales` VALUES (13336, 1, 'H-215', 'CONECTOR ROSCA INT 1/2 P/ TUBO PLUS', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:15', 5, 5);
INSERT INTO `materiales` VALUES (26674, 1, 'EU-086', 'CONECTOR ROSCA INTERIOR 3/4 CPVC', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:15', 5, 5);
INSERT INTO `materiales` VALUES (10701, 1, 'H-046', 'CONECTOR ROSCA INTERIOR DE 1\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:15', 5, 5);
INSERT INTO `materiales` VALUES (12973, 1, 'H-116', 'CONECTOR ROSCA INTERNA 3/4 CPVC', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:14', '2020-10-19 11:07:15', 5, 5);
INSERT INTO `materiales` VALUES (12483, 1, 'H-094', 'CONECTOR ROSCA INTERNA 3/4\" IUSAPLUS', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:16', 5, 5);
INSERT INTO `materiales` VALUES (11617, 1, 'H-078', 'CONECTOR TUBOPLUS ROSCA EXTERIOR DE 1/2', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:16', 5, 5);
INSERT INTO `materiales` VALUES (9674, 1, 'H-008', 'CONECTOR TUBOPLUS ROSCA EXTERNA MACHO DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:16', 5, 5);
INSERT INTO `materiales` VALUES (9670, 1, 'H-007', 'CONECTOR TUBOPLUS ROSCA INTERNA HEMBRA DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:16', 5, 5);
INSERT INTO `materiales` VALUES (13531, 1, '0-373', 'CONEXION DE LINEA TELEFONICA', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:16', 5, 5);
INSERT INTO `materiales` VALUES (12534, 1, 'EU-038', 'CONEXION DE PUENTES PRIMARIOS (INTERCONEXION DE ENERGIA ELECTRICA A CIRCUITO)', 785, 'ELECTRIFICACION URB', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:16', 5, 5);
INSERT INTO `materiales` VALUES (13207, 1, '0-285', 'CONFIGURACION  ESCRITORIO REMOTO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:17', 5, 5);
INSERT INTO `materiales` VALUES (13195, 1, '0-282', 'CONFIGURACION DE IMPRESORA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:17', 5, 5);
INSERT INTO `materiales` VALUES (13834, 1, 'CON-G', 'CONJUNTO OPERATIVO LINEA-G DE 165X225CM', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:17', 5, 5);
INSERT INTO `materiales` VALUES (31034, 1, 'COS-100', 'CONO DE SEGURIDAD P/TRAFICO CON REFLEJANDE DE .91cm', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:17', 5, 5);
INSERT INTO `materiales` VALUES (26585, 1, 'CAE-150', 'CONSTRUCCION DE ACOMETIDA ELECTRICA SUBTERRANEA PARA ALIMENTAR CASETA DE VENTAS', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:17', 5, 5);
INSERT INTO `materiales` VALUES (25184, 1, 'CAM-102', 'CONSTRUCCION DE ALIMENTACION AEREA Y MEDICION PARA ALIMENTAR CASETAS EN VENTAS UBICADA EN PERIFERICO Y PUENTE DE ACCESO', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:15', '2020-10-19 11:07:17', 5, 5);
INSERT INTO `materiales` VALUES (34529, 1, 'CON-200', 'CONSTRUCCION DE DESCARGA PLUVIAL, INC. EXCAVACION POR MEDIOS MANUALES PARA FORMACION DE CANAL', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:18', 5, 5);
INSERT INTO `materiales` VALUES (27058, 1, 'U-121', 'CONSTRUCCIÓN DE CAJA DE VALVULAS DE 90 CM X 110 CM CON MUROS DE ADOBON, ARMADO CON MALLA ELECTROSOLDADA 66 DE 66 TAPA DE LOS A DE CONCRETO FC 200 KG /CM2 ARMADO CON VARILLA DEL 3 CONTRAMARCO SENCILLO,', 806, 'URBANIZACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:18', 5, 5);
INSERT INTO `materiales` VALUES (33209, 1, 'COM-200', 'CONSULTA MEDICA VETERINARIA', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:18', 5, 5);
INSERT INTO `materiales` VALUES (11987, 1, 'O-092', 'CONSUMIBLES TONER BROTHER', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:18', 5, 5);
INSERT INTO `materiales` VALUES (11485, 1, 'O-041', 'CONSUMIBLES TONER CANON 4800 CE278A', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:18', 5, 5);
INSERT INTO `materiales` VALUES (11481, 1, 'O-040', 'CONSUMIBLES TONER CANON 5900 CE505A', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:19', 5, 5);
INSERT INTO `materiales` VALUES (35307, 1, '', 'CONSUMO DE ALIMENTOS', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:19', 5, 5);
INSERT INTO `materiales` VALUES (18920, 1, '', 'CONTACTO 2P+ TIERRA 15 A MARFIL SIMON 25', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:19', 5, 5);
INSERT INTO `materiales` VALUES (10186, 1, 'E-016', 'CONTACTO DOBLE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:19', 5, 5);
INSERT INTO `materiales` VALUES (10182, 1, 'E-015', 'CONTACTO DOBLE DE  INTEMPERIE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:19', 5, 5);
INSERT INTO `materiales` VALUES (11116, 1, 'E-049', 'CONTACTO DUPLEX 2P+T 15A BTICINO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:16', '2020-10-19 11:07:19', 5, 5);
INSERT INTO `materiales` VALUES (20390, 1, 'E-105', 'CONTACTO EXTERIO C/TAPADERA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:20', 5, 5);
INSERT INTO `materiales` VALUES (10856, 1, 'E-046', 'CONTACTO SENCILLO ', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:20', 5, 5);
INSERT INTO `materiales` VALUES (20618, 1, 'URB-053', 'CONTRAMARCO DE CANAL 4 DE 1.25', 818, 'VENTAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:20', 5, 5);
INSERT INTO `materiales` VALUES (20407, 1, 'URB-052', 'CONTRAMARCO FOFO 4\" 1.00 MTS. SENC', 806, 'URBANIZACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:20', 5, 5);
INSERT INTO `materiales` VALUES (10753, 1, 'O-007', 'CONTROL DE CALIDAD (LABORATORIO)', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:20', 5, 5);
INSERT INTO `materiales` VALUES (13855, 1, 'O-0010', 'CONTROL TOPOGRAFICO ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:21', 5, 5);
INSERT INTO `materiales` VALUES (26326, 1, 'COE-100', 'COPIADO EXCEDENTE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:21', 5, 5);
INSERT INTO `materiales` VALUES (33988, 1, 'COP-200', 'COPLE  CONDUIT 1/2', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:21', 5, 5);
INSERT INTO `materiales` VALUES (12477, 1, 'H-092', 'COPLE 1/2 IUSAPLUS', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:21', 5, 5);
INSERT INTO `materiales` VALUES (13828, 1, 'G-030', 'COPLE COBRE 3/4 ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:21', 5, 5);
INSERT INTO `materiales` VALUES (15127, 1, 'H-122', 'COPLE CPVC 3/4\"', 786, 'HIDRAULICA', '1', '1', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:21', 5, 5);
INSERT INTO `materiales` VALUES (10518, 1, 'H-028', 'COPLE CPVC DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:22', 5, 5);
INSERT INTO `materiales` VALUES (29332, 1, 'COP-100', 'COPLE DE 1/2 PARA GAS DURMAN', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:17', '2020-10-19 11:07:22', 5, 5);
INSERT INTO `materiales` VALUES (10677, 1, 'H-041', 'COPLE DE 1/2\" DE COBRE', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:18', '2020-10-19 11:07:22', 5, 5);
INSERT INTO `materiales` VALUES (11337, 1, 'G-028', 'COPLE DE 1/2\" GALVANIZADO', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:18', '2020-10-19 11:07:22', 5, 5);
INSERT INTO `materiales` VALUES (11080, 1, 'G-024', 'COPLE DE COBRE 1\"', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:18', '2020-10-19 11:07:22', 5, 5);
INSERT INTO `materiales` VALUES (12600, 1, 'H-107', 'COPLE GAS 3/8', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:18', '2020-10-19 11:07:22', 5, 5);
INSERT INTO `materiales` VALUES (9746, 1, 'S-015', 'COPLE PVC DE 2\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:18', '2020-10-19 11:07:23', 5, 5);
INSERT INTO `materiales` VALUES (11401, 1, 'H-061', 'COPLE PVC DE 3\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:18', '2020-10-19 11:07:23', 5, 5);
INSERT INTO `materiales` VALUES (9710, 1, 'S-004', 'COPLE PVC DE 4\" DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:18', '2020-10-19 11:07:23', 5, 5);
INSERT INTO `materiales` VALUES (35559, 1, 'COP-114', 'COPLE PVC HID CED 40 CEMENTAR 1-1/4\"', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:18', '2020-10-19 11:07:23', 5, 5);
INSERT INTO `materiales` VALUES (35622, 1, 'COP-120', 'COPLE PVC HID CED 40 CEMENTAR 2\"', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:18', '2020-10-19 11:07:23', 5, 5);
INSERT INTO `materiales` VALUES (35938, 1, 'CPH-350', 'COPLE PVC HID. ING. 150mm REP.', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:19', '2020-10-19 11:07:23', 5, 5);
INSERT INTO `materiales` VALUES (10490, 1, 'H-021', 'COPLE PVC HIDRAULICO DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:19', '2020-10-19 11:07:23', 5, 5);
INSERT INTO `materiales` VALUES (12113, 1, 'S-041', 'COPLE PVC REDUCCION SW 4\" A 2\"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:19', '2020-10-19 11:07:23', 5, 5);
INSERT INTO `materiales` VALUES (10729, 1, 'H-051', 'COPLE REGULAR PE AL PE 1/2\" X PE AL PE 1/2\" BRONCE', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:19', '2020-10-19 11:07:24', 5, 5);
INSERT INTO `materiales` VALUES (12305, 1, 'H-085', 'COPLE REPARACION MET 8\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:24', 5, 5);
INSERT INTO `materiales` VALUES (9654, 1, 'H-002', 'COPLE TUBOPLUS DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:24', 5, 5);
INSERT INTO `materiales` VALUES (13180, 1, 'H-201', 'COPLE UNION 1/2 P-AL-P', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:24', 5, 5);
INSERT INTO `materiales` VALUES (33571, 1, 'COF-180', 'CORDON PARA GAFETE NEGRO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:24', 5, 5);
INSERT INTO `materiales` VALUES (24813, 1, 'U-008', 'CORDON TIPO PECHO PALOMA PARA DESAGUE PLUVIAL, INCLUYE CIMBRA METALICA, TRAZO Y NIEVELACION. CIMBRADO Y DESCIMBRADO COLADO DE CONCRETO RESISTENCIA FC=200 KG/M2', 806, 'URBANIZACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:24', 5, 5);
INSERT INTO `materiales` VALUES (10968, 1, 'O-015', 'CORDONERIA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:24', 5, 5);
INSERT INTO `materiales` VALUES (34857, 1, 'COR-040', 'COROPLAST ROTULADO COM VINIL IMPRESO 40X30', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:25', 5, 5);
INSERT INTO `materiales` VALUES (34657, 1, 'COP-300', 'COROPLAST ROTULADO EN VINIL IMPRESO ALTA DEFINICION DE 1.00X1.00', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:25', 5, 5);
INSERT INTO `materiales` VALUES (35025, 1, 'COC-100', 'CORRECCION DE CLAVES', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:25', 5, 5);
INSERT INTO `materiales` VALUES (36314, 1, 'COR-200', 'CORRECTOR CINTA PERMANENTE DRYLINE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:25', 5, 5);
INSERT INTO `materiales` VALUES (13297, 1, '0-308', 'CORRECTOR LIQUIDO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:25', 5, 5);
INSERT INTO `materiales` VALUES (11884, 1, 'O-075', 'CORREDERA DE EXT. 50 cm', 808, 'OTROS', 'JUEGO', 'JUEGO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:20', '2020-10-19 11:07:25', 5, 5);
INSERT INTO `materiales` VALUES (30803, 1, 'COF-185', 'CORREGIR FALLA DE SUSPENSION AJUSTE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:21', '2020-10-19 11:07:25', 5, 5);
INSERT INTO `materiales` VALUES (28548, 1, 'CAR-100', 'CORTE DE PUERTA', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:21', '2020-10-19 11:07:26', 5, 5);
INSERT INTO `materiales` VALUES (27029, 1, 'U-108', 'CORTE DE TERRENO  PARA LLEGAR A NIVEL DE TERRENO NATURAL, INCLUYE: CORTE, ACAMELLONAMIENTO DE MATERIAL Y CARGA.', 24527, 'PLATAFORMAS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:21', '2020-10-19 11:07:26', 5, 5);
INSERT INTO `materiales` VALUES (24509, 1, 'U-004', 'CORTE DE TERRENO EN VIALIDAD PARA LLEGAR A NIVEL DE TERRENO NATURAL, INCLUYE: CORTE, ACAMELLONAMIENTO DE MATERIAL Y CARGA.', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:21', '2020-10-19 11:07:26', 5, 5);
INSERT INTO `materiales` VALUES (29158, 1, 'COR-108', 'CORTINAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:21', '2020-10-19 11:07:26', 5, 5);
INSERT INTO `materiales` VALUES (29145, 1, 'COR-102', 'CORTINEROS EXTRA INC. INSTALACION', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:21', '2020-10-19 11:07:26', 5, 5);
INSERT INTO `materiales` VALUES (29142, 1, 'COR-100', 'COTINAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:21', '2020-10-19 11:07:26', 5, 5);
INSERT INTO `materiales` VALUES (13024, 1, 'O-264', 'CPVC890-19', 808, 'OTROS', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:21', '2020-10-19 11:07:26', 5, 5);
INSERT INTO `materiales` VALUES (22295, 1, 'MO7', 'CQ MATERIAL Y MANO DE OBRA', 794, 'ACABADOS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:21', '2020-10-19 11:07:27', 5, 5);
INSERT INTO `materiales` VALUES (27178, 1, 'CRA-113', 'CRANCO DE ANIMAL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:27', 5, 5);
INSERT INTO `materiales` VALUES (31530, 1, 'CRN-100', 'CRAYON INDUSTRIAL DIXON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:27', 5, 5);
INSERT INTO `materiales` VALUES (28009, 1, 'CRE-123', 'CREDENZA YAAX NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:27', 5, 5);
INSERT INTO `materiales` VALUES (27175, 1, 'CRE-112', 'CREDINZA TABLON DE 2\"', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:27', 5, 5);
INSERT INTO `materiales` VALUES (13066, 1, 'O-304', 'CREMALLERA DE 2 M A LA MITAD', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:27', 5, 5);
INSERT INTO `materiales` VALUES (27237, 1, 'CREM-121', 'CREMERA CON HUELLA 3oz', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:27', 5, 5);
INSERT INTO `materiales` VALUES (31737, 1, 'CRO-100', 'CROQUETAS NUPEC ADULTO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:28', 5, 5);
INSERT INTO `materiales` VALUES (11152, 1, 'O-025', 'CROTO TORSIDO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:28', 5, 5);
INSERT INTO `materiales` VALUES (26870, 1, 'CRO-154', 'CROTOS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:28', 5, 5);
INSERT INTO `materiales` VALUES (13759, 1, 'CE-001', 'CRUCE EXPORTACION ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:28', 5, 5);
INSERT INTO `materiales` VALUES (31521, 1, 'CFF-100', 'CUADERNO ESP JEANBOOK F/FRANCESA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:22', '2020-10-19 11:07:28', 5, 5);
INSERT INTO `materiales` VALUES (29414, 1, 'CUD-30', 'CUADRO BLANCO/ NEGRO CON DORADO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:28', 5, 5);
INSERT INTO `materiales` VALUES (27991, 1, 'CUA-117', 'CUADRO FIGURA REFLEXIVA NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:29', 5, 5);
INSERT INTO `materiales` VALUES (30951, 1, 'CUB-32', 'CUBETA', 803, 'EXTRAS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:29', 5, 5);
INSERT INTO `materiales` VALUES (34494, 1, '', 'CUBETA BIOLIM TRICLORO GRANULAR 20KG', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:30', 5, 5);
INSERT INTO `materiales` VALUES (11974, 1, 'A-071', 'CUBETA DE RESINA GRUESA', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:30', 5, 5);
INSERT INTO `materiales` VALUES (27078, 1, 'CUB-100', 'CUBIERTA DE MARMOL BLANCO CARRARA EN BAÑOS', 794, 'ACABADOS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:30', 5, 5);
INSERT INTO `materiales` VALUES (27391, 1, 'CUB-138', 'CUBIERTAS PAROTA LISA .80X.80', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:30', 5, 5);
INSERT INTO `materiales` VALUES (33556, 1, 'CUB-150', 'CUBREBOCAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:30', 5, 5);
INSERT INTO `materiales` VALUES (12405, 1, 'A-034', 'CUBREREAL SACO DE 40KG', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:31', 5, 5);
INSERT INTO `materiales` VALUES (31240, 1, 'CUP-100', 'CUCHARA P/ALBAÑIL PRETUL', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:31', 5, 5);
INSERT INTO `materiales` VALUES (34813, 1, 'CUE-200', 'CUCHILLO PARA ELECTRICISTA DE 6', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:31', 5, 5);
INSERT INTO `materiales` VALUES (19906, 1, 'S-047', 'CUELLO DE CERA', 783, 'SANITARIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:31', 5, 5);
INSERT INTO `materiales` VALUES (10306, 1, 'S-017', 'CUELLO DE CERA CON GUIA PARA WC', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:23', '2020-10-19 11:07:31', 5, 5);
INSERT INTO `materiales` VALUES (12825, 1, 'O-199', 'CUOTA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:24', '2020-10-19 11:07:32', 5, 5);
INSERT INTO `materiales` VALUES (23811, 1, 'CC-001', 'CUOTA DE CONTRIBUCION', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:24', '2020-10-19 11:07:32', 5, 5);
INSERT INTO `materiales` VALUES (12955, 1, 'O205', 'CUOTA INSCRIPCION A OFERTA DE VIVIENDA', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:24', '2020-10-19 11:07:32', 5, 5);
INSERT INTO `materiales` VALUES (20139, 1, 'CPI', 'CUOTAS PATRONALES IMSS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:24', '2020-10-19 11:07:32', 5, 5);
INSERT INTO `materiales` VALUES (23436, 1, 'CS-01', 'CUOTAS SINDICALES', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:24', '2020-10-19 11:07:32', 5, 5);
INSERT INTO `materiales` VALUES (20142, 1, 'CTI', 'CUOTAS TRABAJADOR IMSS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:24', '2020-10-19 11:07:32', 5, 5);
INSERT INTO `materiales` VALUES (24740, 1, 'CS-101', 'CUOTAS Y SUSCRIPCIONES', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:25', '2020-10-19 11:07:33', 5, 5);
INSERT INTO `materiales` VALUES (12365, 1, 'O-142', 'CURSO SISEVIVE', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:25', '2020-10-19 11:07:33', 5, 5);
INSERT INTO `materiales` VALUES (12876, 1, 'O-212', 'CURSOS', 808, 'OTROS', 'SERVICIOS', 'SERVICIOS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:25', '2020-10-19 11:07:33', 5, 5);
INSERT INTO `materiales` VALUES (10254, 1, 'E-033', 'CURVA  CONDUIT PESADO DE 1 1/4\"', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:25', '2020-10-19 11:07:33', 5, 5);
INSERT INTO `materiales` VALUES (11478, 1, 'E-059', 'CURVA CONDUIT 1/2', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:25', '2020-10-19 11:07:33', 5, 5);
INSERT INTO `materiales` VALUES (18647, 1, '', 'CUÑA', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:25', '2020-10-19 11:07:34', 5, 5);
INSERT INTO `materiales` VALUES (20610, 1, 'CBGD', 'CYNTHIA BERENICE GONZALEZ DIMAS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:25', '2020-10-19 11:07:34', 5, 5);
INSERT INTO `materiales` VALUES (24923, 1, 'CMK-111', 'Cabecera matrimonial Kiria - Gris oscuro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:25', '2020-10-19 11:07:34', 5, 5);
INSERT INTO `materiales` VALUES (24920, 1, 'MAM-110', 'Cabecera queen de madera Andalucía - Nogal', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:25', '2020-10-19 11:07:34', 5, 5);
INSERT INTO `materiales` VALUES (33251, 1, 'CAB-150', 'Cabina Sanitizante/Desinfectante', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:25', '2020-10-19 11:07:34', 5, 5);
INSERT INTO `materiales` VALUES (25034, 1, 'CQS-147', 'Cama queen size Marquelia - Gris oscuro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:35', 5, 5);
INSERT INTO `materiales` VALUES (13678, 1, 'CL-005', 'Clavija sencilla ', 794, 'ACABADOS', 'pz', 'pz', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:35', 5, 5);
INSERT INTO `materiales` VALUES (24977, 1, 'CC-126', 'Credenza Cobá - Nogal', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:35', 5, 5);
INSERT INTO `materiales` VALUES (30628, 1, 'DAP', 'DAP', 803, 'EXTRAS', '1', '1', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:36', 5, 5);
INSERT INTO `materiales` VALUES (25676, 1, 'DEP-102', 'DEPOSITO EN GARANTIA', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:36', 5, 5);
INSERT INTO `materiales` VALUES (21520, 1, 'DRP-01', 'DERECHO DE REGISTRO PUBLICO', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:36', 5, 5);
INSERT INTO `materiales` VALUES (31099, 1, 'U-122', 'DESCARGA DOMICILIARIA, INCLUYE: TRAZO, EXCAVACION CON EQUIPO MECANICO, RELLENO CON MATERIAL PRODUCTO DE EXCAVACION COMPACTADA AL 85% PROCTOR, SUMINISTRO E INSTALACION DE TUBO 6\" CON TEE DE 6', 806, 'URBANIZACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:36', 5, 5);
INSERT INTO `materiales` VALUES (25617, 1, 'U-022', 'DESCARGA DOMICILIARIA, INCLUYE: TRAZO, EXCAVACION CON EQUIPO MECANICO, RELLENO CON MATERIAL PRODUCTO DE EXCAVACION COMPACTADA AL 85% PROCTOR, SUMINISTRO E INSTALACION DE TUBO 6\" COP Y LGA', 806, 'URBANIZACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:37', 5, 5);
INSERT INTO `materiales` VALUES (21419, 1, 'DESC1', 'DESCUENTO SOBRE VENTA', 818, 'VENTAS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:37', 5, 5);
INSERT INTO `materiales` VALUES (24103, 1, '', 'DESCUENTO SOBRE VENTA.', 818, 'VENTAS', 'NA', 'NA', '1', 'M.O.', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:37', 5, 5);
INSERT INTO `materiales` VALUES (36731, 1, 'DES-250', 'DESENGRAPADOR ACME', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:26', '2020-10-19 11:07:37', 5, 5);
INSERT INTO `materiales` VALUES (10888, 1, 'P-011', 'DESERT DUBAI 50X50 CMS. 1/2 BAÑO 1.72 M2 POR CAJA PROY 1.71 M2', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:38', 5, 5);
INSERT INTO `materiales` VALUES (36612, 1, 'DES-200', 'DESMALEZADORA A GASOLINA 63 cc MANGO BICI TRUPER C-199653', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:38', 5, 5);
INSERT INTO `materiales` VALUES (26548, 1, 'INS-152', 'DESMONTAJE DE EQUIPO DAÑADO E INSTALACION DE NUEVO MINISPLIT', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:38', 5, 5);
INSERT INTO `materiales` VALUES (27665, 1, 'ELT-07', 'DESMONTAJE Y RETIRO DELINEAS EXISTENCIALES', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:38', 5, 5);
INSERT INTO `materiales` VALUES (13138, 1, 'O-272', 'DESMONTAR E INSTALAR MINI SPLIT  POR CAMBIO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:38', 5, 5);
INSERT INTO `materiales` VALUES (24672, 1, 'DMV-101', 'DESMONTE DE MATERIA VEGETAL, ESCOMBRO Y BASURA INC. ACAMELLONADO CARGA Y ACARREO FUERA DE LA OBRA', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:39', 5, 5);
INSERT INTO `materiales` VALUES (24503, 1, 'U-002', 'DESPALME DE 15 CMS DE ESPESOR INCLUYE CORTE ACAMELLONADO, CARGA ACARREO SEMIHUMECTADO Y BANDEO DE MATERIAL EN AREAS DE PATIOS DE VIVIENDA (MATERIAL SUELTO)', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:39', 5, 5);
INSERT INTO `materiales` VALUES (34734, 1, 'DET-200', 'DETERGENTE ARCOIRIS 9 kg.', 808, 'OTROS', 'BOLSA', 'BOLSA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:39', 5, 5);
INSERT INTO `materiales` VALUES (30719, 1, '1205-101-012', 'DETERGENTE FAST 5LTS', 803, 'EXTRAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:39', 5, 5);
INSERT INTO `materiales` VALUES (25334, 1, 'DIA-109', 'DIAMETRO USO Y ACOMODO DE ACUERDO AL PROYECTO, TAMOS CON ORIFICIOS CON CORTES', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:39', 5, 5);
INSERT INTO `materiales` VALUES (13438, 1, '0-336', 'DICTAMEN DE ALUMBRAMIENTO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:39', 5, 5);
INSERT INTO `materiales` VALUES (26069, 1, 'DIS-100', 'DISCO DURO NAS 6 TB CONEXION POR RED INCLUYE SOFWARE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:40', 5, 5);
INSERT INTO `materiales` VALUES (11549, 1, 'O-047', 'DISEÑO DE ESTRATEGIA PUBLICITARIA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:27', '2020-10-19 11:07:40', 5, 5);
INSERT INTO `materiales` VALUES (13618, 1, 'A-090', 'DISEÑO DE IMAGEN  ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:40', 5, 5);
INSERT INTO `materiales` VALUES (23947, 1, 'DE-015', 'DISEÑO E INGENIERIAS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:40', 5, 5);
INSERT INTO `materiales` VALUES (26948, 1, 'DE-172', 'DISEÑO ESTRUCTURAL DE PROTOTIPO CONCORDIA INC. MEMORIA DE CALCULO', 794, 'ACABADOS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:41', 5, 5);
INSERT INTO `materiales` VALUES (36628, 1, 'DIC-100', 'DISEÑO ESTRUCTURAL DE PROTOTIPO CUADRUPLEX  INC. MEMORIA DE CALCULO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:41', 5, 5);
INSERT INTO `materiales` VALUES (26945, 1, 'DE-174', 'DISEÑO ESTRUCTURAL DE PROTOTIPO MESURA INC. MEMORIA DE CALCULO', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:41', 5, 5);
INSERT INTO `materiales` VALUES (9910, 1, 'AC-016', 'DOMO DE POLICARBONATO CON VENTILACION MEDIDAS .60X.60 CMS.', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:41', 5, 5);
INSERT INTO `materiales` VALUES (31300, 1, 'DO-100', 'DRO (DIRECTOR RESIDENTE DE OBRA)', 794, 'ACABADOS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:41', 5, 5);
INSERT INTO `materiales` VALUES (25739, 1, 'DEI-102', 'DUCTERIA E INSTALACION DE 2 APARATOS DE AIRE LAVADO', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:41', 5, 5);
INSERT INTO `materiales` VALUES (26873, 1, 'DUC-100', 'DURAN CUBAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:42', 5, 5);
INSERT INTO `materiales` VALUES (26480, 1, 'ELA-150', 'ELABORACION DE INGENIERIAS', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:42', 5, 5);
INSERT INTO `materiales` VALUES (12010, 1, 'O-097', 'ELABORACION DE TOLDO PARA TRAILA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:28', '2020-10-19 11:07:42', 5, 5);
INSERT INTO `materiales` VALUES (13189, 1, '0-280', 'ELABORACION FORMATO DE FACTURAS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:29', '2020-10-19 11:07:42', 5, 5);
INSERT INTO `materiales` VALUES (26022, 1, 'MO-103', 'ELECTRICO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:29', '2020-10-19 11:07:42', 5, 5);
INSERT INTO `materiales` VALUES (25273, 1, 'ELE-125', 'ELECTRIFICACION', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:29', '2020-10-19 11:07:43', 5, 5);
INSERT INTO `materiales` VALUES (35962, 1, 'EMP-160', 'EMPAQUE NEOPRENO PARA BRIDA 6\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:29', '2020-10-19 11:07:43', 5, 5);
INSERT INTO `materiales` VALUES (35965, 1, 'EMP-200', 'EMPAQUE NEOPRENO PARA BRIDA 8\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:29', '2020-10-19 11:07:43', 5, 5);
INSERT INTO `materiales` VALUES (11815, 1, 'C-038', 'EMPAQUE P/VIDRIO ROLLO 10 KG', 796, 'CANCELERIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:29', '2020-10-19 11:07:43', 5, 5);
INSERT INTO `materiales` VALUES (12777, 1, 'O-191', 'EMPLAYE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:29', '2020-10-19 11:07:43', 5, 5);
INSERT INTO `materiales` VALUES (13468, 1, 'H-605/ACI', 'EMPOTRADO CRISTAL TRANSP C7VINIL BASE FIBRA 50W 12VEXN50 ACERO INOX', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:29', '2020-10-19 11:07:44', 5, 5);
INSERT INTO `materiales` VALUES (13150, 1, 'EU-076', 'EMPOTRADO LED OREMBURGO II  LTLLED-3140-2', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:29', '2020-10-19 11:07:44', 5, 5);
INSERT INTO `materiales` VALUES (13378, 1, '0-320', 'ENCINO ROJO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:29', '2020-10-19 11:07:44', 5, 5);
INSERT INTO `materiales` VALUES (11465, 1, 'ADM-003', 'ENERGIA ELECTRICA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:30', '2020-10-19 11:07:44', 5, 5);
INSERT INTO `materiales` VALUES (26031, 1, 'MO-106', 'ENRASADORES', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:30', '2020-10-19 11:07:44', 5, 5);
INSERT INTO `materiales` VALUES (13054, 1, 'O-300', 'ENTREPAÑO DE  40 X 83.5 CM CAL 24 CON VIGA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:30', '2020-10-19 11:07:44', 5, 5);
INSERT INTO `materiales` VALUES (34479, 1, 'ENV-100', 'ENVASE ANATOMICO DE 1 LTO.', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:30', '2020-10-19 11:07:45', 5, 5);
INSERT INTO `materiales` VALUES (34643, 1, 'ENV-D00', 'ENVIO DOCUMENTOS', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:30', '2020-10-19 11:07:45', 5, 5);
INSERT INTO `materiales` VALUES (13186, 1, '0-279', 'ENVIO PAQUETERIA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:45', 5, 5);
INSERT INTO `materiales` VALUES (13099, 1, 'A-84', 'EPOXACRIL BASE EN AGUA COLOR GRIS', 794, 'ACABADOS', 'GALON', 'GALON', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:45', 5, 5);
INSERT INTO `materiales` VALUES (19397, 1, '', 'EQUIPAMIENTO CASA MUESTRA', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:45', 5, 5);
INSERT INTO `materiales` VALUES (27202, 1, 'EQC-120', 'EQUIPAMIENTO EN MOBILIARIO CASA MUESTRA', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:45', 5, 5);
INSERT INTO `materiales` VALUES (26939, 1, 'EQM-174', 'EQUIPAMIENTO EN MOBILIARIO PARA CASAS MUESTRA - MUEBLES VARIOS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:46', 5, 5);
INSERT INTO `materiales` VALUES (13714, 1, 'TEL-002', 'EQUIPO CELULAR', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:46', 5, 5);
INSERT INTO `materiales` VALUES (27847, 1, 'EQB-103', 'EQUIPO DE BARRA', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:46', 5, 5);
INSERT INTO `materiales` VALUES (27844, 1, 'EQC-100', 'EQUIPO DE COCINA', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:46', 5, 5);
INSERT INTO `materiales` VALUES (27853, 1, 'EQC-105', 'EQUIPO DE CRISTALERIA', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:46', 5, 5);
INSERT INTO `materiales` VALUES (27850, 1, 'EQS-104', 'EQUIPO DE SERVICIO', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:46', 5, 5);
INSERT INTO `materiales` VALUES (13537, 1, '0-341', 'EQUIPO GPS', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:47', 5, 5);
INSERT INTO `materiales` VALUES (20135, 1, 'ESC.01', 'ESCALERA 24 PELDAÑOS 3.6 MTS.', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:31', '2020-10-19 11:07:47', 5, 5);
INSERT INTO `materiales` VALUES (9622, 1, 'ACE-008', 'ESCALERILLA 12-2 AS-.56 CM2 3ML', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:47', 5, 5);
INSERT INTO `materiales` VALUES (13600, 1, 'O-357', 'ESCALONES PARA ESCALERA MARINA DE POZOS DE VISITA', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:47', 5, 5);
INSERT INTO `materiales` VALUES (10578, 1, 'O-004', 'ESCOBA PEÑOLERA (INDUSTRIAL)', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:47', 5, 5);
INSERT INTO `materiales` VALUES (11991, 1, 'O-093', 'ESCOBAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:47', 5, 5);
INSERT INTO `materiales` VALUES (34158, 1, 'ESC-200', 'ESCRITORIO DE 1.80X.60 DE MADERA DE PINO RIGIDO', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:48', 5, 5);
INSERT INTO `materiales` VALUES (12912, 1, 'O-220', 'ESCRITORIO G-CONNECT -DERECHO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:48', 5, 5);
INSERT INTO `materiales` VALUES (12937, 1, 'O-0101', 'ESCRITORIO MODULO OPERATIVO KENZA 1.50X1.50 TWEED PLATINO', 808, 'OTROS', 'PZA', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:48', 5, 5);
INSERT INTO `materiales` VALUES (12275, 1, 'O-125', 'ESCRITURA  PUBLICA DE TRANSMISION', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:48', 5, 5);
INSERT INTO `materiales` VALUES (12456, 1, 'O-148', 'ESCUADRA 16X24', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:48', 5, 5);
INSERT INTO `materiales` VALUES (32194, 1, 'ESC-101', 'ESCUADRA PARA FREGADERO', 792, 'HERRERIA', 'JUEGO', 'JUEGO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:49', 5, 5);
INSERT INTO `materiales` VALUES (29459, 1, 'ESC-100', 'ESCULTURA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:32', '2020-10-19 11:07:49', 5, 5);
INSERT INTO `materiales` VALUES (31243, 1, 'ESM-100', 'ESMERILADORA ANG 4-1/2', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:49', 5, 5);
INSERT INTO `materiales` VALUES (26502, 1, 'ESP-102', 'ESPARRAGO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:49', 5, 5);
INSERT INTO `materiales` VALUES (30834, 1, 'ESP-174', 'ESPATULA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:49', 5, 5);
INSERT INTO `materiales` VALUES (13075, 1, 'P-198', 'ESPEC MARINA BEIGE 20 X 20 PRIMERA', 795, 'PISOS', 'PZAS', 'PZAS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:49', 5, 5);
INSERT INTO `materiales` VALUES (28021, 1, 'ESP-127', 'ESPEJO DE PARED MIXTEPEC 40cm NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:49', 5, 5);
INSERT INTO `materiales` VALUES (27943, 1, 'ESP-100', 'ESPEJO EVO NATURAL', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:50', 5, 5);
INSERT INTO `materiales` VALUES (29426, 1, 'ESP-80', 'ESPEJO MEDIDA 2X1', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:50', 5, 5);
INSERT INTO `materiales` VALUES (29438, 1, 'ESP-202', 'ESPEJO REDONDO HERRERIA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:50', 5, 5);
INSERT INTO `materiales` VALUES (12840, 1, 'EST-085', 'ESTIMACION', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:50', 5, 5);
INSERT INTO `materiales` VALUES (13885, 1, 'EST-091', 'ESTIMACION  AVANCE DE OBRA OFICINA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:50', 5, 5);
INSERT INTO `materiales` VALUES (11192, 1, 'EST-01', 'ESTIMACION 01 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYEMATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:50', 5, 5);
INSERT INTO `materiales` VALUES (10761, 1, 'EST-001', 'ESTIMACION 01 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', 'FACTURA EXCENTA DE IVA EN BASE AL ART. 9 FRACC. II DE LA LEY DEL IVA.', '', 'ACTIVO    ', '2020-10-19 11:02:33', '2020-10-19 11:07:51', 5, 5);
INSERT INTO `materiales` VALUES (11195, 1, 'EST-02', 'ESTIMACION 02 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:51', 5, 5);
INSERT INTO `materiales` VALUES (10765, 1, 'EST-002', 'ESTIMACION 02 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:51', 5, 5);
INSERT INTO `materiales` VALUES (12771, 1, 'EST-084', 'ESTIMACION 03 AVANCE DE OBRA EN FRACC AMPLIACION LAS HUERTAS ETAPA 2', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:52', 5, 5);
INSERT INTO `materiales` VALUES (11198, 1, 'EST-03', 'ESTIMACION 03 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIAL Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:52', 5, 5);
INSERT INTO `materiales` VALUES (10769, 1, 'EST-003', 'ESTIMACION 03 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:52', 5, 5);
INSERT INTO `materiales` VALUES (11201, 1, 'EST-04', 'ESTIMACION 04 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIAL Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:52', 5, 5);
INSERT INTO `materiales` VALUES (10773, 1, 'EST-004', 'ESTIMACION 04 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:52', 5, 5);
INSERT INTO `materiales` VALUES (11204, 1, 'EST-05', 'ESTIMACION 05 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:52', 5, 5);
INSERT INTO `materiales` VALUES (10777, 1, 'EST-005', 'ESTIMACION 05 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:53', 5, 5);
INSERT INTO `materiales` VALUES (11207, 1, 'EST-06', 'ESTIMACION 06 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIAL Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:53', 5, 5);
INSERT INTO `materiales` VALUES (10781, 1, 'EST-006', 'ESTIMACION 06 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:34', '2020-10-19 11:07:53', 5, 5);
INSERT INTO `materiales` VALUES (11326, 1, 'EST-07', 'ESTIMACION 07 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA.INCLUYE MATERIAL Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:53', 5, 5);
INSERT INTO `materiales` VALUES (10828, 1, 'EST-007', 'ESTIMACION 07 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:53', 5, 5);
INSERT INTO `materiales` VALUES (11352, 1, 'EST-08', 'ESTIMACION 08 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:53', 5, 5);
INSERT INTO `materiales` VALUES (10832, 1, 'EST-008', 'ESTIMACION 08 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:54', 5, 5);
INSERT INTO `materiales` VALUES (11355, 1, 'EST-09', 'ESTIMACION 09 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:54', 5, 5);
INSERT INTO `materiales` VALUES (10836, 1, 'EST-009', 'ESTIMACION 09 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:54', 5, 5);
INSERT INTO `materiales` VALUES (13120, 1, 'EST-086', 'ESTIMACION 1 AVANCE EN OBRA AMPLIACION LAS HUERTAS ETAPA 4 INCLUYE MATERIAL Y MANO DE OBRA-ROSENDO', 819, 'ESTIMACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:54', 5, 5);
INSERT INTO `materiales` VALUES (11358, 1, 'EST-10', 'ESTIMACION 10 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:54', 5, 5);
INSERT INTO `materiales` VALUES (10840, 1, 'EST-010', 'ESTIMACION 10 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:55', 5, 5);
INSERT INTO `materiales` VALUES (10844, 1, 'EST-011', 'ESTIMACION 11 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:55', 5, 5);
INSERT INTO `materiales` VALUES (11437, 1, 'EST-11', 'ESTIMACION 11 AVANCE EN OBRA FRACC.RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:35', '2020-10-19 11:07:55', 5, 5);
INSERT INTO `materiales` VALUES (11440, 1, 'EST-12', 'ESTIMACION 12 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:55', 5, 5);
INSERT INTO `materiales` VALUES (11000, 1, 'EST-012', 'ESTIMACION 12 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:55', 5, 5);
INSERT INTO `materiales` VALUES (11443, 1, 'EST-13', 'ESTIMACION 13 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA. ETAPA.INCLUYE MATERIALES Y MANO DE OBRA.', 794, 'ACABADOS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:55', 5, 5);
INSERT INTO `materiales` VALUES (11004, 1, 'EST-013', 'ESTIMACION 13 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:56', 5, 5);
INSERT INTO `materiales` VALUES (12693, 1, 'EST-083', 'ESTIMACION 14 AVANCE DE OBRA EN FRACC AMPLIACION LAS HUERTAS ETAPA 1', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:56', 5, 5);
INSERT INTO `materiales` VALUES (11446, 1, 'EST-14', 'ESTIMACION 14 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ESTAPA. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:56', 5, 5);
INSERT INTO `materiales` VALUES (11008, 1, 'EST-014', 'ESTIMACION 14 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:56', 5, 5);
INSERT INTO `materiales` VALUES (11449, 1, 'EST-15', 'ESTIMACION 15 AVANCE  EN OBRA FRACC. RONCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:56', 5, 5);
INSERT INTO `materiales` VALUES (11012, 1, 'EST-015', 'ESTIMACION 15 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:56', 5, 5);
INSERT INTO `materiales` VALUES (11452, 1, 'EST-16', 'ESTIMACION 16 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:57', 5, 5);
INSERT INTO `materiales` VALUES (11016, 1, 'EST-016', 'ESTIMACION 16 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:57', 5, 5);
INSERT INTO `materiales` VALUES (11462, 1, 'EST-17', 'ESTIMACION 17 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS 2DA ETAPA. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:36', '2020-10-19 11:07:57', 5, 5);
INSERT INTO `materiales` VALUES (11020, 1, 'EST-017', 'ESTIMACION 17 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:57', 5, 5);
INSERT INTO `materiales` VALUES (11024, 1, 'EST-018', 'ESTIMACION 18 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:57', 5, 5);
INSERT INTO `materiales` VALUES (11104, 1, 'EST-019', 'ESTIMACION 19 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:57', 5, 5);
INSERT INTO `materiales` VALUES (13183, 1, 'EST-087', 'ESTIMACION 2 AVANCE EN OBRA AMPLIACION LAS HUERTAS ETAPA 4 INCLUYE MATERIA Y MANO DE OBRA-ROSENDO', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:57', 5, 5);
INSERT INTO `materiales` VALUES (11513, 1, 'EST-020', 'ESTIMACION 20 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:58', 5, 5);
INSERT INTO `materiales` VALUES (11516, 1, 'EST-021', 'ESTIMACION 21 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:58', 5, 5);
INSERT INTO `materiales` VALUES (11519, 1, 'EST-022', 'ESTIMACION 22 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:58', 5, 5);
INSERT INTO `materiales` VALUES (11522, 1, 'EST-023', 'ESTIMACION 23 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:58', 5, 5);
INSERT INTO `materiales` VALUES (11525, 1, 'EST-024', 'ESTIMACION 24 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:58', 5, 5);
INSERT INTO `materiales` VALUES (11528, 1, 'EST-025', 'ESTIMACION 25 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:58', 5, 5);
INSERT INTO `materiales` VALUES (11531, 1, 'EST-026', 'ESTIMACION 26 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:59', 5, 5);
INSERT INTO `materiales` VALUES (11534, 1, 'EST-027', 'ESTIMACION 27 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:37', '2020-10-19 11:07:59', 5, 5);
INSERT INTO `materiales` VALUES (11537, 1, 'EST-028', 'ESTIMACION 28 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:07:59', 5, 5);
INSERT INTO `materiales` VALUES (11540, 1, 'EST-029', 'ESTIMACION 29 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:07:59', 5, 5);
INSERT INTO `materiales` VALUES (11543, 1, 'EST-030', 'ESTIMACION 30 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLLICA', 'NO APLLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:07:59', 5, 5);
INSERT INTO `materiales` VALUES (11562, 1, 'EST-031', 'ESTIMACION 31 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:07:59', 5, 5);
INSERT INTO `materiales` VALUES (11565, 1, 'EST-032', 'ESTIMACION 32 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:08:00', 5, 5);
INSERT INTO `materiales` VALUES (11568, 1, 'EST-033', 'ESTIMACION 33 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:08:00', 5, 5);
INSERT INTO `materiales` VALUES (11571, 1, 'EST-034', 'ESTIMACION 34 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALSE Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:08:00', 5, 5);
INSERT INTO `materiales` VALUES (11574, 1, 'EST-035', 'ESTIMACION 35 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:08:00', 5, 5);
INSERT INTO `materiales` VALUES (11671, 1, 'EST-036', 'ESTIMACION 36 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:08:00', 5, 5);
INSERT INTO `materiales` VALUES (11674, 1, 'EST-037', 'ESTIMACION 37 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:08:00', 5, 5);
INSERT INTO `materiales` VALUES (11677, 1, 'EST-038', 'ESTIMACION 38 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:08:00', 5, 5);
INSERT INTO `materiales` VALUES (11680, 1, 'EST-039', 'ESTIMACION 39 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:08:00', 5, 5);
INSERT INTO `materiales` VALUES (11683, 1, 'EST-040', 'ESTIMACION 40 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:38', '2020-10-19 11:08:01', 5, 5);
INSERT INTO `materiales` VALUES (11728, 1, 'EST-041', 'ESTIMACION 41 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:01', 5, 5);
INSERT INTO `materiales` VALUES (11731, 1, 'EST-042', 'ESTIMACION 42 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OVRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:01', 5, 5);
INSERT INTO `materiales` VALUES (11734, 1, 'EST-043', 'ESTIMACION 43 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:01', 5, 5);
INSERT INTO `materiales` VALUES (11737, 1, 'EST-044', 'ESTIMACION 44 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:01', 5, 5);
INSERT INTO `materiales` VALUES (11740, 1, 'EST-045', 'ESTIMACION 45 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:01', 5, 5);
INSERT INTO `materiales` VALUES (11743, 1, 'EST-046', 'ESTIMACION 46 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO NAPLICA', 'NO NAPLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:01', 5, 5);
INSERT INTO `materiales` VALUES (11746, 1, 'EST-047', 'ESTIMACION 47 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:02', 5, 5);
INSERT INTO `materiales` VALUES (11749, 1, 'EST-048', 'ESTIMACION 48 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:02', 5, 5);
INSERT INTO `materiales` VALUES (11752, 1, 'EST-049', 'ESTIMACION 49 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:02', 5, 5);
INSERT INTO `materiales` VALUES (11755, 1, 'EST-050', 'ESTIMACION 50 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERILAES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:02', 5, 5);
INSERT INTO `materiales` VALUES (11770, 1, 'EST-051', 'ESTIMACION 51 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:02', 5, 5);
INSERT INTO `materiales` VALUES (11773, 1, 'EST-052', 'ESTIMACION 52 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:03', 5, 5);
INSERT INTO `materiales` VALUES (11776, 1, 'EST-053', 'ESTIMACION 53 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:03', 5, 5);
INSERT INTO `materiales` VALUES (11779, 1, 'EST-054', 'ESTIMACION 54 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:39', '2020-10-19 11:08:03', 5, 5);
INSERT INTO `materiales` VALUES (11782, 1, 'EST-055', 'ESTIMACION 55 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:40', '2020-10-19 11:08:03', 5, 5);
INSERT INTO `materiales` VALUES (11849, 1, 'EST-056', 'ESTIMACION 56 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:40', '2020-10-19 11:08:03', 5, 5);
INSERT INTO `materiales` VALUES (11852, 1, 'EST-057', 'ESTIMACION 57 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:40', '2020-10-19 11:08:03', 5, 5);
INSERT INTO `materiales` VALUES (11855, 1, 'EST-058', 'ESTIMACION 58 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERILAES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:40', '2020-10-19 11:08:03', 5, 5);
INSERT INTO `materiales` VALUES (11858, 1, 'EST-059', 'ESTIMACION 59 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:40', '2020-10-19 11:08:03', 5, 5);
INSERT INTO `materiales` VALUES (11861, 1, 'EST-060', 'ESTIMACION 60 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:40', '2020-10-19 11:08:04', 5, 5);
INSERT INTO `materiales` VALUES (11917, 1, 'EST-061', 'ESTIMACION 61 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYR MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO AAPLICA', 'NO AAPLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:40', '2020-10-19 11:08:04', 5, 5);
INSERT INTO `materiales` VALUES (11920, 1, 'EST-062', 'ESTIMACION 62 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:40', '2020-10-19 11:08:04', 5, 5);
INSERT INTO `materiales` VALUES (11923, 1, 'EST-063', 'ESTIMACION 63 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:40', '2020-10-19 11:08:04', 5, 5);
INSERT INTO `materiales` VALUES (11926, 1, 'EST-064', 'ESTIMACION 64 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:40', '2020-10-19 11:08:04', 5, 5);
INSERT INTO `materiales` VALUES (11929, 1, 'EST-065', 'ESTIMACION 65 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:41', '2020-10-19 11:08:04', 5, 5);
INSERT INTO `materiales` VALUES (11932, 1, 'EST-066', 'ESTIMACION 66 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:41', '2020-10-19 11:08:04', 5, 5);
INSERT INTO `materiales` VALUES (11935, 1, 'EST-067', 'ESTIMACION 67 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:41', '2020-10-19 11:08:04', 5, 5);
INSERT INTO `materiales` VALUES (11938, 1, 'EST-068', 'ESTIMACION 68 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:41', '2020-10-19 11:08:05', 5, 5);
INSERT INTO `materiales` VALUES (11941, 1, 'EST-069', 'ESTIMACION 69 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:41', '2020-10-19 11:08:05', 5, 5);
INSERT INTO `materiales` VALUES (11944, 1, 'EST-070', 'ESTIMACION 70 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:41', '2020-10-19 11:08:05', 5, 5);
INSERT INTO `materiales` VALUES (11947, 1, 'EST-071', 'ESTIMACION 71 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:41', '2020-10-19 11:08:05', 5, 5);
INSERT INTO `materiales` VALUES (11950, 1, 'EST-072', 'ESTIMACION 72 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:41', '2020-10-19 11:08:05', 5, 5);
INSERT INTO `materiales` VALUES (11953, 1, 'EST-073', 'ESTIMACION 73 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:05', 5, 5);
INSERT INTO `materiales` VALUES (11956, 1, 'EST-074', 'ESTIMACION 74 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:05', 5, 5);
INSERT INTO `materiales` VALUES (11959, 1, 'EST-075', 'ESTIMACION 75 AVANCE EN OBRA FRACC. RINCON LAS HUERTAS. INCLUYE MATERIALES Y MANO DE OBRA.', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:05', 5, 5);
INSERT INTO `materiales` VALUES (25236, 1, 'EAT-102', 'ESTIMACION ADICIONAL 01 DE TRABAJOS DE URBANIZACION', 806, 'URBANIZACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:06', 5, 5);
INSERT INTO `materiales` VALUES (13879, 1, 'EST-088', 'ESTIMACION AVANCE DE OBRA  ADMON', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:06', 5, 5);
INSERT INTO `materiales` VALUES (13882, 1, 'EST-089', 'ESTIMACION AVANCE DE OBRA ALH 8', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:06', 5, 5);
INSERT INTO `materiales` VALUES (14868, 1, 'EST-096', 'ESTIMACION AVANCE DE OBRA ALH ETAPA 9', 819, 'ESTIMACION', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:06', 5, 5);
INSERT INTO `materiales` VALUES (13777, 1, 'EST-94', 'ESTIMACION AVANCE DE OBRA MATERIALES Y MANO DE OBRA AMPLIACION LAS HUERTAS  ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:06', 5, 5);
INSERT INTO `materiales` VALUES (13774, 1, 'EST-93', 'ESTIMACION AVANCE DE OBRA MATERIALES Y MANO DE OBRA AMPLIACION LAS HUERTAS  ETAPA 6', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:06', 5, 5);
INSERT INTO `materiales` VALUES (13765, 1, 'EST-91', 'ESTIMACION AVANCE DE OBRA MATERIALES Y MANO DE OBRA AMPLIACION LAS HUERTAS  ETAPA 7', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:06', 5, 5);
INSERT INTO `materiales` VALUES (13771, 1, 'EST-92', 'ESTIMACION AVANCE DE OBRA MATERIALES Y MANO DE OBRA AMPLIACION LAS HUERTAS  ETAPA 8', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:06', 5, 5);
INSERT INTO `materiales` VALUES (14862, 1, 'EST-095', 'ESTIMACION AVANCE DE OBRA VENTAS', 819, 'ESTIMACION', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:07', 5, 5);
INSERT INTO `materiales` VALUES (13675, 1, 'EST-090', 'ESTIMACION AVANCE DE URBANIZACION ANTICIPO DE PLATAFORMAS (ampliacion las huertas)', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:42', '2020-10-19 11:08:07', 5, 5);
INSERT INTO `materiales` VALUES (12322, 1, 'EU-033', 'ESTIMACION ELECTRIFICACION ', 785, 'ELECTRIFICACION URB', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:07', 5, 5);
INSERT INTO `materiales` VALUES (13744, 1, 'EST-100', 'ESTIMACION TRABAJO DE URBANIZACION AMPLIACION LAS HUERTAS', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:07', 5, 5);
INSERT INTO `materiales` VALUES (14812, 1, 'EST-097', 'ESTIMACION.', 819, 'ESTIMACION', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:07', 5, 5);
INSERT INTO `materiales` VALUES (11489, 1, 'O-042', 'ESTOPA', 808, 'OTROS', 'KG', 'KG', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:07', 5, 5);
INSERT INTO `materiales` VALUES (9826, 1, 'A-012', 'ESTUCO ADEBLOK CONSTRUCTOR', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:07', 5, 5);
INSERT INTO `materiales` VALUES (29553, 1, 'ESS-100', 'ESTUCO ESTIO', 794, 'ACABADOS', 'SACO', 'SACO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:07', 5, 5);
INSERT INTO `materiales` VALUES (12386, 1, 'A-033', 'ESTUCO PLASTER 40KG', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:08', 5, 5);
INSERT INTO `materiales` VALUES (34279, 1, 'EIA-100', 'ESTUDIO DE IMPACTO AMBIENTAL', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:08', 5, 5);
INSERT INTO `materiales` VALUES (33212, 1, 'ECS-100', 'ESTUDIO DE PANEL COMPLETO  SANGUINEO', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:08', 5, 5);
INSERT INTO `materiales` VALUES (11711, 1, 'O-063', 'ESTUDIO GEOLOGICO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:08', 5, 5);
INSERT INTO `materiales` VALUES (17832, 1, '', 'ESTUDIO MECANICA DE SUELO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:08', 5, 5);
INSERT INTO `materiales` VALUES (11965, 1, 'O-089', 'ESTUDIO Y DEMARCACION TOPOGRAFICA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:08', 5, 5);
INSERT INTO `materiales` VALUES (33658, 1, 'EST-725', 'ESTUFA MABE 30\" SILVER ( SKU 45725 )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:43', '2020-10-19 11:08:08', 5, 5);
INSERT INTO `materiales` VALUES (33664, 1, 'EST-710', 'ESTUFA MABE 4 QUEMADORES GRAFITO ( SKU 49700 )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:08', 5, 5);
INSERT INTO `materiales` VALUES (33661, 1, 'EST-475', 'ESTUFA MABE 6 QUEMADORES NEGRO ( SKU 28475 )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:09', 5, 5);
INSERT INTO `materiales` VALUES (35324, 1, 'ETA-125', 'ETIQUETA ADHES LASER JANEL CARTA C/25', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:09', 5, 5);
INSERT INTO `materiales` VALUES (13258, 1, '0-296', 'ETIQUETA PARA LLAVES', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:09', 5, 5);
INSERT INTO `materiales` VALUES (12867, 1, 'O-210', 'ETIQUETAS PARA SEMBRADOS', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:09', 5, 5);
INSERT INTO `materiales` VALUES (26505, 1, 'EUG-102', 'EUGENIA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:09', 5, 5);
INSERT INTO `materiales` VALUES (12558, 1, 'O-167', 'EVONIMO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:09', 5, 5);
INSERT INTO `materiales` VALUES (15175, 1, 'MO4', 'EX MATERIAL Y MANO DE OBRA', 15165, 'MATERIAL Y MANO DE OBRA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:09', 5, 5);
INSERT INTO `materiales` VALUES (32261, 1, 'EXA-100', 'EXACTO PLASTICO USO RUDO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:10', 5, 5);
INSERT INTO `materiales` VALUES (25600, 1, 'U-015', 'EXCAVACION CON EQUIPO MECANICO EN ZANJA EN MATERIAL TIPO A EN SECO. INCLUYE: AFLOJE, EXTRACCION DE MATERIAL COLOCANDO A UN LADO DE ZANJA', 806, 'URBANIZACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:10', 5, 5);
INSERT INTO `materiales` VALUES (35848, 1, 'EDB-100', 'EXTENCION DE BANDERINES DE COLORES DECORATIVOS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:10', 5, 5);
INSERT INTO `materiales` VALUES (34804, 1, 'EXT-300', 'EXTENCION ELECTRICA USO RUDO 20 MTS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:10', 5, 5);
INSERT INTO `materiales` VALUES (11092, 1, 'H-059', 'EXTENCION FLEXIBLE PARA FREGADERO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:44', '2020-10-19 11:08:10', 5, 5);
INSERT INTO `materiales` VALUES (12106, 1, 'O-110', 'EXTENCION FLEXIBLE PARA LABAVO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:10', 5, 5);
INSERT INTO `materiales` VALUES (13876, 1, 'O-341', 'EXTENSION ITALIANA 2 MTS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:10', 5, 5);
INSERT INTO `materiales` VALUES (25910, 1, 'MV19', 'EXTENSION PARA FLOTA DE MAGNESIO', 25899, 'HERRAMIENTA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:11', 5, 5);
INSERT INTO `materiales` VALUES (31249, 1, 'EXT-100', 'EXTENSION USO RUDO CAL 16 15 MTS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:11', 5, 5);
INSERT INTO `materiales` VALUES (12290, 1, 'O-130', 'EXTINCION DE FIDEICOMISO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:11', 5, 5);
INSERT INTO `materiales` VALUES (34392, 1, 'EXT-200', 'EXTINTOR PQS DE 6kgs.', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:11', 5, 5);
INSERT INTO `materiales` VALUES (13561, 1, 'H-216', 'EXTRACCION DE CORAZONES DE CARPETAS ASFALTICA', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:11', 5, 5);
INSERT INTO `materiales` VALUES (26053, 1, 'MO-113', 'EXTRAS', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:11', 5, 5);
INSERT INTO `materiales` VALUES (12383, 1, 'H-088', 'EXTREMIDAD HIDRAULICA MET.  CAMP. 200MM', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:12', 5, 5);
INSERT INTO `materiales` VALUES (35932, 1, 'EXT-150', 'EXTREMO PVC HID. ING. 150mm C/CAMP. RD-26', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:12', 5, 5);
INSERT INTO `materiales` VALUES (35935, 1, 'EXT-250', 'EXTREMO PVC HID. ING. 150mm C/ESP. RD-26', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:12', 5, 5);
INSERT INTO `materiales` VALUES (24902, 1, 'EE-104', 'Espejo Evo - Natural', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:12', 5, 5);
INSERT INTO `materiales` VALUES (13636, 1, 'CA-047', 'FABRICACION ', 794, 'ACABADOS', 'U', 'U', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:45', '2020-10-19 11:08:12', 5, 5);
INSERT INTO `materiales` VALUES (13762, 1, 'FG-001', 'FABRICACION  E INSTALACION DE CUBIERTAS DE GRANITO ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:12', 5, 5);
INSERT INTO `materiales` VALUES (27084, 1, 'FBC-102', 'FABRICACION DE BANCAS DE MARMOL BLANCO CARRARA DE 1.20 DE LARGO POR 40CM DE', 794, 'ACABADOS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:13', 5, 5);
INSERT INTO `materiales` VALUES (13342, 1, 'E-084', 'FABRICACION DE CIMBRA  P/LA ELABORACION DE SOPORTE DE CONCRETO', 791, 'ELECTRIFICACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:13', 5, 5);
INSERT INTO `materiales` VALUES (27087, 1, 'FCB-103', 'FABRICACION DE CUBIERTA DE BARRA DE SERVICIO DE GRANITO NEGRO SAN GABRIEL', 794, 'ACABADOS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:13', 5, 5);
INSERT INTO `materiales` VALUES (33125, 1, 'FEM-100', 'FABRICACION DE ESTRUCTURA METALICA DE PE RFIL Y LAMINA DE 1X4 INC. VALLA PARA INSTALACION DE LONA', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:14', 5, 5);
INSERT INTO `materiales` VALUES (13588, 1, 'E-089', 'FABRICACION DE MARCO PARA REGISTRO SANITARIO DE 60X40 CON JALADERA ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:14', 5, 5);
INSERT INTO `materiales` VALUES (13339, 1, 'E-083', 'FABRICACION DE MOLDES P/LA ELABORACION DE MURETES ELECTRICOS', 791, 'ELECTRIFICACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:14', 5, 5);
INSERT INTO `materiales` VALUES (23421, 1, 'RE-001', 'FABRICACION DE REMOLQUE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:14', 5, 5);
INSERT INTO `materiales` VALUES (12067, 1, 'O-106', 'FABRICACION DE TECHUMBRE', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:14', 5, 5);
INSERT INTO `materiales` VALUES (13597, 1, 'HE-022', 'FABRICACION E INSTALACION DE DESCANSO DE ESCALERA', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:14', 5, 5);
INSERT INTO `materiales` VALUES (12567, 1, 'HE-017', 'FABRICACION E INSTALACION DE LOGOTIPO ', 792, 'HERRERIA', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:15', 5, 5);
INSERT INTO `materiales` VALUES (11505, 1, 'HE-007', 'FABRICACION E INSTALACION DE PUENTE DE ACCESO VEHICULAR Y PEATONAL', 792, 'HERRERIA', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:15', 5, 5);
INSERT INTO `materiales` VALUES (27081, 1, 'FLG-102', 'FABRICACION E ISNTALACION DE LAMBRIN DE GRANITO AMORI EN MURO Y CUBIERTA', 794, 'ACABADOS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:15', 5, 5);
INSERT INTO `materiales` VALUES (25733, 1, 'DAP-105', 'FABRICACION PARA 3 DADOS PARA ANUNCIOS PALETA CON PLACA QUE LLEVARA VARILLA LISA DE 3/4 CON MEDIDA DE .70CM CON ESCUADRA DE 15 CM Y UNA VARILLA DE TRANSROSCADA DE 3/4 CON 2 TUERCAS Y GUASA DE PRESION', 792, 'HERRERIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:46', '2020-10-19 11:08:15', 5, 5);
INSERT INTO `materiales` VALUES (30937, 1, '', 'FABULOSO 20 LTS', 803, 'EXTRAS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:15', 5, 5);
INSERT INTO `materiales` VALUES (21505, 1, 'FAC-01', 'FACTIBILIDADES', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:15', 5, 5);
INSERT INTO `materiales` VALUES (27351, 1, 'FRP-100', 'FAROL PIÑA ESPEJO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:15', 5, 5);
INSERT INTO `materiales` VALUES (27427, 1, 'FAT-149', 'FAROL TRIANGULAR', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:15', 5, 5);
INSERT INTO `materiales` VALUES (13897, 1, 'O-345', 'FELPA MEDIANA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:16', 5, 5);
INSERT INTO `materiales` VALUES (13894, 1, 'O-344', 'FELPA PACHONA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:16', 5, 5);
INSERT INTO `materiales` VALUES (13630, 1, 'T-030', 'FELPAS LIAS', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:16', 5, 5);
INSERT INTO `materiales` VALUES (26025, 1, 'MO-104', 'FIERRERO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:16', 5, 5);
INSERT INTO `materiales` VALUES (30493, 1, 'CG2-108', 'FIJO Med. .58 x 1.80, Aluminio G2 SIN PROTECCIONES   Perfil 1 1/2¨. Cristal 3 mm. ESCALERA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:16', 5, 5);
INSERT INTO `materiales` VALUES (26628, 1, 'CG2-08', 'FIJO Med. .58 x 1.83, Aluminio G2 SIN PROTECCIONES   Perfil 1 1/2¨. Cristal 3 mm. ESCALERA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:16', 5, 5);
INSERT INTO `materiales` VALUES (31926, 1, 'VEN-2', 'FIJO Med. .60 x 1.85  Aluminio G2    Perfil 1 1/2¨. Cristal 3 mm. ESCALERA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:16', 5, 5);
INSERT INTO `materiales` VALUES (33329, 1, 'CON-6', 'FIJO Med. .60 x 1.85, Aluminio G2 SIN PROTECCIONES   Perfil 1 1/2¨. Cristal 3 mm. ESCALERA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:17', 5, 5);
INSERT INTO `materiales` VALUES (32019, 1, 'MES-2', 'FIJO Med. 35 x4.1 cms, Aluminio EN G2   Perfil 1 1/2¨. Cristal Tapiz  3 mm.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:47', '2020-10-19 11:08:17', 5, 5);
INSERT INTO `materiales` VALUES (12606, 1, 'EST-076', 'FINIQUITO A ESTIMACION 01,02,03 Y 06 AVANCE DE OBRA INCLUYE MATERIAL Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:17', 5, 5);
INSERT INTO `materiales` VALUES (12609, 1, 'EST-077', 'FINIQUITO A ESTIMACION 12,15 Y 17AVANCE EN OBRA INCLUYE MATERIAL Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:17', 5, 5);
INSERT INTO `materiales` VALUES (12612, 1, 'EST-078', 'FINIQUITO A ESTIMACION 21,22 Y 24 AVANCE EN OBRA INCLUYE MATERIAL Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:17', 5, 5);
INSERT INTO `materiales` VALUES (12615, 1, 'EST-079', 'FINIQUITO A ESTIMACION 32,35 Y 36 AVANCE EN OBRA INCLUYE MATERIAL Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:17', 5, 5);
INSERT INTO `materiales` VALUES (12618, 1, 'EST-080', 'FINIQUITO A ESTIMACION 37 Y 38 AVANCE EN OBRA INCLUYE MATERIAL Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:17', 5, 5);
INSERT INTO `materiales` VALUES (12621, 1, 'EST-081', 'FINIQUITO A ESTIMACION 48,49 Y 51 AVANCE EN OBRA INCLUYE MATERIAL Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:17', 5, 5);
INSERT INTO `materiales` VALUES (12624, 1, 'EST-082', 'FINIQUITO A ESTIMACION 52,53,54 Y 57 AVANCE EN OBRA INCLUYE MATERIAL Y MANO DE OBRA', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:18', 5, 5);
INSERT INTO `materiales` VALUES (32816, 1, 'FLI-100', 'FLAYER IMPRESO EN  VINIL ROTULADO SOBRE COROPLAST', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:18', 5, 5);
INSERT INTO `materiales` VALUES (11180, 1, 'V-005', 'FLETE', 817, 'VIAJES', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:18', 5, 5);
INSERT INTO `materiales` VALUES (30828, 1, 'FLX-185', 'FLEXOMETRO DE 8 MTS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:18', 5, 5);
INSERT INTO `materiales` VALUES (25913, 1, 'MV20', 'FLOTA DE MAGNESIO PARA AVION', 25899, 'HERRAMIENTA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:18', 5, 5);
INSERT INTO `materiales` VALUES (31231, 1, 'FLT-100', 'FLOTA ESPONJA FLOTA PRETUL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:18', 5, 5);
INSERT INTO `materiales` VALUES (11614, 1, 'H-077', 'FLOTADOR ELECTRICO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:48', '2020-10-19 11:08:18', 5, 5);
INSERT INTO `materiales` VALUES (12099, 1, '108', 'FLOTADOR PLASTICO CON VARILLA P/ CISTERNA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:19', 5, 5);
INSERT INTO `materiales` VALUES (12049, 1, 'EU-031', 'FOCO ADITIVO METALICO ESTANDAR ED28 250W 4200° BASE E39 SLI', 785, 'ELECTRIFICACION URB', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:19', 5, 5);
INSERT INTO `materiales` VALUES (10094, 1, 'T-005', 'FOCO AHORRADOR 13 W MARCA PRETUL', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:19', 5, 5);
INSERT INTO `materiales` VALUES (13357, 1, 'T-029', 'FOCO AHORRADOR 15 W MARCA PRETUL', 801, 'ECOTECNOLOGIAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:19', 5, 5);
INSERT INTO `materiales` VALUES (10090, 1, 'T-004', 'FOCO AHORRADOR 20 W MARCA PRETUL', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:19', 5, 5);
INSERT INTO `materiales` VALUES (12225, 1, 'T-014', 'FOCO AHORRADOR 4 \"U\" EN 36 WATTS EN 6500K TECNOLITE', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:19', 5, 5);
INSERT INTO `materiales` VALUES (13489, 1, 'CE-36W/65', 'FOCO AHORRADOR 4 U 36W', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:19', 5, 5);
INSERT INTO `materiales` VALUES (18916, 1, '', 'FOCO ESPRAL 15 WATTS. E26 127 VOLTS LUZ DIA T2', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:19', 5, 5);
INSERT INTO `materiales` VALUES (18859, 1, '', 'FOCO GLOBO LED OPALINO DE 11 WATTS E26 127', 800, 'ACCESORIOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:20', 5, 5);
INSERT INTO `materiales` VALUES (13690, 1, 'E-0087', 'FOCO LED   LA-315 P-4W', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:20', 5, 5);
INSERT INTO `materiales` VALUES (12229, 1, 'T-015', 'FOCO LED 10 WATTS', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:20', 5, 5);
INSERT INTO `materiales` VALUES (10098, 1, 'T-006', 'FOCO LED E26 3.5 W', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:20', 5, 5);
INSERT INTO `materiales` VALUES (13555, 1, 'EU-083', 'FOCO LED VELA E12', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:20', 5, 5);
INSERT INTO `materiales` VALUES (13156, 1, 'T-027', 'FOCO LUZ CALIDA AMARILLA', 801, 'ECOTECNOLOGIAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:20', 5, 5);
INSERT INTO `materiales` VALUES (13471, 1, 'MR16-SMDLED/3W', 'FOCO MR16 LED 3W 6500K 100-172V TECNO', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:49', '2020-10-19 11:08:20', 5, 5);
INSERT INTO `materiales` VALUES (18857, 1, '', 'FOCO MR196 LED 3W 6500K 100-127V TECNOLITE', 800, 'ACCESORIOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:21', 5, 5);
INSERT INTO `materiales` VALUES (18630, 1, 'EU-102', 'FOCO MT16 LED 3W 6500K 100-127V TECNOLITE', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:21', 5, 5);
INSERT INTO `materiales` VALUES (18914, 1, '', 'FOCO REFLECTOR PAR20 LED DE 6 WATS', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:21', 5, 5);
INSERT INTO `materiales` VALUES (12501, 1, 'EU-037', 'FOCO TIPO PAR20 DE 4 WATTS EN 3000', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:21', 5, 5);
INSERT INTO `materiales` VALUES (12344, 1, 'O-135', 'FOLDER PORTADOCUMENTOS CLIP', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:21', 5, 5);
INSERT INTO `materiales` VALUES (12633, 1, 'O-181', 'FOLDER PRESENTACION TC 2DIV PZ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:21', 5, 5);
INSERT INTO `materiales` VALUES (12636, 1, 'O-172', 'FOLDER PRESENTACION TC 4DIV ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:21', 5, 5);
INSERT INTO `materiales` VALUES (12516, 1, 'O-154', 'FOLDER TAMAÑO CARTA', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:21', 5, 5);
INSERT INTO `materiales` VALUES (12022, 1, 'O-102', 'FOLDER TAMAÑO OFICIO', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:22', 5, 5);
INSERT INTO `materiales` VALUES (31049, 1, 'FOL-100', 'FOLIADOR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:22', 5, 5);
INSERT INTO `materiales` VALUES (11164, 1, 'O-028', 'FORNIOS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:22', 5, 5);
INSERT INTO `materiales` VALUES (31657, 1, 'FRB-100', 'FRANELA 50cm BLANCA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:22', 5, 5);
INSERT INTO `materiales` VALUES (13726, 1, 'F-100', 'FREGADERO SENCILLO 49X47 CM', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:22', 5, 5);
INSERT INTO `materiales` VALUES (12540, 1, 'O-161', 'FRESNO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:50', '2020-10-19 11:08:22', 5, 5);
INSERT INTO `materiales` VALUES (26242, 1, 'FRS-100', 'FRESNO COMUN', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:22', 5, 5);
INSERT INTO `materiales` VALUES (13519, 1, 'O-370', 'FUMIGACION ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:23', 5, 5);
INSERT INTO `materiales` VALUES (36701, 1, '', 'FUNDA APPLE IPHONE 11 PRO MAX', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:23', 5, 5);
INSERT INTO `materiales` VALUES (36686, 1, '', 'FUNDA HP 15 CARRY NEGRAGRIS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:23', 5, 5);
INSERT INTO `materiales` VALUES (26311, 1, 'FUS-10', 'FUSION DE LAS PARCELAS 72 POLIGONO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:23', 5, 5);
INSERT INTO `materiales` VALUES (12807, 1, 'T-016', 'Foco ahorrador doble 15w ldd 81884 neolux osram', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:23', 5, 5);
INSERT INTO `materiales` VALUES (12810, 1, 'T-017', 'Foco ahorrador triple 23w ldd 81402 neolux osram', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:23', 5, 5);
INSERT INTO `materiales` VALUES (31642, 1, 'GAB-101', 'GABINETE 2  PTAS NEGRO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:23', 5, 5);
INSERT INTO `materiales` VALUES (29259, 1, 'GAB-100', 'GABINETE A PRUEBA DE VAPOR DE 2X3', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:23', 5, 5);
INSERT INTO `materiales` VALUES (20173, 1, 'GRR', 'GABRIELA RAMOS RIOS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:24', 5, 5);
INSERT INTO `materiales` VALUES (10872, 1, 'S-033', 'GANCHO DOBLE VERTIKA CROMO 16106', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:51', '2020-10-19 11:08:24', 5, 5);
INSERT INTO `materiales` VALUES (13063, 1, 'O-303', 'GANCHOS DE 20 CM', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:52', '2020-10-19 11:08:24', 5, 5);
INSERT INTO `materiales` VALUES (11552, 1, 'O-048', 'GASOLINA', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:52', '2020-10-19 11:08:25', 5, 5);
INSERT INTO `materiales` VALUES (23381, 1, 'GT-01', 'GASTOS VARIOS', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:52', '2020-10-19 11:08:25', 5, 5);
INSERT INTO `materiales` VALUES (33911, 1, 'GLS-500', 'GEL SANITIZANTE A BASE DE SALES', 808, 'OTROS', 'GALON', 'GALON', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:52', '2020-10-19 11:08:25', 5, 5);
INSERT INTO `materiales` VALUES (12233, 1, 'O-112', 'GENERACION DE CFDI', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:52', '2020-10-19 11:08:25', 5, 5);
INSERT INTO `materiales` VALUES (31089, 1, 'GNG-100', 'GENERADOR ELECTRICO A GASOLINA PRETUL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:52', '2020-10-19 11:08:26', 5, 5);
INSERT INTO `materiales` VALUES (26257, 1, 'GER-100', 'GERANIO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:52', '2020-10-19 11:08:26', 5, 5);
INSERT INTO `materiales` VALUES (33816, 1, 'GOM-100', 'GOMA ALIMENTACION HP 2035', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:52', '2020-10-19 11:08:26', 5, 5);
INSERT INTO `materiales` VALUES (9814, 1, 'A-009', 'GRANO TEXTU REAL SACO DE 40 KG', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:52', '2020-10-19 11:08:26', 5, 5);
INSERT INTO `materiales` VALUES (11667, 1, 'O-060', 'GRAPADORA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:26', 5, 5);
INSERT INTO `materiales` VALUES (13399, 1, '0-325', 'GRAPADORA DE CLAVO  A 2 DE LARGO CAL. 18', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:26', 5, 5);
INSERT INTO `materiales` VALUES (12507, 1, 'O-151', 'GRAPAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:26', 5, 5);
INSERT INTO `materiales` VALUES (11345, 1, 'O-084', 'GRAVA', 808, 'OTROS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:26', 5, 5);
INSERT INTO `materiales` VALUES (27478, 1, 'GRA-085', 'GRAVA ROJA', 794, 'ACABADOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:27', 5, 5);
INSERT INTO `materiales` VALUES (10611, 1, 'A-018', 'GROUTEX NM', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:27', 5, 5);
INSERT INTO `materiales` VALUES (30825, 1, 'GUA-210', 'GUANTE D/CAUCHO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:27', 5, 5);
INSERT INTO `materiales` VALUES (31336, 1, 'GTN-100', 'GUANTE NYLON NITRILO ESPUMADO GRANGUX', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:27', 5, 5);
INSERT INTO `materiales` VALUES (33722, 1, 'GUA-100', 'GUANTES DE CARNAZA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:27', 5, 5);
INSERT INTO `materiales` VALUES (33725, 1, 'GUI-100', 'GUANTES P/IMPER', 794, 'ACABADOS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:27', 5, 5);
INSERT INTO `materiales` VALUES (33094, 1, 'HIL-100', 'H/D GUKKS 8 KG', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:27', 5, 5);
INSERT INTO `materiales` VALUES (23055, 1, 'HAB-01', 'HABITABILIDAD', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:27', 5, 5);
INSERT INTO `materiales` VALUES (12075, 1, 'A-030', 'HABITAT SMOKE 40 X 60 PRIMERA', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:53', '2020-10-19 11:08:28', 5, 5);
INSERT INTO `materiales` VALUES (29988, 1, 'HEL-100', 'HELECHO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:28', 5, 5);
INSERT INTO `materiales` VALUES (34627, 1, 'K00-297', 'HERB FAENA FTE 360 LTO. MONSANTO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:28', 5, 5);
INSERT INTO `materiales` VALUES (29253, 1, 'HERB-100', 'HERBICIDA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:28', 5, 5);
INSERT INTO `materiales` VALUES (12931, 1, 'T-023', 'HIDRO AUTOMATICO Y COMP', 801, 'ECOTECNOLOGIAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:28', 5, 5);
INSERT INTO `materiales` VALUES (11413, 1, 'AC-019', 'HIDRONEUMATICO DE 16 GALONES', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:28', 5, 5);
INSERT INTO `materiales` VALUES (12395, 1, 'AC-021', 'HIDRONEUMATICO TANQUE 24LT BOMBA 1/2HP PERIF SH60T PUMPS', 800, 'ACCESORIOS', 'Pieza', 'Pieza', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:28', 5, 5);
INSERT INTO `materiales` VALUES (26019, 1, 'MO-102', 'HIDROSANITARIA', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:29', 5, 5);
INSERT INTO `materiales` VALUES (35419, 1, 'HIL-105', 'HILO CRUCETA  PARA DESBROZADORA HTR-105 TRUPPER', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:29', 5, 5);
INSERT INTO `materiales` VALUES (20177, 1, 'HRO', 'HIPOLITO REYES ORONA', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:29', 5, 5);
INSERT INTO `materiales` VALUES (13912, 1, 'O-350', 'HOJA PARA RESANE CHICA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:29', 5, 5);
INSERT INTO `materiales` VALUES (13909, 1, 'O-349', 'HOJA PARA RESANE GDE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:29', 5, 5);
INSERT INTO `materiales` VALUES (11659, 1, 'O-058', 'HOJAS TAMAÑO CARTA', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:29', 5, 5);
INSERT INTO `materiales` VALUES (12513, 1, 'O-153', 'HOJAS TAMAÑO OFICIO', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:54', '2020-10-19 11:08:29', 5, 5);
INSERT INTO `materiales` VALUES (25524, 1, 'U-009', 'HOMOGENIZACION DE TERRENO NATURAL EN UNA CAPA DE 20CM DE ESPESOR PROMEDIO, INCLUYE HUMECTACION, MEZCLADO, TENDIDO Y COMPACTADO AL 90% DE SU PVSM', 806, 'URBANIZACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:29', 5, 5);
INSERT INTO `materiales` VALUES (22138, 1, 'H-1', 'HONORARIOS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:30', 5, 5);
INSERT INTO `materiales` VALUES (25381, 1, 'HON-124', 'HONORARIOS FIDUCARIOS POR ACEPTACION DEL FIDEICOMISO DENOMIANDO ARBOLEDAS', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:30', 5, 5);
INSERT INTO `materiales` VALUES (25371, 1, 'HON-121', 'HONORARIOS FIDUCARIOS POR ACEPTACION DEL FIDEICOMISO DENOMIANDO LAS MISIONES MIRAVALLE', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:30', 5, 5);
INSERT INTO `materiales` VALUES (25384, 1, 'HON-123', 'HONORARIOS FIDUCIARIOS POR ADMINISTRACION DEL FIDEICOMISO DENOMIDADO AROLEDAS CORRESPONDIENTE AL PERIODO DEL 2 DE MAYO AL 1 DE MAYO DEL 2020', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:30', 5, 5);
INSERT INTO `materiales` VALUES (25374, 1, 'HON-125', 'HONORARIOS FIDUCIARIOS POR ADMINISTRACION DEL FIDEICOMISO DENOMINADO LAS MISIONES MIRAVALLE CORRESPONDIENTE AL PERIODO DEL 2 DE MAYO DEL 2019 AL 01 01 DE MAYO DEL 2020', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:30', 5, 5);
INSERT INTO `materiales` VALUES (9593, 1, 'ADM-001', 'HONORARIOS PROFESIONALES', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:30', 5, 5);
INSERT INTO `materiales` VALUES (33215, 1, 'HOS-100', 'HOSPITALIZACION', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:30', 5, 5);
INSERT INTO `materiales` VALUES (12018, 1, 'O-099', 'HOSTING PERSONAL', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:30', 5, 5);
INSERT INTO `materiales` VALUES (18947, 1, 'HULE NE-01', 'HULE NEGRO', 808, 'OTROS', 'KG', 'KG', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:31', 5, 5);
INSERT INTO `materiales` VALUES (31714, 1, 'IGM-100', 'IGUALA MENSUAL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:31', 5, 5);
INSERT INTO `materiales` VALUES (32487, 1, 'IMD-100', 'IMANES IMPRESION ALTA DEFINICION 9X5 CAL 15', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:31', 5, 5);
INSERT INTO `materiales` VALUES (21389, 1, 'IA-10', 'IMPACTO AMBIENTAL', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:31', 5, 5);
INSERT INTO `materiales` VALUES (13627, 1, 'I-004', 'IMPERMEABILIZACION', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:55', '2020-10-19 11:08:31', 5, 5);
INSERT INTO `materiales` VALUES (10542, 1, 'I-001', 'IMPERMEABILIZACION GARANTIA DE 5 AÑOS', 816, 'IMPERMEABILIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:32', 5, 5);
INSERT INTO `materiales` VALUES (33307, 1, 'IMP-300', 'IMPERMEABILIZANTE BASE AGUA NEGRO DIABLO ROJO', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:32', 5, 5);
INSERT INTO `materiales` VALUES (33122, 1, 'IMP-100', 'IMPERMEABILIZANTE IMPERCOOL 5AÑOS', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:32', 5, 5);
INSERT INTO `materiales` VALUES (10546, 1, 'I-002', 'IMPERMEABILIZANTE MARCA IMPAC 5000', 816, 'IMPERMEABILIZACION', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:32', 5, 5);
INSERT INTO `materiales` VALUES (33935, 1, 'IMP-200', 'IMPRESION DE VOLANRES A COLOR FULL COLOR HD EN PAPEL COUCHE DE 120grs', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:32', 5, 5);
INSERT INTO `materiales` VALUES (33404, 1, 'IML-150', 'IMPRESION E INSTALACION DE LONA 2X1 EN BASTIDORES', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:33', 5, 5);
INSERT INTO `materiales` VALUES (33398, 1, 'IMG-150', 'IMPRESION EN GORRAS SUBLIMADAS FULL COLOR', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:33', 5, 5);
INSERT INTO `materiales` VALUES (33395, 1, 'IMP-150', 'IMPRESION EN SERIGRAFIA EN PLAYERA AMBOS LADOS ( 2 DISEÑOS 3 TINTAS )', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:33', 5, 5);
INSERT INTO `materiales` VALUES (33401, 1, 'IMT-150', 'IMPRESION EN TERMO 3 COLORES SERIGRAFIA Y VINIL', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:33', 5, 5);
INSERT INTO `materiales` VALUES (33455, 1, 'IMP-2108', 'IMPRESORA DE TARJETAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:34', 5, 5);
INSERT INTO `materiales` VALUES (11843, 1, 'O-068', 'IMPRESORA HP DESING JET T120 24-IN EPRINTER', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:34', 5, 5);
INSERT INTO `materiales` VALUES (12846, 1, 'O-203', 'IMPRESORA MULTIFUNCIONAL CANon d1320', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:34', 5, 5);
INSERT INTO `materiales` VALUES (25592, 1, 'O-281', 'IMPUESTOS FEDERALES', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:34', 5, 5);
INSERT INTO `materiales` VALUES (18151, 1, 'O-001', 'IMPUESTOS Y DERECHOS MUNICIPALES', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:56', '2020-10-19 11:08:35', 5, 5);
INSERT INTO `materiales` VALUES (13816, 1, 'IN-001', 'IN.STRT.GRIG.192.1001.1', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:35', 5, 5);
INSERT INTO `materiales` VALUES (20145, 1, 'INFONAVIT', 'INFONAVIT', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:35', 5, 5);
INSERT INTO `materiales` VALUES (21110, 1, 'INF-TRAB', 'INFONAVIT TRABAJADOR', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:35', 5, 5);
INSERT INTO `materiales` VALUES (10860, 1, 'S-030', 'INODORO ONE PIECE TWIST BLANCO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:36', 5, 5);
INSERT INTO `materiales` VALUES (24720, 1, 'IPC-101', 'INSCRIPCION AL PADRON CATASTRAL', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:36', 5, 5);
INSERT INTO `materiales` VALUES (27748, 1, 'INS-100', 'INSCRIPCION DE AUTORIZACION DE FRACC. DE TERRENOS POR C/LOTE', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:36', 5, 5);
INSERT INTO `materiales` VALUES (34624, 1, 'K02-062', 'INSECT FIBROTERM 250 ML QUIMIX', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:37', 5, 5);
INSERT INTO `materiales` VALUES (24213, 1, 'ISB-001', 'INSTALACION', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:37', 5, 5);
INSERT INTO `materiales` VALUES (26551, 1, 'INST-153', 'INSTALACION DE AIRE LAVADO 4800 PCM INC. REJILLA Y CODO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:37', 5, 5);
INSERT INTO `materiales` VALUES (10976, 1, 'O-016', 'INSTALACION DE ANUNCIOS', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:37', 5, 5);
INSERT INTO `materiales` VALUES (13132, 1, 'T-026', 'INSTALACION DE CALENTADOR', 801, 'ECOTECNOLOGIAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:37', 5, 5);
INSERT INTO `materiales` VALUES (12059, 1, 'O-104', 'INSTALACION DE CAMARAS', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:37', 5, 5);
INSERT INTO `materiales` VALUES (10956, 1, 'O-014', 'INSTALACION DE CANCELERIA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:57', '2020-10-19 11:08:38', 5, 5);
INSERT INTO `materiales` VALUES (13360, 1, '0-314', 'INSTALACION DE DIFUSORES', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:38', 5, 5);
INSERT INTO `materiales` VALUES (10996, 1, 'O-018', 'INSTALACION DE ESTRUCTURA METALICA CON MOSQUITEROS ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:38', 5, 5);
INSERT INTO `materiales` VALUES (12038, 1, 'HE-009', 'INSTALACION DE LAMINA EN OFICINA MOVIL', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:38', 5, 5);
INSERT INTO `materiales` VALUES (13534, 1, '0-372', 'INSTALACION DE LINEA TELEFONICA ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:38', 5, 5);
INSERT INTO `materiales` VALUES (12423, 1, 'PUBLI-008', 'INSTALACION DE LONAS', 804, 'PUBLICIDAD', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:38', 5, 5);
INSERT INTO `materiales` VALUES (29561, 1, 'INS-150', 'INSTALACION DE MOSQUITEROS', 794, 'ACABADOS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:38', 5, 5);
INSERT INTO `materiales` VALUES (23752, 1, 'INS-01', 'INSTALACION DE PUERTAS Y VENTANAS', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:38', 5, 5);
INSERT INTO `materiales` VALUES (12408, 1, 'CA-036', 'INSTALACION DE VENTANERIA LOTE', 796, 'CANCELERIA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:39', 5, 5);
INSERT INTO `materiales` VALUES (13366, 1, '0-316', 'INSTALACION ELECTRICA P/ALIMENTACION DE LOS MINISPLIT', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:39', 5, 5);
INSERT INTO `materiales` VALUES (13363, 1, '0-315', 'INSTALACION MINI SPLIT ', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:39', 5, 5);
INSERT INTO `materiales` VALUES (13216, 1, '0-288', 'INSTALACION Y CONFIGURACIO  DE IMPRESORA EN RED', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:39', 5, 5);
INSERT INTO `materiales` VALUES (25311, 1, 'INST-102', 'INSTALACION Y DESMANTELAMIENTO DE PERFORADORA', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:39', 5, 5);
INSERT INTO `materiales` VALUES (31461, 1, 'ISN-200', 'INSTALACION Y RETIRADA DE VINIL', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:39', 5, 5);
INSERT INTO `materiales` VALUES (10992, 1, 'O-017', 'INSTALCION DE COCHERA ELECTRICA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:58', '2020-10-19 11:08:39', 5, 5);
INSERT INTO `materiales` VALUES (28525, 1, 'INT-100', 'INTERCONEXION A LINEA EXISTENTE DE AGUA POTABLE', 806, 'URBANIZACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:39', 5, 5);
INSERT INTO `materiales` VALUES (25620, 1, 'U-023', 'INTERCONEXION A LINEA EXISTENTE DE DRENAJE', 806, 'URBANIZACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:40', 5, 5);
INSERT INTO `materiales` VALUES (21444, 1, '', 'INTERESES P.134', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:40', 5, 5);
INSERT INTO `materiales` VALUES (13858, 1, 'IN-100', 'INTERGLASS MURANO LIGHT GREEN ', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:40', 5, 5);
INSERT INTO `materiales` VALUES (13333, 1, 'E-082', 'INTERRUPTOR DE PRECION P/ HIDRONEUMATICO', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:40', 5, 5);
INSERT INTO `materiales` VALUES (10737, 1, 'E-040', 'INTERRUPTOR TERMIMAGNETICO DE 20 AMP.', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:40', 5, 5);
INSERT INTO `materiales` VALUES (10430, 1, 'EU-027', 'INTERRUPTOR TERMOMAGNETICO DE 20 AMPERES MARCA BTPLUG', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:40', 5, 5);
INSERT INTO `materiales` VALUES (10741, 1, 'E-041', 'INTERRUPTOR TERMOMAGNETICO DE 2X20 AMP', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:40', 5, 5);
INSERT INTO `materiales` VALUES (36703, 1, '', 'IPHONE 11 PRO MAX 256GB ORO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:41', 5, 5);
INSERT INTO `materiales` VALUES (23932, 1, 'IPM-01', 'ISR PERSONAS MORALES', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:41', 5, 5);
INSERT INTO `materiales` VALUES (34323, 1, '', 'ISR RETENCION POR ASIMILADOS A SALARIOS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:41', 5, 5);
INSERT INTO `materiales` VALUES (23929, 1, 'ISR-01', 'ISR RETENCIONES POR SALARIOS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:41', 5, 5);
INSERT INTO `materiales` VALUES (14815, 1, 'EST-098', 'IVA ACREDITABLE', 819, 'ESTIMACION', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:41', 5, 5);
INSERT INTO `materiales` VALUES (34327, 1, '', 'IVA RETENCION 10.67%', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:02:59', '2020-10-19 11:08:41', 5, 5);
INSERT INTO `materiales` VALUES (34325, 1, '', 'IVA RETENCIONES 4%', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:41', 5, 5);
INSERT INTO `materiales` VALUES (31449, 1, 'JAB-100', 'JABON LIQUIDO PARA TRASTES', 803, 'EXTRAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:42', 5, 5);
INSERT INTO `materiales` VALUES (10876, 1, 'S-034', 'JABONERA VERTIKA CROMO 16108', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:42', 5, 5);
INSERT INTO `materiales` VALUES (31663, 1, 'JAL-100', 'JALADOR DE HULE ESPUMA C/BASE BMETALICA 45C', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:42', 5, 5);
INSERT INTO `materiales` VALUES (33286, 1, 'JAL-200', 'JALADOR DE HULE ESPUMA P/PISOS C/BASE METALICA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:42', 5, 5);
INSERT INTO `materiales` VALUES (11795, 1, 'C-033', 'JAMBA TRAMO 6.10 MTS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:42', 5, 5);
INSERT INTO `materiales` VALUES (23975, 1, 'JDI-01', 'JARDINERIA', 794, 'ACABADOS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:42', 5, 5);
INSERT INTO `materiales` VALUES (29456, 1, 'JAR-101', 'JARRON CRISTAL GRANDE', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:42', 5, 5);
INSERT INTO `materiales` VALUES (29453, 1, 'JAR-100', 'JARRON CRISTAL MEDIANO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:43', 5, 5);
INSERT INTO `materiales` VALUES (33493, 1, 'JEN-100', 'JEANS DE MEZCLILLA ( VARIAS TALLAS )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:43', 5, 5);
INSERT INTO `materiales` VALUES (13756, 1, 'J-001', 'JORRO AIRE C/CAPUCHA AQUAPLAS', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:43', 5, 5);
INSERT INTO `materiales` VALUES (20164, 1, 'JAGA', 'JOSE ALEJANDRO GARCIA ASTORGA', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:43', 5, 5);
INSERT INTO `materiales` VALUES (20167, 1, 'JMNB', 'JUAN MANUEL NUÑEZ BOCANEGRA', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:43', 5, 5);
INSERT INTO `materiales` VALUES (12879, 1, 'AV-001', 'JUEGO COMBINADO DE PASAMANOS, COLUPIO Y RESVALADERO', 821, 'AREA VERDE', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:43', 5, 5);
INSERT INTO `materiales` VALUES (31367, 1, 'JLC-100', 'JUEGO DE 2 PALANCAS P/CAMBIO DE LLANTA COD 11089', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:00', '2020-10-19 11:08:44', 5, 5);
INSERT INTO `materiales` VALUES (27181, 1, 'JGA-114', 'JUEGO DE 3 ESIZAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:44', 5, 5);
INSERT INTO `materiales` VALUES (27184, 1, 'JGO-115', 'JUEGO DE 3 ESPEJOS', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:44', 5, 5);
INSERT INTO `materiales` VALUES (34807, 1, 'CUÑ-150', 'JUEGO DE 4 CUÑAS C/MANGO DE PLASTICO', 794, 'ACABADOS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:44', 5, 5);
INSERT INTO `materiales` VALUES (11214, 1, 'HE-005', 'JUEGO DE 5  PROTECCIONES PARA VIVIENDA  INCLUYE INSTALACION Y FIJO', 792, 'HERRERIA', 'JUEGO', 'JUEGO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:44', 5, 5);
INSERT INTO `materiales` VALUES (31234, 1, 'DES-100', 'JUEGO DE 8 DESARMADORES', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:44', 5, 5);
INSERT INTO `materiales` VALUES (13591, 1, '0-374', 'JUEGO DE BIRLOS', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:44', 5, 5);
INSERT INTO `materiales` VALUES (13288, 1, '0-305', 'JUEGO DE CORTADOR Y AVELLANADOR EN ESTUCHE GB', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:44', 5, 5);
INSERT INTO `materiales` VALUES (10538, 1, 'H-033', 'JUEGO DE LLAVES PARA REGADERA EMPOTRAMIENTO ROSCABLE MARCA DICA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:45', 5, 5);
INSERT INTO `materiales` VALUES (13057, 1, 'O-301', 'JUEGO DE TORNILLERIA GALVANIZADA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:45', 5, 5);
INSERT INTO `materiales` VALUES (13144, 1, 'O-274', 'JUEGO INTERNO DE SAPO  M/CATO  MODELO BELLINI ECOLOGICO ', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:45', 5, 5);
INSERT INTO `materiales` VALUES (12042, 1, 'HE-011', 'JUEGOS INFANTILES', 792, 'HERRERIA', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:45', 5, 5);
INSERT INTO `materiales` VALUES (12891, 1, 'AV-005', 'JUNGLE GIM', 821, 'AREA VERDE', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:45', 5, 5);
INSERT INTO `materiales` VALUES (35950, 1, 'JUG-205', 'JUNTA GIUBAULT 205mm', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:45', 5, 5);
INSERT INTO `materiales` VALUES (10900, 1, 'P-016', 'K-10861M-4 LLAVE SINGULARE MONOMANDO ALTA POLISHED CHROME', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:01', '2020-10-19 11:08:45', 5, 5);
INSERT INTO `materiales` VALUES (10904, 1, 'P-017', 'K-2661-0 LAVABO VOX DE SOBREPONER CUADRADO WHITE ', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:02', '2020-10-19 11:08:46', 5, 5);
INSERT INTO `materiales` VALUES (12735, 1, 'CS-007', 'KARISMA ALTO:21CM  INDIVIDUAL 192 RESORTES', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:02', '2020-10-19 11:08:46', 5, 5);
INSERT INTO `materiales` VALUES (13750, 1, 'K-001', 'Kit de conexion para calentador', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:02', '2020-10-19 11:08:46', 5, 5);
INSERT INTO `materiales` VALUES (11702, 1, 'A-026', 'LADRILLO PECHO PALOMA DECORATIVO MOLDURA', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:02', '2020-10-19 11:08:46', 5, 5);
INSERT INTO `materiales` VALUES (13579, 1, 'A-088', 'LADRILLO ROJO 14X25X71/2', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:02', '2020-10-19 11:08:46', 5, 5);
INSERT INTO `materiales` VALUES (32278, 1, 'LAN-100', 'LAINA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:02', '2020-10-19 11:08:46', 5, 5);
INSERT INTO `materiales` VALUES (12266, 1, 'O-122', 'LAMINA 1.10 X 5.50 MTS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:02', '2020-10-19 11:08:47', 5, 5);
INSERT INTO `materiales` VALUES (33701, 1, 'LAM-410', 'LAMINA ZINTRO CAL. 26 DE 4  10 ', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:02', '2020-10-19 11:08:47', 5, 5);
INSERT INTO `materiales` VALUES (13477, 1, 'FLT8-32WLD', 'LAMPARA  T8 FLUORESENTE 32W ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:03', '2020-10-19 11:08:47', 5, 5);
INSERT INTO `materiales` VALUES (13147, 1, 'EU-075', 'LAMPARA BAMBA  CTL-8210/CR', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:03', '2020-10-19 11:08:48', 5, 5);
INSERT INTO `materiales` VALUES (13549, 1, 'EU-081', 'LAMPARA COLGANTE DE VIDRIO ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:03', '2020-10-19 11:08:48', 5, 5);
INSERT INTO `materiales` VALUES (26963, 1, 'MV216', 'LAMPARA COLGANTE MOD. EPSILON II NEGRO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:03', '2020-10-19 11:08:48', 5, 5);
INSERT INTO `materiales` VALUES (27169, 1, 'LAM-111', 'LAMPARA DE BUSO PARA PANTALLA NEGRA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:03', '2020-10-19 11:08:48', 5, 5);
INSERT INTO `materiales` VALUES (27964, 1, 'LAM-108', 'LAMPARA DE MESA CENOTILO NEGRO CON AMARILLO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:03', '2020-10-19 11:08:48', 5, 5);
INSERT INTO `materiales` VALUES (27961, 1, 'LAM-107', 'LAMPARA DE MESA MORA BLANCO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:03', '2020-10-19 11:08:48', 5, 5);
INSERT INTO `materiales` VALUES (28003, 1, 'LAM-121', 'LAMPARA DE PARED MECAC NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:03', '2020-10-19 11:08:49', 5, 5);
INSERT INTO `materiales` VALUES (27997, 1, 'LAM-119', 'LAMPARA DE PIE ITZAM NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:03', '2020-10-19 11:08:49', 5, 5);
INSERT INTO `materiales` VALUES (27166, 1, 'LAM-110', 'LAMPARA DE PISO 4 PATAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:03', '2020-10-19 11:08:49', 5, 5);
INSERT INTO `materiales` VALUES (27973, 1, 'LTS-111', 'LAMPARA DE TECHO 1 LUZ  NATURAL SKIU 200062', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:49', 5, 5);
INSERT INTO `materiales` VALUES (29256, 1, 'LAL-100', 'LAMPARA LED 18 WATTS EN 6500º CRISTAL TRANSPARENTE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:49', 5, 5);
INSERT INTO `materiales` VALUES (13693, 1, 'E-0088', 'LAMPARA PLAFONERA LTL-3140  BLANCO FRIO ', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:49', 5, 5);
INSERT INTO `materiales` VALUES (12046, 1, 'EU-030', 'LAMPARA SUBURBANA MAXIMO 250 WATTS, INCLUYE BASE Y ACRILICO LEXALITE JEMA', 785, 'ELECTRIFICACION URB', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:49', 5, 5);
INSERT INTO `materiales` VALUES (34116, 1, 'LAM-100', 'LAMPARAS ULTRAVIOLETAS SANITIZANTES', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:50', 5, 5);
INSERT INTO `materiales` VALUES (26517, 1, 'LAN-115', 'LANTANA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:50', 5, 5);
INSERT INTO `materiales` VALUES (31524, 1, 'LAP-100', 'LAPICERO PENTEL TECHNICLICK', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:50', 5, 5);
INSERT INTO `materiales` VALUES (32264, 1, 'LAP-500', 'LAPIZ ADHESIVO  PRITT', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:50', 5, 5);
INSERT INTO `materiales` VALUES (31527, 1, 'LPZ-100', 'LAPIZ DIXON BICOLOR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:50', 5, 5);
INSERT INTO `materiales` VALUES (11978, 1, 'O-090', 'LAPTOP ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:50', 5, 5);
INSERT INTO `materiales` VALUES (36682, 1, '', 'LAPTOP HP PAVILION 15-CW1005LA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:50', 5, 5);
INSERT INTO `materiales` VALUES (13513, 1, 'L-001', 'LAVABO MODELO LUZA', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:51', 5, 5);
INSERT INTO `materiales` VALUES (10086, 1, 'T-003', 'LAVABO SANITARIO MODELO JAZMIN REDONDO MARCA CATO', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:04', '2020-10-19 11:08:51', 5, 5);
INSERT INTO `materiales` VALUES (11230, 1, 'AC017', 'LAVADERO DE CEMENTO GRIS 75X65 SIN ANCLAS Y SALIDA PARA PVC', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:51', 5, 5);
INSERT INTO `materiales` VALUES (9894, 1, 'AC-012', 'LAVADERO DE CEMENTO GRIS 76X59X17 CMS, CON ANCLAS Y SALIDA PARA PVC', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:51', 5, 5);
INSERT INTO `materiales` VALUES (9898, 1, 'AC-013', 'LAVADERO DE CEMENTO GRIS 78X60 CMS, SIN ANCLAS Y SALIDA PARA PVC', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:51', 5, 5);
INSERT INTO `materiales` VALUES (30915, 1, 'LEC-63', 'LECHE CARNATION', 803, 'EXTRAS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:51', 5, 5);
INSERT INTO `materiales` VALUES (31333, 1, 'LEN-100', 'LENTES DE SEGURIDAD LIGEROS ( COD. 10824 )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:51', 5, 5);
INSERT INTO `materiales` VALUES (12762, 1, 'CS-016', 'LIBRERO/CLOSET COLOR BLANCO', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:52', 5, 5);
INSERT INTO `materiales` VALUES (35406, 1, 'LBT-200', 'LIBRETA HL 120', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:52', 5, 5);
INSERT INTO `materiales` VALUES (35403, 1, 'LBT-100', 'LIBRETA HL 9050', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:52', 5, 5);
INSERT INTO `materiales` VALUES (12864, 1, 'O-209', 'LIBRETA PROFESIONAL', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:52', 5, 5);
INSERT INTO `materiales` VALUES (12237, 1, 'O-113', 'LICENCIA DE CONSTRUCCION', 808, 'OTROS', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:52', 5, 5);
INSERT INTO `materiales` VALUES (12672, 1, 'O-173', 'LICENCIA USO DE SUELO ', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:52', 5, 5);
INSERT INTO `materiales` VALUES (21143, 1, 'LIC-PE', 'LICENCIAS Y PERMISOS', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:52', 5, 5);
INSERT INTO `materiales` VALUES (13276, 1, '0-301', 'LIGAS', 808, 'OTROS', 'BOLSA', 'BOLSA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:05', '2020-10-19 11:08:52', 5, 5);
INSERT INTO `materiales` VALUES (13633, 1, 'A-089', 'LIJA ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:53', 5, 5);
INSERT INTO `materiales` VALUES (10621, 1, 'A-019', 'LIJA #80 METAL', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:53', 5, 5);
INSERT INTO `materiales` VALUES (11896, 1, 'O-079', 'LIJA BANDA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:53', 5, 5);
INSERT INTO `materiales` VALUES (9834, 1, 'A-014', 'LIJA DE  NO. 120', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:53', 5, 5);
INSERT INTO `materiales` VALUES (13081, 1, 'A-055', 'LIJA DE MADERA  No. 80', 794, 'ACABADOS', 'pza', 'pza', '1', '', '', 'ACTIVO                      ', '2020-10-19 11:03:06', '2021-02-23 15:54:33', 5, 0);
INSERT INTO `materiales` VALUES (13891, 1, 'O-343', 'LIJA ESMERIL MEDIANA NUM 80', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:53', 5, 5);
INSERT INTO `materiales` VALUES (11887, 1, 'O-076', 'LIJA PARA MADERA DE LONA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:53', 5, 5);
INSERT INTO `materiales` VALUES (31780, 1, 'LMG-100', 'LIMPIADOR DE MUEBLES ( GLADE )', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:54', 5, 5);
INSERT INTO `materiales` VALUES (24475, 1, 'MP-105', 'LIMPIADOR MAGNETICO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:54', 5, 5);
INSERT INTO `materiales` VALUES (31777, 1, 'WIX-100', 'LIMPIADOR PARA VIDRIOS ( WINDEX )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:54', 5, 5);
INSERT INTO `materiales` VALUES (34483, 1, 'LIM-P00', 'LIMPIADOR PINO', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:54', 5, 5);
INSERT INTO `materiales` VALUES (30733, 1, '1205-108-044', 'LIMPIADOR WOW', 803, 'EXTRAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:54', 5, 5);
INSERT INTO `materiales` VALUES (26050, 1, 'MO-112', 'LIMPIEZA', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:06', '2020-10-19 11:08:54', 5, 5);
INSERT INTO `materiales` VALUES (21895, 1, '', 'LIMPIEZA DE TERRENO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:54', 5, 5);
INSERT INTO `materiales` VALUES (34329, 1, 'LIF-100', 'LIMPIEZA FINA', 794, 'ACABADOS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:54', 5, 5);
INSERT INTO `materiales` VALUES (26511, 1, 'LIR-100', 'LIRIO PERSA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:55', 5, 5);
INSERT INTO `materiales` VALUES (13381, 1, '0-321', 'LISIMAQUIA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:55', 5, 5);
INSERT INTO `materiales` VALUES (12729, 1, 'CS-005', 'LITERA, CAMA Y RODABASE PICOLO A:178   L:203  F: 105 CM', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:55', 5, 5);
INSERT INTO `materiales` VALUES (31237, 1, 'LLNA-185', 'LLANA CANTO DENT CUADR 11X5', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:55', 5, 5);
INSERT INTO `materiales` VALUES (24204, 1, 'LL-195', 'LLANTA 195/60R15 TORNEL REAL 87H', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:55', 5, 5);
INSERT INTO `materiales` VALUES (26769, 1, 'LL1-195', 'LLANTA 195/R15C 106/104R', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:55', 5, 5);
INSERT INTO `materiales` VALUES (33683, 1, 'LNT-200', 'LLANTA 245/40 R21 PARA BMW', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:55', 5, 5);
INSERT INTO `materiales` VALUES (33680, 1, 'LNT-100', 'LLANTA 25/35 R 21 103 Y PARA BMW', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:55', 5, 5);
INSERT INTO `materiales` VALUES (36560, 1, '267-R16', 'LLANTA 265/75 R/16 GENERAL GRABBERT', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:56', 5, 5);
INSERT INTO `materiales` VALUES (33960, 1, 'LLT-100', 'LLANTA 275/55 R/20 BRIDGESTONE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:07', '2020-10-19 11:08:56', 5, 5);
INSERT INTO `materiales` VALUES (33965, 1, '', 'LLANTA 275/60 R/20 BRIDGESTONE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:56', 5, 5);
INSERT INTO `materiales` VALUES (33967, 1, 'LLT-285', 'LLANTA 285/45R22 COOPER DISCOVERER', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:56', 5, 5);
INSERT INTO `materiales` VALUES (11758, 1, 'O-065', 'LLANTA PARA CARRETILLA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:56', 5, 5);
INSERT INTO `materiales` VALUES (31219, 1, 'LLVE-100', 'LLAVE AJUSTABLE ( PERICO )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:56', 5, 5);
INSERT INTO `materiales` VALUES (34810, 1, 'LLAP-100', 'LLAVE AJUSTABLE PERICA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:56', 5, 5);
INSERT INTO `materiales` VALUES (10454, 1, 'H-011', 'LLAVE ANGULAR DE PASO DE 1/2\" DE DIAMETRO PARA LAVABO MARCA DICA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:57', 5, 5);
INSERT INTO `materiales` VALUES (10721, 1, 'H-049', 'LLAVE BANQUETA DE 1/2\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:57', 5, 5);
INSERT INTO `materiales` VALUES (10920, 1, 'H-055', 'LLAVE DE EMPOTRAR', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:57', 5, 5);
INSERT INTO `materiales` VALUES (11602, 1, 'H-073', 'LLAVE DE PASO DE 1 PULGADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:57', 5, 5);
INSERT INTO `materiales` VALUES (10462, 1, 'H-013', 'LLAVE DE PASO DE 1/2\" VALVULA ESPFERA MARCA DICA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:57', 5, 5);
INSERT INTO `materiales` VALUES (13504, 1, 'LAVE-01', 'LLAVE DE RESORTE  MARCA DICA ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:57', 5, 5);
INSERT INTO `materiales` VALUES (12582, 1, 'H-101', 'LLAVE ESFERA 1\" GALVANIZADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:08', '2020-10-19 11:08:57', 5, 5);
INSERT INTO `materiales` VALUES (18876, 1, '', 'LLAVE ESTOPERA', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:57', 5, 5);
INSERT INTO `materiales` VALUES (13651, 1, 'AC-022', 'LLAVE MEZCLADORA PARA LAVABO', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:58', 5, 5);
INSERT INTO `materiales` VALUES (9902, 1, 'AC-014', 'LLAVE NARIZ MANGUERA DE 1/2\" DE DIAMETRO MARCA RUGO', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:58', 5, 5);
INSERT INTO `materiales` VALUES (31246, 1, 'LLVE-101', 'LLAVE P/TUBO STILSON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:58', 5, 5);
INSERT INTO `materiales` VALUES (33149, 1, 'LLI-100', 'LLAVERO IDENTIFICADOR', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:59', 5, 5);
INSERT INTO `materiales` VALUES (12006, 1, 'O-096', 'LOCKER OFICINA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:59', 5, 5);
INSERT INTO `materiales` VALUES (34749, 1, 'LCM-100', 'LONA  IMPRESO ALTA DEFICINION DE 4X2 CON DISEÑO DE CASAS MUESTRA', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:59', 5, 5);
INSERT INTO `materiales` VALUES (31470, 1, 'LON-200', 'LONA 1.00X.60 CON FUNDA ARRIBA Y ABAJO', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:59', 5, 5);
INSERT INTO `materiales` VALUES (12414, 1, 'PUBLI-005', 'LONA ESPECTACULAR ', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:59', 5, 5);
INSERT INTO `materiales` VALUES (9569, 1, 'PUBLI-003', 'LONA IMPRESA', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:59', 5, 5);
INSERT INTO `materiales` VALUES (12417, 1, 'PUBLI-006', 'LONAS BASTIDORES', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:59', 5, 5);
INSERT INTO `materiales` VALUES (11908, 1, 'O-082', 'LONAS PUBLICIDAD', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:08:59', 5, 5);
INSERT INTO `materiales` VALUES (12063, 1, 'O-105', 'LOTE DE ARTICULOS DE LIMPIEZA', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:09', '2020-10-19 11:09:00', 5, 5);
INSERT INTO `materiales` VALUES (20031, 1, 'LP-01', 'LOTE DE PLANTAS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:00', 5, 5);
INSERT INTO `materiales` VALUES (26316, 1, 'LOT-ARB', 'LOTIFICACION DEL FRACC ARBOLEDAS RESIDENCIAL', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:00', 5, 5);
INSERT INTO `materiales` VALUES (12738, 1, 'CS-008', 'LOVE IZQUIERDA A: 90   L: 150   F:88 CM', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:00', 5, 5);
INSERT INTO `materiales` VALUES (31342, 1, 'LUB-100', 'LUBRICANTE EN AEROSOL 400 ML TRUPER ( COD. 1347-1 )', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:00', 5, 5);
INSERT INTO `materiales` VALUES (10394, 1, 'EU-018', 'LUMINARIA DE 150V VAPOR DE SODIO EN  220 TIPO OV15', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:00', 5, 5);
INSERT INTO `materiales` VALUES (18627, 1, 'EU-101', 'LUMINARIA PTL-1950/s ', 794, 'ACABADOS', 'pza', 'pza', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:00', 5, 5);
INSERT INTO `materiales` VALUES (18855, 1, '', 'LUMINARIO ANDORA EMPOTRADO DIRIGIBLE P/MR 16 BLANCO', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:01', 5, 5);
INSERT INTO `materiales` VALUES (18806, 1, '', 'LUMINARIO COLANTE TIPO CANASTA COBRE E-26 TECNOLITE', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:01', 5, 5);
INSERT INTO `materiales` VALUES (12498, 1, 'EU-036', 'LUMINARIO CONSTANZA EMPOTRADO PISO FIBRA DE VIDRIO NEGRO E26 50W', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:01', 5, 5);
INSERT INTO `materiales` VALUES (18815, 1, '', 'LUMINARIO NADI EMPOTRADO LED DE 9WATTS 6500 TECNOLITTE', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:01', 5, 5);
INSERT INTO `materiales` VALUES (18808, 1, '', 'LUMINARIO NAGANO COLGANTE 2X28T5 56W C/LAMPARA', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:01', 5, 5);
INSERT INTO `materiales` VALUES (18817, 1, '', 'LUMINARIO NIZHNY EMPOTRADO ALUMINIO BLANCO 3000K LED 10W C/', 800, 'ACCESORIOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:01', 5, 5);
INSERT INTO `materiales` VALUES (18636, 1, 'EU-104', 'LUMINARIO OLMO EMPOTRADO TECHO BLANCO 4100 K TECNOLITE', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:10', '2020-10-19 11:09:02', 5, 5);
INSERT INTO `materiales` VALUES (18633, 1, 'EU-103', 'LUMINARIO OLMO EMPOTRADO TECHO LAMINA DE ACETO TECNOLITE', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:02', 5, 5);
INSERT INTO `materiales` VALUES (33976, 1, 'LUM-4060', 'LUMINARIO SOBREPONER LED 3X16 DE .40X65 TECNOLITE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:02', 5, 5);
INSERT INTO `materiales` VALUES (30506, 1, 'LUM-150', 'LUMINARIO SOBREPONER LED 3X16 DE .60X1.20 TECNOLITE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:02', 5, 5);
INSERT INTO `materiales` VALUES (18813, 1, 'LUM-26', 'LUMINARIOCOLGANTEMETALICO E26 TECNOLITE', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:02', 5, 5);
INSERT INTO `materiales` VALUES (30939, 1, 'LUST-651', 'LUSTRADOR PARA MUEBLES PLEDGE', 803, 'EXTRAS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:02', 5, 5);
INSERT INTO `materiales` VALUES (12336, 1, 'O-134', 'Lapicero ', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:03', 5, 5);
INSERT INTO `materiales` VALUES (24950, 1, 'LA-120', 'Librero Angular 5 repisas - Café', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:03', 5, 5);
INSERT INTO `materiales` VALUES (24908, 1, 'LTI-106', 'Lámpara de techo Ixquic - Café', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:03', 5, 5);
INSERT INTO `materiales` VALUES (24941, 1, 'LSC-117', 'Lámpara suspendida Campeche - Negro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:03', 5, 5);
INSERT INTO `materiales` VALUES (24905, 1, 'LST-105', 'Lámpara suspendida Temoac - Negro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:03', 5, 5);
INSERT INTO `materiales` VALUES (24953, 1, 'LSV-121', 'Lámpara suspendida Villamar B - Blanco', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:03', 5, 5);
INSERT INTO `materiales` VALUES (24956, 1, 'LSV-111', 'Lámpara suspendida Villamar C - Blanco', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:11', '2020-10-19 11:09:03', 5, 5);
INSERT INTO `materiales` VALUES (13231, 1, '0-292', 'MACBOOK AIR 13', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:04', 5, 5);
INSERT INTO `materiales` VALUES (26251, 1, 'MAC-100', 'MACETA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:04', 5, 5);
INSERT INTO `materiales` VALUES (29444, 1, 'MAC-30', 'MACETA BLANCO CHICA TALCO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:04', 5, 5);
INSERT INTO `materiales` VALUES (29441, 1, 'MAC-230', 'MACETA BLANCO TALCO CON BASE METALICA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:04', 5, 5);
INSERT INTO `materiales` VALUES (29408, 1, 'MAC-20', 'MACETA NEGRA LINEAS DORADAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:04', 5, 5);
INSERT INTO `materiales` VALUES (28030, 1, 'MAC-130', 'MACETA REDONDA CREXAL GRIS OXFORD', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:04', 5, 5);
INSERT INTO `materiales` VALUES (28018, 1, 'MAC-126', 'MACETERO GRANDE MARKOR NEGRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:04', 5, 5);
INSERT INTO `materiales` VALUES (29447, 1, 'MAC-40', 'MACETON DE BARRO CAFE COLONIAL', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:05', 5, 5);
INSERT INTO `materiales` VALUES (30987, 1, 'MHT-100', 'MACHETE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:05', 5, 5);
INSERT INTO `materiales` VALUES (33690, 1, 'MAD-150', 'MADERA 1.5X8X20', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:05', 5, 5);
INSERT INTO `materiales` VALUES (11872, 1, 'O-071', 'MADERA BANK SELECTA 1.5\"', 808, 'OTROS', 'PT', 'PT', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:05', 5, 5);
INSERT INTO `materiales` VALUES (11868, 1, 'O-070', 'MADERA DE BANK SELECTA 1\"', 808, 'OTROS', 'PT', 'PT', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:05', 5, 5);
INSERT INTO `materiales` VALUES (11381, 1, 'O-034', 'MALLA 20 MTS. ', 808, 'OTROS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:12', '2020-10-19 11:09:05', 5, 5);
INSERT INTO `materiales` VALUES (11369, 1, 'O-031', 'MALLA CICLONICA DE 2 MTS DE ALTO CAL. 11X63X63 MM.', 808, 'OTROS', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:13', '2020-10-19 11:09:05', 5, 5);
INSERT INTO `materiales` VALUES (27705, 1, 'ROL-125', 'MALLA DE REFUERZO PARA IMPER', 794, 'ACABADOS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:13', '2020-10-19 11:09:06', 5, 5);
INSERT INTO `materiales` VALUES (9918, 1, 'ACE-005', 'MALLA ELECTROSOLDADA 6X6 10/10 ROLLO DE 40X2.5', 809, 'ACERO', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:13', '2020-10-19 11:09:06', 5, 5);
INSERT INTO `materiales` VALUES (9614, 1, 'ACE-004', 'MALLA ELECTROSOLDADA 6X6 4/4 ROLLO DE 40X2.5', 809, 'ACERO', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:13', '2020-10-19 11:09:06', 5, 5);
INSERT INTO `materiales` VALUES (11341, 1, 'ACE-022', 'MALLA ELECTROSOLDADA 6X6 66 ROLLO DE 40X2.5', 809, 'ACERO', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:13', '2020-10-19 11:09:06', 5, 5);
INSERT INTO `materiales` VALUES (10118, 1, 'T-011', 'MALLA FIBRA DE VIDRIO ROLLO DE 1X50 MTS DE 60 GR.', 801, 'ECOTECNOLOGIAS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:14', '2020-10-19 11:09:06', 5, 5);
INSERT INTO `materiales` VALUES (12961, 1, 'AV-009', 'MALLA PARA VOLEIBOL 9MTSX1', 821, 'AREA VERDE', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:14', '2020-10-19 11:09:06', 5, 5);
INSERT INTO `materiales` VALUES (10813, 1, 'A-023', 'MALLA PLAFONERA GALVANIZADA', 794, 'ACABADOS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:14', '2020-10-19 11:09:06', 5, 5);
INSERT INTO `materiales` VALUES (20211, 1, 'MANERAL', 'MANERAL', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:14', '2020-10-19 11:09:07', 5, 5);
INSERT INTO `materiales` VALUES (31201, 1, 'MGO-100', 'MANGO P/ZAPAPICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:14', '2020-10-19 11:09:07', 5, 5);
INSERT INTO `materiales` VALUES (12919, 1, 'T-021', 'MANGUERA 60CM FLEXIBLE PUMPS P/ HIDRO', 801, 'ECOTECNOLOGIAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:14', '2020-10-19 11:09:07', 5, 5);
INSERT INTO `materiales` VALUES (10725, 1, 'H-050', 'MANGUERA AZUL, POLIDUCTO 1/2\" PARA TOMA DE AGUA', 786, 'HIDRAULICA', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:14', '2020-10-19 11:09:07', 5, 5);
INSERT INTO `materiales` VALUES (13000, 1, 'O-257', 'MANGUERA DE ALTA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:07', 5, 5);
INSERT INTO `materiales` VALUES (12997, 1, 'O-256', 'MANGUERA DE BAJA PARA AIRE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:07', 5, 5);
INSERT INTO `materiales` VALUES (33563, 1, 'MAN-100', 'MANGUERA PARA JARDIN', 808, 'OTROS', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:07', 5, 5);
INSERT INTO `materiales` VALUES (36615, 1, 'MPJ-304', 'MANGUERA PARA JARDIN 4 CAPAS DE 3/4 USO RUDO DE 100 MTS', 808, 'OTROS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:08', 5, 5);
INSERT INTO `materiales` VALUES (13291, 1, '0-306', 'MANIFOLD DE ALUMINIO P/12, R22,R404A,R134A C/MANGUERAS DE 36 MARCA GB', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:08', 5, 5);
INSERT INTO `materiales` VALUES (10936, 1, 'O-009', 'MANIOBRAS', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:08', 5, 5);
INSERT INTO `materiales` VALUES (26798, 1, 'MOD-147', 'MANIOBRAS DE DESCARGA', 808, 'OTROS', '1', '1', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:08', 5, 5);
INSERT INTO `materiales` VALUES (12994, 1, 'O-255', 'MANO DE OBRA EN AUTOS', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:09', 5, 5);
INSERT INTO `materiales` VALUES (13330, 1, 'H-124', 'MANOMETRO', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:09', 5, 5);
INSERT INTO `materiales` VALUES (12916, 1, 'T-020', 'MANOMETRO PUMSP/ PARA HIDRO', 801, 'ECOTECNOLOGIAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:10', 5, 5);
INSERT INTO `materiales` VALUES (36724, 1, 'MTO-100', 'MANTENIMIENTO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:10', 5, 5);
INSERT INTO `materiales` VALUES (30790, 1, 'MBJ-100', 'MANTENIMIENTO A BALATAS INC. AJUSTE Y LIMPIEZA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:15', '2020-10-19 11:09:10', 5, 5);
INSERT INTO `materiales` VALUES (24463, 1, 'MP-101', 'MANTENIMIENTO A PECERA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:10', 5, 5);
INSERT INTO `materiales` VALUES (12284, 1, 'O-128', 'MANTENIMIENTO DE LOCAL', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:11', 5, 5);
INSERT INTO `materiales` VALUES (31964, 1, '', 'MANTENIMIENTO EQUIPO AIRE LAVAD', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:11', 5, 5);
INSERT INTO `materiales` VALUES (13141, 1, 'O-273', 'MANTENIMIENTO EQUIPO AIRE LAVADO ', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:11', 5, 5);
INSERT INTO `materiales` VALUES (31966, 1, 'MTT-100', 'MANTENIMIENTO EQUIPO DE MINISPLIT', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:11', 5, 5);
INSERT INTO `materiales` VALUES (20063, 1, 'MEO-01', 'MANTENIMIENTO EQUIPO DE OFINA', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:11', 5, 5);
INSERT INTO `materiales` VALUES (11846, 1, 'O-069', 'MANTENIMIENTO EQUIPO DE TRANSPORTE', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:11', 5, 5);
INSERT INTO `materiales` VALUES (36766, 1, 'MTO-200', 'MANTENIMIENTO VARIOS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:11', 5, 5);
INSERT INTO `materiales` VALUES (11385, 1, 'O-035', 'MANTENIMIENTO Y CONFIGURACION SISTEMAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:12', 5, 5);
INSERT INTO `materiales` VALUES (13030, 1, 'O-266', 'MARCA TEXTOS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:12', 5, 5);
INSERT INTO `materiales` VALUES (34650, 1, 'MCD-100', 'MARCADOR PERMANENTE ESTERBOOK NEGRO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:12', 5, 5);
INSERT INTO `materiales` VALUES (31761, 1, 'MDV-100', 'MARCADOR RESALT DUO V/COL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:16', '2020-10-19 11:09:12', 5, 5);
INSERT INTO `materiales` VALUES (32043, 1, 'MES-9', 'MARCO ALUMINIO BLANCO 0.64 X 2.09 MTS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:12', 5, 5);
INSERT INTO `materiales` VALUES (31908, 1, 'BON-9', 'MARCO ALUMINIO BLANCO 0.74 X 2.09 MTS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:12', 5, 5);
INSERT INTO `materiales` VALUES (33347, 1, 'CON-11', 'MARCO ALUMINIO BLANCO 0.74 X 2.09 MTS - CONCORDIA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:13', 5, 5);
INSERT INTO `materiales` VALUES (31945, 1, 'VEN-11', 'MARCO ALUMINIO BLANCO 0.74 X 2.09 MTS MOD VENTURA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:13', 5, 5);
INSERT INTO `materiales` VALUES (31893, 1, 'BON-8', 'MARCO ALUMINIO BLANCO 0.84 X 2.09 MTS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:13', 5, 5);
INSERT INTO `materiales` VALUES (33344, 1, 'CON-10', 'MARCO ALUMINIO BLANCO 0.84 X 2.09 MTS - CONCORDIA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:13', 5, 5);
INSERT INTO `materiales` VALUES (32040, 1, 'MES-8', 'MARCO ALUMINIO BLANCO 0.84 X 2.09 MTS - mesura', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:13', 5, 5);
INSERT INTO `materiales` VALUES (31940, 1, 'VEN-10', 'MARCO ALUMINIO BLANCO 0.84 X 2.09 MTS MOD. VENTURA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:13', 5, 5);
INSERT INTO `materiales` VALUES (32001, 1, 'TEM-G9', 'MARCO ALUMINIO BLANCO 0.84 X 2.09 MTS RECAMARAS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:14', 5, 5);
INSERT INTO `materiales` VALUES (32004, 1, 'TEM-G8', 'MARCO ALUMINIO BLANCO 0.89 X 2.09 MTS BAÑOS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:14', 5, 5);
INSERT INTO `materiales` VALUES (31998, 1, 'TEM-G7', 'MARCO ALUMINIO G2 0.89 X 2.09 MTS PUERTA PRINCIPAL', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:14', 5, 5);
INSERT INTO `materiales` VALUES (31348, 1, 'CA-G11', 'MARCO ALUMINIO G2 0.90 X 2.10 MTS PUERTA PRINCIPAL', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:17', '2020-10-19 11:09:14', 5, 5);
INSERT INTO `materiales` VALUES (31890, 1, 'BON-7', 'MARCO ALUMINIO G2 0.94 X 2.09 MTS PUERTA DE COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:14', 5, 5);
INSERT INTO `materiales` VALUES (33339, 1, 'CON-9', 'MARCO ALUMINIO G2 0.94 X 2.09 MTS PUERTA DE COCINA CONCORDIA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:14', 5, 5);
INSERT INTO `materiales` VALUES (31961, 1, 'VEN-9', 'MARCO ALUMINIO G2 0.94 X 2.09 MTS PUERTA DE COCINA MOD VENTURA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:14', 5, 5);
INSERT INTO `materiales` VALUES (31887, 1, 'BON-6', 'MARCO ALUMINIO G2 0.94 X 2.09 MTS PUERTA PRINCIPAL', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:15', 5, 5);
INSERT INTO `materiales` VALUES (33336, 1, 'CON-8', 'MARCO ALUMINIO G2 0.94 X 2.09 MTS PUERTA PRINCIPAL - CONCORDIA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:15', 5, 5);
INSERT INTO `materiales` VALUES (31936, 1, 'VEN-8', 'MARCO ALUMINIO G2 0.94 X 2.09 MTS PUERTA PRINCIPAL MOD. VENTURA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:15', 5, 5);
INSERT INTO `materiales` VALUES (32036, 1, 'MES-7', 'MARCO ALUMINIO G2 0.94 X 2.09MTS PUERTA PRINCIPAL', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:15', 5, 5);
INSERT INTO `materiales` VALUES (11302, 1, 'CA-027', 'MARCO ALUMINIO G2 0.94 X 2.10 MTS PUERTA DE COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:15', 5, 5);
INSERT INTO `materiales` VALUES (26634, 1, 'CA-G01', 'MARCO ALUMINIO G2 0.94 X 2.10 MTS PUERTA PRINCIPAL', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:15', 5, 5);
INSERT INTO `materiales` VALUES (20369, 1, 'EU-051', 'MARCO C/ TAPA POLIETILENO PARA CAJA DE VALVULAS', 806, 'URBANIZACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:15', 5, 5);
INSERT INTO `materiales` VALUES (31351, 1, 'CA-128', 'MARCO DE ALUMINIO  PERFIL 1 1/2\" COLOR BLANCO MED. .90X2.10 CM', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:16', 5, 5);
INSERT INTO `materiales` VALUES (19340, 1, 'CA-46', 'MARCO DE ALUMINIO 89. X 2.10', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:18', '2020-10-19 11:09:16', 5, 5);
INSERT INTO `materiales` VALUES (10010, 1, 'CA-013 ', 'MARCO DE ALUMINIO BLANCO PERFIL DE 1 1/2\" ', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:16', 5, 5);
INSERT INTO `materiales` VALUES (10046, 1, 'CA-022', 'MARCO DE ALUMINIO BLANCO PERFIL DE 1 1/2\" UNIVERSALES, INCLUYE BISAGRAS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:16', 5, 5);
INSERT INTO `materiales` VALUES (11310, 1, 'CA-029', 'MARCO DE ALUMINIO NATURAL PERFIL 1 1/2\" COLOR BLANCO MED. .74X2.10CM', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:16', 5, 5);
INSERT INTO `materiales` VALUES (31355, 1, 'CA-129', 'MARCO DE ALUMINIO NATURAL PERFIL 1 1/2\" COLOR BLANCO MED. .80X2.10 CM', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:16', 5, 5);
INSERT INTO `materiales` VALUES (11306, 1, 'CA-028', 'MARCO DE ALUMINIO NATURAL PERFIL 1 1/2\" COLOR BLANCO MED. .84X2.10 CM', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:16', 5, 5);
INSERT INTO `materiales` VALUES (10438, 1, 'HE-001', 'MARCO DE REGISTRO SANITARIO DE .60X.40 CON JALADERA', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:17', 5, 5);
INSERT INTO `materiales` VALUES (13621, 1, 'CA-046', 'MARCO PARA PUERTA SERVICIO 0.96X2.10 CON ANCLAS ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:17', 5, 5);
INSERT INTO `materiales` VALUES (20613, 1, 'MRMH', 'MARIA DEL ROCIO MARTINEZ HERNANDEZ', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:17', 5, 5);
INSERT INTO `materiales` VALUES (26254, 1, 'MAR-100', 'MARJINATA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:17', 5, 5);
INSERT INTO `materiales` VALUES (22732, 1, 'M-01', 'MARMOL', 795, 'PISOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:17', 5, 5);
INSERT INTO `materiales` VALUES (32066, 1, 'MSM-101', 'MARMOL SMOW HILL DE 60X10 FACHADA', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:17', 5, 5);
INSERT INTO `materiales` VALUES (30592, 1, 'MSM-102', 'MARMOL SMOW HILL DE 60X20 FACHADA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:17', 5, 5);
INSERT INTO `materiales` VALUES (30589, 1, 'MSM-100', 'MARMOL SMOW HILL DE 60X30 FACHADA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:17', 5, 5);
INSERT INTO `materiales` VALUES (35885, 1, 'MSH-P01', 'MARMOL SNOW HILL PREMIUM .30X1.20 MATE S/ACABADO', 794, 'ACABADOS', 'M2', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:19', '2020-10-19 11:09:18', 5, 5);
INSERT INTO `materiales` VALUES (35888, 1, 'MSH-P02', 'MARMOL SNOW HILL PREMIUM .40X1.47 MATE S/ACABADO', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:18', 5, 5);
INSERT INTO `materiales` VALUES (31222, 1, 'MRR-100', 'MARRO OCTAG 4 LBS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:18', 5, 5);
INSERT INTO `materiales` VALUES (13084, 1, 'P-200', 'MARRUECOS CASA BLANCA 20 X 30', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:18', 5, 5);
INSERT INTO `materiales` VALUES (33734, 1, 'MAR-200', 'MARTILLO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:18', 5, 5);
INSERT INTO `materiales` VALUES (27421, 1, 'MAS-148', 'MASCARA CHICA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:18', 5, 5);
INSERT INTO `materiales` VALUES (27418, 1, 'MAS-147', 'MASCARAS GRANDE', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:18', 5, 5);
INSERT INTO `materiales` VALUES (27424, 1, 'MAS-149', 'MASCARAS MINI', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:18', 5, 5);
INSERT INTO `materiales` VALUES (23669, 1, '', 'MATERIAL Y MANO DE OBRA', 794, 'ACABADOS', 'ACTIVIDAD', 'ACTIVIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:19', 5, 5);
INSERT INTO `materiales` VALUES (20028, 1, 'MF-01', 'MATERIALES DE FERRETERRIA', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:19', 5, 5);
INSERT INTO `materiales` VALUES (36684, 1, '', 'MAUSE HP INALAMBRICO 220 PLATA CESTUCHE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:19', 5, 5);
INSERT INTO `materiales` VALUES (20170, 1, 'MMPR', 'MAYRA MARIBEL PEÑA RODRIGUEZ', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:19', 5, 5);
INSERT INTO `materiales` VALUES (36666, 1, '', 'MAZDA 2020 CX30 PLATA SONICO S:3MVDMCCL9L9102023', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:20', '2020-10-19 11:09:19', 5, 5);
INSERT INTO `materiales` VALUES (11881, 1, 'O-074', 'MDF ENCHAPADO EN OKUME 2C, 16mm', 808, 'OTROS', 'pieza', 'pieza', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:19', 5, 5);
INSERT INTO `materiales` VALUES (13012, 1, 'O-260', 'MDF15-TECNOTABLA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:19', 5, 5);
INSERT INTO `materiales` VALUES (13021, 1, 'O-263', 'MDF18-BERNECK', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:20', 5, 5);
INSERT INTO `materiales` VALUES (25500, 1, 'ELT-101', 'MEDIA TENSION SUBTERRANEA', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:20', 5, 5);
INSERT INTO `materiales` VALUES (19363, 1, 'MED-856', 'MEDICAMENTOS', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:20', 5, 5);
INSERT INTO `materiales` VALUES (24506, 1, 'U-003', 'MEJORAMIENTO DE TERRENO NATURAL CON 3 % DE CAL HUMECTACION, MEZCLADO TENDIDO Y COMPACT AL 90%', 806, 'URBANIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:20', 5, 5);
INSERT INTO `materiales` VALUES (30869, 1, 'U-103', 'MEJORAMIENTO DE TERRENO NATURAL CON MATERIAL TRITURADO CALIZO DE 1 1/2\" A FINOS DEL 50% MOVIMIENTO Y APILE CON EXCAVADORA DEL MATERIAL SUELTO, HUMECTACION, MEZCLADO TENDIDO Y COMPACT AL 90% SIN CAL', 808, 'OTROS', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:21', 5, 5);
INSERT INTO `materiales` VALUES (18226, 1, 'H-217', 'MEMBRANA P/HIDRO PARA 80 LTS.', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:21', 5, 5);
INSERT INTO `materiales` VALUES (13540, 1, 'O-358', 'MEMORIA', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:21', 5, 5);
INSERT INTO `materiales` VALUES (13900, 1, 'O-346', 'MENERALES', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:21', 5, 5);
INSERT INTO `materiales` VALUES (12744, 1, 'CS-010', 'MESA COMETA A:63  L:110 F:30 CM', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:21', 5, 5);
INSERT INTO `materiales` VALUES (23954, 1, 'C05-15', 'MESA DE COMEDOR SARA RECTANGULAR', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:21', '2020-10-19 11:09:21', 5, 5);
INSERT INTO `materiales` VALUES (28024, 1, 'MESS-128', 'MESA DE COMEDOR XOCO 120cm ENCINO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2020-10-19 11:03:21', '2021-02-23 15:54:38', 5, 0);
INSERT INTO `materiales` VALUES (27412, 1, 'MES-146', 'MESA DE PAROTA 3MTS X 1.77', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:22', 5, 5);
INSERT INTO `materiales` VALUES (27397, 1, 'MES-140', 'MESA DE PINO CARDADO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:22', 5, 5);
INSERT INTO `materiales` VALUES (12747, 1, 'CS-011', 'MESA LUGO 80 x 80 A:45 L:80 F:80CM CUBIERTA DE MARMOLl MESA CENTRALl', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:22', 5, 5);
INSERT INTO `materiales` VALUES (27400, 1, 'MES-142', 'MESA RD  PINO CARDADO 1.90X.90', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:22', 5, 5);
INSERT INTO `materiales` VALUES (27403, 1, 'MES-143', 'MESA REDONDA DE 1.20 DE DIAMETRO CARDADA, PEDES TAL, DE FUNDIDO NEGRA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:22', 5, 5);
INSERT INTO `materiales` VALUES (27616, 1, 'ME-174', 'MESAS VARIAS MEDIDAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:22', 5, 5);
INSERT INTO `materiales` VALUES (13327, 1, 'H-123', 'METRO TUBOPLUS 1/2', 786, 'HIDRAULICA', 'TRAMO', 'TRAMO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:23', 5, 5);
INSERT INTO `materiales` VALUES (13723, 1, 'M-14998', 'MEZCLADORA FREGADERO 14998', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:23', 5, 5);
INSERT INTO `materiales` VALUES (10110, 1, 'T-009', 'MEZCLADORA FREGADERO MODELO 8-IE MARCA RUGO', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:23', 5, 5);
INSERT INTO `materiales` VALUES (10106, 1, 'T-008', 'MEZCLADORA LAVABO MODELO 24T MARCA RUGO', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:23', 5, 5);
INSERT INTO `materiales` VALUES (13252, 1, 'T-028', 'MEZCLADORA PARA LAVABO MOD. 24 CT RUGO', 801, 'ECOTECNOLOGIAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:23', 5, 5);
INSERT INTO `materiales` VALUES (30253, 1, 'MEZ-100', 'MEZQUITE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:22', '2020-10-19 11:09:23', 5, 5);
INSERT INTO `materiales` VALUES (36697, 1, '', 'MICA PATCHWORK ITG PRO PLUS IPHONE XS MAX', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:24', 5, 5);
INSERT INTO `materiales` VALUES (16867, 1, 'A-88', 'MICROESFERA DE VIDRIO', 794, 'ACABADOS', 'BTO', 'BTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:24', 5, 5);
INSERT INTO `materiales` VALUES (30935, 1, 'MICRO-321', 'MICROFIBRA', 803, 'EXTRAS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:24', 5, 5);
INSERT INTO `materiales` VALUES (33788, 1, 'MFP-100', 'MICROPERFORADO PUERTA OFICINA PROYECTA', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:24', 5, 5);
INSERT INTO `materiales` VALUES (20158, 1, 'MABF', 'MIGUEL ANGEL BRETADO FEMAT', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:25', 5, 5);
INSERT INTO `materiales` VALUES (12359, 1, 'O-140', 'MINAS 0.5 MM HB HI-POLYMER B/3', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:25', 5, 5);
INSERT INTO `materiales` VALUES (13498, 1, 'MIG-01', 'MINGITORIO MARCA CATO', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:25', 5, 5);
INSERT INTO `materiales` VALUES (19863, 1, '0299', 'MINI SPLIT MARTA TRINE 1 TON. STANDAR', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:25', 5, 5);
INSERT INTO `materiales` VALUES (20237, 1, 'MINI SPLIT 2 TON', 'MINI SPLIT MIRAGE FRIO CALOR 2 TON.', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:26', 5, 5);
INSERT INTO `materiales` VALUES (13261, 1, '0-297', 'MINI SPLIT MIRAGE X3 INVERTER', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:26', 5, 5);
INSERT INTO `materiales` VALUES (13213, 1, '0-287', 'MINI SPLIT MOD 24812 MARCA HIFENSE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:26', 5, 5);
INSERT INTO `materiales` VALUES (13210, 1, '0-286', 'MINI SPLIT MOD.24811 MARCA HIFENSE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:27', 5, 5);
INSERT INTO `materiales` VALUES (20240, 1, 'MINI SPLIT 3 TON', 'MINI SPLIT PRIME FRIO CALOR 3 TON.', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:27', 5, 5);
INSERT INTO `materiales` VALUES (19865, 1, '0300', 'MINI SPLIT TRINE 1 1/2 TON. STANDAR', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:23', '2020-10-19 11:09:27', 5, 5);
INSERT INTO `materiales` VALUES (33266, 1, 'MSP-100', 'MINISPLIT FRIO-CALOR 220V INVERTER DE 1 TON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:24', '2020-10-19 11:09:28', 5, 5);
INSERT INTO `materiales` VALUES (33269, 1, 'MNS-150', 'MINISPLIT FRIO-CALOR 220V INVERTER DE 1.5 TON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:24', '2020-10-19 11:09:28', 5, 5);
INSERT INTO `materiales` VALUES (21669, 1, '0301', 'MINISPLIT FRIO-CALOR 220V INVERTER DE 2 TON', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:24', '2020-10-19 11:09:28', 5, 5);
INSERT INTO `materiales` VALUES (25569, 1, 'O302', 'MINISPLIT FRIO-CALOR DE 1 1/2 TON  INVERTER PRIME', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:24', '2020-10-19 11:09:28', 5, 5);
INSERT INTO `materiales` VALUES (34260, 1, 'MST-200', 'MINISPLIT VOZ Y DATOS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:24', '2020-10-19 11:09:28', 5, 5);
INSERT INTO `materiales` VALUES (13009, 1, 'O-259', 'MMDFBCO152-TRUPAN', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:24', '2020-10-19 11:09:29', 5, 5);
INSERT INTO `materiales` VALUES (13780, 1, 'O-1002', 'MOBILIARIO Y EQUIPO DE OFICINA', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:24', '2020-10-19 11:09:29', 5, 5);
INSERT INTO `materiales` VALUES (33097, 1, 'MOB-100', 'MOBILITY', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:24', '2020-10-19 11:09:29', 5, 5);
INSERT INTO `materiales` VALUES (34872, 1, 'MON-200', 'MONITOR SAMSUNG WQHD CURVO DE 32\"', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:24', '2020-10-19 11:09:29', 5, 5);
INSERT INTO `materiales` VALUES (11475, 1, '0-040', 'MONITOREO BASICO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:25', '2020-10-19 11:09:29', 5, 5);
INSERT INTO `materiales` VALUES (10864, 1, 'S-031', 'MONOMANDO SALIDA FLEXIBLE 2 TIPOS DE CHORRO SATIN', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:25', '2020-10-19 11:09:30', 5, 5);
INSERT INTO `materiales` VALUES (10066, 1, 'C-008', 'MORTERO BULTO', 810, 'CONCRETOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:25', '2020-10-19 11:09:30', 5, 5);
INSERT INTO `materiales` VALUES (10964, 1, 'C-012', 'MORTERO CON FIBRA', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:25', '2020-10-19 11:09:31', 5, 5);
INSERT INTO `materiales` VALUES (11036, 1, 'O-021', 'MOTOBOMBA 025MM 1 HP SH500A PUMPS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:25', '2020-10-19 11:09:31', 5, 5);
INSERT INTO `materiales` VALUES (36688, 1, '', 'MOUSE HP INALAMBRICO 220 PLATA CESTUCHE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:25', '2020-10-19 11:09:32', 5, 5);
INSERT INTO `materiales` VALUES (33592, 1, 'MUS-150', 'MOUSE OPTIO USB INALAMBRICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:32', 5, 5);
INSERT INTO `materiales` VALUES (25308, 1, 'MOV-101', 'MOVIMIENTO DE EQUIPO DE PERFORACION INC. KILOMETROS SUBSECUENTES', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:33', 5, 5);
INSERT INTO `materiales` VALUES (35517, 1, 'MPS-100', 'MOVIMIENTO DE PANELES SOLARES', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:33', 5, 5);
INSERT INTO `materiales` VALUES (13171, 1, '0-277', 'MOÑOS GDE BOLSA C/AMARILLO', 808, 'OTROS', 'BOLSA', 'BOLSA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:34', 5, 5);
INSERT INTO `materiales` VALUES (34155, 1, 'MDM-100', 'MUEBLE DE MADERA DE PINO Y CUBIERTA DE MARMOL', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:36', 5, 5);
INSERT INTO `materiales` VALUES (26749, 1, 'MCS-158', 'MUEBLES COMPLEMENTOS Y SERVICIOS', 794, 'ACABADOS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:36', 5, 5);
INSERT INTO `materiales` VALUES (19548, 1, '', 'MUFA 1 1/4', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:37', 5, 5);
INSERT INTO `materiales` VALUES (20320, 1, 'MR', 'MULTAS Y RECARGOS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:37', 5, 5);
INSERT INTO `materiales` VALUES (13753, 1, 'MP-001', 'MULTICONECTOR REFORSADO P/TINACO ROTOPLAS', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:37', 5, 5);
INSERT INTO `materiales` VALUES (33908, 1, 'MUL-200', 'MULTICONTACTO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:37', 5, 5);
INSERT INTO `materiales` VALUES (31086, 1, 'MUL-100', 'MULTIMETRO DIGITAL DE GANCHO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:37', 5, 5);
INSERT INTO `materiales` VALUES (13669, 1, 'M-001', 'MURC ARENA 193.1001', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:37', 5, 5);
INSERT INTO `materiales` VALUES (12071, 1, 'A-029', 'MURCIA LORCA A 60 X 60 DECO PRIMERA', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:26', '2020-10-19 11:09:38', 5, 5);
INSERT INTO `materiales` VALUES (10785, 1, 'E-043', 'MURETE SUBTERRANEO BT-04 DOBLE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:38', 5, 5);
INSERT INTO `materiales` VALUES (10789, 1, 'E-044', 'MURETE SUBTERRANEO BT-04 SENCILLO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:38', 5, 5);
INSERT INTO `materiales` VALUES (28126, 1, 'MUR-160', 'MURO AUSTRAL BLANCO 33*45 (1.60 CAJA ) (1 MURO AREA HUMEDA REGADERA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:38', 5, 5);
INSERT INTO `materiales` VALUES (28129, 1, 'MDJ-185', 'MURO DECO JOY GRIS 25*30 (10 PZAS POR CAJA) (2 MUROS AREA HUMEDA REGADERA )', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:38', 5, 5);
INSERT INTO `materiales` VALUES (26657, 1, 'PS-107', 'MURO GAUDI PLATA  1.44 m2 33.3X33.3 * CAJA MURO COCINA (.32 M2 )', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:38', 5, 5);
INSERT INTO `materiales` VALUES (28556, 1, 'MUR-161', 'MURO LIENZO GRIS 33X45 (1.60 CAJA )', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:39', 5, 5);
INSERT INTO `materiales` VALUES (34883, 1, 'MOS-100', 'MURO OSLO DE 37.5X55 DE 1.80mts POR CAJA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:39', 5, 5);
INSERT INTO `materiales` VALUES (25046, 1, 'MTP-150', 'Maceta Tula con pedestal chica encino - Blanco', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:39', 5, 5);
INSERT INTO `materiales` VALUES (24961, 1, 'MCG-122', 'Maceta grande Colít - Blanco', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:39', 5, 5);
INSERT INTO `materiales` VALUES (24914, 1, 'MHM-108', 'Mesa Hexa mediana - Blanco', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:39', 5, 5);
INSERT INTO `materiales` VALUES (24917, 1, 'MAM-109', 'Mesa auxiliar mediana Chroma - Negro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:39', 5, 5);
INSERT INTO `materiales` VALUES (24967, 1, 'MC-124', 'Mesa de Comedor Capica - Café', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:39', 5, 5);
INSERT INTO `materiales` VALUES (24911, 1, 'MDC-107', 'Mesa de centro Hexa 70cm - Blanco', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:27', '2020-10-19 11:09:40', 5, 5);
INSERT INTO `materiales` VALUES (24932, 1, 'MCZ-114', 'Mesa de centro Zanda - Negro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:40', 5, 5);
INSERT INTO `materiales` VALUES (24983, 1, 'MLA-129', 'Mesa lateral Atarjea - Negro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:40', 5, 5);
INSERT INTO `materiales` VALUES (25001, 1, 'MLA-135', 'Mesa lateral alta Chavinda - Nogal', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:40', 5, 5);
INSERT INTO `materiales` VALUES (25004, 1, 'MLB-136', 'Mesa lateral baja Chavinda - Nogal', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:40', 5, 5);
INSERT INTO `materiales` VALUES (24893, 1, 'MR-101', 'Mesa rectangular Hábito - Natural', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:40', 5, 5);
INSERT INTO `materiales` VALUES (24896, 1, 'ME-102', 'Mueble de bar Evo - Blanco', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:40', 5, 5);
INSERT INTO `materiales` VALUES (24970, 1, 'MPT-125', 'Mueble para tv Evo nogal 120cm - Blanco', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:41', 5, 5);
INSERT INTO `materiales` VALUES (25016, 1, 'MPT-142', 'Mueble para tv abierto alto Nonoalco - Amarillo con encino', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:41', 5, 5);
INSERT INTO `materiales` VALUES (31339, 1, 'NAV-100', 'NAVAJA RETRACTIL MULTIUSOS ( COD. 16950 )', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:41', 5, 5);
INSERT INTO `materiales` VALUES (30912, 1, 'CAFE', 'NESTCAFE', 803, 'EXTRAS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:41', 5, 5);
INSERT INTO `materiales` VALUES (16926, 1, 'H-127', 'NIPLE GALVANIZADO  006X050MM 1/4X2 STANDARD', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:41', 5, 5);
INSERT INTO `materiales` VALUES (11096, 1, 'G-027', 'NIPLE GALVANIZADO 1/2\" ROSCA CORRIDA', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:42', 5, 5);
INSERT INTO `materiales` VALUES (12576, 1, 'H-099', 'NIPLE ROSCA CORRIDA 1\" GALVANIZADO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:28', '2020-10-19 11:09:42', 5, 5);
INSERT INTO `materiales` VALUES (22467, 1, 'H-501', 'NIPLE TUBO GALVANIZADO 1/2 X 60CM', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:29', '2020-10-19 11:09:42', 5, 5);
INSERT INTO `materiales` VALUES (20575, 1, 'H-315', 'NIPLE TUBO GALVANIZADO 1/2X60 CM', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:29', '2020-10-19 11:09:42', 5, 5);
INSERT INTO `materiales` VALUES (10470, 1, 'H-015', 'NIPLE TUBO GALVANIZADO DE 1/2\" DE DIAMETRO X3\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:29', '2020-10-19 11:09:42', 5, 5);
INSERT INTO `materiales` VALUES (10466, 1, 'H-014', 'NIPLE TUBO GALVANIZADO DE 1/2\" DE DIAMETRO X50 CMS.', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:29', '2020-10-19 11:09:43', 5, 5);
INSERT INTO `materiales` VALUES (12459, 1, 'O-149', 'NIVEL 36\"', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:29', '2020-10-19 11:09:43', 5, 5);
INSERT INTO `materiales` VALUES (21997, 1, 'ND', 'NO DEDUCIBLES', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:29', '2020-10-19 11:09:43', 5, 5);
INSERT INTO `materiales` VALUES (12528, 1, 'O-158', 'NOCHE BUENA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:29', '2020-10-19 11:09:43', 5, 5);
INSERT INTO `materiales` VALUES (13345, 1, 'IN-01', 'NOMENCLATURAS CALLES', 822, 'INFRAESTRUCTURA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:29', '2020-10-19 11:09:44', 5, 5);
INSERT INTO `materiales` VALUES (13306, 1, '0-311', 'NOTAS REMISION', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:29', '2020-10-19 11:09:44', 5, 5);
INSERT INTO `materiales` VALUES (26927, 1, 'NUO-174', 'NUMEROS OFICIALES', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:30', '2020-10-19 11:09:45', 5, 5);
INSERT INTO `materiales` VALUES (12331, 1, 'OF-VI65', 'OFERTA DE VIVIENDA', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:30', '2020-10-19 11:09:45', 5, 5);
INSERT INTO `materiales` VALUES (34640, 1, 'OFS-020', 'OFICIO SEGUNDO PERIODO 2020', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:30', '2020-10-19 11:09:45', 5, 5);
INSERT INTO `materiales` VALUES (33622, 1, 'ORG-185', 'ORGANIZADOR MES OVALADO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:30', '2020-10-19 11:09:45', 5, 5);
INSERT INTO `materiales` VALUES (26514, 1, 'ORG-100', 'ORGANOS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:30', '2020-10-19 11:09:46', 5, 5);
INSERT INTO `materiales` VALUES (27134, 1, 'ORQ-108', 'ORQ No. 4', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:30', '2020-10-19 11:09:46', 5, 5);
INSERT INTO `materiales` VALUES (27131, 1, 'ORQ-107', 'ORQ No. 5', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:30', '2020-10-19 11:09:46', 5, 5);
INSERT INTO `materiales` VALUES (27128, 1, 'ORQ-106', 'ORQ No. 6', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:30', '2020-10-19 11:09:47', 5, 5);
INSERT INTO `materiales` VALUES (12299, 1, 'O-133', 'OTROS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:30', '2020-10-19 11:09:47', 5, 5);
INSERT INTO `materiales` VALUES (12684, 1, 'O-183', 'PAGINA WEB', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:30', '2020-10-19 11:09:47', 5, 5);
INSERT INTO `materiales` VALUES (34208, 1, 'PAF-100', 'PAGO DE AJUSTE POR DIFERENCIA', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:48', 5, 5);
INSERT INTO `materiales` VALUES (25876, 1, 'PAD-100', 'PAGO DE APEO Y DESLINDE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:48', 5, 5);
INSERT INTO `materiales` VALUES (24244, 1, 'PD-001', 'PAGO DE DECLARACION', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:48', 5, 5);
INSERT INTO `materiales` VALUES (32253, 1, 'PDD-100', 'PAGO DE DEDUCIBLE', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:49', 5, 5);
INSERT INTO `materiales` VALUES (28167, 1, 'PDL-100', 'PAGO DE LICENCIA DE ALCOHOLES', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:49', 5, 5);
INSERT INTO `materiales` VALUES (24807, 1, 'PP-101', 'PAGO DE PRESTAMO 83823138 - 616', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:49', 5, 5);
INSERT INTO `materiales` VALUES (23853, 1, 'PR-09', 'PAGO DE REFRENDOS Y PLACAS', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO                      ', '2020-10-19 11:03:31', '2021-02-23 15:54:41', 5, 0);
INSERT INTO `materiales` VALUES (24265, 1, 'US-01', 'PAGO DE USO DE SUELO', 806, 'URBANIZACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:50', 5, 5);
INSERT INTO `materiales` VALUES (29010, 1, 'PDC-100', 'PAGO DE VIVIENDA A CUF', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:50', 5, 5);
INSERT INTO `materiales` VALUES (25757, 1, 'PP-102', 'PAGO PRESTAMO 85215819 - 992', 808, 'OTROS', 'pieza', 'pieza', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:50', 5, 5);
INSERT INTO `materiales` VALUES (33728, 1, 'PAL-200', 'PALA C17193', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:50', 5, 5);
INSERT INTO `materiales` VALUES (33712, 1, 'PLC-150', 'PALA CUADRADA MANGO LARGO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:31', '2020-10-19 11:09:51', 5, 5);
INSERT INTO `materiales` VALUES (10570, 1, 'O-002', 'PALA CUADRADA MANGO LARGO.', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:51', 5, 5);
INSERT INTO `materiales` VALUES (33709, 1, 'PRM-100 ', 'PALA REDONDA MANGO LARGO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:51', 5, 5);
INSERT INTO `materiales` VALUES (13078, 1, 'P-199', 'PALERMO IVORY 40 X 40  PRIMERA', 795, 'PISOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:51', 5, 5);
INSERT INTO `materiales` VALUES (29435, 1, 'PAL-101', 'PALMA AGAVE', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:52', 5, 5);
INSERT INTO `materiales` VALUES (29432, 1, 'PAL-100', 'PALMA CYCA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:52', 5, 5);
INSERT INTO `materiales` VALUES (29450, 1, 'PAL-202', 'PALMA MAICERA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:52', 5, 5);
INSERT INTO `materiales` VALUES (12546, 1, 'O-163', 'PAMPAGRAS GRANDE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:53', 5, 5);
INSERT INTO `materiales` VALUES (13060, 1, 'O-302', 'PANEL DE 1.22 X 2.44 M', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:53', 5, 5);
INSERT INTO `materiales` VALUES (12816, 1, 'O-198', 'PANEL, REJA DE ACERO', 795, 'PISOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:53', 5, 5);
INSERT INTO `materiales` VALUES (33866, 1, 'PNA', 'PANTALON ATAN', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:53', 5, 5);
INSERT INTO `materiales` VALUES (27332, 1, 'PP-030', 'PAPAYO .30 DORADO & PALTA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:54', 5, 5);
INSERT INTO `materiales` VALUES (27335, 1, 'PP-040', 'PAPAYO .40 DORADO & PLATA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:54', 5, 5);
INSERT INTO `materiales` VALUES (27342, 1, 'PP-050', 'PAPAYO .50 DORADO & PLATA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:32', '2020-10-19 11:09:54', 5, 5);
INSERT INTO `materiales` VALUES (27338, 1, 'PP-060', 'PAPAYO .60 DORADO & PLATA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:54', 5, 5);
INSERT INTO `materiales` VALUES (27345, 1, 'PP-080', 'PAPAYO .80 DORADO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:55', 5, 5);
INSERT INTO `materiales` VALUES (32267, 1, 'PBD-100', 'PAPEL BOND DOBLE CARA TAMAÑO CARTA', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:55', 5, 5);
INSERT INTO `materiales` VALUES (30715, 1, '1103-186-002', 'PAPEL HIGIENICO ECOLOGICO SANISOL', 803, 'EXTRAS', 'CAJA', 'PIEZAS', '12', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:56', 5, 5);
INSERT INTO `materiales` VALUES (13567, 1, 'O-307', 'PAPELERIA OFICINA, ', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:56', 5, 5);
INSERT INTO `materiales` VALUES (24207, 1, 'P4-001', 'PAQUETE DE 4 MONTAJE CON ALINEACION Y BALANCEO', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:56', 5, 5);
INSERT INTO `materiales` VALUES (11663, 1, 'O-059', 'PAQUETE HOJAS TAMAÑO TABLOIDE', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:56', 5, 5);
INSERT INTO `materiales` VALUES (29429, 1, 'PAR-90', 'PAR DE ESPEJITOS CUADRADOS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:56', 5, 5);
INSERT INTO `materiales` VALUES (29465, 1, 'PAR-100', 'PAR DE FOLLAJE VERDE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:57', 5, 5);
INSERT INTO `materiales` VALUES (13732, 1, 'PA-001', 'PARRILLA GAS 60 CM ACERO INOX', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:57', 5, 5);
INSERT INTO `materiales` VALUES (10685, 1, 'H-043', 'PASTA PARA SOLDAR (100 GMS.)', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:33', '2020-10-19 11:09:57', 5, 5);
INSERT INTO `materiales` VALUES (13249, 1, 'E-080', 'PASTILLA 2X20 ', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:57', 5, 5);
INSERT INTO `materiales` VALUES (11112, 1, 'E-048', 'PASTILLA 2X30', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:57', 5, 5);
INSERT INTO `materiales` VALUES (33292, 1, '1201-128-014', 'PASTILLA WIESE AROMATIZANTE C/GANCHO 70 GRS', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:58', 5, 5);
INSERT INTO `materiales` VALUES (30730, 1, '1201-128-030', 'PASTILLA WIESE CLORO 35 GRS', 803, 'EXTRAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:58', 5, 5);
INSERT INTO `materiales` VALUES (11156, 1, 'O-026', 'PASTO', 808, 'OTROS', 'MTS', 'MTS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:58', 5, 5);
INSERT INTO `materiales` VALUES (21966, 1, 'O-385', 'PAVIMENTACION ASFALTICA', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:58', 5, 5);
INSERT INTO `materiales` VALUES (25538, 1, 'U-014', 'PAVIMENTO ASFALTICO DE 4.0 CM DE ESPESOR COMPACTO PROMEDIO, CON MEZCLA ASFALTICA EN CALIENTE, TENDIDA CON MAQUINA TERMINADORA, INCLUYE: SUMINISTRO DE MEZCLA, TENDIDA Y COMPACTADA', 806, 'URBANIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:58', 5, 5);
INSERT INTO `materiales` VALUES (31455, 1, 'PA-100', 'PAÑO MICROFIBRA SUPEL LISAC40*40', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:59', 5, 5);
INSERT INTO `materiales` VALUES (11322, 1, 'AC-018', 'PEDESTAL MODELO JAZMIN COLOR BLANCO MARCA CATO', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:59', 5, 5);
INSERT INTO `materiales` VALUES (10050, 1, 'C-001', 'PEGACRETO', 810, 'CONCRETOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:59', 5, 5);
INSERT INTO `materiales` VALUES (17889, 1, 'H-128', 'PEGAMENTO P/PVC TRANSPARENTE', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:59', 5, 5);
INSERT INTO `materiales` VALUES (12699, 1, 'H-112', 'PEGAMENTO PARA CPVC 1/2 FLOWGUARD', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:34', '2020-10-19 11:09:59', 5, 5);
INSERT INTO `materiales` VALUES (10530, 1, 'H-031', 'PEGAMENTO PARA CPVC DE 1/8\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:35', '2020-10-19 11:10:00', 5, 5);
INSERT INTO `materiales` VALUES (13417, 1, '0-329', 'PEGAMENTO PARA MADERA', 808, 'OTROS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:35', '2020-10-19 11:10:00', 5, 5);
INSERT INTO `materiales` VALUES (9750, 1, 'S-016', 'PEGAMENTO PARA PVC 16OZ 1/2 RAIN SHINE AZUL', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:35', '2020-10-19 11:10:00', 5, 5);
INSERT INTO `materiales` VALUES (11721, 1, 'S-40', 'PEGAMENTO PARA PVC 16OZ 1/4 RAIN SHINE AZUL', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:35', '2020-10-19 11:10:00', 5, 5);
INSERT INTO `materiales` VALUES (13720, 1, 'S-177', 'PEGAMENTO PARA PVC 16OZ 1LI  RAIN SHINE AZUL', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:35', '2020-10-19 11:10:00', 5, 5);
INSERT INTO `materiales` VALUES (19676, 1, 'PEG-PISO31', 'PEGAMENTO PISO S/PISO CRES', 794, 'ACABADOS', 'BTO.', 'BTO.', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:35', '2020-10-19 11:10:01', 5, 5);
INSERT INTO `materiales` VALUES (11902, 1, 'O-081', 'PEGAMENTO TIPO ELMER¨S ENVASADO', 808, 'OTROS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:35', '2020-10-19 11:10:01', 5, 5);
INSERT INTO `materiales` VALUES (12543, 1, 'O-162', 'PENISETUM ROJO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:35', '2020-10-19 11:10:01', 5, 5);
INSERT INTO `materiales` VALUES (9862, 1, 'AC-004', 'PEPE SILICON BLANCO ', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:35', '2020-10-19 11:10:01', 5, 5);
INSERT INTO `materiales` VALUES (25314, 1, 'PER-103', 'PERFORACION DE POZO EN 12\" DE DIAMETRO EN MATERIAL TIPO II DE 0.00 A 60.00m DE PROFUNDIDAD', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:36', '2020-10-19 11:10:01', 5, 5);
INSERT INTO `materiales` VALUES (35389, 1, 'PEF-150', 'PERFORADORA P/ACCO METAL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:36', '2020-10-19 11:10:02', 5, 5);
INSERT INTO `materiales` VALUES (33568, 1, 'PER-250', 'PERFORADORA P/GAFETE METALICA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:36', '2020-10-19 11:10:02', 5, 5);
INSERT INTO `materiales` VALUES (27619, 1, 'PER-174', 'PERIQUERA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:36', '2020-10-19 11:10:02', 5, 5);
INSERT INTO `materiales` VALUES (27394, 1, 'PER-139', 'PERIQUERA GLENDA .80 DE DIAMETRO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:36', '2020-10-19 11:10:02', 5, 5);
INSERT INTO `materiales` VALUES (25189, 1, 'PE-102', 'PERITAJE ESTRUCTURAL', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:36', '2020-10-19 11:10:02', 5, 5);
INSERT INTO `materiales` VALUES (36959, 1, 'PER-150', 'PERLITA EXPANSIVA DE 100 LTS', 794, 'ACABADOS', 'BOLSA', 'BOLSA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:36', '2020-10-19 11:10:02', 5, 5);
INSERT INTO `materiales` VALUES (34304, 1, 'PEO-100', 'PERMISO EXTRA OFICIAL P/CONECTARSE A COLECTOR EXISTENTE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:03', 5, 5);
INSERT INTO `materiales` VALUES (15117, 1, 'PERS-852', 'PERSIANAS', 800, 'ACCESORIOS', '1', '1', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:03', 5, 5);
INSERT INTO `materiales` VALUES (29250, 1, 'PEZ-101', 'PEZ MOLLY VARIOS COLORES', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:03', 5, 5);
INSERT INTO `materiales` VALUES (12468, 1, 'H-089', 'PICHANCHA 3/4\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:03', 5, 5);
INSERT INTO `materiales` VALUES (11596, 1, 'H-071', 'PICHANCHA DE 1/2  PULGADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:03', 5, 5);
INSERT INTO `materiales` VALUES (35604, 1, 'PCH-174', 'PICHANCHA DE 2  PULGADA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:04', 5, 5);
INSERT INTO `materiales` VALUES (10574, 1, 'O-003', 'PICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:04', 5, 5);
INSERT INTO `materiales` VALUES (13657, 1, 'P-111', 'PIEDRA GRAVA BLANCA', 794, 'ACABADOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:04', 5, 5);
INSERT INTO `materiales` VALUES (12531, 1, 'O-159', 'PIEDRA MARMOL', 808, 'OTROS', 'COSTAL', 'COSTAL', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:04', 5, 5);
INSERT INTO `materiales` VALUES (13456, 1, 'E-085', 'PIJA 3\" 1/2 PARA PORTALAMPARA', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:04', 5, 5);
INSERT INTO `materiales` VALUES (10310, 1, 'S-018', 'PIJA DE 3\" PARA WC', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:04', 5, 5);
INSERT INTO `materiales` VALUES (13486, 1, 'PM-11041', 'PIJA FIJADORA 8 13MM 1/2 PAN', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:05', 5, 5);
INSERT INTO `materiales` VALUES (10314, 1, 'S-019', 'PIJA PARA LAVABO 14X2 C/100', 783, 'SANITARIA', 'BOLSA', 'BOLSA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:37', '2020-10-19 11:10:05', 5, 5);
INSERT INTO `materiales` VALUES (10174, 1, 'E-013', 'PIJA PARA PORTALAMPARA 8X1\" CAJA CON 200 PZAS.', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:05', 5, 5);
INSERT INTO `materiales` VALUES (10924, 1, 'H-056', 'PIJAS DE 3 PARA PIJAS EN WC', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:05', 5, 5);
INSERT INTO `materiales` VALUES (13642, 1, 'E-086', 'PIJAS PARA LAVABO CAJA CON 100', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:05', 5, 5);
INSERT INTO `materiales` VALUES (34301, 1, 'PPT-185', 'PIJAS PARA TARJA DE 8X2\"', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:07', 5, 5);
INSERT INTO `materiales` VALUES (24349, 1, 'PE-AA1', 'PILA ENERGIZER AA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:08', 5, 5);
INSERT INTO `materiales` VALUES (36311, 1, 'PE-AAA', 'PILA ENERGIZER AAA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:09', 5, 5);
INSERT INTO `materiales` VALUES (13435, 1, '0-335', 'PILA LTH TIIDA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:09', 5, 5);
INSERT INTO `materiales` VALUES (13606, 1, 'A-87', 'PINTURA', 794, 'ACABADOS', 'LTS', 'LTS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:10', 5, 5);
INSERT INTO `materiales` VALUES (13915, 1, 'O-351', 'PINTURA  INT PRIMA ALPACCI COD K5-06', 808, 'OTROS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:10', 5, 5);
INSERT INTO `materiales` VALUES (13801, 1, 'AL-001', 'PINTURA ALPACCI 1 LIT INTERIOR', 794, 'ACABADOS', 'LIT', 'LIT', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:10', 5, 5);
INSERT INTO `materiales` VALUES (13273, 1, 'A-86', 'PINTURA AMARILLA  J2-14', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:10', 5, 5);
INSERT INTO `materiales` VALUES (12783, 1, 'A-79', 'PINTURA BOTERO', 794, 'ACABADOS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:11', 5, 5);
INSERT INTO `materiales` VALUES (12786, 1, 'A-80', 'PINTURA CHAPELLE', 794, 'ACABADOS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:38', '2020-10-19 11:10:11', 5, 5);
INSERT INTO `materiales` VALUES (9846, 1, 'A-017', 'PINTURA COLOR BLANCO', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:11', 5, 5);
INSERT INTO `materiales` VALUES (13684, 1, 'A-25', 'PINTURA COLOR MARCUNA H5-02', 794, 'ACABADOS', 'CUBETA ', 'CUBETA ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:11', 5, 5);
INSERT INTO `materiales` VALUES (12522, 1, 'O-156', 'PINTURA DE ACEITE AMARILLA TRAFICO', 808, 'OTROS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:12', 5, 5);
INSERT INTO `materiales` VALUES (12519, 1, 'O-155', 'PINTURA DE ACEITE NEGRA', 808, 'OTROS', 'LTO', 'LTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:12', 5, 5);
INSERT INTO `materiales` VALUES (31722, 1, 'PNA-100', 'PINTURA EN AEROSOL', 797, 'PINTURAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:12', 5, 5);
INSERT INTO `materiales` VALUES (13798, 1, 'ES-001', 'PINTURA ESPECIA  1 LIT', 794, 'ACABADOS', 'LIT', 'LIT', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:13', 5, 5);
INSERT INTO `materiales` VALUES (13924, 1, 'O-354', 'PINTURA EXTERIOR BINIMEX ESPECIA COD J5-09', 808, 'OTROS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:14', 5, 5);
INSERT INTO `materiales` VALUES (12438, 1, 'A-75', 'PINTURA GRIS', 794, 'ACABADOS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:14', 5, 5);
INSERT INTO `materiales` VALUES (12435, 1, 'A-74', 'PINTURA GRIS BOULEVARD', 794, 'ACABADOS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:14', 5, 5);
INSERT INTO `materiales` VALUES (13918, 1, 'O-352', 'PINTURA INT PRIMA JICAMA COD K5-01', 808, 'OTROS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:15', 5, 5);
INSERT INTO `materiales` VALUES (13921, 1, 'O-353', 'PINTURA INT PRIMA VODKA TONIC COD L5-02', 808, 'OTROS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:15', 5, 5);
INSERT INTO `materiales` VALUES (13201, 1, 'A-085', 'PINTURA MATE DE ACEITE', 794, 'ACABADOS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:39', '2020-10-19 11:10:15', 5, 5);
INSERT INTO `materiales` VALUES (13177, 1, 'A-056', 'PINTURA NEGRA DE AGUA', 794, 'ACABADOS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:15', 5, 5);
INSERT INTO `materiales` VALUES (12780, 1, 'A-78', 'PINTURA NOSTALGIA ', 794, 'ACABADOS', 'LITROS', 'LITROS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:16', 5, 5);
INSERT INTO `materiales` VALUES (13006, 1, 'A-70', 'PINTURA REAL FLEX', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:16', 5, 5);
INSERT INTO `materiales` VALUES (13045, 1, 'A-82', 'PINTURA ROJA VELMAR ', 794, 'ACABADOS', 'GALON', 'GALON', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:16', 5, 5);
INSERT INTO `materiales` VALUES (12432, 1, 'A-73', 'PINTURA ROSA ALEBRIJE ', 794, 'ACABADOS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:16', 5, 5);
INSERT INTO `materiales` VALUES (13270, 1, 'A-85', 'PINTURA ROSA C1-13', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:17', 5, 5);
INSERT INTO `materiales` VALUES (12426, 1, 'A-71', 'PINTURA ROSA MEXICANO', 794, 'ACABADOS', 'LITROS', 'LITROS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:17', 5, 5);
INSERT INTO `materiales` VALUES (12940, 1, 'A-050', 'PINTURA TROPICO ( J2-14 )', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:17', 5, 5);
INSERT INTO `materiales` VALUES (13804, 1, 'TU-001', 'PINTURA TUDOR 1 LIT INTERIOR', 794, 'ACABADOS', 'LIT', 'LIT', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:17', 5, 5);
INSERT INTO `materiales` VALUES (12429, 1, 'A-72', 'PINTURA VERDE', 794, 'ACABADOS', 'LITRO', 'LITRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:18', 5, 5);
INSERT INTO `materiales` VALUES (32204, 1, 'PIV-100', 'PINTURA VIVID B1 ( BLANCO OSTION )', 797, 'PINTURAS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:40', '2020-10-19 11:10:18', 5, 5);
INSERT INTO `materiales` VALUES (13807, 1, 'VO-001', 'PINTURA VODKA TONIC 1 LIT INTERIOR', 794, 'ACABADOS', 'LIT', 'LIT', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:18', 5, 5);
INSERT INTO `materiales` VALUES (13795, 1, 'Y-001', 'PINTURA YOUGURTH 1 LIT', 794, 'ACABADOS', 'LIT', 'LIT', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:18', 5, 5);
INSERT INTO `materiales` VALUES (31225, 1, 'PIN-100', 'PINZAS ELECTRICAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:19', 5, 5);
INSERT INTO `materiales` VALUES (26236, 1, 'PCH-100', 'PIRAL CHINO DE 3.00 MTS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:19', 5, 5);
INSERT INTO `materiales` VALUES (13852, 1, 'P-027', 'PISO  CREMA MARFIL CLARO', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:19', 5, 5);
INSERT INTO `materiales` VALUES (17869, 1, 'P-29', 'PISO  MONTPELLIER  GRIGIO 40X60', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:19', 5, 5);
INSERT INTO `materiales` VALUES (13747, 1, 'P-026', 'PISO  PARANA IVORY 60X60 PULIDO PRIMERA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:20', 5, 5);
INSERT INTO `materiales` VALUES (35904, 1, 'PAT-153', 'PISO ANTIDERRAPANTE 20X20 1.53XCAJA TESSUTI', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:20', 5, 5);
INSERT INTO `materiales` VALUES (13873, 1, 'P-028', 'PISO AQUARELLE NAPLES IVORY 60X60 PRIMERA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:21', 5, 5);
INSERT INTO `materiales` VALUES (36569, 1, 'PBT-100', 'PISO BAJA TECATE 45X45 1.62 M2', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:21', 5, 5);
INSERT INTO `materiales` VALUES (19670, 1, 'P-050', 'PISO BERNAL GRIS 60X60', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:21', 5, 5);
INSERT INTO `materiales` VALUES (18593, 1, 'P-31', 'PISO CEMENTINE CONSTRAST CIRCOLI 40X40 PRIMERA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:41', '2020-10-19 11:10:21', 5, 5);
INSERT INTO `materiales` VALUES (18596, 1, 'P-33', 'PISO CEMENTINE CONTRAST CROCE 40X40 PRIMERA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:21', 5, 5);
INSERT INTO `materiales` VALUES (18599, 1, 'P-34', 'PISO HABITAT SMOKE 40X60 PRIMERA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:21', 5, 5);
INSERT INTO `materiales` VALUES (26654, 1, 'PS-106', 'PISO MALIBU AD BLANCO  20X20 CM 1.53M2 ANTIDERRAPANTE ( 2.92 M2 )', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:21', 5, 5);
INSERT INTO `materiales` VALUES (26651, 1, 'PS-109', 'PISO MELBOURNE KNOX 45X45 1.62 X CAJA FACHADA      ( 8.85 M2 )', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:21', 5, 5);
INSERT INTO `materiales` VALUES (10615, 1, 'P-008', 'PISO MODELO MURCIA SAGE 60X60 PRIMERA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:22', 5, 5);
INSERT INTO `materiales` VALUES (28123, 1, 'PIS-150', 'PISO MONET CEDRO    .25X1.00  1.50 M2  X CAJA  BAÑO Y ESCALERA  (11.66 M2)', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:22', 5, 5);
INSERT INTO `materiales` VALUES (26662, 1, 'PS-108', 'PISO MONET NOGAL   25X1.00  1.50 X CAJA  BAÑO y  ESCALERA (10.63 M2 )', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:22', 5, 5);
INSERT INTO `materiales` VALUES (26648, 1, 'PNW-060', 'PISO NAPA WHITE 60X60 1.80 M2 X CAJA   MUROS Y PISO COCINA ( 13.77 M2 )', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:22', 5, 5);
INSERT INTO `materiales` VALUES (26645, 1, 'MV183', 'PISO SANTORINI  GRIS  1.54 X CAJA DE 55X55 por caja PISO VIVIENDA ( 53.64 M2)', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:22', 5, 5);
INSERT INTO `materiales` VALUES (26044, 1, 'MO-110', 'PISOS', 794, 'ACABADOS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:22', 5, 5);
INSERT INTO `materiales` VALUES (13402, 1, '0-326', 'PISTOLA GRAPADORA  DE TAPICERIA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:22', 5, 5);
INSERT INTO `materiales` VALUES (13405, 1, '0-327', 'PISTOLA GRAPADORA DOBLE DE 1/4 A 1 1/2 DE LARGO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:42', '2020-10-19 11:10:22', 5, 5);
INSERT INTO `materiales` VALUES (20264, 1, 'PIST. SIL', 'PISTOLA PARA SILICN', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:23', 5, 5);
INSERT INTO `materiales` VALUES (27348, 1, 'PNP-181', 'PIÑAS PLATA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:23', 5, 5);
INSERT INTO `materiales` VALUES (11286, 1, 'POL-024', 'PLACA 10L MEDIDA 10X2.44X1 1/4\"', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:23', 5, 5);
INSERT INTO `materiales` VALUES (11290, 1, 'POL-025', 'PLACA 10L MEDIDA 30X2.44X1 1/4\"', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:23', 5, 5);
INSERT INTO `materiales` VALUES (18980, 1, '', 'PLACA 3 MODULOS MARFIL SIMON 25', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:23', 5, 5);
INSERT INTO `materiales` VALUES (10290, 1, 'POL-008', 'PLACA AISLAMIENTO .12X2.44X1 1/4\" PARA CALLES DE AZOTEA', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:23', 5, 5);
INSERT INTO `materiales` VALUES (11455, 1, 'POL-026', 'PLACA AISLAMIENTO 2.44X.12X1/2\" PARA CALLE DE AZOTEA', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:23', 5, 5);
INSERT INTO `materiales` VALUES (11120, 1, 'E-050', 'PLACA ALUM C/CHASIS 3 ACERO BTICINO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:24', 5, 5);
INSERT INTO `materiales` VALUES (11124, 1, 'E-051', 'PLACA ALUM C/CHASIS ACERO CIEGA BITICINO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:24', 5, 5);
INSERT INTO `materiales` VALUES (12181, 1, 'POL-041', 'PLACA DE POLISTIRENO 10L 2.58 X .12 X 1 1/4\" PARA CALLE DE ASOTEA', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:24', 5, 5);
INSERT INTO `materiales` VALUES (9694, 1, 'POL-002', 'PLACA JUNTA DE .15X1.25X1/2\" PARA LOSA CIMENTACION', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:24', 5, 5);
INSERT INTO `materiales` VALUES (10270, 1, 'POL-003', 'PLACA JUNTA DE .25X2.44X1/2\" PARA CERRAMIENTO', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:43', '2020-10-19 11:10:24', 5, 5);
INSERT INTO `materiales` VALUES (34535, 1, 'PCM-185', 'PLACA METALICA DE 3/16 P/ESCALERA', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:24', 5, 5);
INSERT INTO `materiales` VALUES (10178, 1, 'E-014', 'PLACA PARA CONTACTO DE INTEMPERIE KLEY', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:24', 5, 5);
INSERT INTO `materiales` VALUES (10286, 1, 'POL-007', 'PLACA PARA JUNTA .20X2.44X1/2\" DENSIDAD DE 10 PARA AZOTEA', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:25', 5, 5);
INSERT INTO `materiales` VALUES (12185, 1, 'POL-042', 'PLACA POLIESTIRENO 10L 3.36 X12 X 1 1/4 \"', 812, 'POLIESTIRENO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:25', 5, 5);
INSERT INTO `materiales` VALUES (26016, 1, 'MO-101', 'PLANCHERO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:25', 5, 5);
INSERT INTO `materiales` VALUES (14892, 1, 'O-373', 'PLANO CATASTRAL', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:25', 5, 5);
INSERT INTO `materiales` VALUES (14896, 1, 'O-374', 'PLANO CATASTRAL.', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:25', 5, 5);
INSERT INTO `materiales` VALUES (24645, 1, 'PA-101', 'PLANOS ARQUITECTONICOS', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:25', 5, 5);
INSERT INTO `materiales` VALUES (29411, 1, 'PLA-30', 'PLANTA HOJA ABIERTA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:25', 5, 5);
INSERT INTO `materiales` VALUES (12873, 1, 'O-211', 'PLANTAS', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:25', 5, 5);
INSERT INTO `materiales` VALUES (35462, 1, 'PFC-200', 'PLANTAS FLORALES CITRICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:25', 5, 5);
INSERT INTO `materiales` VALUES (25597, 1, 'U-016', 'PLANTILLA DE ARENA DE 10 CM DE ESPESOR , INCLUYE SUMINISTRO DE MATERIA Y MANO DE OBRA', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:44', '2020-10-19 11:10:26', 5, 5);
INSERT INTO `materiales` VALUES (27673, 1, 'PLT-185', 'PLATAFORMA EN FRACCIONAMIENTO DE MISIONES', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:26', 5, 5);
INSERT INTO `materiales` VALUES (19977, 1, 'URB-010', 'PLATAFORMAS', 806, 'URBANIZACION', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:26', 5, 5);
INSERT INTO `materiales` VALUES (9589, 1, 'URB-001', 'PLATAFORMAS PARA LOSA DE CIMENTACION', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:26', 5, 5);
INSERT INTO `materiales` VALUES (27113, 1, 'PLT-102', 'PLATITO GOTERO CHICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:26', 5, 5);
INSERT INTO `materiales` VALUES (27116, 1, 'PLT-103', 'PLATITO GOTERO GRANDE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:26', 5, 5);
INSERT INTO `materiales` VALUES (27255, 1, 'PLT-128', 'PLATO BASE 2 CMS - LS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:26', 5, 5);
INSERT INTO `materiales` VALUES (27272, 1, 'PLT-133', 'PLATO CUADRADO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:27', 5, 5);
INSERT INTO `materiales` VALUES (27258, 1, 'PLT-129', 'PLATO PASTEL 20cms - LS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:27', 5, 5);
INSERT INTO `materiales` VALUES (27266, 1, 'PLT-131', 'PLATO PLANO CON BORDE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:27', 5, 5);
INSERT INTO `materiales` VALUES (27278, 1, 'PLR-134', 'PLATO RECTANGULAR DE 29X18 CMS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:27', 5, 5);
INSERT INTO `materiales` VALUES (12350, 1, 'O-137', 'PLOTEO B&N PAPEL BOND POR CM', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:45', '2020-10-19 11:10:27', 5, 5);
INSERT INTO `materiales` VALUES (35724, 1, 'PCB-500', 'PLUMA CORRECTIVA BIC', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:46', '2020-10-19 11:10:27', 5, 5);
INSERT INTO `materiales` VALUES (12026, 1, 'O-101', 'PLUMAS PAPER MATE C/12', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:46', '2020-10-19 11:10:27', 5, 5);
INSERT INTO `materiales` VALUES (31345, 1, 'POD-100', 'PODADORA CON MOTOR ( COD. 19968 )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:46', '2020-10-19 11:10:28', 5, 5);
INSERT INTO `materiales` VALUES (12278, 1, 'O-126', 'PODER', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:46', '2020-10-19 11:10:28', 5, 5);
INSERT INTO `materiales` VALUES (10234, 1, 'E-028', 'POLIDUCTO  DE 1 1/4\"', 791, 'ELECTRIFICACION', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:46', '2020-10-19 11:10:28', 5, 5);
INSERT INTO `materiales` VALUES (10242, 1, 'E-030', 'POLIDUCTO  DE 1/2\"', 791, 'ELECTRIFICACION', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:47', '2020-10-19 11:10:28', 5, 5);
INSERT INTO `materiales` VALUES (10238, 1, 'E-029', 'POLIDUCTO  DE 3/4\"', 791, 'ELECTRIFICACION', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:47', '2020-10-19 11:10:28', 5, 5);
INSERT INTO `materiales` VALUES (11218, 1, 'E-055', 'POLIDUCTO 1 1/4 PAT', 791, 'ELECTRIFICACION', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:47', '2020-10-19 11:10:28', 5, 5);
INSERT INTO `materiales` VALUES (33994, 1, 'PLF-100', 'POLIDUCTO FLEXIBLE METALICO DE 1/2', 791, 'ELECTRIFICACION', 'M.L.', 'M.L.', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:47', '2020-10-19 11:10:28', 5, 5);
INSERT INTO `materiales` VALUES (34918, 1, 'POF-100', 'POLIDUCTO FLEXIBLE REFORZADO RAIN BIRD MTO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:47', '2020-10-19 11:10:29', 5, 5);
INSERT INTO `materiales` VALUES (11140, 1, 'E-054', 'POLIDUCTO NARANJA 3/4\" BICAPA', 791, 'ELECTRIFICACION', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:48', '2020-10-19 11:10:29', 5, 5);
INSERT INTO `materiales` VALUES (11714, 1, 'H-081', 'POLIDUCTO RD9 1/2', 786, 'HIDRAULICA', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:48', '2020-10-19 11:10:29', 5, 5);
INSERT INTO `materiales` VALUES (9690, 1, 'POL-001', 'POLIETILENO NEGRO ROLLO DE 6X105 ML', 812, 'POLIESTIRENO', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:48', '2020-10-19 11:10:29', 5, 5);
INSERT INTO `materiales` VALUES (33693, 1, 'POL-416', 'POLIN 4X4X16', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:48', '2020-10-19 11:10:29', 5, 5);
INSERT INTO `materiales` VALUES (12377, 1, 'O-145', 'POLIN CAL 14 DE 4 X2  6 MTS ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:48', '2020-10-19 11:10:29', 5, 5);
INSERT INTO `materiales` VALUES (35007, 1, 'POL-303', 'POLIN DE 3X3 X8', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:48', '2020-10-19 11:10:29', 5, 5);
INSERT INTO `materiales` VALUES (10805, 1, 'E-045', 'POLIURETANO ESPREADO (ESPUMA EXPANCIVA 300 MIL)', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:48', '2020-10-19 11:10:29', 5, 5);
INSERT INTO `materiales` VALUES (26867, 1, 'POL-154', 'POLLOS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:49', '2020-10-19 11:10:30', 5, 5);
INSERT INTO `materiales` VALUES (10322, 1, 'V-001', 'POLVILLO', 817, 'VIAJES', 'ACTIVIDAD', 'ACTIVIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:49', '2020-10-19 11:10:30', 5, 5);
INSERT INTO `materiales` VALUES (10070, 1, 'C-009', 'POLVILLO APROX 30 A 33 TONELADAS ', 810, 'CONCRETOS', 'TONELADA', 'TONELADA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:49', '2020-10-19 11:10:30', 5, 5);
INSERT INTO `materiales` VALUES (31467, 1, 'PRP-200', 'PORTA PENDON CON LONA', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:49', '2020-10-19 11:10:30', 5, 5);
INSERT INTO `materiales` VALUES (33938, 1, 'PTP-185', 'PORTA PENDON EN X CON LONA IMPRESA ALTA DEFINICION EN MEDIDA DE 1.60X.60', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:49', '2020-10-19 11:10:30', 5, 5);
INSERT INTO `materiales` VALUES (11498, 1, 'E-067', 'PORTALAMPARA DE HULE INTERPERIE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:49', '2020-10-19 11:10:30', 5, 5);
INSERT INTO `materiales` VALUES (10170, 1, 'E-012', 'PORTALAMPARA SOQUET COMERCIAL 4\" IUSA', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:49', '2020-10-19 11:10:31', 5, 5);
INSERT INTO `materiales` VALUES (10868, 1, 'S-032', 'PORTAPAPEL VERTIKA CROMO 16104', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:50', '2020-10-19 11:10:31', 5, 5);
INSERT INTO `materiales` VALUES (28132, 1, 'PBC-100', 'PORTELA BLANCO 33X45 1.65 POR CAJA (AREA HUMEDA COCINA)', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:50', '2020-10-19 11:10:31', 5, 5);
INSERT INTO `materiales` VALUES (12894, 1, 'AV-006', 'PORTERIAS DE FUTBOLL', 821, 'AREA VERDE', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:50', '2020-10-19 11:10:31', 5, 5);
INSERT INTO `materiales` VALUES (13102, 1, '0-214', 'POST IT', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:50', '2020-10-19 11:10:32', 5, 5);
INSERT INTO `materiales` VALUES (13051, 1, 'O-90', 'POSTE DE  2 MTAS CAL 14', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:50', '2020-10-19 11:10:32', 5, 5);
INSERT INTO `materiales` VALUES (12819, 1, 'O-197', 'POSTE DE ACERO 2.50MTS', 795, 'PISOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:50', '2020-10-19 11:10:32', 5, 5);
INSERT INTO `materiales` VALUES (11373, 1, 'O-032', 'POSTE DE LINEA DE TUBO DE 2\"X 6.0 MTS. CAL.20', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:50', '2020-10-19 11:10:32', 5, 5);
INSERT INTO `materiales` VALUES (12257, 1, 'O-119', 'POSTE DE MADERA DE 3X3 DE 3 MTS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:50', '2020-10-19 11:10:32', 5, 5);
INSERT INTO `materiales` VALUES (11377, 1, 'O-033', 'POSTE ESQUINERO DE TUBO DE 2 1/2X2.75 MTS CAL.18', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:50', '2020-10-19 11:10:32', 5, 5);
INSERT INTO `materiales` VALUES (12897, 1, 'AV-007', 'POSTES CON ANCLAS Y GANCHOS PARA VOLLYBOLL', 821, 'AREA VERDE', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:32', 5, 5);
INSERT INTO `materiales` VALUES (25609, 1, 'U-020', 'POZO DE VISITA TIPO COMÚN, INCLUYE: PLANTILLA DE CONCRETO SIMPLE FC 100 KG/CM2, TABIQUE JUNTEADO Y APLANADO CON UNA MEZCLA MORTERO CEMENTO - ARENA EN UNA PROPORCION 1:5 ESCALON METALICO DE VARILLA LIS', 806, 'URBANIZACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:32', 5, 5);
INSERT INTO `materiales` VALUES (11632, 1, 'HE-006', 'PRE- FABRICACION DE PUENTE VEHICULAR Y PEATONAL', 792, 'HERRERIA', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:33', 5, 5);
INSERT INTO `materiales` VALUES (15005, 1, 'PRED-147', 'PREDIAL', 819, 'ESTIMACION', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:33', 5, 5);
INSERT INTO `materiales` VALUES (34464, 1, 'PRT-100', 'PREDIAL DE RESERVA TERRITORIAL', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:33', 5, 5);
INSERT INTO `materiales` VALUES (10960, 1, 'C-011', 'PREMEZCALDO F´C=250 KG/CM2', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:33', 5, 5);
INSERT INTO `materiales` VALUES (9630, 1, 'C-004', 'PREMEZCLADO F´C=100 KG/CM2', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:33', 5, 5);
INSERT INTO `materiales` VALUES (10054, 1, 'C-002', 'PREMEZCLADO F´C=150 KG/CM2', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:33', 5, 5);
INSERT INTO `materiales` VALUES (9626, 1, 'C-003', 'PREMEZCLADO F´C=200 KG/CM2', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:33', 5, 5);
INSERT INTO `materiales` VALUES (10062, 1, 'C-006', 'PREMEZCLADO F´C=200 KG/CM2 BOMBEABLE INC. ACELERANTE A 24 HRS.', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:33', 5, 5);
INSERT INTO `materiales` VALUES (26671, 1, 'C-019', 'PREMEZCLADO F´C=200 KG/CM2 VARIOS', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:51', '2020-10-19 11:10:34', 5, 5);
INSERT INTO `materiales` VALUES (11421, 1, 'C-014', 'PREMEZCLADO F´C=250 CON ACELERANTE', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:34', 5, 5);
INSERT INTO `materiales` VALUES (25796, 1, 'PRE-105', 'PREVENTIVOS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:34', 5, 5);
INSERT INTO `materiales` VALUES (13663, 1, 'P-056', 'PROBADOR DE VOLTAJE Y POLARIDAD cd PROVO-4 TRUPER', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:34', 5, 5);
INSERT INTO `materiales` VALUES (31613, 1, 'PRV-100', 'PRODUCCION DE VIDEO', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:34', 5, 5);
INSERT INTO `materiales` VALUES (12949, 1, 'O-221', 'PROMOSIONES ', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:34', 5, 5);
INSERT INTO `materiales` VALUES (12362, 1, 'O-141', 'PROPAGANDA Y PUBLICIDAD', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:34', 5, 5);
INSERT INTO `materiales` VALUES (35313, 1, '', 'PROPINAS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:34', 5, 5);
INSERT INTO `materiales` VALUES (12353, 1, 'O-138', 'PROTECTOR BRILLANTE OD 200P', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:35', 5, 5);
INSERT INTO `materiales` VALUES (13108, 1, '0-216', 'PROTECTOR DE HOJAS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:35', 5, 5);
INSERT INTO `materiales` VALUES (23446, 1, 'D-098', 'PROYECTO DE INTERIORISMO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:35', 5, 5);
INSERT INTO `materiales` VALUES (36490, 1, 'PRC-200', 'PROYECTO DE VIVIENDA CUADRUPLE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:35', 5, 5);
INSERT INTO `materiales` VALUES (27896, 1, 'PRO-100', 'PROYECTO EJECUTIVO QUINTA ARBOLEDA DE 800.00m2', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:52', '2020-10-19 11:10:35', 5, 5);
INSERT INTO `materiales` VALUES (34682, 1, '', 'PRUEBA', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:53', '2020-10-19 11:10:35', 5, 5);
INSERT INTO `materiales` VALUES (25343, 1, 'PRU-112', 'PRUEBA DE POZO', 794, 'ACABADOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:53', '2020-10-19 11:10:35', 5, 5);
INSERT INTO `materiales` VALUES (34356, 1, 'PRC-100', 'PRUEBA RAPIDA COVID-19', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:53', '2020-10-19 11:10:36', 5, 5);
INSERT INTO `materiales` VALUES (10948, 1, 'O-012', 'PRUEBAS DE LABORATORIO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:53', '2020-10-19 11:10:36', 5, 5);
INSERT INTO `materiales` VALUES (32809, 1, 'PRB-100', 'PRUEBAS DE PERMEABILIDAD DE LA CARPETA ASFALTICA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:53', '2020-10-19 11:10:36', 5, 5);
INSERT INTO `materiales` VALUES (13819, 1, 'PS-001', 'PS.INTM.LIGE.104.4045.1', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:53', '2020-10-19 11:10:36', 5, 5);
INSERT INTO `materiales` VALUES (12371, 1, 'O-143', 'PTR 1 1/2¨ X 1 1/2  CAL 14', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:53', '2020-10-19 11:10:36', 5, 5);
INSERT INTO `materiales` VALUES (27709, 1, 'PUB-001', 'PUBLICACIONES', 818, 'VENTAS', '1', '1', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:53', '2020-10-19 11:10:36', 5, 5);
INSERT INTO `materiales` VALUES (12030, 1, 'PUBLI-001', 'PUBLICIDAD', 804, 'PUBLICIDAD', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:53', '2020-10-19 11:10:37', 5, 5);
INSERT INTO `materiales` VALUES (36234, 1, 'PTB-206', 'PUERTA ACERO TRENTO MIXTA COLOR BLANCA C/2 LINEAS DE .90X2.06', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:53', '2020-10-19 11:10:37', 5, 5);
INSERT INTO `materiales` VALUES (36239, 1, 'PTC-285', 'PUERTA ACERO TRENTO MIXTA COLOR CHOCOLATE  C/2 LINEAS DE .85X2.06', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:37', 5, 5);
INSERT INTO `materiales` VALUES (36237, 1, 'PTC-290', 'PUERTA ACERO TRENTO MIXTA COLOR CHOCOLATE  C/2 LINEAS DE .90X2.06', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:37', 5, 5);
INSERT INTO `materiales` VALUES (11389, 1, 'CA-030', 'PUERTA CLASICA 15 LUCES 90CMX2.065 DE ALTO.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:37', 5, 5);
INSERT INTO `materiales` VALUES (27035, 1, 'PCM-184', 'PUERTA CORREDIZA DE MADERA', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:37', 5, 5);
INSERT INTO `materiales` VALUES (28879, 1, 'PTA-900', 'PUERTA DE ACERO LISA DE 9 LUCES .90X2.03', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:37', 5, 5);
INSERT INTO `materiales` VALUES (31902, 1, 'BON-12', 'PUERTA EUCAPLAC ARENA Med .80 x 2.06cms RECAMARA', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:38', 5, 5);
INSERT INTO `materiales` VALUES (31373, 1, 'CA-119', 'PUERTA EUCAPLAC ARENA Med .85 x 2.09cms', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:38', 5, 5);
INSERT INTO `materiales` VALUES (28545, 1, 'PTE-100', 'PUERTA EUCAPLAC COLOR ARENA .60X2.065', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:38', 5, 5);
INSERT INTO `materiales` VALUES (12213, 1, 'CA-033', 'PUERTA EUCAPLAC MED .70X2.13 CMS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:38', 5, 5);
INSERT INTO `materiales` VALUES (19338, 1, 'CA-47', 'PUERTA EUCOPACL .85 X 2.13', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:38', 5, 5);
INSERT INTO `materiales` VALUES (19194, 1, 'CA-49', 'PUERTA EUCOPLAC MED. .75 X 2.13 CMS', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:54', '2020-10-19 11:10:38', 5, 5);
INSERT INTO `materiales` VALUES (19191, 1, 'CA-48', 'PUERTA EUCOPLAC MED. .80 X 2.13 cms', 794, 'ACABADOS', 'pza', 'pza', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:38', 5, 5);
INSERT INTO `materiales` VALUES (31948, 1, 'VEN-12', 'PUERTA FERHER MOD CONTEMPORANEO DE 3 LINEAS VERT. COLOR BLANCA  .90X2.06', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:38', 5, 5);
INSERT INTO `materiales` VALUES (31896, 1, 'BON-10', 'PUERTA FERHER MOD CONTEMPORANEO DE 3 LINEAS VERT. COLOR BLANCA .90X2.06', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:39', 5, 5);
INSERT INTO `materiales` VALUES (31376, 1, 'CON-01', 'PUERTA FERHER MOD CONTEMPORANEO DE 3 LINEAS VERT. COLOR BLANCA .90X2.06 CONC', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:39', 5, 5);
INSERT INTO `materiales` VALUES (31370, 1, 'PFC-100', 'PUERTA FERHER MOD CONTEMPORANEO DE 3 LINEAS VERT. COLOR CHOCOLATE', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:39', 5, 5);
INSERT INTO `materiales` VALUES (32049, 1, 'MES-10', 'PUERTA FERHER MOD CONTEMPORANEO DE 3 LINEAS VERT. COLOR CHOCOLATE .90X2.06', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:39', 5, 5);
INSERT INTO `materiales` VALUES (32007, 1, 'TEM-10', 'PUERTA FERHER MOD CONTEMPORANEO DE 3 LINEAS VERT. COLOR CHOCOLATE DE .85X2.06 CM', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:39', 5, 5);
INSERT INTO `materiales` VALUES (26639, 1, 'CA-074', 'PUERTA MINIMALISTA CON 4 VAGUETAS HORIZONTALES A 1 CARA DE .90X2.09 COLOR GRIS', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:39', 5, 5);
INSERT INTO `materiales` VALUES (19205, 1, 'CA-053', 'PUERTA MULTIPANEL .90 x 2.13 LISA', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:39', 5, 5);
INSERT INTO `materiales` VALUES (19202, 1, 'CA-052', 'PUERTA MULTIPANEL MIXTA .90 x 2.13', 794, 'ACABADOS', 'pza', 'pza', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:40', 5, 5);
INSERT INTO `materiales` VALUES (12217, 1, 'CON-02', 'PUERTA MULTYPANEL LISA .90X2.06CMS CONC', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:40', 5, 5);
INSERT INTO `materiales` VALUES (31899, 1, 'BON-11', 'PUERTA MULTYPANEL LISA 0.90 x 2.06', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:55', '2020-10-19 11:10:40', 5, 5);
INSERT INTO `materiales` VALUES (31951, 1, 'VEN-13', 'PUERTA MULTYPANEL LISA 0.90 x 2.06  cms', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:40', 5, 5);
INSERT INTO `materiales` VALUES (12660, 1, 'CA-041', 'PUERTA MULTYPANEL LISA DE  .90 x 2.065 CMS COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:40', 5, 5);
INSERT INTO `materiales` VALUES (10038, 1, 'CA-020', 'PUERTA MULTYPANEL LISA DE .90X2.065 CMS COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:40', 5, 5);
INSERT INTO `materiales` VALUES (12221, 1, 'CA-035', 'PUERTA MULTYPANEL MIXTA .90X2.065 CMS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:41', 5, 5);
INSERT INTO `materiales` VALUES (10042, 1, 'CA-021', 'PUERTA MULTYPANELMIXTA DE .90X2.065 CMS. PRINCIPAL', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:41', 5, 5);
INSERT INTO `materiales` VALUES (9974, 1, 'CA-004', 'PUERTA MUTYPANEL LISA DE .75X2.13', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:41', 5, 5);
INSERT INTO `materiales` VALUES (9970, 1, 'CA-003', 'PUERTA MUTYPANEL LISA DE .80X2.13', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:41', 5, 5);
INSERT INTO `materiales` VALUES (9978, 1, 'CA-005', 'PUERTA MUTYPANEL MIXTA DE .90X2.065', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:41', 5, 5);
INSERT INTO `materiales` VALUES (27038, 1, 'PPM-174', 'PUERTA PRINCIPAL DE MADERA', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:41', 5, 5);
INSERT INTO `materiales` VALUES (21130, 1, 'PHC-02', 'PUERTA SOHO MAD CEDRILLO 75 X 213', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:42', 5, 5);
INSERT INTO `materiales` VALUES (21127, 1, 'PHM-01', 'PUERTA SOHO MAD. CEDRILLO 85 X 213', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:56', '2020-10-19 11:10:42', 5, 5);
INSERT INTO `materiales` VALUES (13459, 1, 'CA-044', 'PUERTA TIPO EUCAPLAC .85X2.065', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:57', '2020-10-19 11:10:42', 5, 5);
INSERT INTO `materiales` VALUES (32046, 1, 'MES-12', 'PUERTA TIPO EUCAPLAC ARENA  0.60X2.06', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:57', '2020-10-19 11:10:42', 5, 5);
INSERT INTO `materiales` VALUES (31957, 1, 'VEN-15', 'PUERTA TIPO EUCAPLAC ARENA  0.70X2.06', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:57', '2020-10-19 11:10:42', 5, 5);
INSERT INTO `materiales` VALUES (32013, 1, 'TEM-12', 'PUERTA TIPO EUCAPLAC ARENA  0.80X2.06', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:57', '2020-10-19 11:10:43', 5, 5);
INSERT INTO `materiales` VALUES (31954, 1, 'VEN-14', 'PUERTA TIPO EUCAPLAC ARENA 0.80 x 2.06  cms', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:57', '2020-10-19 11:10:43', 5, 5);
INSERT INTO `materiales` VALUES (32058, 1, 'MES-11', 'PUERTA TIPO EUCAPLAC ARENA 0.80 x 2.06 MES', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:57', '2020-10-19 11:10:43', 5, 5);
INSERT INTO `materiales` VALUES (32010, 1, 'TEM-11', 'PUERTA TIPO EUCAPLAC ARENA 0.85 x 2.06', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:57', '2020-10-19 11:10:43', 5, 5);
INSERT INTO `materiales` VALUES (31905, 1, 'BON-13', 'PUERTA TIPO EUCAPLAC ARENA Med .70 x 2.06 CMS BAÑO', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:57', '2020-10-19 11:10:43', 5, 5);
INSERT INTO `materiales` VALUES (28946, 1, 'CA-111', 'PUERTA TIPO EUCAPLAC DE .60X2.065', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:58', '2020-10-19 11:10:43', 5, 5);
INSERT INTO `materiales` VALUES (9962, 1, 'CON-04', 'PUERTA TIPO EUCAPLAC DE .70X2.06', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:58', '2020-10-19 11:10:43', 5, 5);
INSERT INTO `materiales` VALUES (10030, 1, 'CA-018', 'PUERTA TIPO EUCAPLAC DE .75X2.065 CMS BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:58', '2020-10-19 11:10:44', 5, 5);
INSERT INTO `materiales` VALUES (10034, 1, 'CON-03', 'PUERTA TIPO EUCAPLAC DE .80X2.06 CMS. RECAMARAS CONC', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:58', '2020-10-19 11:10:44', 5, 5);
INSERT INTO `materiales` VALUES (9966, 1, 'CA-002', 'PUERTA TIPO EUCAPLAC DE .80X2.13', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:58', '2020-10-19 11:10:44', 5, 5);
INSERT INTO `materiales` VALUES (12657, 1, 'CA-040', 'PUERTA TIPO EUCAPLAC DE .85 x 2.065 CMS RECAMARAS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:58', '2020-10-19 11:10:44', 5, 5);
INSERT INTO `materiales` VALUES (10852, 1, 'CA-023', 'PUERTA TIPO EUCAPLAC DE .90X2.13', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:44', 5, 5);
INSERT INTO `materiales` VALUES (11393, 1, 'CA-031', 'PUERTAS CLASICA 4 LUCES 90CM X 2.065 MTS DE ALTO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:44', 5, 5);
INSERT INTO `materiales` VALUES (30574, 1, 'P9L-100', 'PUERTAS CLASICA 9 LUCES 80CM X 2.13 MTS DE ALTO', 798, 'CARPINTERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:44', 5, 5);
INSERT INTO `materiales` VALUES (34798, 1, 'PUL-100', 'PULIDOR 7 PULG 1200 WATTS TRUPER', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:45', 5, 5);
INSERT INTO `materiales` VALUES (33625, 1, 'PUN-100', 'PUNTILAS', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:45', 5, 5);
INSERT INTO `materiales` VALUES (35383, 1, 'PUN-150', 'PUNTILLAS BEROL 0.5 mm C/12', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:45', 5, 5);
INSERT INTO `materiales` VALUES (33861, 1, 'p-102', 'Prueba Clara', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:45', 5, 5);
INSERT INTO `materiales` VALUES (25028, 1, 'PZA-145', 'Puff Atoyac 150 cm - Gris', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:45', 5, 5);
INSERT INTO `materiales` VALUES (27107, 1, 'QUE-100', 'QUESNO CHICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:45', 5, 5);
INSERT INTO `materiales` VALUES (27110, 1, 'QUE-101', 'QUESNO GRANDE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:45', 5, 5);
INSERT INTO `materiales` VALUES (12928, 1, 'T-022', 'RACOR 5 VIAS LARGO', 801, 'ECOTECNOLOGIAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:03:59', '2020-10-19 11:10:45', 5, 5);
INSERT INTO `materiales` VALUES (19647, 1, '', 'RASTRILLO', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:00', '2020-10-19 11:10:46', 5, 5);
INSERT INTO `materiales` VALUES (12759, 1, 'CS-015', 'RECAMARA VIENA', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:00', '2020-10-19 11:10:46', 5, 5);
INSERT INTO `materiales` VALUES (13003, 1, 'O-258', 'RECARGA DE GAS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:00', '2020-10-19 11:10:46', 5, 5);
INSERT INTO `materiales` VALUES (34703, 1, '', 'RECARGOS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:00', '2020-10-19 11:10:46', 5, 5);
INSERT INTO `materiales` VALUES (31570, 1, 'REC-1000', 'RECARGOS MORATORIOS', 794, 'ACABADOS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:00', '2020-10-19 11:10:46', 5, 5);
INSERT INTO `materiales` VALUES (13204, 1, '0-284', 'RECIBO DE AGUA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:00', '2020-10-19 11:10:46', 5, 5);
INSERT INTO `materiales` VALUES (24455, 1, 'RG-290', 'RECIBO DE GAS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:00', '2020-10-19 11:10:46', 5, 5);
INSERT INTO `materiales` VALUES (13225, 1, '0-290', 'RECIBO DE LUZ', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:00', '2020-10-19 11:10:47', 5, 5);
INSERT INTO `materiales` VALUES (12296, 1, 'O-132', 'RECIBOS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:00', '2020-10-19 11:10:47', 5, 5);
INSERT INTO `materiales` VALUES (31270, 1, 'REC-100', 'RECOGEDOR DE PLASTICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:00', '2020-10-19 11:10:47', 5, 5);
INSERT INTO `materiales` VALUES (27662, 1, 'ELT-06', 'RECOLECCION LINEA AREA MEDIA TENSION', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:47', 5, 5);
INSERT INTO `materiales` VALUES (30800, 1, 'REC-185', 'RECTIFICACION DE DISCOS DELANTEROS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:47', 5, 5);
INSERT INTO `materiales` VALUES (29137, 1, 'RDE-100', 'RED DE DISTRIBUCION ELECTRICA SUBTERRANEA', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:47', 5, 5);
INSERT INTO `materiales` VALUES (12958, 1, 'AV-008', 'RED PARA PORTERIA 2.80X4 MTS', 821, 'AREA VERDE', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:47', 5, 5);
INSERT INTO `materiales` VALUES (11501, 1, 'O-044', 'REDISEÑO DE PUENTE VEHICULAR EN ESTRUCTURA METALICA', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:47', 5, 5);
INSERT INTO `materiales` VALUES (30277, 1, 'RED', 'REDONDEO', 803, 'EXTRAS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:48', 5, 5);
INSERT INTO `materiales` VALUES (11405, 1, 'S-040', 'REDUCCION 4\" A 2\"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:48', 5, 5);
INSERT INTO `materiales` VALUES (35541, 1, 'RED-202', 'REDUCCION BUSCHING PVC CEM 1 1/2 X 1 1/4\"', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:48', 5, 5);
INSERT INTO `materiales` VALUES (34940, 1, 'RED-201', 'REDUCCION BUSCHING PVC CEM 2\" X 1\"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:48', 5, 5);
INSERT INTO `materiales` VALUES (35556, 1, 'REB-114', 'REDUCCION BUSHING PVC CEM 1 1/4 X 1', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:48', 5, 5);
INSERT INTO `materiales` VALUES (9858, 1, 'AC-003', 'REDUCCION CAMPANA GALVANIZADA DE 3/4\" A 1/2\"', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:01', '2020-10-19 11:10:48', 5, 5);
INSERT INTO `materiales` VALUES (11084, 1, 'G-025', 'REDUCCION COBRE DE 1 A 1/2\"', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:02', '2020-10-19 11:10:48', 5, 5);
INSERT INTO `materiales` VALUES (13354, 1, 'H-125', 'REDUCCION CPVC 1 A1/2', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:02', '2020-10-19 11:10:49', 5, 5);
INSERT INTO `materiales` VALUES (13681, 1, 'H-126', 'REDUCCION CPVC DE 3/4 A1/2', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:02', '2020-10-19 11:10:49', 5, 5);
INSERT INTO `materiales` VALUES (31143, 1, 'RED-32', 'REDUCCION DE 3 A 2 PVC DESAGUE', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:02', '2020-10-19 11:10:49', 5, 5);
INSERT INTO `materiales` VALUES (10661, 1, 'G-012', 'REDUCCION DE COBRE DE 1 1/2 A 3/4', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:02', '2020-10-19 11:10:49', 5, 5);
INSERT INTO `materiales` VALUES (20387, 1, 'H-130', 'REDUCCIONES BUSHING DE 1\" A 1/2\" GALVANIZADA', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:02', '2020-10-19 11:10:49', 5, 5);
INSERT INTO `materiales` VALUES (34403, 1, 'RED-314', 'REDUCCIONES BUSHING DE 1/2\" A 3/4\" GALVANIZADA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:02', '2020-10-19 11:10:49', 5, 5);
INSERT INTO `materiales` VALUES (31507, 1, 'H-230', 'REDUCCIONES BUSHING DE 1/2\" A 3/8\" GALVANIZADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:02', '2020-10-19 11:10:49', 5, 5);
INSERT INTO `materiales` VALUES (34412, 1, 'RED-100', 'REDUCCIONES BUSHING DE CPVC DE 3/4 A 1/2', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:02', '2020-10-19 11:10:49', 5, 5);
INSERT INTO `materiales` VALUES (35616, 1, 'RED-121', 'REDUCCIONES BUSHING PVC CEM 2\" X 1 1/2', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:50', 5, 5);
INSERT INTO `materiales` VALUES (35619, 1, 'RED-114', 'REDUCCIONES BUSHING PVC CEM 2\" X 1 1/4', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:50', 5, 5);
INSERT INTO `materiales` VALUES (12495, 1, 'H-098', 'REDUCCIÓN 1 A 1/2\" IUSA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:50', 5, 5);
INSERT INTO `materiales` VALUES (12579, 1, 'H-100', 'REDUCCIÓN BUCHING 1\" A 1/2\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:50', 5, 5);
INSERT INTO `materiales` VALUES (12588, 1, 'H-103', 'REDUCCIÓN BUCHING 1\" A 3/4\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:50', 5, 5);
INSERT INTO `materiales` VALUES (11605, 1, 'H-074', 'REDUCCIÓN DE CPVC  DE 1 PULGADA A 1/2', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:50', 5, 5);
INSERT INTO `materiales` VALUES (10697, 1, 'H-045', 'REDUCTOR DE 1 A 3/4\" CON ROSCA INTERIOR DE COBRE', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:50', 5, 5);
INSERT INTO `materiales` VALUES (30614, 1, 'RPB-100', 'REEMPLAZAR BATERIA PARA AVEO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:50', 5, 5);
INSERT INTO `materiales` VALUES (36009, 1, 'REM-100', 'REEMPLAZO DE BOMBA DE GASOLINA  Y CHECAR SISTEMA ELECTRICO', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:51', 5, 5);
INSERT INTO `materiales` VALUES (30919, 1, 'REF-235M', 'REFRESCOS 235 ML', 803, 'EXTRAS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:51', 5, 5);
INSERT INTO `materiales` VALUES (27751, 1, 'REG-174', 'REG. PUBL. PROP FOMENTO EDUCATIVO', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:03', '2020-10-19 11:10:51', 5, 5);
INSERT INTO `materiales` VALUES (19272, 1, 'T-010', 'REGADERA CERTIFICDO DICA 300BL ITALIA', 796, 'CANCELERIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:04', '2020-10-19 11:10:51', 5, 5);
INSERT INTO `materiales` VALUES (10892, 1, 'T-013', 'REGADERA ITALIA 44-IB MARCA RUGO', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:04', '2020-10-19 11:16:33', 5, 5);
INSERT INTO `materiales` VALUES (10114, 1, 'T-0100', 'REGADERA MODELO 3003BL ITALIA MARCA DICA', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'SUSPENSION DE COMPRAS       ', '2020-10-19 11:04:04', '2020-10-19 13:25:35', 5, 5);
INSERT INTO `materiales` VALUES (12347, 1, 'O-136', 'REGISTRADOR ELFEN CARTA ROJ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:04', '2020-10-19 11:16:33', 5, 5);
INSERT INTO `materiales` VALUES (13426, 1, '0-332', 'REGISTRADOR ELFEN CTA AMARILLO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:04', '2020-10-19 11:16:33', 5, 5);
INSERT INTO `materiales` VALUES (10406, 1, 'EU-021', 'REGISTRO  RBTB-2', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:04', '2020-10-19 11:16:33', 5, 5);
INSERT INTO `materiales` VALUES (29728, 1, 'RAC-100', 'REGISTRO DE AVALUOS CATASTRALES', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:04', '2020-10-19 11:16:34', 5, 5);
INSERT INTO `materiales` VALUES (24159, 1, 'RM-001', 'REGISTRO DE MARCA', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:04', '2020-10-19 11:16:34', 5, 5);
INSERT INTO `materiales` VALUES (13495, 1, 'RE-01', 'REGISTRO DE OFERTA  DE VIV.', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:04', '2020-10-19 11:16:34', 5, 5);
INSERT INTO `materiales` VALUES (10414, 1, 'EU-023', 'REGISTRO PARA ALUMBRADO DE 40X40X40 CON ANGULO DE 1/8', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:04', '2020-10-19 11:16:34', 5, 5);
INSERT INTO `materiales` VALUES (35380, 1, 'REG-100', 'REGLA METALICA ALUMINIO 30cms.', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:04', '2020-10-19 11:16:34', 5, 5);
INSERT INTO `materiales` VALUES (12570, 1, 'HE-018', 'REJAS PARA BALCONES ', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:05', '2020-10-19 11:16:34', 5, 5);
INSERT INTO `materiales` VALUES (10972, 1, 'HE-004', 'REJAS PARA TRAILA', 792, 'HERRERIA', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:05', '2020-10-19 11:16:35', 5, 5);
INSERT INTO `materiales` VALUES (13450, 1, 'URB-008', 'REJILLA PARA BOCA DE TORMENTA DE 50X50', 806, 'URBANIZACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:05', '2020-10-19 11:16:35', 5, 5);
INSERT INTO `materiales` VALUES (12925, 1, 'HE-019', 'REJILLA PARA DESARENADOR, INCLUYE FONDO EPOXICO', 792, 'HERRERIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:05', '2020-10-19 11:16:35', 5, 5);
INSERT INTO `materiales` VALUES (12034, 1, 'HE-008', 'REJILLAS PARA MEDIDOR', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:05', '2020-10-19 11:16:35', 5, 5);
INSERT INTO `materiales` VALUES (35613, 1, 'REL-110', 'RELEVADOR RAINBIRD 110V Y 220V PSR', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:05', '2020-10-19 11:16:35', 5, 5);
INSERT INTO `materiales` VALUES (25606, 1, 'U-018', 'RELLENO COMPACTO CON MATERIAL PRODUCTO DE EXCAVACION. INCLUYE: HUMECTACION, MEZCLADO Y COMPACTACION DE MATERIAL AL 85% PROCTOR', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:05', '2020-10-19 11:16:35', 5, 5);
INSERT INTO `materiales` VALUES (24512, 1, 'U-005', 'RELLENO CON MATERIAL DE BANCO, CALICHE CRIBADO DE 3 1/2\" A FINOS PARA RECIBIR CAPA DE SUBBASE. INCLUYE: HUMECTACION, MEZCLADO, TENDIDO Y COMPACTADO AL 90% DE SU PVSM. M3 COMPACTADOS', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:05', '2020-10-19 11:16:36', 5, 5);
INSERT INTO `materiales` VALUES (26975, 1, 'REL-142', 'RELLENO CON MATERIAL DE BANCO, GRAVA-ARENA DE 3 1/2\" A FINOS PARA RECIBIR CAPA DE SUBASE, INCLUYE; HUMECTACION, MEZCLADO, TENDIDO Y COMPACTADO AL 90% DE SU PUSM M3 COPACTADOS', 808, 'OTROS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:06', '2020-10-19 11:16:36', 5, 5);
INSERT INTO `materiales` VALUES (29857, 1, 'REL-100', 'RELLENO DE FRENTES Y PATIOS CON MATERIAL PRODUCTO DE CORTES Y/O DESPALMES INCLUYE CORTE, CARGA, ACARREO INTERNO Y ACOMODO DEL MATERIAL', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:06', '2020-10-19 11:16:36', 5, 5);
INSERT INTO `materiales` VALUES (25527, 1, 'U-010', 'RELLENO EN VIALIDAD PARA LLEGAR A NIVEL PARA BASE  INCLUYE: CARGA Y ACARREO CON MATERIAL PRODUCTO DE BANCO HUMEC, TEND Y COMPACT AL 90%', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:06', '2020-10-19 11:16:36', 5, 5);
INSERT INTO `materiales` VALUES (28528, 1, 'RLL-102', 'RELLENO EN VIALIDAD PARA LLEGAR A NIVEL PARA BASE INCLUYE: CARGA Y ACARREO CON MATERIAL PRODUCTO DE BANCO HUMECTEDN Y COMPAC AL 90%', 806, 'URBANIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:06', '2020-10-19 11:16:36', 5, 5);
INSERT INTO `materiales` VALUES (32477, 1, 'RLF-50', 'RELLENO FLUIDO  F´C=50 TIRO DIRECTO', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:06', '2020-10-19 11:16:36', 5, 5);
INSERT INTO `materiales` VALUES (25512, 1, 'ELT-105', 'RELOCALIZACION LINEA BLVD. MISIONES', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:06', '2020-10-19 11:16:36', 5, 5);
INSERT INTO `materiales` VALUES (25509, 1, 'ELT-104', 'RELOCALIZACION LINEA SERVICIO EXISTENTE', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:06', '2020-10-19 11:16:37', 5, 5);
INSERT INTO `materiales` VALUES (13564, 1, 'O-308', 'RELOJ CHECADOR', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:06', '2020-10-19 11:16:37', 5, 5);
INSERT INTO `materiales` VALUES (34946, 1, 'REL-200', 'RELOJ ESP-TM2 12 ESTACIONES 3 PRG 120V. RAINBIRD', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:06', '2020-10-19 11:16:37', 5, 5);
INSERT INTO `materiales` VALUES (24717, 1, 'RLT-101', 'RELOTIFICACION', 794, 'ACABADOS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:06', '2020-10-19 11:16:37', 5, 5);
INSERT INTO `materiales` VALUES (12792, 1, 'O-192', 'REMOLQUE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:37', 5, 5);
INSERT INTO `materiales` VALUES (25612, 1, 'U-021', 'RENIVELACION DE POZO DE VISITA PARA DEJAR A NIVEL DE RASANTE. ALTURA PROMEDIO DE 50 CM INCLUYE: EXCAVACION, MATERIAL, Y MANO DE OBRA (INCLUYE BROCAL DE PAD', 806, 'URBANIZACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:38', 5, 5);
INSERT INTO `materiales` VALUES (12014, 1, 'O-098', 'RENOVACION  DE DIMINIO', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:38', 5, 5);
INSERT INTO `materiales` VALUES (13444, 1, '0-338', 'RENOVACION DICTAMEN USO DE SUELO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:38', 5, 5);
INSERT INTO `materiales` VALUES (13441, 1, '0-337', 'RENOVACION LICENCIA DE FRACCIONAMIENTO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:38', 5, 5);
INSERT INTO `materiales` VALUES (12315, 1, 'URB-003', 'RENTA DE CAMION', 806, 'URBANIZACION', 'HORA', 'HORA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:38', 5, 5);
INSERT INTO `materiales` VALUES (13570, 1, 'E-087', 'RENTA DE CORTADORA DE PISO', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:38', 5, 5);
INSERT INTO `materiales` VALUES (25223, 1, 'RDH-108', 'RENTA DE HABITACION', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:38', 5, 5);
INSERT INTO `materiales` VALUES (11999, 1, 'O-095', 'RENTA DE MAQUINARIA', 808, 'OTROS', 'HORAS', 'HORAS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:39', 5, 5);
INSERT INTO `materiales` VALUES (23579, 1, 'RM-01', 'RENTA DE MOBILIARIO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:39', 5, 5);
INSERT INTO `materiales` VALUES (26323, 1, 'REN-100', 'RENTA DE MULTIFUNCIONAL', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:07', '2020-10-19 11:16:39', 5, 5);
INSERT INTO `materiales` VALUES (13789, 1, 'RE-002', 'RENTA DE OFICINA', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:08', '2020-10-19 11:16:39', 5, 5);
INSERT INTO `materiales` VALUES (26576, 1, 'REN-152', 'RENTA DE RESTAURANT', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:08', '2020-10-19 11:16:39', 5, 5);
INSERT INTO `materiales` VALUES (30140, 1, 'SIM-100', 'RENTA DE SIM DE DATOS PARA MONITOREAR DE ALARMA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:08', '2020-10-19 11:16:39', 5, 5);
INSERT INTO `materiales` VALUES (12311, 1, 'URB-002', 'RENTA DE TRAXCAVO', 806, 'URBANIZACION', 'HORA', 'HORA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:08', '2020-10-19 11:16:40', 5, 5);
INSERT INTO `materiales` VALUES (11706, 1, 'O-062', 'RENTA OFICINA  MOVIL', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:08', '2020-10-19 11:16:40', 5, 5);
INSERT INTO `materiales` VALUES (12991, 1, 'O-254', 'REPARACION AUTOS', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:08', '2020-10-19 11:16:41', 5, 5);
INSERT INTO `materiales` VALUES (33762, 1, 'RPM-100', 'REPARACION DE MINISPLIT DE COMPRESOR INC. CARGA DE GAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:08', '2020-10-19 11:16:41', 5, 5);
INSERT INTO `materiales` VALUES (13582, 1, '0-356', 'REPARACION DE MOLDES PARA MURETES', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:08', '2020-10-19 11:16:41', 5, 5);
INSERT INTO `materiales` VALUES (30179, 1, 'RER-105', 'REPARACION DE REFRIGERADORES', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:09', '2020-10-19 11:16:41', 5, 5);
INSERT INTO `materiales` VALUES (26352, 1, '0030', 'REPARACION LOCAL', 818, 'VENTAS', '1', '1', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:09', '2020-10-19 11:16:41', 5, 5);
INSERT INTO `materiales` VALUES (31969, 1, 'RPC-100', 'REPARACION Y CAMBIO DE CHUMACERAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:09', '2020-10-19 11:16:41', 5, 5);
INSERT INTO `materiales` VALUES (11329, 1, 'O-030', 'REPARACIONES DE VIVIENDAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:09', '2020-10-19 11:16:42', 5, 5);
INSERT INTO `materiales` VALUES (27055, 1, 'U-052', 'REPOSICION DE PAVIMENTO ASFALTICO CON CARPETA DE 7 CM. DE ESPESOR INCLUYE BASE DE CALICHE DE 20 CM. DE ESPESOR, COMPACTADA AL 90% PROCTOR', 806, 'URBANIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:09', '2020-10-19 11:16:42', 5, 5);
INSERT INTO `materiales` VALUES (11890, 1, 'O-077', 'RESANALAK CAOBA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:09', '2020-10-19 11:16:42', 5, 5);
INSERT INTO `materiales` VALUES (29221, 1, 'RES-100', 'RESBALADERO', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:09', '2020-10-19 11:16:43', 5, 5);
INSERT INTO `materiales` VALUES (12690, 1, 'O-176', 'RESERVA DE DOMINIO', 808, 'OTROS', 'VIVIENDA', 'VIVIENDA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:43', 5, 5);
INSERT INTO `materiales` VALUES (9818, 1, 'A-010', 'RESINA GRUESA TANQUE DE 200 LTS.', 794, 'ACABADOS', 'TANQUE', 'TANQUE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:43', 5, 5);
INSERT INTO `materiales` VALUES (13711, 1, 'RG-001', 'RETAZO GRANITO  CASA BLANCA BRILLADA', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:43', 5, 5);
INSERT INTO `materiales` VALUES (35136, 1, '', 'RETENCION ISR 10%', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO                      ', '2020-10-19 11:04:10', '2021-02-23 15:54:52', 5, 0);
INSERT INTO `materiales` VALUES (20180, 1, 'RCV', 'RETIRO CESANTIA EN EDAD AVANZADA Y VEJEZ', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:43', 5, 5);
INSERT INTO `materiales` VALUES (10988, 1, 'O-085', 'RETIRO DE ESCOMBRO', 808, 'OTROS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:43', 5, 5);
INSERT INTO `materiales` VALUES (12328, 1, 'EU-034', 'REUBICACION DE BASES PARA ARBOTANTE', 785, 'ELECTRIFICACION URB', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:44', 5, 5);
INSERT INTO `materiales` VALUES (33258, 1, 'RBC-100', 'REUBICACION DE CAMARA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:44', 5, 5);
INSERT INTO `materiales` VALUES (12639, 1, 'URB-007', 'REUBICACION DE LINEA DE AGUA POTABLE 8\"', 806, 'URBANIZACION', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:44', 5, 5);
INSERT INTO `materiales` VALUES (27559, 1, 'REM-174', 'REUBICACION DE MINISPLIT', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:44', 5, 5);
INSERT INTO `materiales` VALUES (25246, 1, 'RIM-122', 'RIEGO DE IMPREGNACION A RAZON DE 1.2 LTS M2', 806, 'URBANIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:44', 5, 5);
INSERT INTO `materiales` VALUES (25532, 1, 'U-012', 'RIEGO DE IMPREGNACION CON ASFALTO FM 1-0 SIMILAR A RAZON DE 1.2 LTM2', 806, 'URBANIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:10', '2020-10-19 11:16:45', 5, 5);
INSERT INTO `materiales` VALUES (25535, 1, 'U-013', 'RIEGO DE LIGA CON EMULSION ASFALTICA O SIMILAR A RAZON DE 0.5 A 0.6 LT / M2.', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:45', 5, 5);
INSERT INTO `materiales` VALUES (20148, 1, 'RJAE', 'ROCIO JUDITH ALVARADO ESPINOZA', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:45', 5, 5);
INSERT INTO `materiales` VALUES (12732, 1, 'CS-006', 'RODABASE', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:45', 5, 5);
INSERT INTO `materiales` VALUES (31330, 1, 'RON-100', 'RODILLERAS LIGERAS NEOPRENO  ( COD 12951 )', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:45', 5, 5);
INSERT INTO `materiales` VALUES (12441, 1, 'A-76', 'RODILLO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:45', 5, 5);
INSERT INTO `materiales` VALUES (30822, 1, 'ROD-100', 'RODILLO P/PINTAR LISO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:45', 5, 5);
INSERT INTO `materiales` VALUES (12943, 1, 'A-051', 'RODILLO PARA PINTAR', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:46', 5, 5);
INSERT INTO `materiales` VALUES (9838, 1, 'A-015', 'RODILLO PARA PINTAR SUP/ FINA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:46', 5, 5);
INSERT INTO `materiales` VALUES (11686, 1, 'O-061', 'ROLLO DE HULE NEGRO', 808, 'OTROS', 'KG', 'KG', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:46', 5, 5);
INSERT INTO `materiales` VALUES (10294, 1, 'R-001', 'ROLLO DE RAFIA DE 100 MTS.', 815, 'RAFIA', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:46', 5, 5);
INSERT INTO `materiales` VALUES (11835, 1, 'O-067', 'ROLLO PARA PLOTER 61 X 50 CM', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:11', '2020-10-19 11:16:46', 5, 5);
INSERT INTO `materiales` VALUES (29991, 1, 'ROM-100', 'ROMEROS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:12', '2020-10-19 11:16:46', 5, 5);
INSERT INTO `materiales` VALUES (11052, 1, 'G-017', 'RONDANA DE PRESION 1/4\" ', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:12', '2020-10-19 11:16:47', 5, 5);
INSERT INTO `materiales` VALUES (11048, 1, 'G-016', 'RONDANA PLANA 1/4\" ', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:12', '2020-10-19 11:16:47', 5, 5);
INSERT INTO `materiales` VALUES (11168, 1, 'O-029', 'ROSA LAUREL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:12', '2020-10-19 11:16:47', 5, 5);
INSERT INTO `materiales` VALUES (12555, 1, 'O-166', 'ROSALAUREL ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:12', '2020-10-19 11:16:47', 5, 5);
INSERT INTO `materiales` VALUES (35774, 1, 'ROT-200', 'ROTOMARTILLO INALAMBRICO INC. BATERIA 18V 1/2', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:12', '2020-10-19 11:16:47', 5, 5);
INSERT INTO `materiales` VALUES (34909, 1, 'ROT-400', 'ROTOR 3504 4\" CIRC. PARCIAL RAINBIRD', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:12', '2020-10-19 11:16:47', 5, 5);
INSERT INTO `materiales` VALUES (32866, 1, 'RTC-100', 'ROTULACION DE CARRO', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:12', '2020-10-19 11:16:47', 5, 5);
INSERT INTO `materiales` VALUES (31458, 1, 'ROT-100', 'ROTULACION EN CAMMION', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:12', '2020-10-19 11:16:48', 5, 5);
INSERT INTO `materiales` VALUES (34746, 1, 'RTP-100', 'ROTULACION EN PINTURA DE BARDA 150X3.30 mts', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:12', '2020-10-19 11:16:48', 5, 5);
INSERT INTO `materiales` VALUES (25822, 1, 'U-049', 'RUPTURA Y DEMOLICION DE PAVIMENTO ASFALTICO INCLUYE CARGA DE MATERIAL ACARREO', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:48', 5, 5);
INSERT INTO `materiales` VALUES (27051, 1, 'U-051', 'RUPTURA Y DEMOLICION DE PAVIMENTO ASFALTICO INCLUYE CARGA DE MATERIAL Y ACARREO', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:48', 5, 5);
INSERT INTO `materiales` VALUES (25007, 1, 'REN-137', 'Repisa Evo 30cm - Nogal', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:48', 5, 5);
INSERT INTO `materiales` VALUES (25010, 1, 'REN-138', 'Repisa Evo 90cm - nogal', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:49', 5, 5);
INSERT INTO `materiales` VALUES (24947, 1, 'RPB-119', 'Repisa Panal - Blanco', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:49', 5, 5);
INSERT INTO `materiales` VALUES (24944, 1, 'RP-118', 'Repisa Panal - Natural', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:49', 5, 5);
INSERT INTO `materiales` VALUES (25043, 1, 'PZA', 'Revistero Cocula - Encino', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:49', 5, 5);
INSERT INTO `materiales` VALUES (33458, 1, 'RIB-1611', 'Ribbon, Color-YMCKO, 200 ( CARTUCHOS )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:49', 5, 5);
INSERT INTO `materiales` VALUES (36737, 1, 'SAC-100', 'SACAPUNTAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:49', 5, 5);
INSERT INTO `materiales` VALUES (10122, 1, 'T-012', 'SACO MULTIPERL TIPO F', 801, 'ECOTECNOLOGIAS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:50', 5, 5);
INSERT INTO `materiales` VALUES (24469, 1, 'MP-103', 'SAL', 808, 'OTROS', 'KG', 'KG', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:13', '2020-10-19 11:16:50', 5, 5);
INSERT INTO `materiales` VALUES (27976, 1, 'SAL-112', 'SALA ESQUINERA DERECHA ATZIMBA - BEIGE', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:50', 5, 5);
INSERT INTO `materiales` VALUES (27263, 1, 'SAL-130', 'SALSERO ESPECIAL 9 DIAM S 4.5 CMS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:50', 5, 5);
INSERT INTO `materiales` VALUES (13387, 1, '0-323', 'SALVIA GREY', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:50', 5, 5);
INSERT INTO `materiales` VALUES (26508, 1, 'SLR-103', 'SALVIA ROJA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:50', 5, 5);
INSERT INTO `materiales` VALUES (11144, 1, 'O-023', 'SALVIA ROSA PLANTA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:51', 5, 5);
INSERT INTO `materiales` VALUES (13492, 1, 'SAN-01', 'SANITARIO  MONACO UNA OIEZA ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:52', 5, 5);
INSERT INTO `materiales` VALUES (18950, 1, 'SANI-02', 'SANITARIO ECOLOGICO DOBLE DESCARGA', 783, 'SANITARIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:52', 5, 5);
INSERT INTO `materiales` VALUES (35036, 1, 'SAN-200', 'SANITARIO PORTATIL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:52', 5, 5);
INSERT INTO `materiales` VALUES (34027, 1, 'SAN-147', 'SANITIZACION', 794, 'ACABADOS', '1', '1', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:53', 5, 5);
INSERT INTO `materiales` VALUES (12549, 1, 'O-164', 'SAUCE LLORON ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:53', 5, 5);
INSERT INTO `materiales` VALUES (12985, 1, 'O-252', 'SCANEO', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:53', 5, 5);
INSERT INTO `materiales` VALUES (12109, 1, 'O-111', 'SEGURO', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:14', '2020-10-19 11:16:53', 5, 5);
INSERT INTO `materiales` VALUES (24581, 1, 'SE-101', 'SEGUROS DE EDIFICIOS O CONTENIDO', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:53', 5, 5);
INSERT INTO `materiales` VALUES (9646, 1, 'G-003', 'SELLAC CABEZA DE INDIO 55 GR', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:53', 5, 5);
INSERT INTO `materiales` VALUES (9810, 1, 'A-008', 'SELLADOR ADI REAL', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:53', 5, 5);
INSERT INTO `materiales` VALUES (11899, 1, 'O-080', 'SELLADOR DE PINTURA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:54', 5, 5);
INSERT INTO `materiales` VALUES (12774, 1, 'V-002', 'SELLO', 817, 'VIAJES', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:54', 5, 5);
INSERT INTO `materiales` VALUES (31139, 1, 'SLA-100', 'SELLO AUTOENTINTABLE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:54', 5, 5);
INSERT INTO `materiales` VALUES (12055, 1, 'O-103', 'SEMBRADOS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:54', 5, 5);
INSERT INTO `materiales` VALUES (12681, 1, 'O-182', 'SEMINARIO', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:54', 5, 5);
INSERT INTO `materiales` VALUES (35017, 1, 'CLA-100', 'SEPARACION DE CLAVES AREA VERDE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:54', 5, 5);
INSERT INTO `materiales` VALUES (9581, 1, 'P-005', 'SEPARADOR PARA LOSETA .05MM PAQ. 50', 795, 'PISOS', 'BOLSA', 'BOLSA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:54', 5, 5);
INSERT INTO `materiales` VALUES (35918, 1, 'SEP-100', 'SEPARADOR SIN NUMEROS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:15', '2020-10-19 11:16:54', 5, 5);
INSERT INTO `materiales` VALUES (30993, 1, 'SER-100', 'SERRUCHO CURVO P/PODA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:55', 5, 5);
INSERT INTO `materiales` VALUES (10058, 1, 'C-005', 'SERVICIO  DE BOMBA ', 810, 'CONCRETOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:55', 5, 5);
INSERT INTO `materiales` VALUES (10402, 1, 'EU-020', 'SERVICIO DE  GRUA', 785, 'ELECTRIFICACION URB', 'HORA', 'HORA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:55', 5, 5);
INSERT INTO `materiales` VALUES (11459, 1, 'O-038', 'SERVICIO DE 10,000 KM', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:55', 5, 5);
INSERT INTO `materiales` VALUES (12453, 1, 'O-147', 'SERVICIO DE AFINACION', 794, 'ACABADOS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:55', 5, 5);
INSERT INTO `materiales` VALUES (33775, 1, 'SRI-00', 'SERVICIO DE ALINEACION Y BALANCEO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:55', 5, 5);
INSERT INTO `materiales` VALUES (36951, 1, 'SEA-100', 'SERVICIO DE CONTROL DE ACCESO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:55', 5, 5);
INSERT INTO `materiales` VALUES (22320, 1, 'SER-VRH74', 'SERVICIO DE CONTROL VEHICULAR', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:55', 5, 5);
INSERT INTO `materiales` VALUES (33548, 1, 'EST-200', 'SERVICIO DE ESTETICA CANINA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:56', 5, 5);
INSERT INTO `materiales` VALUES (13522, 1, 'O-372', 'SERVICIO DE INSTALACION', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:56', 5, 5);
INSERT INTO `materiales` VALUES (29462, 1, 'SIM-101', 'SERVICIO DE INSTALACION Y MATERIALES', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:16', '2020-10-19 11:16:56', 5, 5);
INSERT INTO `materiales` VALUES (23742, 1, 'SR-L01', 'SERVICIO DE LUZ', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:56', 5, 5);
INSERT INTO `materiales` VALUES (13699, 1, 'SE-102', 'SERVICIO DE MONITOREO ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:56', 5, 5);
INSERT INTO `materiales` VALUES (11629, 1, 'O-051', 'SERVICIO DE PROGRAMACION DE TRANSFORMADOR', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:56', 5, 5);
INSERT INTO `materiales` VALUES (27810, 1, 'SRC-100', 'SERVICIO DE RECOLECCION DE BASURA', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:56', 5, 5);
INSERT INTO `materiales` VALUES (27890, 1, 'SEH-100', 'SERVICIO DE RENTA  HABITACION', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:56', 5, 5);
INSERT INTO `materiales` VALUES (36790, 1, 'SEC-300', 'SERVICIO DE RETIRO DE MATERIALES EN EL EMPLAZAMIENTO DE LA CONSTRUCCCION', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:57', 5, 5);
INSERT INTO `materiales` VALUES (23831, 1, 'ST-001', 'SERVICIO DE TOPOGRAFIA', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:57', 5, 5);
INSERT INTO `materiales` VALUES (23455, 1, 'D-001', 'SERVICIO DE VALIDACION', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:57', 5, 5);
INSERT INTO `materiales` VALUES (23061, 1, 'O-593', 'SERVICIO INTERNET', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:57', 5, 5);
INSERT INTO `materiales` VALUES (27801, 1, 'SEM-123', 'SERVICIO MEDICO', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:57', 5, 5);
INSERT INTO `materiales` VALUES (13708, 1, 'SER-001', 'SERVICIO MINIMO DE CONCRETO', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:17', '2020-10-19 11:16:57', 5, 5);
INSERT INTO `materiales` VALUES (11982, 1, 'O-091', 'SERVICIO TELEFONICO E INTERNET', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:57', 5, 5);
INSERT INTO `materiales` VALUES (12319, 1, 'O-100', 'SERVICIOS DE COMPUTACION ', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:57', 5, 5);
INSERT INTO `materiales` VALUES (11508, 1, 'O-046', 'SERVICIOS PROFESIONALES', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:58', 5, 5);
INSERT INTO `materiales` VALUES (30944, 1, 'SRV-100', 'SERVICIOS VARIOS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:58', 5, 5);
INSERT INTO `materiales` VALUES (30909, 1, 'SERV', 'SERVILLETAS', 803, 'EXTRAS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:58', 5, 5);
INSERT INTO `materiales` VALUES (27967, 1, 'SBY-109', 'SET DE 2 BUROS YOCO NATURAL', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:58', 5, 5);
INSERT INTO `materiales` VALUES (27949, 1, 'SMC-103', 'SET DE 2 MESAS DE CENTRO SAN LUCAS 60 Y 75 cm ENCINO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:58', 5, 5);
INSERT INTO `materiales` VALUES (29405, 1, 'SET-10', 'SET DE 3 LTON NEGRO CON DORADO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:58', 5, 5);
INSERT INTO `materiales` VALUES (29423, 1, 'SET-70', 'SET DE 3 PIÑAS DECORATIVAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:58', 5, 5);
INSERT INTO `materiales` VALUES (29420, 1, 'SET-50', 'SET DE BICHOS DECORATIVOS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:58', 5, 5);
INSERT INTO `materiales` VALUES (29417, 1, 'SEP-40', 'SET DE PLATONES GRANDES', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:59', 5, 5);
INSERT INTO `materiales` VALUES (13696, 1, 'SE-01', 'SEÑAL MENSUAL RASTREO GPS', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:18', '2020-10-19 11:16:59', 5, 5);
INSERT INTO `materiales` VALUES (27829, 1, 'SEÑ-104', 'SEÑALAMIENTO ESTIRENO EXTINTOR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:19', '2020-10-19 11:16:59', 5, 5);
INSERT INTO `materiales` VALUES (27826, 1, 'SEÑ-103', 'SEÑALAMIENTO ESTIRENO NO FUMAR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:19', '2020-10-19 11:16:59', 5, 5);
INSERT INTO `materiales` VALUES (27823, 1, 'SEÑ-102', 'SEÑALAMIENTO ESTIRENO RUTA DE EVACUACION', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:19', '2020-10-19 11:16:59', 5, 5);
INSERT INTO `materiales` VALUES (27820, 1, 'SEÑ-101', 'SEÑALAMIENTO ESTIRENO SALIDA DE EMERGENICA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:19', '2020-10-19 11:16:59', 5, 5);
INSERT INTO `materiales` VALUES (13585, 1, 'EU-080', 'SEÑALETICA ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:19', '2020-10-19 11:16:59', 5, 5);
INSERT INTO `materiales` VALUES (31452, 1, 'SHA-100', 'SHAMPOO PARA MANOS 5 LT', 803, 'EXTRAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:19', '2020-10-19 11:17:00', 5, 5);
INSERT INTO `materiales` VALUES (13408, 1, '0-328', 'SIERRA INGLETINER DE 10', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:19', '2020-10-19 11:17:00', 5, 5);
INSERT INTO `materiales` VALUES (36095, 1, 'SIK-459', 'SIKA ANCHOR FIX 2 CARTUCHO .459 KG.', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:19', '2020-10-19 11:17:00', 5, 5);
INSERT INTO `materiales` VALUES (35729, 1, 'SIK-32', 'SIKADUR 32 GEL IMPRIMANTE Y PUENTE ADHERENTE 2 COMP 1 KG.', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:20', '2020-10-19 11:17:00', 5, 5);
INSERT INTO `materiales` VALUES (13639, 1, 'A-087', 'SILICON TRANSPARENTE', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:20', '2020-10-19 11:17:00', 5, 5);
INSERT INTO `materiales` VALUES (12828, 1, 'O-200', 'SILLA EJECUTIVA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:20', '2020-10-19 11:17:00', 5, 5);
INSERT INTO `materiales` VALUES (27958, 1, 'SIL-106', 'SILLA REPLICA WISHBONE NATURAL', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:20', '2020-10-19 11:17:00', 5, 5);
INSERT INTO `materiales` VALUES (12831, 1, 'O-201', 'SILLA SECRETARIAL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:20', '2020-10-19 11:17:00', 5, 5);
INSERT INTO `materiales` VALUES (27376, 1, 'SIL-133', 'SILLA TRADICIONAL VINTAGE', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:20', '2020-10-19 11:17:01', 5, 5);
INSERT INTO `materiales` VALUES (12834, 1, 'O-202', 'SILLA VISITAS CLASSIC', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:20', '2020-10-19 11:17:01', 5, 5);
INSERT INTO `materiales` VALUES (27379, 1, 'SIL-134', 'SILLAS CROSS C/REMACHE', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:01', 5, 5);
INSERT INTO `materiales` VALUES (27187, 1, 'SLF-115', 'SILLAS FLORIDA PATA CLARA TERCIOPELO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:01', 5, 5);
INSERT INTO `materiales` VALUES (27382, 1, 'SIL-135', 'SILLAS HUECO RESPALDO TONO CAFE LIGHT', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:01', 5, 5);
INSERT INTO `materiales` VALUES (27373, 1, 'SIL-132', 'SILLAS JONATAN DE PAROTA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:01', 5, 5);
INSERT INTO `materiales` VALUES (27196, 1, 'SIL-119', 'SILLAS TAHO DE PAROTA MAX LUB GRIS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:01', 5, 5);
INSERT INTO `materiales` VALUES (27193, 1, 'SILL-118', 'SILLAS TIPO GRETA PATA TORNEADA C/BRAZO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:01', 5, 5);
INSERT INTO `materiales` VALUES (27190, 1, 'SIL-117', 'SILLAS TIPO GRIETA PATA TORNEADA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:02', 5, 5);
INSERT INTO `materiales` VALUES (9766, 1, 'SI-001', 'SILLETA MODELO SM300 P/CALZAR 7.5 CM DE MALLA DE CIMENTACION', 813, 'SILLETA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:02', 5, 5);
INSERT INTO `materiales` VALUES (9770, 1, 'SI-002', 'SILLETA MODELO SP125 P/CALZAR 3CM DE VARILLA NO.3 3/8 LOSA CIMENTACION', 813, 'SILLETA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:02', 5, 5);
INSERT INTO `materiales` VALUES (9774, 1, 'SI-003', 'SILLETA MODELO SP250 P/CALZAR VARILLA NO.3 3/8\" LOSA AZOTEA', 813, 'SILLETA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:02', 5, 5);
INSERT INTO `materiales` VALUES (11314, 1, 'SI-005', 'SILLETA PARA CALZAR VARILLA SP125 2.5CMTS ', 813, 'SILLETA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:03', 5, 5);
INSERT INTO `materiales` VALUES (9778, 1, 'SI-004', 'SILLETA SP125 P/CALZAR 3 CM VARILLA NO.3 3/8\" LOZA DE AZOTEA', 813, 'SILLETA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:21', '2020-10-19 11:17:03', 5, 5);
INSERT INTO `materiales` VALUES (15113, 1, 'SISC-852', 'SISTEMAS COMPUTACIONALES', 808, 'OTROS', '1', '1', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:22', '2020-10-19 11:17:03', 5, 5);
INSERT INTO `materiales` VALUES (13825, 1, 'SK-001', 'SKYDANCERS CON TELA', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:22', '2020-10-19 11:17:03', 5, 5);
INSERT INTO `materiales` VALUES (15172, 1, 'MO3', 'SN MATERIAL Y MANO DE OBRA', 15165, 'MATERIAL Y MANO DE OBRA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:22', '2020-10-19 11:17:03', 5, 5);
INSERT INTO `materiales` VALUES (29756, 1, 'SNH-100', 'SNOW HLL ( MARMOL )', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:22', '2020-10-19 11:17:04', 5, 5);
INSERT INTO `materiales` VALUES (13300, 1, '0-309', 'SOBRES AMARILLO  DE NOMINA', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:22', '2020-10-19 11:17:04', 5, 5);
INSERT INTO `materiales` VALUES (11803, 1, 'C-035', 'SOCLO 6.10 MTS', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:22', '2020-10-19 11:17:04', 5, 5);
INSERT INTO `materiales` VALUES (29997, 1, 'SOC-100', 'SOCULENTAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:22', '2020-10-19 11:17:04', 5, 5);
INSERT INTO `materiales` VALUES (28101, 1, '', 'SOFTRESTAURANTE', 818, 'VENTAS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:22', '2020-10-19 11:17:04', 5, 5);
INSERT INTO `materiales` VALUES (10681, 1, 'H-042', 'SOLDADURA 1/8', 786, 'HIDRAULICA', 'KILO', 'KILO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:22', '2020-10-19 11:17:04', 5, 5);
INSERT INTO `materiales` VALUES (10705, 1, 'H-047', 'SOLDADURA 50x50 OMEGA', 786, 'HIDRAULICA', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:22', '2020-10-19 11:17:04', 5, 5);
INSERT INTO `materiales` VALUES (10821, 1, '', 'SOLDADURA ESTAÑO PARA COBRE ', 808, 'OTROS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:23', '2020-10-19 11:17:04', 5, 5);
INSERT INTO `materiales` VALUES (36775, 1, 'HUM-200', 'SONDEOS EXPLORATORIOS PARA OBTENER PORCENTAJE DE HUMEDAD', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:23', '2020-10-19 11:17:05', 5, 5);
INSERT INTO `materiales` VALUES (32281, 1, 'SPL-100', 'SOPORTE DE LAMINA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:23', '2020-10-19 11:17:05', 5, 5);
INSERT INTO `materiales` VALUES (10446, 1, 'HE-003', 'SOPORTE LATERAL PARA LAVADERO, INCLUYE INSTALACION', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:23', '2020-10-19 11:17:05', 5, 5);
INSERT INTO `materiales` VALUES (23959, 1, 'SPT-01', 'SOPORTE PARA TELEVISION', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:23', '2020-10-19 11:17:05', 5, 5);
INSERT INTO `materiales` VALUES (11495, 1, 'E-066', 'SOQUET DE PLASTICO BENJAMIN SIN CADENA', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:23', '2020-10-19 11:17:05', 5, 5);
INSERT INTO `materiales` VALUES (13687, 1, 'E-0086', 'SPOT  REDONDO SATINADO  YD-140 ', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:23', '2020-10-19 11:17:05', 5, 5);
INSERT INTO `materiales` VALUES (36487, 1, 'STM-200', 'STAND CON MURO DE 2X2 - ANUNCIO LUMINOSO EN ACRILICO', 818, 'VENTAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:23', '2020-10-19 11:17:05', 5, 5);
INSERT INTO `materiales` VALUES (13348, 1, 'IN-02', 'STOP', 822, 'INFRAESTRUCTURA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:05', 5, 5);
INSERT INTO `materiales` VALUES (13864, 1, 'IN-103', 'STRATA BIANCO 50X50 PRIMERA ', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:06', 5, 5);
INSERT INTO `materiales` VALUES (12888, 1, 'AV-004', 'STREET GYM ', 821, 'AREA VERDE', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:06', 5, 5);
INSERT INTO `materiales` VALUES (9782, 1, 'A-001', 'STUBLOCK BLANCO (EMPLASTE )', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:06', 5, 5);
INSERT INTO `materiales` VALUES (24515, 1, 'U-006', 'SUBBASE CON 60%  BASE INDUSTRIAL DE 1 1/2\" A FINOS Y 40% CALICHE CRIBADO EN UNA CAPA DE 20 CM DE ESPESOR PROMEDIO. INCLUYE: SUMINISTRO DE MATERIAL, HUMECTACION, MEZCLADO, TENDIDO Y COMPACTADO AL 95% D', 806, 'URBANIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:06', 5, 5);
INSERT INTO `materiales` VALUES (12885, 1, 'AV-003', 'SUBE Y BAJA DOBLE ', 821, 'AREA VERDE', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:06', 5, 5);
INSERT INTO `materiales` VALUES (33516, 1, 'HER-100', 'SUBIBAJA FABRICADO CON TUBO DE 21/2 CED 30, TUBO DE 2 CED 30, TUBO DE 3/4 CED 30 Y SOLERA DE 1/8*1.', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:06', 5, 5);
INSERT INTO `materiales` VALUES (35127, 1, 'sub-2018', 'SUBURBAN', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:06', 5, 5);
INSERT INTO `materiales` VALUES (25331, 1, 'SUM-108', 'SUMINISTO DE TUBERIA DE ACERO RANURADA DE 16\" DE DIAMETRO Y 1/4\" DE ESPESOR', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:06', 5, 5);
INSERT INTO `materiales` VALUES (27777, 1, 'CRI-122', 'SUMINISTRO CUBIERTA CRISTAL CLARO 12 MM CON CANTO PULIDO RECTO DE 1.60', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:07', 5, 5);
INSERT INTO `materiales` VALUES (26281, 1, 'ELE-100', 'SUMINISTRO DE ACOMETIDA ELECTRICA AEREA E INSTALACION ELECTRICA PARA ALIMENTACION DE AIRES', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:24', '2020-10-19 11:17:07', 5, 5);
INSERT INTO `materiales` VALUES (25340, 1, 'SUM-111', 'SUMINISTRO DE AGUA', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:07', 5, 5);
INSERT INTO `materiales` VALUES (27783, 1, 'ALU-174', 'SUMINISTRO DE ALUMINIO DE 3\" CLARO EN G2 VIDRIO CLARO DE 6mm CON PELICULA DE SEGURIDAD', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:07', 5, 5);
INSERT INTO `materiales` VALUES (25328, 1, 'SUM-107', 'SUMINISTRO DE TUBERIA DE ACERO LISA DE 16\" DE DIAMETRO Y 1/4 DE ESPESOR', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:07', 5, 5);
INSERT INTO `materiales` VALUES (29239, 1, 'SCB-100', 'SUMINISTRO E INSTALACION DE CORTINAS DE TELA IMPORTADA INC. CORTINA BLACKOUT', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:07', 5, 5);
INSERT INTO `materiales` VALUES (34474, 1, 'SIE-100', 'SUMINISTRO E INSTALACION DE ESMERILADO EN CRISTALES', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:07', 5, 5);
INSERT INTO `materiales` VALUES (36780, 1, 'PTZ-200', 'SUMINISTRO E INSTALACION DE PAPEL TAPIZ', 808, 'OTROS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:07', 5, 5);
INSERT INTO `materiales` VALUES (13615, 1, 'EU-078', 'SUMINISTRO E INSTALACION DE PAPEL TAPIZ EN CASA MUESTRA', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:08', 5, 5);
INSERT INTO `materiales` VALUES (29148, 1, 'SEP-114', 'SUMINISTRO E INSTALACION DE PERSIANAS ENROLLABLES MOTORIZADAS Y CONTROL REMOTO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:08', 5, 5);
INSERT INTO `materiales` VALUES (25885, 1, 'U-029', 'SUMINISTRO E INSTALACION DE PIEZAS ESPECIALES. INCLUYE: SUMINISTRO E INSTALACION Y PRUEBA DE PIEZAS ESPECIALES (4 JUNTA DE GIBAULT DE 3\", 2 TEE DE PVC DE 3\")', 806, 'URBANIZACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:08', 5, 5);
INSERT INTO `materiales` VALUES (12325, 1, 'EU-035', 'SUMINISTRO E INSTALACION DE REGISTRO DE CONCRETO TIPO RBTBB2', 785, 'ELECTRIFICACION URB', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:08', 5, 5);
INSERT INTO `materiales` VALUES (27769, 1, 'COB-185', 'SUMINISTRO E INSTALACION DE TELA IMPORTADA', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:08', 5, 5);
INSERT INTO `materiales` VALUES (25717, 1, 'U-039', 'SUMINISTRO E INSTALACION DE TUBERIA DE 10\" (250MM) DE DIAMETRO DE POLIETILENO DE ALTA DENSIDAD (PEAD) CON JUNTA HERMETICA PARA DRENAJE SANITARIO, INCLUYE: SUMINISTRO DE TUBERIA, INSTALACION Y PRUEBA D', 806, 'URBANIZACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:25', '2020-10-19 11:17:08', 5, 5);
INSERT INTO `materiales` VALUES (25626, 1, 'U-019', 'SUMINISTRO E INSTALACION DE TUBERIA DE 8\" (200MM) DE DIAMETRO DE POLIETILENO DE ALTA DENSIDAD (PEAD) CON JUNTA HERMETICA PARA DRENAJE SANITARIO, INCLUYE: SUMINISTRO DE TUBERIA, INSTALACION Y PRUEBA DE', 806, 'URBANIZACION', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:08', 5, 5);
INSERT INTO `materiales` VALUES (25629, 1, 'U-048', 'SUMINISTRO E INSTALACION DE TUBERIA PVC HIDRAHULICO RD-32 DE 4\" DE DIAMETRO. INCLUYE SUMINISTRO DE TUBERIA, COLOCACION Y PREUBA', 806, 'URBANIZACION', 'M.L.', 'M.L.', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:08', 5, 5);
INSERT INTO `materiales` VALUES (25623, 1, 'U-028', 'SUMINISTRO E INSTALACION DE TUBERIA PVC HIDRAULICO RD-26 DE 4\"  DE DIAMETRO. INCLUYE: SUMINISTRO DE TUBERIA, COLOCACION Y PRUEBA.', 806, 'URBANIZACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:09', 5, 5);
INSERT INTO `materiales` VALUES (27047, 1, 'U-047', 'SUMINISTRO E INSTALACION DE TUBERIA PVC HIDRAULICO RD-32 DE 6\"  DE DIAMETRO. INCLUYE: SUMINISTRO DE TUBERIA, COLOCACION Y PRUEBA.', 806, 'URBANIZACION', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:09', 5, 5);
INSERT INTO `materiales` VALUES (13843, 1, 'EU-100', 'SUMINISTRO E INSTALACION DE TUBOS PARA VELARIA ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:09', 5, 5);
INSERT INTO `materiales` VALUES (19217, 1, 'EC-01', 'SUMINISTRO EQUIPO DE COMPUTO', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:09', 5, 5);
INSERT INTO `materiales` VALUES (25325, 1, 'SUM-106', 'SUMINISTRO Y COLOCACION  DE GRAVA DE 1/2 A 3/4 COLOCADA ENTRE AMPLIACION Y TUBERIA PARA FORMAR FILTRO', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:09', 5, 5);
INSERT INTO `materiales` VALUES (22103, 1, 'SO-01', 'SUPERVISION DE OBRA', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:09', 5, 5);
INSERT INTO `materiales` VALUES (11962, 1, 'O-088', 'SUSCRIPCION  NUEVA ONLINE', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:09', 5, 5);
INSERT INTO `materiales` VALUES (31587, 1, 'SWT-100', 'SWITCH TP LINK 5 PUERTOS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:09', 5, 5);
INSERT INTO `materiales` VALUES (25031, 1, 'SEN-146', 'Set de espejos Nahia - Natural', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:26', '2020-10-19 11:17:09', 5, 5);
INSERT INTO `materiales` VALUES (24929, 1, 'SG-113', 'Silla Guerrero - Coral', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:27', '2020-10-19 11:17:10', 5, 5);
INSERT INTO `materiales` VALUES (24973, 1, 'SJ-126', 'Silla Josefina - Azul', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:27', '2020-10-19 11:17:10', 5, 5);
INSERT INTO `materiales` VALUES (24899, 1, 'SS-103', 'Silla Salvador natural - Gris claro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:27', '2020-10-19 11:17:10', 5, 5);
INSERT INTO `materiales` VALUES (24995, 1, 'STN-133', 'Silla Tria nogal - Azul', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:27', '2020-10-19 11:17:10', 5, 5);
INSERT INTO `materiales` VALUES (24998, 1, 'ST-134', 'Silla Tria nogal - Verde', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:27', '2020-10-19 11:17:10', 5, 5);
INSERT INTO `materiales` VALUES (25022, 1, 'SA-144', 'Sillón Ajalpan - Gris claro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:27', '2020-10-19 11:17:10', 5, 5);
INSERT INTO `materiales` VALUES (25049, 1, 'SG-151', 'Sillón Guatei - Menta', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:27', '2020-10-19 11:17:10', 5, 5);
INSERT INTO `materiales` VALUES (24986, 1, 'SLG-130', 'Sillón Linares - Gris', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:27', '2020-10-19 11:17:11', 5, 5);
INSERT INTO `materiales` VALUES (24992, 1, 'S2C-131', 'Sofá 2 cuerpos Márquez - Azul', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:27', '2020-10-19 11:17:11', 5, 5);
INSERT INTO `materiales` VALUES (25019, 1, 'SAL-143', 'Sofá Almoloya loveseat - Verde', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:27', '2020-10-19 11:17:11', 5, 5);
INSERT INTO `materiales` VALUES (24964, 1, 'SA-123', 'Sofá Arizpe 2 cuerpos - Azul', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:28', '2020-10-19 11:17:11', 5, 5);
INSERT INTO `materiales` VALUES (12263, 1, 'O-121', 'TABLA DE 1\" X 10 CM X 2.40 MTS DE LARGO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:28', '2020-10-19 11:17:11', 5, 5);
INSERT INTO `materiales` VALUES (12260, 1, 'O-120', 'TABLA DE 1\" X 15CM X 5MTS DE LARGO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:28', '2020-10-19 11:17:11', 5, 5);
INSERT INTO `materiales` VALUES (13423, 1, '0-331', 'TABLA MADERA C/CLIP   T/CARTA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:28', '2020-10-19 11:17:11', 5, 5);
INSERT INTO `materiales` VALUES (31464, 1, 'TAB-100', 'TABLOIDES', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:28', '2020-10-19 11:17:11', 5, 5);
INSERT INTO `materiales` VALUES (30069, 1, 'TBA-100', 'TABLON DE ACERO .25X2.54 PARA ANDAMIOS', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:28', '2020-10-19 11:17:12', 5, 5);
INSERT INTO `materiales` VALUES (33715, 1, 'TAL-200', 'TALACHO PICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:28', '2020-10-19 11:17:12', 5, 5);
INSERT INTO `materiales` VALUES (31228, 1, 'TAL-100', 'TALACHO PICO FORJ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:28', '2020-10-19 11:17:12', 5, 5);
INSERT INTO `materiales` VALUES (34801, 1, 'TAL-300', 'TALADRO INALAMBRICO INC. BATERIA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:28', '2020-10-19 11:17:12', 5, 5);
INSERT INTO `materiales` VALUES (9598, 1, 'G-005', 'TANQUE ESTACIONARIO 300 LTS. TATSA', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:28', '2020-10-19 11:17:12', 5, 5);
INSERT INTO `materiales` VALUES (11032, 1, 'O-020', 'TANQUE HORIZONTAL PARA HIDRO 80L CON ACCESORIOS PUMPS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:29', '2020-10-19 11:17:12', 5, 5);
INSERT INTO `materiales` VALUES (10082, 1, 'T-002', 'TANQUE SANITARIO 4.8 L MODELO JAZMIN REDONDO MARCA CATO', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:29', '2020-10-19 11:17:12', 5, 5);
INSERT INTO `materiales` VALUES (10202, 1, 'E-020', 'TAPA APAGADOR 1 VENTANA ', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:29', '2020-10-19 11:17:12', 5, 5);
INSERT INTO `materiales` VALUES (10206, 1, 'E-021', 'TAPA APAGADOR 2 VENTANAS ', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:29', '2020-10-19 11:17:13', 5, 5);
INSERT INTO `materiales` VALUES (10210, 1, 'E-022', 'TAPA APAGADOR 3 VENTANAS ', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:29', '2020-10-19 11:17:13', 5, 5);
INSERT INTO `materiales` VALUES (10214, 1, 'E-023', 'TAPA CIEGA MARCA SCUDETTO COLOR  BLANCO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:29', '2020-10-19 11:17:13', 5, 5);
INSERT INTO `materiales` VALUES (12705, 1, 'S-046', 'TAPA DE INSERCION 2\" DE PVC', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:29', '2020-10-19 11:17:13', 5, 5);
INSERT INTO `materiales` VALUES (9714, 1, 'S-005', 'TAPA DE INSERCION PVC 4\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:29', '2020-10-19 11:17:13', 5, 5);
INSERT INTO `materiales` VALUES (10410, 1, 'EU-022', 'TAPA DE REGISTRO RBTB-2 CON 2 TORNILLOS DE SEGURIDAD', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:29', '2020-10-19 11:17:13', 5, 5);
INSERT INTO `materiales` VALUES (10418, 1, 'EU-024', 'TAPA PARA REGISTRO DE ALUMBRADO 40X0 CON ANGULO DE 1/8', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:29', '2020-10-19 11:17:14', 5, 5);
INSERT INTO `materiales` VALUES (27988, 1, 'TAP-116', 'TAPETE HUAYAPAM 200X250 BEIGE', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:30', '2020-10-19 11:17:14', 5, 5);
INSERT INTO `materiales` VALUES (27985, 1, 'TAP-115', 'TAPETE ZANATEPEC 120X170 AZ', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:30', '2020-10-19 11:17:14', 5, 5);
INSERT INTO `materiales` VALUES (9678, 1, 'H-009', 'TAPON CACHUCHA GALVANIZADO DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:30', '2020-10-19 11:17:14', 5, 5);
INSERT INTO `materiales` VALUES (12398, 1, 'URB-004', 'TAPON CAMP. 8\" ', 806, 'URBANIZACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:30', '2020-10-19 11:17:14', 5, 5);
INSERT INTO `materiales` VALUES (9870, 1, 'AC-006', 'TAPON CESPOL CHUPON PARA TRAMPA TARJA', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:30', '2020-10-19 11:17:15', 5, 5);
INSERT INTO `materiales` VALUES (10693, 1, 'H-044', 'TAPON DE 1/2\" DE COBRE INTERIOR', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:30', '2020-10-19 11:17:15', 5, 5);
INSERT INTO `materiales` VALUES (10709, 1, 'H-048', 'TAPON DE 1/2\" GALVANIZADO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:30', '2020-10-19 11:17:15', 5, 5);
INSERT INTO `materiales` VALUES (10745, 1, 'H-053', 'TAPON GALVANIZADO DE 1/2 \" HEMBRA (ROSCA INTERIOR)', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:31', '2020-10-19 11:17:15', 5, 5);
INSERT INTO `materiales` VALUES (12486, 1, 'H-095', 'TAPON HEMBRA 1/2\" Diametro ( TAPON PLUS)', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:31', '2020-10-19 11:17:15', 5, 5);
INSERT INTO `materiales` VALUES (12976, 1, 'H-117', 'TAPON HEMBRA 3/4 DIAMETRO CPVC', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:31', '2020-10-19 11:17:16', 5, 5);
INSERT INTO `materiales` VALUES (12489, 1, 'H-096', 'TAPON HEMBRA 3/4\" Diametro ( TAPON PLUS)', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:31', '2020-10-19 11:17:16', 5, 5);
INSERT INTO `materiales` VALUES (11694, 1, 'H-136', 'TAPON HEMBRA CPVC DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:31', '2020-10-19 11:17:16', 5, 5);
INSERT INTO `materiales` VALUES (9662, 1, 'H-004', 'TAPON HEMBRA TUBOPLUS DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:31', '2020-10-19 11:17:16', 5, 5);
INSERT INTO `materiales` VALUES (13318, 1, 'H-119', 'TAPON MACHO GALV 1 ', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:31', '2020-10-19 11:17:16', 5, 5);
INSERT INTO `materiales` VALUES (9682, 1, 'H-010', 'TAPON MACHO GALVANIZADO DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:16', 5, 5);
INSERT INTO `materiales` VALUES (10932, 1, 'H-058', 'TAPON PARA LAVABO CHUPON', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:16', 5, 5);
INSERT INTO `materiales` VALUES (22461, 1, 'S-050', 'TAPON PVC DE 2\" DE DIAMETRO', 813, 'SILLETA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:16', 5, 5);
INSERT INTO `materiales` VALUES (22464, 1, 'S-051', 'TAPON PVC DE 4\" DE DIAMETRO', 783, 'SANITARIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:17', 5, 5);
INSERT INTO `materiales` VALUES (10498, 1, 'H-023', 'TAPON PVC HIDRAULICO HEMBRA DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:17', 5, 5);
INSERT INTO `materiales` VALUES (10928, 1, 'H-057', 'TAQUETES', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:17', 5, 5);
INSERT INTO `materiales` VALUES (10318, 1, 'S-020', 'TAQUETES DE 3/8\" PARA PIJAS ', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:17', 5, 5);
INSERT INTO `materiales` VALUES (27876, 1, 'TRF-185', 'TARIFAS', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:17', 5, 5);
INSERT INTO `materiales` VALUES (12765, 1, 'CS-018', 'TARIMA MATRIMONIAL BASE BARI  ALTO:33 CM', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:17', 5, 5);
INSERT INTO `materiales` VALUES (34223, 1, 'TAI-100', 'TARJA DE ACE INOX DE 2 TINAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:17', 5, 5);
INSERT INTO `materiales` VALUES (9866, 1, 'AC-005', 'TARJA DE ACERO INOXIDABLE ', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:18', 5, 5);
INSERT INTO `materiales` VALUES (10884, 1, 'S-036', 'TARJA INOX DOS TINAS MOD CS-110', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:32', '2020-10-19 11:17:18', 5, 5);
INSERT INTO `materiales` VALUES (27868, 1, 'TAJ-101', 'TARJETA DE SALUD', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:18', 5, 5);
INSERT INTO `materiales` VALUES (13822, 1, 'TA-002', 'TARJETA PANASONIC KX-TE82480 DE 3 LINEAS ', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:18', 5, 5);
INSERT INTO `materiales` VALUES (13717, 1, 'TA-001', 'TARJETA SIM TCM011', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:18', 5, 5);
INSERT INTO `materiales` VALUES (11556, 1, 'O-049', 'TARJETAS DE PRESENTACION', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:18', 5, 5);
INSERT INTO `materiales` VALUES (33461, 1, 'TAR-1815', 'TARJETAS MARCA ZEBRA DE PVC 30 MILESIMAS (500 PZAS) BLANCO', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:18', 5, 5);
INSERT INTO `materiales` VALUES (27246, 1, 'TAZ-125', 'TAZA REDONDA - AMERICANO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:18', 5, 5);
INSERT INTO `materiales` VALUES (10078, 1, 'T-001', 'TAZA SANITARIA 4.8 L MODELO JAZMIN REDONDO MARCA CATO', 801, 'ECOTECNOLOGIAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:19', 5, 5);
INSERT INTO `materiales` VALUES (27640, 1, 'TAZ-135', 'TAZON ABIERTO 25X25 NEGRO MATE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:19', 5, 5);
INSERT INTO `materiales` VALUES (27240, 1, 'TAZ-123', 'TAZON CEREAL 14 DIAM X 8', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:19', 5, 5);
INSERT INTO `materiales` VALUES (12988, 1, 'O-253', 'TECLADO INALAMBRICO MK220', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:19', 5, 5);
INSERT INTO `materiales` VALUES (12900, 1, 'O-213', 'TECLADO MK 270 INALAM LGTECHG', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:33', '2020-10-19 11:17:19', 5, 5);
INSERT INTO `materiales` VALUES (13393, 1, 'G-029', 'TEE 1/2 MULTICAPA', 784, 'GAS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:19', 5, 5);
INSERT INTO `materiales` VALUES (12091, 1, 'H-083', 'TEE CPVC 1 PULGADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:19', 5, 5);
INSERT INTO `materiales` VALUES (11690, 1, 'H-137', 'TEE CPVC DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:20', 5, 5);
INSERT INTO `materiales` VALUES (33650, 1, 'H-247', 'TEE CPVC DE 3/4\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:20', 5, 5);
INSERT INTO `materiales` VALUES (9642, 1, 'G-002', 'TEE DE 1/2 DE DIAMETRO MULTICAPA MARCA DURMAN', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:20', 5, 5);
INSERT INTO `materiales` VALUES (10482, 1, 'H-019', 'TEE DE 1/2\" GALVANIZADO ', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:20', 5, 5);
INSERT INTO `materiales` VALUES (10607, 1, 'G-008', 'TEE DE 3/8\" MULTICAPA MARCA DURMAN', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:20', 5, 5);
INSERT INTO `materiales` VALUES (10649, 1, 'H-038', 'TEE DE COBRE DE 1/2', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:20', 5, 5);
INSERT INTO `materiales` VALUES (10689, 1, 'S-024', 'TEE DE PVC 4\" CON REDUCCION A 2\"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:20', 5, 5);
INSERT INTO `materiales` VALUES (35953, 1, 'TEF-060', 'TEE FO.FO 6\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:21', 5, 5);
INSERT INTO `materiales` VALUES (35956, 1, 'TEF-086', 'TEE FO.FO 8\" A 6\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:34', '2020-10-19 11:17:21', 5, 5);
INSERT INTO `materiales` VALUES (11599, 1, 'H-072', 'TEE PLUS 1 PULGADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:21', 5, 5);
INSERT INTO `materiales` VALUES (9734, 1, 'S-010', 'TEE PVC DE 2\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:21', 5, 5);
INSERT INTO `materiales` VALUES (9718, 1, 'S-006', 'TEE PVC DE 4\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:21', 5, 5);
INSERT INTO `materiales` VALUES (12121, 1, 'S-043', 'TEE PVC DE 4\" DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:21', 5, 5);
INSERT INTO `materiales` VALUES (35583, 1, 'TEE-124', 'TEE PVC HID CED 40 CEM 1 1/4\"', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:21', 5, 5);
INSERT INTO `materiales` VALUES (34931, 1, 'TCD-041', 'TEE PVC HID CED 40 CEM 1\"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:21', 5, 5);
INSERT INTO `materiales` VALUES (34924, 1, 'THC-040', 'TEE PVC HID CED 40 CEM 1\" X 1/2 \"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:22', 5, 5);
INSERT INTO `materiales` VALUES (34937, 1, 'TPH-040', 'TEE PVC HID CED 40 CEM 2\"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:22', 5, 5);
INSERT INTO `materiales` VALUES (35553, 1, 'TEE-114', 'TEE PVC HID CED 40 CEM X R-INT 1 1/4\" X 1/2', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:22', 5, 5);
INSERT INTO `materiales` VALUES (35547, 1, 'TEE-112', 'TEE PVC HID CED 40 CEM X R-INT 1\" X 1/2', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:22', 5, 5);
INSERT INTO `materiales` VALUES (10494, 1, 'H-022', 'TEE PVC HIDRAULICO DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:35', '2020-10-19 11:17:22', 5, 5);
INSERT INTO `materiales` VALUES (12117, 1, 'S-042', 'TEE PVC REDUCCION 4\" X 2\"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:22', 5, 5);
INSERT INTO `materiales` VALUES (9658, 1, 'H-003', 'TEE TUBOPLUS DE 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:22', 5, 5);
INSERT INTO `materiales` VALUES (18944, 1, 'TEFLO-01', 'TEFLONES', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:22', 5, 5);
INSERT INTO `materiales` VALUES (19245, 1, 'AC-025', 'TEJA', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:23', 5, 5);
INSERT INTO `materiales` VALUES (11698, 1, 'A-028', 'TEJA DE BARRO COSALA ROJIZA', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:23', 5, 5);
INSERT INTO `materiales` VALUES (9830, 1, 'A-013', 'TEJA DE BARRO PORTUGUESA NAT. ROJIZA', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:23', 5, 5);
INSERT INTO `materiales` VALUES (11811, 1, 'C-037', 'TELA MOSQUITERA ROLLO 30 MTS', 796, 'CANCELERIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:23', 5, 5);
INSERT INTO `materiales` VALUES (13831, 1, 'T-200', 'TELA PARA PLAFON ', 794, 'ACABADOS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:23', 5, 5);
INSERT INTO `materiales` VALUES (34336, 1, 'TEG-100', 'TELA TERGAL GRUESA SUBLIMADA ALTA DEFINICION 1.30X3.55º', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:23', 5, 5);
INSERT INTO `materiales` VALUES (34339, 1, 'TEG-200', 'TELA TERGAL GRUESA SUBLIMADA ALTA DEFINICION 1.42X2.80', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:23', 5, 5);
INSERT INTO `materiales` VALUES (34342, 1, 'TEG-300', 'TELA TERGAL GRUESA SUBLIMADA ALTA DEFINICION 1.45X4.50', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:36', '2020-10-19 11:17:24', 5, 5);
INSERT INTO `materiales` VALUES (13528, 1, '0-340', 'TELEFONO PANASONIC', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:24', 5, 5);
INSERT INTO `materiales` VALUES (27733, 1, 'TLV-50', 'TELEVISION LED 50\" HISENSE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:24', 5, 5);
INSERT INTO `materiales` VALUES (27736, 1, 'TEL-65', 'TELEVISION LED 65\" HISENSE SMART', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:24', 5, 5);
INSERT INTO `materiales` VALUES (13237, 1, '0-294', 'TELEVISION SMART  48 ', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:24', 5, 5);
INSERT INTO `materiales` VALUES (13234, 1, '0-293', 'TELEVISION SPECTRA 32 HD', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:24', 5, 5);
INSERT INTO `materiales` VALUES (19729, 1, '0-345', 'TELEVISON', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:25', 5, 5);
INSERT INTO `materiales` VALUES (23058, 1, 'TO-01', 'TERMINACION DE OBRA', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:25', 5, 5);
INSERT INTO `materiales` VALUES (12795, 1, 'E-069', 'TERMO MAGNETICO 20 AMP BT PLUG BTCINO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:25', 5, 5);
INSERT INTO `materiales` VALUES (10134, 1, 'E-003', 'TERMOMAGNETICO 30AMP BTPLUG BTCINO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:25', 5, 5);
INSERT INTO `materiales` VALUES (33747, 1, 'TRM-174', 'TERMOS IMPRESOS A 3 TINTAS EN SERIGRAFIA Y VINIL DE CORTE', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:25', 5, 5);
INSERT INTO `materiales` VALUES (19276, 1, 'TERR-1', 'TERRENO', 808, 'OTROS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:37', '2020-10-19 11:17:26', 5, 5);
INSERT INTO `materiales` VALUES (13861, 1, 'IN-101', 'TESSUTO PEARL WHITE 60X60', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:26', 5, 5);
INSERT INTO `materiales` VALUES (9786, 1, 'A-002', 'TEXTU-REAL COLOR BLANCO SACO DE 40KG', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:26', 5, 5);
INSERT INTO `materiales` VALUES (11580, 1, 'A-027', 'TEXTUCO BLANCO ', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:26', 5, 5);
INSERT INTO `materiales` VALUES (11577, 1, 'A-O26', 'TEXTUCO PLUS SACO DE 40KG', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:26', 5, 5);
INSERT INTO `materiales` VALUES (16944, 1, 'TEXT CEMIX', 'TEXTURA CEMIX', 794, 'ACABADOS', '1', '1', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:26', 5, 5);
INSERT INTO `materiales` VALUES (12585, 1, 'H-102', 'TEÉ 1\" GALVANIZADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:26', 5, 5);
INSERT INTO `materiales` VALUES (12675, 1, 'O-174', 'THINER', 808, 'OTROS', 'LITROS', 'LITROS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:26', 5, 5);
INSERT INTO `materiales` VALUES (13384, 1, '0-322', 'TIERRA', 808, 'OTROS', 'VIAJE', 'VIAJE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:27', 5, 5);
INSERT INTO `materiales` VALUES (12339, 1, '0-135', 'TIJERAS', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:27', 5, 5);
INSERT INTO `materiales` VALUES (19649, 1, '', 'TIJERAS PARA PODAR JARDIN', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:27', 5, 5);
INSERT INTO `materiales` VALUES (13192, 1, '0-281', 'TIMBRES FISCALES', 808, 'OTROS', 'SERV', 'SERV', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:27', 5, 5);
INSERT INTO `materiales` VALUES (11409, 1, 'AC-017', 'TINACO 750 LTS.MARCA ROTOPLAS COLOR NEGRO', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:38', '2020-10-19 11:17:27', 5, 5);
INSERT INTO `materiales` VALUES (26665, 1, 'AC-060', 'TINACO CISTERNA 450 LTS. MARCA IUSA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:39', '2020-10-19 11:17:27', 5, 5);
INSERT INTO `materiales` VALUES (13603, 1, 'AC-276', 'TINACO DE 450LTS AQUAPLASH COLOR BEIGE ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:39', '2020-10-19 11:17:27', 5, 5);
INSERT INTO `materiales` VALUES (13267, 1, '0-299', 'TINTA P/SELLO NEGRA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:39', '2020-10-19 11:17:28', 5, 5);
INSERT INTO `materiales` VALUES (11176, 1, 'A-024', 'TIROL', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:39', '2020-10-19 11:17:28', 5, 5);
INSERT INTO `materiales` VALUES (10880, 1, 'S-035', 'TOALLERO BARRA VERTIKA CROMO 16105', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:39', '2020-10-19 11:17:28', 5, 5);
INSERT INTO `materiales` VALUES (33505, 1, 'TOL-200', 'TOLDO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:39', '2020-10-19 11:17:28', 5, 5);
INSERT INTO `materiales` VALUES (29302, 1, 'TOL-100', 'TOLDO DE 3X3 ALTURA DE 2.5 M INCL. LOA COLOR BLANCO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:39', '2020-10-19 11:17:28', 5, 5);
INSERT INTO `materiales` VALUES (25720, 1, 'U-032', 'TOMA DOMICILIARIA DE 7.0 M DE DESARROLLO, INCLUYE: EXCAVACION CON EQUIPO MECANICO, ABRAZADERA DE PVC DE 3\" CON SALIDA DE 1/2\", VALVULA DE INSERCION DE 1/2\", VALVULA BANQUETA DE 1/2\", MANGUERA PE AL PE', 806, 'URBANIZACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:39', '2020-10-19 11:17:28', 5, 5);
INSERT INTO `materiales` VALUES (26107, 1, 'U-58', 'TOMA DOMICILIARIA DE 7.0 M DE DESARROLLO, INCLUYE: EXCAVACION CON EQUIPO MECANICO, ABRAZADERA DE PVC DE 4\" CON SALIDA DE 1/2\", VALVULA DE INSERCION DE 1/2\", VALVULA BANQUETA DE 1/2\", MANGUERA PE AL PE', 806, 'URBANIZACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:40', '2020-10-19 11:17:28', 5, 5);
INSERT INTO `materiales` VALUES (12855, 1, 'O-206', 'TONER CANON 119', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:40', '2020-10-19 11:17:28', 5, 5);
INSERT INTO `materiales` VALUES (12858, 1, 'O-207', 'TONER CANON 120', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:40', '2020-10-19 11:17:28', 5, 5);
INSERT INTO `materiales` VALUES (12342, 1, '', 'TONER GYG COMPATIBLE CE278A', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:40', '2020-10-19 11:17:29', 5, 5);
INSERT INTO `materiales` VALUES (12843, 1, '0-300', 'TONER HP LASERJET P1102w', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:40', '2020-10-19 11:17:29', 5, 5);
INSERT INTO `materiales` VALUES (12272, 1, 'O-124', 'TONER PARA PLOTER HP DESIGNJET T120', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:40', '2020-10-19 11:17:29', 5, 5);
INSERT INTO `materiales` VALUES (13705, 1, 'O-124N', 'TONER PARA PLOTER HP NEGRO', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:40', '2020-10-19 11:17:29', 5, 5);
INSERT INTO `materiales` VALUES (13849, 1, 'O-124AM', 'TONER PLOTER AMARILLO', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:40', '2020-10-19 11:17:29', 5, 5);
INSERT INTO `materiales` VALUES (13846, 1, 'O-124C', 'TONER PLOTER CYAN ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:40', '2020-10-19 11:17:29', 5, 5);
INSERT INTO `materiales` VALUES (13702, 1, 'O-124P', 'TONER PLOTER MAGENTA hp 711.', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:40', '2020-10-19 11:17:29', 5, 5);
INSERT INTO `materiales` VALUES (12504, 1, 'O-150', 'TORN LAMINA T/AB 12X2\"', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:41', '2020-10-19 11:17:29', 5, 5);
INSERT INTO `materiales` VALUES (11056, 1, 'G-018', 'TORNILLO 1/4\"x1\"', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:41', '2020-10-19 11:17:30', 5, 5);
INSERT INTO `materiales` VALUES (35968, 1, 'TOR-312', 'TORNILLO C/TUERCA 3/4\" X 3 1/2 \" GALV.', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:41', '2020-10-19 11:17:30', 5, 5);
INSERT INTO `materiales` VALUES (20214, 1, 'TOR', 'TORNILLOS P/MANERAL CLAVE 44615', 808, 'OTROS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:41', '2020-10-19 11:17:30', 5, 5);
INSERT INTO `materiales` VALUES (11893, 1, 'O-078', 'TORNILLOS VARIOS', 808, 'OTROS', 'MILLAR', 'MILLAR', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:41', '2020-10-19 11:17:30', 5, 5);
INSERT INTO `materiales` VALUES (13027, 1, 'O-265', 'TORRE DE DISCOS VIRGENES', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:42', '2020-10-19 11:17:30', 5, 5);
INSERT INTO `materiales` VALUES (29275, 1, 'TOT-100', 'TOTEM METALICO', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:42', '2020-10-19 11:17:30', 5, 5);
INSERT INTO `materiales` VALUES (12564, 1, 'O-168', 'TRABAJO DE ALBAÑILERIA', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:42', '2020-10-19 11:17:30', 5, 5);
INSERT INTO `materiales` VALUES (34124, 1, 'TDP-196', 'TRABAJO DE PLAFON', 794, 'ACABADOS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:42', '2020-10-19 11:17:31', 5, 5);
INSERT INTO `materiales` VALUES (27325, 1, 'TBC-135', 'TRABAJOS DE CANCELERIA', 796, 'CANCELERIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:43', '2020-10-19 11:17:31', 5, 5);
INSERT INTO `materiales` VALUES (28408, 1, 'TDC-185', 'TRABAJOS DE CARPINTERIA', 798, 'CARPINTERIA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:43', '2020-10-19 11:17:31', 5, 5);
INSERT INTO `materiales` VALUES (13546, 1, 'O-362', 'TRABAJOS DE CONSTRUCCION ', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:43', '2020-10-19 11:17:31', 5, 5);
INSERT INTO `materiales` VALUES (28398, 1, 'TDI-174', 'TRABAJOS DE DUCTERERIA, INCL INSTALACION Y REJILLAS', 794, 'ACABADOS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:43', '2020-10-19 11:17:31', 5, 5);
INSERT INTO `materiales` VALUES (34048, 1, 'TDE-150', 'TRABAJOS DE ELECTRICIDAD', 791, 'ELECTRIFICACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:43', '2020-10-19 11:17:31', 5, 5);
INSERT INTO `materiales` VALUES (25178, 1, 'TEA-101', 'TRABAJOS DE ELECTRIFICACION Y ALUMBRADO PUBLICO', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:43', '2020-10-19 11:17:31', 5, 5);
INSERT INTO `materiales` VALUES (20044, 1, 'HTH-20', 'ESCALERA METALICA', 792, 'HERRERIA', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2020-10-19 11:04:43', '2021-02-23 15:54:21', 5, 0);
INSERT INTO `materiales` VALUES (33643, 1, 'TDP-185', 'TRABAJOS DE PINTURA', 797, 'PINTURAS', 'NA', 'NA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:43', '2020-10-19 11:17:31', 5, 5);
INSERT INTO `materiales` VALUES (34051, 1, 'TDP-100', 'TRABAJOS DE PLOMERIA', 783, 'SANITARIA', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:43', '2020-10-19 11:17:32', 5, 5);
INSERT INTO `materiales` VALUES (34042, 1, 'TVR-100', 'TRABAJOS DE TABLAROCA, VIDRIO, Y CARPINTERIA', 794, 'ACABADOS', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:44', '2020-10-19 11:17:32', 5, 5);
INSERT INTO `materiales` VALUES (13624, 1, 'EU-077', 'TRABAJOS REALIZADOS', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:44', '2020-10-19 11:17:32', 5, 5);
INSERT INTO `materiales` VALUES (34146, 1, 'TRV-100', 'TRABAJOS REALIZADOS ( VARIOS )', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:44', '2020-10-19 11:17:32', 5, 5);
INSERT INTO `materiales` VALUES (31320, 1, 'TV-100', 'TRABAJOS VARIOS', 794, 'ACABADOS', 'ACTIVIDAD', 'ACTIVIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:44', '2020-10-19 11:17:32', 5, 5);
INSERT INTO `materiales` VALUES (11807, 1, 'C-036', 'TRAMO MOSQUITERO 6.10 MTS', 796, 'CANCELERIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:44', '2020-10-19 11:17:32', 5, 5);
INSERT INTO `materiales` VALUES (18878, 1, 'TRA-TARJ63', 'TRAMPA  P/TARJA', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:44', '2020-10-19 11:17:32', 5, 5);
INSERT INTO `materiales` VALUES (18941, 1, 'TRAM-03', 'TRAMPA FLEXIBLE  P/LAVABO', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:44', '2020-10-19 11:17:33', 5, 5);
INSERT INTO `materiales` VALUES (13660, 1, 'TR-002', 'TRAMPA P/LAVABO RIGIDA AC INOX 3721 URREA', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:44', '2020-10-19 11:17:33', 5, 5);
INSERT INTO `materiales` VALUES (13501, 1, 'TRMIG01', 'TRAMPA P/MINGITORIO MARCA KOFLEX', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:44', '2020-10-19 11:17:33', 5, 5);
INSERT INTO `materiales` VALUES (11626, 1, 'O-050', 'TRANSFORMADOR', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:44', '2020-10-19 11:17:33', 5, 5);
INSERT INTO `materiales` VALUES (34374, 1, 'TSF-100', 'TRANSFORMADOR 16VCA 40 VA FUSIBLE INTERNO DSC/TV', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:45', '2020-10-19 11:17:33', 5, 5);
INSERT INTO `materiales` VALUES (30727, 1, '1302-100-010', 'TRAPEADOR DE ALGODON SEMIPEÑOLERO', 803, 'EXTRAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:45', '2020-10-19 11:17:33', 5, 5);
INSERT INTO `materiales` VALUES (12251, 1, 'O-117', 'TRASLADO DE DOMINIO', 808, 'OTROS', 'VIVIENDA', 'VIVIENDA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:45', '2020-10-19 11:17:33', 5, 5);
INSERT INTO `materiales` VALUES (23430, 1, 'TA-01', 'TRASLADO DE UNIDAD', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:45', '2020-10-19 11:17:33', 5, 5);
INSERT INTO `materiales` VALUES (11799, 1, 'C-034', 'TRASLAPE TRAMO 6.10M MTS', 796, 'CANCELERIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:45', '2020-10-19 11:17:33', 5, 5);
INSERT INTO `materiales` VALUES (24500, 1, 'U-001', 'TRAZO Y NIVELACION DE TERRENO PARA TRAZO Y REFERENCIAS', 806, 'URBANIZACION', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:45', '2020-10-19 11:17:34', 5, 5);
INSERT INTO `materiales` VALUES (11878, 1, 'O-073', 'TRIPLAY DE BANAK 6mm', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:45', '2020-10-19 11:17:34', 5, 5);
INSERT INTO `materiales` VALUES (11875, 1, 'O-072', 'TRIPLAY DE CAOBILLA 3mm', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:45', '2020-10-19 11:17:34', 5, 5);
INSERT INTO `materiales` VALUES (11148, 1, 'O-024', 'TRUENO DE VENUS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:45', '2020-10-19 11:17:34', 5, 5);
INSERT INTO `materiales` VALUES (26677, 1, 'H-139', 'TUBO 3/4 CPVC', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:45', '2020-10-19 11:17:34', 5, 5);
INSERT INTO `materiales` VALUES (12492, 1, 'H-097', 'TUBO 3/4 IUSA PLUS', 786, 'HIDRAULICA', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:34', 5, 5);
INSERT INTO `materiales` VALUES (36554, 1, 'S-060', 'TUBO A.C. C/COST A 53 C-40 .E -6\"', 786, 'HIDRAULICA', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:34', 5, 5);
INSERT INTO `materiales` VALUES (12678, 1, 'H-111', 'TUBO CLASE PLUS 16 DE 25 MM 3/4', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:34', 5, 5);
INSERT INTO `materiales` VALUES (19550, 1, 'E-128', 'TUBO CONDIUT 1/2', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:35', 5, 5);
INSERT INTO `materiales` VALUES (19575, 1, 'TCD-114', 'TUBO CONDUIT 1 1/4', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:35', 5, 5);
INSERT INTO `materiales` VALUES (33985, 1, 'TUB-100', 'TUBO CONDUIT DE 1/2', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:35', 5, 5);
INSERT INTO `materiales` VALUES (11623, 1, 'H-080', 'TUBO CPVC 1 PULGADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:35', 5, 5);
INSERT INTO `materiales` VALUES (10514, 1, 'H-027', 'TUBO CPVC 1/2\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:35', 5, 5);
INSERT INTO `materiales` VALUES (12964, 1, 'H-113', 'TUBO CPVC 3/4 DE DIAMETRO TRAMO 6 MTS', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:35', 5, 5);
INSERT INTO `materiales` VALUES (12645, 1, 'H-138', 'TUBO CPVC DE 1/2\" DE DIAMETRO 6 MTS', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:35', 5, 5);
INSERT INTO `materiales` VALUES (10793, 1, 'EU-028', 'TUBO DE 1 1/4 SDR-17 DE POLIETILENO DE ALTA DENSIDAD TIPO II, PARED LISA, COLOR NARANJA', 785, 'ELECTRIFICACION URB', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:46', '2020-10-19 11:17:36', 5, 5);
INSERT INTO `materiales` VALUES (10645, 1, 'H-037', 'TUBO DE COBRE 1/2', 786, 'HIDRAULICA', 'TRAMO', 'TRAMO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:36', 5, 5);
INSERT INTO `materiales` VALUES (10633, 1, 'G-009', 'TUBO DE COBRE 3/4\" GAS', 784, 'GAS', 'M2', 'M2', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:36', 5, 5);
INSERT INTO `materiales` VALUES (11088, 1, 'G-026', 'TUBO DE COBRE DE 1\"', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:36', 5, 5);
INSERT INTO `materiales` VALUES (12308, 1, 'H-086', 'TUBO HID S/M 200 MM C/C CL-7', 786, 'HIDRAULICA', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:36', 5, 5);
INSERT INTO `materiales` VALUES (12374, 1, 'O-144', 'TUBO MECANICO DE  1 1/2 CED 40', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:37', 5, 5);
INSERT INTO `materiales` VALUES (10599, 1, 'G-006', 'TUBO MULTICAPA MARCA DURMAN 3/8\"', 784, 'GAS', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:37', 5, 5);
INSERT INTO `materiales` VALUES (9638, 1, 'G-001', 'TUBO MULTICAPA MARCA DURMAN PE-AL-PE DE 1/2\" DIAMETRO', 784, 'GAS', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:37', 5, 5);
INSERT INTO `materiales` VALUES (20366, 1, 'EU-050', 'TUBO PEAD \"ADS\" N-12 8\" C/CAMP. Y LIGA SERIE 32', 806, 'URBANIZACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:37', 5, 5);
INSERT INTO `materiales` VALUES (10358, 1, 'EU-009', 'TUBO PEAD 2\" CORRUGADO ROJO (50MM)X6.10 MTS.', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:37', 5, 5);
INSERT INTO `materiales` VALUES (10362, 1, 'EU-010', 'TUBO PEAD 3\" CORRUGADO ROJO (75MM)X6.10 MTS.', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:37', 5, 5);
INSERT INTO `materiales` VALUES (11361, 1, 'S-038', 'TUBO PVC 3\"', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:37', 5, 5);
INSERT INTO `materiales` VALUES (10250, 1, 'E-032', 'TUBO PVC CONDUIT PESADO DE 1 1/4\" TRAMO DE 3 MTS.', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:47', '2020-10-19 11:17:37', 5, 5);
INSERT INTO `materiales` VALUES (13240, 1, 'H-118', 'TUBO PVC DE 1/2 ', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:38', 5, 5);
INSERT INTO `materiales` VALUES (9730, 1, 'S-009', 'TUBO PVC DE 2\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:38', 5, 5);
INSERT INTO `materiales` VALUES (9754, 1, 'S-021', 'TUBO PVC DE 3\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:38', 5, 5);
INSERT INTO `materiales` VALUES (9698, 1, 'S-001', 'TUBO PVC DE 4\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:38', 5, 5);
INSERT INTO `materiales` VALUES (35589, 1, 'TUB-114', 'TUBO PVC HID CED 40 1 1/4\" MTO.', 794, 'ACABADOS', 'MTO', 'MTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:38', 5, 5);
INSERT INTO `materiales` VALUES (34905, 1, 'TUB-C40', 'TUBO PVC HID CED 40 1\" MTO.', 783, 'SANITARIA', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:38', 5, 5);
INSERT INTO `materiales` VALUES (35568, 1, 'TUB-C42', 'TUBO PVC HID CED 40 2\" MTO.', 794, 'ACABADOS', 'MTO', 'MTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:38', 5, 5);
INSERT INTO `materiales` VALUES (35929, 1, 'TPH-150', 'TUBO PVC HID. ING. 6\" RD-26 C/C Y LIGA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:38', 5, 5);
INSERT INTO `materiales` VALUES (10486, 1, 'H-020', 'TUBO PVC HIDRAULICO DE 1/2\" DE DIAMETRO X 6 MTS DE LARGO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:39', 5, 5);
INSERT INTO `materiales` VALUES (9650, 1, 'H-001', 'TUBOPLUS DE 1/2\" DE DIAMETRO 4 MTS.', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:39', 5, 5);
INSERT INTO `materiales` VALUES (11060, 1, 'G-019', 'TUERCA 1/4\"', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:48', '2020-10-19 11:17:39', 5, 5);
INSERT INTO `materiales` VALUES (12465, 1, 'URB-005', 'TUERCA HEX. Y ROND. 15.9-177.8', 806, 'URBANIZACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:49', '2020-10-19 11:17:39', 5, 5);
INSERT INTO `materiales` VALUES (13324, 1, 'H-121', 'TUERCA UNION 1/2 P/TUBO PLUS 1/2', 786, 'HIDRAULICA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:49', '2020-10-19 11:17:39', 5, 5);
INSERT INTO `materiales` VALUES (12597, 1, 'H-106', 'TUERCA UNION 1/2\" IUSAPLUS', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:49', '2020-10-19 11:17:39', 5, 5);
INSERT INTO `materiales` VALUES (12594, 1, 'H-105', 'TUERCA UNION 3/4\" CPVC', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:49', '2020-10-19 11:17:39', 5, 5);
INSERT INTO `materiales` VALUES (12087, 1, 'H-082', 'TUERCA UNION CPVC 1/2 PULGADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:49', '2020-10-19 11:17:40', 5, 5);
INSERT INTO `materiales` VALUES (11608, 1, 'H-075', 'TUERCA UNION CPVC DE 1 PULGADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:49', '2020-10-19 11:17:40', 5, 5);
INSERT INTO `materiales` VALUES (35595, 1, 'TUE-114', 'TUERCA UNION PVC HID CED 40 CEM DE 1-1/4', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:49', '2020-10-19 11:17:40', 5, 5);
INSERT INTO `materiales` VALUES (35598, 1, 'TUE-121', 'TUERCA UNION PVC HID CED 40 CEM DE 2', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:49', '2020-10-19 11:17:40', 5, 5);
INSERT INTO `materiales` VALUES (11072, 1, 'G-022', 'TUERCA UNION SOLDABLE COBRE 1\"', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:49', '2020-10-19 11:17:40', 5, 5);
INSERT INTO `materiales` VALUES (11076, 1, 'G-023', 'TUERCA UNION SOLDABLE DE COBRE 1/2\"', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:49', '2020-10-19 11:17:40', 5, 5);
INSERT INTO `materiales` VALUES (25013, 1, 'TA-140', 'Tapete Aiyan 180x120 - Negro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:50', '2020-10-19 11:17:40', 5, 5);
INSERT INTO `materiales` VALUES (24938, 1, 'TMA-116', 'Tapete Mantic 120x180 - Azul', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:50', '2020-10-19 11:17:41', 5, 5);
INSERT INTO `materiales` VALUES (25037, 1, 'TM-149', 'Tapete Mané 160x230 - Gris', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:50', '2020-10-19 11:17:41', 5, 5);
INSERT INTO `materiales` VALUES (24989, 1, 'TM-131', 'Tapete Meyax 160x230 - Gris', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:50', '2020-10-19 11:17:41', 5, 5);
INSERT INTO `materiales` VALUES (24935, 1, 'TM-114', 'Tapete Moki 180x120 - Negro', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:50', '2020-10-19 11:17:41', 5, 5);
INSERT INTO `materiales` VALUES (25090, 1, 'TM-153', 'Tapete Moki 180x120 - Negro 1', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:50', '2020-10-19 11:17:41', 5, 5);
INSERT INTO `materiales` VALUES (24980, 1, 'TRC-128', 'Tapete redondo Chimeca grande 200 cm - Natural', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:50', '2020-10-19 11:17:41', 5, 5);
INSERT INTO `materiales` VALUES (9850, 1, 'AC-001', 'Tinaco tricapa BEIGE 0450lts C/ACCS S/FILTRO ', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:50', '2020-10-19 11:17:41', 5, 5);
INSERT INTO `materiales` VALUES (13111, 1, '0-217', 'UNIFORME LIMPIEZA', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:50', '2020-10-19 11:17:42', 5, 5);
INSERT INTO `materiales` VALUES (11425, 1, 'O-036', 'UNIFORMES ', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:50', '2020-10-19 11:17:42', 5, 5);
INSERT INTO `materiales` VALUES (36656, 1, 'UA1-100', 'URBANIZACION ARBOLEDA  ETAPA 1', 806, 'URBANIZACION', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:51', '2020-10-19 11:17:42', 5, 5);
INSERT INTO `materiales` VALUES (36659, 1, 'UA2-100', 'URBANIZACION ARBOLEDA  ETAPA 2', 806, 'URBANIZACION', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:51', '2020-10-19 11:17:42', 5, 5);
INSERT INTO `materiales` VALUES (36514, 1, 'UBA-03', 'URBANIZACION ARBOLEDA  ETAPA 3', 806, 'URBANIZACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:51', '2020-10-19 11:17:42', 5, 5);
INSERT INTO `materiales` VALUES (12561, 1, 'URB-006', 'URBANIZACION DE TERRENO ', 806, 'URBANIZACION', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:51', '2020-10-19 11:17:42', 5, 5);
INSERT INTO `materiales` VALUES (34854, 1, 'UBM-006', 'URBANIZACION MISIONES ETAPA 6', 806, 'URBANIZACION', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:51', '2020-10-19 11:17:42', 5, 5);
INSERT INTO `materiales` VALUES (12103, 1, 'O-109', 'VALBULA DE LLENADO DE 1/2', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:51', '2020-10-19 11:17:42', 5, 5);
INSERT INTO `materiales` VALUES (36330, 1, 'VLD-100', 'VALE DE REPORTES - POST VENTA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:51', '2020-10-19 11:17:42', 5, 5);
INSERT INTO `materiales` VALUES (12934, 1, 'O-250', 'VALES DE MATERIALES FOLIADOS', 808, 'OTROS', 'PZAS', 'PZAS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:51', '2020-10-19 11:17:43', 5, 5);
INSERT INTO `materiales` VALUES (35853, 1, 'VRI-200', 'VALLA ROTULADAEN VINIL IMPRESO ( VARIAS MEDIDAS )', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:52', '2020-10-19 11:17:43', 5, 5);
INSERT INTO `materiales` VALUES (35941, 1, 'VLV-200', 'VALVULA 2\" ADMISION Y EXPULSION DE AIRE 125 psi COMBINADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:52', '2020-10-19 11:17:43', 5, 5);
INSERT INTO `materiales` VALUES (34409, 1, 'VVR-134', 'VALVULA CHECK DE 3/4 ROSCABLE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:52', '2020-10-19 11:17:43', 5, 5);
INSERT INTO `materiales` VALUES (10458, 1, 'H-012', 'VALVULA CHECK RESORTE DE 1/2\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:52', '2020-10-19 11:17:43', 5, 5);
INSERT INTO `materiales` VALUES (35944, 1, 'VLV-600', 'VALVULA COMPUERTA 6\" VASTAGO FIJO C/VOLANTE', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:52', '2020-10-19 11:17:43', 5, 5);
INSERT INTO `materiales` VALUES (9854, 1, 'AC-002', 'VALVULA DE COLUMPIO MARCA DICA', 800, 'ACCESORIOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:52', '2020-10-19 11:17:43', 5, 5);
INSERT INTO `materiales` VALUES (10665, 1, 'G-013', 'VALVULA DE LLENADO DE GAS 3/4 CON TAPA Y SUJETADOR', 784, 'GAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:52', '2020-10-19 11:17:43', 5, 5);
INSERT INTO `materiales` VALUES (34406, 1, 'VVE-314', 'VALVULA ESFERA DE CPVC DE 3/4', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:52', '2020-10-19 11:17:44', 5, 5);
INSERT INTO `materiales` VALUES (35610, 1, 'VAL-114', 'VALVULA ESFERA PVC HID CED 40 CEM  DE 1 1/4', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:52', '2020-10-19 11:17:44', 5, 5);
INSERT INTO `materiales` VALUES (12380, 1, 'H-087', 'VALVULA MARIPOSA DE PALANCA  AL 8\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:52', '2020-10-19 11:17:44', 5, 5);
INSERT INTO `materiales` VALUES (31636, 1, 'VLF-100', 'VALVULA PARA FLOTADOR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:53', '2020-10-19 11:17:44', 5, 5);
INSERT INTO `materiales` VALUES (35626, 1, 'VAL-150', 'VALVULA SOLENOIDE 1 1/2\" ROSCABLE 100DV', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:53', '2020-10-19 11:17:44', 5, 5);
INSERT INTO `materiales` VALUES (34943, 1, 'VAL-100', 'VALVULA SOLENOIDE 1\" ROSCABLE 100DV', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:53', '2020-10-19 11:17:44', 5, 5);
INSERT INTO `materiales` VALUES (11970, 1, 'ACE-023', 'VARILLA 3/8', 809, 'ACERO', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:53', '2020-10-19 11:17:44', 5, 5);
INSERT INTO `materiales` VALUES (10350, 1, 'EU-007', 'VARILLA DE TIERRA 5/8\"X3 MTS', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:53', '2020-10-19 11:17:44', 5, 5);
INSERT INTO `materiales` VALUES (10222, 1, 'E-025', 'VARILLA DE TIERRA DE 1/2\"X1.50 MTS.', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:53', '2020-10-19 11:17:45', 5, 5);
INSERT INTO `materiales` VALUES (12245, 1, 'O-115', 'VASTAGO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:45', 5, 5);
INSERT INTO `materiales` VALUES (21597, 1, '', 'VEHICULO PROMOCIONAL', 818, 'VENTAS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:45', 5, 5);
INSERT INTO `materiales` VALUES (22439, 1, '', 'VEHICULO USADO TOYOTA SIENNA LTD COLOR BLANCO APERLADO CHASSIS 5TDYZ3DC5HS767107 MOTOR: 2GR-7935116', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:45', 5, 5);
INSERT INTO `materiales` VALUES (30878, 1, 'VEL-100', 'VELCRO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:45', 5, 5);
INSERT INTO `materiales` VALUES (12003, 1, '001', 'VENTA CASA HABITACION', 818, 'VENTAS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:45', 5, 5);
INSERT INTO `materiales` VALUES (13888, 1, 'O-342', 'VENTA E INSTALACION DE PERSIANAS ENROLLABLES', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:45', 5, 5);
INSERT INTO `materiales` VALUES (19236, 1, 'CA-054', 'VENTANA EUCOPLAC .85 X 2.13', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:46', 5, 5);
INSERT INTO `materiales` VALUES (19233, 1, 'CA-051', 'VENTANA EUCOPLAC MED. .70 X 2.13', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:46', 5, 5);
INSERT INTO `materiales` VALUES (12651, 1, 'CA-039', 'VENTANA FIJO MEDIDA .40 x 1.68, ALUMINIO BLANCO PERFIL DE 1 1/2\". CRISTAL DE 3MM. ACCESO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:46', 5, 5);
INSERT INTO `materiales` VALUES (11100, 1, 'CA-024', 'VENTANA FIJO MEDIDA .715X1.20 ALUMINIO BLANCO PERFIL DE 1 1/2\" CRISTAL DE 3MM PASILLO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:46', 5, 5);
INSERT INTO `materiales` VALUES (10018, 1, 'CA-015', 'VENTANA FIJO MEDIDA .74X1.20 ALUMINIO BLANCO PERFIL DE 1 1/2\" CRISTAL DE 3 MM PASILLO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:54', '2020-10-19 11:17:46', 5, 5);
INSERT INTO `materiales` VALUES (12193, 1, 'HE-012', 'VENTANA MED .50X.50 CM, ALUMINIO BLANCO PERFIL 1 1/2\".CRISTAL TAPIZ 3MM BAÑO', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:55', '2020-10-19 11:17:46', 5, 5);
INSERT INTO `materiales` VALUES (12201, 1, 'HE-014', 'VENTANA MED .67X2.10, FIJO ALUMINIO BLANCO PERFIL 1 1/2\" CRISTAL 3MM', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:55', '2020-10-19 11:17:47', 5, 5);
INSERT INTO `materiales` VALUES (12197, 1, 'HE-013', 'VENTANA MED 1.00X 1.00, ALUMINIO BLANCO PERFIL 1 1/2\" CRISTAL 3MM', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:55', '2020-10-19 11:17:47', 5, 5);
INSERT INTO `materiales` VALUES (12205, 1, 'HE-015', 'VENTANA MED 1.20X1.40, ALUMINI0 BLANCO PERFIL 1 1/2\" CRISTAL 3MM', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:55', '2020-10-19 11:17:47', 5, 5);
INSERT INTO `materiales` VALUES (12209, 1, 'HE-016', 'VENTANA MED 1.20X1.78 ALUMINIO BLANCO PERFIL 1 1/2\" CRISTAL 3MM', 792, 'HERRERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:55', '2020-10-19 11:17:47', 5, 5);
INSERT INTO `materiales` VALUES (19200, 1, 'CA-51', 'VENTANA MED. .48 X 1.20 ALUMINIO BLANCO 1 1/2\" cristal mm (ACCESO)', 794, 'ACABADOS', '', '', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:55', '2020-10-19 11:17:48', 5, 5);
INSERT INTO `materiales` VALUES (19197, 1, 'CA-50', 'VENTANA MED. 1.22 X 1.40 ALUMINIO 1 1/2\" cristal mm (RECAMARA)', 794, 'ACABADOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:55', '2020-10-19 11:17:48', 5, 5);
INSERT INTO `materiales` VALUES (9990, 1, 'CA-008', 'VENTANA MEDIDA .40X.40 CMS. ALUMINIO BLANCO PERFIL DE 1 1/2\" CRISTAL TAPIZ 3 MM. BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:55', '2020-10-19 11:17:48', 5, 5);
INSERT INTO `materiales` VALUES (31361, 1, 'CA-225', 'VENTANA MEDIDA .48X.30 CMS, ALUMINIO G2  1 1/2\" CRISTAL TAPIZ 3MM BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:56', '2020-10-19 11:17:48', 5, 5);
INSERT INTO `materiales` VALUES (11294, 1, 'CA-025', 'VENTANA MEDIDA .60X.40 CMS, ALUMINIO BLANCO PERFIL 1 1/2\" CRISTAL TAPIZ 3MM BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:56', '2020-10-19 11:17:48', 5, 5);
INSERT INTO `materiales` VALUES (10002, 1, 'CA-011', 'VENTANA MEDIDA .60X.60 FIJO ALUMINIO BLANCO PERFIL DE 1 1/2\" CRISTAL 3 MM ESCALERA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:56', '2020-10-19 11:17:48', 5, 5);
INSERT INTO `materiales` VALUES (10006, 1, 'CA-012', 'VENTANA MEDIDA .90X1.18 ALUMINIO BLANCO PERFIL DE 1 1/2\" CRISTAL3 MM ALCOBA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:56', '2020-10-19 11:17:48', 5, 5);
INSERT INTO `materiales` VALUES (12654, 1, 'CA-038', 'VENTANA MEDIDA 0.92 x 1.00, ALUMINIO BLANCO PERFIL DE 1 1/2\". CRISTAL DE 3MM COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:56', '2020-10-19 11:17:49', 5, 5);
INSERT INTO `materiales` VALUES (13525, 1, 'CA-045', 'VENTANA MEDIDA 0.98/1.20 ALUMINIO BLANCO PERFIL DE 1 1/2 CRISTAL DE 3MM RECAMARAS Y COMEDOR', 794, 'ACABADOS', 'PZ', 'PZ', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:56', '2020-10-19 11:17:49', 5, 5);
INSERT INTO `materiales` VALUES (10026, 1, 'CA-017', 'VENTANA MEDIDA 1.00X1.20 ALUMINIO BLANCO PERFIL DE 1 1/2\" CRISTAL DE 3 MM SALA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:49', 5, 5);
INSERT INTO `materiales` VALUES (11298, 1, 'CA-026', 'VENTANA MEDIDA 1.08X1.00 ALUMINIO BLANCO PERFIL 1 1/2\" CRISTAL 3MM', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:49', 5, 5);
INSERT INTO `materiales` VALUES (9998, 1, 'CA-010', 'VENTANA MEDIDA 1.10X1.18 ALUMINIO BLANCO PERFIL DE 1 1/2\" CRISTAL 3 MM SALA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:49', 5, 5);
INSERT INTO `materiales` VALUES (12648, 1, 'CA-037', 'VENTANA MEDIDA 1.20 x 1.20, ALUMINIO BLANCO PERFIL DE 1 1/2\". CRISTAL DE 3MM RECAMARAS Y COMEDOR', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:49', 5, 5);
INSERT INTO `materiales` VALUES (10014, 1, 'CA-014', 'VENTANA MEDIDA 1.20X1.40 ALUMINIO BLANCO PERFIL DE 1 1/2\" CRISTAL DE 3 MM RECAMARA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:49', 5, 5);
INSERT INTO `materiales` VALUES (9994, 1, 'CA-009', 'VENTANA MEDIDA DE .85X1.18 ALUMINIO BLANCO PERFIL DE 1 1/2\" CRISTAL 3 MM RECAMARA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:50', 5, 5);
INSERT INTO `materiales` VALUES (10022, 1, 'CA-016', 'VENTANA MEDIDA DE 1.00X1.00 ALUMINIO BLANCO PERFIL DE 1 1/2\" CRISTAL DE 3 MM COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:50', 5, 5);
INSERT INTO `materiales` VALUES (31981, 1, 'TEM-G2', 'VENTANA Med. .40 x .30  Aluminio G2 Perfil 1 1/2¨.  Cristal 3 mm. 1/2  BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:50', 5, 5);
INSERT INTO `materiales` VALUES (30500, 1, 'CG2-203', 'VENTANA Med. .56 x .40  Aluminio G2 Perfil 1 1/2¨.SIN PROTECCIONES  Cristal 3 mm.  BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:50', 5, 5);
INSERT INTO `materiales` VALUES (30484, 1, 'CG2-103', 'VENTANA Med. .58 x .40  Aluminio G2 Perfil 1 1/2¨.SIN PROTECCIONES  Cristal 3 mm.  BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:50', 5, 5);
INSERT INTO `materiales` VALUES (26619, 1, 'CG2-03', 'VENTANA Med. .58 x .50  Aluminio G2 Perfil 1 1/2¨.SIN PROTECCIONES  Cristal 3 mm.  BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:57', '2020-10-19 11:17:50', 5, 5);
INSERT INTO `materiales` VALUES (31917, 1, 'VEN-6', 'VENTANA Med. .60 x .40  Aluminio G2 Perfil 1 1/2¨  Cristal 3 mm.  BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:58', '2020-10-19 11:17:50', 5, 5);
INSERT INTO `materiales` VALUES (31884, 1, 'BON-5', 'VENTANA Med. .60 x .40  Aluminio G2 Perfil 1 1/2¨.  Cristal 3 mm.  BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:58', '2020-10-19 11:17:51', 5, 5);
INSERT INTO `materiales` VALUES (31992, 1, 'TEM-G5', 'VENTANA Med. .60 x .40  Aluminio G2 Perfil 1 1/2¨.  Cristal 3 mm.  BAÑO TEMPLANZA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:58', '2020-10-19 11:17:51', 5, 5);
INSERT INTO `materiales` VALUES (32030, 1, 'MES-5', 'VENTANA Med. .60 x .40  Aluminio G2 Perfil 1 1/2¨.  Cristal 3 mm.  BAÑO mesura', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:58', '2020-10-19 11:17:51', 5, 5);
INSERT INTO `materiales` VALUES (33322, 1, 'CON-4', 'VENTANA Med. .60 x .40  Aluminio G2 Perfil 1 1/2¨.SIN PROTECCIONES  Cristal 3 mm.   BAÑO', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:58', '2020-10-19 11:17:51', 5, 5);
INSERT INTO `materiales` VALUES (26684, 1, 'CG2-05', 'VENTANA Med. .78 x 1.00  Aluminio G2 Perfil 1 1/2¨.SIN PROTECCIONES  Cristal 3 mm.  COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:58', '2020-10-19 11:17:51', 5, 5);
INSERT INTO `materiales` VALUES (30497, 1, 'CG2-105', 'VENTANA Med. .80 x 1.00  Aluminio G2 Perfil 1 1/2¨.SIN PROTECCIONES  Cristal 3 mm.  COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:58', '2020-10-19 11:17:51', 5, 5);
INSERT INTO `materiales` VALUES (33333, 1, 'CON-7', 'VENTANA Med. .80 x 1.00  Aluminio G2 Perfil 1 1/2¨.SIN PROTECCIONES  Cristal 3 mm.  COCINA CON', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:58', '2020-10-19 11:17:52', 5, 5);
INSERT INTO `materiales` VALUES (31875, 1, 'BON-2', 'VENTANA Med. .82 x 1.00  Aluminio G2 Perfil 1 1/2¨.CORREDIZA  Cristal 3 mm.  COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2020-10-19 11:04:58', '2021-02-23 15:55:06', 5, 0);
INSERT INTO `materiales` VALUES (32022, 1, 'MES-3', 'VENTANA Med. .90 x .90  Aluminio G2 CORREDIZA Perfil 1 1/2¨.  Cristal 3 mm.  COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:58', '2020-10-19 11:17:52', 5, 5);
INSERT INTO `materiales` VALUES (26613, 1, 'CG2-02', 'VENTANA Med. .97 x1 .20 cms, Aluminio EN G2  SIN GUILLOTINA SIN PROTECCIONES  Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC.2', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:59', '2020-10-19 11:17:52', 5, 5);
INSERT INTO `materiales` VALUES (31881, 1, 'BON-4', 'VENTANA Med. .97 x1 .20 cms, Aluminio EN G2 CORREDIZA  Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC. 2', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:59', '2020-10-19 11:17:52', 5, 5);
INSERT INTO `materiales` VALUES (31923, 1, 'VEN-3', 'VENTANA Med. 1.00 x 1.00  Aluminio G2  CORREDIZA  Perfil 1 1/2¨. Cristal 3 mm.  COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:59', '2020-10-19 11:17:52', 5, 5);
INSERT INTO `materiales` VALUES (26625, 1, 'CG2-07', 'VENTANA Med. 1.00 x 1.00  Aluminio G2 SIN PROTECCIONES  Perfil 1 1/2¨. Cristal 3 mm.  COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:59', '2020-10-19 11:17:52', 5, 5);
INSERT INTO `materiales` VALUES (31364, 1, 'CG2-114', 'VENTANA Med. 1.10 x1 .20 cms, Aluminio EN G2  CON GUILLOTINA SIN PROTECCIONES  Perfil 1 1/2¨. Cristal Tapiz  3 mm.  FRENTE', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:59', '2020-10-19 11:17:52', 5, 5);
INSERT INTO `materiales` VALUES (27702, 1, 'CG2-04', 'VENTANA Med. 1.19 x .1.20  Aluminio G2 Perfil 1 1/2¨.SIN PROTECCIONES  Cristal 3 mm.  SALA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:59', '2020-10-19 11:17:53', 5, 5);
INSERT INTO `materiales` VALUES (26616, 1, 'CG2-01', 'VENTANA Med. 1.19 x1 .40 cms, Aluminio EN G2  CON GUILLOTINA SIN PROTECCIONES  Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC. PPAL.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:59', '2020-10-19 11:17:53', 5, 5);
INSERT INTO `materiales` VALUES (31984, 1, 'TEM-G3', 'VENTANA Med. 1.20 x1 .10 cms, Aluminio EN G2  GUILLOTINA   Perfil 1 1/2¨. Cristal Tapiz  3 mm. COCINA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:59', '2020-10-19 11:17:53', 5, 5);
INSERT INTO `materiales` VALUES (31978, 1, 'TEM-G1', 'VENTANA Med. 1.20 x1 .20 cms, Aluminio EN G2  CORREDIZA  Perfil 1 1/2¨. Cristal Tapiz  3 mm.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:59', '2020-10-19 11:17:53', 5, 5);
INSERT INTO `materiales` VALUES (31872, 1, 'BON-1', 'VENTANA Med. 1.20 x1 .20 cms, Aluminio EN G2  CORREDIZA -   Perfil 1 1/2¨. Cristal Tapiz  3 mm. SALA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:04:59', '2020-10-19 11:17:53', 5, 5);
INSERT INTO `materiales` VALUES (31929, 1, 'VEN-5', 'VENTANA Med. 1.20 x1 .20 cms, Aluminio EN G2  SIN GUILLOTINA   Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC.2', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:53', 5, 5);
INSERT INTO `materiales` VALUES (30481, 1, 'CG2-102', 'VENTANA Med. 1.20 x1 .20 cms, Aluminio EN G2  SIN GUILLOTINA SIN PROTECCIONES  Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:53', 5, 5);
INSERT INTO `materiales` VALUES (33319, 1, 'CON-3', 'VENTANA Med. 1.20 x1 .20 cms, Aluminio EN G2  SIN GUILLOTINA SIN PROTECCIONES  Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC.2', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:54', 5, 5);
INSERT INTO `materiales` VALUES (31914, 1, 'VEN-1', 'VENTANA Med. 1.20 x1 .40 cms, Aluminio EN G2  CON GUILLOTINA   Perfil 1 1/2¨. Cristal Tapiz  3 mm.  FRENTE SALA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:54', 5, 5);
INSERT INTO `materiales` VALUES (30490, 1, 'CG2-104', 'VENTANA Med. 1.20 x1 .40 cms, Aluminio EN G2  CON GUILLOTINA SIN PROTECCIONES  Perfil 1 1/2¨. Cristal Tapiz  3 mm.  FRENTE', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:54', 5, 5);
INSERT INTO `materiales` VALUES (33312, 1, 'CON-1', 'VENTANA Med. 1.20 x1 .40 cms, Aluminio EN G2  CON GUILLOTINA SIN PROTECCIONES  Perfil 1 1/2¨. Cristal Tapiz  3 mm.  SALA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:54', 5, 5);
INSERT INTO `materiales` VALUES (31987, 1, 'TEM-G4', 'VENTANA Med. 1.20 x1 .40 cms, Aluminio EN G2  GUILLOTINA  Perfil 1 1/2¨. Cristal Tapiz  3 mm.  REC 1', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:54', 5, 5);
INSERT INTO `materiales` VALUES (31878, 1, 'BON-3', 'VENTANA Med. 1.20 x1 .40 cms, Aluminio EN G2 CON GUILLOTINA  Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC. 1', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:54', 5, 5);
INSERT INTO `materiales` VALUES (31911, 1, 'VEN-4', 'VENTANA Med. 1.20 x1 .60 cms, Aluminio EN G2  CON GUILLOTINA   Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC. 1', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:54', 5, 5);
INSERT INTO `materiales` VALUES (33316, 1, 'CON-2', 'VENTANA Med. 1.20 x1 .60 cms, Aluminio EN G2  CON GUILLOTINA SIN PROTECCIONES  Perfil 1 1/2¨. Cristal Tapiz  3 mm.', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:54', 5, 5);
INSERT INTO `materiales` VALUES (30487, 1, 'CG2-101', 'VENTANA Med. 1.20 x1 .60 cms, Aluminio EN G2  CON GUILLOTINA SIN PROTECCIONES  Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC. 1', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:55', 5, 5);
INSERT INTO `materiales` VALUES (26631, 1, 'CG2-13', 'VENTANA Med. 1.20 x1 .60 cms, Aluminio EN G2  CON GUILLOTINA SIN PROTECCIONES  Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC. PPAL. Y FRENTE', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:00', '2020-10-19 11:17:55', 5, 5);
INSERT INTO `materiales` VALUES (32025, 1, 'MES-4', 'VENTANA Med. 1.50 x1 .60 cms, Aluminio EN G2  CORREDIZA   Perfil 1 1/2¨. Cristal Tapiz  3 mm. REC 1', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:55', 5, 5);
INSERT INTO `materiales` VALUES (32016, 1, 'MES-1', 'VENTANA Med. 1.50 x1 .60 cms, Aluminio EN G2  PANORAMICA   Perfil 1 1/2¨. Cristal Tapiz  3 mm. ALCOBA', 796, 'CANCELERIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:55', 5, 5);
INSERT INTO `materiales` VALUES (12798, 1, '0-193', 'VERIFICACION DE OBRA', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:55', 5, 5);
INSERT INTO `materiales` VALUES (12726, 1, 'CS-004', 'VERONA ROJA  A:120   L:83    F:42CM', 820, 'CASA MUESTRA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:55', 5, 5);
INSERT INTO `materiales` VALUES (10984, 1, 'V-003', 'VIAJE DE MOVIMIENTO INTERNO', 817, 'VIAJES', 'VIAJE', 'VIAJE', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:55', 5, 5);
INSERT INTO `materiales` VALUES (32345, 1, 'GVR-100', 'VIAJE MIXTO ( GRAVA - ARENA )', 794, 'ACABADOS', 'M3', 'M3', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:56', 5, 5);
INSERT INTO `materiales` VALUES (12952, 1, 'O-222', 'VIATICOS', 808, 'OTROS', 'NO APLICA', 'NO APLICA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:56', 5, 5);
INSERT INTO `materiales` VALUES (25904, 1, 'MV17', 'VIBRADOR A GASOLINA LONCIN 6.5 HP', 25899, 'HERRAMIENTA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:56', 5, 5);
INSERT INTO `materiales` VALUES (11819, 1, 'C-039', 'VIDRIO LAMINADO 1.80 X 2.30', 796, 'CANCELERIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:56', 5, 5);
INSERT INTO `materiales` VALUES (31831, 1, 'VSP-100', 'VIGILANCIA EN SEGURIDAD PRIVADA', 808, 'OTROS', 'UNIDAD', 'UNIDAD', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:56', 5, 5);
INSERT INTO `materiales` VALUES (32869, 1, 'VINP-100', 'VINIL IMPRESO CON VINIL TRANSPARENTE DE PROTECCION PARA TOTEM', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:01', '2020-10-19 11:17:56', 5, 5);
INSERT INTO `materiales` VALUES (31598, 1, 'VIN-100', 'VINIL MATE SOBRE TROVICEL', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:57', 5, 5);
INSERT INTO `materiales` VALUES (12248, 1, 'O-116', 'VINIL RECORTADO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:57', 5, 5);
INSERT INTO `materiales` VALUES (12837, 1, 'PUBLI-009', 'VINILES SEMBRADO', 804, 'PUBLICIDAD', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:57', 5, 5);
INSERT INTO `materiales` VALUES (29994, 1, 'VIO-100', 'VIOLETAS', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:57', 5, 5);
INSERT INTO `materiales` VALUES (30000, 1, 'VIL-101', 'VIOLETAS A', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:57', 5, 5);
INSERT INTO `materiales` VALUES (13072, 1, 'O-306', 'VITRINA MOSTRADOR 32 CAJONES', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:57', 5, 5);
INSERT INTO `materiales` VALUES (9585, 1, 'P-006', 'VITRO ANTIDERRAPANTE GOLD 20 X 20', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:57', 5, 5);
INSERT INTO `materiales` VALUES (13510, 1, 'P-101', 'VITRO ESPEC MARINA 20X20CM', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:57', 5, 5);
INSERT INTO `materiales` VALUES (12870, 1, 'P-030', 'VITRO PISO PALERMO BEIGE 40X40', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:58', 5, 5);
INSERT INTO `materiales` VALUES (10896, 1, 'P-015', 'VITRO SLATE IVORY 60X120 ESTRUCTURADO', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:58', 5, 5);
INSERT INTO `materiales` VALUES (19520, 1, 'P-37', 'VITROMUO ANTIDERRAPANTE OIGIN CAUSE GRIS 33X33', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:02', '2020-10-19 11:17:58', 5, 5);
INSERT INTO `materiales` VALUES (11210, 1, 'P-021', 'VITROMURO DESERT CADIR 20X30CM', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:03', '2020-10-19 11:17:58', 5, 5);
INSERT INTO `materiales` VALUES (9577, 1, 'P-004', 'VITROMURO DESERT DUBAI 20X30CM', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:03', '2020-10-19 11:17:59', 5, 5);
INSERT INTO `materiales` VALUES (19517, 1, 'P-36', 'VITROMURO MOD. GAUDI PLATA CUADRICULADO 33X33', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:03', '2020-10-19 11:17:59', 5, 5);
INSERT INTO `materiales` VALUES (13507, 1, 'P-100', 'VITROPISO  PALERMO BECHS 40X40CM', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:03', '2020-10-19 11:17:59', 5, 5);
INSERT INTO `materiales` VALUES (19514, 1, 'P-35', 'VITROPISO 33 X33 ROMA GRIS 1.55 M2', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:03', '2020-10-19 11:17:59', 5, 5);
INSERT INTO `materiales` VALUES (12189, 1, 'P-023', 'VITROPISO 40 X 40 MODELO PALERMO IVORY 1.60 M2 POR CAJA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:03', '2020-10-19 11:17:59', 5, 5);
INSERT INTO `materiales` VALUES (31771, 1, 'VTR-100', 'VITROPISO 40X40  ROMA GRIS 1.62 M2', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:03', '2020-10-19 11:17:59', 5, 5);
INSERT INTO `materiales` VALUES (11766, 1, 'P-012', 'VITROPISO ANTIDERRAPANTE \"MALIBU\" 20X20 COLOR BEIGE 1.53M2 CAJA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:03', '2020-10-19 11:17:59', 5, 5);
INSERT INTO `materiales` VALUES (12401, 1, 'P-025', 'VITROPISO ANTIDERRAPANTE ESPEC MARINA BEIGE 20X20 PRIMERA', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:04', '2020-10-19 11:18:00', 5, 5);
INSERT INTO `materiales` VALUES (11559, 1, 'P-007', 'VITROPISO ANTIDERRAPANTE METALIC II BRASS 20X20', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:04', '2020-10-19 11:18:00', 5, 5);
INSERT INTO `materiales` VALUES (12389, 1, 'P-024', 'VITROPISO ANTIDERRAPANTE ROMA ARENA 20 X 20 1.53 M2 CAJA', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:04', '2020-10-19 11:18:00', 5, 5);
INSERT INTO `materiales` VALUES (9573, 1, 'P-003', 'VITROPISO DESERT DUBAI 33X33CM ', 795, 'PISOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:04', '2020-10-19 11:18:00', 5, 5);
INSERT INTO `materiales` VALUES (13741, 1, 'P-110', 'VITROPISO PALERMO IVORY 40X40CM ', 794, 'ACABADOS', 'CAJA', 'CAJA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:04', '2020-10-19 11:18:00', 5, 5);
INSERT INTO `materiales` VALUES (13594, 1, 'O-371', 'VIVIENDAS REVISADAS PARA CONTROL DE CALIDAD ', 794, 'ACABADOS', 'N/A', 'N/A', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:04', '2020-10-19 11:18:00', 5, 5);
INSERT INTO `materiales` VALUES (11725, 1, 'PUBLI-004', 'VOLANTES', 804, 'PUBLICIDAD', 'PIEZAS', 'PIEZAS', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:05', '2020-10-19 11:18:00', 5, 5);
INSERT INTO `materiales` VALUES (33528, 1, 'HER-500', 'VOLANTÍN ESTÁNDAR FABRICADO CON TUBO DE 3/4 CED 30, TUBO DE 3 CED 30, LÁMINA ANTIDERRAPANTE CAL 14, PTR 2*2 CAL 14 Y BALERO DE 4\".', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:05', '2020-10-19 11:18:01', 5, 5);
INSERT INTO `materiales` VALUES (32317, 1, 'GEL-100', 'WOW GEL ANTIBACTERIAL', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:05', '2020-10-19 11:18:01', 5, 5);
INSERT INTO `materiales` VALUES (10334, 1, 'EU-003', 'XLP (2+1) CAL 3/0-1/0 600V', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:05', '2020-10-19 11:18:01', 5, 5);
INSERT INTO `materiales` VALUES (10326, 1, 'EU-001', 'XLP (2+1) CLA 6 ALUMINIO', 785, 'ELECTRIFICACION URB', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:05', '2020-10-19 11:18:01', 5, 5);
INSERT INTO `materiales` VALUES (10330, 1, 'EU-002', 'XLP (2+1)CAL 1/0 600V', 785, 'ELECTRIFICACION URB', 'ML', 'ML', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:05', '2020-10-19 11:18:01', 5, 5);
INSERT INTO `materiales` VALUES (12702, 1, 'S-045', 'YEE DE PVC DE 2\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:05', '2020-10-19 11:18:01', 5, 5);
INSERT INTO `materiales` VALUES (31742, 1, 'S-113', 'YEE PVC DE 3\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:05', '2020-10-19 11:18:01', 5, 5);
INSERT INTO `materiales` VALUES (9722, 1, 'S-007', 'YEE PVC DE 4\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:05', '2020-10-19 11:18:02', 5, 5);
INSERT INTO `materiales` VALUES (9726, 1, 'S-008', 'YEE PVC REDUCCION DE 4\" A 2\" DE DIAMETRO', 783, 'SANITARIA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:05', '2020-10-19 11:18:02', 5, 5);
INSERT INTO `materiales` VALUES (9822, 1, 'A-011', 'YESO MARCA IMPERIAL', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:06', '2020-10-19 11:18:02', 5, 5);
INSERT INTO `materiales` VALUES (10817, 1, 'A-040', 'YESO MARCA POLAR', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:06', '2020-10-19 11:18:02', 5, 5);
INSERT INTO `materiales` VALUES (11184, 1, 'A-025', 'YESO POLAR PLUS', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:06', '2020-10-19 11:18:02', 5, 5);
INSERT INTO `materiales` VALUES (19239, 1, 'A-101', 'YESO REGIO', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:06', '2020-10-19 11:18:02', 5, 5);
INSERT INTO `materiales` VALUES (11788, 1, 'A-068', 'YESO SAYRO', 794, 'ACABADOS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:06', '2020-10-19 11:18:02', 5, 5);
INSERT INTO `materiales` VALUES (30831, 1, 'ZAP-100', 'ZAPAPICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:06', '2020-10-19 11:18:02', 5, 5);
INSERT INTO `materiales` VALUES (10338, 1, 'EU-004', 'ZAPATA Y MANGA CALIBRE 6', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:06', '2020-10-19 11:18:03', 5, 5);
INSERT INTO `materiales` VALUES (10342, 1, 'EU-005', 'ZAPATA Y MANGA TERMOCONTRACTIL CALIBRE 1/0', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:06', '2020-10-19 11:18:03', 5, 5);
INSERT INTO `materiales` VALUES (10346, 1, 'EU-006', 'ZAPATA Y MANGA TERMOCONTRACTIL CALIBRE 3/0', 785, 'ELECTRIFICACION URB', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:06', '2020-10-19 11:18:03', 5, 5);
INSERT INTO `materiales` VALUES (11226, 1, 'E-057', 'ZAPATAS Y MANGAS CALIBRE 1-0', 791, 'ELECTRIFICACION', 'METRO', 'METRO', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:06', '2020-10-19 11:18:03', 5, 5);
INSERT INTO `materiales` VALUES (13351, 1, 'IN-03', 'ZONA 20 KM/HR', 822, 'INFRAESTRUCTURA', 'PZA', 'PZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:07', '2020-10-19 11:18:03', 5, 5);
INSERT INTO `materiales` VALUES (10190, 1, 'E-017', 'ZUMBADOR MARCA SCUDETTO COLOR  BLANCO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:07', '2020-10-19 11:18:03', 5, 5);
INSERT INTO `materiales` VALUES (33225, 1, 'FAB-100', 'fabricación de flecha con aumento para valla', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO    ', '2020-10-19 11:05:07', '2020-10-19 11:18:03', 5, 5);
INSERT INTO `materiales` VALUES (39215, 1, '02-2766034.020', '02 TINA SEDONA LOFT FREESTANDING BLANCO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:53:59', '2021-02-23 15:53:59', 0, 0);
INSERT INTO `materiales` VALUES (39209, 1, '150-S93005', '150 S93005 GRIFO P/TINA ROMANA A PISO CR', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:53:59', '2021-02-23 15:53:59', 0, 0);
INSERT INTO `materiales` VALUES (39212, 1, '150-TS50100', '150 TS50100 SISTEMA MONTA. P/TINA ROMANA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:00', '2021-02-23 15:54:00', 0, 0);
INSERT INTO `materiales` VALUES (40440, 1, '24-TD', '24-TD MEZCLADORA PARA  LAVABO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:00', '2021-02-23 15:54:00', 0, 0);
INSERT INTO `materiales` VALUES (37918, 1, 'ABZ-258', 'ABRAZADERA UNICANAL HW Y EMT 1 25mm ANCLO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:00', '2021-02-23 15:54:00', 0, 0);
INSERT INTO `materiales` VALUES (41962, 1, 'ACCE-73', 'ACCESORIOS  P/POSTE REMATE 73 MM', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:00', '2021-02-23 15:54:00', 0, 0);
INSERT INTO `materiales` VALUES (38404, 1, 'M08', 'AD MATERIAL Y MANO DE OBRA RET FG', 15165, 'MATERIAL Y MANO DE OBRA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:01', '2021-02-23 15:54:01', 0, 0);
INSERT INTO `materiales` VALUES (41947, 1, 'ALAMP-02', 'ALAMBRE DE PUAS CAL. 16 GALV.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:01', '2021-02-23 15:54:01', 0, 0);
INSERT INTO `materiales` VALUES (38195, 1, '', 'ALINEACION', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:01', '2021-02-23 15:54:01', 0, 0);
INSERT INTO `materiales` VALUES (39777, 1, 'E-2003', 'APAGADOR ESCALERA 3 VIAS 16 AMP. 127-277V BLANCO MCA. MODUS PRO', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:02', '2021-02-23 15:54:02', 0, 0);
INSERT INTO `materiales` VALUES (39774, 1, 'E-2001', 'APAGADOR SENCILLO 16 AMP. 127-277 BLANCO MCA. MODUS PRO 10', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:02', '2021-02-23 15:54:02', 0, 0);
INSERT INTO `materiales` VALUES (40460, 1, 'APAG-19', 'APAGADOR SENCILLO 195908 MX BTICINO', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:02', '2021-02-23 15:54:02', 0, 0);
INSERT INTO `materiales` VALUES (41478, 1, 'ENCI-02', 'ARBOL ENCINO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:02', '2021-02-23 15:54:02', 0, 0);
INSERT INTO `materiales` VALUES (41472, 1, 'ARBMEZ-01', 'ARBOL MEZQUITE', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:02', '2021-02-23 15:54:02', 0, 0);
INSERT INTO `materiales` VALUES (41475, 1, 'ARBRET-02', 'ARBOL RETAMA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:02', '2021-02-23 15:54:02', 0, 0);
INSERT INTO `materiales` VALUES (41061, 1, 'ATOM-001', 'ATOMIZADOR', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:03', '2021-02-23 15:54:03', 0, 0);
INSERT INTO `materiales` VALUES (40826, 1, 'AVA-05', 'AVALUO PERICIAL', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:03', '2021-02-23 15:54:03', 0, 0);
INSERT INTO `materiales` VALUES (39346, 1, 'GM-7011', 'BACKHAUL ENLACES PUNTO A  PUNTO POWER BEAM AIRMA X M5 HASTA 150 MBPS', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:03', '2021-02-23 15:54:03', 0, 0);
INSERT INTO `materiales` VALUES (38779, 1, 'BAN-200', 'BANQUETA  DE CONCRETO PREMEZCLADO FC=150kg/cm2, T.M.A. 3/4\",  DE 10cm., INCLUYE: CIMBRA EN FRONTERAS, COLADO, VIBRADO,   ACABADO COMUN A PLANA Y/O CON BOCHA DE PELO INCLUYE:MATERIALES PUESTOS E', 806, 'URBANIZACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:04', '2021-02-23 15:54:04', 0, 0);
INSERT INTO `materiales` VALUES (39352, 1, 'GM-1601', 'BARRA DE 8 CONTACTOS HORIZONTALES DE 19\"', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:04', '2021-02-23 15:54:04', 0, 0);
INSERT INTO `materiales` VALUES (41944, 1, 'BARR-38', 'BARRA SUPERIOR DE 38 MM CAL. 20 GALV.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:04', '2021-02-23 15:54:04', 0, 0);
INSERT INTO `materiales` VALUES (41515, 1, 'BARR-02', 'BARRERA DE CONTENCION DE PLASTICO COLOR NARANJA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:04', '2021-02-23 15:54:04', 0, 0);
INSERT INTO `materiales` VALUES (37695, 1, 'BAR-100', 'BARRIDO DE PAVIMENTO CON BARREDORA MECANICA INC. SUMINISTRO DE AGUA PARA EVITAR LEVANTAMIENTO DE POLVOS', 806, 'URBANIZACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:04', '2021-02-23 15:54:04', 0, 0);
INSERT INTO `materiales` VALUES (38275, 1, 'BSR-100', 'BASTAGOS PARA REGADERA MCA. RUGO', 786, 'HIDRAULICA', 'JUEGO', 'JUEGO', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:04', '2021-02-23 15:54:04', 0, 0);
INSERT INTO `materiales` VALUES (39050, 1, 'BCA-401', 'BLANCO AMANECER DE 40X1\"', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:05', '2021-02-23 15:54:05', 0, 0);
INSERT INTO `materiales` VALUES (39081, 1, 'BOL-709', 'BOLSA NATURAL 70X90 KG KILEADA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:05', '2021-02-23 15:54:05', 0, 0);
INSERT INTO `materiales` VALUES (41308, 1, 'BOMPER-01', 'BOMBA PERIFERICA', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:05', '2021-02-23 15:54:05', 0, 0);
INSERT INTO `materiales` VALUES (40443, 1, 'BOQUILL-429', 'BOQUILLA SIN ARENA UNIVERSAL CEMIX CAJA 5 KG', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:05', '2021-02-23 15:54:05', 0, 0);
INSERT INTO `materiales` VALUES (37779, 1, 'BOY-200', 'BOYA SEA DOO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:06', '2021-02-23 15:54:06', 0, 0);
INSERT INTO `materiales` VALUES (40172, 1, 'BRID-01', 'BRIDA DE CUELLO PLASTICO CORTO', 783, 'SANITARIA', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:06', '2021-02-23 15:54:06', 0, 0);
INSERT INTO `materiales` VALUES (41915, 1, 'CAB-02', 'CABEZAL HP COLORES', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:06', '2021-02-23 15:54:06', 0, 0);
INSERT INTO `materiales` VALUES (39880, 1, '', 'CABLE APPLE MX0K2AM/A USB-C A LIGHNING (1M)', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:06', '2021-02-23 15:54:06', 0, 0);
INSERT INTO `materiales` VALUES (40493, 1, 'CAB-14', 'CABLE P/BOCINA DUPLEX BICOLOR CALIBRE 14', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:06', '2021-02-23 15:54:06', 0, 0);
INSERT INTO `materiales` VALUES (38560, 1, 'E-204', 'CABLE THW 04\"  MARCA IUSA', 791, 'ELECTRIFICACION', 'ML', 'ML', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:06', '2021-02-23 15:54:06', 0, 0);
INSERT INTO `materiales` VALUES (37912, 1, 'E-116', 'CABLE THW 06\"  MARCA IUSA', 791, 'ELECTRIFICACION', 'ML', 'ML', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:07', '2021-02-23 15:54:07', 0, 0);
INSERT INTO `materiales` VALUES (39117, 1, 'E-120', 'CABLE THW 20\"  MARCA IUSA', 791, 'ELECTRIFICACION', 'ML', 'ML', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:07', '2021-02-23 15:54:07', 0, 0);
INSERT INTO `materiales` VALUES (38554, 1, 'CC66', 'CAJA REGISTRO CUADRADA DE 1 1/2 6X6 38mm ECONOMIC LAMPRO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:07', '2021-02-23 15:54:07', 0, 0);
INSERT INTO `materiales` VALUES (38889, 1, 'CAP-200', 'CALENTADOR RHEEM PERFORMANCE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:08', '2021-02-23 15:54:08', 0, 0);
INSERT INTO `materiales` VALUES (41510, 1, 'CAM-20', 'CAMA DE 20 CM DE ESPESOR DE MATERIAL TRITURADO', 808, 'OTROS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:08', '2021-02-23 15:54:08', 0, 0);
INSERT INTO `materiales` VALUES (37666, 1, 'CAM-300', 'CAMARA WEB', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:08', '2021-02-23 15:54:08', 0, 0);
INSERT INTO `materiales` VALUES (40528, 1, 'VINI-01', 'CAMBIO DE VINIL EN TOTEMP', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:08', '2021-02-23 15:54:08', 0, 0);
INSERT INTO `materiales` VALUES (41929, 1, 'CAN-05', 'CANALETA CHICA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:08', '2021-02-23 15:54:08', 0, 0);
INSERT INTO `materiales` VALUES (39102, 1, 'CHA-100', 'CANCHA DE USOS MÚLTIPLES  DE CONCRETO PREMEZCLADO FC=150kg/cm2, T.M.A. 3/4\",  DE 10cm., INCLUYE: CIMBRA EN FRONTERAS, COLADO, VIBRADO,   ACABADO COMUN A PLANA Y/O CON BOCHA DE PELO INCLUYE:MATERIALES', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:08', '2021-02-23 15:54:08', 0, 0);
INSERT INTO `materiales` VALUES (41965, 1, 'CAPU-73', 'CAPUCHA SIMPLE DE 73 MM GALV.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:09', '2021-02-23 15:54:09', 0, 0);
INSERT INTO `materiales` VALUES (41355, 1, 'CARP-87', 'CARPETA PLASTICA 3 ARGOLLAS 3 PUKLGADAS', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:09', '2021-02-23 15:54:09', 0, 0);
INSERT INTO `materiales` VALUES (41352, 1, 'CAR-087', 'CARPETA PLASTICA DE 3 ARGOLLAS 1', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:09', '2021-02-23 15:54:09', 0, 0);
INSERT INTO `materiales` VALUES (38114, 1, 'CAS-200', 'CASCO DE SEGURIDAD', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:09', '2021-02-23 15:54:09', 0, 0);
INSERT INTO `materiales` VALUES (37700, 1, 'CAT-250', 'CATALOGOS EN PAPEL COUCHE LAMINADO Y ENMICADO CON 25 HOJAS', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:10', '2021-02-23 15:54:10', 0, 0);
INSERT INTO `materiales` VALUES (39114, 1, 'CAL-200', 'CAUTIN LAPIZ DE 40 W', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:10', '2021-02-23 15:54:10', 0, 0);
INSERT INTO `materiales` VALUES (41313, 1, 'CEME-01', 'CEMENTO GRIS IMPERCEM 50 KG.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:10', '2021-02-23 15:54:10', 0, 0);
INSERT INTO `materiales` VALUES (40179, 1, 'CCS-20', 'CENTRO DE CARGA 20 CIRC. SOBREPONER 125 AMP. INC. TAPA SOBREPONER MCA. BTPLUG', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:10', '2021-02-23 15:54:10', 0, 0);
INSERT INTO `materiales` VALUES (37223, 1, 'CCT-100', 'CENTRO DE CARGA DE 20 CIRC. TRIFASICO 125 AMP DE EMPOTRAR', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:10', '2021-02-23 15:54:10', 0, 0);
INSERT INTO `materiales` VALUES (41699, 1, 'CEQ-02', 'CENTRO DE CARGA Q2', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:10', '2021-02-23 15:54:10', 0, 0);
INSERT INTO `materiales` VALUES (41702, 1, 'CENQ-04', 'CENTRO DE CARGA Q4', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:11', '2021-02-23 15:54:11', 0, 0);
INSERT INTO `materiales` VALUES (38701, 1, 'CWC-200', 'CEPILLO PARA W.C.', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:11', '2021-02-23 15:54:11', 0, 0);
INSERT INTO `materiales` VALUES (40800, 1, 'CER-05', 'CERTIFICACION CABILDO', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:11', '2021-02-23 15:54:11', 0, 0);
INSERT INTO `materiales` VALUES (40436, 1, '2236', 'CESPOL P/LAV TIPO  P  FLEX C/CUB A. INOX 2236', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:11', '2021-02-23 15:54:11', 0, 0);
INSERT INTO `materiales` VALUES (38789, 1, 'CCL-100', 'CESPOL P/LAVABO CR TV-107 CROMADO', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:11', '2021-02-23 15:54:11', 0, 0);
INSERT INTO `materiales` VALUES (37773, 1, 'CHA-00', 'CHALECO SALVAVIDA MOTION CAN A M HOMBRE G/L', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:11', '2021-02-23 15:54:11', 0, 0);
INSERT INTO `materiales` VALUES (41369, 1, 'CHALE-002', 'CHALECO VERDE', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:11', '2021-02-23 15:54:11', 0, 0);
INSERT INTO `materiales` VALUES (41719, 1, 'CHU-02', 'CHUPON PARA TARJA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:12', '2021-02-23 15:54:12', 0, 0);
INSERT INTO `materiales` VALUES (40795, 1, 'CAT-06', 'CLAVES CATASTRALES', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:12', '2021-02-23 15:54:12', 0, 0);
INSERT INTO `materiales` VALUES (38808, 1, 'H-145', 'CODO CPVC 45° DE 1/2 DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:13', '2021-02-23 15:54:13', 0, 0);
INSERT INTO `materiales` VALUES (38910, 1, 'H-302', 'CODO DE 90° TUBOPLUS DE 3/4\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:13', '2021-02-23 15:54:13', 0, 0);
INSERT INTO `materiales` VALUES (39099, 1, 'H-320', 'CODO PVC HIDRAULICO DE 90° DE 3/4\" DE DIAMETRO', 25899, 'HERRAMIENTA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:13', '2021-02-23 15:54:13', 0, 0);
INSERT INTO `materiales` VALUES (38750, 1, 'COI-200', 'COLADERA LINEAL D/INSERTO 8.5X20cm', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:13', '2021-02-23 15:54:13', 0, 0);
INSERT INTO `materiales` VALUES (38753, 1, 'COL-201', 'COLADERA LINEAL LAMINA LISA DESALOJO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:13', '2021-02-23 15:54:13', 0, 0);
INSERT INTO `materiales` VALUES (40092, 1, '', 'CONCENTRADOR CON  NEBULIZADOR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:14', '2021-02-23 15:54:14', 0, 0);
INSERT INTO `materiales` VALUES (38545, 1, 'COB-093', 'CONDULET LB C/TAP 1\" MCA. RAWELT', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:14', '2021-02-23 15:54:14', 0, 0);
INSERT INTO `materiales` VALUES (38548, 1, 'COL-094', 'CONDULET LL C/TAP 1\" MCA. RAWELT', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:14', '2021-02-23 15:54:14', 0, 0);
INSERT INTO `materiales` VALUES (38551, 1, 'COR-095', 'CONDULET LR C/TAP 1\" MCA. RAWELT', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:14', '2021-02-23 15:54:14', 0, 0);
INSERT INTO `materiales` VALUES (37906, 1, 'CON-250', 'CONECTOR PARED DELGADA 25 mm ( 1 ) ANCLO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:15', '2021-02-23 15:54:15', 0, 0);
INSERT INTO `materiales` VALUES (41219, 1, 'CONRU-12', 'CONECTOR USO RUDO DE 1/2 ANCLO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:15', '2021-02-23 15:54:15', 0, 0);
INSERT INTO `materiales` VALUES (41576, 1, 'CONE-02', 'CONECTORES DE GAS', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:15', '2021-02-23 15:54:15', 0, 0);
INSERT INTO `materiales` VALUES (40847, 1, 'CON-14', 'CONEXIONES DE LINEA PRIMARIA PARA ELECTRIFICACION', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:15', '2021-02-23 15:54:15', 0, 0);
INSERT INTO `materiales` VALUES (39780, 1, 'E-6028', 'CONTACTO DUPLEX CON POLO A TIERRA 15 AMP. 127-250 VOLTS BLANCO MCA. MODUS PRO', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:15', '2021-02-23 15:54:15', 0, 0);
INSERT INTO `materiales` VALUES (40499, 1, 'CONT-15', 'CONTACTO DUPLEX CON POLO A TIERRA 15 AMP. 127-250 VOLTS. BLANCO MCA. MODUS PRO', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:16', '2021-02-23 15:54:16', 0, 0);
INSERT INTO `materiales` VALUES (39786, 1, 'M-5250', 'CONTACTO DUPLEX POLARIZADO 15A-125V 2 POLOS DE 3 HILOS BLANCO ARROW HART', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:16', '2021-02-23 15:54:16', 0, 0);
INSERT INTO `materiales` VALUES (37740, 1, 'CMT-200', 'CONTENEDOR MARITIMO DE ACERO TIPO B - USADO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:16', '2021-02-23 15:54:16', 0, 0);
INSERT INTO `materiales` VALUES (38413, 1, 'CNM-200', 'CONTROL PARA MINISPLIT', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:16', '2021-02-23 15:54:16', 0, 0);
INSERT INTO `materiales` VALUES (39752, 1, 'CONV-01', 'CONVERTIDOR MANHATTAN HDMI', 808, 'OTROS', 'PIEZAS', 'PIEZAS', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:16', '2021-02-23 15:54:16', 0, 0);
INSERT INTO `materiales` VALUES (37909, 1, 'COP-125', 'COPLE PARED DELGADA 25 mm ( 1 ) ANCLO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:16', '2021-02-23 15:54:16', 0, 0);
INSERT INTO `materiales` VALUES (38903, 1, 'H-204', 'COPLE TUBOPLUS DE 3/4\" DE DIAMETRO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:16', '2021-02-23 15:54:16', 0, 0);
INSERT INTO `materiales` VALUES (41555, 1, 'CIR-80', 'COROPLAST 1 X .80 C M', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:17', '2021-02-23 15:54:17', 0, 0);
INSERT INTO `materiales` VALUES (37978, 1, 'CRV-102', 'CREMA VENEZIA 20X2 ESPESOR ARENADO P-025', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:17', '2021-02-23 15:54:17', 0, 0);
INSERT INTO `materiales` VALUES (37975, 1, 'CRV-101', 'CREMA VENEZIA 20X2 ESPESOR ARENADO P-146', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:17', '2021-02-23 15:54:17', 0, 0);
INSERT INTO `materiales` VALUES (37972, 1, 'CRV-100', 'CREMA VENEZIA 20X2 ESPESOR ARENADO P-147', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:17', '2021-02-23 15:54:17', 0, 0);
INSERT INTO `materiales` VALUES (41133, 1, 'CUAM-02', 'CUADROS DE MADERA CON LONA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:17', '2021-02-23 15:54:17', 0, 0);
INSERT INTO `materiales` VALUES (41055, 1, 'CUB-002', 'CUBETA CON ESCURRIDOR', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:17', '2021-02-23 15:54:17', 0, 0);
INSERT INTO `materiales` VALUES (40111, 1, 'CUA-20', 'CUOTA ANUAL ( COLEGIO DE ARQUITECTOS DRO )', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:18', '2021-02-23 15:54:18', 0, 0);
INSERT INTO `materiales` VALUES (40781, 1, 'CUO-01', 'CUOTA ANUAL DE DRO', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:18', '2021-02-23 15:54:18', 0, 0);
INSERT INTO `materiales` VALUES (40376, 1, '', 'Certificado Libre Gravamen', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:18', '2021-02-23 15:54:18', 0, 0);
INSERT INTO `materiales` VALUES (39763, 1, 'DD-011', 'DD INTERNO WD PURPLE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:18', '2021-02-23 15:54:18', 0, 0);
INSERT INTO `materiales` VALUES (38763, 1, 'DES-203', 'DESAGUE UNIVERSAL DE POP UP SIN REBOSADERO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:18', '2021-02-23 15:54:18', 0, 0);
INSERT INTO `materiales` VALUES (41393, 1, 'DES-02', 'DESARMADORES', 25899, 'HERRAMIENTA', 'JUEGO', 'JUEGO', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:19', '2021-02-23 15:54:19', 0, 0);
INSERT INTO `materiales` VALUES (38346, 1, 'DES-300', 'DESINFECTANTE ANTIBACTERIAL LYSOL CRIP MOUNTAIN AIR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:19', '2021-02-23 15:54:19', 0, 0);
INSERT INTO `materiales` VALUES (38410, 1, 'DEM-350', 'DESMONTAJE DE  MINISPLIT', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:19', '2021-02-23 15:54:19', 0, 0);
INSERT INTO `materiales` VALUES (37859, 1, 'DEM-300', 'DESMONTAJE Y MONTAJE DE UNA SERIA DE 15 PANELES SOLARES EN NUEVA UBICACION', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:19', '2021-02-23 15:54:19', 0, 0);
INSERT INTO `materiales` VALUES (42004, 1, 'DESPA-2', 'DESPACHADOR CINTA SCOTCH', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:19', '2021-02-23 15:54:19', 0, 0);
INSERT INTO `materiales` VALUES (41402, 1, 'DISCDIA-02', 'DISCO DIAMANTE', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:19', '2021-02-23 15:54:19', 0, 0);
INSERT INTO `materiales` VALUES (41405, 1, 'DISCAC-02', 'DISCO PARA ACERO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:19', '2021-02-23 15:54:19', 0, 0);
INSERT INTO `materiales` VALUES (38876, 1, '', 'DISEÑO DE LOGOTIPO', 804, 'PUBLICIDAD', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:19', '2021-02-23 15:54:19', 0, 0);
INSERT INTO `materiales` VALUES (41671, 1, 'DONA-02', 'DONATIVO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:20', '2021-02-23 15:54:20', 0, 0);
INSERT INTO `materiales` VALUES (37998, 1, 'DOF-100', 'DOSIFICADORA P/ENVASE 1 - 1/2 LTO.', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:20', '2021-02-23 15:54:20', 0, 0);
INSERT INTO `materiales` VALUES (40511, 1, 'DUCT-4', 'DUCTO P/SECADORA 4*2.44 MTOS. COFLEX DJ-D48A', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:20', '2021-02-23 15:54:20', 0, 0);
INSERT INTO `materiales` VALUES (38240, 1, 'TEFO-7', 'EMPAQUE NEOPRENO DE 1/8\" P/BRIDA DE ( 12\" )', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:20', '2021-02-23 15:54:20', 0, 0);
INSERT INTO `materiales` VALUES (38243, 1, 'TEFO-8', 'EMPAQUE NEOPRENO DE 1/8\" P/BRIDA DE ( 6\" )', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:20', '2021-02-23 15:54:20', 0, 0);
INSERT INTO `materiales` VALUES (38228, 1, 'TEFO-3', 'EMPAQUE NEOPRENO DE 1/8\" P/BRIDA DE ( 8\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:21', '2021-02-23 15:54:21', 0, 0);
INSERT INTO `materiales` VALUES (41380, 1, 'EQ', 'EQUIPO 5 TON TIPO PAQUETE MARCA TRANE CON BOMBA DE CALOR R 410 220/1/60', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:21', '2021-02-23 15:54:21', 0, 0);
INSERT INTO `materiales` VALUES (38782, 1, 'ESC-201', 'ESCALERA DE  CONCRETO Y BLOCK  SECCIÓN 12-20-40 HECHO EN OBRA FC=150 KG/CM2 TMA 3/4 SECCION 6 MTS ANCHO  ALTURA MAX 1.00  INCLUYE CIMBRA EN FRONTERAS,COLADO,VIBRADO,ACABADO OLANEADO CON MADER', 806, 'URBANIZACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:21', '2021-02-23 15:54:21', 0, 0);
INSERT INTO `materiales` VALUES (41069, 1, 'ESCA-007', 'ESCALERA DE 7 MTS.', 25899, 'HERRAMIENTA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:21', '2021-02-23 15:54:21', 0, 0);
INSERT INTO `materiales` VALUES (41564, 1, 'ESCA-02', 'ESCALERA DE TIJERA DE 2 MTS.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:21', '2021-02-23 15:54:21', 0, 0);
INSERT INTO `materiales` VALUES (41084, 1, 'ESCPEL-007', 'ESCALERA TIJERA DE 7 PELDAÑOS', 25899, 'HERRAMIENTA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:21', '2021-02-23 15:54:21', 0, 0);
INSERT INTO `materiales` VALUES (41049, 1, 'ESCC-001', 'ESCOBA DE CEPILLO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:22', '2021-02-23 15:54:22', 0, 0);
INSERT INTO `materiales` VALUES (41600, 1, 'ESCRO-02', 'ESCRITORIO EN ESCUADRA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:22', '2021-02-23 15:54:22', 0, 0);
INSERT INTO `materiales` VALUES (40823, 1, 'ESC-03', 'ESCRITURAS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:22', '2021-02-23 15:54:22', 0, 0);
INSERT INTO `materiales` VALUES (40806, 1, 'PRE-05', 'ESTADOS DE CUENTA PREDIAL', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:22', '2021-02-23 15:54:22', 0, 0);
INSERT INTO `materiales` VALUES (40900, 1, 'EXT-002', 'EXTENSION CROMADA PARA LAVABO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:24', '2021-02-23 15:54:24', 0, 0);
INSERT INTO `materiales` VALUES (41127, 1, 'ACRIL-80', 'FABRICACION DE CUADROS DE ACRILICO DE 80 X 60 CON CRIPOS', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:24', '2021-02-23 15:54:24', 0, 0);
INSERT INTO `materiales` VALUES (39565, 1, 'ACR-187', 'FABRICACION DE CUADROS EN ACRILICO DE 80X100 INC. INSTALACION EN VAGON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:24', '2021-02-23 15:54:24', 0, 0);
INSERT INTO `materiales` VALUES (39521, 1, 'ACR-H87', 'FABRICACION DE CUADROS EN ACRILICO DE 80X60 INC. INSTALACION EN VAGON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:25', '2021-02-23 15:54:25', 0, 0);
INSERT INTO `materiales` VALUES (40531, 1, 'TOTE-01', 'FABRICACION DE TOTEM', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:25', '2021-02-23 15:54:25', 0, 0);
INSERT INTO `materiales` VALUES (39771, 1, 'MR-16', 'FOCO MR16 LED 7 WATTS, DIMEABLE EN 3000 TECNOLITE', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:25', '2021-02-23 15:54:25', 0, 0);
INSERT INTO `materiales` VALUES (41637, 1, 'FOLHOT-02', 'FOLDER STRFILE HOTCOLOR OFICIO VERDE C/25', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:26', '2021-02-23 15:54:26', 0, 0);
INSERT INTO `materiales` VALUES (42023, 1, 'FOMI-5', 'FOMICEL', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:26', '2021-02-23 15:54:26', 0, 0);
INSERT INTO `materiales` VALUES (37776, 1, 'FOR-00', 'FORRO PARA RXP/GTR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:26', '2021-02-23 15:54:26', 0, 0);
INSERT INTO `materiales` VALUES (39878, 1, '', 'FUNDA APPLE IPHONE 12 PRO MAX TRANSPARENTE MAGSAFE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:26', '2021-02-23 15:54:26', 0, 0);
INSERT INTO `materiales` VALUES (38074, 1, '', 'FUNDA SAE DOO SPARK 2 PERSONAS', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:26', '2021-02-23 15:54:26', 0, 0);
INSERT INTO `materiales` VALUES (40819, 1, 'FUS-01', 'FUSION', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:26', '2021-02-23 15:54:26', 0, 0);
INSERT INTO `materiales` VALUES (41923, 1, 'GAB-06', 'GABINETE DE PLASTICO PARA INTERPERIE', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:26', '2021-02-23 15:54:26', 0, 0);
INSERT INTO `materiales` VALUES (41305, 1, 'GENEELE-01', 'GENERADOR ELECTRICO', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:27', '2021-02-23 15:54:27', 0, 0);
INSERT INTO `materiales` VALUES (38140, 1, '', 'GOGGLE BKR ESSENTIAL NEGRO MATE 70-2181-001', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:27', '2021-02-23 15:54:27', 0, 0);
INSERT INTO `materiales` VALUES (40850, 1, 'GRA-08', 'GRATIFICACIONES', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:27', '2021-02-23 15:54:27', 0, 0);
INSERT INTO `materiales` VALUES (37966, 1, 'GIM-100', 'GRIS IMPERIAL 30X1 ESPESOR CEPILLADO', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:27', '2021-02-23 15:54:27', 0, 0);
INSERT INTO `materiales` VALUES (38351, 1, 'GLX-200', 'GUANTE DE LATEX BLANCO MEDIANO C/100  PIEZAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:27', '2021-02-23 15:54:27', 0, 0);
INSERT INTO `materiales` VALUES (41052, 1, 'GUAN-002', 'GUANTES AFELPADOS PARA LIMPIEZA', 15165, 'MATERIAL Y MANO DE OBRA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:27', '2021-02-23 15:54:27', 0, 0);
INSERT INTO `materiales` VALUES (40107, 1, 'GUANT-02', 'GUANTES DE CARNAZA MANGA LARGA', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:27', '2021-02-23 15:54:27', 0, 0);
INSERT INTO `materiales` VALUES (38704, 1, 'GTH-200', 'GUANTES DE HULE', 808, 'OTROS', 'JUEGO', 'JUEGO', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:27', '2021-02-23 15:54:27', 0, 0);
INSERT INTO `materiales` VALUES (41260, 1, 'GUANTELAR-02', 'GUANTES LARGOS', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:27', '2021-02-23 15:54:27', 0, 0);
INSERT INTO `materiales` VALUES (38099, 1, '', 'HERRAJES PARA PRODUCTOR DE PUÑO 715001378', 808, 'OTROS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:28', '2021-02-23 15:54:28', 0, 0);
INSERT INTO `materiales` VALUES (38093, 1, 'HRR-100', 'HERRERIA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:28', '2021-02-23 15:54:28', 0, 0);
INSERT INTO `materiales` VALUES (37250, 1, 'IMP-400', 'IMPERMEABILIZANTE MARCA THERMOTEK DOBLE ACCION BCO', 794, 'ACABADOS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:28', '2021-02-23 15:54:28', 0, 0);
INSERT INTO `materiales` VALUES (40475, 1, 'INGR-10', 'INGROUND2 10W 3000K', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:28', '2021-02-23 15:54:28', 0, 0);
INSERT INTO `materiales` VALUES (40831, 1, 'INS-04', 'INSCRIPCION DE VIVIENDA', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:29', '2021-02-23 15:54:29', 0, 0);
INSERT INTO `materiales` VALUES (38103, 1, 'IND-100', 'INSECTICIDA DIAZINON', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:29', '2021-02-23 15:54:29', 0, 0);
INSERT INTO `materiales` VALUES (41611, 1, 'INSMIN-02', 'INSTALACION DE MINISPLIT', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:29', '2021-02-23 15:54:29', 0, 0);
INSERT INTO `materiales` VALUES (39343, 1, 'GM-7402', 'INSTALACION DE SISTEMA DE ENLACE PARA 2 PUNTOS INALAMBRICOS', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:29', '2021-02-23 15:54:29', 0, 0);
INSERT INTO `materiales` VALUES (39057, 1, 'POS-200', 'INTERCALAR POSTE DE CONCRETO DE 12 MTS. Y ESTRUCTURAS', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:29', '2021-02-23 15:54:29', 0, 0);
INSERT INTO `materiales` VALUES (37706, 1, 'INV-100', 'INVERSION DE REDES', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:30', '2021-02-23 15:54:30', 0, 0);
INSERT INTO `materiales` VALUES (38834, 1, 'CAREAPP937', 'IPAD PRO 12.9&QUOT;MXF52LZ/A WIFI+CELLULLAR 256 GB GRIS ESPACIAL NUEVA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:30', '2021-02-23 15:54:30', 0, 0);
INSERT INTO `materiales` VALUES (39892, 1, '', 'IPHONE 12 128 GB (PRODUCT) RED', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:30', '2021-02-23 15:54:30', 0, 0);
INSERT INTO `materiales` VALUES (42080, 1, '', 'IPHONE 12 PRO MAX 256 GB ORO', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:30', '2021-02-23 15:54:30', 0, 0);
INSERT INTO `materiales` VALUES (39876, 1, '', 'IPHONE 12 PRO MAX 256 GB PLATA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:30', '2021-02-23 15:54:30', 0, 0);
INSERT INTO `materiales` VALUES (39272, 1, 'ISL-100', 'ISLA DE TRABAJO MODELO 210S LINEA ITALIA 1.50 X 1.50 X .75', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:30', '2021-02-23 15:54:30', 0, 0);
INSERT INTO `materiales` VALUES (41065, 1, 'JALA-001', 'JALADOR PARA VIDRIOS', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:30', '2021-02-23 15:54:30', 0, 0);
INSERT INTO `materiales` VALUES (39905, 1, 'JGO-100', 'JUEGO DE ACTA ENTREGA, 3 DISEÑOS CON ORIGINAL Y 2 COPIAS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:30', '2021-02-23 15:54:30', 0, 0);
INSERT INTO `materiales` VALUES (39383, 1, 'LAM-320', 'LAMPARA CON SENSOR DE MOVIMIENTO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:31', '2021-02-23 15:54:31', 0, 0);
INSERT INTO `materiales` VALUES (41332, 1, 'LPT-200', 'LAPTOP GAMER', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:32', '2021-02-23 15:54:32', 0, 0);
INSERT INTO `materiales` VALUES (38766, 1, 'LAV-201', 'LAVABO OSLO RECTANGULAR BLANCO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:32', '2021-02-23 15:54:32', 0, 0);
INSERT INTO `materiales` VALUES (41235, 1, 'LAVABTO-01', 'LAVABO TOTTI BLANCO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:32', '2021-02-23 15:54:32', 0, 0);
INSERT INTO `materiales` VALUES (40469, 1, 'LED-19', 'LED ECO A19 9W LUZ CALIDA', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:32', '2021-02-23 15:54:32', 0, 0);
INSERT INTO `materiales` VALUES (41606, 1, 'LIBMOD-02', 'LIBRERO MODERNO METALICO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:32', '2021-02-23 15:54:32', 0, 0);
INSERT INTO `materiales` VALUES (39727, 1, '', 'LIBRERO MODERNO METALICO YOU', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:32', '2021-02-23 15:54:32', 0, 0);
INSERT INTO `materiales` VALUES (39297, 1, 'LIB-100', 'LIBRO MODERNO METALICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:32', '2021-02-23 15:54:32', 0, 0);
INSERT INTO `materiales` VALUES (40777, 1, 'LIC-01', 'LICENCIA DE FRACCIONAMIENTO', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:32', '2021-02-23 15:54:32', 0, 0);
INSERT INTO `materiales` VALUES (37995, 1, 'LIP-100', 'LIMPIADOR DESINFECTANTE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:33', '2021-02-23 15:54:33', 0, 0);
INSERT INTO `materiales` VALUES (38760, 1, 'LLB-100', 'LLAVE BERLIN MONOMANDO ALTA PARA LAVABO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:33', '2021-02-23 15:54:33', 0, 0);
INSERT INTO `materiales` VALUES (41074, 1, 'PERI-001', 'LLAVE PERICA 1/2 AJUSTABLE', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:33', '2021-02-23 15:54:33', 0, 0);
INSERT INTO `materiales` VALUES (41078, 1, 'STIL-002', 'LLAVE STILSON', 25899, 'HERRAMIENTA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:33', '2021-02-23 15:54:33', 0, 0);
INSERT INTO `materiales` VALUES (38365, 1, 'LAV-300', 'LLAVERO CASA RUMA, CON UN GRABADO DE LASER DE UN LOGO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:34', '2021-02-23 15:54:34', 0, 0);
INSERT INTO `materiales` VALUES (38360, 1, 'LAV-140', 'LLAVERO LABORO CON IMPRESION Y GOTEADO DE RESINA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:34', '2021-02-23 15:54:34', 0, 0);
INSERT INTO `materiales` VALUES (41653, 1, 'LLAVELA-02', 'LLAVEROS GRABADOS EN LASER', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:34', '2021-02-23 15:54:34', 0, 0);
INSERT INTO `materiales` VALUES (40813, 1, 'LOT-03', 'LOTIFICACION', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:34', '2021-02-23 15:54:34', 0, 0);
INSERT INTO `materiales` VALUES (39768, 1, 'YD-220', 'LUMINARIO ALEZIO EMPOTRADO PARA MR16 COLOR SATIN tecnolite', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:34', '2021-02-23 15:54:34', 0, 0);
INSERT INTO `materiales` VALUES (38722, 1, 'LUM-300', 'LUMINARIO PISO DE 7.5 WATTS. DE 3000° TECNOLITE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:34', '2021-02-23 15:54:34', 0, 0);
INSERT INTO `materiales` VALUES (39827, 1, 'N-075', 'LUMINARIO TOLEDO I MURO ALUMINIO SATIN 2XE26 S/LAMPARAS TECNOLITE', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:34', '2021-02-23 15:54:34', 0, 0);
INSERT INTO `materiales` VALUES (39543, 1, 'MAC-244', 'MACETA EDENIKA 25 CHOCOLATE', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:35', '2021-02-23 15:54:35', 0, 0);
INSERT INTO `materiales` VALUES (39547, 1, 'MAC-232', 'MACETA EDENIKA 25 IVORY', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:35', '2021-02-23 15:54:35', 0, 0);
INSERT INTO `materiales` VALUES (39630, 1, 'MD-016', 'MADERA 1X8X16', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:35', '2021-02-23 15:54:35', 0, 0);
INSERT INTO `materiales` VALUES (38837, 1, 'TECAPP048', 'MAGIC KEYBOARD PARA IPAD PRO DE 12.9', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:35', '2021-02-23 15:54:35', 0, 0);
INSERT INTO `materiales` VALUES (41941, 1, 'MAL-11', 'MALLA CICLONICA DE 1 MT, CAL. 11 63 X 63', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:35', '2021-02-23 15:54:35', 0, 0);
INSERT INTO `materiales` VALUES (41375, 1, 'MALL-01', 'MALLA PLAFONERA', 808, 'OTROS', 'ROLLO', 'ROLLO', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:35', '2021-02-23 15:54:35', 0, 0);
INSERT INTO `materiales` VALUES (41257, 1, 'MANGRI-34', 'MANGUERA PARA RIEGO 3/4', 808, 'OTROS', 'MTO', 'MTO', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:36', '2021-02-23 15:54:36', 0, 0);
INSERT INTO `materiales` VALUES (40844, 1, 'MAN-03', 'MANIOBRAS CON EQUIPO AISLADO', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:36', '2021-02-23 15:54:36', 0, 0);
INSERT INTO `materiales` VALUES (41974, 1, 'MANO-02', 'MANO DE OBRA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:36', '2021-02-23 15:54:36', 0, 0);
INSERT INTO `materiales` VALUES (41281, 1, 'MCR-200', 'MARCADOR P/PIZ PLASTICO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:36', '2021-02-23 15:54:36', 0, 0);
INSERT INTO `materiales` VALUES (38920, 1, 'MBT-200', 'MARMOL BEIGE PARA TERRAZA 60x20', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:37', '2021-02-23 15:54:37', 0, 0);
INSERT INTO `materiales` VALUES (40979, 1, 'MARM-001', 'MARMOL CORTADO A DIF. MEDIDAS', 795, 'PISOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:37', '2021-02-23 15:54:37', 0, 0);
INSERT INTO `materiales` VALUES (38065, 1, 'MGT-200', 'MARMOL GRIS TEPEACA MARTELINADO DE 1.40X.80 MTS', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:37', '2021-02-23 15:54:37', 0, 0);
INSERT INTO `materiales` VALUES (38321, 1, 'MMG-200', 'MARMOL MYSTERY GRAY 40X40 HORNEADO 1 CM', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:37', '2021-02-23 15:54:37', 0, 0);
INSERT INTO `materiales` VALUES (41390, 1, 'MARR-02', 'MARRO GRANDE 12 LBS.', 25899, 'HERRAMIENTA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:37', '2021-02-23 15:54:37', 0, 0);
INSERT INTO `materiales` VALUES (39361, 1, 'GM-0004', 'MATERIAL MISCELANEO', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:37', '2021-02-23 15:54:37', 0, 0);
INSERT INTO `materiales` VALUES (41000, 1, 'HYT-533', 'MESA CIRCULAR NAPOLES 719 CUBIERTA PRECOMPUESTO CENIZA Y ESTRUCTURA DE ALUMINIO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:38', '2021-02-23 15:54:38', 0, 0);
INSERT INTO `materiales` VALUES (39282, 1, 'MES-100', 'MESA PARA JUNTAS NAPOLES MODELO 719 DE 1.10 DE DIAMETRO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:38', '2021-02-23 15:54:38', 0, 0);
INSERT INTO `materiales` VALUES (39882, 1, '', 'MICA ZAGG IS-GLASS ELITE VISIONGUARD PLUS P/IPHONE 12 PROMAX', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:38', '2021-02-23 15:54:38', 0, 0);
INSERT INTO `materiales` VALUES (42028, 1, 'MILLREP-5', 'MILLAR REPORTES DE FOLIO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:38', '2021-02-23 15:54:38', 0, 0);
INSERT INTO `materiales` VALUES (41089, 1, 'STAN-19', 'MODIFICACION DE STAND (MURO, TRABE, FOLLAJE VERDE, MADERA, MOLDURAS LUZ INDIRECTA, CUADROS ACRILICO, VINIL IMPRESO HD.)', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:39', '2021-02-23 15:54:39', 0, 0);
INSERT INTO `materiales` VALUES (39469, 1, 'MOL-200', 'MOLDE METALICO PARA MURETES DE LUZ', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:39', '2021-02-23 15:54:39', 0, 0);
INSERT INTO `materiales` VALUES (41926, 1, 'MONI-07', 'MONITOR DAHUA TOUCH DE 7 PULG.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:39', '2021-02-23 15:54:39', 0, 0);
INSERT INTO `materiales` VALUES (40541, 1, 'MONI-23', 'MONITOR LED BENQ IPS 23.8/HDMI/VGA/ MONITORES Y BOCINAS 1W X 2', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:39', '2021-02-23 15:54:39', 0, 0);
INSERT INTO `materiales` VALUES (41232, 1, 'MONOMA-01', 'MONOMANDO PARA LAVABO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:39', '2021-02-23 15:54:39', 0, 0);
INSERT INTO `materiales` VALUES (38193, 1, '', 'MONTAJE', 808, 'OTROS', '', '', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:39', '2021-02-23 15:54:39', 0, 0);
INSERT INTO `materiales` VALUES (37862, 1, 'MON-300', 'MONTAJE DE CANALIZACION PARA INTERCONEXION CON INVERSOR', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:40', '2021-02-23 15:54:40', 0, 0);
INSERT INTO `materiales` VALUES (37790, 1, 'MOA-250', 'MOTO ACUATICA RXP-XRS 300 21', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:40', '2021-02-23 15:54:40', 0, 0);
INSERT INTO `materiales` VALUES (38070, 1, '', 'MOTO ACUATICA SPARK 2 900 HO/IBR 21 64M MA-MOD 2021 MARCA  CAN AM', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:40', '2021-02-23 15:54:40', 0, 0);
INSERT INTO `materiales` VALUES (38897, 1, 'MOT-M511', 'MOTOR MERIK 511', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:40', '2021-02-23 15:54:40', 0, 0);
INSERT INTO `materiales` VALUES (40834, 1, 'PAG-04', 'PAGO DE ORDEN DE VERIFICACION', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:41', '2021-02-23 15:54:41', 0, 0);
INSERT INTO `materiales` VALUES (38884, 1, 'PHM-2169', 'PANEL DE HIDROMASAJE COMPUESTO AC/INOX 2169', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:41', '2021-02-23 15:54:41', 0, 0);
INSERT INTO `materiales` VALUES (37921, 1, 'PAS-174', 'PASTILLA RIEL 3 POLOS DE 63 AMP IUSA', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:42', '2021-02-23 15:54:42', 0, 0);
INSERT INTO `materiales` VALUES (41713, 1, 'TEM-20', 'PASTILLA TERMOMAGNETICA 20 AMP.', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:42', '2021-02-23 15:54:42', 0, 0);
INSERT INTO `materiales` VALUES (41567, 1, 'PASTI-30', 'PASTILLA TERMOMAGNETICA 30 AMP.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:42', '2021-02-23 15:54:42', 0, 0);
INSERT INTO `materiales` VALUES (41254, 1, 'PICOTAL-01', 'PICO-TALACHO', 25899, 'HERRAMIENTA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:43', '2021-02-23 15:54:43', 0, 0);
INSERT INTO `materiales` VALUES (41573, 1, 'PIJ-03', 'PIJAS PARA SOQUET', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:43', '2021-02-23 15:54:43', 0, 0);
INSERT INTO `materiales` VALUES (41372, 1, 'PINBL-01', 'PINTURA BLANCO OSTION, VINIL-ACRILICO', 797, 'PINTURAS', 'CUBETA', 'CUBETA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:43', '2021-02-23 15:54:43', 0, 0);
INSERT INTO `materiales` VALUES (41081, 1, 'ELECT-002', 'PINZA ELECTRICA', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:44', '2021-02-23 15:54:44', 0, 0);
INSERT INTO `materiales` VALUES (40971, 1, 'STO-001', 'PISO MARMOL STO. TOMAS BRILLADO 40 X 60 X2 CM', 795, 'PISOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:44', '2021-02-23 15:54:44', 0, 0);
INSERT INTO `materiales` VALUES (37800, 1, 'ATZ-100', 'PISTOLA ATOMIZADOR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:44', '2021-02-23 15:54:44', 0, 0);
INSERT INTO `materiales` VALUES (38336, 1, 'PIS-101', 'PISTOLA TERMOMETRO INFRA ROJO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:44', '2021-02-23 15:54:44', 0, 0);
INSERT INTO `materiales` VALUES (41278, 1, 'PIZ-100', 'PIZARRON BLANCO 40X60', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:45', '2021-02-23 15:54:45', 0, 0);
INSERT INTO `materiales` VALUES (39792, 1, 'E-5N1', 'PLACA 1 MODULO COLOR BLANCO MCA. MODUS PRO', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:45', '2021-02-23 15:54:45', 0, 0);
INSERT INTO `materiales` VALUES (39795, 1, 'E-5N2', 'PLACA 2 MODULOS COLOR BLANCO MCA. MODUS PRO', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:45', '2021-02-23 15:54:45', 0, 0);
INSERT INTO `materiales` VALUES (40182, 1, 'PLACM-03', 'PLACA 3 MODULOS BLANCA MCA. MODUS PRO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:45', '2021-02-23 15:54:45', 0, 0);
INSERT INTO `materiales` VALUES (40189, 1, 'PLACI-01', 'PLACA CIEGA  BLANCA MCA. MODUS PRO', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:45', '2021-02-23 15:54:45', 0, 0);
INSERT INTO `materiales` VALUES (39830, 1, 'N-0PTL', 'PLACA CIEGA BLANCA MCA. MODUS PRO', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:45', '2021-02-23 15:54:45', 0, 0);
INSERT INTO `materiales` VALUES (41570, 1, 'PLAC-02', 'PLACA DE 2 VENTANAS', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:45', '2021-02-23 15:54:45', 0, 0);
INSERT INTO `materiales` VALUES (39789, 1, 'PLA-022', 'PLACA PARA CONTACTO DOBLE INTERPERIE MCA. KLEY', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:45', '2021-02-23 15:54:45', 0, 0);
INSERT INTO `materiales` VALUES (40457, 1, 'PLC-1959', 'PLACA RESINA C/CHASIS BLANCO 1 MOD. 195973 MX', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:45', '2021-02-23 15:54:45', 0, 0);
INSERT INTO `materiales` VALUES (37682, 1, 'PLA-04', 'PLATAFORMAS ET 4 ARBOLEDA', 24527, 'PLATAFORMAS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:46', '2021-02-23 15:54:46', 0, 0);
INSERT INTO `materiales` VALUES (37690, 1, 'PLT-011', 'PLATAFORMAS ET. 11 MISIONES', 24527, 'PLATAFORMAS', 'PAQUETE', 'PAQUETE', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:46', '2021-02-23 15:54:46', 0, 0);
INSERT INTO `materiales` VALUES (41243, 1, 'POLICORR-34', 'POLIDUCTO CORRUGADO 3/4 ROLLO CON 50 MTS. GAREN', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:46', '2021-02-23 15:54:46', 0, 0);
INSERT INTO `materiales` VALUES (41971, 1, 'POR-4', 'PORTON DOS HOJAS ABATIBLE P/ CLRO DE 4. 4 MTS', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:46', '2021-02-23 15:54:46', 0, 0);
INSERT INTO `materiales` VALUES (41959, 1, 'POS-13', 'POSTE DE REMATE DE 60 MM X 1.3 MTS. CAL 18 GALV.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:47', '2021-02-23 15:54:47', 0, 0);
INSERT INTO `materiales` VALUES (39327, 1, 'PSA-250', 'POSTE EN PERFIL DE \" MTS CON LAMINA GALVANIZADA ROTULADA Y BARNIZADA UV 40X50 CON MARCO DE PERFIL DE 3/4', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:47', '2021-02-23 15:54:47', 0, 0);
INSERT INTO `materiales` VALUES (41956, 1, 'POS-60', 'POSTE REMATE DE 60 MM X 3.0 CAL .18 GALV.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:47', '2021-02-23 15:54:47', 0, 0);
INSERT INTO `materiales` VALUES (41953, 1, 'POS-73', 'POSTE REMATE DE 730 MM X 3.0 MTS CAL. 18 GALV.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:47', '2021-02-23 15:54:47', 0, 0);
INSERT INTO `materiales` VALUES (40787, 1, 'PRE-03', 'PREDIALES', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:47', '2021-02-23 15:54:47', 0, 0);
INSERT INTO `materiales` VALUES (40161, 1, 'PROC-01', 'PROCESOS ESPECIALES DE COMPUTACION', 808, 'OTROS', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:47', '2021-02-23 15:54:47', 0, 0);
INSERT INTO `materiales` VALUES (40841, 1, 'PRU-06', 'PRUEBAS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:47', '2021-02-23 15:54:47', 0, 0);
INSERT INTO `materiales` VALUES (39172, 1, '', 'PRUEBAS COVID', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:48', '2021-02-23 15:54:48', 0, 0);
INSERT INTO `materiales` VALUES (41399, 1, 'PULI-04', 'PULIDOR MARCA BOSH', 25899, 'HERRAMIENTA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:48', '2021-02-23 15:54:48', 0, 0);
INSERT INTO `materiales` VALUES (41058, 1, 'RAID-01', 'RAID, CASA Y JARDIN', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:49', '2021-02-23 15:54:49', 0, 0);
INSERT INTO `materiales` VALUES (40502, 1, 'RECEP9-3', 'RECEPTACULO DE POTENCIA ENTRADA RECTA 3P DE H HILOS ARROW HART', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:49', '2021-02-23 15:54:49', 0, 0);
INSERT INTO `materiales` VALUES (40803, 1, 'REC-06', 'RECOLECCION BASURA', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:49', '2021-02-23 15:54:49', 0, 0);
INSERT INTO `materiales` VALUES (41441, 1, 'ESCO-01', 'RECOLECCION DE ESCOMBRO', 15165, 'MATERIAL Y MANO DE OBRA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:49', '2021-02-23 15:54:49', 0, 0);
INSERT INTO `materiales` VALUES (38315, 1, 'H-226', 'REDUCCION CPVC 1 A 3/4', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:49', '2021-02-23 15:54:49', 0, 0);
INSERT INTO `materiales` VALUES (38225, 1, 'TEFO-2', 'REDUCCION EN FO.FO. BRIDADA DE ( 8\" x 6\" )', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:50', '2021-02-23 15:54:50', 0, 0);
INSERT INTO `materiales` VALUES (40928, 1, 'H-314', 'REDUCCIONES BUSHING DE 1/2\" A 1/4\" GALVANIZADA', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:50', '2021-02-23 15:54:50', 0, 0);
INSERT INTO `materiales` VALUES (40472, 1, 'REF-10', 'REFLECTOR DE LED SMD 10 W BCO CALIDO 30 IPSA', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:50', '2021-02-23 15:54:50', 0, 0);
INSERT INTO `materiales` VALUES (41415, 1, 'REFL-02', 'REFLECTOR DE20 WHATS,CYPERUS II MCA. TECNOLITE', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:50', '2021-02-23 15:54:50', 0, 0);
INSERT INTO `materiales` VALUES (38719, 1, 'REF-200', 'REFLECTOR LED DE 10 WATTS. EN 6500° MCA. TECNOLITE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:50', '2021-02-23 15:54:50', 0, 0);
INSERT INTO `materiales` VALUES (40784, 1, 'REG-01', 'REGISTRO DRO', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:50', '2021-02-23 15:54:50', 0, 0);
INSERT INTO `materiales` VALUES (37894, 1, 'REC-174', 'REIMPRESIONES POR CAMBIO DE DISEÑO DE CATALOGOS', 804, 'PUBLICIDAD', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:50', '2021-02-23 15:54:50', 0, 0);
INSERT INTO `materiales` VALUES (37793, 1, 'REM-250', 'REMOLQUE SEA DOO MOVEI LATAM', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:51', '2021-02-23 15:54:51', 0, 0);
INSERT INTO `materiales` VALUES (37889, 1, 'REA-150', 'RESINA', 794, 'ACABADOS', 'KG', 'KG', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:51', '2021-02-23 15:54:51', 0, 0);
INSERT INTO `materiales` VALUES (38330, 1, 'RSG-100', 'RESINA GRUESA EN LTS.', 794, 'ACABADOS', 'LTO', 'LTO', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:51', '2021-02-23 15:54:51', 0, 0);
INSERT INTO `materiales` VALUES (37814, 1, '', 'RETENCION CONTRA ENTREGA', 819, 'ESTIMACION', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:52', '2021-02-23 15:54:52', 0, 0);
INSERT INTO `materiales` VALUES (41968, 1, 'RETH-38', 'RETENIDA HORIZONTAL DE 38 MM X 3.0 MTS. CAL. 20', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:52', '2021-02-23 15:54:52', 0, 0);
INSERT INTO `materiales` VALUES (40837, 1, 'REV-08', 'REVISION DE PROYECTO', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:52', '2021-02-23 15:54:52', 0, 0);
INSERT INTO `materiales` VALUES (41396, 1, 'ROTO-04', 'ROTOMARTILLO MARCA BOSCH', 25899, 'HERRAMIENTA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:53', '2021-02-23 15:54:53', 0, 0);
INSERT INTO `materiales` VALUES (39355, 1, 'GM-7354', 'ROUTER INALAMBRICO DOBLE BANDA AC, 2.4 GHZ Y 5 GHZ HASTA 1200 MBPS 4 ANTENAS', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:53', '2021-02-23 15:54:53', 0, 0);
INSERT INTO `materiales` VALUES (40078, 1, 'SEG-01', 'SEGUETA HOJA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:53', '2021-02-23 15:54:53', 0, 0);
INSERT INTO `materiales` VALUES (39340, 1, 'GM-00', 'SERVICIO', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:54', '2021-02-23 15:54:54', 0, 0);
INSERT INTO `materiales` VALUES (39743, 1, 'CCTV-02', 'SERVICIO DE CCTV', 808, 'OTROS', 'PIEZAS', 'PIEZAS', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:54', '2021-02-23 15:54:54', 0, 0);
INSERT INTO `materiales` VALUES (38437, 1, '0-092', 'SERVICIO TELEFONICO E INTERNET TASA0', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:54', '2021-02-23 15:54:54', 0, 0);
INSERT INTO `materiales` VALUES (41366, 1, 'SILICO-02', 'SILICON BLANCO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:54', '2021-02-23 15:54:54', 0, 0);
INSERT INTO `materiales` VALUES (38820, 1, 'MO-E03', 'SILLA DE OFICINA MODELO MO-E03 COLOR NEGRO Y BASE CROMO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:55', '2021-02-23 15:54:55', 0, 0);
INSERT INTO `materiales` VALUES (39279, 1, 'SIL-101', 'SILLA DE VISITA MODELO RE790 MCA. REQUIEZ BASE TRINEO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:55', '2021-02-23 15:54:55', 0, 0);
INSERT INTO `materiales` VALUES (41003, 1, 'OH-115', 'SILLA DE VISITA MULTIUSOS MOD-OHV124 EN PVC COLOR BLANCO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:55', '2021-02-23 15:54:55', 0, 0);
INSERT INTO `materiales` VALUES (39285, 1, 'SIL-102', 'SILLA FIJA MULTIUSOS MODELO OHV124', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:55', '2021-02-23 15:54:55', 0, 0);
INSERT INTO `materiales` VALUES (40997, 1, 'AB-119', 'SILLA MULTIUSOS A-200 BASE DE TRINEO CROMADO RESPALDO EN COLOR BLANCO Y ASIENTO EN TAPIZ VINIL GRIS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:55', '2021-02-23 15:54:55', 0, 0);
INSERT INTO `materiales` VALUES (39294, 1, 'SIL-105', 'SILLA OPERATIVA LK07 RESPALDO ERGONOMICO DE MALLA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:55', '2021-02-23 15:54:55', 0, 0);
INSERT INTO `materiales` VALUES (40994, 1, 'AB-118', 'SILLON EJECUTIVO AB-40 EN TAPIZ VINIL MUSHROOM GRIS', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:55', '2021-02-23 15:54:55', 0, 0);
INSERT INTO `materiales` VALUES (39276, 1, 'SIL-100', 'SILLON EJECUTIVO MODELO BM1260', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:55', '2021-02-23 15:54:55', 0, 0);
INSERT INTO `materiales` VALUES (39291, 1, 'SIL-104', 'SILLON INDIVIDUAL NEON MODELO N658', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:55', '2021-02-23 15:54:55', 0, 0);
INSERT INTO `materiales` VALUES (39380, 1, 'SIS-300', 'SISTEMA DE ALARMA HIKVISION INALAMBRICO POR APLICACION HIK CONECT', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:56', '2021-02-23 15:54:56', 0, 0);
INSERT INTO `materiales` VALUES (40466, 1, 'SMOO-2', 'SMOOTH LED 2X8W 3000K', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:56', '2021-02-23 15:54:56', 0, 0);
INSERT INTO `materiales` VALUES (39288, 1, 'SOF-100', 'SOFA CONFORTABLE 3 PLAZAS MODELO AREZZO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:56', '2021-02-23 15:54:56', 0, 0);
INSERT INTO `materiales` VALUES (40463, 1, 'SQ-09', 'SQ 9 FLAST   9 W 100-240V 40BK BC', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:56', '2021-02-23 15:54:56', 0, 0);
INSERT INTO `materiales` VALUES (41335, 1, 'SSD-200', 'SSD M.2 ( DISCO DURO )', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:56', '2021-02-23 15:54:56', 0, 0);
INSERT INTO `materiales` VALUES (40816, 1, 'SUB-06', 'SUBDIVISION', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:56', '2021-02-23 15:54:56', 0, 0);
INSERT INTO `materiales` VALUES (42016, 1, 'SUMIB-6', 'SUMINISTRO E INSTALACION DE BOMBA DE  HP MARCA EVANS', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:57', '2021-02-23 15:54:57', 0, 0);
INSERT INTO `materiales` VALUES (39161, 1, 'SIC-200', 'SUMINISTRO E INSTALACION DE CANCELERIA', 796, 'CANCELERIA', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:57', '2021-02-23 15:54:57', 0, 0);
INSERT INTO `materiales` VALUES (40148, 1, '', 'SUMINISTRO E INSTALACION DE NODO INCLUYE SWITCH', 808, 'OTROS', 'SERVICIO', 'SERVICIO', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:57', '2021-02-23 15:54:57', 0, 0);
INSERT INTO `materiales` VALUES (41169, 1, 'SUMEIN-002', 'SUMINISTRO E INSTALACION DE PASTO TIPO SAN AGUSTIN', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:57', '2021-02-23 15:54:57', 0, 0);
INSERT INTO `materiales` VALUES (41621, 1, 'SUMIPIN-02', 'SUMINISTRO Y APLICACION DE PINTURA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:57', '2021-02-23 15:54:57', 0, 0);
INSERT INTO `materiales` VALUES (41584, 1, 'SUMICOL-02', 'SUMINISTRO Y COLOCACION DE CANCELERIA DE ALUMINIO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:57', '2021-02-23 15:54:57', 0, 0);
INSERT INTO `materiales` VALUES (41594, 1, 'SUMIPELI-02', 'SUMINISTRO Y COLOCACION DE PELICULA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:57', '2021-02-23 15:54:57', 0, 0);
INSERT INTO `materiales` VALUES (41589, 1, 'SUMIPU-02', 'SUMINISTRO Y COLOCACION DE PUERTA DE TAMBOR', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:58', '2021-02-23 15:54:58', 0, 0);
INSERT INTO `materiales` VALUES (41616, 1, 'SUMREJ-02', 'SUMINISTRO Y COLOCACION DE REJA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:58', '2021-02-23 15:54:58', 0, 0);
INSERT INTO `materiales` VALUES (41579, 1, 'SUMI-02', 'SUMINISTRO Y COLOCACION DE TRIPLAY DE MADERA DE PINO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:58', '2021-02-23 15:54:58', 0, 0);
INSERT INTO `materiales` VALUES (41347, 1, 'SUMIPRO-002', 'SUMINISTRO Y PROGRAMACION DE CONTROLES', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:58', '2021-02-23 15:54:58', 0, 0);
INSERT INTO `materiales` VALUES (39349, 1, 'GM-7056', 'SW 24 PUERTOS 10/100/1000 TP LINK NO DMINISTRABLE PARA RACK', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:58', '2021-02-23 15:54:58', 0, 0);
INSERT INTO `materiales` VALUES (37618, 1, 'ACCTAG', 'TAG VEHICULAR', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:58', '2021-02-23 15:54:58', 0, 0);
INSERT INTO `materiales` VALUES (41271, 1, 'TALAD-002', 'TALADRO', 25899, 'HERRAMIENTA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:58', '2021-02-23 15:54:58', 0, 0);
INSERT INTO `materiales` VALUES (37960, 1, 'TAN-918', 'TANQUE ACTIVATE SKU 123918', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:58', '2021-02-23 15:54:58', 0, 0);
INSERT INTO `materiales` VALUES (38557, 1, 'LST-21', 'TAPA DE REGISTRO ENTRADA DE 1 1/2 6X6 38 mm LAMPRO', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:59', '2021-02-23 15:54:59', 0, 0);
INSERT INTO `materiales` VALUES (41716, 1, 'TAP-02', 'TAPA INTERPERIE', 791, 'ELECTRIFICACION', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:59', '2021-02-23 15:54:59', 0, 0);
INSERT INTO `materiales` VALUES (39078, 1, 'TPT-140', 'TAPA PARA TINACO', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:59', '2021-02-23 15:54:59', 0, 0);
INSERT INTO `materiales` VALUES (37963, 1, 'TAZ-917', 'TAZA ACTIVATE SKU 123917', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:54:59', '2021-02-23 15:54:59', 0, 0);
INSERT INTO `materiales` VALUES (38122, 1, 'TEV-200', 'TEAMVIEWER BUSNINESS SUSCRIPCION', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:00', '2021-02-23 15:55:00', 0, 0);
INSERT INTO `materiales` VALUES (42007, 1, 'TECL-4', 'TECLADO Y MOUSE KIT', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:00', '2021-02-23 15:55:00', 0, 0);
INSERT INTO `materiales` VALUES (38222, 1, 'TEFO-1', 'TEE EN FO.FO. BRIDADA DE ( 12\" x 8\" )', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:00', '2021-02-23 15:55:00', 0, 0);
INSERT INTO `materiales` VALUES (42031, 1, 'TICK-6', 'TICKETS FOLIADOS CON 6 PRECORTES DE LIBERACION', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:01', '2021-02-23 15:55:01', 0, 0);
INSERT INTO `materiales` VALUES (39601, 1, 'TPM-200', 'TIERRA PARA MACETA', 808, 'OTROS', 'BULTO', 'BULTO', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:01', '2021-02-23 15:55:01', 0, 0);
INSERT INTO `materiales` VALUES (40104, 1, 'TIJER-02', 'TIJERAS PARA CPVC', 800, 'ACCESORIOS', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:01', '2021-02-23 15:55:01', 0, 0);
INSERT INTO `materiales` VALUES (41387, 1, 'TIJE-02', 'TIJERAS PARA LAMINA', 25899, 'HERRAMIENTA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:01', '2021-02-23 15:55:01', 0, 0);
INSERT INTO `materiales` VALUES (41461, 1, 'TINMAG-02', 'TINTA HP  MAGENTA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:01', '2021-02-23 15:55:01', 0, 0);
INSERT INTO `materiales` VALUES (41458, 1, 'TONAMA-02', 'TINTA HP AMARILLA', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:01', '2021-02-23 15:55:01', 0, 0);
INSERT INTO `materiales` VALUES (41455, 1, 'TIN-02', 'TINTA HP NEGRO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:01', '2021-02-23 15:55:01', 0, 0);
INSERT INTO `materiales` VALUES (37969, 1, 'TIR-100', 'TIRANY GRAY 30X2 ESPESOR CEPILLADO', 794, 'ACABADOS', 'M2', 'M2', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:01', '2021-02-23 15:55:01', 0, 0);
INSERT INTO `materiales` VALUES (39783, 1, 'E-6028N', 'TOMACORRIENTE CON POLO A TIERRA +2 USB BLANCO MCA. MODUS PRO', 791, 'ELECTRIFICACION', 'PZA', 'PZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:01', '2021-02-23 15:55:01', 0, 0);
INSERT INTO `materiales` VALUES (38237, 1, 'TEFO-6', 'TORNILLO CON TCA. MAQUINA DE ( 3/4\" x 3\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:02', '2021-02-23 15:55:02', 0, 0);
INSERT INTO `materiales` VALUES (38231, 1, 'TEFO-4', 'TORNILLO CON TCA. MAQUINA DE ( 3/4\" x 4\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:02', '2021-02-23 15:55:02', 0, 0);
INSERT INTO `materiales` VALUES (38234, 1, 'TEFO-5', 'TORNILLO CON TCA. MAQUINA DE ( 7/8\" x 4\" )', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:02', '2021-02-23 15:55:02', 0, 0);
INSERT INTO `materiales` VALUES (37955, 1, 'TBH-200', 'TRABAJOS DE HERRERIA', 808, 'OTROS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:02', '2021-02-23 15:55:02', 0, 0);
INSERT INTO `materiales` VALUES (38420, 1, 'TRE-100', 'TRABAJOS DE TRANSICION AEREA SUBTERRANEA, EXTENCION DE LINEA SUBTERRANEA PARA ALIMENTAR EQUIPO DE MEDICION EN MEDIA TENSION DE ERASUN', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:02', '2021-02-23 15:55:02', 0, 0);
INSERT INTO `materiales` VALUES (41223, 1, 'TUME-12', 'TUBO METALICO FLEXIBLE TIPO SLDX 1/2 CARRETE', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:03', '2021-02-23 15:55:03', 0, 0);
INSERT INTO `materiales` VALUES (39096, 1, 'H-220', 'TUBO PVC HIDRAULICO DE 3/4\" DE DIAMETRO X 6 MTS DE LARGO', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:03', '2021-02-23 15:55:03', 0, 0);
INSERT INTO `materiales` VALUES (37903, 1, 'TUV-100', 'TUBO TW DE 1\" VERDE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:04', '2021-02-23 15:55:04', 0, 0);
INSERT INTO `materiales` VALUES (38953, 1, 'TUB-112', 'TUBO TW DE 1/2\" VERDE', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:04', '2021-02-23 15:55:04', 0, 0);
INSERT INTO `materiales` VALUES (37915, 1, 'UNI-100', 'UNICANAL SOLIDA 4X4 ESTRUCTURAL CAL. 14 SPORTEK', 791, 'ELECTRIFICACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:04', '2021-02-23 15:55:04', 0, 0);
INSERT INTO `materiales` VALUES (39358, 1, 'GM-7508', 'UPS DE 750 VA 315 WATSS 8 TERNINALES DE SALIDA 4C ON RESPALDO 4 TERMINALES DE SUPRESION DE PICOS', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:04', '2021-02-23 15:55:04', 0, 0);
INSERT INTO `materiales` VALUES (37938, 1, 'URB-500', 'URBANIZACION', 806, 'URBANIZACION', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:04', '2021-02-23 15:55:04', 0, 0);
INSERT INTO `materiales` VALUES (37676, 1, 'UBA-04', 'URBANIZACION ARBOLEDA  ETAPA 4', 806, 'URBANIZACION', 'LOTE', 'LOTE', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:04', '2021-02-23 15:55:04', 0, 0);
INSERT INTO `materiales` VALUES (39031, 1, 'URB-07', 'URBANIZACION MISIONES ETAPA 7', 806, 'URBANIZACION', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:05', '2021-02-23 15:55:05', 0, 0);
INSERT INTO `materiales` VALUES (40809, 1, 'USO-01', 'USO DE SUELO', 808, 'OTROS', 'N/A', 'N/A', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:05', '2021-02-23 15:55:05', 0, 0);
INSERT INTO `materiales` VALUES (38916, 1, 'H-214', 'VALVULA CHECK RESORTE DE 3/4\"', 786, 'HIDRAULICA', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:05', '2021-02-23 15:55:05', 0, 0);
INSERT INTO `materiales` VALUES (41691, 1, 'VALPA-02', 'VALVULA DE PASO 1/2\"', 15165, 'MATERIAL Y MANO DE OBRA', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:05', '2021-02-23 15:55:05', 0, 0);
INSERT INTO `materiales` VALUES (40903, 1, 'VALVIN-01', 'VALVULA INVIERNO', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:05', '2021-02-23 15:55:05', 0, 0);
INSERT INTO `materiales` VALUES (40432, 1, 'VS-A35', 'VS-A35 COFLEX VINILO 1/2 X 7/8 X 35 CM.', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:07', '2021-02-23 15:55:07', 0, 0);
INSERT INTO `materiales` VALUES (39084, 1, 'APD-100', 'WOW ACEITE P/MOP O DUELA', 794, 'ACABADOS', 'PIEZA', 'PIEZA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:07', '2021-02-23 15:55:07', 0, 0);
INSERT INTO `materiales` VALUES (38377, 1, 'SEC-201', 'XG 135 ENTERPRISEGUARD WHIT ENHANCED SUPPORT', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:07', '2021-02-23 15:55:07', 0, 0);
INSERT INTO `materiales` VALUES (38374, 1, 'SEC-200', 'XG 135 REV.3 SECURITY APPLIANCE', 808, 'OTROS', 'NA', 'NA', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:07', '2021-02-23 15:55:07', 0, 0);
INSERT INTO `materiales` VALUES (41950, 1, 'CINT-05', '´CINTILLA PLASTICA DE PRIVACIDAD', 808, 'OTROS', 'PZ', 'PZ', '1', '', '', 'ACTIVO                      ', '2021-02-23 15:55:08', '2021-02-23 15:55:08', 0, 0);

CREATE TABLE `matriz_comisiones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ventas` int(11) DEFAULT NULL,
  `porcentajeVentas` decimal(10,2) DEFAULT NULL,
  `tipoPromotor` varchar(20) DEFAULT NULL COMMENT 'Interno, Externo, Ex-interno',
  `status` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

INSERT INTO `matriz_comisiones` VALUES (1, 1, 2.00, 'Interno', 1, '2021-06-23 13:27:52', '2021-06-23 13:27:52', 5, 5);
INSERT INTO `matriz_comisiones` VALUES (2, 2, 3.00, 'Interno', 1, '2021-06-23 13:27:52', '2021-06-23 13:27:52', 5, 5);
INSERT INTO `matriz_comisiones` VALUES (3, 3, 4.00, 'Interno', 1, '2021-06-23 13:27:52', '2021-06-23 13:27:52', 5, 5);
INSERT INTO `matriz_comisiones` VALUES (4, 4, 4.00, 'Interno', 1, '2021-06-23 13:27:52', '2021-06-23 13:27:52', 5, 5);
INSERT INTO `matriz_comisiones` VALUES (5, 5, 5.00, 'Interno', 1, '2021-06-23 13:27:52', '2021-06-23 13:27:52', 5, 5);
INSERT INTO `matriz_comisiones` VALUES (6, 1, 4.00, 'Externo', 1, '2021-06-23 13:27:52', '2021-06-23 13:27:52', 5, 5);
INSERT INTO `matriz_comisiones` VALUES (7, 1, 3.00, 'Ex-interno', 1, '2021-06-23 13:27:52', '2021-06-23 13:27:52', 5, 5);

CREATE TABLE `movimientos_promotores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `idPromotor` int(11) DEFAULT NULL,
  `cargo` decimal(10,2) DEFAULT NULL,
  `descripcion` varchar(150) DEFAULT NULL,
  `tipo` varchar(50) DEFAULT NULL COMMENT 'Ingresos,Egresos',
  `status` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

CREATE TABLE `orden_compra` (
  `id` int(11) NOT NULL,
  `idEmpresa` int(11) NOT NULL DEFAULT '1',
  `idMaterial` int(11) DEFAULT NULL,
  `idPaquete` int(11) DEFAULT '0',
  `semana` int(11) DEFAULT '0',
  `descripcion` varchar(200) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fecha` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `folio` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `id_proveedor` int(11) DEFAULT NULL,
  `id_almacen` int(11) DEFAULT NULL,
  `id_moneda` int(11) DEFAULT NULL,
  `importe_neto` varchar(20) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `numero_articulos` int(11) DEFAULT NULL,
  `fecha_entrega` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `estatus` varchar(10) COLLATE utf8_spanish2_ci NOT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

CREATE TABLE `orden_compra_viv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idMaterial` int(11) DEFAULT NULL,
  `idPaquete` int(11) DEFAULT '0',
  `semana` int(11) DEFAULT '0',
  `descripcion` varchar(200) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fecha` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `folio` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `id_proveedor` int(11) DEFAULT NULL,
  `id_almacen` int(11) DEFAULT NULL,
  `id_moneda` int(11) DEFAULT NULL,
  `importe_neto` varchar(20) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `numero_articulos` int(11) DEFAULT NULL,
  `fecha_entrega` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `estatus` varchar(10) COLLATE utf8_spanish2_ci NOT NULL,
  `status` tinyint(1) DEFAULT '1',
  `status_ws` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

CREATE TABLE `presupuesto_mat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idMaterial` int(11) DEFAULT NULL,
  `idMateriales` int(11) DEFAULT NULL,
  `idProveedor` int(11) DEFAULT NULL,
  `precioUnitario` decimal(11,2) DEFAULT NULL,
  `importe` decimal(11,2) DEFAULT NULL,
  `semana` int(11) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

CREATE TABLE `programa_obra` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idPresupuesto` int(11) DEFAULT NULL,
  `semana` int(11) DEFAULT NULL,
  `lote` varchar(20) DEFAULT NULL,
  `manzana` varchar(20) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `proveedores` (
  `id` int(11) NOT NULL,
  `idEmpresa` int(11) DEFAULT '1',
  `nombre` varchar(100) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `clave` varchar(30) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `contacto1` varchar(30) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `contacto2` varchar(30) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `rfc` varchar(25) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `moneda_id` int(11) DEFAULT NULL,
  `moneda` varchar(20) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `ciudad_id` int(11) DEFAULT NULL,
  `ciudad` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `cp` varchar(10) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `telefono1` varchar(30) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `telefono2` varchar(30) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `estatus` varchar(30) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

INSERT INTO `proveedores` VALUES (22828, 1, '1100 ARQUITECTURA SADE CV', '', '', '', 'ARQ160205NB5', 1, 'Moneda nacional', 307, 'TORREON', '27140', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:37:59', '2020-10-19 10:37:59', 5, 5);
INSERT INTO `proveedores` VALUES (28477, 1, '4G ADD GROUP S.A. DE C.V.', '', '', '', 'CGA030311CZ7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:37:59', '2020-10-19 10:37:59', 5, 5);
INSERT INTO `proveedores` VALUES (19266, 1, 'ABA SEGUROS, S.A. DE C.V.', '', '', '', 'ABA 920310QW0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:37:59', '2020-10-19 10:37:59', 5, 5);
INSERT INTO `proveedores` VALUES (417, 1, 'ABASTECEDORES ELECTROMECANICOS DEL NORTE S.A.', '', 'Luz Galarza', '', 'AEM8202034B1', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35078', '871 175 03 00', '', 'luz.galarza@aemnsa.com.mx;mailto:hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx,averdin@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:37:59', '2020-10-19 10:37:59', 5, 5);
INSERT INTO `proveedores` VALUES (27842, 1, 'ABASTEHOGAR COMERCIALIZADORA SA DE CV', '', '', '', 'ACO131107ML1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:00', '2020-10-19 10:38:00', 5, 5);
INSERT INTO `proveedores` VALUES (31550, 1, 'ABDEL HALIM GOMEZ SERRANO', '', '', '', 'GOSA810105UV9', 1, 'Moneda nacional', 307, 'TORREON', '27110', '', '', 'rayo_9106@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:00', '2020-10-19 10:38:00', 5, 5);
INSERT INTO `proveedores` VALUES (591, 1, 'ABRAHAM GARCIA LAURA', '', '', '', 'AAGL850129F45', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'docuprint.juarez@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:00', '2020-10-19 10:38:00', 5, 5);
INSERT INTO `proveedores` VALUES (485, 1, 'ACOSTA DELGADO FERNANDO DANIEL', '', '', '', 'AODF830923SW8', 1, 'Moneda nacional', 307, 'TORREON', '27297', '8717250505', '', 'fdo.firsa@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:00', '2020-10-19 10:38:00', 5, 5);
INSERT INTO `proveedores` VALUES (21467, 1, 'ADMINISTRACION FISCAL GENERAL DEL ESTADO DE COAHUILA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:00', '2020-10-19 10:38:00', 5, 5);
INSERT INTO `proveedores` VALUES (23861, 1, 'ADMINISTRACION GENERAL DE RECAUDACION', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:00', '2020-10-19 10:38:00', 5, 5);
INSERT INTO `proveedores` VALUES (24168, 1, 'ADRIANA ROSALES ANDRADE', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:00', '2020-10-19 10:38:00', 5, 5);
INSERT INTO `proveedores` VALUES (26960, 1, 'AEMNSA EXPRESS SA DE CV', '', '8711750300', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:00', '2020-10-19 10:38:00', 5, 5);
INSERT INTO `proveedores` VALUES (36496, 1, 'AGRICULTURA URBANA EL HUERTITO S.P.R. DE R.L. DE C.V.', '', '', '', 'AUH130606FI1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '8717169647', 'elhuertito@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:00', '2020-10-19 10:38:00', 5, 5);
INSERT INTO `proveedores` VALUES (491, 1, 'AISLANTES TERMOACUSTICOS DEL NORTE SA DE CV', '', '', '', 'ATN040701896', 1, 'Moneda nacional', 307, 'TORREON', '27280', '7322411', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:01', '2020-10-19 10:38:01', 5, 5);
INSERT INTO `proveedores` VALUES (23426, 1, 'ALAMO LAGUNA SA DE CV', '', '', '', 'ALA950714UJ7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:01', '2020-10-19 10:38:01', 5, 5);
INSERT INTO `proveedores` VALUES (34153, 1, 'ALAYZA ESCARLETH MEJIA VILLEGAS ', '', '', '', 'MEVA871011H50', 1, 'Moneda nacional', 307, 'TORREON', '27277', '', '', 'mmantenimientoyconstrucciones@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:01', '2020-10-19 10:38:01', 5, 5);
INSERT INTO `proveedores` VALUES (21122, 1, 'ALEJANDRA PUENTES OLMOS', '', '', '', 'SED130108HY4', 1, 'Moneda nacional', 307, 'TORREON', '27060', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:01', '2020-10-19 10:38:01', 5, 5);
INSERT INTO `proveedores` VALUES (25794, 1, 'ALEJANDRA SALAS LUNA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', 'gestoria@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:01', '2020-10-19 10:38:01', 5, 5);
INSERT INTO `proveedores` VALUES (34292, 1, 'ALL STEEL LAGUNA, SA DE CV', '', '', '', 'ASL160916N89', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35017', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:01', '2020-10-19 10:38:01', 5, 5);
INSERT INTO `proveedores` VALUES (30273, 1, 'ALONDRA NAZARETH CORDERO GOMEZ', '', '', '', 'COGA980607HW9', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:01', '2020-10-19 10:38:01', 5, 5);
INSERT INTO `proveedores` VALUES (531, 1, 'ALTO PROTECCION INTEGRAL SA DE CV', '', '', '', 'API0508041E8', 1, 'Moneda nacional', 307, 'TORREON', '27268', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:01', '2020-10-19 10:38:01', 5, 5);
INSERT INTO `proveedores` VALUES (26643, 1, 'ALUMINIOS FERHER SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 311, 'MONTERREY', '66060', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:02', '2020-10-19 10:38:02', 5, 5);
INSERT INTO `proveedores` VALUES (711, 1, 'AMADOR LOZANO ESCOBEDO', '', '', '', 'LOEA660720AM1', 1, 'Moneda nacional', 307, 'TORREON', '35150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:02', '2020-10-19 10:38:02', 5, 5);
INSERT INTO `proveedores` VALUES (25169, 1, 'ANA GABRIELA ROSALES LONGORIA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:02', '2020-10-19 10:38:02', 5, 5);
INSERT INTO `proveedores` VALUES (21142, 1, 'ANDREA PATRICIA RUIZ GARCIA', '', '', '', 'RUGA941006M50', 1, 'Moneda nacional', 310, 'LERDO', '35158', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:02', '2020-10-19 10:38:02', 5, 5);
INSERT INTO `proveedores` VALUES (741, 1, 'ANDRES II CAVAZOS CHAPA', '', '', '', 'CACX810623C61', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '64880', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:02', '2020-10-19 10:38:02', 5, 5);
INSERT INTO `proveedores` VALUES (28780, 1, 'ANDRES MORENO SANDOVAL ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:02', '2020-10-19 10:38:02', 5, 5);
INSERT INTO `proveedores` VALUES (770, 1, 'ANTULIO VILLARREAL SANCHEZ ', '', '', '', 'VISA690619DC3', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:03', '2020-10-19 10:38:03', 5, 5);
INSERT INTO `proveedores` VALUES (449, 1, 'ANTUNA LOPEZ REBECA', '', 'TONY VIVERO', '', 'AULR420927 T4A', 1, 'Moneda nacional', 310, 'LERDO', '35150', '725-21-12', '', 'viverosanisidro.facturas@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:03', '2020-10-19 10:38:03', 5, 5);
INSERT INTO `proveedores` VALUES (517, 1, 'ARELLANO MORA ENRIQUE', '', 'CP DAVID DELGADO', '', 'AEME710309S50', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8711432875', '', 'administracion@hergus.com', 'ACTIVO    ', 1, '2020-10-19 10:38:03', '2020-10-19 10:38:03', 5, 5);
INSERT INTO `proveedores` VALUES (33864, 1, 'ARTICULOS MILITARES Y POLICIACOS', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27274', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:03', '2020-10-19 10:38:03', 5, 5);
INSERT INTO `proveedores` VALUES (31161, 1, 'ARTURO FLORES GUADARRAMA', '', '', '', 'FOGA870505GK8', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:03', '2020-10-19 10:38:03', 5, 5);
INSERT INTO `proveedores` VALUES (742, 1, 'ARTURO RUIZ AGUIRRE', '', '', '', 'ruaa860917ry2', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27275', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:03', '2020-10-19 10:38:03', 5, 5);
INSERT INTO `proveedores` VALUES (29243, 1, 'ASESORIA, DISEÑO Y CALCULO ESTRUCTURA', '', '', '', 'ADC160407SA9', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'afuentes@adyce.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:03', '2020-10-19 10:38:03', 5, 5);
INSERT INTO `proveedores` VALUES (31766, 1, 'ASOCIACION MEXICANA DE PROFESIONALES INMOBILIARIOS AC', '', '', '', 'XAXA010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:03', '2020-10-19 10:38:03', 5, 5);
INSERT INTO `proveedores` VALUES (23767, 1, 'AUTOMOTORES DE LA LAGUNA, S.A. DE C.V.', '', '7472700', '', 'ALA021016AS2', 1, 'Moneda nacional', 307, 'TORREON', '27010', '7472727', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:03', '2020-10-19 10:38:03', 5, 5);
INSERT INTO `proveedores` VALUES (605, 1, 'AUTOS ALAMEDA SA DE CV', '', 'RICARDO D ELA CRUZ', '', 'AAL8007311N8', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '7147020 EXT 135', '', 'caja@nissangomezpalacio.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:04', '2020-10-19 10:38:04', 5, 5);
INSERT INTO `proveedores` VALUES (25666, 1, 'AVALUOS Y ASOCIADOS, S.A. DE C.V.', '', '7110846', '2954671', 'AAS111209LM8', 1, 'Moneda nacional', 307, 'TORREON', '27130', '7130324', '', 'almaguer.aya@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:04', '2020-10-19 10:38:04', 5, 5);
INSERT INTO `proveedores` VALUES (19587, 1, 'AXA SEGUROS, S.A. DE C.V.', '', '', '', 'ASE 931116 231', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '03200', '759 05 04', '759 05 00', '', 'ACTIVO    ', 1, '2020-10-19 10:38:04', '2020-10-19 10:38:04', 5, 5);
INSERT INTO `proveedores` VALUES (461, 1, 'AXTEL S.A.B. DE C.V.', '', '', '', 'AXT940727FP8', 1, 'Moneda nacional', 313, 'SALTILLO', '66215', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:04', '2020-10-19 10:38:04', 5, 5);
INSERT INTO `proveedores` VALUES (437, 1, 'AYALA VALDEZ ROMAN HORACIO', '', '', '', '', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '7146073', '8711189739', 'r.ayala@masingserv.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:04', '2020-10-19 10:38:04', 5, 5);
INSERT INTO `proveedores` VALUES (539, 1, 'AZULBLUE SA DE CV', '', 'ERIKA', '', 'AZU121212FE4', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8717105770', '', 'erika@azulblue.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:04', '2020-10-19 10:38:04', 5, 5);
INSERT INTO `proveedores` VALUES (24806, 1, 'BANCO MERCANTIL DEL NORTE S.A.', '', '', '', 'BMN930209927', 1, 'Moneda nacional', 311, 'MONTERREY', '64830', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:05', '2020-10-19 10:38:05', 5, 5);
INSERT INTO `proveedores` VALUES (616, 1, 'BARRAZA ARAIZA ROGELIO', '', 'ROGELIO BARRAZA', '', 'BAAR551207B15', 1, 'Moneda nacional', 307, 'TORREON', '27250', '8711749571', '8711749583', 'r_barrazas@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:05', '2020-10-19 10:38:05', 5, 5);
INSERT INTO `proveedores` VALUES (561, 1, 'BARRAZA BARRON AMADO', '', 'AMADO BARRON BARRAZA', '', 'BABA7801028B0', 1, 'Moneda nacional', 310, 'LERDO', '35150', '7250445', '', 'automotrizbarraza@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:05', '2020-10-19 10:38:05', 5, 5);
INSERT INTO `proveedores` VALUES (473, 1, 'BARRON HERNANDEZ PABLO', '', 'CONRRADO', '', 'BAHP660615 TL7', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:05', '2020-10-19 10:38:05', 5, 5);
INSERT INTO `proveedores` VALUES (755, 1, 'BELLENIT SA DE CV', '', '', '', 'BEL140109BN5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27010', '7370100', '', 'margaritayadani@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:05', '2020-10-19 10:38:05', 5, 5);
INSERT INTO `proveedores` VALUES (535, 1, 'BELLO MENDOZA CARLOS DAVID', '', 'CAROLINA', '', 'BEMC830327RH3', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7930076', '', 'carolina@dissolver.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:05', '2020-10-19 10:38:05', 5, 5);
INSERT INTO `proveedores` VALUES (26574, 1, 'BERTHA ROCHA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:05', '2020-10-19 10:38:05', 5, 5);
INSERT INTO `proveedores` VALUES (25409, 1, 'BEST BUY', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 21664, 'MEXICO D.F', '78501', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:05', '2020-10-19 10:38:05', 5, 5);
INSERT INTO `proveedores` VALUES (19597, 1, 'BEST BUY STORES S. DE R.L. DE C.V.', '', '', '', 'BBS070606D33', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:06', '2020-10-19 10:38:06', 5, 5);
INSERT INTO `proveedores` VALUES (26985, 1, 'BRENDA LUNA INFANTE ', '', '', '', 'LUIB600810KW2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:06', '2020-10-19 10:38:06', 5, 5);
INSERT INTO `proveedores` VALUES (33200, 1, 'CADENA COMERCIAL OXXO SA DE CV', '', '', '', 'CCO8605231N4', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:06', '2020-10-19 10:38:06', 5, 5);
INSERT INTO `proveedores` VALUES (679, 1, 'CAFE SIRENA S DE RL DE CV ', '', '', '', 'CSI020226MV4', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '06600', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:06', '2020-10-19 10:38:06', 5, 5);
INSERT INTO `proveedores` VALUES (745, 1, 'CAFI FERRELECTRICO SA DE CV', '', '', '', '', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27050', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:06', '2020-10-19 10:38:06', 5, 5);
INSERT INTO `proveedores` VALUES (523, 1, 'CALVILLO HERNANDEZ CESAR', '', 'CESAR CALVILLO', '', 'CAHC691224RY5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35026', '', '', 'cesa19@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:07', '2020-10-19 10:38:07', 5, 5);
INSERT INTO `proveedores` VALUES (644, 1, 'CAMARA MEXICANA DE LA INDUSTRIA DE LA CONSTRUCCION', '', '', '', 'CMI970416U95', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:07', '2020-10-19 10:38:07', 5, 5);
INSERT INTO `proveedores` VALUES (15147, 1, 'CAMARA NACIONAL DE LA INDUSTRIA DE DESARROLLO Y PROMOCION DE VIVIENDA', '', '', '', 'CNI020510K24', 1, 'Moneda nacional', 306, 'LERDO', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:07', '2020-10-19 10:38:07', 5, 5);
INSERT INTO `proveedores` VALUES (27875, 1, 'CAMARA NACIONAL DE LA INDUSTRIA DE RESTAURANTES Y ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:07', '2020-10-19 10:38:07', 5, 5);
INSERT INTO `proveedores` VALUES (577, 1, 'CANADEVI TORREON', '', '', 'LAURA WOO', 'CNI020510K24', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7223525', '', 'admonlaguna@canadevi.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:07', '2020-10-19 10:38:07', 5, 5);
INSERT INTO `proveedores` VALUES (22184, 1, 'CANAL XXI SA DE CV', '', '', '', 'CXX980325UF6', 1, 'Moneda nacional', 21664, 'MEXICO D.F', '1210', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:07', '2020-10-19 10:38:07', 5, 5);
INSERT INTO `proveedores` VALUES (511, 1, 'CANDELA ENRIQUEZ JOSEFINA', '', '', '', 'CAEJ700803AJ3', 1, 'Moneda nacional', 310, 'LERDO', '35167', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:08', '2020-10-19 10:38:08', 5, 5);
INSERT INTO `proveedores` VALUES (29754, 1, 'CANTERAS PORTOFINO, SA DE CV', '', '', '', 'CPO120424IM8', 1, 'Moneda nacional', 307, 'TORREON', '27018', '8711821110', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:08', '2020-10-19 10:38:08', 5, 5);
INSERT INTO `proveedores` VALUES (18640, 1, 'CAP CONTADORES PUBLICOS Y ABOGADOS, SC.', '', 'C.P. SALVADOR CASTAÑEDA', '', 'CCP1509193W7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:08', '2020-10-19 10:38:08', 5, 5);
INSERT INTO `proveedores` VALUES (24774, 1, 'CAPACIDAD DE MEXICO SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', 'tmartinez@sieteleguas.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:08', '2020-10-19 10:38:08', 5, 5);
INSERT INTO `proveedores` VALUES (20617, 1, 'CARLOS ABELARDO GONZALEZ CAMPOS', '', '', '', 'GOCC490226565', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:08', '2020-10-19 10:38:08', 5, 5);
INSERT INTO `proveedores` VALUES (19900, 1, 'CARLOS ANDRES JACQUEZ CAMPOS', '', '', '', 'JACC791220GA7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:09', '2020-10-19 10:38:09', 5, 5);
INSERT INTO `proveedores` VALUES (33543, 1, 'CARLOS ESPARZA LIRA ', '', '', '', 'EALC680820H35', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'cesparza_lira@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:09', '2020-10-19 10:38:09', 5, 5);
INSERT INTO `proveedores` VALUES (20949, 1, 'CARLOS IBARRA CAMACHO', '', '', '', 'IACC2907292A4', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:09', '2020-10-19 10:38:09', 5, 5);
INSERT INTO `proveedores` VALUES (22178, 1, 'CARLOS ROBERTO MUÑOZ ROSALES', '', '', '', 'MURC7206078NA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:09', '2020-10-19 10:38:09', 5, 5);
INSERT INTO `proveedores` VALUES (29734, 1, 'CARLOS VALERO GONZALEZ', '', '', '', 'VAGC7810097V2', 1, 'Moneda nacional', 311, 'MONTERREY', '64610', '', '', 'yakartagerencia@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:09', '2020-10-19 10:38:09', 5, 5);
INSERT INTO `proveedores` VALUES (29638, 1, 'CARMEN ELENA HERNANDEZ RABELO', '', '', '', 'HERC851213E72', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:09', '2020-10-19 10:38:09', 5, 5);
INSERT INTO `proveedores` VALUES (37025, 1, 'CAROLINA MUÑOZ URIBE', '', '', '', 'MUUC890926KX6', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:10', '2020-10-19 10:38:10', 5, 5);
INSERT INTO `proveedores` VALUES (427, 1, 'CASA DEL PLOMERO DE GOMEZ PALACIO SA DE CV', '', '', '', 'CPG9103048R2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '871 714 06 00', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:10', '2020-10-19 10:38:10', 5, 5);
INSERT INTO `proveedores` VALUES (27941, 1, 'CASA GAIA', '', '', '', 'PDE140513FR0', 1, 'Moneda nacional', 311, 'MONTERREY', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:10', '2020-10-19 10:38:10', 5, 5);
INSERT INTO `proveedores` VALUES (551, 1, 'CASTAÑEDA NENE JUAN JORGE', '', 'ISABEL BECERRA', '', 'CANJ620315JX0', 1, 'Moneda nacional', 307, 'TORREON', '27170', '', '', 'cofiscal_isabel@yahoo.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:10', '2020-10-19 10:38:10', 5, 5);
INSERT INTO `proveedores` VALUES (17827, 1, 'CASTRUITA TORRES FRANCISCO JAVIER ', '', '', '', '', 1, 'Moneda nacional', 310, 'LERDO', '35000', '8713662928', '', 'paco_castorr@hotmail.com;compras@sali.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:11', '2020-10-19 10:38:11', 5, 5);
INSERT INTO `proveedores` VALUES (543, 1, 'CELSA IMPRESOS SA DE CV', '', 'BLANCA MUÑOZ', '', 'CIM0412013B4', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35070', '(871)1591135', '', 'bmunoz@celsaimpresos.com.mx;hsalinas@viviend.mx;compas@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:11', '2020-10-19 10:38:11', 5, 5);
INSERT INTO `proveedores` VALUES (359, 1, 'CEMEX CONCRETOS SA DE CV', '', 'GLORIA HERNANDEZ', '', 'CCO7409189M1', 1, 'Moneda nacional', 311, 'MONTERREY', '64000', '8183283000', '', 'gloriairene.hernandez@cemex.com;averdin@viviend.mx;almacen@viviend.mx;compras@viviend.mx;hsalinas@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:11', '2020-10-19 10:38:11', 5, 5);
INSERT INTO `proveedores` VALUES (20337, 1, 'CENTRO LLANTERO ROYAL, S.A. DE C.V.', '', '', '', 'CLR891025JT7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27100', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:11', '2020-10-19 10:38:11', 5, 5);
INSERT INTO `proveedores` VALUES (35512, 1, 'CESAR OMAR LOZANO MONTIEL', '', '', '', 'LOMC6610124Z3', 1, 'Moneda nacional', 307, 'TORREON', '27440', '', '', 'cesar_lozano1210@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:11', '2020-10-19 10:38:11', 5, 5);
INSERT INTO `proveedores` VALUES (25285, 1, 'CFE DISTRIBUCION ', '', '', '', 'CDI160330RC9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:11', '2020-10-19 10:38:11', 5, 5);
INSERT INTO `proveedores` VALUES (529, 1, 'CFE SUMINISTRADOR DE SERVICIOS BÁSICOS', '', '', '', 'CSS160330CP7', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '06600', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:11', '2020-10-19 10:38:11', 5, 5);
INSERT INTO `proveedores` VALUES (27808, 1, 'CHRISTIAN NEFTALI MIRAMONTES LOZANO', '', '', '', 'MILC7802189L2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8711438931', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:11', '2020-10-19 10:38:11', 5, 5);
INSERT INTO `proveedores` VALUES (21703, 1, 'CHUBB SEGUROS MEXICO S.A', '', '', '', 'ASE901221SM4', 1, 'Moneda nacional', 21664, 'MEXICO D.F', '06600', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:12', '2020-10-19 10:38:12', 5, 5);
INSERT INTO `proveedores` VALUES (25350, 1, 'CI TRANSPORTS SA DE CV', '', '', '', 'CTR161021IW8', 1, 'Moneda nacional', 307, 'TORREON', '27018', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:12', '2020-10-19 10:38:12', 5, 5);
INSERT INTO `proveedores` VALUES (25557, 1, 'CIA. EDITORIAL DE LA LAGUNA SA DE CV', '', '', '', 'ELA2508203L8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:12', '2020-10-19 10:38:12', 5, 5);
INSERT INTO `proveedores` VALUES (28790, 1, 'CITY HOMES SA DE CV ', '', '', '', 'CHO0612182EA', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:12', '2020-10-19 10:38:12', 5, 5);
INSERT INTO `proveedores` VALUES (25197, 1, 'CLARA ERNESTINA RIOS MORALES', '', '', '', 'RIMC800107PV9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:12', '2020-10-19 10:38:12', 5, 5);
INSERT INTO `proveedores` VALUES (18150, 1, 'CLAUDIA CONTRERAS GOMEZ ', '', '', '', '', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:12', '2020-10-19 10:38:12', 5, 5);
INSERT INTO `proveedores` VALUES (28096, 1, 'CLEAN SHOP S DE RL DE CV', '', '', '', 'CSH130523BM0', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:12', '2020-10-19 10:38:12', 5, 5);
INSERT INTO `proveedores` VALUES (26747, 1, 'CO EX LA', '', '7 13 40 84', '', 'XAXA010101000', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', 'ventas@coexla.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:12', '2020-10-19 10:38:12', 5, 5);
INSERT INTO `proveedores` VALUES (26741, 1, 'COEXLA SA DE CV ', '', '', '', 'COE120424325', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:12', '2020-10-19 10:38:12', 5, 5);
INSERT INTO `proveedores` VALUES (691, 1, 'COLEGIO DE INGENIEROS CIVILES DE LA LAGUNA AC', '', '', '', 'CIC7310192J0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35078', '7-19-08-62', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (31479, 1, 'COMBUSTIBLES Y GASES DE TORREON S.A. DE C.V.', '', '', '', 'CGT980424CX8', 1, 'Moneda nacional', 307, 'TORREON', '27019', '8717505901', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (33229, 1, 'COMERCIALIZADORA ARISA, S.A. DE C.V.', '', '', '', 'CAR940706MU9', 1, 'Moneda nacional', 307, 'TORREON', '', '871) 7133830', '', 'omercializadoraarisa@yahoo.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (709, 1, 'COMERCIALIZADORA DE PRODUCTOS SUSTENTABLES GARZA SA DE CV', '', 'DIANA MENDOZA', '', 'CPS-110124-DN7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '64108', '8147370137', '83736737', 'proyectos@comercializadoragarza.com.mx>', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (501, 1, 'COMERCIALIZADORA DE SUMINISTROS DEL NORTE SA DE CV', '', '', '', 'CSN9608217C9', 1, 'Moneda nacional', 307, 'TORREON', '27089', '7216000', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (27731, 1, 'COMERCIALIZADORA OLHMAN SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (403, 1, 'COMERCIALIZADORA PASA EXPORT TORREON SA DE CV', '', '', '', 'CPE 970313 TPA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '871 713 60 80', '', 'psatorreon@prodigy.net.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (19406, 1, 'COMPAÑIA PAPELERA DEL NAZAS, S.A. DE C.V.', '', '', '', 'PNA9409147L0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (733, 1, 'CONRRADO MACIEL BARRAZA', '', '', '', 'MABC820402R31', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '7250326', '', 'averdin@viviend.mx;almacen@viviend.mx;compras@viviend.mx;hsalinas@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (31807, 1, 'CONSTRUCTORA Y CONSULTORA SA DE CV', '', '', '', 'CCO990302GGA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (587, 1, 'CONSTRUCTORA Y ESTRUCTURAS LAGUNA SA DE CV', '', '', 'NATIVIDAD IBARRA', 'CEL100622 3C4', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8717113839', '', 'cyelsatorreon@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (571, 1, 'CONSULTORES SALAS Y ASOCIADOS', '', 'CP PEREZ', '', 'CSA041229BB3', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7938003', '8712345713', 'antonio_perez2005@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:13', '2020-10-19 10:38:13', 5, 5);
INSERT INTO `proveedores` VALUES (469, 1, 'CONTEMPORANI SA DE CV', '', 'NORMA CHANTACA', '', 'CON911002304', 1, 'Moneda nacional', 311, 'MONTERREY', '66220', '(81)83785596 EXT 106', '8112143739', 'mayoreo@contemporani.com', 'ACTIVO    ', 1, '2020-10-19 10:38:14', '2020-10-19 10:38:14', 5, 5);
INSERT INTO `proveedores` VALUES (638, 1, 'CONTRERAS CALDERON MARIA TRINIDAD', '', 'DIEGO LEMUS', '', 'COCT660728PN1', 1, 'Moneda nacional', 307, 'TORREON', '27446', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:14', '2020-10-19 10:38:14', 5, 5);
INSERT INTO `proveedores` VALUES (648, 1, 'COPRA CONSTRUCICONES Y PROYECTOS ARQUITECTONICOS SA DE CV ', '', '', '', 'CCP101210LB9', 1, 'Moneda nacional', 307, 'TORREON', '27020', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:14', '2020-10-19 10:38:14', 5, 5);
INSERT INTO `proveedores` VALUES (519, 1, 'CORONADO AGUIRRE LUCILA', '', 'Lucila', '', 'COAL7811178G7', 1, 'Moneda nacional', 307, 'TORREON', '27087', '7314396', '8711998237', 'marmol_juarez@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:14', '2020-10-19 10:38:14', 5, 5);
INSERT INTO `proveedores` VALUES (439, 1, 'CORPORACION PRODECO S.A. de C.V.', '', 'ERNESTO MARTELL', '', 'CPR090611 4RA', 1, 'Moneda nacional', 307, 'TORREON', '27100', '747 28 00', '', 'ermartell@prodeco.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:14', '2020-10-19 10:38:14', 5, 5);
INSERT INTO `proveedores` VALUES (453, 1, 'CORPORATIVO DE NEGOCIOS Y ASESORIAS EMPRESARIALES SA DE CV', '', 'ALEJANDRO LOPEZ', '', 'CNA101018 SE9', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '03300', '', '', 'alelopez@manopco.com', 'ACTIVO    ', 1, '2020-10-19 10:38:14', '2020-10-19 10:38:14', 5, 5);
INSERT INTO `proveedores` VALUES (607, 1, 'CORRAL MELERO MARA MAGDALENA', '', 'EDUARDO RIOS', '', 'COMM6409257Z7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35049', '7191985', '', 'eliseo.isaias@madereriarealdelpino.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:14', '2020-10-19 10:38:14', 5, 5);
INSERT INTO `proveedores` VALUES (34716, 1, 'COSTCO DE MEXICO SA DE CV', '', '', '', 'CME910715UB9', 1, 'Moneda nacional', 311, 'MONTERREY', '64989', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:15', '2020-10-19 10:38:15', 5, 5);
INSERT INTO `proveedores` VALUES (29882, 1, 'CRISTINA ISABEL  SOLIS ROMAN', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:15', '2020-10-19 10:38:15', 5, 5);
INSERT INTO `proveedores` VALUES (21283, 1, 'CRISTINA MARTINEZ REYES', '', '', '', 'MARC871211TU2', 1, 'Moneda nacional', 307, 'TORREON', '27148', '', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;kmarin@viviend.mx;rnavarro@viviend.mx;cristy_amu2901@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:15', '2020-10-19 10:38:15', 5, 5);
INSERT INTO `proveedores` VALUES (27577, 1, 'CYNTHIA LIZZETH BAZAN BARRERA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'delnorteneon@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:15', '2020-10-19 10:38:15', 5, 5);
INSERT INTO `proveedores` VALUES (481, 1, 'DAC ACCESORIOS PARA LA CONSTRUCCION SA DE CV', '', 'JUAN CARLOS FLORES', '', 'DAC091109DB7', 1, 'Moneda nacional', 315, 'ESTADO DE MEXICO', '03940', '', '', 'jcflores@ftpmexico.com', 'ACTIVO    ', 1, '2020-10-19 10:38:15', '2020-10-19 10:38:15', 5, 5);
INSERT INTO `proveedores` VALUES (463, 1, 'DAGOBERTO DE LA O FAVILA', '', 'GABRIELA IBARRA', '', '', 1, 'Moneda nacional', 307, 'TORREON', '27100', '192 0892', '', 'gabrielaibarra92@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:15', '2020-10-19 10:38:15', 5, 5);
INSERT INTO `proveedores` VALUES (30754, 1, 'DANIEL ALEJANDRO MORADO ACOSTA', '', '', '', 'MOAD821211VC5', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:15', '2020-10-19 10:38:15', 5, 5);
INSERT INTO `proveedores` VALUES (25494, 1, 'DANIEL BECERRA ROCHA', '', '', '', 'BERD9002121L2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:16', '2020-10-19 10:38:16', 5, 5);
INSERT INTO `proveedores` VALUES (27077, 1, 'DANIEL SANDOVAL ORTIZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27274', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:16', '2020-10-19 10:38:16', 5, 5);
INSERT INTO `proveedores` VALUES (735, 1, 'DANIELA JAQUELINE  SOLIS GUEVARA ', '', '', '', 'SOGD810818R35', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:16', '2020-10-19 10:38:16', 5, 5);
INSERT INTO `proveedores` VALUES (22144, 1, 'DANTE JAVIER LOPEZ ESPINOZA', '', '', '', 'LOED820628RZ9', 1, 'Moneda nacional', 307, 'TORREON', '27110', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:16', '2020-10-19 10:38:16', 5, 5);
INSERT INTO `proveedores` VALUES (21045, 1, 'DAVID RODRIGUE AYALA', '', '', '', 'ROAD790213PD5', 1, 'Moneda nacional', 310, 'LERDO', '35155', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:16', '2020-10-19 10:38:16', 5, 5);
INSERT INTO `proveedores` VALUES (487, 1, 'DAVILA MONTALVO JOSE ANGEL', '', 'Jose Angel Davila', '', '', 1, 'Moneda nacional', 307, 'TORREON', '27280', '713-37-83', '', 'josangel832@yahoo.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:16', '2020-10-19 10:38:16', 5, 5);
INSERT INTO `proveedores` VALUES (22739, 1, 'DELEGACION NUEVO LEON', '', '', '', 'CNI020510K24', 1, 'Moneda nacional', 311, 'MONTERREY', '64000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:16', '2020-10-19 10:38:16', 5, 5);
INSERT INTO `proveedores` VALUES (457, 1, 'DELTA BLOCK DE LA LAGUNA, S.A. DE C.V.', '', 'FRANCISCO CHAVEZ', '', 'DBL890619SK4', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '719-03-22', '', 'deltablocklaguna@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:16', '2020-10-19 10:38:16', 5, 5);
INSERT INTO `proveedores` VALUES (630, 1, 'DESARROLLOS E INFRAESTRUCTURA GLOBAL SA DE CV ', '', 'EDUARDO GAMMA', '', 'DEI090131DL6', 1, 'Moneda nacional', 307, 'TORREON', '27100', '2-03-68-55', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:16', '2020-10-19 10:38:16', 5, 5);
INSERT INTO `proveedores` VALUES (27331, 1, 'DIEGO EMILIANO ALBARRAN TURRADO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 320, 'GUADALAJARA', '45400', '', '', 'eltamarindotonala@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:16', '2020-10-19 10:38:16', 5, 5);
INSERT INTO `proveedores` VALUES (351, 1, 'DIESEL Y GASOLINA DE LA LAGUNA SA DE CV', '', 'PERLA', '', 'DGL9910268Q3', 1, 'Moneda nacional', 307, 'TORREON', '27019', '7502222', '', 'servicioaclientes@migasolina.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:17', '2020-10-19 10:38:17', 5, 5);
INSERT INTO `proveedores` VALUES (20343, 1, 'DISEÑO ECLECTICO MODERNO SA DE CV', '', '', '', 'DEM130828QL8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '64320', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:17', '2020-10-19 10:38:17', 5, 5);
INSERT INTO `proveedores` VALUES (407, 1, 'DISTRIBUCIONES INDUSTRIALES CUERDA SA DE CV', '', 'SOL PAULINA', '', 'DIC860228NXA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '871 732 70 00', '', 'mkt@cuerda.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:17', '2020-10-19 10:38:17', 5, 5);
INSERT INTO `proveedores` VALUES (738, 1, 'DISTRIBUIDOR SOLTRACK LAGUNA SA DE CV', '', '', '', 'DSL150108PA2', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27250', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:17', '2020-10-19 10:38:17', 5, 5);
INSERT INTO `proveedores` VALUES (31829, 1, 'DISTRIBUIDORA BETA DE CIUDAD JUAREZ, S.DE R.L. DE C.V.', '', '', '', 'DBC170321LT2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '', '', '  facturas.asi.2015@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:17', '2020-10-19 10:38:17', 5, 5);
INSERT INTO `proveedores` VALUES (347, 1, 'DISTRIBUIDORA DE PUERTAS Y AISLANTES S DE RL DE CV', '', 'C.P. JUAN ANTONIO CHAVARRIA', '', 'DPA920318FF4', 1, 'Moneda nacional', 307, 'TORREON', '27170', '7125256', '7122218', 'jchavarria53@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:17', '2020-10-19 10:38:17', 5, 5);
INSERT INTO `proveedores` VALUES (35927, 1, 'DISTRIBUIDORA DE TUBERIA Y RIEGOS SA DE CV', '', '', '', 'DTR171010SQ9', 1, 'Moneda nacional', 307, 'TORREON', '27000', ' 871 218 0737', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:17', '2020-10-19 10:38:17', 5, 5);
INSERT INTO `proveedores` VALUES (772, 1, 'DISTRIBUIDORA LIVERPOOL SA DE CV', '', '', '', 'DLI931201MI9', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '05348', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:18', '2020-10-19 10:38:18', 5, 5);
INSERT INTO `proveedores` VALUES (34493, 1, 'DISTRIBUIDORA MIRIMA SA DE CV ', '', '', '', 'DMI030402M31', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:18', '2020-10-19 10:38:18', 5, 5);
INSERT INTO `proveedores` VALUES (349, 1, 'DOMINGUEZ ALANIS ADRIAN HOMERO', '', 'Adrian Dominguez', '', 'DOAA800630FI8', 1, 'Moneda nacional', 307, 'TORREON', '27250', '8711012707', '', 'miro0680@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:18', '2020-10-19 10:38:18', 5, 5);
INSERT INTO `proveedores` VALUES (30263, 1, 'DORA SALINAS JIMENEZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 310, 'LERDO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:18', '2020-10-19 10:38:18', 5, 5);
INSERT INTO `proveedores` VALUES (37151, 1, 'DUES TEXTIL SA DE CV ', '', '', '', 'DTE031126KD1', 1, 'Moneda nacional', 35447, 'MAZATLAN', '82127', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:18', '2020-10-19 10:38:18', 5, 5);
INSERT INTO `proveedores` VALUES (24454, 1, 'ECOGAS MEXICO, S. DE R.L. DE C.V. ', '', '', '', 'EME9704037Q8', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '31160', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:18', '2020-10-19 10:38:18', 5, 5);
INSERT INTO `proveedores` VALUES (34138, 1, 'EDGAR JONATAN REYES RAMIREZ', '', '', '', 'RERE770404K35', 1, 'Moneda nacional', 307, 'TORREON', '27440', '', '', 'eduardo.duranlaf@live.com', 'ACTIVO    ', 1, '2020-10-19 10:38:18', '2020-10-19 10:38:18', 5, 5);
INSERT INTO `proveedores` VALUES (361, 1, 'EDIFICACION Y VALUACION LEONART SA DE CV', '', '', 'CRISTY', 'EVL0903041L2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'cristy_amu2901@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:18', '2020-10-19 10:38:18', 5, 5);
INSERT INTO `proveedores` VALUES (19937, 1, 'EDITORIAL LA OPINION, S.A.', '', '', '', 'EOP510101UA4', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:19', '2020-10-19 10:38:19', 5, 5);
INSERT INTO `proveedores` VALUES (27764, 1, 'EDUARDO CHAIREZ FLORES', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:19', '2020-10-19 10:38:19', 5, 5);
INSERT INTO `proveedores` VALUES (31169, 1, 'EDUARDO SALAS BALBANEDA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:19', '2020-10-19 10:38:19', 5, 5);
INSERT INTO `proveedores` VALUES (31280, 1, 'EDWIN AARON MOLINA RONDON', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:19', '2020-10-19 10:38:19', 5, 5);
INSERT INTO `proveedores` VALUES (22050, 1, 'EL CAMELLO IMPORT SA DE CV', '', '', '', 'CIM140120RX2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:19', '2020-10-19 10:38:19', 5, 5);
INSERT INTO `proveedores` VALUES (567, 1, 'EL ECONOMISTA GRUPO EDITORIAL SA DE CV', '', '', 'VERONICA ALDANA', 'EGE101130F25', 1, 'Moneda nacional', 315, 'ESTADO DE MEXICO', '06060', '015553265454', '', 'veronica.aldana@eleconomista.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:19', '2020-10-19 10:38:19', 5, 5);
INSERT INTO `proveedores` VALUES (411, 1, 'ELECTRICA SAISA SA DE CV', '', 'SERGIO SAENZ IBARRA', '', 'ESA1008192W5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '871 723 78 35', '', 'electricasaisa@prodigy.net.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:19', '2020-10-19 10:38:19', 5, 5);
INSERT INTO `proveedores` VALUES (409, 1, 'ELECTRO TABLEROS DE CONTROL SA DE CV', '', 'Sergio Rios', '', 'SEC 050511H69', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '871 719 21 31', '', 'mechavarria@electrotableros.com', 'ACTIVO    ', 1, '2020-10-19 10:38:19', '2020-10-19 10:38:19', 5, 5);
INSERT INTO `proveedores` VALUES (632, 1, 'ELIAS RAMOS NANCY YOSELIN', '', 'CECILIA ALVAREZ', '', 'EIRN8905244Z1', 1, 'Moneda nacional', 310, 'LERDO', '35150', '(871) 1 59 35 49', '', 'viverosanisidro.facturas@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:19', '2020-10-19 10:38:19', 5, 5);
INSERT INTO `proveedores` VALUES (705, 1, 'ELIDA AMERICA CORDOVA MARIN', '', '', '', 'MACE6109155T8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '7-13-49-73', '', 'metalicos_aldama@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:20', '2020-10-19 10:38:20', 5, 5);
INSERT INTO `proveedores` VALUES (21626, 1, 'ELIZABETH DE JESUS MARTINEZ SANCHEZ', '', '', '', 'MASE830517PI6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35078', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:20', '2020-10-19 10:38:20', 5, 5);
INSERT INTO `proveedores` VALUES (30660, 1, 'ELSA ALEJANDRA HERNANDEZ SALINAS ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '0035123', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:20', '2020-10-19 10:38:20', 5, 5);
INSERT INTO `proveedores` VALUES (34666, 1, 'ELSA OTILA SALINAS JIMENEZ', '', '', '', '', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35013', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:20', '2020-10-19 10:38:20', 5, 5);
INSERT INTO `proveedores` VALUES (27789, 1, 'EMELIA GOVELA ( DISEÑA TU IMAGEN )', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:20', '2020-10-19 10:38:20', 5, 5);
INSERT INTO `proveedores` VALUES (549, 1, 'ENCERRADO ALVARADO JOSE LUIS', '', '', '', 'EEAL450621910', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:21', '2020-10-19 10:38:21', 5, 5);
INSERT INTO `proveedores` VALUES (687, 1, 'ENERGIA Y SERVICIOS COORDINADOS S.A. DE C.V.', '', '', '', 'ESC-141203-1E8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35135', '7502222', '7502371', '', 'ACTIVO    ', 1, '2020-10-19 10:38:21', '2020-10-19 10:38:21', 5, 5);
INSERT INTO `proveedores` VALUES (20040, 1, 'ENRIQUE NUÑEZ SLEIMAN', '', '', '', 'NUSE9002151N1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27020', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:21', '2020-10-19 10:38:21', 5, 5);
INSERT INTO `proveedores` VALUES (31175, 1, 'ENRIQUE OLIVAS REYES', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:22', '2020-10-19 10:38:22', 5, 5);
INSERT INTO `proveedores` VALUES (29879, 1, 'ERIKA MUÑIZ  VELA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27274', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:22', '2020-10-19 10:38:22', 5, 5);
INSERT INTO `proveedores` VALUES (35330, 1, 'ERNESTO MALTO SALINAS', '', '', '', 'MASE870929961', 1, 'Moneda nacional', 307, 'TORREON', '27087', '', '8711841587', 'administracion@grupomalgo.com', 'ACTIVO    ', 1, '2020-10-19 10:38:22', '2020-10-19 10:38:22', 5, 5);
INSERT INTO `proveedores` VALUES (21441, 1, 'ERNESTO RAFAEL CHAVEZ CASTELLANOS ', '', '', '', 'CACE750603T11', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:22', '2020-10-19 10:38:22', 5, 5);
INSERT INTO `proveedores` VALUES (683, 1, 'ESPECIALISTAS EN ALTA COCINA SA DE CV ', '', '', '', 'EAC8504236U5', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '06600', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:22', '2020-10-19 10:38:22', 5, 5);
INSERT INTO `proveedores` VALUES (599, 1, 'ESTRELLA OCHOA SERGIO', '', 'RAQUEL', '', 'EEOS340321EI5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '7151811', '', 'notariapublica5@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:22', '2020-10-19 10:38:22', 5, 5);
INSERT INTO `proveedores` VALUES (29770, 1, 'EXCAVACIONES DIRECCIONES DE LA LAGUNA', '', '', '', 'EDL140517I9A', 1, 'Moneda nacional', 307, 'TORREON', '27019', '', '', 'ccruz@gasnaturalindustrial.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:22', '2020-10-19 10:38:22', 5, 5);
INSERT INTO `proveedores` VALUES (25831, 1, 'EXPO FERIA GOMEZ PALACIO, DGO.', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:22', '2020-10-19 10:38:22', 5, 5);
INSERT INTO `proveedores` VALUES (27708, 1, 'FACEBOOK IRELAND LIMITED', '', '', '', 'XAXE010101000', 1, 'Moneda nacional', 307, 'TORREON', '27250', '', '', '', 'ACTIVO                 ', 1, '2020-10-19 10:38:23', '2021-02-23 15:52:05', 5, 0);
INSERT INTO `proveedores` VALUES (475, 1, 'FACIO LOPEZ OLGA LIDIA (PINTURAS ALDAMA)', '', 'OLGA FACIO', '', 'FALO620801B57', 1, 'Moneda nacional', 310, 'LERDO', '35150', '725-00-68', '', 'olga_fasio@live.com', 'ACTIVO    ', 1, '2020-10-19 10:38:23', '2020-10-19 10:38:23', 5, 5);
INSERT INTO `proveedores` VALUES (19362, 1, 'FARMACIAS BENAVIDES, S.A.B. DE C.V.', '', '', '', 'FBE9110215Z3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '64750', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:23', '2020-10-19 10:38:23', 5, 5);
INSERT INTO `proveedores` VALUES (721, 1, 'FASTPRINT', '', 'THANIA', '', 'GVA0902251V3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35080', '7-14-38-10', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:23', '2020-10-19 10:38:23', 5, 5);
INSERT INTO `proveedores` VALUES (493, 1, 'FAVELA NAVARRO SONIA ESTELA', '', 'SABINO FAVELA', '', 'FANS771121SC7', 1, 'Moneda nacional', 310, 'LERDO', '35161', '7257550', '8711207029', 'taktejasyacabados@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:23', '2020-10-19 10:38:23', 5, 5);
INSERT INTO `proveedores` VALUES (585, 1, 'FAVILA FERNANDEZ BALTAZAR', '', 'BALTAZAR FAVILA', '', 'FAFB851109T14', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7300145', '', 'balta_favila@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:23', '2020-10-19 10:38:23', 5, 5);
INSERT INTO `proveedores` VALUES (20344, 1, 'FELIPE GALLEGOS BERLANGA', '', '', '', 'GABF920518HN5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:23', '2020-10-19 10:38:23', 5, 5);
INSERT INTO `proveedores` VALUES (17880, 1, 'FELIX SOTO DE LA CRUZ', '', '', '', 'SOCF570720EZ6', 1, 'Moneda nacional', 307, 'TORREON', '27240', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:23', '2020-10-19 10:38:23', 5, 5);
INSERT INTO `proveedores` VALUES (31574, 1, 'FEMSA COMERCIO SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:24', '2020-10-19 10:38:24', 5, 5);
INSERT INTO `proveedores` VALUES (28889, 1, 'FERNANDO CHAIREZ ORTIZ ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:24', '2020-10-19 10:38:24', 5, 5);
INSERT INTO `proveedores` VALUES (27520, 1, 'FERNANDO JAVIER ROSALES ARCAUTE', '', '', '', 'ROAF820928NM0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35080', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:24', '2020-10-19 10:38:24', 5, 5);
INSERT INTO `proveedores` VALUES (29397, 1, 'FERNANDO OLIDEN PEÑA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:24', '2020-10-19 10:38:24', 5, 5);
INSERT INTO `proveedores` VALUES (620, 1, 'FIDEICOMISO REGISTRO UNICO DE VIVIENDA', '', '', '', 'FRU111123SA3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '01020', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:24', '2020-10-19 10:38:24', 5, 5);
INSERT INTO `proveedores` VALUES (653, 1, 'FLEJES SULTANA SA DE CV ', '', '', '', 'FSU8911099Y4', 1, 'Moneda nacional', 307, 'TORREON', '27020', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:24', '2020-10-19 10:38:24', 5, 5);
INSERT INTO `proveedores` VALUES (662, 1, 'FLEJES Y EMBALAJES INDUSTRIALES SA DE CV ', '', '', '', 'FEI931202T55', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:24', '2020-10-19 10:38:24', 5, 5);
INSERT INTO `proveedores` VALUES (559, 1, 'FORESTAL LAGUNERA SA DE CV', '', '', '', 'FLA960617E78', 1, 'Moneda nacional', 307, 'TORREON', '27030', '7133501', '7938017', 'folag@prodigy.net.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:24', '2020-10-19 10:38:24', 5, 5);
INSERT INTO `proveedores` VALUES (26974, 1, 'FRANCISCO FERNANDO ARROYO LUNA ', '', '', '', 'ARLF900810PA1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:24', '2020-10-19 10:38:24', 5, 5);
INSERT INTO `proveedores` VALUES (32312, 1, 'FRANCISCO JAVIER LUNA SARMIENTO ', '', '', '', 'LUSF861206VB2', 1, 'Moneda nacional', 317, 'TAMAULIPAS', '99080', '', '494625941', 'fcojav.sar@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:25', '2020-10-19 10:38:25', 5, 5);
INSERT INTO `proveedores` VALUES (19489, 1, 'GADIVI, S.A. DE C.V.', '', '', '', 'GAD1005245M8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '66220', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:25', '2020-10-19 10:38:25', 5, 5);
INSERT INTO `proveedores` VALUES (345, 1, 'GAFI FERRELECTRICO SA DE CV', '', 'GILDA HERNANDEZ', 'JUAN ARTURO JUAREZ', 'GFE000627QW0', 1, 'Moneda nacional', 307, 'TORREON', '27050', '7474612', '7474600 ext 156', 'compras@viviend.mx', 'ACTIVO                 ', 1, '2020-10-19 10:38:25', '2021-02-23 15:52:06', 5, 0);
INSERT INTO `proveedores` VALUES (471, 1, 'GALVAN CAMACHO TOMAS', '', '', '', 'GACT610919 9B2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:25', '2020-10-19 10:38:25', 5, 5);
INSERT INTO `proveedores` VALUES (19396, 1, 'GANT IMPRESOS Y REGALOS S.A. DE C.V.', '', '', '', 'GIR970121MM1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:25', '2020-10-19 10:38:25', 5, 5);
INSERT INTO `proveedores` VALUES (729, 1, 'GAS NATURAL DEL NOROESTE  SA DE CV', '', 'GERARDO  PIÑERA', '', 'GNN9706053S3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27019', '8717255282', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:25', '2020-10-19 10:38:25', 5, 5);
INSERT INTO `proveedores` VALUES (431, 1, 'GASPAR ROJAS JOSE RUBEN', '', '', '', 'GARR621231CW7', 1, 'Moneda nacional', 307, 'TORREON', '27060', '7207288', '', 'elplomerito.ferreteria@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:25', '2020-10-19 10:38:25', 5, 5);
INSERT INTO `proveedores` VALUES (25963, 1, 'GERARDO ALCARAZ SIERRA', '', '', '', 'AASG800523MU9', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7224688', '044 8711177686', ' gerardo.alcarazs@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:25', '2020-10-19 10:38:25', 5, 5);
INSERT INTO `proveedores` VALUES (31316, 1, 'GERARDO CARRERA MENA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:25', '2020-10-19 10:38:25', 5, 5);
INSERT INTO `proveedores` VALUES (764, 1, 'GILBERTO VARGAS VALDEZ', '', '', '', 'VAVG760204LTA', 1, 'Moneda nacional', 307, 'TORREON', '27089', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:26', '2020-10-19 10:38:26', 5, 5);
INSERT INTO `proveedores` VALUES (34605, 1, 'GLORIA VAZQUEZ CARRILLO', '', '', '', 'VACG670325241', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '8713738541', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:26', '2020-10-19 10:38:26', 5, 5);
INSERT INTO `proveedores` VALUES (22744, 1, 'GOBIERNO DEL ESTADO DE DURANGO', '', '', '', 'GEB620101652', 1, 'Moneda nacional', 318, 'DURANGO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:26', '2020-10-19 10:38:26', 5, 5);
INSERT INTO `proveedores` VALUES (656, 1, 'GONZALEZ CABRAL Y ASOCIADOS SC', '', '', '', 'GCA961015A71', 1, 'Moneda nacional', 307, 'TORREON', '27200', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:26', '2020-10-19 10:38:26', 5, 5);
INSERT INTO `proveedores` VALUES (634, 1, 'GONZALEZ GARCIA CARLOS', '', 'CARLOS GONZALEZ', '', 'GOGC500203155', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7177358', '', 'gonzalezcabral.facturacion@yahoo.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:26', '2020-10-19 10:38:26', 5, 5);
INSERT INTO `proveedores` VALUES (575, 1, 'GONZALEZ MACHADO SERGIO ARTURO', '', '', 'KAREN', 'GOMS 661007 L89', 1, 'Moneda nacional', 307, 'TORREON', '27000', '871-7220800', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:26', '2020-10-19 10:38:26', 5, 5);
INSERT INTO `proveedores` VALUES (24195, 1, 'GONZALEZ MORENO SALVADOR', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:26', '2020-10-19 10:38:26', 5, 5);
INSERT INTO `proveedores` VALUES (35460, 1, 'GONZALO VILLANUEVA CAMARILLO', '', '', '', 'VICG650113PA5', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'viverolosangelesss@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:26', '2020-10-19 10:38:26', 5, 5);
INSERT INTO `proveedores` VALUES (367, 1, 'GORVAL CONSULTORES SC', '', 'AURORA', '', 'GCO100601LH9', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:27', '2020-10-19 10:38:27', 5, 5);
INSERT INTO `proveedores` VALUES (21446, 1, 'GRAHER Y ASOCIADOS SC', '', '', '', 'GAS170118SC6', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:27', '2020-10-19 10:38:27', 5, 5);
INSERT INTO `proveedores` VALUES (19395, 1, 'GRANT IMPRESOS Y REGALOS, S.A DE C.V', '', '', '', 'GIR970121MM1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '66260', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:27', '2020-10-19 10:38:27', 5, 5);
INSERT INTO `proveedores` VALUES (445, 1, 'GRUAS TASA S.A. DE C.V.', '', 'CLAUDIA', '', 'GTA960508 UL1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '722-81-11', '', 'gruastasa@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:27', '2020-10-19 10:38:27', 5, 5);
INSERT INTO `proveedores` VALUES (677, 1, 'GRUPO AMIGOS SAN ANGEL SA DE CV ', '', '', '', 'GAS9404199I6', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '06600', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:27', '2020-10-19 10:38:27', 5, 5);
INSERT INTO `proveedores` VALUES (27818, 1, 'GRUPO COMERCIAL LEALCO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8717930999', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:27', '2020-10-19 10:38:27', 5, 5);
INSERT INTO `proveedores` VALUES (433, 1, 'GRUPO COMERCIAL YAZBEK SA DE CV ', '', 'CAROLINA', '', 'GCY890426MZ1', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '08400', '018002929235', '2099390', 'torreon@yazbek.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:27', '2020-10-19 10:38:27', 5, 5);
INSERT INTO `proveedores` VALUES (441, 1, 'GRUPO CORCELES SA DE CV', '', '', '', 'GCO1007283X7', 1, 'Moneda nacional', 307, 'TORREON', '27190', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:28', '2020-10-19 10:38:28', 5, 5);
INSERT INTO `proveedores` VALUES (385, 1, 'GRUPO ENLACE MEK SA DE CV', '', 'DAVID GONZALEZ', '', 'GEM110824 HA1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '871-2685346', '8712115146', 'glzdavid@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:28', '2020-10-19 10:38:28', 5, 5);
INSERT INTO `proveedores` VALUES (22101, 1, 'GRUPO HABITALMEX SA DE CV', '', '', '', 'GHA1510036F2', 1, 'Moneda nacional', 318, 'DURANGO', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:28', '2020-10-19 10:38:28', 5, 5);
INSERT INTO `proveedores` VALUES (595, 1, 'GRUPO LEGRAF SA DE CV', '', 'MARLENE', '', 'GLE140212F19', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7111714', '', 'legraf@outlook.com', 'ACTIVO    ', 1, '2020-10-19 10:38:28', '2020-10-19 10:38:28', 5, 5);
INSERT INTO `proveedores` VALUES (30638, 1, 'GRUPO NACIONAL PROVINCIAL S.A.B.', '', '', '', 'GNP9211244P0', 1, 'Moneda nacional', 30634, 'MEXICO', '04200', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:28', '2020-10-19 10:38:28', 5, 5);
INSERT INTO `proveedores` VALUES (383, 1, 'GRUPO PERLITA DE LA LAGUNA S.A. DE C.V.', '', 'RAFAEL MARENTIS', 'MARGARITA HERRERA', 'GPL-090512-8E6', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '35077', '719 13 15  EXT 115', '8711816168', 'averdin@viviend.mx.,almacen@viviend.mx.,compras@viviend.mx.,hsalinas@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:28', '2020-10-19 10:38:28', 5, 5);
INSERT INTO `proveedores` VALUES (35306, 1, 'GRUPO RICOY LAGUNA SA DE CV ', '', '', '', 'GRL190731N73', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:28', '2020-10-19 10:38:28', 5, 5);
INSERT INTO `proveedores` VALUES (30687, 1, 'GRUPO TOYKA S.A. DE C.V.', '', '', '', 'GTO120702HW7', 1, 'Moneda nacional', 307, 'TORREON', '27010', '8717478317', '', 'clientes1@toyka.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:28', '2020-10-19 10:38:28', 5, 5);
INSERT INTO `proveedores` VALUES (18154, 1, 'GRUPO VACO S.A. DE C.V.', '', '', '', 'GVA0902251V3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35080', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:28', '2020-10-19 10:38:28', 5, 5);
INSERT INTO `proveedores` VALUES (465, 1, 'GUERRA GUZMAN JOSE PRAXEDIS', '', '', '', 'GUGP520410 9T6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35078', '750 05 71', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:29', '2020-10-19 10:38:29', 5, 5);
INSERT INTO `proveedores` VALUES (30474, 1, 'GUILLERMO GABRIEL ROCHA GARCIA', '', '', '', 'ROG6512149J0', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:29', '2020-10-19 10:38:29', 5, 5);
INSERT INTO `proveedores` VALUES (23256, 1, 'GUILLERMO GUTIERREZ DEL BOSQUE', '', '', '', 'GUBG5912097B2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:29', '2020-10-19 10:38:29', 5, 5);
INSERT INTO `proveedores` VALUES (29522, 1, 'GUILLERMO SANDOVAL YARZA', '', '', '', 'SAYG861122IU0', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:29', '2020-10-19 10:38:29', 5, 5);
INSERT INTO `proveedores` VALUES (36934, 1, 'GUILLERMO URRUTIA SILVA', '', '', '', 'UUSG700403PJ5', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:29', '2020-10-19 10:38:29', 5, 5);
INSERT INTO `proveedores` VALUES (527, 1, 'GUTIERREZ AUTOMOTORES SA  DE CV', '', '', '', 'GAU891218GH0', 1, 'Moneda nacional', 307, 'TORREON', '27018', '871750202', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:29', '2020-10-19 10:38:29', 5, 5);
INSERT INTO `proveedores` VALUES (391, 1, 'GUTIERREZ FERRETEROS S.A. DE C.V.', '', 'JAVIER BERDIN', '', 'GFE861208 L17', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '1751200', '', 'ventas01@gutierrezferreteros.com;mailto:hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx,averdin@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:29', '2020-10-19 10:38:29', 5, 5);
INSERT INTO `proveedores` VALUES (525, 1, 'GUTIERREZ MERLO MA TERESA', '', '', '', 'GUMT631223TM0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '871 7142984', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:29', '2020-10-19 10:38:29', 5, 5);
INSERT INTO `proveedores` VALUES (24271, 1, 'H&M HENNES AND MAURITZ SA DE CV', '', '', '', 'HAM111006K69', 1, 'Moneda nacional', 21664, 'MEXICO D.F', '11000', '5511003530', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:29', '2020-10-19 10:38:29', 5, 5);
INSERT INTO `proveedores` VALUES (24653, 1, 'HACIENDA EL ROSARIO ', '', '87 11 76 18 26 ', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'cooperativa@haciendaelrosario.com', 'ACTIVO    ', 1, '2020-10-19 10:38:29', '2020-10-19 10:38:29', 5, 5);
INSERT INTO `proveedores` VALUES (31798, 1, 'HACIENDA LAGUNERA SAN JOSE SA DE CV', '', '', '', 'HLS1212208G4', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:30', '2020-10-19 10:38:30', 5, 5);
INSERT INTO `proveedores` VALUES (601, 1, 'HDI SEGUROS SA DE CV', '', '', 'ERIKA', 'HSE701218532', 1, 'Moneda nacional', 322, 'LEON GUANAJUATO', '37306', '1938490', '', 'erika.ehrenzwieg@hdi.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:30', '2020-10-19 10:38:30', 5, 5);
INSERT INTO `proveedores` VALUES (34034, 1, 'HECTOR MENCHACA ARELLANO', '', '', '', 'MEAH890530A39', 1, 'Moneda nacional', 307, 'TORREON', '27000', '2967180', '', 'facturacionhma@yahoo.com', 'ACTIVO    ', 1, '2020-10-19 10:38:30', '2020-10-19 10:38:30', 5, 5);
INSERT INTO `proveedores` VALUES (697, 1, 'HERA INGENIEROS S DE RL DE CV ', '', '', '', 'HIN160205555', 1, 'Moneda nacional', 307, 'TORREON', '27100', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:30', '2020-10-19 10:38:30', 5, 5);
INSERT INTO `proveedores` VALUES (19355, 1, 'HERNAN RENE GOMEZ TORRES', '', '8183597998', '', 'GOTH881204P40', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '67170', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:30', '2020-10-19 10:38:30', 5, 5);
INSERT INTO `proveedores` VALUES (650, 1, 'HERNANDEZ CASTRO FRANCISCO JAVIER ', '', '', '', 'HECF810814IM6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35049', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:30', '2020-10-19 10:38:30', 5, 5);
INSERT INTO `proveedores` VALUES (479, 1, 'HERNANDEZ RUELAS AGUSTIN', '', '8711785339', '', 'HERA851005CU0', 1, 'Moneda nacional', 307, 'TORREON', '27119', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:30', '2020-10-19 10:38:30', 5, 5);
INSERT INTO `proveedores` VALUES (35509, 1, 'HILARIO RANGEL GUZMAN', '', '', '', 'RAGH6002281L7', 1, 'Moneda nacional', 307, 'TORREON', '27270', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:30', '2020-10-19 10:38:30', 5, 5);
INSERT INTO `proveedores` VALUES (395, 1, 'HOME DEPOT MEXICO S DE R.L. DE C.V.', '', 'FRANCISCO BARUSH', '', 'HDM001017AS1', 1, 'Moneda nacional', 307, 'TORREON', '27020', '7474540', '2130117', 'ventas8728@homedepot.com.mx;averdin@viviend.mx;almacen@viviend.mx;compras@viviend.mx;hsalinas@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:30', '2020-10-19 10:38:30', 5, 5);
INSERT INTO `proveedores` VALUES (27888, 1, 'HOTEL POSADA DEL RIO SA DE CV', '', '', '', 'HPR8106038A7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:30', '2020-10-19 10:38:30', 5, 5);
INSERT INTO `proveedores` VALUES (760, 1, 'HUMAN STAFF SA DE CV', '', '', '', 'HST0003292H0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:31', '2020-10-19 10:38:31', 5, 5);
INSERT INTO `proveedores` VALUES (712, 1, 'HUMBERTO HERNANDEZ GUTIERREZ', '', '', '', 'HEGH671121A51', 1, 'Moneda nacional', 310, 'LERDO', '35140', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:31', '2020-10-19 10:38:31', 5, 5);
INSERT INTO `proveedores` VALUES (19862, 1, 'IAJAIRA SANDOVAL CARDENAS', '', '', '', 'SACI 810919 7B7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:31', '2020-10-19 10:38:31', 5, 5);
INSERT INTO `proveedores` VALUES (31388, 1, 'ICICAC SA DE CV', '', '', '', 'ICI150121MD7', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '01780', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:31', '2020-10-19 10:38:31', 5, 5);
INSERT INTO `proveedores` VALUES (19929, 1, 'ILEANA ARACELI MIRANDA GIRON', '', '', '', 'MIGI8603069R8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:31', '2020-10-19 10:38:31', 5, 5);
INSERT INTO `proveedores` VALUES (715, 1, 'IMPULSORA ELIZONDO SA DE CV', '', '7-19-04-10', '', 'IEL931213LD7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', 'rchacon@elizondomx.com;sayala@elizondomx.com', 'ACTIVO    ', 1, '2020-10-19 10:38:31', '2020-10-19 10:38:31', 5, 5);
INSERT INTO `proveedores` VALUES (626, 1, 'INDUSTRIAL BALA SA DE CV ', '', 'JUAN IGNACIO DEHESA TORRE', 'PEDRO FERNANDEZ SAUCEDO', 'IBA040621NY5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35140', '1800139', '1800144', 'jdehesa@gmail.com;pfdzjm@gmail.com;balafacturas@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:31', '2020-10-19 10:38:31', 5, 5);
INSERT INTO `proveedores` VALUES (775, 1, 'INDUSTRIAL DE LONAS DEL NORTE SA DE CV', '', '', '', 'ILN860519UT5', 1, 'Moneda nacional', 307, 'TORREON', '27013', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:32', '2020-10-19 10:38:32', 5, 5);
INSERT INTO `proveedores` VALUES (555, 1, 'INFORMATICA EMPRESARIAL INTEGRADA SA DE CV', '', '', '83330456', 'IEI930820FC2', 1, 'Moneda nacional', 311, 'MONTERREY', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:32', '2020-10-19 10:38:32', 5, 5);
INSERT INTO `proveedores` VALUES (717, 1, 'INGENIERIA ELECTRICA Y EQUIPAMENTO  EN CLIMAS SA DE CV', '', '', '', 'IEE070508BY9', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27058', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:32', '2020-10-19 10:38:32', 5, 5);
INSERT INTO `proveedores` VALUES (685, 1, 'INMOBILIARIA PASEO DE LA REFORMA SA DE CV ', '', '', '', 'IPR820702IG9', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '06030', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:32', '2020-10-19 10:38:32', 5, 5);
INSERT INTO `proveedores` VALUES (21214, 1, 'INMOBILIARIA VILLA JARDIN, S.A. DE C.V.', '', '', '', 'IVJ791228B49', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:32', '2020-10-19 10:38:32', 5, 5);
INSERT INTO `proveedores` VALUES (36521, 1, 'INSTITUTO DE CONTROL VEHICULAR DEL ESTADO DE NL', '', '', '', 'ICV051202LD4', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (24158, 1, 'INSTITUTO MEXICANO DE LA PROPIEDAD INDUSTRIAL', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 21664, 'MEXICO D.F', '03820', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (20138, 1, 'INSTITUTO MEXICANO DEL SEGURO SOCIAL', '', '', '', 'IMSS170507HY4', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (618, 1, 'INTEGRACORP & H CONSULTING SA DE CV', '', 'FELIPE SALAZAR', '', 'IAH110225TFA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8711188153', '4556161', 'fsalazar@ihconsulting.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (393, 1, 'INTER LAGUNA S.A. DE C.V.', '', 'STEPHANIA VALLES', '', 'ILA1010283EA', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35090', '7149000', '', 'ventas1_ma@interceramic.com;averdin@viviend.mx;almacen@viviend.mx;compras@viviend.mx;hsalinas@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (37209, 1, 'INVERSION PUBICIDAD REDES', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (36499, 1, 'INVERSIONES SANTA CRUZ SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 317, 'TAMAULIPAS', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (425, 1, 'IQ LAGUNA, SA DE CV', '', 'LORENA ZAVALA', '', 'ILA100826EA7', 1, 'Moneda nacional', 307, 'TORREON', '', '7505084', '', 'iqlaguna@laguna.com;averdin@viviend.mx;almacen@viviend.mx;compras@viviend.mx;hsalinas@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (26604, 1, 'ISAAC RENE DAVILA MONTALVO', '', '', '', 'DAMI861019NE3', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'robertodavilacastaneda@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (723, 1, 'ISABEL CRISTINA BALDERAS MORENO', '', 'ISABEL', '', 'BAMI750708RG1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (573, 1, 'IUSACELL', '', '', '', 'IUS890616RH6', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '11000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (19973, 1, 'IVO CONSTRUCCIONES, S.A. DE C.V.', '', '', '', 'ICO071017Q17', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35018', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:33', '2020-10-19 10:38:33', 5, 5);
INSERT INTO `proveedores` VALUES (695, 1, 'J. GUADALUPE GAYTAN CHAVARRIA', '', '', '', 'GACJ4912126A8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:34', '2020-10-19 10:38:34', 5, 5);
INSERT INTO `proveedores` VALUES (19144, 1, 'JAIME JAVIER SALUM BLAZQUEZ', '', '', '', 'SABJ76110484A', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '871 204 25 43', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:34', '2020-10-19 10:38:34', 5, 5);
INSERT INTO `proveedores` VALUES (495, 1, 'JAIME RAMIREZ JUAN RAYMUNDO', '', 'JUAN RAYMUNDO JAIME', '', 'JARJ490526JR5', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7169333', '', 'torreon@steren.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:34', '2020-10-19 10:38:34', 5, 5);
INSERT INTO `proveedores` VALUES (405, 1, 'JARAMILLO MONTOYA JUAN', '', 'NANCY', '', 'JAMJ 401027 DI2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35120', '7 52 11 01', '7 52 11 02', 'pobelec.compras@live.com', 'ACTIVO    ', 1, '2020-10-19 10:38:34', '2020-10-19 10:38:34', 5, 5);
INSERT INTO `proveedores` VALUES (31720, 1, 'JESUS ALONSO SOTO DELGADO', '', '', '', 'SODJ820920CM1', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:34', '2020-10-19 10:38:34', 5, 5);
INSERT INTO `proveedores` VALUES (24587, 1, 'JESUS ARMANDO HERNANDEZ BELTRAN', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:34', '2020-10-19 10:38:34', 5, 5);
INSERT INTO `proveedores` VALUES (24800, 1, 'JESUS EDUARDO GUTIERREZ OROZCO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:34', '2020-10-19 10:38:34', 5, 5);
INSERT INTO `proveedores` VALUES (33604, 1, 'JESUS GARCIA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '8715676222', '', 'jesusalejandrocarciaceballes@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:34', '2020-10-19 10:38:34', 5, 5);
INSERT INTO `proveedores` VALUES (33048, 1, 'JESUS GARCIA GARCIA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8715676222', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:34', '2020-10-19 10:38:34', 5, 5);
INSERT INTO `proveedores` VALUES (24235, 1, 'JESUS JORGE MEDRANO RUIZ', '', '', '', 'MERJ730113C61', 1, 'Moneda nacional', 321, 'MERIDA', '97133', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:34', '2020-10-19 10:38:34', 5, 5);
INSERT INTO `proveedores` VALUES (35034, 1, 'JESUS NEIRA IBARRA', '', '', '', 'NEIJ660212SP1', 1, 'Moneda nacional', 313, 'SALTILLO', '25198', '8715201205', '018716887480', 'portatilwc.torreon@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (23468, 1, 'JESUS OLVERA RODRIGUEZ', '', '871 7 18 88 02', '', 'OERJ610404EW9', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (751, 1, 'JESUS RAMIREZ ANDRADE', '', '', '', 'RAAJ631218E91', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '871 718 2829', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (521, 1, 'JIMENEZ HERRERA JUANA', '', 'JOSE MURILLO', '', 'JIHJ581208KV9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '7159482', '', 'cercosymallaslaguna@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (665, 1, 'JM LIDER EN ELECTRONICA SA DE CV ', '', '', '', 'JLE1505129Y7', 1, 'Moneda nacional', 307, 'TORREON', '27100', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (17837, 1, 'JORGE ERNESTO DAVILA RODRIGUEZ', '', '', '', 'DARJ720825PCA', 1, 'Moneda nacional', 307, 'TORREON', '27058', '', '', 'ttmayoral@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (714, 1, 'JORGE IVAN MONARREZ MORALES', '', '', '', 'MOMJ8907293M6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (26321, 1, 'JORGE LUIS VILLARREAL GARZA', '', '7122604', '7128365', 'VIGJ561028SV7', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7122604', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (34271, 1, 'JOSE AMERICO VALDES SILVA ', '', '', '', 'VASA780322CQ2', 1, 'Moneda nacional', 311, 'MONTERREY', '66000', '  81 8188 1716', '', 'mariana.despacho@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (30656, 1, 'JOSE ANGEL CUEVAS', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (33080, 1, 'JOSE ANTONIO CALZADA LOPEZ', '', '', '', 'CALA5311214B0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35029', '8711037331', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:35', '2020-10-19 10:38:35', 5, 5);
INSERT INTO `proveedores` VALUES (35862, 1, 'JOSE CARLOS IZQUIERDO GARCIA', '', '', '', 'IUGC6305199M0', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8717200430', '', 'f_izquierdo_g@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (34021, 1, 'JOSE ERIK LUNA AYALA ', '', '', '', 'LUAE920324K12', 1, 'Moneda nacional', 310, 'LERDO', '35156', '', '', 'emalimpiezaysalud@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (34038, 1, 'JOSE LUIS ESPIINOZA PINTO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (24111, 1, 'JOSE LUIS MORENO VALDEZ', '', '', '', '', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (16917, 1, 'JOSE LUIS SEPULVEDA ESTRADA', '', 'JOSE LUIS', '', 'SEEL870411U89', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35000', '8717976969', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (33641, 1, 'JOSE REFUGIO GRADO MOLINA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (768, 1, 'JOSE ROBERTO PEREZ ALEJANDRO ', '', '', '', 'PEAR410505UW6', 1, 'Moneda nacional', 310, 'LERDO', '35150', '7257483', '', 'robertoperez410505@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (16938, 1, 'JOSE SALVADOR NECOCHEA SAGUI', '', '', '', 'NESS511210JU4', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35158', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (669, 1, 'JOSE SERGIO RAMIREZ JARAMILLO', '', '', '', 'RAJS490416353', 1, 'Moneda nacional', 310, 'LERDO', '35150', '7250606', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (19407, 1, 'JOSUE DAVID ARELLANO SALINAS', '', '', '', 'AESJ891213HM7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (31179, 1, 'JUAN CARLOS REYES FRAIRE', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:36', '2020-10-19 10:38:36', 5, 5);
INSERT INTO `proveedores` VALUES (725, 1, 'JUAN FELIPE CHAVEZ MORAN', '', 'HUMBERTO REYES', '', 'CAMJ660208KG0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '7313034', '7313045', 'cobranza@minotauroherramientas.com', 'ACTIVO    ', 1, '2020-10-19 10:38:37', '2020-10-19 10:38:37', 5, 5);
INSERT INTO `proveedores` VALUES (28107, 1, 'JUAN FERNANDEZ HUERTA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:37', '2020-10-19 10:38:37', 5, 5);
INSERT INTO `proveedores` VALUES (24679, 1, 'JUAN FERNANDO SANCHEZ GURROLA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:37', '2020-10-19 10:38:37', 5, 5);
INSERT INTO `proveedores` VALUES (35152, 1, 'JUAN GERARDO GOMEZ JAUREGUI', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27296', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:37', '2020-10-19 10:38:37', 5, 5);
INSERT INTO `proveedores` VALUES (28147, 1, 'JUAN HERNANDEZ HUERTA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:37', '2020-10-19 10:38:37', 5, 5);
INSERT INTO `proveedores` VALUES (37038, 1, 'JUAN MANUEL FLORES LUCERO', '', '', '', 'FOLJ720223NM2', 1, 'Moneda nacional', 307, 'TORREON', '27090', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:37', '2020-10-19 10:38:37', 5, 5);
INSERT INTO `proveedores` VALUES (22158, 1, 'JUAN MANUEL RAMIREZ FERNANDEZ', '', '', '', 'RAFJ800802U66', 1, 'Moneda nacional', 307, 'TORREON', '27140', '8711890029', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:37', '2020-10-19 10:38:37', 5, 5);
INSERT INTO `proveedores` VALUES (743, 1, 'JUAN MANUEL RAMIREZ PALACIOS ', '', '', '', 'rapj970516bma', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27399', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:37', '2020-10-19 10:38:37', 5, 5);
INSERT INTO `proveedores` VALUES (20345, 1, 'JUAN MARMOLEJO AMOZURRUTIA', '', '', '', 'MAAJ6809231S7', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:37', '2020-10-19 10:38:37', 5, 5);
INSERT INTO `proveedores` VALUES (26863, 1, 'JUAN PABLO SILVA OCAMPO ', '', '', '', 'SIOJ701216SA0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:37', '2020-10-19 10:38:37', 5, 5);
INSERT INTO `proveedores` VALUES (29048, 1, 'JUAN SALVADOR MARQUEZ SOLIS', '', '', '', 'MASJ821012FJ5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35040', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (749, 1, 'JULIO AZPIAZU RUIZ', '', '', '', 'AIRJ481116B20 ', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '8717144045', '', 'aspi@prodigy.net.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (29955, 1, 'JULIO ELEAZAR FACIO VELAZQUEZ ', '', '', '', 'FAVJ8609086F0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (30597, 1, 'KARLA CONCEPCION CABALLERO GARCIA', '', '', '', 'CAGK900726KL2', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (26064, 1, 'KARLA GABRIELA MARENTIS AVILA ', '', '', '', 'MAAK8009297K8', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (22305, 1, 'KORIANDER S DE RL DE CV', '', '', '', 'KOR120224ML5', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (379, 1, 'KREATIV GRAN FORMATO SA DE CV', '', 'ADRIAN DOMINGUEZ', '', 'KGF0208066R1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7174212', '7137825', '', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (734, 1, 'L.I. DAVID RODRIGUEZ AYALA', '', '', '', 'ROAD790213PD5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (16939, 1, 'LABORATORIO Y CONSULTORIA EN SUELOS Y CONCRETOS SC', '', '', '', 'LCS1411257T0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '31125', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (746, 1, 'LAMINADOS DE BARRO SA DE CV ', '', '', '', 'LBA6804198Y1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (744, 1, 'LEO TEXTIL Y DECORACIONES , S.A DE C.V', '', '', '', 'ltd110215ac8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '2700', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (23380, 1, 'LEOBARDO HERNANDEZ CASTILLO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 310, 'LERDO', '35090', '', '', 'XXXX', 'ACTIVO    ', 1, '2020-10-19 10:38:38', '2020-10-19 10:38:38', 5, 5);
INSERT INTO `proveedores` VALUES (31290, 1, 'LEON LARA SOLIS', '', '', '', 'LASL8506266X9', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:39', '2020-10-19 10:38:39', 5, 5);
INSERT INTO `proveedores` VALUES (753, 1, 'LEONARDO MARTINEZ GOMEZ', '', '', '', 'MAGL790914K56', 1, 'Moneda nacional', 307, 'TORREON', '27277', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:39', '2020-10-19 10:38:39', 5, 5);
INSERT INTO `proveedores` VALUES (15116, 1, 'LETICIA GUTIERREZ HERNANDEZ', '', '', '', 'GUHL460516H65', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:39', '2020-10-19 10:38:39', 5, 5);
INSERT INTO `proveedores` VALUES (29812, 1, 'LILIANA BRAVO SALINAS', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:39', '2020-10-19 10:38:39', 5, 5);
INSERT INTO `proveedores` VALUES (37019, 1, 'LIZETH PAOLA VILLEGAS RAMOS', '', '', '', 'VIRL960403DK3', 1, 'Moneda nacional', 307, 'TORREON', '27110', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:39', '2020-10-19 10:38:39', 5, 5);
INSERT INTO `proveedores` VALUES (26775, 1, 'LLANTAS FINAS DE TORREON, S.A. DE C.V.', '', '7-17-05-38', '', 'LFT9907076X0', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'reformallantimundo.com', 'ACTIVO    ', 1, '2020-10-19 10:38:39', '2020-10-19 10:38:39', 5, 5);
INSERT INTO `proveedores` VALUES (541, 1, 'LOPEZ RODRIGUEZ JOEL', '', 'ROSENDO', '', 'LORJ7706049Q8', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35150', '8711018263', '', 'karina_mata6@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:39', '2020-10-19 10:38:39', 5, 5);
INSERT INTO `proveedores` VALUES (397, 1, 'LORENZO OROZCO GARCIA', '', 'GRIS ESTRADA ', '', 'OOGL750810J83', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '35018', '192-30-21', '', 'distribuidoradetuberias@grimosa.com', 'SUSPENSION DE COMPRAS  ', 1, '2020-10-19 10:38:39', '2020-10-23 11:26:24', 5, 5);
INSERT INTO `proveedores` VALUES (27106, 1, 'LOURDES GONZALEZ SUAREZ', '', '24692203', '3331974369', 'XAXA010101000', 1, 'Moneda nacional', 320, 'GUADALAJARA', '45400', '', '', 'alfareria.alvarez.migs@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:39', '2020-10-19 10:38:39', 5, 5);
INSERT INTO `proveedores` VALUES (515, 1, 'LUCILA CORONADO AGUIRRE', '', 'LUCILA', '', 'COAL7811178G7', 1, 'Moneda nacional', 307, 'TORREON', '27087', '7314396', '', 'marmol_juarez@hotmail.com', 'SUSPENSION DE COMPRAS  ', 1, '2020-10-19 10:38:39', '2020-10-23 11:26:24', 5, 5);
INSERT INTO `proveedores` VALUES (675, 1, 'LUIS ABRAHAM HERNANDEZ SALINAS', '', '', '', 'HESL780722F21', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:39', '2020-10-19 10:38:39', 5, 5);
INSERT INTO `proveedores` VALUES (29669, 1, 'LUIS ALBERTO LUNA FAVILA', '', '', '', 'LUFL900202HI2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:39', '2020-10-19 10:38:39', 5, 5);
INSERT INTO `proveedores` VALUES (28407, 1, 'LUIS ANTONIO CABRERA BOTELLO', '', '', '', 'CABL870323G45', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (23578, 1, 'LUIS FRANCISCO NUÑEZ CARPIO', '', '', '', 'NUCL7406081K2', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', 'luis_nunez@live.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (23974, 1, 'LUIS GOMEZ ALANIS', '', '8712114429', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27274', '8712114429', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (26601, 1, 'LUIS MANUEL BECERRA PADILLA', '', '8711893905', '7937767', 'BEPL770905082', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7 93 77 67 ', '', 'herreria4caminos@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (35078, 1, 'LUIS MANUEL SILVA GALLEGOS', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27274', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (739, 1, 'LUIS RENE JACQUEZ LOPEZ ', '', '', '', 'JALL891212A25', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (28239, 1, 'LUISA DAHER', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (15196, 1, 'MA. DE LOS DOLORES PADILLA LUGO', '', '', '', 'PALD680626N7A', 1, 'Moneda nacional', 313, 'SALTILLO', '25057', '8444206281', '', 'certificaciones.lolispadilla@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (29403, 1, 'MA. GUADALUPE ALONSO TERRONES', '', '', '', 'AOTM681217TE8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (759, 1, 'MA. TERESA YOLANDA GUTIERRES MERLO ', '', '', '', 'GUMT631223TM0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35000', '7142984', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (447, 1, 'MACIEL MARRUFO CONRADO', '', 'CONRADO', '', 'MAMC581224MSA', 1, 'Moneda nacional', 310, 'LERDO', '35150', '8712309968', '', 'materialistas_lerdo@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (28886, 1, 'MADERAS Y TARIMAS REAL DEL PINO LAGUNA SA DE CV ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (389, 1, 'MADERERA DEL NAZAS SA DE CV', '', 'Lucy Pamanes', '', 'MNA9010012P6', 1, 'Moneda nacional', 307, 'TORREON', '27271', '7191313', '', 'mailto:hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx,averdin@viviend.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:40', '2020-10-19 10:38:40', 5, 5);
INSERT INTO `proveedores` VALUES (35865, 1, 'MAGMA PROS, SA DE CV', '', '', '', 'MPR161214N15', 1, 'Moneda nacional', 311, 'MONTERREY', '65060', '871 219 6737', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (731, 1, 'MANRIQUE HUMBERTO URIBE LOPEZ', '', '', '', 'UILM671019SD1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27200', '871 347 85 79', '', 'seal_asesores_laborales@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (34792, 1, 'MANTENIMIENTO INDUSTRIAL CLEARS SA DE CV', '', '', '', 'MIC150414E51', 1, 'Moneda nacional', 34791, 'CIUDAD DE MEXICO', '03100', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (25732, 1, 'MANUEL ALBERTO CENICEROS SALAS', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (747, 1, 'MANUELA REYES ', '', '', '', 'RAMA6006166W1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27110', '8717741301', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (579, 1, 'MANUFACTURAS POST FORM SA DE CV', '', 'ANGELICA ACOSTA', 'JESUS LOPEZ', 'MPF861014CD6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '7077718', '7077714', 'angelica.acosta@gebesa.com', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (33039, 1, 'MANZARA LOFT RESORT GERENCIA A.C.', '', '', '', 'MLR171121382', 1, 'Moneda nacional', 316, 'SINALOA', '80227', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (19602, 1, 'MAPFRE TEPEYAC, S.A.', '', '', '', 'MTE440316E54', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '03800', '750 13 36', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (29876, 1, 'MARCELA RUBIO ARRATIA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (21936, 1, 'MARCO MARIANO JASSO GUZMAN', '', '', '', 'JAGM671007SY2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (371, 1, 'MARCOS AUTOMOTRIZ SA DE CV', '', '', '', 'MAU9103057U0', 1, 'Moneda nacional', 312, 'SAN PEDRO', '27800', '7152030', '7152090', '', 'ACTIVO    ', 1, '2020-10-19 10:38:41', '2020-10-19 10:38:41', 5, 5);
INSERT INTO `proveedores` VALUES (779, 1, 'MARGARITA CHAVEZ BERUMEN', '', 'MARGARITA', '', 'CABM530822988', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:42', '2020-10-19 10:38:42', 5, 5);
INSERT INTO `proveedores` VALUES (27033, 1, 'MARGARITA SANCHEZ PAMANES', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:42', '2020-10-19 10:38:42', 5, 5);
INSERT INTO `proveedores` VALUES (24328, 1, 'MARIA ALMA IBARRA MARTINEZ ', '', '', '', 'IAMA5502197T9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:42', '2020-10-19 10:38:42', 5, 5);
INSERT INTO `proveedores` VALUES (33107, 1, 'MARIA CRISTINA GONZALEZ DEL TORO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 310, 'LERDO', '35156', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:42', '2020-10-19 10:38:42', 5, 5);
INSERT INTO `proveedores` VALUES (21117, 1, 'MARIA DE LOURDES ARENAS JIMENEZ', '', '', '', 'AEJL671016N11', 1, 'Moneda nacional', 21116, 'SAN NICOLAS ', '66450', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:42', '2020-10-19 10:38:42', 5, 5);
INSERT INTO `proveedores` VALUES (15108, 1, 'MARIA DE LOURDES MARES MONRREAL', '', '', '', 'MAML550603GF9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '', '', 'cortinasdeseguridad@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:42', '2020-10-19 10:38:42', 5, 5);
INSERT INTO `proveedores` VALUES (34040, 1, 'MARIA DEL ROSARIO REYES ROJERO', '', '', '', 'RERR631007MQ0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:42', '2020-10-19 10:38:42', 5, 5);
INSERT INTO `proveedores` VALUES (23751, 1, 'MARIA FERNANDA BETANCOURT COMPEAN', '', '', '', 'BECF8808214F3', 1, 'Moneda nacional', 307, 'TORREON', '27089', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:42', '2020-10-19 10:38:42', 5, 5);
INSERT INTO `proveedores` VALUES (23307, 1, 'MARIANA AGUILAR RINCON', '', '', '', 'AURM940215LHA', 1, 'Moneda nacional', 21664, 'MEXICO D.F', '02800', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:42', '2020-10-19 10:38:42', 5, 5);
INSERT INTO `proveedores` VALUES (23903, 1, 'MARINA RODRIGUEZ ZURITA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '..', 'ACTIVO    ', 1, '2020-10-19 10:38:43', '2020-10-19 10:38:43', 5, 5);
INSERT INTO `proveedores` VALUES (563, 1, 'MARMOLEJO AMOZURRUTIA JUAN', '', '7235515', '', 'MAAJ6809231S7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35080', '7235515', '', 'aleman@marmolejolaguna.com', 'ACTIVO    ', 1, '2020-10-19 10:38:43', '2020-10-19 10:38:43', 5, 5);
INSERT INTO `proveedores` VALUES (22730, 1, 'MARMOLES DINAMEX, SA DE CV', '', '', '', 'MDI960210BR6', 1, 'Moneda nacional', 317, 'TAMAULIPAS', '27040', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:43', '2020-10-19 10:38:43', 5, 5);
INSERT INTO `proveedores` VALUES (497, 1, 'MARQUEZ Y ASOCIADOS ASESORIA FISCAL, SC', '', 'ERIKA ESCAMILLA', '', 'MAA8505299J2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7124910', '7128462', 'erika@marquezyasociados.com', 'ACTIVO    ', 1, '2020-10-19 10:38:43', '2020-10-19 10:38:43', 5, 5);
INSERT INTO `proveedores` VALUES (21383, 1, 'MARTHA BEATRIZ ORTEGA DIAZ', '', '', '', 'OEDM820608KH5', 1, 'Moneda nacional', 307, 'TORREON', '27105', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:43', '2020-10-19 10:38:43', 5, 5);
INSERT INTO `proveedores` VALUES (355, 1, 'MARTINEZ GOMEZ LEONARDO', '', 'LEONARDO MARTINEZ', '', 'MAGL790914K56', 1, 'Moneda nacional', 307, 'TORREON', '27277', '8711675616', '', 'administracion@casistemas.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:43', '2020-10-19 10:38:43', 5, 5);
INSERT INTO `proveedores` VALUES (483, 1, 'MATA AVILA KARINA SOLEDAD', '', '', '', 'MAAK800101RM9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:43', '2020-10-19 10:38:43', 5, 5);
INSERT INTO `proveedores` VALUES (699, 1, 'MATERIALES COMSA SA DE CV ', '', '', '', 'MCO830127BI6', 1, 'Moneda nacional', 307, 'TORREON', '27020', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:43', '2020-10-19 10:38:43', 5, 5);
INSERT INTO `proveedores` VALUES (21657, 1, 'MAURICIO CARLOS GUTIERREZ', '', '', '', 'CAGM7911018J5', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:43', '2020-10-19 10:38:43', 5, 5);
INSERT INTO `proveedores` VALUES (19899, 1, 'MAXIMA COMERCIAL, S.A. DE C.V.', '', '', '', 'MCO 971001 435', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (33631, 1, 'MAYELA RAMOS GARCIA', '', '', '', 'RAGM800713NK2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35026', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (36536, 1, 'MAYRA LILIANA MARROQUIN SALAS', '', '', '', 'MASM730406518', 1, 'Moneda nacional', 311, 'MONTERREY', '65030', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (15629, 1, 'MAYRA MARIBEL PEÑA RODRIGUEZ', '', '', '', 'PERM7008191T5', 1, 'Moneda nacional', 310, 'LERDO', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (24232, 1, 'MEDRANO RUIZ JESUS JORGE', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (707, 1, 'METALICOS DAVILA', '', 'GUSTAVO MOLINA CORDOVA', '', 'MDA 880506 QW6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', 'ventasmatriz@metalicosdavila.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (21754, 1, 'MG IMPORTACIONES SA DE CV', '', '', '', 'MIM020923RN1', 1, 'Moneda nacional', 307, 'TORREON', '27019', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (757, 1, 'MGC DE LA LAGUNA SA DE CV', '', '', '', 'MLA0607054K5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27140', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (27233, 1, 'MICHEL DE ALBA PEÑA ', '', '3326962736', '3313491521', '', 1, 'Moneda nacional', 320, 'GUADALAJARA', '45150', '', '', 'lagunabglancaceramica@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (26852, 1, 'MICHELE DE ALBA DE LA PEÑA ', '', '', '', 'AAPM890415911', 1, 'Moneda nacional', 320, 'GUADALAJARA', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (766, 1, 'MIGUEL ANGEL AGUILLON ZARATE ', '', '', '', 'AUZM730107EX4', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (24378, 1, 'MIGUEL ANGEL BRETADO ', '', '', '', 'BEFM790220GY8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:44', '2020-10-19 10:38:44', 5, 5);
INSERT INTO `proveedores` VALUES (29287, 1, 'MIGUEL ANGEL DE LUNA PEREZ', '', '', '', 'LUPM871209TW6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', 'manuel.deluna00@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (467, 1, 'MM CONCRETOS SA DE CV', '', 'ALMA BORJON', '', 'MCO130409 3Z8', 1, 'Moneda nacional', 307, 'TORREON', '27019', '7507494', '8711893042', 'compras@viviend.mx', 'ACTIVO                 ', 1, '2020-10-19 10:38:45', '2021-02-23 15:52:08', 5, 0);
INSERT INTO `proveedores` VALUES (589, 1, 'MOBILIARIO E INTERIORES MC SA DE CV', '', 'YSABETH AGUILAR', '', 'MIN140613SK3', 1, 'Moneda nacional', 321, 'MERIDA', '97133', '9999443700', '', 'amatimerida@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (20074, 1, 'MODA IN CASA S.A. DE C.V.', '', '', '', 'MCA831201PI0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '01060', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (624, 1, 'MOLINA VENEGAS ROBERTO', '', 'WENDY BLANQUET', '', 'MOVR890120RR0', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8711178723', '8711518746', 'rmolina@socialclickmarketing.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (29936, 1, 'MONSERRAT ARGENTINA AVILA ELIZONDO', '', '', '', 'AIEM780326FD9', 1, 'Moneda nacional', 307, 'TORREON', '27110', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (727, 1, 'MONSERRATT ALBERTINA AVILA ELIZONDO', '', '', '', 'AIEM780326FD9', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27110', '1-91-69-60', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (435, 1, 'MONTENEGRO GARCIA RODRIGO', '', 'RODRIGO ', 'MARTHA', 'MOGR930622 UX2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '8711842648', '', 'fareme1@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (509, 1, 'MONTENEGRO SOTO MIGUEL ANGEL', '', '', '', 'MOSM360916Q51', 1, 'Moneda nacional', 307, 'TORREON', '27150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (569, 1, 'MORALES VEGA JUAN MANUEL', '', 'JUAN MUANUEL MORALES', '', 'MOVJ7206083V5', 1, 'Moneda nacional', 307, 'TORREON', '27299', '8711565874', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (415, 1, 'MOTORAMA DE LA LAGUNA, S.A. DE C.V.', '', 'JESUS ALEJANDRO RAMOS MADRIGAL', '', 'MLA0511078L9', 1, 'Moneda nacional', 307, 'TORREON', '27020', '7176414', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (32820, 1, 'MOYRO CONSTRUCCIONES Y SERVICIOS SA DE CV', '', '', '', 'MCY120813UQA', 1, 'Moneda nacional', 307, 'TORREON', 'C.P. 35043', '8712957350', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (505, 1, 'MR CONCRETOS, SA DE CV', '', '', '', 'MCO020820R96', 1, 'Moneda nacional', 307, 'TORREON', '27148', '7112383', '8711319769', '', 'ACTIVO    ', 1, '2020-10-19 10:38:45', '2020-10-19 10:38:45', 5, 5);
INSERT INTO `proveedores` VALUES (23379, 1, 'MRIAM RAMIREZ PEREZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (343, 1, 'MULTIACEROS Y MATERIALES SA DE CV', '', 'MONI ', 'GINA', 'MMA860715I97', 1, 'Moneda nacional', 307, 'TORREON', '27276', '7152760', '7303244', 'expomateriales@multiaceros.mx;compras@viviend.mx                                      ', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (19901, 1, 'MULTIMEDIOS, S.A. DE C.V.', '', '', '', 'MUL 071114 7NA', 1, 'Moneda nacional', 311, 'MONTERREY', '64700', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (17861, 1, 'MULTISERVICIOS ESPECIALIZADOS IRCE SA DE CV', '', '', '', 'MEI161123QK6', 1, 'Moneda nacional', 311, 'MONTERREY', '64520', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (21778, 1, 'MUNICIPIO GOMEZ PALACIO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '871 1 75 10 00 ext 1214', '', 'ingresosayuntamientogp@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (24875, 1, 'MUZAR, S.A. DE C.V. ', '', '', '', 'MUZ0707027UA', 1, 'Moneda nacional', 318, 'DURANGO', '34234', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (593, 1, 'NACIONAL SANTA FE SA DE CV', '', '', 'LUPITA DEL CAMPO', 'NSF930414HN1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7163078', '', 'lupitadelcampo07@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (603, 1, 'NAP INNOVACION, CREATIVIDAD Y PRODUCTIVIDAD SA DE CV', '', '', '', 'NIC100625HT4', 1, 'Moneda nacional', 323, 'VENUSTIANO CARRANZA', '15900', '0455543426149', '', 'p.sanchezaldana@napsa.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (22362, 1, 'NAVARRO CAMPOS RAQUEL ELENA', '', '', '', 'NACR840908FQ2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (21599, 1, 'NISSAN MEXICANA S.A DE C.V', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (19358, 1, 'NUEVA WAL MART DE MEXICO, S DE R.L. DE C.V.', '', '', '', 'NWM9709244W4', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '02770', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:46', '2020-10-19 10:38:46', 5, 5);
INSERT INTO `proveedores` VALUES (613, 1, 'NUEVA WALMART DE MEXICO SA DE RL DE CV', '', '', '', 'NWM9709244W4', 1, 'Moneda nacional', 324, 'NAUCALPAN', '02770', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (20987, 1, 'NUPA INMOBILIARIA Y CONSTRUCTORA, S.A. DE C.V.', '', '', '', 'NIC1504244K6', 1, 'Moneda nacional', 307, 'TORREON', '27266', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (628, 1, 'OFFICE DEPOT DE MEXICO SA DE CV', '', '', '', 'ODM950324V2A', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '05348', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (28100, 1, 'OLGA LIDIA MAYELA ALVARADO CORTES', '', '', '', 'AACO780629NN1', 1, 'Moneda nacional', 307, 'TORREON', '27054', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (499, 1, 'OROZCO GARCIA LORENZO', '', 'HECTOR GONZALEZ', '', 'OOGL750810J83', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35043', '7375026', '1923021', 'distribuidoradetuberias@grimosa.com', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (34244, 1, 'OSCAR CASTRUITA VILLANUEVA', '', '', '', 'CAVO970513AAA', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (27072, 1, 'OSCAR JAVIER MONTELONGO VALDES', '', '', '', 'MOVO680507JY5', 1, 'Moneda nacional', 307, 'TORREON', '27276', '', '8711921998', 'cobranza@revistaescaparate.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (29643, 1, 'OSCAR ROLANDO SALAZAR CONTRERAS', '', '', '', 'SACO780320UV8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (27164, 1, 'PABLO ALEJANDRO SILVA SANCHEZ', '', '3338171828', '', 'SISP941209UVA', 1, 'Moneda nacional', 320, 'GUADALAJARA', '45000', '', '', 'muebleriadosromano@gmamil.com', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (459, 1, 'PAPELERA DEL NORTE DE LA LAGUNA SA DE CV', '', 'EDUARDO CORRAL ', '', 'PNL840516 MM0', 1, 'Moneda nacional', 307, 'TORREON', '27020', '7231920', '7144441', 'sucursal1010@papeleradelnorte.net', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (22125, 1, 'PAPELERA LOS ANDES SA DE CV', '', '', '', 'PAN9305144P0', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7137426', '', 'ventas@losandesdigital.com', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (681, 1, 'PASTELERIA Y CONFITERIA DE MEXICO SA DE CV ', '', '', '', 'PCM881209N54', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '11560', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (30431, 1, 'PATSY DANIELA GONZALEZ SESATTY', '', '', '', 'GOSP870721UC9', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:47', '2020-10-19 10:38:47', 5, 5);
INSERT INTO `proveedores` VALUES (21298, 1, 'PEDRO GERARDO MORALES CARRANZA', '', '', '', 'MOCP870703EJ3', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (36835, 1, 'PEDRO MARTIN DE SANTIAGO TRUJILLO', '', '', '', 'SATP630331J65', 1, 'Moneda nacional', 307, 'TORREON', '27018', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (429, 1, 'PINTURAS Y LACAS DE LA LAGUNA SA DE CV', '', 'SERGIO REYES', '', 'PLL8708215R1', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35150', '725-43-21', '7231212', 'pylsalerdo@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (363, 1, 'POLIESTIRENO ALFA GAMMA SA DE CV', '', 'JORGE GALICIA', '', 'PAG9110236T6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35080', '7590950 al 53', '8711611189', 'compras@viviend.mx', 'ACTIVO                 ', 1, '2020-10-19 10:38:48', '2021-02-23 15:52:09', 5, 0);
INSERT INTO `proveedores` VALUES (443, 1, 'PORRAS CASTILLO MARCELO', '', 'VICKY', '', 'POCM670103N87', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '717 80 40', 'vicky_.32@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (34563, 1, 'PORTOFINO STONE SA de CV', '', '', '', 'PST1911018Y2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35049', '8712779713', '', 'angelica@canterasportofino.com', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (381, 1, 'PRESIDENCIA MUNICIPAL DE CD LERDO DGO', '', 'CLAUDIA PARGA', '', 'PMC951010FE3', 1, 'Moneda nacional', 310, 'LERDO', '35150', '1750000', '', 'c_parga@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (21631, 1, 'PROCESADORA INDUSTRIAL DE MUEBLES S.A DE C.V', '', '', '', 'PIM030507U19', 1, 'Moneda nacional', 21632, 'LINARES NUEVO LEON', '67715', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (33890, 1, 'PRODUCTORES DE ARBOLES Y PALMAS LOS ENCINOS S.P.R ', '', '', '', 'PAP060906N22', 1, 'Moneda nacional', 311, 'MONTERREY', '65000', '018262684415', '', 'prodencino@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (413, 1, 'PRODUCTOS ELECTROMECANICOS DEL PARQUE SA DE CV', '', 'ROBERTO MARQUEZ IBARRA', '', 'PEP-830603-2M7', 1, 'Moneda nacional', 310, 'LERDO', '35150', '725 81 80', '', 'delparque83@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (16870, 1, 'PROGRAMAS TECNICOS  DE  MEXICO SA DE CV', '', 'ROMAN CORRALES', '', 'PTM140520J63', 1, 'Moneda nacional', 307, 'TORREON', '27130', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (33248, 1, 'PROMOCIONES LAVATTO S.A DE C.V', '', '', '', 'PLA190301I81', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'adboxanuncios@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (489, 1, 'PROVEEDORA MEXICANA DE MATERIALES SA DE CV', '', '', '', 'PMM700717WQ0', 1, 'Moneda nacional', 307, 'TORREON', '27100', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:48', '2020-10-19 10:38:48', 5, 5);
INSERT INTO `proveedores` VALUES (36233, 1, 'PROVEPUERTAS SA DE CV', '', '', '', 'PRO0910293D7', 1, 'Moneda nacional', 311, 'MONTERREY', '66059', '8183322135', '8117277568', 'pesquivel@provepuertas.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (25306, 1, 'PROYECTOS Y EDIFICACIONES FESA DE LA LAGUNA S.A. DE C.V', '', '', '', 'PYE090925F93', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '2114578', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (33359, 1, 'PUBLI IMPRESO S.A. DE CV.', '', '', '', 'PIM070312K22', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '', '', 'facturacion.grupomonteromi@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (703, 1, 'PUERTAS Y MARCOS AJUSTABLES S.A. DE C.V.', '', 'AARON RAMOS VILLARREAL', '', 'PMA-1205231-I3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '66610', '81-83-85-57-07', '', 'aaramos@pymaa.com.mx;ghurtado@pymaa.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (25053, 1, 'PopUp Design S. de RL. De CV.', '', '', '', 'PDE140513FR0', 1, 'Moneda nacional', 21664, 'MEXICO D.F', '25000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (34354, 1, 'QUALITY VIEW, S.A. DE C.V.', '', '', '', 'QVI161216L96', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35020', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (777, 1, 'QUATTRO ARQUITECTURA  Y CONSTRUCCIONES SA DE CV', '', 'LIDIA ESPINOZA', '', 'QAC0601198K5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27274', '7-22-88-10', '', 'lidia_espinoza20@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (455, 1, 'RADIOMOVIL DIPSA SA DE CV', '', '', '', 'RDI841003QJ4', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '11529', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (32191, 1, 'RAMIREZ AGUILAR  JESUS ANGEL', '', '', '', 'RAAJ640802FG9', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (581, 1, 'RAMIREZ ANDRADE JESUS', '', 'NADIA', 'NADIA', 'RAAJ 631218 E91', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7182829', '', 'ofiplustorreon@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (34069, 1, 'RAUL AGUIRRE RAMIREZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (29825, 1, 'RAUL AUSENCIO BLASQUEZ CANTU', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 318, 'DURANGO', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:49', '2020-10-19 10:38:49', 5, 5);
INSERT INTO `proveedores` VALUES (357, 1, 'RECUBRIMIENTOS Y ADHESIVOS DE LA LAGUNA SA DE CV', '', 'EDUARDO CRUZ', '', 'RAL910124RN9', 1, 'Moneda nacional', 307, 'TORREON', '27019', '7506465', '2252672', 'edicruzromo@real-sa.com', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (646, 1, 'REFACCIONARIA DE LA LAGUNA DEL NORTE SA DE CV ', '', '', '', 'RLN811026ED7', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (353, 1, 'REGISTRO UNICO DE VIVIENDA', '', '', '', '', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '01020', '018000077788', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (27795, 1, 'RENE DUEÑAS ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (23348, 1, 'REYES/ORONA,MIRIAM', '', '', '', 'REOM-750918-LW3', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (26060, 1, 'RICARDO PEREZ AYALA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (35908, 1, 'RICARDO SABIDO CORTES', '', '', '', 'SACR881012E12', 1, 'Moneda nacional', 307, 'TORREON', '27268', '8711412780', '', 'sarcotorreon@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (35763, 1, 'RICARDO SERGIO SANCHEZ MARTINEZ ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27274', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (583, 1, 'RIVAS ALVARADO PABLO', '', 'ARIANA PEREZ', '', 'RIAP 671201 T71', 1, 'Moneda nacional', 320, 'GUADALAJARA', '44500', '018008010932', '', 'ariana.perez@okhosting.com', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (507, 1, 'RIVERA SIERRA NATIVIDAD', '', '', '', 'RISN600907CH7', 1, 'Moneda nacional', 307, 'TORREON', '27453', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (373, 1, 'RIVERS SYSTEMS SA DE CV', '', 'SARAH ROSALES', '', 'RSY020506QIA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7135059', '018008210577', 'srosales@rivers.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (27700, 1, 'ROBERTO GARCIA SEAÑEZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (31098, 1, 'ROBERTO IBARRA SAUCEDO', '', '', '', 'IASR790702LZ3', 1, 'Moneda nacional', 307, 'TORREON', '27010', '8711890921', '', 'robe_ibarra@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:50', '2020-10-19 10:38:50', 5, 5);
INSERT INTO `proveedores` VALUES (25395, 1, 'ROCIO DE LOS SANTOS GALLEGOS', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:51', '2020-10-19 10:38:51', 5, 5);
INSERT INTO `proveedores` VALUES (30966, 1, 'RODOLFO IBARRA SAUCEDO', '', '', '', 'IASR790702LZ3', 1, 'Moneda nacional', 307, 'TORREON', '27010', '8711890921', '', 'robe_ibarra@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:51', '2020-10-19 10:38:51', 5, 5);
INSERT INTO `proveedores` VALUES (693, 1, 'RODOLFO OSVALDO AYALA REYES', '', '', '', 'AARR751102HD6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '3-15-56-21', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:51', '2020-10-19 10:38:51', 5, 5);
INSERT INTO `proveedores` VALUES (719, 1, 'RODRIGO AGUSTIN MONTENEGRO ALBA', '', '', '', 'MOAR680828JC0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35015', '', '', ' fareme1@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:51', '2020-10-19 10:38:51', 5, 5);
INSERT INTO `proveedores` VALUES (701, 1, 'ROJAS ALVARADO JOSE ANTONIO', '', '', '', 'ROAA6903091F2', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:51', '2020-10-19 10:38:51', 5, 5);
INSERT INTO `proveedores` VALUES (451, 1, 'ROMO MACIAS PEDRO ERNESTO', '', '', '', 'ROMP661107 9L8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '718 33 69', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:51', '2020-10-19 10:38:51', 5, 5);
INSERT INTO `proveedores` VALUES (21858, 1, 'ROSA ADRIANA RODRIGUEZ RIOS', '', '', '', 'RORR780408GK6', 1, 'Moneda nacional', 307, 'TORREON', '27105', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:51', '2020-10-19 10:38:51', 5, 5);
INSERT INTO `proveedores` VALUES (33931, 1, 'ROSA ELBA MENDEZ DOMIGUEZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2020-10-19 10:38:51', '2021-02-23 15:52:09', 5, 0);
INSERT INTO `proveedores` VALUES (513, 1, 'ROSALES CABRAL VICTOR MANUEL', '', '', '', 'ROCV5905265I5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:51', '2020-10-19 10:38:51', 5, 5);
INSERT INTO `proveedores` VALUES (29078, 1, 'ROSENDO LOPEZ RODRIGUEZ ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:51', '2020-10-19 10:38:51', 5, 5);
INSERT INTO `proveedores` VALUES (27476, 1, 'RUBEN REYES VALENZUELA', '', '', '', 'REVR860317929', 1, 'Moneda nacional', 310, 'LERDO', '35150', '871345026', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:51', '2020-10-19 10:38:51', 5, 5);
INSERT INTO `proveedores` VALUES (25567, 1, 'RUBEN RODRIGUEZ ORTIZ', '', '', '', 'ROOR610821B69', 1, 'Moneda nacional', 307, 'TORREON', '27274', '', '', 'ruben61@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (660, 1, 'RUIZ AVILA RICARDO', '', '', '', 'RUAR700328JQ4', 1, 'Moneda nacional', 307, 'TORREON', '27200', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (365, 1, 'RUIZ RAMIREZ GREGORIO', '', 'MARTIN ARANDA', '', 'RURG550221FF7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '7238484', '', 'martinaranda@ymail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (377, 1, 'RUIZ VAZQUEZ EDUARDO', '', 'BORIS', 'GUILLERMO', 'RUVE630720N2A', 1, 'Moneda nacional', 307, 'TORREON', '27275', '7204273', '', 'georuva@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (25897, 1, 'SAGRARIO CORAZON CHAVEZ SANDATE', '', '', '', 'CASS9205105Z7', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (21748, 1, 'SAID JULIAN DIAZ BATARSE', '', '', '', 'DIBS820428UB2', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (642, 1, 'SALCIDO SANDOVAL ALBERTO', '', '', '', '', 1, 'Moneda nacional', 320, 'GUADALAJARA', '44190', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (667, 1, 'SALMON DE LA LAGUNA  S.A. DE C.V.', '', '', '', 'SLA8210184A7', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7-16-36-51', '', 'tito.santos@gebesa.com', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (671, 1, 'SALMON DE LA LAGUNA SA DE CV ', '', '', '', 'SLA8210184A7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (736, 1, 'SALOMON GERARDO CASTRO ENRIQUEZ ', '', '', '', 'CAES560625SIA', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27110', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (689, 1, 'SALPER S.A. DE C.V.', '', '', '', '', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7-12-79-90', '', 'salpertorreon@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (34144, 1, 'SALVADOR TORRES MARIN ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (23904, 1, 'SAMIR JAIDAR GUTIERREZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:52', '2020-10-19 10:38:52', 5, 5);
INSERT INTO `proveedores` VALUES (22845, 1, 'SAMUEL FLORES MORALES', '', '', '', 'FOMS951108A76', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35044', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:53', '2020-10-19 10:38:53', 5, 5);
INSERT INTO `proveedores` VALUES (33453, 1, 'SAMUEL HUERTA TREVIÑO', '', '', '', 'HUTS850110SI4', 1, 'Moneda nacional', 311, 'MONTERREY', '66350', '', '3314524414', 'javier.trevino@innotrev.com', 'ACTIVO    ', 1, '2020-10-19 10:38:53', '2020-10-19 10:38:53', 5, 5);
INSERT INTO `proveedores` VALUES (23965, 1, 'SANDRA LUZ RODRIGUEZ', '', '8711247748', '', 'XAXX010101000', 1, 'Moneda nacional', 310, 'LERDO', '24350', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:53', '2020-10-19 10:38:53', 5, 5);
INSERT INTO `proveedores` VALUES (26865, 1, 'SANJUANA MACHADO PARGA', '', '', '', 'MAPS491116E46', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:53', '2020-10-19 10:38:53', 5, 5);
INSERT INTO `proveedores` VALUES (533, 1, 'SCOTIABANK', '', 'CLAUDIA PALACIOS', '', 'SIN9412025I4', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '06820', '7490368', '', 'cpalaciosc@scotiabank.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:53', '2020-10-19 10:38:53', 5, 5);
INSERT INTO `proveedores` VALUES (19405, 1, 'SEARS OPERADORA MEXICO, S.A. DE C.V.', '', '', '', 'SOM101125UEA', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:53', '2020-10-19 10:38:53', 5, 5);
INSERT INTO `proveedores` VALUES (19275, 1, 'SECRETARIA DE FINANZAS Y ADMON. DEL EDO. DE DURANGO', '', '', '', 'GED620101652', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:53', '2020-10-19 10:38:53', 5, 5);
INSERT INTO `proveedores` VALUES (21665, 1, 'SEGUROS ATLAS S.A', '', '', '', 'SAT8410245V8', 1, 'Moneda nacional', 21664, 'MEXICO D.F', '05120', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:53', '2020-10-19 10:38:53', 5, 5);
INSERT INTO `proveedores` VALUES (25177, 1, 'SEISA ELECTROMECANICA SA DE CV', '', '', '', 'SEL1509223I5', 1, 'Moneda nacional', 307, 'TORREON', '27089', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:54', '2020-10-19 10:38:54', 5, 5);
INSERT INTO `proveedores` VALUES (553, 1, 'SELLOS IMPERMEABLES DEL NORTE S.A. DE C.V.', '', 'Patricia', '', 'SIN050622AA7', 1, 'Moneda nacional', 307, 'TORREON', '27020', '7181812', '8711513215', 'protexatorreon@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:54', '2020-10-19 10:38:54', 5, 5);
INSERT INTO `proveedores` VALUES (32295, 1, 'SERGIO GABRIEL CUETO GONZALEZ ', '', '', '', 'CUGS940614AN3', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35090', '8711358552', '', 'graph_publicity@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:54', '2020-10-19 10:38:54', 5, 5);
INSERT INTO `proveedores` VALUES (737, 1, 'SERGIO LUIS ALVARADO SALDIVAR ', '', '', '', 'AASS710908JB5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:54', '2020-10-19 10:38:54', 5, 5);
INSERT INTO `proveedores` VALUES (28838, 1, 'SERGIO RAMIREZ MARTINEZ', '', '', '', 'RAMS621130474', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8717138099', '8717227383', '', 'ACTIVO    ', 1, '2020-10-19 10:38:54', '2020-10-19 10:38:54', 5, 5);
INSERT INTO `proveedores` VALUES (673, 1, 'SERVICIO AUTOMOTRIZ DE TORREON SA DE CV ', '', '', '', 'SAT071211FD3', 1, 'Moneda nacional', 307, 'TORREON', '27089', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:54', '2020-10-19 10:38:54', 5, 5);
INSERT INTO `proveedores` VALUES (21517, 1, 'SERVICIO DE ADMINISTRACION TRIBUTARIA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:54', '2020-10-19 10:38:54', 5, 5);
INSERT INTO `proveedores` VALUES (28800, 1, 'SERVICIOS  DE LOGISTICA Y REMOLQUES HERZA DE LA LAGUNA SA', '', '', '', 'SLR180921R59', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35043', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:54', '2020-10-19 10:38:54', 5, 5);
INSERT INTO `proveedores` VALUES (27866, 1, 'SERVICIOS DE SALUD DE COAHUILA DE ZARAGOZA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:54', '2020-10-19 10:38:54', 5, 5);
INSERT INTO `proveedores` VALUES (503, 1, 'SERVICIOS ELECTROHIDRAULICOS INTEGRALES SA DE CV', '', '', '', 'SEI0305095T3', 1, 'Moneda nacional', 307, 'TORREON', '27275', '7486040', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (27800, 1, 'SERVICIOS MEDICOS DE EMERGENCIA DE LA LAGUNA S.C.', '', '', '', 'SME031010HZ5', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7206000', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (23434, 1, 'SINDICATO MORELENSE DE TRABAJADORES DE LA INDUSTRIA DEL COMERCIO Y PRESTADORES DE SERVICIO GENER', '', '', '', 'SMT151107EG5', 1, 'Moneda nacional', 315, 'ESTADO DE MEXICO', '62300', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (25222, 1, 'SINERGIA INMOBILIARIA DE MEXICO, S.A. DE C.V.', '', '', '', 'SIM110318DF9', 1, 'Moneda nacional', 307, 'TORREON', '27018', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (614, 1, 'SISTEMA DE AGUA POTABLE Y ALCANTARILLADO DEL MUNICIPIO DE CD LERDO DGO', '', '', '', 'SAP990715876', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', 'sapalerdo1@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (24614, 1, 'SISTEMA DESCENTRALIZADO DE AGUA POTABLE Y ALCANTARILLADO DEL MPIO DE GOMEZ PALACIO DGO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (34903, 1, 'SISTEMAS AMERICANOS PARA RIEGO, S.A. DE C.V.', '', '', '', 'SAR-020130-BP1', 1, 'Moneda nacional', 307, 'TORREON', '27010', '8717226161', '', 'tere.compras@sistemasamericanos.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (35448, 1, 'SISTEMAS EMPRESARIALES DABO SA DE CV', '', '', '', 'SED881215J89', 1, 'Moneda nacional', 35447, 'MAZATLAN', '82103', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (34616, 1, 'SOCIEDAD COOPERATIVA AGROPECUARIA DE LA COMARCA LAGUNERA, S.C.L.', '', '', '', 'SCA710416IM4', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35079', '87174805000', '', 'l.herrera@cooplaguna.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (611, 1, 'SOLUCIONES INTEGRALES DE REINGENIERIA Y ADMINISTRACION SC', '', '', '', 'SIR110902N91', 1, 'Moneda nacional', 324, 'NAUCALPAN', '53127', '015562662403', '', 'soporte@analisiscomercialsira.com', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (21253, 1, 'SOLUCIONES PATRIMONIALES CUFRISA SA DE CV', '', '', '', 'SPC170117RL9', 1, 'Moneda nacional', 312, 'SAN PEDRO', '72764', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (651, 1, 'SURMAN MOTORS SA DE CV ', '', '', '', 'SMO99011491A', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:55', '2020-10-19 10:38:55', 5, 5);
INSERT INTO `proveedores` VALUES (762, 1, 'TCI TRANSPORTES, SA DE CV', '', '', '', 'TTR990121-FU7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27280', '8717297500', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (20079, 1, 'TECNICENTRO GUZMAN S.A. DE C.V.', '', '', '', 'TGU161006GV2', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '82103', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (35840, 1, 'TECNOLOGIA Y ASESORIA EN REDES, SA DE CV', '', '', '', 'TAR9606155Q6', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '8717166301', 'soporte@tyar.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (24279, 1, 'TELEFONIA POR CABLE SA DE CV', '', '', '', 'TCA0407219T6', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (597, 1, 'TELEFONOS DE MEXICO SAB DE CV', '', '', 'ROBERTO MARTINEZ', 'TME840315KT6', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '06500', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (640, 1, 'TEPEPA ROSALES JOSE LUIS', '', '', '', 'TERL830914NA6', 1, 'Moneda nacional', 310, 'LERDO', '35159', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (24709, 1, 'TESORERIA MUNICIPAL DE GOMEZ PALACIO, DGO.', '', '', '', 'TMU820908EP0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '1-75-10-00', '', 'aciudadana@gomezpalacio.gob.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (28165, 1, 'TESORERIA MUNICIPAL DE TORREON', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (25420, 1, 'TESORERIA MUNICPAL CD LERDO DGO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (545, 1, 'TEXA DE LA LAGUNA S.A DE C.V', '', 'MARCO TRUJILLO', '', '', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35070', '7575000', '8711613500', 'servicio@texasa.net', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (663, 1, 'TIENDAS SORIANA S.A. DE C.V.', '', '', '', 'TSO991022PB6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35090', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (537, 1, 'TODD DE LA GARZA Y TORRES, S.C.', '', 'FERNANDO TODD', '', 'TGT130212SR0', 1, 'Moneda nacional', 307, 'TORREON', '27000', '2280725', '', 'todd@heralde.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (19220, 1, 'TOMAS GALVAN CAMACHO', '', '', '', 'CACT6109199B2', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:56', '2020-10-19 10:38:56', 5, 5);
INSERT INTO `proveedores` VALUES (375, 1, 'TORRES AVALOS DAVID ERNESTO', '', 'DAVID ERNESTO TORRES AVALOS', '', 'TOAD650330I35', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '8711645386', '', 'ventas@asproecom.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (477, 1, 'TORRES OLIVARES MARCO ANTONIO', '', '', '', 'TOOM880614GK8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7324989', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (419, 1, 'TRANSFORMADORES Y PROYECTOS INDUSTRIALES SA DE CV', '', '', '', '', 1, 'Moneda nacional', 313, 'SALTILLO', '25210', '844 288. 4040', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (28256, 1, 'TRANSPORTES JULIAN DE OBREGON SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'monterrey.auxcobranza1@tjo.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (421, 1, 'TRAVERTINOS LAGUNA SA DE CV', '', 'NANCY FLORES', '', 'TLA030218440', 1, 'Moneda nacional', 310, 'LERDO', '', '759 17 20 EXT 103', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (636, 1, 'TRES DIMENSIONES SISTEMAS CONSTRUCTIVOS SA DE CV ', '', 'CLAUDIA CONTRERAS', '', 'TDS990423UZ1', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (401, 1, 'TRITURADOS CRIBISSA SA DE CV', '', 'NANCY', '', 'TCS970503824', 1, 'Moneda nacional', 310, 'LERDO', '35153', '725 37 42', '', 'ventas@cribissa.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (557, 1, 'TUBERIA Y CABLES SA DE CV', '', '', 'PEPE', 'TCA12032844A', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7938775', '', 'ventas_tycsa@prodigy.net.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (36551, 1, 'TUBERIA Y VALVULAS METRO S DE R.L. DE C.V.', '', '', '', 'TVM180518S85', 1, 'Moneda nacional', 30634, 'MEXICO', '31105', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (387, 1, 'ULTRACONCRETO SA DE CV', '', 'ESTEFANIA', '', 'ULT0602043R4', 1, 'Moneda nacional', 307, 'TORREON', '27270', '2096767', '2096768', 'averdin@viviend.mx;almacen@viviend.mx;compras@viviend.mx;hsalinas@viviend.mx;ultraconcreto.ventas@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (654, 1, 'VALDES BARBA LETICIA', '', '', '', 'VABL530606AM8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'geaoficinamty@hotmail.com;acrilgea@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:57', '2020-10-19 10:38:57', 5, 5);
INSERT INTO `proveedores` VALUES (26611, 1, 'VALSA PANEL, S.A. DE C.V.', '', '8119171947', '', 'VPA920617QZ3', 1, 'Moneda nacional', 311, 'MONTERREY', '66062', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (21986, 1, 'VALUACION ORGANIZADA, SA DE CV', '', '', '', 'VOR0309304H3', 1, 'Moneda nacional', 21985, 'CORDOVA', '94500', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (31040, 1, 'VANILLA INK PRINT CENTER', '', '', '', 'VCO170220E50', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8712962998', '', 'vanilla.admon@gmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (565, 1, 'VELASCO DE LA RIVA MARCO ANTONIO', '', 'Raquel 7-14-19-02', '', 'VERM750115F15', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7141902', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (399, 1, 'VELASCO RUBIO MARIA EUGENIA', '', 'MARCELO ARMENDARIZ', '', 'VERE6011027D1', 1, 'Moneda nacional', 310, 'LERDO', '35150', '7404261', '8711376061', 'arvelconstrucciones@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (622, 1, 'VELOZ NEVAREZ MARIANA', '', '', '', 'VENM890621RI4', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (609, 1, 'VENTACERO EXPRESS SA DE CV', '', '', '', 'VEX090807ED9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35029', '7481200', '', 'suc.morelos@ventacero.com', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (28151, 1, 'VENTANAS PREFABRICADAS DE ALUMINIO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 311, 'MONTERREY', '65000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (21221, 1, 'VERONICA CONCEPCION RIOS LIRA', '', '', '', 'RILV680831FP6', 1, 'Moneda nacional', -1, '', '82157', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (27372, 1, 'VICENTE GODINEZ ESPINOZA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 320, 'GUADALAJARA', '45000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (35117, 1, 'VICTOR ANGEL SANCHEZ GARCIA', '', '', '', 'SAGV6207273T9', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:58', '2020-10-19 10:38:58', 5, 5);
INSERT INTO `proveedores` VALUES (30458, 1, 'VICTOR ESQUIVEL TRINIDAD', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (26608, 1, 'VIDRIOS VISAGO SA DE CV', '', '87157655642', '', 'VVI101215UD4', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (369, 1, 'VILLALPANDO ARREOLA SAN JUANA', '', 'ROBERTO RAMIREZ', '', 'VIAS660720US5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35018', '7370748', '8711410118', 'ingramiremurillo@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (21551, 1, 'VIVANTU SOSTENIBLEMENTE S.C', '', '', '', 'VSO1706122Q9', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '6500', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (32781, 1, 'VIVIEND INMOBILIARIA SA DE CV', '', '', '', 'VIN060711I30', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35013', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (423, 1, 'WINDOOR SA DE CV', '', 'AARON RAMOS', '', 'WIN990127BW5', 1, 'Moneda nacional', 311, 'MONTERREY', '66634', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (24462, 1, 'YARELY V. RIOS LOPEZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (21641, 1, 'YESIKA RODRIGUEZ CONTRERAS', '', '', '', 'ROCY790102FH1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (34258, 1, 'YOLANDA PRISCILA GALVAN NEVAREZ ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (658, 1, 'ZAIN MARIN ALIA NUR', '', 'Ing. Sami Alejandro Zain', '', 'ZAMA890924540', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27130', '7-13-56-00', '', 'malla.acero@hotmail.com', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (547, 1, 'ZAPATERIAS SUPER SA DE CV', '', 'TERE DE J ROCHA GALVAN', '', 'ZSU920314FC2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35070', '7124875', '7194455', 'creditoycobranza@discalse.com.mx', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (774, 1, 'ZARLAG SA DE CV', '', '', '', 'ZAR760126963', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO    ', 1, '2020-10-19 10:38:59', '2020-10-19 10:38:59', 5, 5);
INSERT INTO `proveedores` VALUES (23946, 1, 'ZERVAL SOLUCION S.A. DE C.V.', '', '8711234293', '', 'ZSO160308DE5', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'r.ssm@outlook.es', 'ACTIVO    ', 1, '2020-10-19 10:39:00', '2020-10-19 10:39:00', 5, 5);
INSERT INTO `proveedores` VALUES (38824, 1, 'ANGELICA IVONNE CHAVEZ TOSCANO', '', '', '', 'CATA840612NG8', 1, 'Moneda nacional', 35447, 'MAZATLAN', '82000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:03', '2021-02-23 15:52:03', 0, 0);
INSERT INTO `proveedores` VALUES (42048, 1, 'ASOCIACION DE COLOS DEL FRACC RESIDENCIAL HACIENDA EL ROSARIO AC', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:04', '2021-02-23 15:52:04', 0, 0);
INSERT INTO `proveedores` VALUES (40853, 1, 'AYUNTAMIENTO DE TORREON', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:04', '2021-02-23 15:52:04', 0, 0);
INSERT INTO `proveedores` VALUES (39159, 1, 'Aluminio y Vidrio de la Laguna, S.A. DE C.V.', '', '', '', 'AVL160113HX2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35078', '(871) 7199869', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:04', '2021-02-23 15:52:04', 0, 0);
INSERT INTO `proveedores` VALUES (40509, 1, 'CEVIBE S.A. DE C.V.', '', '', '', 'CEV091028SV4', 1, 'Moneda nacional', 307, 'TORREON', '', '2283535', '8714106567', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:04', '2021-02-23 15:52:04', 0, 0);
INSERT INTO `proveedores` VALUES (40347, 1, 'COLEGIO DE ARQUITECTOS DE LA COMARCA LAGUNERA A.C.', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27275', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:04', '2021-02-23 15:52:04', 0, 0);
INSERT INTO `proveedores` VALUES (41379, 1, 'COMERCIALIZADORA Y CONSTRUCTORA XEAKSA SA DE CV', '', '', '', 'CCX180626RE1', 1, 'Moneda nacional', 307, 'TORREON', '27148', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:04', '2021-02-23 15:52:04', 0, 0);
INSERT INTO `proveedores` VALUES (40427, 1, 'CONSTRUCTORA Y PROVEEDORA FERRETO S.A. DE C.V.', '', '', '', 'CPF860424UB7', 1, 'Moneda nacional', 307, 'TORREON', '', '8717201091', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:05', '2021-02-23 15:52:05', 0, 0);
INSERT INTO `proveedores` VALUES (37756, 1, 'CRAZY MOTORES Y VEHICULOS, SA. DE C.V.', '', '', '', 'CMY1004124M1', 1, 'Moneda nacional', 35447, 'MAZATLAN', '80090', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:05', '2021-02-23 15:52:05', 0, 0);
INSERT INTO `proveedores` VALUES (41912, 1, 'ENRIQUE DEL VILLAR BRIONES', '', '', '', 'VIBE741007QL9', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:05', '2021-02-23 15:52:05', 0, 0);
INSERT INTO `proveedores` VALUES (39394, 1, 'FERRETERIA LA NUEVA VICTORIA DE RODEO, SA DE CV', '', '', '', 'FNV050308T21', 1, 'Moneda nacional', 307, 'TORREON', '27130', '8717173531', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:05', '2021-02-23 15:52:05', 0, 0);
INSERT INTO `proveedores` VALUES (39208, 1, 'GILSA SA DE CV', '', 'SOFIA DUARTE', '', 'GIL820401SX1', 1, 'Moneda nacional', 313, 'SALTILLO', '25200', '8444548001', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:06', '2021-02-23 15:52:06', 0, 0);
INSERT INTO `proveedores` VALUES (38936, 1, 'GRUAS MOVER S.A. DE C.V.', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35079', '8717192000', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:06', '2021-02-23 15:52:06', 0, 0);
INSERT INTO `proveedores` VALUES (39538, 1, 'GRUPO LOROMO INNOVACION EN EVENTOS SA DE CV', '', '', '', 'GLI1909121VA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8712341172', '', 'manolaeventost@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:06', '2021-02-23 15:52:06', 0, 0);
INSERT INTO `proveedores` VALUES (41263, 1, 'INMOBILIARIA PLAZA IBERIA SA DE CV', '', '', '', 'IPI120811EF3', 1, 'Moneda nacional', 307, 'TORREON', '27018', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:07', '2021-02-23 15:52:07', 0, 0);
INSERT INTO `proveedores` VALUES (37738, 1, 'ISOCONTENEDORES MARITIMOS SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 311, 'MONTERREY', '65000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:07', '2021-02-23 15:52:07', 0, 0);
INSERT INTO `proveedores` VALUES (38220, 1, 'JESUS SANTANA TRIANA', '', '', '', 'SATJ760326FV9', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8713791702', '', 'ferreteriasantana@prodigy.net.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:07', '2021-02-23 15:52:07', 0, 0);
INSERT INTO `proveedores` VALUES (41938, 1, 'JORGE ARTURO ZAAMBRANO FERNANDEZ', '', '', '', 'ZAFA580729EM8', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:07', '2021-02-23 15:52:07', 0, 0);
INSERT INTO `proveedores` VALUES (37731, 1, 'JOSE LUIS NUÑEZ SALDAÑA', '', '', '', 'NUSL550911QD8', 1, 'Moneda nacional', 307, 'TORREON', '27743', '8711142160', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:07', '2021-02-23 15:52:07', 0, 0);
INSERT INTO `proveedores` VALUES (38895, 1, 'JUAN GABRIEL LOERA CHAVEZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8711515751', '', 'davidloera.24@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:07', '2021-02-23 15:52:07', 0, 0);
INSERT INTO `proveedores` VALUES (40856, 1, 'LIC. HUMBERTO NEVAREZ NOTARIO PUBLICO No. 02', '', '', '', '', 1, 'Moneda nacional', -1, '', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:08', '2021-02-23 15:52:08', 0, 0);
INSERT INTO `proveedores` VALUES (37725, 1, 'MANUEL MENA ADAME', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:08', '2021-02-23 15:52:08', 0, 0);
INSERT INTO `proveedores` VALUES (40539, 1, 'MARGARITA SALINAS BRIONES', '', '', '', 'SABM6411173Y7', 1, 'Moneda nacional', 307, 'TORREON', '27087', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:08', '2021-02-23 15:52:08', 0, 0);
INSERT INTO `proveedores` VALUES (39267, 1, 'OFICENTRO, S.A. DE C.V.', '', 'JUANIS MEJIA', '', 'OFI-710529-291', 1, 'Moneda nacional', 307, 'TORREON', '27000', '871712-90-40', '', 'VENTAS1@OFICENTRO.COM', 'ACTIVO                 ', 1, '2021-02-23 15:52:08', '2021-02-23 15:52:08', 0, 0);
INSERT INTO `proveedores` VALUES (40121, 1, 'PALMAS AUTOMOTRIZ SA DE CV', '', '', '', 'PAU981125RRA', 1, 'Moneda nacional', 35447, 'MAZATLAN', '82110', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:09', '2021-02-23 15:52:09', 0, 0);
INSERT INTO `proveedores` VALUES (41499, 1, 'PROVEEDORA DE RINES Y LLANTAS MONTERREY SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:09', '2021-02-23 15:52:09', 0, 0);
INSERT INTO `proveedores` VALUES (37769, 1, 'RAUL VILLA HERNANDEZ', '', '', '', 'VIHR760228E70', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:09', '2021-02-23 15:52:09', 0, 0);
INSERT INTO `proveedores` VALUES (40377, 1, 'REGISTRO PUBLICO DE LA PROPIEDAD', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:09', '2021-02-23 15:52:09', 0, 0);
INSERT INTO `proveedores` VALUES (38948, 1, 'ROSENDO SALOMON MONTIEL', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:10', '2021-02-23 15:52:10', 0, 0);
INSERT INTO `proveedores` VALUES (39732, 1, 'SEGUROS BANORTE SA DE CV, GRUPO FINANCIERO BANORTE', '', '', '', 'SBG971124PL2', 1, 'Moneda nacional', 311, 'MONTERREY', '64000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:10', '2021-02-23 15:52:10', 0, 0);
INSERT INTO `proveedores` VALUES (40091, 1, 'SERGIO DAVID MERCADO VERA', '', '', '', 'MEVS940713R60', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:10', '2021-02-23 15:52:10', 0, 0);
INSERT INTO `proveedores` VALUES (37751, 1, 'SERVICIOS DENTALES DENT SC', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:10', '2021-02-23 15:52:10', 0, 0);
INSERT INTO `proveedores` VALUES (40858, 1, 'SIDEAPA', '', '', '', 'SDA920814CIA', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:10', '2021-02-23 15:52:10', 0, 0);
INSERT INTO `proveedores` VALUES (39624, 1, 'TALAVI, S.A. DE C.V.', '', '', '', 'TAL120627M80', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:10', '2021-02-23 15:52:10', 0, 0);
INSERT INTO `proveedores` VALUES (38120, 1, 'TEAMVIEWER GERMANY GMBH', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 34791, 'CIUDAD DE MEXICO', '73033', '5547743047', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:10', '2021-02-23 15:52:10', 0, 0);
INSERT INTO `proveedores` VALUES (40888, 1, 'TESORERIA MUNICIPAL DE MAZATLAN', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 35447, 'MAZATLAN', '0000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:10', '2021-02-23 15:52:10', 0, 0);
INSERT INTO `proveedores` VALUES (38880, 1, 'TOTAL PLAY TELECOMUNICACION SA DE CV', '', '', '', 'TPT890516JP5', 1, 'Moneda nacional', 30634, 'MEXICO', '04519', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:11', '2021-02-23 15:52:11', 0, 0);
INSERT INTO `proveedores` VALUES (39040, 1, 'TRANSPORTES ANSO, S.A. DE C.V.', '', '', '', 'TAN1603054F2', 1, 'Moneda nacional', 311, 'MONTERREY', '67330', '8122624050', '', 'logistica@transportesanso.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:11', '2021-02-23 15:52:11', 0, 0);
INSERT INTO `proveedores` VALUES (40455, 1, 'TS MATERIAL ELECTRICO E ILUMINACION S.A. DE C.V.', '', '', '', 'TME170302D27', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:11', '2021-02-23 15:52:11', 0, 0);
INSERT INTO `proveedores` VALUES (40396, 1, 'UNIFORMES TAMPICO SA DE CV', '', '', '', 'UTA820628TV3', 1, 'Moneda nacional', 317, 'TAMAULIPAS', '89359', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:11', '2021-02-23 15:52:11', 0, 0);
INSERT INTO `proveedores` VALUES (41491, 1, 'VJ ASEGURAMIENTO Y CONSULTORIA SC', '', '', '', 'VAC2006238V6', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:11', '2021-02-23 15:52:11', 0, 0);
INSERT INTO `proveedores` VALUES (37950, 1, 'WENDOLYNE VILLA RUIZ', '', '', '', 'VIRW8905099Y7', 1, 'Moneda nacional', 307, 'TORREON', '27087', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:11', '2021-02-23 15:52:11', 0, 0);
INSERT INTO `proveedores` VALUES (22873, 2, 'ABA SEGUROS S.A DE C.V', '', '', '', 'ABA 920310 QW0', 1, 'Moneda nacional', 22872, 'GARZA GARICA', '66260', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:34', '2021-02-23 15:52:34', 0, 0);
INSERT INTO `proveedores` VALUES (19266, 2, 'ABA SEGUROS, S.A. DE C.V.', '', '', '', 'ABA 920310QW0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:34', '2021-02-23 15:52:34', 0, 0);
INSERT INTO `proveedores` VALUES (417, 2, 'ABASTECEDORES ELECTROMECANICOS DEL NORTE S.A.', '', 'Luz Galarza', '', 'AEM8202034B1', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35078', '871 175 03 00', '', 'luz.galarza@aemnsa.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;averdin@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:34', '2021-02-23 15:52:34', 0, 0);
INSERT INTO `proveedores` VALUES (591, 2, 'ABRAHAM GARCIA LAURA', '', '', '', 'AAGL850129F45', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'docuprint.juarez@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:34', '2021-02-23 15:52:34', 0, 0);
INSERT INTO `proveedores` VALUES (485, 2, 'ACOSTA DELGADO FERNANDO DANIEL', '', '', '', 'AODF830923SW8', 1, 'Moneda nacional', 307, 'TORREON', '27297', '8717250505', '', 'fdo.firsa@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (20430, 2, 'ADRIAN HOMERO DOMINGUEZ ALANIS', '', '', '', 'DOAA800630FI8', 1, 'Moneda nacional', 307, 'TORREON', '27268', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (71689, 2, 'AGENCIA MX-5 SA DE CV', '', '', '', 'AMG0608239L9', 1, 'Moneda nacional', 69163, 'CULIACAN', '80020', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (72321, 2, 'AGRICOLA Y COMERCIAL SAN KISSTOLO SA DE CV', '', '', '', 'ACS931020HF6', 1, 'Moneda nacional', 69163, 'CULIACAN', '80396', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (491, 2, 'AISLANTES TERMOACUSTICOS DEL NORTE SA DE CV', '', '', '', 'ATN040701896', 1, 'Moneda nacional', 307, 'TORREON', '27280', '7322411', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (68365, 2, 'ALAYZA ESCARLETH MEJIA VILLEGAS', '', '', '', 'MEVA871011H50', 1, 'Moneda nacional', 307, 'TORREON', '27277', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (22148, 2, 'ALEJANDRA PUENTES OLMOS', '', '', '', 'PUOA810221H44', 1, 'Moneda nacional', 307, 'TORREON', '27060', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (20405, 2, 'ALEJANDRO ALBARRA MARQUEZ', '', '', '', 'AAMA880712ANA', 1, 'Moneda nacional', 315, 'ESTADO DE MEXICO', '54910', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (531, 2, 'ALTO PROTECCION INTEGRAL SA DE CV', '', '', '', 'API0508041E8', 1, 'Moneda nacional', 307, 'TORREON', '27268', '', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (711, 2, 'AMADOR LOZANO ESCOBEDO', '', '', '', 'LOEA660720AM1', 1, 'Moneda nacional', 307, 'TORREON', '35150', '', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (20724, 2, 'ANA MINERVA ALVARADO MORALES', '', '', '', 'AAMA7805217X6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35025', '719 55 44', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:35', '2021-02-23 15:52:35', 0, 0);
INSERT INTO `proveedores` VALUES (21924, 2, 'ANDREA PATRICIA RUIZ GARCIA', '', '', '', 'RUGA941006M50', 1, 'Moneda nacional', 310, 'LERDO', '35158', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (741, 2, 'ANDRES II CAVAZOS CHAPA', '', '', '', 'CACX810623C61', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '64880', '', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (770, 2, 'ANTULIO VILLARREAL SANCHEZ ', '', '', '', 'VISA690619DC3', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (449, 2, 'ANTUNA LOPEZ REBECA', '', 'TONY VIVERO', '', 'AULR420927 T4A', 1, 'Moneda nacional', 310, 'LERDO', '35150', '725-21-12', '', 'viverosanisidro.facturas@gmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (517, 2, 'ARELLANO MORA ENRIQUE', '', 'CP DAVID DELGADO', '', 'AEME710309S50', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8711432875', '', 'administracion@hergus.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (20738, 2, 'ARQUITECTURA DISEÑO Y CONSTRUCCIONES MEXICO LAGUNA, SA DE CV', '', '', '', 'ADC1209296B5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (742, 2, 'ARTURO RUIZ AGUIRRE', '', '', '', 'ruaa860917ry2', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27275', '', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (22460, 2, 'AUTOCONSIGNACIONES PLAZA DE TORREON SA DE CV', '', '', '', 'APT030610S54', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (22236, 2, 'AUTOMOTORES DE LA LAGUNA SA DE CV', '', '', '', 'ALA0210164S2', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (605, 2, 'AUTOS ALAMEDA SA DE CV', '', 'RICARDO D ELA CRUZ', '', 'AAL8007311N8', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '7147020 EXT 135', '', 'caja@nissangomezpalacio.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (19587, 2, 'AXA SEGUROS, S.A. DE C.V.', '', '', '', 'ASE 931116 231', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '03200', '759 05 04', '759 05 00', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:36', '2021-02-23 15:52:36', 0, 0);
INSERT INTO `proveedores` VALUES (461, 2, 'AXTEL S.A.B. DE C.V.', '', '', '', 'AXT940727FP8', 1, 'Moneda nacional', 313, 'SALTILLO', '66215', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (437, 2, 'AYALA VALDEZ ROMAN HORACIO', '', '', '', '', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '7146073', '8711189739', 'r.ayala@masingserv.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (539, 2, 'AZULBLUE SA DE CV', '', 'ERIKA', '', 'AZU121212FE4', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8717105770', '', 'erika@azulblue.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (616, 2, 'BARRAZA ARAIZA ROGELIO', '', 'ROGELIO BARRAZA', '', 'BAAR551207B15', 1, 'Moneda nacional', 307, 'TORREON', '27250', '8711749571', '8711749583', 'r_barrazas@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (561, 2, 'BARRAZA BARRON AMADO', '', 'AMADO BARRON BARRAZA', '', 'BABA7801028B0', 1, 'Moneda nacional', 310, 'LERDO', '35150', '7250445', '', 'automotrizbarraza@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (473, 2, 'BARRON HERNANDEZ PABLO', '', 'CONRRADO', '', 'BAHP660615 TL7', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (755, 2, 'BELLENIT SA DE CV', '', '', '', 'BEL140109BN5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27010', '7370100', '', 'margaritayadani@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (535, 2, 'BELLO MENDOZA CARLOS DAVID', '', 'CAROLINA', '', 'BEMC830327RH3', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7930076', '', 'carolina@dissolver.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (21753, 2, 'BERNARDO VILLARREAL CANO', '', '', '', 'VICB601106SM4', 1, 'Moneda nacional', 311, 'MONTERREY', '64590', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (19597, 2, 'BEST BUY STORES S. DE R.L. DE C.V.', '', '', '', 'BBS070606D33', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (21074, 2, 'BRYAN MICHEL HERNANDEZ MENDOZA', '', '', '', 'HEMB930706EC1', 1, 'Moneda nacional', 315, 'ESTADO DE MEXICO', '16700', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (679, 2, 'CAFE SIRENA S DE RL DE CV ', '', '', '', 'CSI020226MV4', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '06600', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:37', '2021-02-23 15:52:37', 0, 0);
INSERT INTO `proveedores` VALUES (745, 2, 'CAFI FERRELECTRICO SA DE CV', '', '', '', '', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27050', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:38', '2021-02-23 15:52:38', 0, 0);
INSERT INTO `proveedores` VALUES (523, 2, 'CALVILLO HERNANDEZ CESAR', '', 'CESAR CALVILLO', '', 'CAHC691224RY5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35026', '', '', 'cesa19@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:38', '2021-02-23 15:52:38', 0, 0);
INSERT INTO `proveedores` VALUES (644, 2, 'CAMARA MEXICANA DE LA INDUSTRIA DE LA CONSTRUCCION', '', '', '', 'CMI970416U95', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:38', '2021-02-23 15:52:38', 0, 0);
INSERT INTO `proveedores` VALUES (15147, 2, 'CAMARA NACIONAL DE LA INDUSTRIA DE DESARROLLO Y PROMOCION DE VIVIENDA', '', '', '', 'CNI020510K24', 1, 'Moneda nacional', 306, 'LERDO', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:38', '2021-02-23 15:52:38', 0, 0);
INSERT INTO `proveedores` VALUES (22632, 2, 'CAMARA NACIONAL DE LA INDUSTRIA DE TRANSFORMACION GOMEZ PALACIO', '', '', '', 'CNI560421FF1', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35090', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:38', '2021-02-23 15:52:38', 0, 0);
INSERT INTO `proveedores` VALUES (577, 2, 'CANADEVI TORREON', '', '', 'LAURA WOO', 'CNI020510K24', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7223525', '', 'admonlaguna@canadevi.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:38', '2021-02-23 15:52:38', 0, 0);
INSERT INTO `proveedores` VALUES (511, 2, 'CANDELA ENRIQUEZ JOSEFINA', '', '', '', 'CAEJ700803AJ3', 1, 'Moneda nacional', 310, 'LERDO', '35167', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:38', '2021-02-23 15:52:38', 0, 0);
INSERT INTO `proveedores` VALUES (18640, 2, 'CAP CONTADORES PUBLICOS Y ABOGADOS, SC.', '', 'C.P. SALVADOR CASTAÑEDA', '', 'CCP1509193W7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:38', '2021-02-23 15:52:38', 0, 0);
INSERT INTO `proveedores` VALUES (20929, 2, 'CARLOS ABELARDO GONZALEZ CAMPOS', '', '', '', 'GOCC490226565', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (20360, 2, 'CARLOS ALBERTO RODRIGUEZ DE LA TORRE', '', '', '', 'ROTC740331E34', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35150', '7255260', '', 'fab_poliducto@yahoo.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (19900, 2, 'CARLOS ANDRES JACQUEZ CAMPOS', '', '', '', 'JACC791220GA7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (21182, 2, 'CARLOS IBARRA CAMACHO', '', '', '', 'IACC2907292A4', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (427, 2, 'CASA DEL PLOMERO DE GOMEZ PALACIO SA DE CV', '', '', '', 'CPG9103048R2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '871 714 06 00', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (69092, 2, 'CASA LEY SAPI DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (551, 2, 'CASTAÑEDA NENE JUAN JORGE', '', 'ISABEL BECERRA', '', 'CANJ620315JX0', 1, 'Moneda nacional', 307, 'TORREON', '27170', '', '', 'cofiscal_isabel@yahoo.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (21324, 2, 'CASTRO CEPEDA JAVIER', '', '', '', 'CACJ691129NUA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (17827, 2, 'CASTRUITA TORRES FRANCISCO JAVIER ', '', '', '', '', 1, 'Moneda nacional', 310, 'LERDO', '35000', '8713662928', '', 'paco_castorr@hotmail.com;compras@sali.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (20930, 2, 'CELINA RODRIGUEZ MARROQUIN', '', '', '', 'ROMC650823S50', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '67350', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (543, 2, 'CELSA IMPRESOS SA DE CV', '', 'BLANCA MUÑOZ', '', 'CIM0412013B4', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35070', '(871)1591135', '', 'bmunoz@celsaimpresos.com.mx;hsalinas@viviend.mx;compas@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:39', '2021-02-23 15:52:39', 0, 0);
INSERT INTO `proveedores` VALUES (359, 2, 'CEMEX CONCRETOS SA DE CV', '', 'GLORIA HERNANDEZ', '', 'CCO7409189M1', 1, 'Moneda nacional', 311, 'MONTERREY', '64000', '8183283000', '', 'gloriairene.hernandez@cemex.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx;averdin@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (529, 2, 'CFE SUMINISTRADOR DE SERVICIOS BASICOS', '', '', '', 'CSS160330CP7', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '06500', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (23025, 2, 'CHINA WORLD FACTORY S.A DE C.V', '', '', '', 'CWF130315KT8', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35077', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (64515, 2, 'CHUBB SEGUROS MEXICO, S.A. ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 21781, 'ALVARO OBREGON', '06600', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (22009, 2, 'CIA. EDITORA DE LA LAGUNA SA DE CV', '', '', '', 'ELA2508203L8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (23706, 2, 'CINTHIA BERENICE GONZALEZ DIMAS', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (69193, 2, 'CLARA SANCHEZ OSUNA', '', '', '', 'SAOC590812KW3', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (18150, 2, 'CLAUDIA CONTRERAS GOMEZ ', '', '', '', '', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (68172, 2, 'CLEAN SHOP, S DE R.L. DE C.V.', '', '', '', 'CSH130523BM0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35090', '', '', 'clean_depot@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (691, 2, 'COLEGIO DE INGENIEROS CIVILES DE LA LAGUNA AC', '', '', '', 'CIC7310192J0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35078', '7-19-08-62', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (68226, 2, 'COMBUSTIBLES Y GASES DE TORREON S.A. DE C.V. ', '', '', '', 'CGT980424CX8', 1, 'Moneda nacional', 307, 'TORREON', '27019', '8717505901', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (709, 2, 'COMERCIALIZADORA DE PRODUCTOS SUSTENTABLES GARZA SA DE CV', '', 'DIANA MENDOZA', '', 'CPS-110124-DN7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '64108', '8147370137', '83736737', 'proyectos@comercializadoragarza.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:40', '2021-02-23 15:52:40', 0, 0);
INSERT INTO `proveedores` VALUES (501, 2, 'COMERCIALIZADORA DE SUMINISTROS DEL NORTE SA DE CV', '', '', '', 'CSN9608217C9', 1, 'Moneda nacional', 307, 'TORREON', '27089', '7216000', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (403, 2, 'COMERCIALIZADORA PASA EXPORT TORREON SA DE CV', '', '', '', 'CPE 970313 TPA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '871 713 60 80', '', 'psatorreon@prodigy.net.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (21912, 2, 'COMERCIALIZADORA SAULO, SA DE CV', '', '', '', 'CSA030228EK6', 1, 'Moneda nacional', 307, 'TORREON', '27297', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (19406, 2, 'COMPAÑIA PAPELERA DEL NAZAS, S.A. DE C.V.', '', '', '', 'PNA9409147L0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (71885, 2, 'CONCESIONARIA DE AUTOPISTAS Y LIBRAMIENTOS DEL PACIFICO NORTE SA DE CV', '', '', '', 'CAL091028SP5', 1, 'Moneda nacional', 71884, 'MIGUEL HIDALGO ', '11000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (733, 2, 'CONRRADO MACIEL BARRAZA', '', '', '', 'MABC820402R31', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '7250326', '', 'averdin@viviend.mx;almacen@viviend.mx;compras@viviend.mx;hsalinas@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (72330, 2, 'CONSTRUALIANZA SA DE CV', '', '', '8717190954', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8717190954', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (587, 2, 'CONSTRUCTORA Y ESTRUCTURAS LAGUNA SA DE CV', '', '', 'NATIVIDAD IBARRA', 'CEL100622 3C4', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8717113839', '', 'cyelsatorreon@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (571, 2, 'CONSULTORES SALAS Y ASOCIADOS', '', 'CP PEREZ', '', 'CSA041229BB3', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7938003', '8712345713', 'antonio_perez2005@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (469, 2, 'CONTEMPORANI SA DE CV', '', 'NORMA CHANTACA', '', 'CON911002304', 1, 'Moneda nacional', 311, 'MONTERREY', '66220', '(81)83785596 EXT 106', '8112143739', 'mayoreo@contemporani.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (638, 2, 'CONTRERAS CALDERON MARIA TRINIDAD', '', 'DIEGO LEMUS', '', 'COCT660728PN1', 1, 'Moneda nacional', 307, 'TORREON', '27446', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:41', '2021-02-23 15:52:41', 0, 0);
INSERT INTO `proveedores` VALUES (648, 2, 'COPRA CONSTRUCICONES Y PROYECTOS ARQUITECTONICOS SA DE CV ', '', '', '', 'CCP101210LB9', 1, 'Moneda nacional', 307, 'TORREON', '27020', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:42', '2021-02-23 15:52:42', 0, 0);
INSERT INTO `proveedores` VALUES (519, 2, 'CORONADO AGUIRRE LUCILA', '', 'Lucila', '', 'COAL7811178G7', 1, 'Moneda nacional', 307, 'TORREON', '27087', '7314396', '8711998237', 'marmol_juarez@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:42', '2021-02-23 15:52:42', 0, 0);
INSERT INTO `proveedores` VALUES (439, 2, 'CORPORACION PRODECO S.A. de C.V.', '', 'ERNESTO MARTELL', '', 'CPR090611 4RA', 1, 'Moneda nacional', 307, 'TORREON', '27100', '747 28 00', '', 'ermartell@prodeco.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:42', '2021-02-23 15:52:42', 0, 0);
INSERT INTO `proveedores` VALUES (453, 2, 'CORPORATIVO DE NEGOCIOS Y ASESORIAS EMPRESARIALES SA DE CV', '', 'ALEJANDRO LOPEZ', '', 'CNA101018 SE9', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '03300', '', '', 'alelopez@manopco.com;hsalinas@viviend.mx;esalinas@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:42', '2021-02-23 15:52:42', 0, 0);
INSERT INTO `proveedores` VALUES (607, 2, 'CORRAL MELERO MARA MAGDALENA', '', 'EDUARDO RIOS', '', 'COMM6409257Z7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35049', '7191985', '', 'eliseo.isaias@madereriarealdelpino.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:42', '2021-02-23 15:52:42', 0, 0);
INSERT INTO `proveedores` VALUES (22619, 2, 'CRIJAI GROUP S.A. DE C.V.', '', '', '', 'CGR150722FP0', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:42', '2021-02-23 15:52:42', 0, 0);
INSERT INTO `proveedores` VALUES (22585, 2, 'CRISTINA MARTINEZ REYES', '', '', '', 'MARC871211TU2', 1, 'Moneda nacional', 307, 'TORREON', '27148', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:42', '2021-02-23 15:52:42', 0, 0);
INSERT INTO `proveedores` VALUES (21115, 2, 'CUBIERTAS Y LAMINADOS DE LA LAGUNA, S.A DE C.V.', '', '', '', 'CLL9803091U1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27060', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:42', '2021-02-23 15:52:42', 0, 0);
INSERT INTO `proveedores` VALUES (481, 2, 'DAC ACCESORIOS PARA LA CONSTRUCCION SA DE CV', '', 'JUAN CARLOS FLORES', '', 'DAC091109DB7', 1, 'Moneda nacional', 315, 'ESTADO DE MEXICO', '03940', '', '', 'jcflores@ftpmexico.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:42', '2021-02-23 15:52:42', 0, 0);
INSERT INTO `proveedores` VALUES (463, 2, 'DAGOBERTO DE LA O FAVILA', '', 'GABRIELA IBARRA', '', '', 1, 'Moneda nacional', 307, 'TORREON', '27100', '192 0892', '', 'gabrielaibarra92@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:42', '2021-02-23 15:52:42', 0, 0);
INSERT INTO `proveedores` VALUES (69996, 2, 'DAMASO DANIEL OSUNA JIMENEZ', '', '', '', 'OUJD830629ND0', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82157', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (64661, 2, 'DANIEL BECERRA ROCHA', '', '', '', 'BERD9002121L2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (735, 2, 'DANIELA JAQUELINE  SOLIS GUEVARA ', '', '', '', 'SOGD810818R35', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (68671, 2, 'DAVID FRANCISCO ALAPIZCO VARGAS', '', '', '', 'AAVD720309QY7', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82030', '1181655', '6691462222', 'impresiones4graphics@gmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (487, 2, 'DAVILA MONTALVO JOSE ANGEL', '', 'Jose Angel Davila', '', '', 1, 'Moneda nacional', 307, 'TORREON', '27280', '713-37-83', '', 'josangel832@yahoo.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (457, 2, 'DELTA BLOCK DE LA LAGUNA, S.A. DE C.V.', '', 'FRANCISCO CHAVEZ', '', '', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '719-03-22', '', 'deltablocklaguna@gmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (72215, 2, 'DEREK MANUEL MELENDREZ LEYVA', '', '', '', 'MELD020822M48', 1, 'Moneda nacional', 69163, 'CULIACAN', '80144', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (630, 2, 'DESARROLLOS E INFRAESTRUCTURA GLOBAL SA DE CV ', '', 'EDUARDO GAMMA', '', 'DEI090131DL6', 1, 'Moneda nacional', 307, 'TORREON', '27100', '2-03-68-55', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (351, 2, 'DIESEL Y GASOLINA DE LA LAGUNA SA DE CV', '', 'PERLA', '', 'DGL9910268Q3', 1, 'Moneda nacional', 307, 'TORREON', '27019', '7502222', '', 'servicioaclientes@migasolina.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (20434, 2, 'DIGITAL COMPANY MEXICO SA DE CV', '', '', '', 'DME100521SPA', 1, 'Moneda nacional', 307, 'TORREON', '27106', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (407, 2, 'DISTRIBUCIONES INDUSTRIALES CUERDA SA DE CV', '', 'SOL PAULINA', '', 'DIC860228NXA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '871 732 70 00', '', 'mkt@cuerda.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (20736, 2, 'DISTRIBUCIUONES INDUSTRIALES CUERDA, SA DE CV', '', '', '', 'DIC860228NXA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '713-60-13', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:43', '2021-02-23 15:52:43', 0, 0);
INSERT INTO `proveedores` VALUES (738, 2, 'DISTRIBUIDOR SOLTRACK LAGUNA SA DE CV', '', '', '', 'DSL150108PA2', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27250', '', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:44', '2021-02-23 15:52:44', 0, 0);
INSERT INTO `proveedores` VALUES (347, 2, 'DISTRIBUIDORA DE PUERTAS Y AISLANTES S DE RL DE CV', '', 'C.P. JUAN ANTONIO CHAVARRIA', '', 'DPA920318FF4', 1, 'Moneda nacional', 307, 'TORREON', '27170', '7125256', '7122218', 'jchavarria53@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:44', '2021-02-23 15:52:44', 0, 0);
INSERT INTO `proveedores` VALUES (772, 2, 'DISTRIBUIDORA LIVERPOOL SA DE CV', '', '', '', 'DLI931201MI9', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '05348', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:44', '2021-02-23 15:52:44', 0, 0);
INSERT INTO `proveedores` VALUES (349, 2, 'DOMINGUEZ ALANIS ADRIAN HOMERO', '', 'Adrian Dominguez', '', 'DOAA800630FI8', 1, 'Moneda nacional', 307, 'TORREON', '27250', '8711012707', '', 'miro0680@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:44', '2021-02-23 15:52:44', 0, 0);
INSERT INTO `proveedores` VALUES (68863, 2, 'D´GRASS & DECK SA DE CV', '', '', '', 'DGA140624HG1', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82110', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:44', '2021-02-23 15:52:44', 0, 0);
INSERT INTO `proveedores` VALUES (361, 2, 'EDIFICACION Y VALUACION LEONART SA DE CV', '', '', 'CRISTY', 'EVL0903041L2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'cristy_amu2901@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:44', '2021-02-23 15:52:44', 0, 0);
INSERT INTO `proveedores` VALUES (19937, 2, 'EDITORIAL LA OPINION, S.A.', '', '', '', 'EOP510101UA4', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:44', '2021-02-23 15:52:44', 0, 0);
INSERT INTO `proveedores` VALUES (68088, 2, 'EDUARDO CHAIREZ FLORES ', '', '', '', 'CAFE7602162Y5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:44', '2021-02-23 15:52:44', 0, 0);
INSERT INTO `proveedores` VALUES (567, 2, 'EL ECONOMISTA GRUPO EDITORIAL SA DE CV', '', '', 'VERONICA ALDANA', 'EGE101130F25', 1, 'Moneda nacional', 315, 'ESTADO DE MEXICO', '06060', '015553265454', '', 'veronica.aldana@eleconomista.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:45', '2021-02-23 15:52:45', 0, 0);
INSERT INTO `proveedores` VALUES (68866, 2, 'ELECTRICA DOS HERMANOS SA DE CV', '', '', '', 'EDH02053071A', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82127', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:45', '2021-02-23 15:52:45', 0, 0);
INSERT INTO `proveedores` VALUES (411, 2, 'ELECTRICA SAISA SA DE CV', '', 'SERGIO SAENZ IBARRA', '', 'ESA1008192W5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '871 723 78 35', '', 'electricasaisa@prodigy.net.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:45', '2021-02-23 15:52:45', 0, 0);
INSERT INTO `proveedores` VALUES (409, 2, 'ELECTRO TABLEROS DE CONTROL SA DE CV', '', 'Sergio Rios', '', 'SEC 050511H69', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '871 719 21 31', '', 'mechavarria@electrotableros.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:45', '2021-02-23 15:52:45', 0, 0);
INSERT INTO `proveedores` VALUES (632, 2, 'ELIAS RAMOS NANCY YOSELIN', '', 'CECILIA ALVAREZ', '', 'EIRN8905244Z1', 1, 'Moneda nacional', 310, 'LERDO', '35150', '(871) 1 59 35 49', '', 'viverosanisidro.facturas@gmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:45', '2021-02-23 15:52:45', 0, 0);
INSERT INTO `proveedores` VALUES (705, 2, 'ELIDA AMERICA CORDOVA MARIN', '', '', '', 'MACE6109155T8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '7-13-49-73', '', 'metalicos_aldama@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (68766, 2, 'EMMANUEL ALEJANDRO BERGES ROSALES', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (549, 2, 'ENCERRADO ALVARADO JOSE LUIS', '', '', '', 'EEAL450621910', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (687, 2, 'ENERGIA Y SERVICIOS COORDINADOS S.A. DE C.V.', '', '', '', 'ESC-141203-1E8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35135', '7502222', '7502371', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (20040, 2, 'ENRIQUE NUÑEZ SLEIMAN', '', '', '', 'NUSE9002151N1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27020', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (69063, 2, 'ERIKA MUÑIZ VELA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27087', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (69057, 2, 'ERNESTO MALTOS SALINAS', '', '', '', 'MASE870929961', 1, 'Moneda nacional', 307, 'TORREON', '27087', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (20987, 2, 'ERNESTO REYES MARQUEZ', '', '', '', 'REME761008J52', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35026', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (683, 2, 'ESPECIALISTAS EN ALTA COCINA SA DE CV ', '', '', '', 'EAC8504236U5', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '06600', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (599, 2, 'ESTRELLA OCHOA SERGIO', '', 'RAQUEL', '', 'EEOS340321EI5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '7151811', '', 'notariapublica5@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (20758, 2, 'EXPORTADORA LAGUNERA SA DE CV', '', '', '', 'ELA0910024S7', 1, 'Moneda nacional', 307, 'TORREON', '27018', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (70029, 2, 'FACEBOOK IRELAND LIMITED', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (475, 2, 'FACIO LOPEZ OLGA LIDIA (PINTURAS ALDAMA)', '', 'OLGA FACIO', '', 'FALO620801B57', 1, 'Moneda nacional', 310, 'LERDO', '35150', '725-00-68', '', 'olga_fasio@live.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:46', '2021-02-23 15:52:46', 0, 0);
INSERT INTO `proveedores` VALUES (19362, 2, 'FARMACIAS BENAVIDES, S.A.B. DE C.V.', '', '', '', 'FBE9110215Z3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '64750', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (721, 2, 'FASTPRINT', '', 'THANIA', '', 'GVA0902251V3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35080', '7-14-38-10', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (493, 2, 'FAVELA NAVARRO SONIA ESTELA', '', 'SABINO FAVELA', '', 'FANS771121SC7', 1, 'Moneda nacional', 310, 'LERDO', '35161', '7257550', '8711207029', 'taktejasyacabados@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (585, 2, 'FAVILA FERNANDEZ BALTAZAR', '', 'BALTAZAR FAVILA', '', 'FAFB851109T14', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7300145', '', 'balta_favila@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (17880, 2, 'FELIX SOTO DE LA CRUZ', '', '', '', 'SOCF570720EZ6', 1, 'Moneda nacional', 307, 'TORREON', '27240', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (620, 2, 'FIDEICOMISO REGISTRO UNICO DE VIVIENDA ', '', '', '', 'FRU111123SA3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '01020', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (653, 2, 'FLEJES SULTANA SA DE CV ', '', '', '', 'FSU8911099Y4', 1, 'Moneda nacional', 307, 'TORREON', '27020', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (662, 2, 'FLEJES Y EMBALAJES INDUSTRIALES SA DE CV ', '', '', '', 'FEI931202T55', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (559, 2, 'FORESTAL LAGUNERA SA DE CV', '', '', '', 'FLA960617E78', 1, 'Moneda nacional', 307, 'TORREON', '27030', '7133501', '7938017', 'folag@prodigy.net.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (22156, 2, 'FRANCISCO ENRIQUE BARRON HERNANDEZ', '', '', '', 'BAHF751216P31', 1, 'Moneda nacional', 310, 'LERDO', '35188', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (72476, 2, 'FRANCISCO JAVIER GARDUÑO ALVARADO', '', '', '', 'GAAF6302081Y9', 1, 'Moneda nacional', 72475, 'QUERETARO', '76116', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (19489, 2, 'GADIVI, S.A. DE C.V.', '', '', '', 'GAD1005245M8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '66220', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:47', '2021-02-23 15:52:47', 0, 0);
INSERT INTO `proveedores` VALUES (345, 2, 'GAFI FERRELECTRICO SA DE CV', '', 'GILDA HERNANDEZ', 'JUAN ARTURO JUAREZ', 'GFE000627QW0', 1, 'Moneda nacional', 307, 'TORREON', '27050', '7474612', '7474600 ext 156', 'cadomingue@gafi.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;averdin@viviend.mx;compras@viviend.mx;mmarines@gafi.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:48', '2021-02-23 15:52:48', 0, 0);
INSERT INTO `proveedores` VALUES (471, 2, 'GALVAN CAMACHO TOMAS', '', '', '', 'GACT610919 9B2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:48', '2021-02-23 15:52:48', 0, 0);
INSERT INTO `proveedores` VALUES (19396, 2, 'GANT IMPRESOS Y REGALOS S.A. DE C.V.', '', '', '', 'GIR970121MM1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:48', '2021-02-23 15:52:48', 0, 0);
INSERT INTO `proveedores` VALUES (729, 2, 'GAS NATURAL DEL NOROESTE  SA DE CV', '', 'GERARDO  PIÑERA', '', 'GNN9706053S3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27019', '8717255282', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:48', '2021-02-23 15:52:48', 0, 0);
INSERT INTO `proveedores` VALUES (71878, 2, 'GASOLINERAS PABA SA DE CV', '', '', '', 'GPA0610318A0', 1, 'Moneda nacional', 69163, 'CULIACAN', '80027', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:48', '2021-02-23 15:52:48', 0, 0);
INSERT INTO `proveedores` VALUES (431, 2, 'GASPAR ROJAS JOSE RUBEN', '', '', '', 'GARR621231CW7', 1, 'Moneda nacional', 307, 'TORREON', '27060', '7207288', '', 'elplomerito.ferreteria@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:48', '2021-02-23 15:52:48', 0, 0);
INSERT INTO `proveedores` VALUES (69018, 2, 'GASPASA GASOLINAS SA DE CV', '', '', '', 'FMU060508B16', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:48', '2021-02-23 15:52:48', 0, 0);
INSERT INTO `proveedores` VALUES (20871, 2, 'GERARDO ESPINOSA MONTELEONE', '', '', '', 'EIMG5405175H6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35070', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:48', '2021-02-23 15:52:48', 0, 0);
INSERT INTO `proveedores` VALUES (764, 2, 'GILBERTO VARGAS VALDEZ', '', '', '', 'VAVG760204LTA', 1, 'Moneda nacional', 307, 'TORREON', '27089', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:48', '2021-02-23 15:52:48', 0, 0);
INSERT INTO `proveedores` VALUES (69159, 2, 'GISELA TIJERINA RUBIN CELIS ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:48', '2021-02-23 15:52:48', 0, 0);
INSERT INTO `proveedores` VALUES (656, 2, 'GONZALEZ CABRAL Y ASOCIADOS SC', '', '', '', 'GCA961015A71', 1, 'Moneda nacional', 307, 'TORREON', '27200', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (634, 2, 'GONZALEZ GARCIA CARLOS', '', 'CARLOS GONZALEZ', '', 'GOGC500203155', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7177358', '', 'gonzalezcabral.facturacion@yahoo.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (575, 2, 'GONZALEZ MACHADO SERGIO ARTURO', '', '', 'KAREN', 'GOMS 661007 L89', 1, 'Moneda nacional', 307, 'TORREON', '27000', '871-7220800', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (367, 2, 'GORVAL CONSULTORES SC', '', 'AURORA', '', 'GCO100601LH9', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (19395, 2, 'GRANT IMPRESOS Y REGALOS, S.A DE C.V', '', '', '', 'GIR970121MM1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '66260', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (445, 2, 'GRUAS TASA S.A. DE C.V.', '', 'CLAUDIA', '', 'GTA960508 UL1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '722-81-11', '', 'gruastasa@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (677, 2, 'GRUPO AMIGOS SAN ANGEL SA DE CV ', '', '', '', 'GAS9404199I6', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '06600', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (433, 2, 'GRUPO COMERCIAL YAZBEK SA DE CV ', '', 'CAROLINA', '', 'GCY890426MZ1', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '08400', '018002929235', '2099390', 'torreon@yazbek.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (441, 2, 'GRUPO CORCELES SA DE CV', '', '', '', 'GCO1007283X7', 1, 'Moneda nacional', 307, 'TORREON', '27190', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (385, 2, 'GRUPO ENLACE MEK SA DE CV', '', 'DAVID GONZALEZ', '', 'GEM110824 HA1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '871-2685346', '8712115146', 'glzdavid@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (595, 2, 'GRUPO LEGRAF SA DE CV', '', 'MARLENE', '', 'GLE140212F19', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7111714', '', 'legraf@outlook.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (70702, 2, 'GRUPO NACIONAL PROVINCIAL S.A.B.', '', '', '', 'GNP9211244P0', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '4200', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:49', '2021-02-23 15:52:49', 0, 0);
INSERT INTO `proveedores` VALUES (383, 2, 'GRUPO PERLITA DE LA LAGUNA S.A. DE C.V.', '', 'RAFAEL MARENTIS', 'MARGARITA HERRERA', 'GPL-090512-8E6', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '35077', '719 13 15  EXT 115', '8711816168', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (18154, 2, 'GRUPO VACO S.A. DE C.V.', '', '', '', 'GVA0902251V3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35080', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (465, 2, 'GUERRA GUZMAN JOSE PRAXEDIS', '', '', '', 'GUGP520410 9T6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35078', '750 05 71', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (527, 2, 'GUTIERREZ AUTOMOTORES SA  DE CV', '', '', '', 'GAU891218GH0', 1, 'Moneda nacional', 307, 'TORREON', '27018', '871750202', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (391, 2, 'GUTIERREZ FERRETEROS S.A. DE C.V.', '', 'JAVIER BERDIN', '', 'GFE861208 L17', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '1751200', '', 'ventas01@gutierrezferreteros.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (525, 2, 'GUTIERREZ MERLO MA TERESA', '', '', '', 'GUMT631223TM0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '871 7142984', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (69168, 2, 'HANKKEET CONTROL DE RIESGOS SA DE CV', '', '', '', 'HCR140228FZ0', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (601, 2, 'HDI SEGUROS SA DE CV', '', '', 'ERIKA', 'HSE701218532', 1, 'Moneda nacional', 322, 'LEON GUANAJUATO', '37306', '1938490', '', 'erika.ehrenzwieg@hdi.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (697, 2, 'HERA INGENIEROS S DE RL DE CV ', '', '', '', 'HIN160205555', 1, 'Moneda nacional', 307, 'TORREON', '27100', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (19355, 2, 'HERNAN RENE GOMEZ TORRES', '', '8183597998', '', 'GOTH881204P40', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '67170', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (650, 2, 'HERNANDEZ CASTRO FRANCISCO JAVIER ', '', '', '', 'HECF810814IM6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35049', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (479, 2, 'HERNANDEZ RUELAS AGUSTIN', '', '8711785339', '', 'HERA851005CU0', 1, 'Moneda nacional', 307, 'TORREON', '27119', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:50', '2021-02-23 15:52:50', 0, 0);
INSERT INTO `proveedores` VALUES (395, 2, 'HOME DEPOT MEXICO S DE R.L. DE C.V.', '', 'FRANCISCO BARUSH', '', 'HDM001017AS1', 1, 'Moneda nacional', 307, 'TORREON', '27020', '7474540', '2130117', 'ventas8728@homedepot.com.mx;averdin@viviend.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (69995, 2, 'HOSPIMAZ SAPI DE CV', '', '', '', 'HOS170808SX1', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82103', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (760, 2, 'HUMAN STAFF SA DE CV', '', '', '', 'HST0003292H0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (712, 2, 'HUMBERTO HERNANDEZ GUTIERREZ', '', '', '', 'HEGH671121A51', 1, 'Moneda nacional', 310, 'LERDO', '35140', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (19862, 2, 'IAJAIRA SANDOVAL CARDENAS', '', '', '', 'SACI 810919 7B7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (21782, 2, 'ICICAC, S.A. DE C.V.', '', '', '', 'ICI150121MD7', 1, 'Moneda nacional', 21781, 'ALVARO OBREGON', '01780', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (19929, 2, 'ILEANA ARACELI MIRANDA GIRON', '', '', '', 'MIGI8603069R8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (715, 2, 'IMPULSORA ELIZONDO SA DE CV', '', '7-19-04-10', '', 'IEL931213LD7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', 'rchacon@elizondomx.com;sayala@elizondomx.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (22625, 2, 'IN-K, S.A. DE C.V.', '', '', '', 'INK071008JI4', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (626, 2, 'INDUSTRIAL BALA SA DE CV ', '', 'JUAN IGNACIO DEHESA TORRE', 'PEDRO FERNANDEZ SAUCEDO', 'IBA040621NY5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35140', '1800139', '1800144', 'jdehesa@gmail.com;pfdzjm@gmail.com;balafacturas@gmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx;averdin@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (775, 2, 'INDUSTRIAL DE LONAS DEL NORTE SA DE CV', '', '', '', 'ILN860519UT5', 1, 'Moneda nacional', 307, 'TORREON', '27013', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:51', '2021-02-23 15:52:51', 0, 0);
INSERT INTO `proveedores` VALUES (555, 2, 'INFORMATICA EMPRESARIAL INTEGRADA SA DE CV', '', '', '83330456', 'IEI930820FC2', 1, 'Moneda nacional', 311, 'MONTERREY', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (717, 2, 'INGENIERIA ELECTRICA Y EQUIPAMENTO  EN CLIMAS SA DE CV', '', '', '', 'IEE070508BY9', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27058', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (64450, 2, 'INMOBILIARIA EJECUTIVA EMPRESARIAL SA DE CV ', '', '', '', 'IEE030925KR6', 1, 'Moneda nacional', 307, 'TORREON', '27000', ' facturacion@arrendalaguna.com', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (22521, 2, 'INMOBILIARIA MGS S.A. DE C.V.', '', '', '', 'IMG130528TV6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (685, 2, 'INMOBILIARIA PASEO DE LA REFORMA SA DE CV ', '', '', '', 'IPR820702IG9', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '06030', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (20911, 2, 'INMOBILIARIA VILLA JARDIN S.A. DE C.V.', '', '', '', 'IVJ791228B49', 1, 'Moneda nacional', 307, 'TORREON', '35000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (20138, 2, 'INSTITUTO MEXICANO DEL SEGURO SOCIAL', '', '', '', 'IMSS170507HY4', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (618, 2, 'INTEGRACORP & H CONSULTING SA DE CV', '', 'FELIPE SALAZAR', '', 'IAH110225TFA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8711188153', '4556161', 'fsalazar@ihconsulting.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (393, 2, 'INTER LAGUNA S.A. DE C.V.', '', 'STEPHANIA VALLES', '', 'ILA1010283EA', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35090', '7149000', '', 'ventas1_ma@interceramic.com;averdin@viviend.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (425, 2, 'IQ LAGUNA, SA DE CV', '', 'LORENA ZAVALA', '', 'ILA100826EA7', 1, 'Moneda nacional', 307, 'TORREON', '', '7505084', '', 'iqlaguna@laguna.com;averdin@viviend.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (68524, 2, 'ISAAC RENE DAVILA MONTALVO', '', '', '', 'DAMI861019NE3', 1, 'Moneda nacional', 307, 'TORREON', '27110', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (723, 2, 'ISABEL CRISTINA BALDERAS MORENO', '', 'ISABEL', '', 'BAMI750708RG1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:52', '2021-02-23 15:52:52', 0, 0);
INSERT INTO `proveedores` VALUES (573, 2, 'IUSACELL', '', '', '', 'IUS890616RH6', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '11000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (21258, 2, 'IVAN ALBERTO ARREOLA JALIFE', '', '', '', 'AEJI8302134NA', 1, 'Moneda nacional', 307, 'TORREON', '27100', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (19973, 2, 'IVO CONSTRUCCIONES, S.A. DE C.V.', '', '', '', 'ICO071017Q17', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35018', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (695, 2, 'J. GUADALUPE GAYTAN CHAVARRIA', '', '', '', 'GACJ4912126A8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (19144, 2, 'JAIME JAVIER SALUM BLAZQUEZ', '', '', '', 'SABJ76110484A', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '871 204 25 43', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (495, 2, 'JAIME RAMIREZ JUAN RAYMUNDO', '', 'JUAN RAYMUNDO JAIME', '', 'JARJ490526JR5', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7169333', '', 'torreon@steren.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (405, 2, 'JARAMILLO MONTOYA JUAN', '', 'NANCY', '', 'JAMJ 401027 DI2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35120', '7 52 11 01', '7 52 11 02', 'pobelec.compras@live.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (22161, 2, 'JESUS JORGE MEDRANO RUIZ', '', '', '', 'MERJ730113C61', 1, 'Moneda nacional', 321, 'MERIDA', '97133', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (751, 2, 'JESUS RAMIREZ ANDRADE', '', '', '', 'RAAJ631218E91', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '871 718 2829', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (21983, 2, 'JESUS SANTANA TRIANA', '', '', '', 'SATJ760326FV9', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (521, 2, 'JIMENEZ HERRERA JUANA', '', 'JOSE MURILLO', '', 'JIHJ581208KV9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '7159482', '', 'cercosymallaslaguna@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:53', '2021-02-23 15:52:53', 0, 0);
INSERT INTO `proveedores` VALUES (665, 2, 'JM LIDER EN ELECTRONICA SA DE CV ', '', '', '', 'JLE1505129Y7', 1, 'Moneda nacional', 307, 'TORREON', '27100', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:54', '2021-02-23 15:52:54', 0, 0);
INSERT INTO `proveedores` VALUES (17837, 2, 'JORGE ERNESTO DAVILA RODRIGUEZ', '', '', '', 'DARJ720825PCA', 1, 'Moneda nacional', 307, 'TORREON', '27058', '', '', 'ttmayoral@gmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:54', '2021-02-23 15:52:54', 0, 0);
INSERT INTO `proveedores` VALUES (714, 2, 'JORGE IVAN MONARREZ MORALES', '', '', '', 'MOMJ8907293M6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:54', '2021-02-23 15:52:54', 0, 0);
INSERT INTO `proveedores` VALUES (64300, 2, 'JORGE LUIS VILLARREAL GARZA', '', '', '', 'VIGJ561028SV7', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8717122604', '8717128365', 'copifox@prodigy.net.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:54', '2021-02-23 15:52:54', 0, 0);
INSERT INTO `proveedores` VALUES (16917, 2, 'JOSE LUIS SEPULVEDA ESTRADA', '', 'JOSE LUIS', '', 'SEEL870411U89', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35000', '8717976969', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:54', '2021-02-23 15:52:54', 0, 0);
INSERT INTO `proveedores` VALUES (768, 2, 'JOSE ROBERTO PEREZ ALEJANDRO ', '', '', '', 'PEAR410505UW6', 1, 'Moneda nacional', 310, 'LERDO', '35150', '7257483', '', 'robertoperez410505@gmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:54', '2021-02-23 15:52:54', 0, 0);
INSERT INTO `proveedores` VALUES (16938, 2, 'JOSE SALVADOR NECOCHEA SAGUI', '', '', '', 'NESS511210JU4', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35158', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:54', '2021-02-23 15:52:54', 0, 0);
INSERT INTO `proveedores` VALUES (669, 2, 'JOSE SERGIO RAMIREZ JARAMILLO', '', '', '', 'RAJS490416353', 1, 'Moneda nacional', 310, 'LERDO', '35150', '7250606', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:54', '2021-02-23 15:52:54', 0, 0);
INSERT INTO `proveedores` VALUES (19407, 2, 'JOSUE DAVID ARELLANO SALINAS', '', '', '', 'AESJ891213HM7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:54', '2021-02-23 15:52:54', 0, 0);
INSERT INTO `proveedores` VALUES (72468, 2, 'JUAN BERNAL BAHENA', '', '', '', 'BEBJ7512171B1', 1, 'Moneda nacional', 69499, 'CUERNAVACA', '62300', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:55', '2021-02-23 15:52:55', 0, 0);
INSERT INTO `proveedores` VALUES (725, 2, 'JUAN FELIPE CHAVEZ MORAN', '', 'HUMBERTO REYES', '', 'CAMJ660208KG0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '7313034', '7313045', 'cobranza@minotauroherramientas.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:55', '2021-02-23 15:52:55', 0, 0);
INSERT INTO `proveedores` VALUES (743, 2, 'JUAN MANUEL RAMIREZ PALACIOS ', '', '', '', 'rapj970516bma', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27399', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:55', '2021-02-23 15:52:55', 0, 0);
INSERT INTO `proveedores` VALUES (749, 2, 'JULIO AZPIAZU RUIZ', '', '', '', 'AIRJ481116B20 ', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '8717144045', '', 'aspi@prodigy.net.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:55', '2021-02-23 15:52:55', 0, 0);
INSERT INTO `proveedores` VALUES (69483, 2, 'JUNTA MUNICIPAL DE AGUA POTABLE Y ALCANTARILLADO DE MAZATLAN', '', '', '', 'JMA880101M02', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:55', '2021-02-23 15:52:55', 0, 0);
INSERT INTO `proveedores` VALUES (379, 2, 'KREATIV GRAN FORMATO SA DE CV', '', 'ADRIAN DOMINGUEZ', '', 'KGF0208066R1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7174212', '7137825', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:55', '2021-02-23 15:52:55', 0, 0);
INSERT INTO `proveedores` VALUES (734, 2, 'L.I. DAVID RODRIGUEZ AYALA', '', '', '', 'ROAD790213PD5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:55', '2021-02-23 15:52:55', 0, 0);
INSERT INTO `proveedores` VALUES (16939, 2, 'LABORATORIO Y CONSULTORIA EN SUELOS Y CONCRETOS SC', '', '', '', 'LCS1411257T0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '31125', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:55', '2021-02-23 15:52:55', 0, 0);
INSERT INTO `proveedores` VALUES (746, 2, 'LAMINADOS DE BARRO SA DE CV ', '', '', '', 'LBA6804198Y1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:55', '2021-02-23 15:52:55', 0, 0);
INSERT INTO `proveedores` VALUES (744, 2, 'LEO TEXTIL Y DECORACIONES , S.A DE C.V', '', '', '', 'ltd110215ac8', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '2700', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:55', '2021-02-23 15:52:55', 0, 0);
INSERT INTO `proveedores` VALUES (753, 2, 'LEONARDO MARTINEZ GOMEZ', '', '', '', 'MAGL790914K56', 1, 'Moneda nacional', 307, 'TORREON', '27277', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:56', '2021-02-23 15:52:56', 0, 0);
INSERT INTO `proveedores` VALUES (21120, 2, 'LEONCIO MUÑOZ LAZOS', '', '', '', 'MULL 470424 GF1', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:56', '2021-02-23 15:52:56', 0, 0);
INSERT INTO `proveedores` VALUES (15116, 2, 'LETICIA GUTIERREZ HERNANDEZ', '', '', '', 'GUHL460516H65', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (541, 2, 'LOPEZ RODRIGUEZ JOEL', '', 'ROSENDO', '', 'LORJ7706049Q8', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35150', '8711018263', '', 'karina_mata6@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (397, 2, 'LORENZO OROZCO GARCIA', '', 'GRIS ESTRADA ', '', 'OOGL750810J83', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '35018', '192-30-21', '', 'distribuidoradetuberias@grimosa.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx;averdin@viviend.mx', 'SUSPENSION DE COMPRAS  ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (21957, 2, 'LUAR DIVAD TEJEIDA SANCHEZ', '', '', '', 'TESL830227GJ1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (515, 2, 'LUCILA CORONADO AGUIRRE', '', 'LUCILA', '', 'COAL7811178G7', 1, 'Moneda nacional', 307, 'TORREON', '27087', '7314396', '', 'marmol_juarez@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'SUSPENSION DE COMPRAS  ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (675, 2, 'LUIS ABRAHAM HERNANDEZ SALINAS', '', '', '', 'HESL780722F21', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (22583, 2, 'LUIS ALBERTO GUERRERO ESCAMILLA', '', '', '', 'GUEL890814G64', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35050', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (64205, 2, 'LUIS MANUEL BECERRA PADILLA', '', '', '', 'BEPL770905U82', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8717937767', '8711935648', 'herreria4caminos@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (739, 2, 'LUIS RENE JACQUEZ LOPEZ ', '', '', '', 'JALL891212A25', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (67973, 2, 'LUISA FERNANDA VENEGAS VALDERAZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '8116883323', '', 'TRAMITES@VIVIEND.MX', 'ACTIVO                 ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (15196, 2, 'MA. DE LOS DOLORES PADILLA LUGO', '', '', '', 'PALD680626N7A', 1, 'Moneda nacional', 313, 'SALTILLO', '25057', '8444206281', '', 'certificaciones.lolispadilla@gmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:57', '2021-02-23 15:52:57', 0, 0);
INSERT INTO `proveedores` VALUES (20297, 2, 'MA. DEL ROSARIO AGUERO IBARRA', '', '', '', 'AUIR510401MW6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35027', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (759, 2, 'MA. TERESA YOLANDA GUTIERRES MERLO ', '', '', '', 'GUMT631223TM0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35000', '7142984', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (447, 2, 'MACIEL MARRUFO CONRADO', '', 'CONRADO', '', 'MAMC581224MSA', 1, 'Moneda nacional', 310, 'LERDO', '35150', '8712309968', '', 'materialistas_lerdo@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (389, 2, 'MADERERA DEL NAZAS SA DE CV', '', 'Lucy Pamanes', '', 'MNA9010012P6', 1, 'Moneda nacional', 307, 'TORREON', '27271', '7191313', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx;averdin@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (68641, 2, 'MAGMA PROS, SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (21688, 2, 'MAIRA DE JESUS MORENO FAVELA', '', '', '', 'MOFJ630729PU7', 1, 'Moneda nacional', 307, 'TORREON', '27240', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (731, 2, 'MANRIQUE HUMBERTO URIBE LOPEZ', '', '', '', 'UILM671019SD1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27200', '871 347 85 79', '', 'seal_asesores_laborales@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (72470, 2, 'MANUEL ISAMEL AUDELO SANTIAGO ', '', '', '', 'AUSM700617S72', 1, 'Moneda nacional', 69499, 'CUERNAVACA', '62448', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (747, 2, 'MANUELA REYES ', '', '', '', 'RAMA6006166W1', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27110', '8717741301', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (579, 2, 'MANUFACTURAS POST FORM SA DE CV', '', 'ANGELICA ACOSTA', 'JESUS LOPEZ', 'MPF861014CD6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '7077718', '7077714', 'angelica.acosta@gebesa.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (19602, 2, 'MAPFRE TEPEYAC, S.A.', '', '', '', 'MTE440316E54', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '03800', '750 13 36', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (21344, 2, 'MARCELO PORRAS CASTILLO', '', '', '', 'POCM670103N87', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:58', '2021-02-23 15:52:58', 0, 0);
INSERT INTO `proveedores` VALUES (72532, 2, 'MARCO ANTONIO VILLELA GONZALEZ', '', '', '', 'VIGM870613B1A', 1, 'Moneda nacional', 69499, 'CUERNAVACA', '62490', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (22196, 2, 'MARCO MARIANO JASSO GUZMAN', '', '', '', 'JAGM671007SY2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (371, 2, 'MARCOS AUTOMOTRIZ SA DE CV', '', '', '', 'MAU9103057U0', 1, 'Moneda nacional', 312, 'SAN PEDRO', '27800', '7152030', '7152090', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (779, 2, 'MARGARITA CHAVEZ BERUMEN', '', 'MARGARITA', '', 'CABM530822988', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (21690, 2, 'MARIA DE JESUS MORENO FAVELA', '', '', '', 'MOFJ630729PU7', 1, 'Moneda nacional', 307, 'TORREON', '27240', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (22186, 2, 'MARIA DE LOURDES ARENAS JIMENEZ', '', '', '', 'AEJL671016N11', 1, 'Moneda nacional', 22185, 'SAN NICOLAS DE LOS GARZA', '66450', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (15108, 2, 'MARIA DE LOURDES MARES MONRREAL', '', '', '', 'MAML550603GF9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '', '', 'cortinasdeseguridad@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (21199, 2, 'MARIA EUGENIA RENDON ARCE', '', '', '', 'REAE590507Q58', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27280', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (72306, 2, 'MARIA SUSANA PEREZ SOTO ', '', '', '', 'PESS650329KW9', 1, 'Moneda nacional', 22245, 'MAZATLAN', '8000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (72480, 2, 'MARIBEL VALDOVINOS LOPEZ', '', '', '', 'VALM790311DC9', 1, 'Moneda nacional', 69499, 'CUERNAVACA', '62662', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (21880, 2, 'MARKETING VISUAL DEL PACIFICO, SA DE CV', '', '', '', 'VIN060711I30', 1, 'Moneda nacional', 324, 'NAUCALPAN', '63175', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:52:59', '2021-02-23 15:52:59', 0, 0);
INSERT INTO `proveedores` VALUES (563, 2, 'MARMOLEJO AMOZURRUTIA JUAN', '', '7235515', '', 'MAAJ6809231S7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35080', '7235515', '', 'aleman@marmolejolaguna.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (497, 2, 'MARQUEZ Y ASOCIADOS ASESORIA FISCAL, SC', '', 'ERIKA ESCAMILLA', '', 'MAA8505299J2', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7124910', '7128462', 'erika@marquezyasociados.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (355, 2, 'MARTINEZ GOMEZ LEONARDO', '', 'LEONARDO MARTINEZ', '', 'MAGL790914K56', 1, 'Moneda nacional', 307, 'TORREON', '27277', '8711675616', '', 'administracion@casistemas.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (483, 2, 'MATA AVILA KARINA SOLEDAD', '', '', '', 'MAAK800101RM9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (699, 2, 'MATERIALES COMSA SA DE CV ', '', '', '', 'MCO830127BI6', 1, 'Moneda nacional', 307, 'TORREON', '27020', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (72472, 2, 'MAURICIO REGUERO FLORES', '', '', '', 'REFM930930KM4', 1, 'Moneda nacional', 69499, 'CUERNAVACA', '62450', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (19899, 2, 'MAXIMA COMERCIAL, S.A. DE C.V.', '', '', '', 'MCO 971001 435', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (67647, 2, 'MAYORAMSA SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'maytorreon.ventas@mayoramsa.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (70614, 2, 'MAYORISTA ELECTRICO Y FERRETERO SA DE CV', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82000', '016699818045', '', 'JCCASTRO@MAZATLAN.COM.MX', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (15629, 2, 'MAYRA MARIBEL PEÑA RODRIGUEZ', '', '', '', 'PERM7008191T5', 1, 'Moneda nacional', 310, 'LERDO', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (707, 2, 'METALICOS DAVILA', '', 'GUSTAVO MOLINA CORDOVA', '', 'MDA 880506 QW6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', 'ventasmatriz@metalicosdavila.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:00', '2021-02-23 15:53:00', 0, 0);
INSERT INTO `proveedores` VALUES (757, 2, 'MGC DE LA LAGUNA SA DE CV', '', '', '', 'MLA0607054K5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27140', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (766, 2, 'MIGUEL ANGEL AGUILLON ZARATE ', '', '', '', 'AUZM730107EX4', 1, 'Moneda nacional', 307, 'TORREON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (68767, 2, 'MIGUEL ANGEL ORRANTE CAZARES', '', '', '', 'OACM700513KP4', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (21797, 2, 'MIGUEL YAÑEZ ALVAREZ', '', '', '', 'YAAM730807HS0', 1, 'Moneda nacional', 307, 'TORREON', '27140', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (467, 2, 'MM CONCRETOS SA DE CV', '', 'ALMA BORJON', '', 'MCO130409 3Z8', 1, 'Moneda nacional', 307, 'TORREON', '27019', '7507494', '8711893042', 'compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (589, 2, 'MOBILIARIO E INTERIORES MC SA DE CV', '', 'YSABETH AGUILAR', '', 'MIN140613SK3', 1, 'Moneda nacional', 321, 'MERIDA', '97133', '9999443700', '', 'amatimerida@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (20074, 2, 'MODA IN CASA S.A. DE C.V.', '', '', '', 'MCA831201PI0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '01060', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (624, 2, 'MOLINA VENEGAS ROBERTO', '', 'WENDY BLANQUET', '', 'MOVR890120RR0', 1, 'Moneda nacional', 307, 'TORREON', '27000', '8711178723', '8711518746', 'rmolina@socialclickmarketing.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (727, 2, 'MONSERRATT ALBERTINA AVILA ELIZONDO', '', '', '', 'AIEM780326FD9', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27110', '1-91-69-60', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (435, 2, 'MONTENEGRO GARCIA RODRIGO', '', 'RODRIGO ', 'MARTHA', 'MOGR930622 UX2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '8711842648', '', 'fareme1@gmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (509, 2, 'MONTENEGRO SOTO MIGUEL ANGEL', '', '', '', 'MOSM360916Q51', 1, 'Moneda nacional', 307, 'TORREON', '27150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:01', '2021-02-23 15:53:01', 0, 0);
INSERT INTO `proveedores` VALUES (569, 2, 'MORALES VEGA JUAN MANUEL', '', 'JUAN MUANUEL MORALES', '', 'MOVJ7206083V5', 1, 'Moneda nacional', 307, 'TORREON', '27299', '8711565874', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (72695, 2, 'MOTOCICLETAS EUROPEAS SA DE CV', '', '', '', 'MEU0502286Q0', 1, 'Moneda nacional', 72694, 'SAN PEDRO GARZA GARCIA ', '66220', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (415, 2, 'MOTORAMA DE LA LAGUNA, S.A. DE C.V.', '', 'JESUS ALEJANDRO RAMOS MADRIGAL', '', 'MLA0511078L9', 1, 'Moneda nacional', 307, 'TORREON', '27020', '7176414', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (505, 2, 'MR CONCRETOS, SA DE CV', '', '', '', 'MCO020820R96', 1, 'Moneda nacional', 307, 'TORREON', '27148', '7112383', '8711319769', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (343, 2, 'MULTIACEROS Y MATERIALES SA DE CV', '', 'MONI ', 'GINA', 'MMA860715I97', 1, 'Moneda nacional', 307, 'TORREON', '27276', '7152760', '7303244', 'compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (19901, 2, 'MULTIMEDIOS, S.A. DE C.V.', '', '', '', 'MUL 071114 7NA', 1, 'Moneda nacional', 311, 'MONTERREY', '64700', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (17861, 2, 'MULTISERVICIOS ESPECIALIZADOS IRCE SA DE CV', '', '', '', 'MEI161123QK6', 1, 'Moneda nacional', 311, 'MONTERREY', '64520', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (69482, 2, 'MUNICIPIO DE MAZATLAN', '', '', '', 'MMA810101BN9', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (63709, 2, 'MUNICIPIO GOMEZ PALACIO', '', '', '', 'TMU820908EP0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (593, 2, 'NACIONAL SANTA FE SA DE CV', '', '', 'LUPITA DEL CAMPO', 'NSF930414HN1', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7163078', '', 'lupitadelcampo07@gmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (603, 2, 'NAP INNOVACION, CREATIVIDAD Y PRODUCTIVIDAD SA DE CV', '', '', '', 'NIC100625HT4', 1, 'Moneda nacional', 323, 'VENUSTIANO CARRANZA', '15900', '0455543426149', '', 'p.sanchezaldana@napsa.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:02', '2021-02-23 15:53:02', 0, 0);
INSERT INTO `proveedores` VALUES (72046, 2, 'NORMA CONSUELO FONTES MARTINEZ', '', '', '', 'FOMN640228ME9', 1, 'Moneda nacional', 72045, 'ZAPOPAN', '45040', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (68331, 2, 'NUBOSOFT SERVICIOS SA DE CV', '', '', '', 'NSE111011M99', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35039', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (19358, 2, 'NUEVA WAL MART DE MEXICO, S DE R.L. DE C.V.', '', '', '', 'NWM9709244W4', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '02770', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (613, 2, 'NUEVA WALMART DE MEXICO SA DE RL DE CV', '', '', '', 'NWM9709244W4', 1, 'Moneda nacional', 324, 'NAUCALPAN', '02770', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (21201, 2, 'NUPA INMOBILIARIA Y CONSTRUCTORA SA DE CV', '', '', '', 'BIC1504244K6', 1, 'Moneda nacional', 307, 'TORREON', '27266', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (67694, 2, 'OF CONSULTORIA LEGAL, S.C.', '', 'Susana Alejandra Chavero Galin', '', 'CLE9809017T7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35015', '5547125214', '', 'susana.chavero@ofconsultoria.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (628, 2, 'OFFICE DEPOT DE MEXICO SA DE CV', '', '', '', 'ODM950324V2A', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '05348', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (72618, 2, 'OFFIVISION SA DE CV', '', '', '', 'OFF130625FW3', 1, 'Moneda nacional', 69163, 'CULIACAN', '80220', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (22867, 2, 'OLGA NIDIA PRADO SANTIN', '', '', '', 'PASO610922DK3', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82010', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (69500, 2, 'OLIVIA OCHOA JIMENEZ', '', '', '', 'OOJO720513JH8', 1, 'Moneda nacional', 69499, 'CUERNAVACA', '62000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (72453, 2, 'OPERADORA HOTELERA CAAVI SA PI DE CV', '', '', '', 'OHC1304041R1', 1, 'Moneda nacional', 69163, 'CULIACAN', '80150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (72093, 2, 'OPERADORA OMX SA DE CV', '', '', '', 'OOM960429832', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '05348', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:03', '2021-02-23 15:53:03', 0, 0);
INSERT INTO `proveedores` VALUES (499, 2, 'OROZCO GARCIA LORENZO', '', 'HECTOR GONZALEZ', '', 'OOGL750810J83', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35043', '7375026', '1923021', 'distribuidoradetuberias@grimosa.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (459, 2, 'PAPELERA DEL NORTE DE LA LAGUNA SA DE CV', '', 'EDUARDO CORRAL ', '', 'PNL840516 MM0', 1, 'Moneda nacional', 307, 'TORREON', '27020', '7231920', '7144441', 'sucursal1010@papeleradelnorte.net', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (72210, 2, 'PASE SERVICIOS ELECTRONICOS SA DE CV', '', '', '', 'ISD950921HE5', 1, 'Moneda nacional', 71884, 'MIGUEL HIDALGO ', '11529', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (681, 2, 'PASTELERIA Y CONFITERIA DE MEXICO SA DE CV ', '', '', '', 'PCM881209N54', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '11560', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (21016, 2, 'PEDRO ANTONIO BALDERAS AGUIRRE', '', '', '', 'BAAP9709278X3', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (22151, 2, 'PEDRO GERARDO MORALES CARRANZA', '', '', '', 'MOCP870703EJ3', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (69001, 2, 'PEDRO NOE TIZNADO ALARCON', '', '', '', 'TIAP7605239Z5', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82127', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (72086, 2, 'PETROPLAZAS SA DE CV', '', '', '', 'PET0309111I2', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82102', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (429, 2, 'PINTURAS Y LACAS DE LA LAGUNA SA DE CV', '', 'SERGIO REYES', '', 'PLL8708215R1', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35150', '725-43-21', '7231212', 'pylsalerdo@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (363, 2, 'POLIESTIRENO ALFA GAMMA SA DE CV', '', 'JORGE GALICIA', '', 'PAG9110236T6', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35080', '7590950 al 53', '8711611189', 'ventaslaguna@alfagamma.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (443, 2, 'PORRAS CASTILLO MARCELO', '', 'VICKY', '', 'POCM670103N87', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '717 80 40', 'vicky_.32@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (68507, 2, 'PORTOFINO STONE SA de CV', '', '', '', 'PST1911018Y2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35049', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:04', '2021-02-23 15:53:04', 0, 0);
INSERT INTO `proveedores` VALUES (381, 2, 'PRESIDENCIA MUNICIPAL DE CD LERDO DGO', '', 'CLAUDIA PARGA', '', 'PMC951010FE3', 1, 'Moneda nacional', 310, 'LERDO', '35150', '1750000', '', 'c_parga@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (413, 2, 'PRODUCTOS ELECTROMECANICOS DEL PARQUE SA DE CV', '', 'ROBERTO MARQUEZ IBARRA', '', 'PEP-830603-2M7', 1, 'Moneda nacional', 310, 'LERDO', '35150', '725 81 80', '', 'delparque83@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (16870, 2, 'PROGRAMAS TECNICOS  DE  MEXICO SA DE CV', '', 'ROMAN CORRALES', '', 'PTM140520J63', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35080', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (69994, 2, 'PROVEEDORA MEDICA FATIMA SA DE CV', '', '', '', 'PMF090806TJ6', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82126', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (489, 2, 'PROVEEDORA MEXICANA DE MATERIALES SA DE CV', '', '', '', 'PMM700717WQ0', 1, 'Moneda nacional', 307, 'TORREON', '27100', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (68567, 2, 'PROVEPUERTAS SA DE CV', '', '', '', 'PRO0910293D7', 1, 'Moneda nacional', 311, 'MONTERREY', '66059', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (23027, 2, 'PROYECTOS Y SOLUCIONES INTEGRALES DE LA LAGUNA SA DE CV', '', '', '', 'PYS-111101-L67', 1, 'Moneda nacional', 307, 'TORREON', '27100', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (703, 2, 'PUERTAS Y MARCOS AJUSTABLES S.A. DE C.V.', '', 'AARON RAMOS VILLARREAL', '', 'PMA-1205231-I3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '66610', '81-83-85-57-07', '', 'aaramos@pymaa.com.mx;ghurtado@pymaa.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (777, 2, 'QUATTRO ARQUITECTURA  Y CONSTRUCCIONES SA DE CV', '', 'LIDIA ESPINOZA', '', 'QAC0601198K5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27274', '7-22-88-10', '', 'lidia_espinoza20@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (455, 2, 'RADIOMOVIL DIPSA SA DE CV', '', '', '', 'RDI841003QJ4', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '11529', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (581, 2, 'RAMIREZ ANDRADE JESUS', '', 'NADIA', 'NADIA', 'RAAJ 631218 E91', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7182829', '', 'ofiplustorreon@gmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (70792, 2, 'RAUL HERNANDEZ VILLA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 307, 'TORREON', '27285', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:05', '2021-02-23 15:53:05', 0, 0);
INSERT INTO `proveedores` VALUES (357, 2, 'RECUBRIMIENTOS Y ADHESIVOS DE LA LAGUNA SA DE CV', '', 'EDUARDO CRUZ', '', 'RAL910124RN9', 1, 'Moneda nacional', 307, 'TORREON', '27019', '7506465', '2252672', 'edicruzromo@real-sa.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (646, 2, 'REFACCIONARIA DE LA LAGUNA DEL NORTE SA DE CV ', '', '', '', 'RLN811026ED7', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (353, 2, 'REGISTRO UNICO DE VIVIENDA', '', '', '', '', 1, 'Moneda nacional', 308, 'DELEGACION MIGUEL HIDALGO', '01020', '018000077788', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (68996, 2, 'RENATO ANDRADE AGUILAR ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82103', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (22201, 2, 'RESTAURANTE NEW YORK', '', '', '', 'RURR821217LZ7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35380', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (20507, 2, 'RICARDO ADAN CASTRO PRADO', '', '', '', 'CARP770415KW8', 1, 'Moneda nacional', 318, 'DURANGO', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (583, 2, 'RIVAS ALVARADO PABLO', '', 'ARIANA PEREZ', '', 'RIAP 671201 T71', 1, 'Moneda nacional', 320, 'GUADALAJARA', '44500', '018008010932', '', 'ariana.perez@okhosting.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (507, 2, 'RIVERA SIERRA NATIVIDAD', '', '', '', 'RISN600907CH7', 1, 'Moneda nacional', 307, 'TORREON', '27453', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (373, 2, 'RIVERS SYSTEMS SA DE CV', '', 'SARAH ROSALES', '', 'RSY020506QIA', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7135059', '018008210577', 'srosales@rivers.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (20729, 2, 'ROBERTO DAVILA CASTAÑEDA', '', '', '', 'DACR5902257S7', 1, 'Moneda nacional', 307, 'TORREON', '27110', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (693, 2, 'RODOLFO OSVALDO AYALA REYES', '', '', '', 'AARR751102HD6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '3-15-56-21', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (719, 2, 'RODRIGO AGUSTIN MONTENEGRO ALBA', '', '', '', 'MOAR680828JC0', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35015', '', '', ' fareme1@gmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (701, 2, 'ROJAS ALVARADO JOSE ANTONIO', '', '', '', 'ROAA6903091F2', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:06', '2021-02-23 15:53:06', 0, 0);
INSERT INTO `proveedores` VALUES (451, 2, 'ROMO MACIAS PEDRO ERNESTO', '', '', '', 'ROMP661107 9L8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '718 33 69', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:07', '2021-02-23 15:53:07', 0, 0);
INSERT INTO `proveedores` VALUES (20747, 2, 'ROSA ADRIANA RODRIGUEZ RIOS', '', '', '', 'RORR780408GK6', 1, 'Moneda nacional', 307, 'TORREON', '27105', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:07', '2021-02-23 15:53:07', 0, 0);
INSERT INTO `proveedores` VALUES (21084, 2, 'ROSA MARIA DE MONTSERRAT TATAY MARTINEZ', '', '', '', 'TAMR541127KA3', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:07', '2021-02-23 15:53:07', 0, 0);
INSERT INTO `proveedores` VALUES (513, 2, 'ROSALES CABRAL VICTOR MANUEL', '', '', '', 'ROCV5905265I5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (67620, 2, 'ROSENDO LOPEZ RODRIGUEZ', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (68579, 2, 'RUBEN REYES VALENZUELA', '', '', '', 'REVR860317929', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (67658, 2, 'RUBEN RODRIGUEZ ORTIZ', '', '', '', 'ROOR610821B69', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'ruber61@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (660, 2, 'RUIZ AVILA RICARDO', '', '', '', 'RUAR700328JQ4', 1, 'Moneda nacional', 307, 'TORREON', '27200', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (365, 2, 'RUIZ RAMIREZ GREGORIO', '', 'MARTIN ARANDA', '', 'RURG550221FF7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '7238484', '', 'martinaranda@ymail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (377, 2, 'RUIZ VAZQUEZ EDUARDO', '', 'BORIS', 'GUILLERMO', 'RUVE630720N2A', 1, 'Moneda nacional', 307, 'TORREON', '27275', '7204273', '', 'georuva@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx;averdin@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (642, 2, 'SALCIDO SANDOVAL ALBERTO', '', '', '', '', 1, 'Moneda nacional', 320, 'GUADALAJARA', '44190', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (667, 2, 'SALMON DE LA LAGUNA  S.A. DE C.V.', '', '', '', 'SLA8210184A7', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7-16-36-51', '', 'tito.santos@gebesa.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (671, 2, 'SALMON DE LA LAGUNA SA DE CV ', '', '', '', 'SLA8210184A7', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (736, 2, 'SALOMON GERARDO CASTRO ENRIQUEZ ', '', '', '', 'CAES560625SIA', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27110', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:08', '2021-02-23 15:53:08', 0, 0);
INSERT INTO `proveedores` VALUES (689, 2, 'SALPER S.A. DE C.V.', '', '', '', '', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7-12-79-90', '', 'salpertorreon@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (533, 2, 'SCOTIABANK', '', 'CLAUDIA PALACIOS', '', 'SIN9412025I4', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '06820', '7490368', '', 'cpalaciosc@scotiabank.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (19405, 2, 'SEARS OPERADORA MEXICO, S.A. DE C.V.', '', '', '', 'SOM101125UEA', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (19275, 2, 'SECRETARIA DE FINANZAS Y ADMON. DEL EDO. DE DURANGO', '', '', '', 'GED620101652', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (20298, 2, 'SEISA ELECTOMECANICA S.A. DE C.V.', '', '', '', 'SEL 1509223I5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27089', '', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (553, 2, 'SELLOS IMPERMEABLES DEL NORTE S.A. DE C.V.', '', 'Patricia', '', 'SIN050622AA7', 1, 'Moneda nacional', 307, 'TORREON', '27020', '7181812', '8711513215', 'protexatorreon@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (69164, 2, 'SENZ SA DE CV', '', '', '', 'SEN101105SQ1', 1, 'Moneda nacional', 69163, 'CULIACAN', '80300', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (64640, 2, 'SERGIO GABRIEL CUETO GONZALEZ', '', '', '', 'CUGS940614AN3', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '8715 11 86 66', '', 'graph_publicity@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (737, 2, 'SERGIO LUIS ALVARADO SALDIVAR ', '', '', '', 'AASS710908JB5', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (673, 2, 'SERVICIO AUTOMOTRIZ DE TORREON SA DE CV ', '', '', '', 'SAT071211FD3', 1, 'Moneda nacional', 307, 'TORREON', '27089', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (23670, 2, 'SERVICIO DE ADMINISTRACION TRIBUTARIA', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:09', '2021-02-23 15:53:09', 0, 0);
INSERT INTO `proveedores` VALUES (503, 2, 'SERVICIOS ELECTROHIDRAULICOS INTEGRALES SA DE CV', '', '', '', 'SEI0305095T3', 1, 'Moneda nacional', 307, 'TORREON', '27275', '7486040', '', 'hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (72767, 2, 'SERVICIOS Y GASOLINERA LA COSTERITA SA DE CV ', '', '', '', 'SGC060919PA9', 1, 'Moneda nacional', 69163, 'CULIACAN', '80104', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (614, 2, 'SISTEMA DE AGUA POTABLE Y ALCANTARILLADO DEL MUNICIPIO DE CD LERDO DGO', '', '', '', 'SAP990715876', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', 'sapalerdo1@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (70717, 2, 'SISTEMAS DE ALMACENAJE DASA SA DE CV', '', '', '', 'SAD190924H65', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82010', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (611, 2, 'SOLUCIONES INTEGRALES DE REINGENIERIA Y ADMINISTRACION SC', '', '', '', 'SIR110902N91', 1, 'Moneda nacional', 324, 'NAUCALPAN', '53127', '015562662403', '', 'soporte@analisiscomercialsira.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (651, 2, 'SURMAN MOTORS SA DE CV ', '', '', '', 'SMO99011491A', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (762, 2, 'TCI TRANSPORTES, SA DE CV', '', '', '', 'TTR990121-FU7', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27280', '8717297500', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (20079, 2, 'TECNICENTRO GUZMAN S.A. DE C.V.', '', '', '', 'TGU161006GV2', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '82103', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (21103, 2, 'TECNOSEGRIDAD CIDEP S.A. DE C.V.', '', '', '', 'TCI0611249S6', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '04360', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (597, 2, 'TELEFONOS DE MEXICO SAB DE CV', '', '', 'ROBERTO MARTINEZ', 'TME840315KT6', 1, 'Moneda nacional', 314, 'DELEGACION IZTACALCO', '06500', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (640, 2, 'TEPEPA ROSALES JOSE LUIS', '', '', '', 'TERL830914NA6', 1, 'Moneda nacional', 310, 'LERDO', '35159', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:10', '2021-02-23 15:53:10', 0, 0);
INSERT INTO `proveedores` VALUES (545, 2, 'TEXA DE LA LAGUNA S.A DE C.V', '', 'MARCO TRUJILLO', '', '', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35070', '7575000', '8711613500', 'servicio@texasa.net;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (21653, 2, 'THE GAME MARKETING S.A. DE C.V.', '', '', '', 'GMA140123HZ3', 1, 'Moneda nacional', 307, 'TORREON', '27100', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (663, 2, 'TIENDAS SORIANA S.A. DE C.V.', '', '', '', 'TSO991022PB6', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '35090', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (537, 2, 'TODD DE LA GARZA Y TORRES, S.C.', '', 'FERNANDO TODD', '', 'TGT130212SR0', 1, 'Moneda nacional', 307, 'TORREON', '27000', '2280725', '', 'todd@heralde.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (19220, 2, 'TOMAS GALVAN CAMACHO', '', '', '', 'CACT6109199B2', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (375, 2, 'TORRES AVALOS DAVID ERNESTO', '', 'DAVID ERNESTO TORRES AVALOS', '', 'TOAD650330I35', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35000', '8711645386', '', 'ventas@asproecom.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (477, 2, 'TORRES OLIVARES MARCO ANTONIO', '', '', '', 'TOOM880614GK8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7324989', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (70688, 2, 'TOTAL PLAY TELECOMUNICACIONES SA DE CV', '', '', '', 'TPT890516JP5', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (20862, 2, 'TP INNOVATIONS, SA DE CV', '', '', '', 'PIN150304LC6', 1, 'Moneda nacional', 311, 'MONTERREY', '64000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (419, 2, 'TRANSFORMADORES Y PROYECTOS INDUSTRIALES SA DE CV', '', '', '', '', 1, 'Moneda nacional', 313, 'SALTILLO', '25210', '844 288. 4040', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (72128, 2, 'TRANSPORTES ANSO, S.A. DE C.V.', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 311, 'MONTERREY', '67330', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (421, 2, 'TRAVERTINOS LAGUNA SA DE CV', '', 'NANCY FLORES', '', 'TLA030218440', 1, 'Moneda nacional', 310, 'LERDO', '', '759 17 20 EXT 103', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:11', '2021-02-23 15:53:11', 0, 0);
INSERT INTO `proveedores` VALUES (636, 2, 'TRES DIMENSIONES SISTEMAS CONSTRUCTIVOS SA DE CV ', '', 'CLAUDIA CONTRERAS', '', 'TDS990423UZ1', 1, 'Moneda nacional', 310, 'LERDO', '35150', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (401, 2, 'TRITURADOS CRIBISSA SA DE CV', '', 'NANCY', '', 'TCS970503824', 1, 'Moneda nacional', 310, 'LERDO', '35153', '725 37 42', '', 'ventas@cribissa.com.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (557, 2, 'TUBERIA Y CABLES SA DE CV', '', '', 'PEPE', 'TCA 120328 44A', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7938775', '', 'ventas_tycsa@prodigy.net.mx;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (22130, 2, 'TUBERIAS Y VALVULAS DEL NOROESTE', '', '', '', 'TVN7407019H3', 1, 'Moneda nacional', 307, 'TORREON', '27089', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (387, 2, 'ULTRACONCRETO SA DE CV', '', 'ESTEFANIA', '', 'ULT0602043R4', 1, 'Moneda nacional', 307, 'TORREON', '27270', '2096767', '2096768', 'esalinas@viviend.mx;averdin@viviend.mx;almacen@viviend.mx;compras@viviend.mx;hsalinas@viviend.mx;ultraconcreto.ventas@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (654, 2, 'VALDES BARBA LETICIA', '', '', '', 'VABL530606AM8', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'geaoficinamty@hotmail.com;acrilgea@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (20312, 2, 'VALSA PANEL, S.A. DE C.V.', '', '', '', 'VPA920617QZ3', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '', '', '', 'mcoronel@grupomasvalor.mx;hsalinas@viviend.mx;esalinas@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (64128, 2, 'VANILLA COLOR SA DE CV', '', '', '', 'VCO170220E50', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', 'vanilla.admon@gmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (565, 2, 'VELASCO DE LA RIVA MARCO ANTONIO', '', 'Raquel 7-14-19-02', '', 'VERM750115F15', 1, 'Moneda nacional', 307, 'TORREON', '27000', '7141902', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (399, 2, 'VELASCO RUBIO MARIA EUGENIA', '', 'MARCELO ARMENDARIZ', '', 'VERE6011027D1', 1, 'Moneda nacional', 310, 'LERDO', '35150', '7404261', '8711376061', 'arvelconstrucciones@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (622, 2, 'VELOZ NEVAREZ MARIANA', '', '', '', 'VENM890621RI4', 1, 'Moneda nacional', 307, 'TORREON', '27010', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (609, 2, 'VENTACERO EXPRESS SA DE CV', '', '', '', 'VEX090807ED9', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35029', '7481200', '', 'suc.morelos@ventacero.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:12', '2021-02-23 15:53:12', 0, 0);
INSERT INTO `proveedores` VALUES (21166, 2, 'VENTACERO, S.A. DE C.V.', '', '', '', 'VAC8110164V0', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35078', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:13', '2021-02-23 15:53:13', 0, 0);
INSERT INTO `proveedores` VALUES (68527, 2, 'VENTANAS PREFABRICADAS DE ALUMINIO', '', '', '', 'VPA-970409-FQ4', 1, 'Moneda nacional', 311, 'MONTERREY', '66362', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:13', '2021-02-23 15:53:13', 0, 0);
INSERT INTO `proveedores` VALUES (22246, 2, 'VERONICA CONCEPCION RIOS LIRA', '', '', '', 'RILV680831FP6', 1, 'Moneda nacional', 22245, 'MAZATLAN', '82157', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:13', '2021-02-23 15:53:13', 0, 0);
INSERT INTO `proveedores` VALUES (72478, 2, 'VICENTE COLON XOCHIPA ', '', '', '', 'COXV720122LTA', 1, 'Moneda nacional', 327, 'DISTRITO FEDERAL', '06200', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:13', '2021-02-23 15:53:13', 0, 0);
INSERT INTO `proveedores` VALUES (72313, 2, 'VICTOR ISMAEL TORRES TIZNADO', '', '', '', 'XAXX010101000', 1, 'Moneda nacional', 69163, 'CULIACAN', '8000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:13', '2021-02-23 15:53:13', 0, 0);
INSERT INTO `proveedores` VALUES (369, 2, 'VILLALPANDO ARREOLA SAN JUANA', '', 'ROBERTO RAMIREZ', '', 'VIAS660720US5', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35018', '7370748', '8711410118', 'ingramiremurillo@hotmail.com', 'ACTIVO                 ', 1, '2021-02-23 15:53:13', '2021-02-23 15:53:13', 0, 0);
INSERT INTO `proveedores` VALUES (20898, 2, 'VIVEROS VALLE DEL PILON S.P.R DE R.L DE C.V', '', '', '', 'VVP1307291R4', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '67560', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:13', '2021-02-23 15:53:13', 0, 0);
INSERT INTO `proveedores` VALUES (423, 2, 'WINDOOR SA DE CV', '', 'AARON RAMOS', '', 'WIN990127BW5', 1, 'Moneda nacional', 311, 'MONTERREY', '66634', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:14', '2021-02-23 15:53:14', 0, 0);
INSERT INTO `proveedores` VALUES (658, 2, 'ZAIN MARIN ALIA NUR', '', 'Ing. Sami Alejandro Zain', '', '', 1, 'Moneda nacional', 326, 'DELEGACION ALVARO OBREGON', '27130', '7-13-56-00', '', 'malla.acero@hotmail.com;hsalinas@viviend.mx;esalinas@viviend.mx;almacen@viviend.mx;contabilidad@viviend.mx;compras@viviend.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:14', '2021-02-23 15:53:14', 0, 0);
INSERT INTO `proveedores` VALUES (547, 2, 'ZAPATERIAS SUPER SA DE CV', '', 'TERE DE J ROCHA GALVAN', '', 'ZSU920314FC2', 1, 'Moneda nacional', 309, 'GOMEZ PALACIO', '35070', '7124875', '7194455', 'creditoycobranza@discalse.com.mx', 'ACTIVO                 ', 1, '2021-02-23 15:53:14', '2021-02-23 15:53:14', 0, 0);
INSERT INTO `proveedores` VALUES (774, 2, 'ZARLAG SA DE CV', '', '', '', 'ZAR760126963', 1, 'Moneda nacional', 307, 'TORREON', '27000', '', '', '', 'ACTIVO                 ', 1, '2021-02-23 15:53:14', '2021-02-23 15:53:14', 0, 0);

CREATE TABLE `recepcion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_orden_compra` int(11) DEFAULT '0',
  `id_proveedor` int(11) DEFAULT '0',
  `id_almacen` int(11) DEFAULT '0',
  `id_moneda` int(11) DEFAULT '0',
  `idEmpresa` int(11) DEFAULT '1',
  `folio` varchar(50) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fecha` datetime DEFAULT NULL,
  `importe_neto` decimal(20,2) DEFAULT '0.00',
  `fecha_entrega` datetime DEFAULT NULL,
  `numero_articulos` int(11) DEFAULT '0',
  `estatus` varchar(10) DEFAULT NULL COMMENT 'PENDIENTE, FACTURADO, CANCELADO',
  `status` int(11) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT '0',
  `updated_by` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `supercategorias_mo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supercategoria` varchar(150) CHARACTER SET utf8 COLLATE utf8_spanish2_ci DEFAULT NULL,
  `idCategoria` text CHARACTER SET utf8 COLLATE utf8_spanish2_ci,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT '1',
  `updated_by` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

INSERT INTO `supercategorias_mo` VALUES (1, 'OBRA NEGRA', '7,6,5,4,3,2,1', 1, '2021-04-13 18:58:38', '2021-04-13 18:58:38', 5, 5);
INSERT INTO `supercategorias_mo` VALUES (2, 'ACABADOS', '13,12,11,10,9,8', 1, '2021-04-13 19:06:13', '2021-04-13 19:06:13', 5, 5);
INSERT INTO `supercategorias_mo` VALUES (3, 'ENTREGA', '15,14', 1, '2021-04-13 19:07:02', '2021-04-13 19:07:02', 5, 5);

CREATE TABLE `tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url_func` varchar(100) NOT NULL COMMENT 'URL O FUNCION',
  `idItem` varchar(11) NOT NULL,
  `periodo` tinyint(4) NOT NULL COMMENT '0|una vez',
  `descripcion` varchar(50) NOT NULL,
  `tipo` tinyint(1) NOT NULL COMMENT '1|mail, 2|whats, 3|bd',
  `status` tinyint(1) NOT NULL COMMENT '0|por ejecutar, 1|ejecutado',
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

CREATE TABLE `logs_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idTask` int(11) NOT NULL,
  `mensaje` varchar(200) NOT NULL,
  `error` varchar(50) NOT NULL,
  `status_ws` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;