/*
SQLyog Community v12.2.2 (64 bit)
MySQL - 5.5.39 : Database - viviend
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`viviend` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `viviend`;

/*Table structure for table `alta_venta` */

DROP TABLE IF EXISTS `alta_venta`;

CREATE TABLE `alta_venta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(11) NOT NULL,
  `idProyecto` int(11) DEFAULT NULL,
  `idProspecto` int(11) DEFAULT NULL,
  `idNotaria` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8_spanish2_ci,
  `monto` decimal(12,2) DEFAULT NULL,
  `subCuenta` decimal(12,2) DEFAULT NULL,
  `gastosOperacion` decimal(12,2) DEFAULT NULL,
  `total` decimal(12,2) DEFAULT NULL,
  `fechaPreca` date DEFAULT NULL,
  `revisionMontos` varchar(30) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'Inician campos validacion venta',
  `motivo` text COLLATE utf8_spanish2_ci,
  `tipoCredito` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `diferencia` decimal(12,2) DEFAULT NULL,
  `bonoEquipamiento` decimal(12,2) DEFAULT NULL,
  `pdf_1` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'acta',
  `statusPdf_1` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_2` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'ife',
  `statusPdf_2` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_3` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'curp',
  `statusPdf_3` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_4` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'bansefi',
  `statusPdf_4` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_5` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'preCalificacion',
  `statusPdf_5` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_6` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'curso',
  `statusPdf_6` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_7` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'SolicitudCredito',
  `statusPdf_7` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `statusValidacion` tinyint(1) DEFAULT '0' COMMENT '0 indica que esta en etapa alta de venta, 1 indica que esta en etapa validacion de venta, 2 indica que ya esta validado, 3 indica que está en alta gestoría, 4 que está disponible para agregar comision/bono a promotor, 5 indica que ya se ha agregado una comisión al promotor',
  `statusEncuesta` tinyint(1) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `alta_venta_ibfk_1` (`idProyecto`),
  KEY `alta_venta_ibfk_2` (`idProspecto`),
  KEY `alta_venta_ibfk_3` (`idNotaria`),
  CONSTRAINT `alta_venta_ibfk_1` FOREIGN KEY (`idProyecto`) REFERENCES `proyectos` (`id`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `alta_venta_ibfk_2` FOREIGN KEY (`idProspecto`) REFERENCES `prospectos` (`id`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `alta_venta_ibfk_3` FOREIGN KEY (`idNotaria`) REFERENCES `notarias` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `alta_venta` */

insert  into `alta_venta`(`id`,`idFraccionamiento`,`idProyecto`,`idProspecto`,`idNotaria`,`descripcion`,`monto`,`subCuenta`,`gastosOperacion`,`total`,`fechaPreca`,`revisionMontos`,`motivo`,`tipoCredito`,`diferencia`,`bonoEquipamiento`,`pdf_1`,`statusPdf_1`,`pdf_2`,`statusPdf_2`,`pdf_3`,`statusPdf_3`,`pdf_4`,`statusPdf_4`,`pdf_5`,`statusPdf_5`,`pdf_6`,`statusPdf_6`,`pdf_7`,`statusPdf_7`,`statusValidacion`,`statusEncuesta`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,0,2,2,1,NULL,'200000.00','80000.00','20000.00','260000.00','2018-01-15','procede','','infonavit puro','150000.00','70000.00','1_1.pdf',1,'1_2.pdf',1,'1_3.pdf',1,'1_4.pdf',1,'1_5.pdf',1,'1_6.pdf',1,'1_7.pdf',1,5,0,1,'2018-01-15 13:35:14','2018-01-15 17:12:06',14,1),

(2,0,3,4,1,NULL,'300000.00','100000.00','20000.00','380000.00','2018-01-15','procede','','infonavit subsidio','150000.00','70000.00','2_1.pdf',1,'2_2.pdf',1,'2_3.pdf',1,'2_4.pdf',1,'2_5.pdf',1,'2_6.pdf',1,'2_7.pdf',1,5,0,1,'2018-01-15 15:25:05','2018-01-16 10:31:29',6,1),

(3,0,1,5,1,NULL,'470000.00','200000.00','20000.00','650000.00','2018-01-16','procede','','foviste','300000.00','100000.00','3_1.pdf',1,'3_2.pdf',1,'3_3.pdf',1,'3_4.pdf',1,'3_5.pdf',1,'3_6.pdf',1,'3_7.pdf',1,5,0,1,'2018-01-16 11:01:44','2018-01-16 11:05:21',19,1);

/*Table structure for table `autorizaciones` */

DROP TABLE IF EXISTS `autorizaciones`;

CREATE TABLE `autorizaciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `montoTotal` decimal(12,2) DEFAULT NULL,
  `difPropPeculio` decimal(12,2) DEFAULT NULL,
  `resultado` decimal(12,2) DEFAULT NULL,
  `propVenta` decimal(12,2) DEFAULT NULL,
  `statusAutorizacion` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `autorizaciones_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `autorizaciones_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `autorizaciones` */

/*Table structure for table `blackboard` */

DROP TABLE IF EXISTS `blackboard`;

CREATE TABLE `blackboard` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(11) NOT NULL,
  `asunto` varchar(45) NOT NULL,
  `proyecto` varchar(45) NOT NULL,
  `delegado` varchar(45) NOT NULL,
  `idUsuario` int(5) NOT NULL,
  `mail` varchar(45) NOT NULL,
  `fechaInicio` date NOT NULL,
  `fechaTermino` date NOT NULL,
  `checked` tinyint(1) NOT NULL,
  `statusAlert` tinyint(5) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(5) NOT NULL,
  `updated_by` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `blackboard` */

/*Table structure for table `comisiones_bonos` */

DROP TABLE IF EXISTS `comisiones_bonos`;

CREATE TABLE `comisiones_bonos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `difPropioPeculio` decimal(12,2) DEFAULT NULL,
  `resultado` decimal(12,2) DEFAULT NULL,
  `saldo` decimal(12,2) DEFAULT NULL,
  `cierre` decimal(12,2) DEFAULT NULL,
  `importeComision` decimal(12,2) DEFAULT NULL,
  `netoVenta` decimal(12,2) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `comisiones_bonos_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `comisiones_bonos_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `comisiones_bonos` */

insert  into `comisiones_bonos`(`id`,`idAltaVenta`,`difPropioPeculio`,`resultado`,`saldo`,`cierre`,`importeComision`,`netoVenta`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,1,'20000.00','180000.00','110000.00','680000.00','20400.00','659600.00',1,'2018-01-15 17:12:06','2018-01-16 10:33:19',17,17),

(2,2,'-140000.00','140000.00','70000.00','640000.00','19200.00','620800.00',1,'2018-01-16 10:31:29','2018-01-16 10:36:35',17,17),

(3,3,'-130000.00','130000.00','30000.00','530000.00','15900.00','514100.00',1,'2018-01-16 11:05:21','2018-01-16 11:05:21',18,18);

/*Table structure for table `depositos` */

DROP TABLE IF EXISTS `depositos`;

CREATE TABLE `depositos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `montoTotal` decimal(12,2) DEFAULT NULL,
  `difPropPeculio` decimal(12,2) DEFAULT NULL,
  `resultado` decimal(12,2) DEFAULT NULL,
  `propVenta` decimal(12,2) DEFAULT NULL,
  `statusAutorizacion` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `depositoInfonavit` decimal(12,2) DEFAULT NULL,
  `depositoConavi` decimal(12,2) DEFAULT NULL,
  `fechaDeposito` date DEFAULT NULL,
  `cuentaDepositada` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `depositos_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `depositos_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `depositos` */

insert  into `depositos`(`id`,`idAltaVenta`,`montoTotal`,`difPropPeculio`,`resultado`,`propVenta`,`statusAutorizacion`,`depositoInfonavit`,`depositoConavi`,`fechaDeposito`,`cuentaDepositada`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,1,'500000.00','400000.00','100000.00','30000.00','si','400000.00','450000.00','1969-12-31','cuenta 1',1,'2018-01-15 19:18:53','2018-01-15 19:18:53',1,1);

/*Table structure for table `encuestavivienda` */

DROP TABLE IF EXISTS `encuestavivienda`;

CREATE TABLE `encuestavivienda` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(10) NOT NULL,
  `fecha` datetime NOT NULL,
  `tratoAsesor` int(2) NOT NULL,
  `tratoAsesorWhy` varchar(200) NOT NULL,
  `nosotros` int(2) NOT NULL,
  `nosotrosOtro` varchar(50) NOT NULL,
  `casaMuestra` int(2) NOT NULL,
  `viviendaAdquirir` int(2) NOT NULL,
  `tiempoTramite` int(2) NOT NULL,
  `gradoAceptacionFracc` int(2) NOT NULL,
  `razonEleccion` varchar(200) NOT NULL,
  `mejorasVivienda` varchar(200) NOT NULL,
  `mejorasfracc` varchar(200) NOT NULL,
  `condicionEntregaVivienda` int(2) NOT NULL,
  `condicionEntregaViviendaWhy` varchar(200) NOT NULL,
  `recomendacionCompra` int(2) NOT NULL,
  `recomendacionCompraWhy` varchar(200) NOT NULL,
  `status` int(2) NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(5) NOT NULL,
  `updated_by` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `encuestavivienda` */

/*Table structure for table `entrega` */

DROP TABLE IF EXISTS `entrega`;

CREATE TABLE `entrega` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `fechaEntrega` date DEFAULT NULL,
  `pdf_12` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'input entrega de vivienda',
  `pdf_13` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'input reglamento de fraccinamiento',
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entrega_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `entrega_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `entrega` */

/*Table structure for table `fraccionamientos` */

DROP TABLE IF EXISTS `fraccionamientos`;

CREATE TABLE `fraccionamientos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `estado` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `municipio` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `foto` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `thumbnail` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `fraccionamientos` */

insert  into `fraccionamientos`(`id`,`titulo`,`estado`,`municipio`,`foto`,`thumbnail`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,'Prueba','coahuila','',NULL,NULL,1,'2018-01-15 13:14:01','2018-01-15 13:23:06',1,1);

/*Table structure for table `fraccionamientosxusuarios` */

DROP TABLE IF EXISTS `fraccionamientosxusuarios`;

CREATE TABLE `fraccionamientosxusuarios` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(50) DEFAULT NULL,
  `idUsuario` int(50) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fraccionamientosxusuarios_ibfk_1` (`idFraccionamiento`),
  KEY `fraccionamientosxusuarios_ibfk_2` (`idUsuario`),
  CONSTRAINT `fraccionamientosxusuarios_ibfk_1` FOREIGN KEY (`idFraccionamiento`) REFERENCES `fraccionamientos` (`id`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `fraccionamientosxusuarios_ibfk_2` FOREIGN KEY (`idUsuario`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `fraccionamientosxusuarios` */

insert  into `fraccionamientosxusuarios`(`id`,`idFraccionamiento`,`idUsuario`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(22,1,8,1,'2018-01-15 13:23:06','2018-01-15 13:23:06',1,1),

(23,1,17,1,'2018-01-15 13:23:06','2018-01-15 13:23:06',1,1),

(24,1,3,1,'2018-01-15 13:23:06','2018-01-15 13:23:06',1,1),

(25,1,14,1,'2018-01-15 13:23:06','2018-01-15 13:23:06',1,1),

(26,1,6,1,'2018-01-15 13:23:06','2018-01-15 13:23:06',1,1),

(27,1,7,1,'2018-01-15 13:23:06','2018-01-15 13:23:06',1,1),

(28,1,16,1,'2018-01-15 13:23:06','2018-01-15 13:23:06',1,1),

(29,1,18,1,'2018-01-16 10:38:06','2018-01-16 10:38:06',1,1),

(30,1,19,1,'2018-01-16 10:52:04','2018-01-16 10:52:04',1,1);

/*Table structure for table `gestoria` */

DROP TABLE IF EXISTS `gestoria`;

CREATE TABLE `gestoria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `aplicaFolio` tinyint(1) DEFAULT '0',
  `numeroFolio` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `numeroCredito` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fechaIngreso` date DEFAULT NULL,
  `certificadoLibertad` char(5) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `constanciaNoAdeudo` char(5) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `precioVentaOci` decimal(12,2) DEFAULT NULL,
  `montoOci` decimal(12,2) DEFAULT NULL,
  `subCuenta` decimal(12,2) DEFAULT NULL,
  `gastosTitulacion` decimal(12,2) DEFAULT NULL,
  `ahorroVol` decimal(12,2) DEFAULT NULL,
  `subsidio` decimal(12,2) DEFAULT NULL,
  `sumaFinal` decimal(12,2) DEFAULT NULL,
  `fechaFirma` date DEFAULT NULL,
  `pdf_8` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'archivo escritura',
  `statusPdf_8` tinyint(1) DEFAULT '0',
  `pdf_9` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'archivo carta de instrucción',
  `statusPdf_9` tinyint(1) DEFAULT '0',
  `pdf_10` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'archivo no adeudo agua',
  `statusPdf_10` tinyint(1) DEFAULT '0',
  `pdf_11` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'archivo certificdo lib o g',
  `statusPdf_11` tinyint(1) DEFAULT '0',
  `statusGestoria` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `motivoCancelacion` varchar(200) COLLATE utf8_spanish2_ci NOT NULL,
  `fechaCancelacion` date NOT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gestoria_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `gestoria_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `gestoria` */

insert  into `gestoria`(`id`,`idAltaVenta`,`aplicaFolio`,`numeroFolio`,`numeroCredito`,`fechaIngreso`,`certificadoLibertad`,`constanciaNoAdeudo`,`precioVentaOci`,`montoOci`,`subCuenta`,`gastosTitulacion`,`ahorroVol`,`subsidio`,`sumaFinal`,`fechaFirma`,`pdf_8`,`statusPdf_8`,`pdf_9`,`statusPdf_9`,`pdf_10`,`statusPdf_10`,`pdf_11`,`statusPdf_11`,`statusGestoria`,`motivoCancelacion`,`fechaCancelacion`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,1,1,'111111','1','2018-01-15','no','no','700000.00','400000.00','200000.00','20000.00','60000.00','100000.00','680000.00','2018-01-15','1_8.pdf',0,'1_9.pdf',0,'1_10.pdf',0,'1_11.pdf',0,'detonado','','0000-00-00',1,'2018-01-15 15:12:36','2018-01-15 15:12:36',1,1),

(2,2,NULL,'','2','2018-01-15','no','no','500000.00','450000.00','100000.00','30000.00','60000.00','120000.00','640000.00','2018-01-15','2_8.pdf',0,'2_9.pdf',0,'2_10.pdf',0,'2_11.pdf',0,'detonado','','0000-00-00',1,'2018-01-15 15:27:35','2018-01-15 15:27:35',1,1),

(3,3,NULL,'','555555','2018-01-16','no','no','400000.00','380000.00','90000.00','20000.00','90000.00','80000.00','530000.00','2018-01-16','3_8.pdf',0,'3_9.pdf',0,'3_10.pdf',0,'3_11.pdf',0,'detonado','','0000-00-00',1,'2018-01-16 11:04:31','2018-01-16 11:04:31',1,1);

/*Table structure for table `logs` */

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `tipo` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `descripcion` text CHARACTER SET latin1,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `logs` */

insert  into `logs`(`id`,`titulo`,`tipo`,`descripcion`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,'Se insertó el registro: 2 de la tabla: usuarios','1','Se insertó el registro: 2 de la tabla: usuarios por el usuario: 1 (admin) el 2018-01-11 13:34:52',1,'2018-01-11 13:34:52','2018-01-11 13:34:52',1,1),

(2,'Se insertó el registro: 1 de la tabla: fraccionamientos','1','Se insertó el registro: 1 de la tabla: fraccionamientos por el usuario: 1 (admin) el 2018-01-15 13:14:01',1,'2018-01-15 13:14:01','2018-01-15 13:14:01',1,1),

(5,'Se actualizó el registro: 1 de la tabla: fraccionamientos','2','Se actualizó el registro: 1 de la tabla: fraccionamientos por el usuario: 1 (admin) el 2018-01-15 13:20:04Los datos anteriores eran: id: 1 ,titulo: Prueba ,estado: coahuila ,municipio:  ,foto:  ,thumbnail:  ,status: 1 ,created: 2018-01-15 13:14:01 ,updated: 2018-01-15 13:14:01 ,created_by: 1 ,updated_by: 1  | Los nuevos son: titulo:Prueba,estado:coahuila,municipio:,status:1,updated:2018-01-15 13:20:04,updated_by:1',1,'2018-01-15 13:20:04','2018-01-15 13:20:04',0,1),

(6,'Se actualizó el registro: 1 de la tabla: fraccionamientos','2','Se actualizó el registro: 1 de la tabla: fraccionamientos por el usuario: 1 (admin) el 2018-01-15 13:23:06Los datos anteriores eran: id: 1 ,titulo: Prueba ,estado: coahuila ,municipio:  ,foto:  ,thumbnail:  ,status: 1 ,created: 2018-01-15 13:14:01 ,updated: 2018-01-15 13:20:04 ,created_by: 1 ,updated_by: 1  | Los nuevos son: titulo:Prueba,estado:coahuila,municipio:,status:1,updated:2018-01-15 13:23:06,updated_by:1',1,'2018-01-15 13:23:06','2018-01-15 13:23:06',0,1),

(7,'Se insertó el registro: 1 de la tabla: proyectos','1','Se insertó el registro: 1 de la tabla: proyectos por el usuario: 1 (admin) el 2018-01-15 13:25:57',1,'2018-01-15 13:25:57','2018-01-15 13:25:57',1,1),

(8,'Se insertó el registro: 2 de la tabla: proyectos','1','Se insertó el registro: 2 de la tabla: proyectos por el usuario: 1 (admin) el 2018-01-15 13:26:48',1,'2018-01-15 13:26:48','2018-01-15 13:26:48',1,1),

(9,'Se insertó el registro: 3 de la tabla: proyectos','1','Se insertó el registro: 3 de la tabla: proyectos por el usuario: 1 (admin) el 2018-01-15 13:27:18',1,'2018-01-15 13:27:18','2018-01-15 13:27:18',1,1),

(10,'Se insertó el registro: 1 de la tabla: prospectos','1','Se insertó el registro: 1 de la tabla: prospectos por el usuario: 1 (admin) el 2018-01-15 13:29:18',1,'2018-01-15 13:29:18','2018-01-15 13:29:18',1,1),

(11,'Se insertó el registro: 2 de la tabla: prospectos','1','Se insertó el registro: 2 de la tabla: prospectos por el usuario: 1 (admin) el 2018-01-15 13:30:05',1,'2018-01-15 13:30:05','2018-01-15 13:30:05',1,1),

(12,'Se insertó el registro: 3 de la tabla: prospectos','1','Se insertó el registro: 3 de la tabla: prospectos por el usuario: 1 (admin) el 2018-01-15 13:30:50',1,'2018-01-15 13:30:50','2018-01-15 13:30:50',1,1),

(13,'Se insertó el registro: 4 de la tabla: prospectos','1','Se insertó el registro: 4 de la tabla: prospectos por el usuario: 1 (admin) el 2018-01-15 13:32:48',1,'2018-01-15 13:32:48','2018-01-15 13:32:48',1,1),

(14,'Se insertó el registro: 1 de la tabla: alta_venta','1','Se insertó el registro: 1 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-15 13:35:14',1,'2018-01-15 13:35:15','2018-01-15 13:35:15',1,1),

(15,'Se actualizó el registro: 2 de la tabla: prospectos','2','Se actualizó el registro: 2 de la tabla: prospectos por el usuario: 1 (admin) el 2018-01-15 13:35:15Los datos anteriores eran: id: 2 ,idPromotor: 14 ,idFraccionamiento: 1 ,nombre: Javier ,apellidoP: Guti ,apellidoM:  ,rfc:  ,telefono:  ,fecha: 2018-01-15 ,fechaNac: 2018-01-15 ,lugarProspeccion: casa muestra ,otroLugar:  ,nss: 22222222222 ,statusProspecto: interesado ,comentario:  ,prototipo: 2 ,status: 1 ,created: 2018-01-15 13:30:05 ,updated: 2018-01-15 13:30:05 ,created_by: 1 ,updated_by: 1  | Los nuevos son: nombre:Javier,apellidoP:Guti,apellidoM:,rfc:,telefono:,fecha:2018-01-15,fechaNac:2018-01-15,statusProspecto:interesado,updated:2018-01-15 13:35:15,updated_by:1',1,'2018-01-15 13:35:15','2018-01-15 13:35:15',0,1),

(16,'Se actualizó el registro: 2 de la tabla: proyectos','2','Se actualizó el registro: 2 de la tabla: proyectos por el usuario: 1 (admin) el 2018-01-15 13:35:15Los datos anteriores eran: id: 2 ,idFraccionamiento: 1 ,idPrototipo: 1 ,numPaquete: 2 ,lote: 2 ,manzana: 1 ,calle: 17 ,nOficial: 2 ,cuv: 2 ,claveCatastral: 2 ,supTerreno: 200.00 ,supConstruccion: 250.00 ,precioVenta: 500000.00 ,statusProyecto: dtu ,puntaje: 50.00 ,porcentajeAvance: 30 ,contratista: gabriel ,avaluo: 650000.00 ,unidadVerificadora: verificadora 2 ,fechaVencimiento: 2018-07-15 ,fechaDtu: 2018-01-15 ,statusAlertDTU: 1 ,lineaCredito: 1 ,statusVenta: 0 ,status: 1 ,created: 2018-01-15 13:26:48 ,updated: 2018-01-15 13:26:48 ,created_by: 1 ,updated_by: 1  | Los nuevos son: statusVenta:1,updated:2018-01-15 13:35:15,updated_by:1',1,'2018-01-15 13:35:15','2018-01-15 13:35:15',0,1),

(17,'Se actualizó el registro: 1 de la tabla: alta_venta','2','Se actualizó el registro: 1 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-15 13:36:42Los datos anteriores eran: id: 1 ,idFraccionamiento: 0 ,idProyecto: 2 ,idProspecto: 2 ,idNotaria:  ,descripcion:  ,monto: 200000.00 ,subCuenta: 80000.00 ,gastosOperacion: 20000.00 ,total: 260000.00 ,fechaPreca: 2018-01-15 ,revisionMontos:  ,motivo:  ,tipoCredito:  ,diferencia:  ,bonoEquipamiento:  ,pdf_1: 1_1.pdf ,statusPdf_1: 0 ,pdf_2: 1_2.pdf ,statusPdf_2: 0 ,pdf_3: 1_3.pdf ,statusPdf_3: 0 ,pdf_4: 1_4.pdf ,statusPdf_4: 0 ,pdf_5: 1_5.pdf ,statusPdf_5: 0 ,pdf_6: 1_6.pdf ,statusPdf_6: 0 ,pdf_7: 1_7.pdf ,statusPdf_7: 0 ,statusValidacion: 0 ,statusEncuesta: 0 ,status: 1 ,created: 2018-01-15 13:35:14 ,updated: 2018-01-15 13:35:14 ,created_by: 14 ,updated_by: 14  | Los nuevos son: revisionMontos:procede,motivo:,tipoCredito:infonavit puro,diferencia:150000,bonoEquipamiento:70000,idNotaria:1,statusPdf_1:1,statusPdf_2:1,statusPdf_3:1,statusPdf_4:1,statusPdf_5:1,statusPdf_6:1,statusPdf_7:1,statusValidacion:2,updated:2018-01-15 13:36:42,updated_by:1',1,'2018-01-15 13:36:42','2018-01-15 13:36:42',0,1),

(18,'Se insertó el registro: 1 de la tabla: gestoria','1','Se insertó el registro: 1 de la tabla: gestoria por el usuario: 1 (admin) el 2018-01-15 15:12:36',1,'2018-01-15 15:12:37','2018-01-15 15:12:37',1,1),

(19,'Se actualizó el registro: 1 de la tabla: alta_venta','2','Se actualizó el registro: 1 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-15 15:12:37Los datos anteriores eran: id: 1 ,idFraccionamiento: 0 ,idProyecto: 2 ,idProspecto: 2 ,idNotaria: 1 ,descripcion:  ,monto: 200000.00 ,subCuenta: 80000.00 ,gastosOperacion: 20000.00 ,total: 260000.00 ,fechaPreca: 2018-01-15 ,revisionMontos: procede ,motivo:  ,tipoCredito: infonavit puro ,diferencia: 150000.00 ,bonoEquipamiento: 70000.00 ,pdf_1: 1_1.pdf ,statusPdf_1: 1 ,pdf_2: 1_2.pdf ,statusPdf_2: 1 ,pdf_3: 1_3.pdf ,statusPdf_3: 1 ,pdf_4: 1_4.pdf ,statusPdf_4: 1 ,pdf_5: 1_5.pdf ,statusPdf_5: 1 ,pdf_6: 1_6.pdf ,statusPdf_6: 1 ,pdf_7: 1_7.pdf ,statusPdf_7: 1 ,statusValidacion: 2 ,statusEncuesta: 0 ,status: 1 ,created: 2018-01-15 13:35:14 ,updated: 2018-01-15 13:36:42 ,created_by: 14 ,updated_by: 1  | Los nuevos son: statusValidacion:4,updated:2018-01-15 15:12:37,updated_by:1',1,'2018-01-15 15:12:37','2018-01-15 15:12:37',0,1),

(20,'Se actualizó el registro: 2 de la tabla: proyectos','2','Se actualizó el registro: 2 de la tabla: proyectos por el usuario: 1 (admin) el 2018-01-15 15:12:37Los datos anteriores eran: id: 2 ,idFraccionamiento: 1 ,idPrototipo: 1 ,numPaquete: 2 ,lote: 2 ,manzana: 1 ,calle: 17 ,nOficial: 2 ,cuv: 2 ,claveCatastral: 2 ,supTerreno: 200.00 ,supConstruccion: 250.00 ,precioVenta: 500000.00 ,statusProyecto: dtu ,puntaje: 50.00 ,porcentajeAvance: 30 ,contratista: gabriel ,avaluo: 650000.00 ,unidadVerificadora: verificadora 2 ,fechaVencimiento: 2018-07-15 ,fechaDtu: 2018-01-15 ,statusAlertDTU: 1 ,lineaCredito: 1 ,statusVenta: 1 ,status: 1 ,created: 2018-01-15 13:26:48 ,updated: 2018-01-15 13:35:15 ,created_by: 1 ,updated_by: 1  | Los nuevos son: statusVenta:3,updated:2018-01-15 15:12:37,updated_by:1',1,'2018-01-15 15:12:37','2018-01-15 15:12:37',0,1),

(21,'Se insertó el registro: 2 de la tabla: alta_venta','1','Se insertó el registro: 2 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-15 15:25:05',1,'2018-01-15 15:25:05','2018-01-15 15:25:05',1,1),

(22,'Se actualizó el registro: 4 de la tabla: prospectos','2','Se actualizó el registro: 4 de la tabla: prospectos por el usuario: 1 (admin) el 2018-01-15 15:25:06Los datos anteriores eran: id: 4 ,idPromotor: 6 ,idFraccionamiento: 1 ,nombre: Miguel ,apellidoP: Avila ,apellidoM:  ,rfc:  ,telefono:  ,fecha: 2018-01-15 ,fechaNac: 2018-01-15 ,lugarProspeccion: of periferico ,otroLugar:  ,nss: 44444444444 ,statusProspecto: interesado ,comentario:  ,prototipo: 4 ,status: 1 ,created: 2018-01-15 13:32:48 ,updated: 2018-01-15 13:32:48 ,created_by: 1 ,updated_by: 1  | Los nuevos son: nombre:Miguel,apellidoP:Avila,apellidoM:,rfc:,telefono:,fecha:2018-01-15,fechaNac:2018-01-15,statusProspecto:interesado,updated:2018-01-15 15:25:06,updated_by:1',1,'2018-01-15 15:25:06','2018-01-15 15:25:06',0,1),

(23,'Se actualizó el registro: 3 de la tabla: proyectos','2','Se actualizó el registro: 3 de la tabla: proyectos por el usuario: 1 (admin) el 2018-01-15 15:25:06Los datos anteriores eran: id: 3 ,idFraccionamiento: 1 ,idPrototipo: 1 ,numPaquete: 3 ,lote: 3 ,manzana: 3 ,calle: 17 ,nOficial: 3 ,cuv: 3 ,claveCatastral: 3 ,supTerreno: 200.00 ,supConstruccion: 250.00 ,precioVenta: 520000.00 ,statusProyecto: dtu ,puntaje: 50.00 ,porcentajeAvance: 30 ,contratista: gabriel ,avaluo: 700000.00 ,unidadVerificadora: verificadora 2 ,fechaVencimiento: 2018-07-15 ,fechaDtu: 2018-01-15 ,statusAlertDTU: 1 ,lineaCredito: 1 ,statusVenta: 0 ,status: 1 ,created: 2018-01-15 13:27:18 ,updated: 2018-01-15 13:27:18 ,created_by: 1 ,updated_by: 1  | Los nuevos son: statusVenta:1,updated:2018-01-15 15:25:06,updated_by:1',1,'2018-01-15 15:25:06','2018-01-15 15:25:06',0,1),

(24,'Se actualizó el registro: 2 de la tabla: alta_venta','2','Se actualizó el registro: 2 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-15 15:26:07Los datos anteriores eran: id: 2 ,idFraccionamiento: 0 ,idProyecto: 3 ,idProspecto: 4 ,idNotaria:  ,descripcion:  ,monto: 300000.00 ,subCuenta: 100000.00 ,gastosOperacion: 20000.00 ,total: 380000.00 ,fechaPreca: 2018-01-15 ,revisionMontos:  ,motivo:  ,tipoCredito:  ,diferencia:  ,bonoEquipamiento:  ,pdf_1: 2_1.pdf ,statusPdf_1: 0 ,pdf_2: 2_2.pdf ,statusPdf_2: 0 ,pdf_3: 2_3.pdf ,statusPdf_3: 0 ,pdf_4: 2_4.pdf ,statusPdf_4: 0 ,pdf_5: 2_5.pdf ,statusPdf_5: 0 ,pdf_6: 2_6.pdf ,statusPdf_6: 0 ,pdf_7: 2_7.pdf ,statusPdf_7: 0 ,statusValidacion: 0 ,statusEncuesta: 0 ,status: 1 ,created: 2018-01-15 15:25:05 ,updated: 2018-01-15 15:25:05 ,created_by: 6 ,updated_by: 6  | Los nuevos son: revisionMontos:procede,motivo:,tipoCredito:infonavit subsidio,diferencia:150000,bonoEquipamiento:70000,idNotaria:1,statusPdf_1:1,statusPdf_2:1,statusPdf_3:1,statusPdf_4:1,statusPdf_5:1,statusPdf_6:1,statusPdf_7:1,statusValidacion:2,updated:2018-01-15 15:26:07,updated_by:1',1,'2018-01-15 15:26:07','2018-01-15 15:26:07',0,1),

(25,'Se insertó el registro: 2 de la tabla: gestoria','1','Se insertó el registro: 2 de la tabla: gestoria por el usuario: 1 (admin) el 2018-01-15 15:27:35',1,'2018-01-15 15:27:35','2018-01-15 15:27:35',1,1),

(26,'Se actualizó el registro: 2 de la tabla: alta_venta','2','Se actualizó el registro: 2 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-15 15:27:35Los datos anteriores eran: id: 2 ,idFraccionamiento: 0 ,idProyecto: 3 ,idProspecto: 4 ,idNotaria: 1 ,descripcion:  ,monto: 300000.00 ,subCuenta: 100000.00 ,gastosOperacion: 20000.00 ,total: 380000.00 ,fechaPreca: 2018-01-15 ,revisionMontos: procede ,motivo:  ,tipoCredito: infonavit subsidio ,diferencia: 150000.00 ,bonoEquipamiento: 70000.00 ,pdf_1: 2_1.pdf ,statusPdf_1: 1 ,pdf_2: 2_2.pdf ,statusPdf_2: 1 ,pdf_3: 2_3.pdf ,statusPdf_3: 1 ,pdf_4: 2_4.pdf ,statusPdf_4: 1 ,pdf_5: 2_5.pdf ,statusPdf_5: 1 ,pdf_6: 2_6.pdf ,statusPdf_6: 1 ,pdf_7: 2_7.pdf ,statusPdf_7: 1 ,statusValidacion: 2 ,statusEncuesta: 0 ,status: 1 ,created: 2018-01-15 15:25:05 ,updated: 2018-01-15 15:26:07 ,created_by: 6 ,updated_by: 1  | Los nuevos son: statusValidacion:4,updated:2018-01-15 15:27:35,updated_by:1',1,'2018-01-15 15:27:36','2018-01-15 15:27:36',0,1),

(27,'Se actualizó el registro: 3 de la tabla: proyectos','2','Se actualizó el registro: 3 de la tabla: proyectos por el usuario: 1 (admin) el 2018-01-15 15:27:36Los datos anteriores eran: id: 3 ,idFraccionamiento: 1 ,idPrototipo: 1 ,numPaquete: 3 ,lote: 3 ,manzana: 3 ,calle: 17 ,nOficial: 3 ,cuv: 3 ,claveCatastral: 3 ,supTerreno: 200.00 ,supConstruccion: 250.00 ,precioVenta: 520000.00 ,statusProyecto: dtu ,puntaje: 50.00 ,porcentajeAvance: 30 ,contratista: gabriel ,avaluo: 700000.00 ,unidadVerificadora: verificadora 2 ,fechaVencimiento: 2018-07-15 ,fechaDtu: 2018-01-15 ,statusAlertDTU: 1 ,lineaCredito: 1 ,statusVenta: 1 ,status: 1 ,created: 2018-01-15 13:27:18 ,updated: 2018-01-15 15:25:06 ,created_by: 1 ,updated_by: 1  | Los nuevos son: statusVenta:3,updated:2018-01-15 15:27:36,updated_by:1',1,'2018-01-15 15:27:36','2018-01-15 15:27:36',0,1),

(28,'Se insertó el registro: 1 de la tabla: comisiones_bonos','1','Se insertó el registro: 1 de la tabla: comisiones_bonos por el usuario: 1 (admin) el 2018-01-15 17:12:06',1,'2018-01-15 17:12:06','2018-01-15 17:12:06',1,1),

(29,'Se actualizó el registro: 1 de la tabla: alta_venta','2','Se actualizó el registro: 1 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-15 17:12:06Los datos anteriores eran: id: 1 ,idFraccionamiento: 0 ,idProyecto: 2 ,idProspecto: 2 ,idNotaria: 1 ,descripcion:  ,monto: 200000.00 ,subCuenta: 80000.00 ,gastosOperacion: 20000.00 ,total: 260000.00 ,fechaPreca: 2018-01-15 ,revisionMontos: procede ,motivo:  ,tipoCredito: infonavit puro ,diferencia: 150000.00 ,bonoEquipamiento: 70000.00 ,pdf_1: 1_1.pdf ,statusPdf_1: 1 ,pdf_2: 1_2.pdf ,statusPdf_2: 1 ,pdf_3: 1_3.pdf ,statusPdf_3: 1 ,pdf_4: 1_4.pdf ,statusPdf_4: 1 ,pdf_5: 1_5.pdf ,statusPdf_5: 1 ,pdf_6: 1_6.pdf ,statusPdf_6: 1 ,pdf_7: 1_7.pdf ,statusPdf_7: 1 ,statusValidacion: 4 ,statusEncuesta: 0 ,status: 1 ,created: 2018-01-15 13:35:14 ,updated: 2018-01-15 15:12:37 ,created_by: 14 ,updated_by: 1  | Los nuevos son: statusValidacion:5,updated:2018-01-15 17:12:06,updated_by:1',1,'2018-01-15 17:12:06','2018-01-15 17:12:06',0,1),

(30,'Se insertó el registro: 1 de la tabla: depositos','1','Se insertó el registro: 1 de la tabla: depositos por el usuario: 1 (admin) el 2018-01-15 19:18:53',1,'2018-01-15 19:18:53','2018-01-15 19:18:53',1,1),

(31,'Se actualizó el registro: 1 de la tabla: comisiones_bonos','2','Se actualizó el registro: 1 de la tabla: comisiones_bonos por el usuario: 1 (admin) el 2018-01-16 10:24:55Los datos anteriores eran: id: 1 ,idAltaVenta: 1 ,difPropioPeculio: 20000.00 ,resultado: 180000.00 ,saldo: 110000.00 ,cierre: 680000.00 ,importeComision: 20400.00 ,netoVenta: 659600.00 ,status: 1 ,created: 2018-01-15 17:12:06 ,updated: 2018-01-15 17:12:06 ,created_by: 1 ,updated_by: 1  | Los nuevos son: idAltaVenta:1,difPropioPeculio:20000.00,resultado:180000.00,saldo:110000.00,cierre:680000.00,importeComision:20400.00,netoVenta:659600.00,updated:2018-01-16 10:24:55,updated_by:1',1,'2018-01-16 10:24:55','2018-01-16 10:24:55',0,1),

(32,'Se actualizó el registro: 14 de la tabla: usuarios','2','Se actualizó el registro: 14 de la tabla: usuarios por el usuario: 1 (admin) el 2018-01-16 10:24:55Los datos anteriores eran: id: 14 ,rol: 2 ,usuario: promotor1020 ,password: bf019414f607bdf1149c9afd586f972f6e9c1764 ,nombre: Guillermo ,apellidoP: Briceño ,apellidoM:  ,email: promoprueba1111@mail.com ,rfc: 12233gtt ,curp: 1234567 ,calle: 17 ,colonia: Florida ,ciudad: Mérida ,telFijo: 9999999999 ,celular: 9999999999 ,tipoPromotor: Interno ,comision: 3.00 ,fechaIngreso: 2018-01-08 ,status: 1 ,created: 2018-01-08 09:31:08 ,updated: 2018-01-09 12:19:01 ,created_by: 17 ,updated_by: 1  | Los nuevos son: comision:3.00,updated:2018-01-16 10:24:55,updated_by:1',1,'2018-01-16 10:24:55','2018-01-16 10:24:55',0,1),

(33,'Se actualizó el registro: 1 de la tabla: comisiones_bonos','2','Se actualizó el registro: 1 de la tabla: comisiones_bonos por el usuario: 1 (admin) el 2018-01-16 10:25:29Los datos anteriores eran: id: 1 ,idAltaVenta: 1 ,difPropioPeculio: 20000.00 ,resultado: 180000.00 ,saldo: 110000.00 ,cierre: 680000.00 ,importeComision: 20400.00 ,netoVenta: 659600.00 ,status: 1 ,created: 2018-01-15 17:12:06 ,updated: 2018-01-16 10:24:55 ,created_by:  ,updated_by:   | Los nuevos son: idAltaVenta:1,difPropioPeculio:20000.00,resultado:180000.00,saldo:110000.00,cierre:680000.00,importeComision:20400.00,netoVenta:659600.00,updated:2018-01-16 10:25:29,updated_by:1',1,'2018-01-16 10:25:29','2018-01-16 10:25:29',0,1),

(34,'Se actualizó el registro: 14 de la tabla: usuarios','2','Se actualizó el registro: 14 de la tabla: usuarios por el usuario: 1 (admin) el 2018-01-16 10:25:29Los datos anteriores eran: id: 14 ,rol: 2 ,usuario: promotor1020 ,password: bf019414f607bdf1149c9afd586f972f6e9c1764 ,nombre: Guillermo ,apellidoP: Briceño ,apellidoM:  ,email: promoprueba1111@mail.com ,rfc: 12233gtt ,curp: 1234567 ,calle: 17 ,colonia: Florida ,ciudad: Mérida ,telFijo: 9999999999 ,celular: 9999999999 ,tipoPromotor: Interno ,comision: 3.00 ,fechaIngreso: 2018-01-08 ,status: 1 ,created: 2018-01-08 09:31:08 ,updated: 2018-01-16 10:24:55 ,created_by: 17 ,updated_by: 1  | Los nuevos son: comision:3.00,updated:2018-01-16 10:25:29,updated_by:1',1,'2018-01-16 10:25:29','2018-01-16 10:25:29',0,1),

(35,'Se insertó el registro: 2 de la tabla: comisiones_bonos','1','Se insertó el registro: 2 de la tabla: comisiones_bonos por el usuario: 1 (admin) el 2018-01-16 10:31:29',1,'2018-01-16 10:31:29','2018-01-16 10:31:29',1,1),

(36,'Se actualizó el registro: 2 de la tabla: alta_venta','2','Se actualizó el registro: 2 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-16 10:31:29Los datos anteriores eran: id: 2 ,idFraccionamiento: 0 ,idProyecto: 3 ,idProspecto: 4 ,idNotaria: 1 ,descripcion:  ,monto: 300000.00 ,subCuenta: 100000.00 ,gastosOperacion: 20000.00 ,total: 380000.00 ,fechaPreca: 2018-01-15 ,revisionMontos: procede ,motivo:  ,tipoCredito: infonavit subsidio ,diferencia: 150000.00 ,bonoEquipamiento: 70000.00 ,pdf_1: 2_1.pdf ,statusPdf_1: 1 ,pdf_2: 2_2.pdf ,statusPdf_2: 1 ,pdf_3: 2_3.pdf ,statusPdf_3: 1 ,pdf_4: 2_4.pdf ,statusPdf_4: 1 ,pdf_5: 2_5.pdf ,statusPdf_5: 1 ,pdf_6: 2_6.pdf ,statusPdf_6: 1 ,pdf_7: 2_7.pdf ,statusPdf_7: 1 ,statusValidacion: 4 ,statusEncuesta: 0 ,status: 1 ,created: 2018-01-15 15:25:05 ,updated: 2018-01-15 15:27:35 ,created_by: 6 ,updated_by: 1  | Los nuevos son: statusValidacion:5,updated:2018-01-16 10:31:29,updated_by:1',1,'2018-01-16 10:31:29','2018-01-16 10:31:29',0,1),

(37,'Se actualizó el registro: 1 de la tabla: comisiones_bonos','2','Se actualizó el registro: 1 de la tabla: comisiones_bonos por el usuario: 1 (admin) el 2018-01-16 10:32:11Los datos anteriores eran: id: 1 ,idAltaVenta: 1 ,difPropioPeculio: 20000.00 ,resultado: 180000.00 ,saldo: 110000.00 ,cierre: 680000.00 ,importeComision: 20400.00 ,netoVenta: 659600.00 ,status: 1 ,created: 2018-01-15 17:12:06 ,updated: 2018-01-16 10:25:29 ,created_by: 17 ,updated_by: 17  | Los nuevos son: idAltaVenta:1,difPropioPeculio:20000.00,resultado:180000.00,saldo:110000.00,cierre:680000.00,importeComision:20400.00,netoVenta:659600.00,updated:2018-01-16 10:32:11,updated_by:1',1,'2018-01-16 10:32:11','2018-01-16 10:32:11',0,1),

(38,'Se actualizó el registro: 14 de la tabla: usuarios','2','Se actualizó el registro: 14 de la tabla: usuarios por el usuario: 1 (admin) el 2018-01-16 10:32:11Los datos anteriores eran: id: 14 ,rol: 2 ,usuario: promotor1020 ,password: bf019414f607bdf1149c9afd586f972f6e9c1764 ,nombre: Guillermo ,apellidoP: Briceño ,apellidoM:  ,email: promoprueba1111@mail.com ,rfc: 12233gtt ,curp: 1234567 ,calle: 17 ,colonia: Florida ,ciudad: Mérida ,telFijo: 9999999999 ,celular: 9999999999 ,tipoPromotor: Interno ,comision: 3.00 ,fechaIngreso: 2018-01-08 ,status: 1 ,created: 2018-01-08 09:31:08 ,updated: 2018-01-16 10:25:29 ,created_by: 17 ,updated_by: 1  | Los nuevos son: comision:3.00,updated:2018-01-16 10:32:11,updated_by:1',1,'2018-01-16 10:32:11','2018-01-16 10:32:11',0,1),

(39,'Se actualizó el registro: 1 de la tabla: comisiones_bonos','2','Se actualizó el registro: 1 de la tabla: comisiones_bonos por el usuario: 1 (admin) el 2018-01-16 10:32:27Los datos anteriores eran: id: 1 ,idAltaVenta: 1 ,difPropioPeculio: 20000.00 ,resultado: 180000.00 ,saldo: 110000.00 ,cierre: 680000.00 ,importeComision: 20400.00 ,netoVenta: 659600.00 ,status: 1 ,created: 2018-01-15 17:12:06 ,updated: 2018-01-16 10:32:11 ,created_by: 17 ,updated_by: 17  | Los nuevos son: idAltaVenta:1,difPropioPeculio:20000.00,resultado:180000.00,saldo:110000.00,cierre:680000.00,importeComision:20400.00,netoVenta:659600.00,updated:2018-01-16 10:32:27,updated_by:1',1,'2018-01-16 10:32:27','2018-01-16 10:32:27',0,1),

(40,'Se actualizó el registro: 14 de la tabla: usuarios','2','Se actualizó el registro: 14 de la tabla: usuarios por el usuario: 1 (admin) el 2018-01-16 10:32:27Los datos anteriores eran: id: 14 ,rol: 2 ,usuario: promotor1020 ,password: bf019414f607bdf1149c9afd586f972f6e9c1764 ,nombre: Guillermo ,apellidoP: Briceño ,apellidoM:  ,email: promoprueba1111@mail.com ,rfc: 12233gtt ,curp: 1234567 ,calle: 17 ,colonia: Florida ,ciudad: Mérida ,telFijo: 9999999999 ,celular: 9999999999 ,tipoPromotor: Interno ,comision: 3.00 ,fechaIngreso: 2018-01-08 ,status: 1 ,created: 2018-01-08 09:31:08 ,updated: 2018-01-16 10:32:11 ,created_by: 17 ,updated_by: 1  | Los nuevos son: comision:3.00,updated:2018-01-16 10:32:27,updated_by:1',1,'2018-01-16 10:32:27','2018-01-16 10:32:27',0,1),

(41,'Se actualizó el registro: 1 de la tabla: comisiones_bonos','2','Se actualizó el registro: 1 de la tabla: comisiones_bonos por el usuario: 1 (admin) el 2018-01-16 10:33:19Los datos anteriores eran: id: 1 ,idAltaVenta: 1 ,difPropioPeculio: 20000.00 ,resultado: 180000.00 ,saldo: 110000.00 ,cierre: 680000.00 ,importeComision: 20400.00 ,netoVenta: 659600.00 ,status: 1 ,created: 2018-01-15 17:12:06 ,updated: 2018-01-16 10:32:27 ,created_by: 17 ,updated_by: 17  | Los nuevos son: idAltaVenta:1,difPropioPeculio:20000.00,resultado:180000.00,saldo:110000.00,cierre:680000.00,importeComision:20400.00,netoVenta:659600.00,updated:2018-01-16 10:33:19,updated_by:1',1,'2018-01-16 10:33:19','2018-01-16 10:33:19',0,1),

(42,'Se actualizó el registro: 14 de la tabla: usuarios','2','Se actualizó el registro: 14 de la tabla: usuarios por el usuario: 1 (admin) el 2018-01-16 10:33:19Los datos anteriores eran: id: 14 ,rol: 2 ,usuario: promotor1020 ,password: bf019414f607bdf1149c9afd586f972f6e9c1764 ,nombre: Guillermo ,apellidoP: Briceño ,apellidoM:  ,email: promoprueba1111@mail.com ,rfc: 12233gtt ,curp: 1234567 ,calle: 17 ,colonia: Florida ,ciudad: Mérida ,telFijo: 9999999999 ,celular: 9999999999 ,tipoPromotor: Interno ,comision: 3.00 ,fechaIngreso: 2018-01-08 ,status: 1 ,created: 2018-01-08 09:31:08 ,updated: 2018-01-16 10:32:27 ,created_by: 17 ,updated_by: 1  | Los nuevos son: comision:3.00,updated:2018-01-16 10:33:19,updated_by:1',1,'2018-01-16 10:33:19','2018-01-16 10:33:19',0,1),

(43,'Se actualizó el registro: 2 de la tabla: comisiones_bonos','2','Se actualizó el registro: 2 de la tabla: comisiones_bonos por el usuario: 1 (admin) el 2018-01-16 10:36:35Los datos anteriores eran: id: 2 ,idAltaVenta: 2 ,difPropioPeculio: -140000.00 ,resultado: 140000.00 ,saldo: 70000.00 ,cierre: 640000.00 ,importeComision: 19200.00 ,netoVenta: 620800.00 ,status: 1 ,created: 2018-01-16 10:31:29 ,updated: 2018-01-16 10:31:29 ,created_by:  ,updated_by:   | Los nuevos son: idAltaVenta:2,difPropioPeculio:-140000.00,resultado:140000.00,saldo:70000.00,cierre:640000.00,importeComision:19200.00,netoVenta:620800.00,updated:2018-01-16 10:36:35,updated_by:1',1,'2018-01-16 10:36:35','2018-01-16 10:36:35',0,1),

(44,'Se actualizó el registro: 6 de la tabla: usuarios','2','Se actualizó el registro: 6 de la tabla: usuarios por el usuario: 1 (admin) el 2018-01-16 10:36:35Los datos anteriores eran: id: 6 ,rol: 2 ,usuario: promotorA ,password: bf019414f607bdf1149c9afd586f972f6e9c1764 ,nombre: Alvaro ,apellidoP: Briceño ,apellidoM: Rosado ,email: alvaro@navegantes.mx ,rfc: abno123456 ,curp: ab34re4567 ,calle: 17 ,colonia: Florida ,ciudad: Mérida ,telFijo: 9999999999 ,celular: 9999999999 ,tipoPromotor: Interno ,comision: 3.00 ,fechaIngreso: 2017-12-18 ,status: 1 ,created: 2017-12-19 12:01:29 ,updated: 2017-12-19 12:01:29 ,created_by: 17 ,updated_by: 17  | Los nuevos son: comision:3.00,updated:2018-01-16 10:36:35,updated_by:1',1,'2018-01-16 10:36:35','2018-01-16 10:36:35',0,1),

(45,'Se insertó el registro: 18 de la tabla: usuarios','1','Se insertó el registro: 18 de la tabla: usuarios por el usuario: 1 (admin) el 2018-01-16 10:38:06',1,'2018-01-16 10:38:06','2018-01-16 10:38:06',1,1),

(46,'Se insertó el registro: 19 de la tabla: usuarios','1','Se insertó el registro: 19 de la tabla: usuarios por el usuario: 18 (gte3) el 2018-01-16 10:40:18',1,'2018-01-16 10:40:18','2018-01-16 10:40:18',18,18),

(47,'Se actualizó el registro: 19 de la tabla: usuarios','2','Se actualizó el registro: 19 de la tabla: usuarios por el usuario: 1 (admin) el 2018-01-16 10:52:04Los datos anteriores eran: id: 19 ,rol: 2 ,usuario: promotor1021 ,password: bf019414f607bdf1149c9afd586f972f6e9c1764 ,nombre: Ruth ,apellidoP: Loyola ,apellidoM:  ,email: promotor1021@mail.com ,rfc:  ,curp:  ,calle:  ,colonia:  ,ciudad:  ,telFijo:  ,celular:  ,tipoPromotor: Interno ,comision: 3.00 ,fechaIngreso: 2018-01-16 ,status: 1 ,created: 2018-01-16 10:40:18 ,updated: 2018-01-16 10:40:18 ,created_by: 18 ,updated_by: 18  | Los nuevos son: rol:2,nombre:Ruth,apellidoP:Loyola,apellidoM:,email:promotor1021@mail.com,rfc:,curp:,calle:,colonia:,ciudad:,telFijo:,celular:,tipoPromotor:Interno,comision:3.00,fechaIngreso:2018-01-16,status:1,updated:2018-01-16 10:52:04,updated_by:1',1,'2018-01-16 10:52:04','2018-01-16 10:52:04',0,1),

(48,'Se insertó el registro: 5 de la tabla: prospectos','1','Se insertó el registro: 5 de la tabla: prospectos por el usuario: 1 (admin) el 2018-01-16 10:58:31',1,'2018-01-16 10:58:31','2018-01-16 10:58:31',1,1),

(49,'Se insertó el registro: 3 de la tabla: alta_venta','1','Se insertó el registro: 3 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-16 11:01:44',1,'2018-01-16 11:01:44','2018-01-16 11:01:44',1,1),

(50,'Se actualizó el registro: 5 de la tabla: prospectos','2','Se actualizó el registro: 5 de la tabla: prospectos por el usuario: 1 (admin) el 2018-01-16 11:01:44Los datos anteriores eran: id: 5 ,idPromotor: 19 ,idFraccionamiento: 1 ,nombre: Gladis ,apellidoP: Tec ,apellidoM:  ,rfc:  ,telefono:  ,fecha: 2018-01-16 ,fechaNac: 2018-01-16 ,lugarProspeccion: camion ,otroLugar:  ,nss: 55555555555 ,statusProspecto: interesado ,comentario:  ,prototipo: 4 ,status: 1 ,created: 2018-01-16 10:58:31 ,updated: 2018-01-16 10:58:31 ,created_by: 1 ,updated_by: 1  | Los nuevos son: nombre:Gladis,apellidoP:Tec,apellidoM:,rfc:,telefono:,fecha:2018-01-16,fechaNac:2018-01-16,statusProspecto:interesado,updated:2018-01-16 11:01:44,updated_by:1',1,'2018-01-16 11:01:44','2018-01-16 11:01:44',0,1),

(51,'Se actualizó el registro: 1 de la tabla: proyectos','2','Se actualizó el registro: 1 de la tabla: proyectos por el usuario: 1 (admin) el 2018-01-16 11:01:44Los datos anteriores eran: id: 1 ,idFraccionamiento: 1 ,idPrototipo: 1 ,numPaquete:  ,lote: 1 ,manzana: 1 ,calle: 17 ,nOficial: 234345 ,cuv: 234 ,claveCatastral: 54323 ,supTerreno: 200.00 ,supConstruccion: 250.00 ,precioVenta: 400000.00 ,statusProyecto: dtu ,puntaje: 50.00 ,porcentajeAvance: 30 ,contratista: gabriel ,avaluo: 600000.00 ,unidadVerificadora: verificadora 1 ,fechaVencimiento: 2018-07-15 ,fechaDtu: 2018-01-15 ,statusAlertDTU: 1 ,lineaCredito: 1 ,statusVenta: 0 ,status: 1 ,created: 2018-01-15 13:25:57 ,updated: 2018-01-15 13:25:57 ,created_by: 1 ,updated_by: 1  | Los nuevos son: statusVenta:1,updated:2018-01-16 11:01:44,updated_by:1',1,'2018-01-16 11:01:44','2018-01-16 11:01:44',0,1),

(52,'Se actualizó el registro: 3 de la tabla: alta_venta','2','Se actualizó el registro: 3 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-16 11:02:25Los datos anteriores eran: id: 3 ,idFraccionamiento: 0 ,idProyecto: 1 ,idProspecto: 5 ,idNotaria:  ,descripcion:  ,monto: 470000.00 ,subCuenta: 200000.00 ,gastosOperacion: 20000.00 ,total: 650000.00 ,fechaPreca: 2018-01-16 ,revisionMontos:  ,motivo:  ,tipoCredito:  ,diferencia:  ,bonoEquipamiento:  ,pdf_1: 3_1.pdf ,statusPdf_1: 0 ,pdf_2: 3_2.pdf ,statusPdf_2: 0 ,pdf_3: 3_3.pdf ,statusPdf_3: 0 ,pdf_4: 3_4.pdf ,statusPdf_4: 0 ,pdf_5: 3_5.pdf ,statusPdf_5: 0 ,pdf_6: 3_6.pdf ,statusPdf_6: 0 ,pdf_7: 3_7.pdf ,statusPdf_7: 0 ,statusValidacion: 0 ,statusEncuesta: 0 ,status: 1 ,created: 2018-01-16 11:01:44 ,updated: 2018-01-16 11:01:44 ,created_by: 19 ,updated_by: 19  | Los nuevos son: revisionMontos:procede,motivo:,tipoCredito:foviste,diferencia:300000,bonoEquipamiento:100000,idNotaria:1,statusPdf_1:1,statusPdf_2:1,statusPdf_3:1,statusPdf_4:1,statusPdf_5:1,statusPdf_6:1,statusPdf_7:1,statusValidacion:2,updated:2018-01-16 11:02:25,updated_by:1',1,'2018-01-16 11:02:25','2018-01-16 11:02:25',0,1),

(53,'Se insertó el registro: 3 de la tabla: gestoria','1','Se insertó el registro: 3 de la tabla: gestoria por el usuario: 1 (admin) el 2018-01-16 11:04:31',1,'2018-01-16 11:04:31','2018-01-16 11:04:31',1,1),

(54,'Se actualizó el registro: 3 de la tabla: alta_venta','2','Se actualizó el registro: 3 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-16 11:04:31Los datos anteriores eran: id: 3 ,idFraccionamiento: 0 ,idProyecto: 1 ,idProspecto: 5 ,idNotaria: 1 ,descripcion:  ,monto: 470000.00 ,subCuenta: 200000.00 ,gastosOperacion: 20000.00 ,total: 650000.00 ,fechaPreca: 2018-01-16 ,revisionMontos: procede ,motivo:  ,tipoCredito: foviste ,diferencia: 300000.00 ,bonoEquipamiento: 100000.00 ,pdf_1: 3_1.pdf ,statusPdf_1: 1 ,pdf_2: 3_2.pdf ,statusPdf_2: 1 ,pdf_3: 3_3.pdf ,statusPdf_3: 1 ,pdf_4: 3_4.pdf ,statusPdf_4: 1 ,pdf_5: 3_5.pdf ,statusPdf_5: 1 ,pdf_6: 3_6.pdf ,statusPdf_6: 1 ,pdf_7: 3_7.pdf ,statusPdf_7: 1 ,statusValidacion: 2 ,statusEncuesta: 0 ,status: 1 ,created: 2018-01-16 11:01:44 ,updated: 2018-01-16 11:02:25 ,created_by: 19 ,updated_by: 1  | Los nuevos son: statusValidacion:4,updated:2018-01-16 11:04:31,updated_by:1',1,'2018-01-16 11:04:31','2018-01-16 11:04:31',0,1),

(55,'Se actualizó el registro: 1 de la tabla: proyectos','2','Se actualizó el registro: 1 de la tabla: proyectos por el usuario: 1 (admin) el 2018-01-16 11:04:31Los datos anteriores eran: id: 1 ,idFraccionamiento: 1 ,idPrototipo: 1 ,numPaquete:  ,lote: 1 ,manzana: 1 ,calle: 17 ,nOficial: 234345 ,cuv: 234 ,claveCatastral: 54323 ,supTerreno: 200.00 ,supConstruccion: 250.00 ,precioVenta: 400000.00 ,statusProyecto: dtu ,puntaje: 50.00 ,porcentajeAvance: 30 ,contratista: gabriel ,avaluo: 600000.00 ,unidadVerificadora: verificadora 1 ,fechaVencimiento: 2018-07-15 ,fechaDtu: 2018-01-15 ,statusAlertDTU: 1 ,lineaCredito: 1 ,statusVenta: 1 ,status: 1 ,created: 2018-01-15 13:25:57 ,updated: 2018-01-16 11:01:44 ,created_by: 1 ,updated_by: 1  | Los nuevos son: statusVenta:3,updated:2018-01-16 11:04:31,updated_by:1',1,'2018-01-16 11:04:31','2018-01-16 11:04:31',0,1),

(56,'Se insertó el registro: 3 de la tabla: comisiones_bonos','1','Se insertó el registro: 3 de la tabla: comisiones_bonos por el usuario: 1 (admin) el 2018-01-16 11:05:21',1,'2018-01-16 11:05:21','2018-01-16 11:05:21',1,1),

(57,'Se actualizó el registro: 3 de la tabla: alta_venta','2','Se actualizó el registro: 3 de la tabla: alta_venta por el usuario: 1 (admin) el 2018-01-16 11:05:21Los datos anteriores eran: id: 3 ,idFraccionamiento: 0 ,idProyecto: 1 ,idProspecto: 5 ,idNotaria: 1 ,descripcion:  ,monto: 470000.00 ,subCuenta: 200000.00 ,gastosOperacion: 20000.00 ,total: 650000.00 ,fechaPreca: 2018-01-16 ,revisionMontos: procede ,motivo:  ,tipoCredito: foviste ,diferencia: 300000.00 ,bonoEquipamiento: 100000.00 ,pdf_1: 3_1.pdf ,statusPdf_1: 1 ,pdf_2: 3_2.pdf ,statusPdf_2: 1 ,pdf_3: 3_3.pdf ,statusPdf_3: 1 ,pdf_4: 3_4.pdf ,statusPdf_4: 1 ,pdf_5: 3_5.pdf ,statusPdf_5: 1 ,pdf_6: 3_6.pdf ,statusPdf_6: 1 ,pdf_7: 3_7.pdf ,statusPdf_7: 1 ,statusValidacion: 4 ,statusEncuesta: 0 ,status: 1 ,created: 2018-01-16 11:01:44 ,updated: 2018-01-16 11:04:31 ,created_by: 19 ,updated_by: 1  | Los nuevos son: statusValidacion:5,updated:2018-01-16 11:05:21,updated_by:1',1,'2018-01-16 11:05:21','2018-01-16 11:05:21',0,1);

/*Table structure for table `notarias` */

DROP TABLE IF EXISTS `notarias`;

CREATE TABLE `notarias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(150) CHARACTER SET utf8 DEFAULT NULL,
  `telefono` varchar(20) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `email` varchar(80) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `notarias` */

insert  into `notarias`(`id`,`nombre`,`telefono`,`email`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,'Notaría 1','9999999999','notaria1@mail.com',1,'2017-11-10 10:38:03','2017-11-10 10:38:03',1,1);

/*Table structure for table `postventa` */

DROP TABLE IF EXISTS `postventa`;

CREATE TABLE `postventa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `instElectricas` date DEFAULT NULL,
  `instHidraulicas` date DEFAULT NULL,
  `instSanitarias` date DEFAULT NULL,
  `instGas` date DEFAULT NULL,
  `canceleria` varchar(45) COLLATE utf8_spanish2_ci DEFAULT 'NA',
  `impermeabilizacion` date DEFAULT NULL,
  `acabados` date DEFAULT NULL,
  `estructural` date DEFAULT NULL,
  `accesorios` date DEFAULT NULL,
  `calentadorAgua` date DEFAULT NULL,
  `pdf_14` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'input para carga conformidad',
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `postventa_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `postventa_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `postventa` */

/*Table structure for table `prospectos` */

DROP TABLE IF EXISTS `prospectos`;

CREATE TABLE `prospectos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idPromotor` int(11) DEFAULT NULL,
  `idFraccionamiento` int(11) NOT NULL,
  `nombre` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `apellidoP` varchar(80) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `apellidoM` varchar(80) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `rfc` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `telefono` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `fechaNac` date DEFAULT NULL,
  `lugarProspeccion` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `otroLugar` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `nss` varchar(100) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `statusProspecto` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `comentario` text COLLATE utf8_spanish2_ci,
  `prototipo` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `prospectos_ibfk_1` (`idPromotor`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `prospectos` */

insert  into `prospectos`(`id`,`idPromotor`,`idFraccionamiento`,`nombre`,`apellidoP`,`apellidoM`,`rfc`,`telefono`,`fecha`,`fechaNac`,`lugarProspeccion`,`otroLugar`,`nss`,`statusProspecto`,`comentario`,`prototipo`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,14,1,'Denis','Zambrano','','','','2018-01-15','2018-01-15','casa muestra','','11111111111','interesado','','1',1,'2018-01-15 13:29:18','2018-01-15 13:29:18',1,1),

(2,14,1,'Javier','Guti','','','','2018-01-15','2018-01-15','casa muestra','','22222222222','interesado','','2',1,'2018-01-15 13:30:05','2018-01-15 13:35:15',1,1),

(3,14,1,'Sofia','Mex','','','','2018-01-15','2018-01-15','casa muestra','','33333333333','interesado','','3',1,'2018-01-15 13:30:50','2018-01-15 13:30:50',1,1),

(4,6,1,'Miguel','Avila','','','','2018-01-15','2018-01-15','of periferico','','44444444444','interesado','','4',1,'2018-01-15 13:32:48','2018-01-15 15:25:06',1,1),

(5,19,1,'Gladis','Tec','','','','2018-01-16','2018-01-16','camion','','55555555555','interesado','','4',1,'2018-01-16 10:58:31','2018-01-16 11:01:44',1,1);

/*Table structure for table `prototiposxfraccionamiento` */

DROP TABLE IF EXISTS `prototiposxfraccionamiento`;

CREATE TABLE `prototiposxfraccionamiento` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(50) DEFAULT NULL,
  `titulo` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fraccionamientosxusuarios_ibfk_1` (`idFraccionamiento`),
  KEY `fraccionamientosxusuarios_ibfk_2` (`titulo`),
  CONSTRAINT `prototiposxfraccionamiento_ibfk_1` FOREIGN KEY (`idFraccionamiento`) REFERENCES `fraccionamientos` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `prototiposxfraccionamiento` */

insert  into `prototiposxfraccionamiento`(`id`,`idFraccionamiento`,`titulo`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,1,'p1',1,NULL,NULL,NULL,NULL);

/*Table structure for table `proyectos` */

DROP TABLE IF EXISTS `proyectos`;

CREATE TABLE `proyectos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(11) DEFAULT NULL,
  `idPrototipo` int(11) DEFAULT NULL,
  `numPaquete` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `lote` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `manzana` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `calle` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `nOficial` varchar(25) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `cuv` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `claveCatastral` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `supTerreno` decimal(8,2) DEFAULT NULL,
  `supConstruccion` decimal(8,2) DEFAULT NULL,
  `precioVenta` decimal(12,2) DEFAULT NULL,
  `statusProyecto` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `puntaje` decimal(6,2) DEFAULT NULL,
  `porcentajeAvance` int(6) DEFAULT NULL,
  `contratista` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `avaluo` decimal(12,2) DEFAULT NULL,
  `unidadVerificadora` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fechaVencimiento` date DEFAULT NULL,
  `fechaDtu` date DEFAULT NULL,
  `statusAlertDTU` tinyint(1) NOT NULL COMMENT '0 es alerta no enviada, 1 es alerta enviada',
  `lineaCredito` varchar(11) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `statusVenta` tinyint(1) NOT NULL COMMENT '0 se encuentre disponible, 1 se encuentra apartada, 2 se encuentra en proceso de venta, 3 se encuentra vendida',
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proyectos_ibfk_1` (`idFraccionamiento`),
  CONSTRAINT `proyectos_ibfk_1` FOREIGN KEY (`idFraccionamiento`) REFERENCES `fraccionamientos` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `proyectos` */

insert  into `proyectos`(`id`,`idFraccionamiento`,`idPrototipo`,`numPaquete`,`lote`,`manzana`,`calle`,`nOficial`,`cuv`,`claveCatastral`,`supTerreno`,`supConstruccion`,`precioVenta`,`statusProyecto`,`puntaje`,`porcentajeAvance`,`contratista`,`avaluo`,`unidadVerificadora`,`fechaVencimiento`,`fechaDtu`,`statusAlertDTU`,`lineaCredito`,`statusVenta`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,1,1,'','1','1','17','234345','234','54323','200.00','250.00','400000.00','dtu','50.00',30,'gabriel','600000.00','verificadora 1','2018-07-15','2018-01-15',1,'1',3,1,'2018-01-15 13:25:57','2018-01-16 11:04:31',1,1),

(2,1,1,'2','2','1','17','2','2','2','200.00','250.00','500000.00','dtu','50.00',30,'gabriel','650000.00','verificadora 2','2018-07-15','2018-01-15',1,'1',3,1,'2018-01-15 13:26:48','2018-01-15 15:12:37',1,1),

(3,1,1,'3','3','3','17','3','3','3','200.00','250.00','520000.00','dtu','50.00',30,'gabriel','700000.00','verificadora 2','2018-07-15','2018-01-15',1,'1',3,1,'2018-01-15 13:27:18','2018-01-15 15:27:36',1,1);

/*Table structure for table `roles` */

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `roles` */

insert  into `roles`(`id`,`nombre`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,'admin',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(2,'Promotor',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(3,'Gestor',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(4,'Gte Ventas',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(5,'Técnica',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(6,'Postventa',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(7,'Contabilidad',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1);

/*Table structure for table `usuarios` */

DROP TABLE IF EXISTS `usuarios`;

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rol` int(11) DEFAULT '1',
  `usuario` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `password` varchar(100) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `nombre` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `apellidoP` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `apellidoM` varchar(45) COLLATE utf8_spanish2_ci NOT NULL,
  `email` varchar(80) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `rfc` varchar(45) COLLATE utf8_spanish2_ci NOT NULL,
  `curp` varchar(45) COLLATE utf8_spanish2_ci NOT NULL,
  `calle` varchar(100) COLLATE utf8_spanish2_ci NOT NULL,
  `colonia` varchar(45) COLLATE utf8_spanish2_ci NOT NULL,
  `ciudad` varchar(45) COLLATE utf8_spanish2_ci NOT NULL,
  `telFijo` varchar(20) COLLATE utf8_spanish2_ci NOT NULL,
  `celular` varchar(20) COLLATE utf8_spanish2_ci NOT NULL,
  `tipoPromotor` varchar(45) COLLATE utf8_spanish2_ci NOT NULL COMMENT 'Interno o Externo',
  `comision` decimal(5,2) NOT NULL COMMENT 'Comisión de promotor',
  `fechaIngreso` date DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `usuarios` */

insert  into `usuarios`(`id`,`rol`,`usuario`,`password`,`nombre`,`apellidoP`,`apellidoM`,`email`,`rfc`,`curp`,`calle`,`colonia`,`ciudad`,`telFijo`,`celular`,`tipoPromotor`,`comision`,`fechaIngreso`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,1,'admin','bf019414f607bdf1149c9afd586f972f6e9c1764','administrador','','','emmanuel@navegantes.mx','','','','','','','','0','0.00',NULL,1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(3,4,'gte1','bf019414f607bdf1149c9afd586f972f6e9c1764','Gerente de Ventas 1','','','gte1@mail.com','','','','','','','','0','0.00',NULL,1,'2017-10-04 17:19:49','2017-10-04 17:19:49',1,2),

(5,2,'promotorM','bf019414f607bdf1149c9afd586f972f6e9c1764','Carlos','Lopez','Vallarta','prommerida@mail.com','','','','','','9992344748','','Interno','3.00','2017-10-12',1,'2017-11-17 18:59:32','2017-11-17 18:59:32',3,3),

(6,2,'promotorA','bf019414f607bdf1149c9afd586f972f6e9c1764','Alvaro','Briceño','Rosado','alvaro@navegantes.mx','abno123456','ab34re4567','17','Florida','Mérida','9999999999','9999999999','Interno','3.00','2017-12-18',1,'2017-12-19 12:01:29','2018-01-16 10:36:35',17,1),

(7,3,'gestor','bf019414f607bdf1149c9afd586f972f6e9c1764','Gerardo','Gallardo','Lopez','gestor@mail.com','g3434562tlp','gglpz85412563','27','pINOS','mÉRIDA','9999999999','9999999999','','0.00','2017-12-20',1,'2017-12-20 13:08:40','2017-12-20 13:08:40',1,1),

(8,5,'tecnica','bf019414f607bdf1149c9afd586f972f6e9c1764','emmanuel','avilés','','aviles1189@gmail.com','34rttt','rtyyg','27','','merida','9999999999','9999999999','','0.00','2017-12-27',1,'2017-12-27 12:41:54','2017-12-27 12:41:54',1,1),

(9,2,'promotor','bf019414f607bdf1149c9afd586f972f6e9c1764','promotor prueba','apellidop prueba','apellidoM prueba','promoprueba@mail.com','12345566','rgp23444','17','Florida','Mérida','9999999999','9999999999','Interno','3.00','2018-01-03',1,'2018-01-05 12:25:51','2018-01-05 12:25:51',3,3),

(10,2,'promotor','bf019414f607bdf1149c9afd586f972f6e9c1764','ruben','montado','sambrano','promotorprueb2@mail.com','123456','rsm124','17','florida','merida','9999999999','9999999999','Interno','3.00','2018-01-05',1,'2018-01-05 12:39:34','2018-01-05 12:39:34',3,3),

(12,2,'promotor18','bf019414f607bdf1149c9afd586f972f6e9c1764','promotor18:12','apellidop18:12','apellidom18:12','promotorp2@mail.com','1234','rfgtr5666','17','Florida','Mérida','9999999999','9999999999','Interno','3.00','2018-01-05',1,'2018-01-05 18:13:20','2018-01-05 18:13:20',3,3),

(13,2,'promotor','7c4a8d09ca3762af61e59520943dc26494f8941b','aaaa','aaaaa','','emmanuewwwl@navegantes.mx','','','','','','','','','0.00','2018-01-05',1,'2018-01-05 19:06:20','2018-01-05 19:06:20',1,1),

(14,2,'promotor1020','bf019414f607bdf1149c9afd586f972f6e9c1764','Guillermo','Briceño','','promoprueba1111@mail.com','12233gtt','1234567','17','Florida','Mérida','9999999999','9999999999','Interno','3.00','2018-01-08',1,'2018-01-08 09:31:08','2018-01-16 10:33:19',17,1),

(16,6,'postventa','bf019414f607bdf1149c9afd586f972f6e9c1764','postventa','Briceño','','postventa@mail.com','1234rtt','54tygg','17','florida','merida','9999999999','9999999999','','0.00','2018-01-08',1,'2018-01-08 10:49:39','2018-01-08 10:49:39',1,1),

(17,4,'gte2','bf019414f607bdf1149c9afd586f972f6e9c1764','Gerente de Ventas 2','','','gte1@mail.com','','','','','','','','0','0.00',NULL,1,'2017-10-04 17:19:49','2017-10-04 17:19:49',1,2),

(18,4,'gte3','bf019414f607bdf1149c9afd586f972f6e9c1764','Raul','Galindo','','gte3@mail.com','','','','','','','','','0.00','2018-01-16',1,'2018-01-16 10:38:06','2018-01-16 10:38:06',1,1),

(19,2,'promotor1021','bf019414f607bdf1149c9afd586f972f6e9c1764','Ruth','Loyola','','promotor1021@mail.com','','','','','','','','Interno','3.00','2018-01-16',1,'2018-01-16 10:40:18','2018-01-16 10:52:04',18,1);

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
