/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`viviend` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `viviend`;

/*Table structure for table `alta_venta` */

DROP TABLE IF EXISTS `alta_venta`;

CREATE TABLE `alta_venta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(11) NOT NULL,
  `idProyecto` int(11) DEFAULT NULL,
  `idProspecto` int(11) DEFAULT NULL,
  `idNotaria` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8_spanish2_ci,
  `monto` decimal(12,2) DEFAULT NULL,
  `subCuenta` decimal(12,2) DEFAULT NULL,
  `gastosOperacion` decimal(12,2) DEFAULT NULL,
  `total` decimal(12,2) DEFAULT NULL,
  `fechaPreca` date DEFAULT NULL,
  `revisionMontos` varchar(30) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'Inician campos validacion venta',
  `motivo` text COLLATE utf8_spanish2_ci,
  `tipoCredito` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `diferencia` decimal(12,2) DEFAULT NULL,
  `bonoEquipamiento` decimal(12,2) DEFAULT NULL,
  `pdf_1` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'acta',
  `statusPdf_1` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_2` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'ife',
  `statusPdf_2` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_3` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'curp',
  `statusPdf_3` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_4` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'bansefi',
  `statusPdf_4` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_5` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'preCalificacion',
  `statusPdf_5` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_6` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'curso',
  `statusPdf_6` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `pdf_7` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'SolicitudCredito',
  `statusPdf_7` tinyint(1) DEFAULT '0' COMMENT '1 indica que esta validado',
  `statusValidacion` tinyint(1) DEFAULT '0' COMMENT '0 indica que esta en etapa alta de venta, 1 indica que esta en etapa validacion de venta, 2 indica que ya esta validado, 3 indica que está en alta gestoría, 4 que está disponible para agregar comision/bono a promotor, 5 indica que ya se ha agregado una comisión al promotor',
  `statusEncuesta` tinyint(1) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `alta_venta_ibfk_1` (`idProyecto`),
  KEY `alta_venta_ibfk_2` (`idProspecto`),
  KEY `alta_venta_ibfk_3` (`idNotaria`),
  CONSTRAINT `alta_venta_ibfk_1` FOREIGN KEY (`idProyecto`) REFERENCES `proyectos` (`id`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `alta_venta_ibfk_2` FOREIGN KEY (`idProspecto`) REFERENCES `prospectos` (`id`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `alta_venta_ibfk_3` FOREIGN KEY (`idNotaria`) REFERENCES `notarias` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `alta_venta` */

/*Table structure for table `autorizaciones` */

DROP TABLE IF EXISTS `autorizaciones`;

CREATE TABLE `autorizaciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `montoTotal` decimal(12,2) DEFAULT NULL,
  `difPropPeculio` decimal(12,2) DEFAULT NULL,
  `resultado` decimal(12,2) DEFAULT NULL,
  `propVenta` decimal(12,2) DEFAULT NULL,
  `statusAutorizacion` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `autorizaciones_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `autorizaciones_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `autorizaciones` */

/*Table structure for table `blackboard` */

DROP TABLE IF EXISTS `blackboard`;

CREATE TABLE `blackboard` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(11) NOT NULL,
  `asunto` varchar(45) NOT NULL,
  `proyecto` varchar(45) NOT NULL,
  `delegado` varchar(45) NOT NULL,
  `mail` varchar(45) NOT NULL,
  `fechaInicio` date NOT NULL,
  `fechaTermino` date NOT NULL,
  `checked` tinyint(1) NOT NULL,
  `statusAlert` tinyint(5) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(5) NOT NULL,
  `updated_by` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `blackboard` */

/*Table structure for table `comisiones_bonos` */

DROP TABLE IF EXISTS `comisiones_bonos`;

CREATE TABLE `comisiones_bonos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `difPropioPeculio` decimal(12,2) DEFAULT NULL,
  `resultado` decimal(12,2) DEFAULT NULL,
  `saldo` decimal(12,2) DEFAULT NULL,
  `cierre` decimal(12,2) DEFAULT NULL,
  `importeComision` decimal(12,2) DEFAULT NULL,
  `netoVenta` decimal(12,2) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `comisiones_bonos_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `comisiones_bonos_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `comisiones_bonos` */

/*Table structure for table `encuestavivienda` */

DROP TABLE IF EXISTS `encuestavivienda`;

CREATE TABLE `encuestavivienda` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(10) NOT NULL,
  `fecha` datetime NOT NULL,
  `tratoAsesor` int(2) NOT NULL,
  `tratoAsesorWhy` varchar(200) NOT NULL,
  `nosotros` int(2) NOT NULL,
  `nosotrosOtro` varchar(50) NOT NULL,
  `casaMuestra` int(2) NOT NULL,
  `viviendaAdquirir` int(2) NOT NULL,
  `tiempoTramite` int(2) NOT NULL,
  `gradoAceptacionFracc` int(2) NOT NULL,
  `razonEleccion` varchar(200) NOT NULL,
  `mejorasVivienda` varchar(200) NOT NULL,
  `mejorasfracc` varchar(200) NOT NULL,
  `condicionEntregaVivienda` int(2) NOT NULL,
  `condicionEntregaViviendaWhy` varchar(200) NOT NULL,
  `recomendacionCompra` int(2) NOT NULL,
  `recomendacionCompraWhy` varchar(200) NOT NULL,
  `status` int(2) NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(5) NOT NULL,
  `updated_by` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*Data for the table `encuestavivienda` */

/*Table structure for table `entrega` */

DROP TABLE IF EXISTS `entrega`;

CREATE TABLE `entrega` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `fechaEntrega` date DEFAULT NULL,
  `pdf_12` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'input entrega de vivienda',
  `pdf_13` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'input reglamento de fraccinamiento',
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entrega_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `entrega_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `entrega` */

/*Table structure for table `fraccionamientos` */

DROP TABLE IF EXISTS `fraccionamientos`;

CREATE TABLE `fraccionamientos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `estado` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `municipio` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `foto` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `thumbnail` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `fraccionamientos` */

/*Table structure for table `fraccionamientosxusuarios` */

DROP TABLE IF EXISTS `fraccionamientosxusuarios`;

CREATE TABLE `fraccionamientosxusuarios` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(50) DEFAULT NULL,
  `idUsuario` int(50) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fraccionamientosxusuarios_ibfk_1` (`idFraccionamiento`),
  KEY `fraccionamientosxusuarios_ibfk_2` (`idUsuario`),
  CONSTRAINT `fraccionamientosxusuarios_ibfk_1` FOREIGN KEY (`idFraccionamiento`) REFERENCES `fraccionamientos` (`id`) ON DELETE SET NULL ON UPDATE SET NULL,
  CONSTRAINT `fraccionamientosxusuarios_ibfk_2` FOREIGN KEY (`idUsuario`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `fraccionamientosxusuarios` */

/*Table structure for table `gestoria` */

DROP TABLE IF EXISTS `gestoria`;

CREATE TABLE `gestoria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `aplicaFolio` tinyint(1) DEFAULT '0',
  `numeroFolio` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `numeroCredito` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fechaIngreso` date DEFAULT NULL,
  `certificadoLibertad` char(5) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `constanciaNoAdeudo` char(5) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `precioVentaOci` decimal(12,2) DEFAULT NULL,
  `montoOci` decimal(12,2) DEFAULT NULL,
  `subCuenta` decimal(12,2) DEFAULT NULL,
  `gastosTitulacion` decimal(12,2) DEFAULT NULL,
  `ahorroVol` decimal(12,2) DEFAULT NULL,
  `subsidio` decimal(12,2) DEFAULT NULL,
  `sumaFinal` decimal(12,2) DEFAULT NULL,
  `fechaFirma` date DEFAULT NULL,
  `pdf_8` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'archivo escritura',
  `statusPdf_8` tinyint(1) DEFAULT '0',
  `pdf_9` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'archivo carta de instrucción',
  `statusPdf_9` tinyint(1) DEFAULT '0',
  `pdf_10` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'archivo no adeudo agua',
  `statusPdf_10` tinyint(1) DEFAULT '0',
  `pdf_11` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'archivo certificdo lib o g',
  `statusPdf_11` tinyint(1) DEFAULT '0',
  `statusGestoria` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gestoria_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `gestoria_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `gestoria` */

/*Table structure for table `logs` */

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `tipo` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `descripcion` text CHARACTER SET latin1,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `logs` */

/*Table structure for table `notarias` */

DROP TABLE IF EXISTS `notarias`;

CREATE TABLE `notarias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(150) CHARACTER SET utf8 DEFAULT NULL,
  `telefono` varchar(20) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `email` varchar(80) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `notarias` */

insert  into `notarias`(`id`,`nombre`,`telefono`,`email`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,'Notaría 1','9999999999','notaria1@mail.com',1,'2017-11-10 10:38:03','2017-11-10 10:38:03',1,1);

/*Table structure for table `postventa` */

DROP TABLE IF EXISTS `postventa`;

CREATE TABLE `postventa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAltaVenta` int(11) DEFAULT NULL,
  `instElectricas` date DEFAULT NULL,
  `instHidraulicas` date DEFAULT NULL,
  `instSanitarias` date DEFAULT NULL,
  `instGas` date DEFAULT NULL,
  `canceleria` varchar(45) COLLATE utf8_spanish2_ci DEFAULT 'NA',
  `impermeabilizacion` date DEFAULT NULL,
  `acabados` date DEFAULT NULL,
  `estructural` date DEFAULT NULL,
  `accesorios` date DEFAULT NULL,
  `calentadorAgua` date DEFAULT NULL,
  `pdf_14` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL COMMENT 'input para carga conformidad',
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `postventa_ibfk_1` (`idAltaVenta`),
  CONSTRAINT `postventa_ibfk_1` FOREIGN KEY (`idAltaVenta`) REFERENCES `alta_venta` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `postventa` */

/*Table structure for table `prospectos` */

DROP TABLE IF EXISTS `prospectos`;

CREATE TABLE `prospectos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idPromotor` int(11) DEFAULT NULL,
  `idFraccionamiento` int(11) NOT NULL,
  `nombre` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `apellidoP` varchar(80) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `apellidoM` varchar(80) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `rfc` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `telefono` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `fechaNac` date DEFAULT NULL,
  `lugarProspeccion` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `otroLugar` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `nss` varchar(100) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `statusProspecto` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `comentario` text COLLATE utf8_spanish2_ci,
  `prototipo` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `prospectos_ibfk_1` (`idPromotor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `prospectos` */

/*Table structure for table `prototiposxfraccionamiento` */

DROP TABLE IF EXISTS `prototiposxfraccionamiento`;

CREATE TABLE `prototiposxfraccionamiento` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(50) DEFAULT NULL,
  `titulo` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fraccionamientosxusuarios_ibfk_1` (`idFraccionamiento`),
  KEY `fraccionamientosxusuarios_ibfk_2` (`titulo`),
  CONSTRAINT `prototiposxfraccionamiento_ibfk_1` FOREIGN KEY (`idFraccionamiento`) REFERENCES `fraccionamientos` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `prototiposxfraccionamiento` */

/*Table structure for table `proyectos` */

DROP TABLE IF EXISTS `proyectos`;

CREATE TABLE `proyectos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idFraccionamiento` int(11) DEFAULT NULL,
  `idPrototipo` int(11) DEFAULT NULL,
  `numPaquete` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `lote` varchar(255) CHARACTER SET latin1 DEFAULT NULL,
  `manzana` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `calle` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `nOficial` varchar(25) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `cuv` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `claveCatastral` varchar(150) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `supTerreno` decimal(8,2) DEFAULT NULL,
  `supConstruccion` decimal(8,2) DEFAULT NULL,
  `precioVenta` decimal(12,2) DEFAULT NULL,
  `statusProyecto` varchar(50) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `puntaje` decimal(6,2) DEFAULT NULL,
  `porcentajeAvance` int(6) DEFAULT NULL,
  `contratista` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `avaluo` decimal(12,2) DEFAULT NULL,
  `unidadVerificadora` varchar(255) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `fechaVencimiento` date DEFAULT NULL,
  `fechaDtu` date DEFAULT NULL,
  `statusAlertDTU` tinyint(1) NOT NULL COMMENT '0 es alerta no enviada, 1 es alerta enviada',
  `lineaCredito` varchar(11) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `statusVenta` tinyint(1) NOT NULL COMMENT '0 se encuentre disponible, 1 se encuentra apartada, 2 se encuentra en proceso de venta, 3 se encuentra vendida',
  `status` tinyint(1) DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `proyectos_ibfk_1` (`idFraccionamiento`),
  CONSTRAINT `proyectos_ibfk_1` FOREIGN KEY (`idFraccionamiento`) REFERENCES `fraccionamientos` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `proyectos` */

/*Table structure for table `roles` */

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `roles` */

insert  into `roles`(`id`,`nombre`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,'admin',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(2,'Promotor',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(3,'Gestor',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(4,'Gte Ventas',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(5,'Técnica',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(6,'Postventa',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1),

(7,'Contabilidad',1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1);

/*Table structure for table `usuarios` */

DROP TABLE IF EXISTS `usuarios`;

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rol` int(11) DEFAULT '1',
  `usuario` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `password` varchar(100) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `nombre` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `apellidoP` varchar(45) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `apellidoM` varchar(45) COLLATE utf8_spanish2_ci NOT NULL,
  `email` varchar(80) COLLATE utf8_spanish2_ci DEFAULT NULL,
  `rfc` varchar(45) COLLATE utf8_spanish2_ci NOT NULL,
  `curp` varchar(45) COLLATE utf8_spanish2_ci NOT NULL,
  `calle` varchar(100) COLLATE utf8_spanish2_ci NOT NULL,
  `colonia` varchar(45) COLLATE utf8_spanish2_ci NOT NULL,
  `ciudad` varchar(45) COLLATE utf8_spanish2_ci NOT NULL,
  `telFijo` varchar(20) COLLATE utf8_spanish2_ci NOT NULL,
  `celular` varchar(20) COLLATE utf8_spanish2_ci NOT NULL,
  `tipoPromotor` varchar(45) COLLATE utf8_spanish2_ci NOT NULL COMMENT 'Interno o Externo',
  `comision` decimal(5,2) NOT NULL COMMENT 'Comisión de promotor',
  `fechaIngreso` date DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '1',
  `updated_by` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish2_ci;

/*Data for the table `usuarios` */

insert  into `usuarios`(`id`,`rol`,`usuario`,`password`,`nombre`,`apellidoP`,`apellidoM`,`email`,`rfc`,`curp`,`calle`,`colonia`,`ciudad`,`telFijo`,`celular`,`tipoPromotor`,`comision`,`fechaIngreso`,`status`,`created`,`updated`,`created_by`,`updated_by`) values 

(1,1,'admin','bf019414f607bdf1149c9afd586f972f6e9c1764','administrador','','','emmanuel@navegantes.mx','','','','','','','','0','0.00',NULL,1,'0000-00-00 00:00:00','0000-00-00 00:00:00',1,1);

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
