(function () {
	desbloquear();

	$('#contrasenia').keydown(function(e)
	{
		if(e.keyCode == 13)
		{ 
			e.preventDefault();
			enviar();
		}
	});
	$('#email').keydown(function(e)
	{
		if(e.keyCode == 13)
		{ 
			e.preventDefault();
			enviar();
		}
	});
})();

function desbloquear(){
	if($("#forget-password").is(":visible")){
		$("#login").show();
		$("#forget-password").hide();
		$('#correo').prop('required',true);
		$('#contrasenia').prop('required',true);
		$('#email').removeAttr('required');
		$('#email').val('');
		$('#ValidarForm').removeClass('was-validated');
	}
	else{
		$("#login").hide();
		$("#forget-password").show();
		$('#correo').removeAttr('required');
		$('#contrasenia').removeAttr('required');
		$('#email').prop('required',true);
		$('#correo').val('');
		$('#contrasenia').val('');
		$('#ValidarForm').removeClass('was-validated');
	}
}

function enviar(){
	$(':input[type="button"]').prop('disabled', true);
	$(':input[type="email"]').prop('disabled', true);
	$('#contrasenia').prop('disabled', true);
	var form = document.getElementById('ValidarForm');
	form.classList.add('was-validated');
	if (form.checkValidity() === false) {
		$(':input[type="button"]').prop('disabled', false);
		$(':input[type="email"]').prop('disabled', false);
		$('#contrasenia').prop('disabled', false);
	}
	else {
		var parametros = {
			"contrasenia" : $("#contrasenia").val(),
			"email" : $("#email").val(),
			"correo": $("#correo").val()
		};
		$.ajax({
			data: parametros,
			url: ($("#forget-password").is(":visible"))? "login/recuperar" : "login/login",
			type: "post",
			dataType: "JSON",
			beforeSend: function () {
				$(':input[type="button"]').prop('disabled', true);
			},
			success:  function (response) {
				if(response["msg"] == 'Bienvenido.'){
					window.location.href = response["url"];
				}
				else{
					$(':input[type="button"]').prop('disabled', false);
					$(':input[type="email"]').prop('disabled', false);
					$('#contrasenia').prop('disabled', false);
					$("#titulo").html(response["titulo"]);
					$("#texto").html(response["msg"]);
					$('#respuesta').modal('show');
				}
			},
			error : function(jqXHR, textStatus, errorThrown) {
				$(':input[type="button"]').prop('disabled', false);
				if (jqXHR.status === 0) {
					alert('Not connect: Verify Network.');
				} else if (jqXHR.status == 404) {
					alert('Requested page not found [404]');
				} else if (jqXHR.status == 500) {
					alert('Internal Server Error [500].');
				} else if (textStatus === 'parsererror') {
					alert('Requested JSON parse failed.');
				} else if (textStatus === 'timeout') {
					alert('Time out error.');
				} else if (textStatus === 'abort') {
					alert('Ajax request aborted.');
				} else {
					alert('Uncaught Error: ' + jqXHR.responseText);
				}
			}
		});
	}
}