$(document).ready(function() {
	//$("ul[id*='list_']").hide();
	//$("div[id*='div_']").hide();
	$('#loader_wrpper').hide();
});

function desplegar(lt){
	var x = document.getElementById("list_"+lt);
	if(x){
		if (window.getComputedStyle(x).display === "none") {
			$("#btn_"+lt).addClass('active');
			$('#list_'+lt).show();
			$('#div_'+lt).show();
		}
		else{
			$("button[id*='btn_sema']").removeClass('active');
			$('#list_'+lt).hide();
			$('#div_'+lt).hide();
		}
	}
	else{
		var parametros = {
			"valor" : lt
		};
		$.ajax({
			data:  parametros,
			url:   'inicio/crearLote',
			type:  'post',
			dataType: "JSON",
			beforeSend: function () {
				$("button[id*='btn_sema']").removeClass('active');
				$('button[type=button]').prop('disabled', true);
				$('#listado_lote').hide();
			},
			success:  function (response) {
				var html = '<ul class="list-group" id="list_' + lt + '">';
				for (var i = 0; i < response.length; i++) {
					var avance = response[i]['avances'];
					if(avance['mostrar']){
						var estilo = (!avance['activar'])? 'opacity:0.6; background-color: #DCDCDC' : '';
						var habilitar = (!avance['activar'])? 'disabled' : '';
						var checar = (avance['estado'])? 'checked' : '';
						html = html + '<li id="li_' + lt + '_avan' + avance['id'] + '" name="li_' + lt + '_avan' + avance['id'] 
						 + '" class="list-group-item d-flex justify-content-between align-items-center" style="'
						 + estilo + '" onclick="marcar(' + "'" + lt + '_avan' + avance['id'] + "'" +')"> ' + response[i]['descripcion']
						 + '<div class="form-group"> <label class="custom-control custom-checkbox text-right"> '
						 + '<input type="checkbox" class="custom-control-input" id="' + lt + '_avan' + avance['id'] + '" name="' + lt + '_avan' + avance['id'] 
						 + '" ' + checar + ' ' + habilitar + ' onchange="guardar(' + "'" + lt + '_avan' + avance['id'] + ')" >' 
						 + '<span class="custom-control-indicator"></span> <span class="custom-control-description"></span> </label>' 
						 + '</div> </li>';
					}
				}
				html = html + '</ul>';
				html = html + ' <div class="text-right" id="div_' + lt + '"> <button type="button" class="btn btn-outline-danger" onclick="ocultar(' 
				 + "'" + lt + "'" +')">Cerrar</button> </div>';
				$('#listado_lote').html(html);
				$('#listado_lote').show();
				$('button[type=button]').prop('disabled', false);
				$("#btn_"+lt).addClass('active');
			}
		});
	}
}

function ocultar(lt){
	$("button[id*='btn_sema']").removeClass('active');
	$('#list_'+lt).hide();
	$('#div_'+lt).hide();
}

function marcar(check) {
	if(!$('#'+check).is(':checked') && !$('#'+check).is(':disabled')){
		$('#'+check).attr('checked', true);
		$('#'+check).prop('checked', true);
		guardar(check);
	}
	else{
		if(!$('#'+check).is(':disabled')){
			$('#'+check).attr('checked', false);
			$('#'+check).prop('checked', false);
			guardar(check);
		}
	}
}

function abrir() {
	var radioValue = $("input[name='estimaciones']:checked").attr('id');
	var temp = $("input[name='categorias']:checked").val();
	if(radioValue){
		var x = document.getElementById('tab-' + radioValue + '-' + temp);
		if(x){
			$('#tab-' + radioValue + '-' + temp).show();
		}
		else{
			var categoria = $('input[name=categorias]:first').val();
			$("label[id*='lbl_']").removeClass('active');
			$('#btn-'+categoria).attr('checked', true);
			$('#btn-'+categoria).prop('checked', true);
			$("#lbl_"+categoria).addClass('active');
			cargarLotesXCateSema(categoria, radioValue);
		}
	}
}

function abrirC() {
	var radioValue = $("input[name='categorias']:checked").val();
	var semana = $("input[name='estimaciones']:checked").attr("id");
	if(radioValue){
		var x = document.getElementById('tab-' + semana + '-' + radioValue);
		if(x){
			$('#tab-' + semana + '-' + radioValue).show();
		}
		else{
			cargarLotesXCateSema(radioValue, semana);
		}
	}
}

function guardar(id){
	var otros = [];
	$("input[type=checkbox]").each(function(a){
		if( $(this).is(':enabled') ) {
			otros.push([$(this).attr("id"), $(this).is(':checked')]);
		}
	});
  	var datos = id.split("_");

	var parametros = {
		"nombre" : id,
		"valor" : $('#'+id).is(':checked'),
		"otros" : otros
	};
	$.ajax({
		data:  parametros,
		url:   'inicio/guardar',
		type:  'post',
		dataType: "JSON",
		beforeSend: function () {
			$('#sp_' + datos[0] + '_' + datos[1] + '_' + datos[2] + '_' + datos[3]).removeClass('badge badge-pill badge-success float-right');
			$('#sp_' + datos[0] + '_' + datos[1] + '_' + datos[2] + '_' + datos[3]).html('');
			for(i = 0; i < otros.length; i++){
				$('#li_'+otros[i][0]).css({"background-color": "#DCDCDC", "opacity": "0.6"});
			}
			$('button[type=button]').prop('disabled', true);
			$('input[type=checkbox]').prop('disabled', true);
		},
		success:  function (response) {
			for (i = 0; i < response['activos'].length; i++) {
				$('#'+response['activos'][i]).prop('disabled', false);
				$('#li_'+response['activos'][i]).removeAttr("style");
			}
			if(response['notificarXLt'] > 0){
				$('#sp_' + datos[0] + '_' + datos[1] + '_' + datos[2] + '_' + datos[3]).addClass('badge badge-pill badge-success float-right');
				$('#sp_' + datos[0] + '_' + datos[1] + '_' + datos[2] + '_' + datos[3]).html(response['notificarXLt']);
			}
			$('button[type=button]').prop('disabled', false);
		}
	});
}

function cargarLotesXCateSema(radioValue, semana){
	$('#loader_wrpper').show();
	var parametros = {
		"cate" : radioValue,
		"semana" : semana
	};
	$.ajax({
		data:  parametros,
		url:   'inicio/crearCategoriaXSemana',
		type:  'post',
		dataType: "JSON",
		beforeSend: function () {
			$('input[type=radio]').prop('disabled', true);
			$('#tab-content').hide()
		},
		success:  function (response) {
			if(response['lotes'].length > 0){
				var html = '<div class="tab-pane active" id="tab-' + semana + '_' + radioValue +'" role="tabpanel"> '
				+ '<div id="listado_lote" class="wrapperLista"> <table class="table"> <thead> <tr> <th> </th>';
				for (var l = 0; l < response['titulos'].length; l++) {
					html = html + '<th> ' + response['titulos'][l] + ' </th>';
				}
				html = html + '</tr> </thead> <tbody> ';
				for (var i = 0; i < response['actividades'].length; i++) {
					var avance = response['actividades'][i]['avances'];
					if(avance['mostrar']){
						html = html + '<tr id="li_' + semana + '_' + radioValue + '_avan' + avance['id'] + '" name="li_' + semana 
						 + '_' + radioValue + '_avan' + avance['id'] + '"> <td>' + response['actividades'][i]['descripcion'] + '</td> ';
						for (var l = 0; l < response['lotes'].length; l++) {
							var estilo = (!avance['activar'][response['lotes'][l]])? 'opacity:0.6; background-color: #DCDCDC' : '';
							var habilitar = (!avance['activar'][response['lotes'][l]])? 'disabled' : '';
							var checar = (avance['estado'][response['lotes'][l]])? 'checked' : '';
						html = html + '<td style="' + estilo + '"> <label class="custom-control custom-checkbox text-right"> '
							+ '<input type="checkbox" class="custom-control-input" id="' + semana + '_' + radioValue 
							+ '_lt' + response['lotes'][l] + '_avan' + avance['id'] + '" name="' + semana + '_' 
							+ radioValue + '_lt' + response['lotes'][l] + '_avan' + avance['id'] + '" ' + checar + ' ' + habilitar 
							+ ' onchange="guardar(' + "'" + semana + '_' + radioValue + '_lt' + response['lotes'][l] 
							+ '_avan' + avance['id'] + "'" + ')" >' + '<span class="custom-control-indicator"></span> <span class="'
							+ 'custom-control-description"></span> </label> </td>';
						}
						html = html + '</tr>';
					}
				}
				html = html + '</tbody> </table> </div> </div>';
				$('#tab-content').html(html);
				$('#tab-content').show();
				$("#listado_lote").show();
				$("#semana").show();
				$('input[type=radio]').prop('disabled', false);
			}
			$('#loader_wrpper').hide();
		}
	});
}