$(document).ready(function() {
    table();
    $("#aplicar").click(function(event) {
        table();
    });

    var oTable;
    $('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');

    var info=new Array();
    function table(){
        var subtotal=0;
        var iva=0;
        var total=0;
        var seguro=0;
        var descuento=0;
        var costo=0;
        var ganancia=0;
        var granSubtotal=0;

        info =
        {
            statusPaquete : $("#statusPaquete").val(),
            idFraccionamiento : $("#idFraccionamiento").val(),
            idPrototipo : $("#idPrototipo").val(),
            idConstructor : $("#idConstructor").val(),
            idResidente : $("#idResidentes").val(),
            fecha_inicio : $("#fecha_inicio").val(),
            fecha_fin : $("#fecha_fin").val()
        };

        $('#sample_3').DataTable().destroy();
        $('#sample_3').DataTable({
            "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "Todo"]],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Reporte Rentas"),
            // Processing indicator
            "processing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "rtest/listado/",
                "type": "POST",
                "data": {
                    "info": info
                }
            },
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                //Realizar operaciones
                //subtotal+=parseFloat(aData["_subtotal"]);
            },
            "fnInitComplete": function (oSettings, json) {
                //Resultado de operaciones
                //$("#subtotal").text(subtotal);
            },
            // DataTables server-side processing mode
            "serverSide": true,
            // Initial no order.
            "order": [],
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            //Set column definition initialisation properties
            "aoColumns": [
                { "mData": "id" },
                { "mData": "paquete" },
                { "mData": "fraccionamiento" },
                { "mData": "prototipo" },
                { "mData": "constructor" },
                { "mData": "nLotes" },
                //{ "mData": "rango_lotes" },
                { "mData": "fecha_inicio" },
                { "mData": "fecha_fin" },
                { "mData": "statusPaquete" },
                //{ "mData": "acciones" }
            ],
            "aaSorting": []
        });
    }

    $("#estatus,#idCliente,#fecha_inicio,#fecha_fin,#equipo,#personal,#vehiculo,#accesorio,#freelance,#marca,#codigo,#categoria,#proyecto,#cotizacion,#area,#moneda").change(function(event) {
        var idSelect = $(this).attr('id');
        if($(this).val() != 0){
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'yellow' );
        }else{
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'white' );
        }
    });
    $("#moneda").trigger('change');

    $("#idFraccionamiento").change(function(event) {
        App.blockUI();
        var idFraccionamiento = $(this).val();
        $("#idPrototipo").html('<option value="" selected="selected">Seleccione Prototipo</option>');
        $.post('rtest/getPrototiposByFracc/'+idFraccionamiento, {}, function(data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html = '<option value="0" selected="selected">Seleccione Prototipo</option>';
            if ( response2 != 0 ) {
                for ( i in response2 ) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#idPrototipo").html(html);
            $("#idPrototipo").val(0).trigger('change');
        });
        setTimeout(function(){ App.unblockUI() }, 700);
    });
});
