$(document).ready(function() {

    var idPrototipo = $('#idPrototipo').val();
    var statusProyecto = $('#statusProyecto').val();
    var fecha_inicio=$("#fecha_inicio").val();
    var fecha_fin=$("#fecha_fin").val();
    var lineaCredito = $('#lineaCredito').val();
    var fraccionamiento = $('#fraccionamiento').val();
    table();

    $("#aplicar").click(function(event) {
        idPrototipo = $('#idPrototipo').val();
        statusProyecto = $('#statusProyecto').val();
        fecha_inicio=$("#fecha_inicio").val().split('/');
        fecha_fin=$("#fecha_fin").val().split('/');
        fecha_inicio=(fecha_inicio != "") ? fecha_inicio[2] +"-"+fecha_inicio[1] +"-"+fecha_inicio[0] : "";
        fecha_fin=(fecha_fin != "") ? fecha_fin[2] +"-"+fecha_fin[1] +"-"+fecha_fin[0] : "";
        lineaCredito = $('#lineaCredito').val();
        fraccionamiento = $('#fraccionamiento').val();
        table();
    });

    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});

    $('#formatoCSV').click(function(event) {
        /* Act on the event */
        idPrototipo = $('#idPrototipo').val();
        statusProyecto = $('#statusProyecto').val();
        fecha_inicio=$("#fecha_inicio").val();
        fecha_fin=$("#fecha_fin").val();
        lineaCredito = $('#lineaCredito').val();
        fraccionamiento = $('#fraccionamiento').val();
        window.location.href="rtecnica/formatoCSV/"+idPrototipo+"_"+statusProyecto+"_"+fecha_inicio+"_"+fecha_fin+"_"+lineaCredito+"_"+fraccionamiento;
    });

$('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');
function table(){
    costo(idPrototipo+"_"+statusProyecto+"_"+fecha_inicio+"_"+fecha_fin+"_"+lineaCredito+"_"+fraccionamiento);
    // datatable
    $('#inventarioTecnica').DataTable().destroy();
    $('[data-ride="datatables"]').each(function() {
        var oTable = $(this).dataTable( {
            fixedHeader: {
                header: true,
                footer: false
            },
            "bProcessing": true,
            "sAjaxSource": "rtecnica/listado",
            "fnServerParams": function ( aoData ) {
                 aoData.push(
                        { "name": "idPrototipo", "value": idPrototipo },
                        { "name": "statusProyecto", "value": statusProyecto },
                        { "name": "fecha_inicio", "value": fecha_inicio },
                        { "name": "fecha_fin", "value": fecha_fin },
                        { "name": "lineaCredito", "value": lineaCredito },
                        { "name": "fraccionamiento", "value": fraccionamiento }
                    );
            },
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "fracc" },
                { "mData": "titulo" },
                { "mData": "manzana" },
                { "mData": "nOficial" },
                { "mData": "calle" },
                { "mData": "numPaquete" },
                { "mData": "cuv" },
                { "mData": "claveCatastral" },
                { "mData": "supTerreno" },
                { "mData": "supConstruccion" },
                { "mData": "prototipo" },
                { "mData": "precioVenta" },
                { "mData": "puntaje" },
                { "mData": "statusProyecto" },
                { "mData": "porcentajeAvance" },
                { "mData": "fechaDtu" },
                { "mData": "fechaVencimiento" },
                { "mData": "contratista" },
                { "mData": "avaluo" },
                { "mData": "unidadVerificadora" },
                { "mData": "lineaCredito" }
            ],
            "aaSorting": []
        } );
    });
}

    function costo(info){
        $.ajax({
                url: "rtecnica/getTotal/"+info,
                type: 'GET',
                dataType: 'JSON'
                ,success: function(total){
                    $("#total").text(total);
                }
            });
    }

});
