$(document).ready(function() {
    $(".menu-toggler").trigger("click");

    $(document).on('click', '.borrar', async function(){
        let idRequisicionDet=$(this).attr("id");  
        let res=await ajax('requisicion/eliminarDetalle',{
            idRequisicionDet:idRequisicionDet,
        });
        table();
     });

    $("#aplicar").click(function(event) {
        //(myTable) ? myTable.clear().draw() : "";
        visible={};
        $('#tfooter th').show();
        table();
    });

    table();
    var info=new Array();
    var myTable;
    $('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');
    function table(){
        $('#sample_3').DataTable().destroy();
        // datatable
        myTable = $("#sample_3").dataTable({
            "fixedHeader": {
                header: true,
            },
            "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todo"]],
            //lengthMenu: [[-1],["Todo"]],
            scrollX: true,
            ordering:true,
            // Initial no order.
            order: [],
            //Inicia docs y languaje
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Requisicion"),
            //Termina docs y languaje
            "bProcessing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "requisicion/listadoArticulos/",
                "type": "POST",
                "data": {
                    idRequisicion:$("#idRequisicion").val(),
                }
            },
            "initComplete": function () {
                var tableBody = document.querySelector ('.dataTables_scrollBody');
                var headerTable = document.querySelector ('.dataTables_scrollHead');
                var curDown = false;
                var oldScrollLeft = 0;
                var oldScrollTop = 0;
                var curXPos = 0;
                var curYPos = 0;
                
                if (tableBody) {
                  tableBody.addEventListener ("mousemove", function (e) {
                    if (curDown === true) {
                      tableBody.scrollLeft = oldScrollLeft + (curXPos - e.pageX);
                      headerTable.scrollLeft = oldScrollLeft + (curXPos - e.pageX);
                      tableBody.scrollTop = oldScrollTop + (curYPos - e.pageY);
                    }
                  });
                  
                  tableBody.addEventListener ("mousedown", function (e) {
                    curDown = true;
                    curYPos = e.pageY;
                    curXPos = e.pageX;
                    oldScrollLeft = tableBody.scrollLeft;
                    oldScrollTop = tableBody.scrollTop;
                  });
                  
                  tableBody.addEventListener ("mouseup", function (e) {
                    curDown = false;
                  });
                  
                  tableBody.addEventListener ("scroll", function (e) {
                    headerTable.scrollLeft = tableBody.scrollLeft;
                  });
                }
            },
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "manzana" }, 
                { "mData": "lote" }, 
                { "mData": "prototipo" }, 
                { "mData": "categoria" },
                { "mData": "articulo" }, 
                { "mData": "total" }, 
                { "mData": "solicitado" }, 
                { "mData": "pendiente" }, 
                { "mData": "cantidad" },
                { "mData": "acciones" },
            ],
            "aaSorting": [],
            //scrollY: 300,
        });
    }

    //hide footer columns
    let visible={};
    $(document).on("click", ".dt-button", function(e){
        let index = $(this).parent().children();
        index = index.index(this);
        if (visible.hasOwnProperty(index)) {
            let value=visible[index];
            if(value){
                $("#tfooter").find('th').eq(index).hide();
                visible[index]=false;
            }else{
                $("#tfooter").find('th').eq(index).show();
                visible[index]=true;
            }
        }else{
            visible[index]=false;
            $("#tfooter").find('th').eq(index).hide();
        }
        myTable.fnAdjustColumnSizing();
    });

    $(".select2").change(function(event) {
        let idSelect = $(this).attr('id');
        let val=$(this).val();
        if(val){
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'yellow' );
        }else{
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'white' );
        }
    });
    $("#moneda").trigger('change');

    //------------------ AGREGAR -------------------------------------------------
    $("#agregar").on( "click", async function() {
        App.blockUI();
        let idRequisicion=$("#idRequisicion").val();
        let idFraccionamiento=$("#fraccionamiento").val();
        let lote=$("#lote").val();
        let manzana=$("#manzana").val();
        let idArticulo=$("#articulo").val();
        if(idFraccionamiento && lote && manzana && articulo && !$.isNumeric(ltemza)){
            let dataArticulo = articulo.find(item => item.idArticulo === idArticulo);
            console.log(dataArticulo);
            let cantidad=$("#cantidad").val();
            if(cantidad != "" && cantidad > 0){
                let res=await ajax('requisicion/addArticulo',{
                    idRequisicion:idRequisicion,
                    cantidad:cantidad,
                    articulo:dataArticulo,
                    ltemza:ltemza,
                });
                if(res.error==""){
                    table();
                }else{
                    validation(res.error);
                }
            }else{
                validation("La cantidad tiene que ser mayor a 0");
            }
        }else{
            validation("Debes seleccionar un artículo");
        }
        App.unblockUI();
    });
    
    $( "#manzana" ).on( "change", async function() {
        App.blockUI();
        $("#lote, #categoria, #articulo").empty().trigger("change");
        let manzana=$("#manzana").val();
        if(manzana){
            let res=await ajax('requisicion/getLotes/1',{manzana:manzana});
            if(!$.isNumeric(res)){
                res.forEach(elem => {
                    addOption("#lote",elem.lote,elem.lote);
                });
            }
        }
        App.unblockUI();
    });
    
    let ltemza;
    $( "#lote" ).on( "change", async function() {
        App.blockUI();
        $("#categoria, #articulo").empty().trigger("change");
        let idFraccionamiento=$("#fraccionamiento").val();
        let lote=$("#lote").val();
        let manzana=$("#manzana").val();
        if(idFraccionamiento && lote && manzana){
            ltemza=await ajax('requisicion/getLteMza/',{
                idFraccionamiento:idFraccionamiento,
                lote:lote,
                manzana:manzana
            });
            console.log(ltemza);
            //categorias
            if(!$.isNumeric(ltemza)){
                let res=await ajax('requisicion/getCategorias/',{idMaterial:ltemza.idMaterial});
                if(!$.isNumeric(res)){
                    res.forEach(elem => {
                        addOption("#categoria",elem.clave,elem.categoria);
                    });
                }
            }
        }
        App.unblockUI();
    });
    
    let articulo;
    $( "#categoria" ).on( "change", async function() {
        App.blockUI();
        $("#articulo").empty().trigger("change");
        let categoria=$("#categoria").val();
        if(categoria && !$.isNumeric(ltemza)){
            articulo=await ajax('requisicion/getCantPptoByClaveCategoria/',{
                idEmpresa: ltemza.idEmpresa,
                idPaquete: ltemza.idPaquete,
                claveCategoria: categoria,
            });
            if(!$.isNumeric(articulo)){
                articulo.forEach(elem => {
                    addOption("#articulo",elem.idArticulo,elem.nombre);
                });
            }
        }
        App.unblockUI();
    });
    
    $( "#articulo" ).on( "change", async function() {
        $("#cantidad").val("");
    });
    
    function addOption(name,id,titulo,selected=false){
        var o = $("<option/>", {
            value: id,
            text: titulo
        });
        $(name).append(o);
        $(name+' option[value="' + id + '"]').prop('selected',selected);
    }
});
