$(document).ready(function() {
    $('.date-picker').datepicker({todayHighlight: true});
    $("#fecha_inicio").val('');
    $("#fecha_fin").val('');

    table();
    $("#aplicar").click(function(event) {
        table();
    });

    let oTable;
    $('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');

    var info=new Array();
    function table(){

        const numberFormat = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
            minimumFractionDigits: 2
        });

        var totRCMonto=0;
        var totRCImporte=0;
        var totRCPagos=0;
        var totRCSaldo=0;

        info =
        {
            fecha_inicio : ($("#fecha_inicio").val() != "") ? $("#fecha_inicio").val() : 0,
            fecha_fin : ($("#fecha_fin").val() != "") ? $("#fecha_fin").val() : 0,
            fraccionamiento : $('#fraccionamiento').val(),
            promotor : $('#promotor').val(),
            manzana : $('#manzana').val(),
            prototipo : $('#prototipo').val(),
            status : $('#status').val(),
        };
        $('#sample_3').DataTable().destroy();
        $('#sample_3').DataTable({
            "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "Todo"]],
            //"lengthMenu": [[-1], ["Todo"]],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Ventas de Contado"),
            // Processing indicator
            "ordering": true,
            "processing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "rcontado/listado/",
                "type": "POST",
                "data": {
                    "info": info
                }
            },
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {

                totRCMonto+=($.isNumeric(aData["monto_"])) ? parseFloat(aData["monto_"]) : 0;
                totRCImporte+=($.isNumeric(aData["importe_"])) ? parseFloat(aData["importe_"]) : 0;
                totRCPagos+=($.isNumeric(aData["pagos_"])) ? parseFloat(aData["pagos_"]) : 0;
                totRCSaldo+=($.isNumeric(aData["saldo_"])) ? parseFloat(aData["saldo_"]) : 0;
            },
            "fnDrawCallback": function() {
                $("#totRCMonto").text(numberFormat.format(totRCMonto));
                $("#totRCImporte").text(numberFormat.format(totRCImporte));
                $("#totRCPagos").text(numberFormat.format(totRCPagos));
                $("#totRCSaldo").text(numberFormat.format(totRCSaldo));
    
                totRCMonto=0;
                totRCImporte=0;
                totRCPagos=0;
                totRCSaldo=0;
            },
            // DataTables server-side processing mode
            "serverSide": true,
            "serverMethod": "post",
            // Initial no order.
            "order": [],
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            //Set column definition initialisation properties
            "aoColumns": [
                { "mData": "cliente" },
                { "mData": "fraccionamiento" },
                { "mData": "manzana" },
                { "mData": "lote" },
                { "mData": "nOficial" },
                { "mData": "prototipo" },
                { "mData": "superficie" },
                { "mData": "plazos" },
                { "mData": "monto" },
                { "mData": "importe" },
                { "mData": "pagos" },
                { "mData": "saldo" },
                { "mData": "movimiento" },
                { "mData": "comprobante" },
                { "mData": "statusDetalle" },
            ],
            "aaSorting": [],
            "columnDefs": [
                { "orderable": false, "className": "dt-right", "targets": 13 },
            ]
        });

        setTimeout(function(){
            $(".numIitems").html('');
            $('.searchTable').html('');
            $("#sample_3_length").prependTo(".numIitems");
            $('#sample_3_filter').prependTo('.searchTable');
        }, 1000);
    }

    $("#fraccionamiento,#promotor,#manzana,#prototipo,#status").change(function (event) {
        let idSelect = $(this).attr('id');
        if($(this).val() != 0){
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'yellow' );
        }else{
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'white' );
        }
    });

    $("#fecha_inicio,#fecha_fin").change(function (event) {
        let idSelect = $(this).attr('id');
        if($(this).val() != ''){
            $('#'+idSelect).css( 'background-color', 'yellow' );
        }else{
            $('#'+idSelect).css( 'background-color', 'white' );
        }
    });
});
