$(document).ready(function() {
    var info=new Array();
    table();

    $("#aplicar").click(function(event) {
        table();
    });

    //Función recursiva de creación de datatables con filtros y exportación NAVEGANTE
    function table(){
        var suma=0;
        var n=0;
        var filtros="";
        info =
          {
            idPromotor: $("#idPromotor").val(),
            fecha_inicio: $("#fecha_inicio").val(),
            fecha_fin: $("#fecha_fin").val()
        };
        filtros="FILTROS: ";
        filtros+= (info['fecha_inicio'] != "" && info['fecha_fin'] != "") ? " > Fecha inicio: "+info['fecha_inicio']+" - Fecha fin: "+info['fecha_fin'] : "";
        $("#filtros").text(filtros);

        // datatable
        $('#sample_3').DataTable().destroy();
        $("#sample_3").each(function() {
            var oTable = $(this).dataTable( {
                //Inicia docs y languaje
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
                },
                buttons: [
                {
                    extend: 'print',
                    title: 'Reporte de Tiempos de Atención',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'copy',
                    title: 'Reporte de Tiempos de Atención',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'pdf',
                    title: 'Reporte de Tiempos de Atención',
                    filename: 'Reporte de Tiempos de Atención',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'excel',
                    title: 'Reporte de Tiempos de Atención',
                    filename: 'Reporte de Tiempos de Atención',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'csv',
                    title: 'Reporte de Tiempos de Atención',
                    filename: 'Reporte de Tiempos de Atención',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                 'colvis'
                ],
                //Termina docs y languaje
                "bProcessing": true,
                "sAjaxSource": "ratencion/listadoDetalle/",
                "fnServerParams": function ( aoData ) {
                     aoData.push(
                            { "name": "info", "value":  info }
                        );
                },
                "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                    suma=aData["tiempo"];
                    n+=1;
                },
                "fnInitComplete": function (oSettings, json) {
                    $("#promedio").text(suma/n+" MINS");
                },
                "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
                "sPaginationType": "full_numbers",
                "aoColumns": [
                    { "mData": "fechaAsignacion" },
                    { "mData": "horaAsignacion" },
                    { "mData": "fechaAtencion" },
                    { "mData": "horaAtencion" },
                    { "mData": "tiempo" }
                ],
                "aaSorting": []
            } );
        });
    }



});
