$(document).ready(function() {
    $(".menu-toggler").trigger("click");
    $("#aplicar").click(function(event) {
        //(myTable) ? myTable.clear().draw() : "";
        visible={};
        $('#tfooter th').show();
        table();
    });

    table();
    var info=new Array();
    var myTable;
    $('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');
    function table(){
        var importe=0;
        var fg=0;
        var total=0;
        info =
        {
            ano : $("#ano").val(),
            semana : $("#semana").val(),
            fraccionamiento : $("#fraccionamiento").val(),
            paquete : $("#paquete").val(),
            constructor : $("#constructor").val(),
            prototipo : $("#prototipo").val(),
            supervisor : $("#supervisor").val(),
            tipoLote : $("#tipoLote").val(),
            fecha_inicio : $("#fecha_inicio").val(),
            fecha_fin : $("#fecha_fin").val(),
            estatusCalidad : $("#estatusCalidad").val(),
        };
        $('#sample_3').DataTable().destroy();
        // datatable
        myTable = $("#sample_3").dataTable({
            "fixedHeader": {
                header: true,
            },
            "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todo"]],
            //lengthMenu: [[-1],["Todo"]],
            scrollX: true,
            ordering:true,
            // Initial no order.
            order: [],
            //Inicia docs y languaje
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Reporte de Actividades"),
            //Termina docs y languaje
            "bProcessing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "ractividades/listado/",
                "type": "POST",
                "data": {
                    "info": info
                }
            },
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                //Realizar operaciones
                if(aData["tipo"]=="footer"){
                    importe+=toNumber(aData["importe"]);
                    fg+=toNumber(aData["fg"]);
                    total+=toNumber(aData["total"]);
                }
            },
            "initComplete": function () {
                var tableBody = document.querySelector ('.dataTables_scrollBody');
                var headerTable = document.querySelector ('.dataTables_scrollHead');
                var curDown = false;
                var oldScrollLeft = 0;
                var oldScrollTop = 0;
                var curXPos = 0;
                var curYPos = 0;
                
                if (tableBody) {
                  tableBody.addEventListener ("mousemove", function (e) {
                    if (curDown === true) {
                      tableBody.scrollLeft = oldScrollLeft + (curXPos - e.pageX);
                      headerTable.scrollLeft = oldScrollLeft + (curXPos - e.pageX);
                      tableBody.scrollTop = oldScrollTop + (curYPos - e.pageY);
                    }
                  });
                  
                  tableBody.addEventListener ("mousedown", function (e) {
                    curDown = true;
                    curYPos = e.pageY;
                    curXPos = e.pageX;
                    oldScrollLeft = tableBody.scrollLeft;
                    oldScrollTop = tableBody.scrollTop;
                  });
                  
                  tableBody.addEventListener ("mouseup", function (e) {
                    curDown = false;
                  });
                  
                  tableBody.addEventListener ("scroll", function (e) {
                    headerTable.scrollLeft = tableBody.scrollLeft;
                  });
                }
                //Resultado de operaciones
                $("#importe").text(importe);
                $("#fg").text(fg);
                $("#total").text(total);
                $(".moneda").formatCurrency();

                //reinicializacion
                importe=0;
                fg=0;
                total=0;
            },
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "fraccionamiento" }, 
                { "mData": "manzana" }, 
                { "mData": "lote" }, 
                { "mData": "prototipo" }, 
                { "mData": "constructor" },
                { "mData": "supervisor" }, 
                { "mData": "inspector" }, 
                { "mData": "descripcion" }, 
                { "mData": "categoria" }, 
                { "mData": "semanaActual" },
                { "mData": "semanaAnual" }, 
                { "mData": "calidad" }, 
                { "mData": "tipoLote" }, 
                { "mData": "paquete" }, 
                { "mData": "precioUnitario" }, 
                { "mData": "cantidad" }, 
                { "mData": "importe" }, 
                { "mData": "fg" }, 
                { "mData": "total" },
            ],
            "aaSorting": [],
            //scrollY: 300,
        });
    }

    //hide footer columns
    let visible={};
    $(document).on("click", ".dt-button", function(e){
        let index = $(this).parent().children();
        index = index.index(this);
        if (visible.hasOwnProperty(index)) {
            let value=visible[index];
            if(value){
                $("#tfooter").find('th').eq(index).hide();
                visible[index]=false;
            }else{
                $("#tfooter").find('th').eq(index).show();
                visible[index]=true;
            }
        }else{
            visible[index]=false;
            $("#tfooter").find('th').eq(index).hide();
        }
        myTable.fnAdjustColumnSizing();
    });

    function toNumber(number){
        //let res=parseFloat(number.substring(1, number.length - 1));
        let res=number.toString().slice(1, -1);
        res=res.replaceAll(/,/g,"");
        return parseFloat(res);
    }

    $(".select2").change(function(event) {
        var idSelect = $(this).attr('id');
        if($(this).val() != 0){
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'yellow' );
        }else{
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'white' );
        }
    });
    $("#moneda").trigger('change');
});
