$(document).ready(function() {
    // datatable
    $('[data-ride="programa"]').each(function() {
        var oTable = $(this).dataTable({
            "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "Todo"]],
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                if(aData["tipo"] ==  1){
                    $(nRow).css('background-color', '#000000');
                    $(nRow).css('color', '#FFFFFF');
                    $(nRow).css('font-weight', 'bold');
                }
            },
            "bProcessing": true,
            "sAjaxSource": "prototipos_mat/listadoProgramaObra/" + $("#idPrototipo").val(),
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
            { "mData": "id" },
            { "mData": "idCategoria" },
            { "mData": "clave" },
            { "mData": "titulo" },
            { "mData": "cantidad" },
            { "mData": "idUnidad" },
            { "mData": "acciones" }
            ],
            "aaSorting": [],
             "paging": false,
            "ordering": false,
            "info": false
        });
        //detectar cuando un tecla es presionada en el input
        $("#tbl").on("keypress", 'input', function(e) {
            //validar si esa tecla es enter
            if(e.which == 13) { 
                var id = this.id.substring(10);
                var val = this.value;
            // datatable actualizar
            $.ajax({
                url: 'prototipos_mat/actProgObra/',
                type: 'POST',
                dataType: 'json',
                data: {
                    id: id,
                    val: val
                },beforeSend: function() {
                    //App.blockUI();
                    $('.loading-message img').attr('src','assets/global/img/loading-spinner-grey.gif');
                },success: function(data){
                 //Llenado del modal
                    $("#titulo").html(data.titulo);
                    $("#texto").html(data.msg);
                    $('#mdl-rsp').modal('show');
                    $(document).on("keypress", function(e) {
                        //validar si esa tecla es enter
                        if(e.which == 13) {
                            $("#mdl-rsp").modal('hide');
                        }
                     });
                     oTable.ajax.reload( null, false ); // user paging is not reset on reload

             }
         });
            // datatable actualizar
        }
    });

    });

    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});

    // mostrar mesaje de imporación CSV
    if ($('#csv-imp').val()) {
        //trigger modal
        $('#mdl-csv').modal('show');
        $(document).on("keypress", function(e) {
                        //validar si esa tecla es enter
                        if(e.which == 13) {
                            $("#mdl-csv").modal('hide');
                        }
        });

    }

  });
    

 function modalEliminarActividad(idActividad ) {
         $('#idActividad').val(idActividad);
           // alert(idActividad)
         $('#modalEliminarPO').modal({
            backdrop: 'static',
            keyboard: false
        });

 }

function eliminarActividad(){
    var idActividad = $('#idActividad').val();
        //alert(idActividad);
    $.ajax({
        type: "POST",
        url: 'prototipos_mat/eliminarActividad',
        dataType: 'json',
        cache:false,
        data:{
            idActividad: idActividad,
        },
        beforeSend: function() {
            App.blockUI();
            $('.loading-message img').attr('src','assets/global/img/loading-spinner-grey.gif');
        },
        success: function(data){
            App.unblockUI();
            if(data.valor="true"){
            window.location.reload();
            }
        }
    }); // termina ajax
}