$(document).ready(function() {
    let idCorte=$("#idCorte").val();
    $(".menu-toggler").trigger("click");
    $("#aplicar").click(function(event) {
        //(myTable) ? myTable.clear().draw() : "";
        visible={};
        $('#tfooter th').show();
        table();
    });

    $("#confirmar").on( "click", function() {
        let error="";
        $('.modal').css({'z-index' : 10050});
        App.blockUI();
        let idConstructor=$("#idConstructor").val();
        let otros=$("#otros").val();
        let amortizacion=$("#amortizacion").val();
        let prestamo=$("#prestamo").val();
        let formaPago=$("#formaPago").val();
        let comision=$("#comision").val();
        //fondos de garantia
        let tipos=[];
        $(".tipoPpto").each(function( index ) {
            tipos.push({
                "id":$(this).attr('id'),
                "value":$(this).val(),
            });
        });
        let response= ajax("preorden/saveMovimientos/"+idCorte,{
            idOrdenPago:idOrdenPago,
            idConstructor:idConstructor,
            otros:otros,
            amortizacion:amortizacion,
            prestamo:prestamo,
            formaPago:formaPago,
            comision:comision,
            tipos:tipos,
        });
        table();
        $("#ordenPago").modal("hide");
        App.unblockUI();
    });

    table();
    var myTable;
    $('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');
    function table(){
        var importe=0;
        var extras=0;
        var prestamos=0;
        var amortizaciones=0;
        var retenciones=0;
        var fg=0;
        var total=0;
        $('#sample_3').DataTable().destroy();
        // datatable
        myTable = $("#sample_3").dataTable({
            "fixedHeader": {
                header: true,
            },
            "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todo"]],
            //lengthMenu: [[-1],["Todo"]],
            scrollX: true,
            ordering:true,
            // Initial no order.
            order: [],
            //Inicia docs y languaje
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Preorden"),
            //Termina docs y languaje
            "bProcessing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "preorden/listado/"+idCorte,
                "type": "POST",
            },
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                //Realizar operaciones
                if(aData["tipo"]=="footer"){
                    importe+=toNumber(aData["importe"]);
                    extras+=toNumber(aData["extras"]);
                    prestamos+=toNumber(aData["prestamos"]);
                    amortizaciones+=toNumber(aData["amortizaciones"]);
                    retenciones+=toNumber(aData["retenciones"]);
                    fg+=toNumber(aData["fg"]);
                    total+=toNumber(aData["total"]);
                }
            },
            "initComplete": function () {
                var tableBody = document.querySelector ('.dataTables_scrollBody');
                var headerTable = document.querySelector ('.dataTables_scrollHead');
                var curDown = false;
                var oldScrollLeft = 0;
                var oldScrollTop = 0;
                var curXPos = 0;
                var curYPos = 0;
                
                if (tableBody) {
                  tableBody.addEventListener ("mousemove", function (e) {
                    if (curDown === true) {
                      tableBody.scrollLeft = oldScrollLeft + (curXPos - e.pageX);
                      headerTable.scrollLeft = oldScrollLeft + (curXPos - e.pageX);
                      tableBody.scrollTop = oldScrollTop + (curYPos - e.pageY);
                    }
                  });
                  
                  tableBody.addEventListener ("mousedown", function (e) {
                    curDown = true;
                    curYPos = e.pageY;
                    curXPos = e.pageX;
                    oldScrollLeft = tableBody.scrollLeft;
                    oldScrollTop = tableBody.scrollTop;
                  });
                  
                  tableBody.addEventListener ("mouseup", function (e) {
                    curDown = false;
                  });
                  
                  tableBody.addEventListener ("scroll", function (e) {
                    headerTable.scrollLeft = tableBody.scrollLeft;
                  });
                }
                //Resultado de operaciones
                $("#importe").text(importe);
                $("#extras").text(extras);
                $("#prestamos").text(prestamos);
                $("#amortizaciones").text(amortizaciones);
                $("#retenciones").text(retenciones);
                $("#fg").text(fg);
                $("#total").text(total);
                $(".moneda").formatCurrency();

                //reinicializacion
                importe=0;
                extras=0;
                prestamos=0;
                amortizaciones=0;
                retenciones=0;
                fg=0;
                total=0;
            },
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "constructor" },
                { "mData": "nActividades" },
                { "mData": "nLotes" },
                { "mData": "nPaquetes" },
                { "mData": "importe" },
                { "mData": "extras" },
                { "mData": "prestamos" },
                { "mData": "amortizaciones" },
                { "mData": "retenciones" },
                { "mData": "fg" },
                { "mData": "total" },
                { "mData": "acciones" },
            ],
            "aaSorting": [],
            //scrollY: 300,
        });
    }

    //hide footer columns
    let visible={};
    $(document).on("click", ".dt-button", function(e){
        let index = $(this).parent().children();
        index = index.index(this);
        if (visible.hasOwnProperty(index)) {
            let value=visible[index];
            if(value){
                $("#tfooter").find('th').eq(index).hide();
                visible[index]=false;
            }else{
                $("#tfooter").find('th').eq(index).show();
                visible[index]=true;
            }
        }else{
            visible[index]=false;
            $("#tfooter").find('th').eq(index).hide();
        }
        myTable.fnAdjustColumnSizing();
    });

    function toNumber(number){
        //let res=parseFloat(number.substring(1, number.length - 1));
        let res=number.toString().slice(1, -1);
        res=res.replaceAll(/,/g,"");
        return parseFloat(res);
    }

    $(".select2").change(function(event) {
        var idSelect = $(this).attr('id');
        if($(this).val() != 0){
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'yellow' );
        }else{
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'white' );
        }
    });
    $("#moneda").trigger('change');

});



let idOrdenPago;
async function openModal(id){
    $("#content-tipos").empty();
    $("#prestamo,#amortizacion,#otros").val("");
    idOrdenPago=id;
    let idCorte=$("#idCorte").val();
    $('.modal').css({'z-index' : 10050});
    App.blockUI();
    let response= await ajax("preorden/getOpConstructor",{id:id,idCorte:idCorte});
    let data=response.data[0];
    $("#idConstructor").val(data.idConstructor);
    //movimientos
    if(!$.isNumeric(response.movimientos)){
        response.movimientos.forEach(mov => {
            console.log(mov.tipo);
            switch (parseInt(mov.tipo)) {
                case 1:
                    $("#prestamo").val(mov.monto);
                    break;
                case 3:
                    $("#amortizacion").val(mov.monto);
                    break;
                case 7:
                    $("#otros").val(mov.monto);
                    break;
                case 8:
                    $("#comision").val(mov.monto);
                    break;
            }
        });
    }
    $("#idConstructor").val(data.idConstructor);
    $("#idConstructor").val(data.idConstructor);
    $("#idConstructor").val(data.idConstructor);
    $("#idConstructor").find('option[value="' + data.idConstructor+ '"]').prop('selected',true);
    $("#idConstructor").trigger('change');
    $("#montoTotal").html(data.monto);
    $("#montoTotal").formatCurrency();
    if(!$.isNumeric(response.tipos)){
        response.tipos.forEach(tipo => {
            let input='<label class="control-label" for="prestamo">'+tipoLote(tipo.tipoLote)+'(%):</label>';
            input+='<input id="'+tipo.tipoLote+'" name="'+tipo.tipoLote+'" value="'+tipo.percent_fg+'" type="text" class="form-control tipoPpto" placeholder="'+tipoLote(tipo.tipoLote)+'"></input>';
            $("#content-tipos").append(input);
        });
    }
    $("#ordenPago").modal("show");
    App.unblockUI();
}

$("#addContratista").click(function(event) {
    $("#addContratistaModal").modal("show");
});

$("#saveContratista").click(async function(event) {
    App.blockUI();
    $(".modal-backdrop").remove();
    let idConstructor=$("#addContratistaModal").find("#idConstructor").val();
    if(idConstructor>0){
        let idCorte=$("#idCorte").val();
        let response= await ajax("preorden/addContratista",{idConstructor:idConstructor,idCorte:idCorte});
        if(response.error==''){
            window.location.reload();
        }else{
            $('.modal').css({'z-index' : 10050});
            //$(".modal-backdrop").remove();
            App.unblockUI();
            validation(response.error);
        }
    }
});


