$(document).ready(function() {
    let idOrdenPago=$("#idOrdenPago").val();
    $(".menu-toggler").trigger("click");
    $("#aplicar").click(function(event) {
        //(myTable) ? myTable.clear().draw() : "";
        visible={};
        $('#tfooter th').show();
        table();
    });

    table();
    var myTable;
    $('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');
    function table(){
        var importe=0;
        $('#sample_3').DataTable().destroy();
        // datatable
        myTable = $("#sample_3").dataTable({
            "fixedHeader": {
                header: true,
            },
            "lengthMenu": [[10, 50, 100, -1], [10, 50, 100, "Todo"]],
            //lengthMenu: [[-1],["Todo"]],
            scrollX: true,
            ordering:true,
            // Initial no order.
            order: [],
            //Inicia docs y languaje
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Extras"),
            //Termina docs y languaje
            "bProcessing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "preorden/listadoExtras/"+idOrdenPago,
                "type": "POST",
            },
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                //Realizar operaciones
                importe+=parseFloat(aData["_importe"],2);
            },
            "initComplete": function () {
                var tableBody = document.querySelector ('.dataTables_scrollBody');
                var headerTable = document.querySelector ('.dataTables_scrollHead');
                var curDown = false;
                var oldScrollLeft = 0;
                var oldScrollTop = 0;
                var curXPos = 0;
                var curYPos = 0;
                
                if (tableBody) {
                  tableBody.addEventListener ("mousemove", function (e) {
                    if (curDown === true) {
                      tableBody.scrollLeft = oldScrollLeft + (curXPos - e.pageX);
                      headerTable.scrollLeft = oldScrollLeft + (curXPos - e.pageX);
                      tableBody.scrollTop = oldScrollTop + (curYPos - e.pageY);
                    }
                  });
                  
                  tableBody.addEventListener ("mousedown", function (e) {
                    curDown = true;
                    curYPos = e.pageY;
                    curXPos = e.pageX;
                    oldScrollLeft = tableBody.scrollLeft;
                    oldScrollTop = tableBody.scrollTop;
                  });
                  
                  tableBody.addEventListener ("mouseup", function (e) {
                    curDown = false;
                  });
                  
                  tableBody.addEventListener ("scroll", function (e) {
                    headerTable.scrollLeft = tableBody.scrollLeft;
                  });
                }
                //Resultado de operaciones
                $("#importe").text(importe);
                $(".moneda").formatCurrency();

                //reinicializacion
                importe=0;
            },
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "fraccionamiento" },
                { "mData": "tipoExtra" },
                { "mData": "Lote" },
                { "mData": "manzana" },
                { "mData": "descripcion" },
                { "mData": "cantidad" },
                { "mData": "precio" },
                { "mData": "importe" },
                { "mData": "acciones" },
            ],
            "aaSorting": [],
        });
    }

    $("#divmanzana, #divlote").hide();
    $( "#tipoExtra" ).on( "change", function() {
        let val=$(this).val();
        if(val==2){
            $("#divmanzana, #divlote").hide();
        }else if(val==1){
            $("#divmanzana, #divlote").show();
        }
    });

    $( "#idFraccionamiento" ).on( "change", async function() {
        App.blockUI();
        $("#manzana, #lote, #cantidad, #precioUnitario, #descripcion").empty().trigger("change");
        let idFraccionamiento=$("#idFraccionamiento").val();
        if(idFraccionamiento){
            let res=await ajax('preorden/getManzanas/1',{idFraccionamiento:idFraccionamiento});
            if(!$.isNumeric(res)){
                res.forEach(elem => {
                    addOption("#manzana",elem.id,elem.titulo);
                });
            }
        }
        App.unblockUI();
    });
    
    $( "#manzana" ).on( "change", async function() {
        App.blockUI();
        $("#lote, #cantidad, #precioUnitario, #descripcion").empty().trigger("change");
        let manzana=$("#manzana").val();
        if(manzana){
            let res=await ajax('preorden/getLotes/1',{manzana:manzana});
            if(!$.isNumeric(res)){
                res.forEach(elem => {
                    addOption("#lote",elem.lote,elem.lote);
                });
            }
        }
        App.unblockUI();
    });

    function addOption(name,id,titulo,selected=false){
        var o = $("<option/>", {
            value: id,
            text: titulo
        });
        $(name).append(o);
        $(name+' option[value="' + id + '"]').prop('selected',selected);
    }

    $("#agregar").on( "click", async function() {
        App.blockUI();
        let tipoExtra=$("#tipoExtra").val();
        let idOrdenPago=$("#idOrdenPago").val();
        let idFraccionamiento=$("#idFraccionamiento").val();
        let lote=$("#lote").val();
        let manzana=$("#manzana").val();
        if(idOrdenPago && idFraccionamiento && ((tipoExtra==1 && lote && manzana) || (tipoExtra==2))){
            let cantidad=$("#cantidad").val();
            let precioUnitario=$("#precioUnitario").val();
            if((cantidad != "" && cantidad > 0) && (precioUnitario != "" && precioUnitario > 0)){
                let descripcion=$("#descripcion").val();
                if(descripcion!=""){
                    let res=await ajax('preorden/addExtras',{
                        idOrdenPago:idOrdenPago,
                        idFraccionamiento:idFraccionamiento,
                        tipoExtra:tipoExtra,
                        lote:lote,
                        manzana:manzana,
                        cantidad:cantidad,
                        precioUnitario:precioUnitario,
                        descripcion:descripcion,
                    });
                    if(res.error==""){
                        table();
                        $("#cantidad, #precioUnitario, #descripcion").empty().trigger("change");
                    }else{
                        validation(res.error);
                    }
                }else{
                    validation("Debes agregar una descripción");
                }
            }else{
                validation("La cantidad y el precio unitario deben ser mayores a 0");
            }
        }else{
            validation("Debes seleccionar todos los campos");
        }
        App.unblockUI();
    });

    $(document).on('click', '.borrar', async function(){
        let id=$(this).attr("id");  
        let res=await ajax('preorden/eliminarDetalle',{
            id:id,
        });
        table();
     });

     $(document).on('change', '.myInput', async function(){  
        App.blockUI();
        let id=$(this).attr("id");
        let cantidad=$(".cantidad_"+id).val();
        let precio=$(".precio_"+id).val();
        let res=await ajax('preorden/actualizarDetalle',{
            id:id,
            cantidad:cantidad,
            precio:precio
        });
        $(".importe_"+id).html(res);
        let importe=0;
        $( ".importe" ).each(function( index ) {
            importe+=parseFloat($( this ).html(),2);
        });
        $("#importe").text(importe);
        $(".moneda").formatCurrency();
        App.unblockUI();
     }); 
});