$(document).ready(function() {
    $("#export_csv").click(function(event) {
        /* Act on the event */
        window.location.href="pmat/exportarEjemplo";
    });

    var mostrarModal = $('#mostrarModal').val();
    if(mostrarModal == 'SI'){
        $('#modalActualizar').modal({backdrop: 'static', keyboard: false})
        $('#modalActualizar').modal('show');
    }else{
        $('#modalActualizar').modal('hide');
    }

    $('#sample_3').DataTable().destroy();
     // datatable
    $("#sample_3").dataTable({
        //Inicia docs y languaje
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
        },
        buttons: getConfigColvis("Pmat"),
        "bProcessing": true,
        "sAjaxSource": "pmat/listado",
        "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
        "sPaginationType": "full_numbers",
        "aoColumns": [
            { "mData": "acciones" },
            { "mData": "paquete" },
            { "mData": "prototipo" },
            { "mData": "totalUnitario" },
            { "mData": "totalPaquete" },
            { "mData": "inputFile" },
        ],
        "aaSorting": []
        });

    $(".blockui-save").click(function () { App.blockUI(), window.setTimeout(function () { App.unblockUI(".blockui-content") }, 2e3) });

    $("#idFraccionamiento").change(function (event) {
        App.blockUI();
        var idFraccionamiento = $(this).val();
        $("#idPrototipo").html('<option value="" selected="selected">Seleccione Prototipo</option>');
        $.post('pmat/getPrototiposByFracc/' + idFraccionamiento, {}, function (data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html = '<option value="0" selected="selected">Seleccione Prototipo</option>';
            if (response2 != 0) {
                for (i in response2) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#idPrototipo").html(html);
            $("#idPrototipo").val(0).trigger('change');
        });
        setTimeout(function () {
            App.unblockUI()
        }, 700);
    });

    $("#idPrototipo").change(function (event) {
        App.blockUI();
        var idFraccionamiento = $("#idFraccionamiento").val();
        var idPrototipo = $(this).val();
        $("#idPaquete").html('<option value="" selected="selected">Seleccione Paquete</option>');
        $.post('pmat/getPaqueteByFraccProto/' + idFraccionamiento + '/' + idPrototipo, {}, function (data, textStatus, xhr) {
            var response2 = $.parseJSON(data);
            var html = '<option value="0" selected="selected">Seleccione Presupuesto MO</option>';
            if (response2 != 0) {
                for (i in response2) {
                    html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                }
            }
            $("#idPaquete").html(html);
            $("#idPaquete").val(0).trigger('change');
        });
        setTimeout(function () {
            App.unblockUI()
        }, 700);
    });
});

function editar(id){
    $("#"+id).submit();
    App.blockUI(), window.setTimeout(function () {
        App.unblockUI(".blockui-content")
    }, 2e3);
}

function redirect(){
    window.location.href="pmat";
}
