$(document).ready(function() {
    table();
    $("#aplicar").click(function (event) {
        table();
    });
    // datatable
    function table() {
        var filtroSemana = $("#filtroSemana").val();
        $('[data-ride="resumen"]').DataTable().destroy();
        $('[data-ride="resumen"]').each(function() {
            var oTable = $(this).dataTable({
                "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "Todo"]],
                "bProcessing": true,
                "sAjaxSource": "pmat/listadoResumenpmat/" + $("#idMaterial").val() + "/" + filtroSemana,
                "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
                "sPaginationType": "full_numbers",
                "aoColumns": [
                    { "mData": "tipo" },
                    { "mData": "clave" },
                    { "mData": "categoria" },
                    { "mData": "proveedor" },
                    { "mData": "semana" },
                    { "mData": "descripcion" },
                    { "mData": "unidad" },
                    { "mData": "cantidad" },
                    { "mData": "precioUnitario" },
                    { "mData": "importe" },
                ],
                "columnDefs": [{
                    width: '25%',
                    targets: 3,
                }],
                "aaSorting": []
            });
        });
    }

     $("#filtroSemana").change(function (event) {
        var idSelect = $(this).attr('id');
        if ($(this).val() != 0) {
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css('background-color', 'yellow');
        } else {
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css('background-color', 'white');
        }
    });

    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});
});
