$(document).ready(function(){
    $('.map').maphilight();
    setTimeout(() => {
        $(".fa fa-download").show();
    }, 5000);

    var $div = $('<div>').css({
        position: 'absolute',
        background: 'white',
        padding: '10px',
        zIndex: 999,
        display: 'none'
    }).appendTo('body'); 
    var titulo = '';
    var estatusLote = '';
    var status = 0;
    var precio = '';
    var clase = '';

    $('a.tooltipRojo, a.tooltipAmarillo, a.tooltipVerde, a.tooltipGris, a.tooltipNaranja, a.tooltipAzul').each(function (i, value) {
        $(this).mousemove(function(e){
            $div.css({
                top: e.pageY + 10 + 'px',
                left: e.pageX + 10 + 'px'
            });
      
        });
        $(this).hover(function (e) {
            titulo = $(this).data("titulo");
            estatusLote = $(this).data("estatuslote");
            status = $(this).data("status");
            precio = $(this).data("precio");
            clase = $(this).data("clase");
            prototipo = $(this).data("prototipo");
            
            $div.show().html(`
                        <h5 class="`+clase+`"> 
                            `+estatusLote+` 
                        </h5> 
                        ` 
                        +
                        `
                        <label class="red"> 
                              `+titulo+`
                         </label> <br>
                      
                        ` 
                        +
                        `
                        <label class="red"> 
                             <strong> Prototipo </strong>: `+prototipo+`
                         </label> <br>
                      
                        ` 
                        );
        }, function () {
            $div.hide();
        });
    });

});

function SelectArea(eid){
    var data = $('#'+eid).data('maphilight') || {};
    data.fillColor='FFFFFF';
    data.fillOpacity=0.5;
    data.alwaysOn = false;
    $('#'+eid).data('maphilight',data);
}

function downloadImage(){
    console.log("Screenshot");
    setDate();
    var width = $("#myCanvas").css("width");
    $("#mapa").width(width);
    html2canvas(document.getElementById('mapa'), {
        onrendered: function(canvas) {
          return Canvas2Image.saveAsPNG(canvas);
        }
    });
}

function downloadPdf(){
    setDate();
    var width = $("#myCanvas").css("width");
    $("#mapa").width(width);
    html2canvas(document.getElementById('mapa'), {
        onrendered: function(canvas) {
            var pageData = canvas.toDataURL('image/jpeg', 1.0);
            var pdf = new jsPDF('', 'pt', 'a4');
            pdf.addImage(pageData, 'JPEG', 0, 0, 595.28, 592.28/canvas.width * canvas.height );
            pdf.save('plano.pdf');
        }
    });
}

function setDate(){
    var c = document.getElementById("myCanvas");
    var ctx=c.getContext("2d");
    today = new Date();
    var d = today.getDate()
    var m = today.getMonth()+1
    var y = today.getFullYear()

    ctx.fillText(("Fecha: " + d + "/" + m + "/" + y), 10, 20);
}

