$(document).ready(function() {
    // datatable
    // $('[data-ride="datatables"]').each(function() {
    //     var oTable = $(this).dataTable( {
    //         "bProcessing": true,
    //         "sAjaxSource": "gestoria/listado",
    //         "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
    //         "sPaginationType": "full_numbers",
    //         "aoColumns": [
    //             { "mData": "fraccionamiento" },
    //             { "mData": "nombre" },
    //             { "mData": "nss" },
    //             { "mData": "promotor" },
    //             { "mData": "lote" },
    //             { "mData": "manzana" },
    //             { "mData": "nOficial" },
    //             { "mData": "calle" },
    //             { "mData": "cuv" },
    //             { "mData": "precioVenta" },
    //             { "mData": "avaluo" },
    //             { "mData": "statusVivienda" },
    //             { "mData": "statusGestoria" },
    //             { "mData": "acciones" }
    //         ],
    //         "aaSorting": []
    //     } );
    // });

    $('#sample_3').DataTable().destroy();

    // datatable
    $("#sample_3").each(function() {
        var oTable = $(this).dataTable( {
            "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
            //Inicia docs y languaje
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Titulacion"),
            //Termina docs y languaje
            "bProcessing": true,
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            //INICIA CONF. SERVERSIDE
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "gestoria/listado",
                "type": "POST"
            },
            "ordering": false,
            //FINALIZA CONF. SERVERSIDE
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "statusGestoria" },
                { "mData": "statusVivienda" },
                { "mData": "fraccionamiento" },
                { "mData": "nombre" },
                { "mData": "nss" },
                { "mData": "promotor" },
                { "mData": "lote" },
                { "mData": "manzana" },
                { "mData": "ronda" },
                { "mData": "nOficial" },
                { "mData": "calle" },
                { "mData": "cuv" },
                //{ "mData": "monto" },
                //{ "mData": "gastosOperacion" },
                //{ "mData": "total" },
                { "mData": "diferencia" },
                { "mData": "bonoEquipamiento" },
                { "mData": "numeroCredito" },
                { "mData": "precioVentaOci" },
                { "mData": "montoOci" },
                { "mData": "gastosTitulacion" },
                { "mData": "ahorroVol" },
                { "mData": "subsidio" },
                { "mData": "sumaFinal" },
                { "mData": "fechaFirma" },
                { "mData": "fechaProceso" },

                { "mData": "fechaEsperaIns" },
                { "mData": "fechaInscrito" },
                { "mData": "fechaAhorroVol" },
                { "mData": "fechaRevCondiciones" },
                { "mData": "fechaNotaria" },
                { "mData": "fechaFirmaEscritura" },
                { "mData": "fechaFirmado" },
                { "mData": "fechaVenta" },
                //{ "mData": "fechaDetonado" },
                { "mData": "fechaPreca" },
                { "mData": "fechaAlta" },
                { "mData": "fechaProspeccion" },
                { "mData": "ronda" },

                { "mData": "precioVenta" },
                { "mData": "avaluo" },
                { "mData": "fechaCambio" },
                { "mData": "valorTerreno" },
                { "mData": "supTerreno" }
            ],
            "aaSorting": []
        } );
    });

    var oTable2 = $("#listado2").dataTable( {
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            "destroy": true,
            "bProcessing": true,
            "sAjaxSource": "gestoria/listado2",
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "statusGestoria" },
                { "mData": "statusVivienda" },
                { "mData": "fraccionamiento" },
                { "mData": "nombre" },
                { "mData": "nss" },
                { "mData": "promotor" },
                { "mData": "lote" },
                { "mData": "manzana" },
                { "mData": "nOficial" },
                { "mData": "calle" },
                { "mData": "cuv" },
                { "mData": "monto" },
                { "mData": "gastosOperacion" },
                { "mData": "total" },
                { "mData": "diferencia" },
                { "mData": "bonoEquipamiento" },
                { "mData": "numeroCredito" },
                { "mData": "precioVentaOci" },
                { "mData": "montoOci" },
                { "mData": "gastosTitulacion" },
                { "mData": "ahorroVol" },
                { "mData": "subsidio" },
                { "mData": "sumaFinal" },
                { "mData": "fechaFirma" },
                { "mData": "precioVenta" },
                { "mData": "avaluo" },
                { "mData": "fechaCambio" }
            ],
            "aaSorting": []
    });

    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});

    $('#aplicaFolio').click(function() {
        if ($(this).is(':checked')){
            $(this).val(1);
            $('#contentNumFolio').show('slow');
        }else{
            $(this).val(0);
            $('#numeroFolio').val('')
            $('#contentNumFolio').hide('slow');
        }
    });

    //calculamos suma total en apartado montos
    $(".sumar").on("keydown keyup", function() {
        calculateSum();
    });
    $(".restar").on("keydown keyup", function() {
        calculateSum();
    });

    $('#btnEspacio').click(function(event) {
        /* Act on the event */
        $('#modal-espacio').modal()
    });

    $('#revisionMontos2').change(function(event) {
        //alert($(this).val());
        if ($(this).val()=='diferencia'){
            $('#contentBonoE').hide('slow');
            $('#bonoEquipamiento').val('');
            $('#contentDiferencia').show('slow');
        }
        if ($(this).val()=='bonoEquipamiento'){
            $('#contentDiferencia').hide('slow');
            $('#diferencia').val('');
            $('#contentBonoE').show('slow');
        }
        if ($(this).val()=='ninguna'){
            $('#contentDiferencia').hide('slow');
            $('#diferencia').val('');
            $('#contentBonoE').hide('slow');
            $('#bonoEquipamiento').val('');
        }

    });


});

function calculateSum() {
    var sum = 0;
    var sum2 = 0;
    //iterate through each textboxes and add the values
    $(".sumar").each(function() {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length != 0) {
            $(this).css("background-color", "transparent");
            sum += parseFloat(this.value);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.length != 0){
            $(this).css("background-color", "red");
        }
    });

    $(".restar").each(function() {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length != 0) {
            $(this).css("background-color", "transparent");
            sum2 += parseFloat(this.value);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (this.value.length != 0){
            $(this).css("background-color", "red");
        }
    });

    var total = sum - sum2;

    if (total > 0){
        $("#total").val(total);
        $("#total").formatCurrency();
    }else{
        $("#total").val(parseFloat(total).toFixed(2));
    }
}

function cancelProcess( id ) {
    var idMotivo=$("#cancelProcess").find("#idMotivo").val();
    console.log("Id gestoria: " + id);
    console.log("Motivo cancelación: " + $("#motivoCancelacion").val());
    if(id==0){
        var id = $("#idAltaVenta").val();
        if (id>0){

        }else{
            id = 0;
        }
    }
    $('#cancel-process').hide('slow');
    $('#procesa-cancelacion').show('slow');
    $.post('gestoria/cancelProcess', {idGestoria: id, motivoCancelacion: $("#motivoCancelacion").val(),idMotivo:idMotivo}, function(data) {
        console.log("Data reponse: " + data);
        $("#cancelProcess").modal('hide');
        if ( $.parseJSON(data).success ) {
            success('El tramite ha sido cancelado');
            location.href ="gestoria";
        }
        else {
            validation($.parseJSON(data).msg);
        }
    });
    $('#cancel-process').show('slow');
    $('#procesa-cancelacion').hide('slow');
}

function revertir( id ) {
        $('#revertir').modal('show')
        $('#idAltaVenta').val(id);
}

function ProcesarModalRevertir() {

    var idAltaVenta= $('#idAltaVenta').val(); //este idAltaVenta viene del modal. Se asgna la var idAltaventa
    $.post('gestoria/ProcesarModalRevertir',{idAltaVenta:idAltaVenta}, function(data) {
        console.log("Data reponse: " + data);

        if ( $.parseJSON(data).success == true ) {
            success('El tramite ha sido revertido');
            location.href ="gestoria";
        }
        else {
            validation($.parseJSON(data).msg);
        }
    });

}

function modalCancelarProceso(id){
    $('#cancelProcess').modal('show')
    $('#idAltaVenta').val(id);
}
