$(document).ready(function() {

    var chart;
    var filters;
    var filtro;
    setTimeout(function(){
      $("#aplicar").trigger('click');
    },500);
    $("#aplicar").click(function(event){
        getData();
    });

    var info= new Array();
    function getData(){
      filters="";
      fecha_inicio=$("#fecha_inicio").val().split('/');
      fecha_fin=$("#fecha_fin").val().split('/');
      fecha_inicio=(fecha_inicio != "") ? fecha_inicio[2] +"-"+fecha_inicio[1] +"-"+fecha_inicio[0] : "";
      fecha_fin=(fecha_fin != "") ? fecha_fin[2] +"-"+fecha_fin[1] +"-"+fecha_fin[0] : "";
      grafica=$("#grafica option:selected").val();
      fraccionamiento=$("#fraccionamiento option:selected").val();

      filters+=(fecha_inicio != "") ? "Fecha Inicio: "+$("#fecha_inicio").val()+"\n" : "";
      filters+=(fecha_fin != "") ? "Fecha Final: "+$("#fecha_fin").val()+"\n" : "";
      filters+=(fraccionamiento != 0) ? "Fraccionamiento: "+$("#fraccionamiento option:selected").text() : "";
      filtro=((fecha_inicio != "" && fecha_fin !="") || fraccionamiento != 0) ? "FILTROS" : "";
      info =
      {
        fecha_inicio : fecha_inicio,
        fecha_fin : fecha_fin,
        grafica : grafica,
        fraccionamiento : fraccionamiento
      };
      //alert($("#grafica option:selected").val());
      if($("#grafica option:selected").val() != 0){
          $.ajax({
              url: "g_gestoria/getGrafica",
              type: 'POST',
              dataType: 'JSON',
              data: {
                  info: info
              },success:function(data){
                graph(data);
                if(data.length == 0){
                  validation("Tu busqueda no genero ningún resultado, intenta con una combinación diferente.");
                }
              }
          });
      }else{
        validation("Selecciona una gráfica");
      }
    }

    function graph(data){
      //var field=($("#grafica option:selected").val() == 1) ? "Lugar de Prospeccion" : "Promotor";
      var field = 'Lugar de Prospeccion';
      var chart = AmCharts.makeChart("chartdiv", {
        "hideCredits":true,
        "type": "serial",
        "theme": "light",
        "marginRight": 70,
        "dataProvider": data,
        "valueAxes": [{
          "axisAlpha": 0,
          "position": "left",
          "title": "# Clientes",
        }],
        "titles": [{
          "text": 'Gestoría',
        }, {
          "text": filters,
          "bold": false
        }],
        "startDuration": 1,
        "graphs": [{
          "balloonText": "<b>[["+field+"]] : [[# Prospectos]]</b>",
          "fillColorsField": "color",
          "fillAlphas": 0.9,
          "lineAlpha": 0.2,
          "type": "column",
          "valueField": "# Prospectos"
        }],
        "chartCursor": {
          "categoryBalloonEnabled": false,
          "cursorAlpha": 0,
          "zoomable": false
        },
        "categoryField": field,
        "categoryAxis": {
          "gridPosition": "start",
          "labelRotation": 45
        },
        "export": {
          "enabled": true,
          "exportFields": [
            field,
            "# Prospectos"
          ],
          "menu": [ {
            "class": "export-main",
            "menu": [ {
              "label": "Descargar como imagen",
              "menu": [ "PNG", "JPG", "SVG",  ]
            }, {
              "label": "Descargar como archivo",
              "menu": [ "CSV", "JSON" ]
            }, {
              "format": "PRINT"
            }]
          } ]
        }

      });
    }

});

