$(document).ready(function() {

    var chart;
    var filters;
    var filtro;
    setTimeout(function(){
      $("#aplicar").trigger('click');
    },500);
    $("#aplicar").click(function(event){
        getData();
    });

    var info= new Array();
    function getData(){
      filters="";
      fecha_inicio=$("#fecha_inicio").val().split('/');
      fecha_fin=$("#fecha_fin").val().split('/');
      fecha_inicio=(fecha_inicio != "") ? fecha_inicio[2] +"-"+fecha_inicio[1] +"-"+fecha_inicio[0] : "";
      fecha_fin=(fecha_fin != "") ? fecha_fin[2] +"-"+fecha_fin[1] +"-"+fecha_fin[0] : "";
      fraccionamiento=$("#fraccionamiento option:selected").val();

      filters+=(fecha_inicio != "") ? "Fecha Inicio: "+$("#fecha_inicio").val()+"\n" : "";
      filters+=(fecha_fin != "") ? "Fecha Final: "+$("#fecha_fin").val()+"\n" : "";
      filters+=(fraccionamiento != 0) ? "Fraccionamiento: "+$("#fraccionamiento option:selected").text() : "";
      filtro=((fecha_inicio != "" && fecha_fin !="") || fraccionamiento != 0) ? "FILTROS" : "";
      info =
      {
        fecha_inicio : fecha_inicio,
        fecha_fin : fecha_fin,
        fraccionamiento : fraccionamiento
      };
      //alert($("#estatus option:selected").val());
      $.ajax({
          url: "g_encuesta/getGraficas",
          type: 'POST',
          dataType: 'JSON',
          data: {
              info: info
          },success:function(data){
            //console.log(data);
            graph(data[1],"1.¿Cómo califica el trato del asesor de venta?","chartdiv1");
            graph(data[2],"2.¿Que grado de aceptación encuentra nuestro fraccionamiento?","chartdiv2");
            graph(data[3],"3.¿Cuál fue la condición de entrega de su vivienda?","chartdiv3");
            graph(data[4],"4.¿Se mostró la casa muestra?","chartdiv4");
            graph(data[5],"5.¿Se mostró la vivienda a adquirir?","chartdiv5");
            graph(data[6],"6.¿Le explicaron sobre el tiempo de trámite de su crédito?","chartdiv6");
            graph(data[7],"7.¿Nos recomendaría o compraría nuevamente?","chartdiv7");
            graph(data[8],"8.¿Cómo se entero de nosotros?","chartdiv8");
            if(data[1].length == 0){
              validation("Tu busqueda no generó ningún resultado, intenta con una combinación diferente.");
            }
          }
      });
    }

    function graph(data,title="",graph=""){
      var field="Rubro";
      var chart = AmCharts.makeChart(graph, {
        "hideCredits":true,
        "type": "serial",
        "theme": "light",
        "marginRight": 70,
        "dataProvider": data,
        "valueAxes": [{
          "axisAlpha": 0,
          "position": "left",
          "title": "# Clientes",
          "integersOnly":true,
        }],
        "titles": [{
          "text": title,
        }, {
          "text": filters,
          "bold": false
        }],
        "startDuration": 1,
        "graphs": [{
          "balloonText": "<b>[["+field+"]] : [[# Usuarios]]</b>",
          "fillColorsField": "color",
          "fillAlphas": 0.9,
          "lineAlpha": 0.2,
          "type": "column",
          "valueField": "# Usuarios"
        }],
        "chartCursor": {
          "categoryBalloonEnabled": false,
          "cursorAlpha": 0,
          "zoomable": false
        },
        "categoryField": field,
        "categoryAxis": {
          "gridPosition": "start",
          "labelRotation": 45
        },
        "export": {
          "enabled": true,
          "exportFields": [
            field,
            "# Usuarios"
          ],
          "menu": [ {
            "class": "export-main",
            "menu": [ {
              "label": "Descargar como imagen",
              "menu": [ "PNG", "JPG", "SVG",  ]
            }, {
              "label": "Descargar como archivo",
              "menu": [ "CSV", "JSON" ]
            }, {
              "format": "PRINT"
            }]
          } ]
        }

      });
    }

});

