$(document).ready(function() {
// datatable
          $('#sample_3').DataTable().destroy();
     // datatable
    $("#sample_3").dataTable({
        //Inicia docs y languaje
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
        },
        buttons: getConfigColvis("Estimaciones"),    

            "bProcessing": true,
            "sAjaxSource": "estimaciones/listado",
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "idFraccionamiento" },
                { "mData": "idPrototipo" },
                { "mData": "estimaciones" },
                { "mData": "paquete" },
            ],
            "aaSorting": []
        } );



    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});

});

$("#idFraccionamiento").change(function(event) {
    App.blockUI();
    var idFraccionamiento = $(this).val();
    $("#idPrototipo").html('<option value="" selected="selected">Seleccione Prototipo</option>');
    $.post('estimaciones/getPrototiposByFracc/'+idFraccionamiento, {}, function(data, textStatus, xhr) {
        var response2 = $.parseJSON(data);
        var html = '<option value="0" selected="selected">Seleccione Prototipo</option>';
        if ( response2 != 0 ) {
            for ( i in response2 ) {
                html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
            }
        }
        $("#idPrototipo").html(html);
        $("#idPrototipo").val(0).trigger('change');
    });
    setTimeout(function(){ App.unblockUI() }, 900);
});

$("#idPrototipo").change(function(event) {
    App.blockUI();
    var idFraccionamiento = $('#idFraccionamiento').val();
    var idPrototipo = $(this).val();
    var estimaciones = '';
    $("#idPaquete").html('<option value="" selected="selected">Seleccione Paquete</option>');
    $.post('estimaciones/getPaquetesByFraccProt/'+idFraccionamiento+'/'+idPrototipo, {}, function(data, textStatus, xhr) {
        var response2 = $.parseJSON(data);
        var html = '<option value="0" selected="selected">Seleccione Paquete</option>';
        if ( response2 != 0 ) {
            for ( i in response2 ) {
                html += '<option value="' + response2[i].id + '">' + response2[i].titulo + '</option>';
                estimaciones = response2[i].estimaciones;
            }
        }
        $("#estimaciones").val(estimaciones);
        $("#idPaquete").html(html);
        $("#idPaquete").val(0).trigger('change');
    });
    setTimeout(function(){ App.unblockUI() }, 900);
});

// actualizar estimaciones
function actualizarDias(id,dia,obj){
    var parametros = {
        "id" : id,
        "valor" : obj.value,
        "dia" : dia,
        "actividad": $('#actividad').val(),
        "prototipo": $('#prototipo').val(),
        "idPaquete": $('#idPaquete').val()
    };    
    $.ajax({
        data: parametros,
        url: "estimaciones/actualizarDias",
        type: "post",
        dataType: "JSON",
        beforeSend: function () {
            App.blockUI();
        },
        success:  function (response) {
            App.unblockUI();
            switch(response["valor"]){
                case 'error':
                //Llenado del modal

                    /*$("#titulo").html(response["titulo"]);
                    $("#texto").html(response["texto"]);
                    $('#respuesta').modal('show');*/


                    //$('div[id = alrt-message]').html(response["alert"]);
                    obj.value = response['val'];

                    validation(response["texto"]);
                    //$("#pendiPagar_"+id).css("background","red");
                    $('.day-'+dia+"-"+id).css("background","red");
                    $('.day-'+dia+"-"+id).find(':input'),css("background","red");
                    $('.day-'+dia+"-"+id).find(':input'),css("color","white");                    
                    //$("#estimados_"+id).css("background","red");
                    //$("#estimados_"+id).css("color","white");
                    $('.day-'+dia+"-"+id).find(':input').val(0);                     
                    break;
                case 'limite':
                //Llenado del modal
                    $("#titulo").html(response["titulo"]);
                    $("#texto").html(response["texto"]);
                    //$("#pendiPagar_"+id).css("background","red");
                    $('.day-'+dia+"-"+id).css("background","red");
                    $('.day-'+dia+"-"+id).find(':input').css("background","red");
                    $('.day-'+dia+"-"+id).find(':input').css("color","white");
                    //$("#estimados_"+id).css("background","red");
                    //$("#estimados_"+id).css("color","white");
                    $('.day-'+dia+"-"+id).find(':input').val(0);

                    validation(response["texto"]);
                    //$('#respuesta').modal('show');
                    break;
                case 'correcto':
                //Llenado del modal
                    $("#titulo").html(response["titulo"]);
                    $("#texto").html(response["texto"]);
                    
                    //$("#pendiPagar_"+id).css("background","green");
                    $('.day-'+dia+"-"+id).css("background","green");
                    $('.day-'+dia+"-"+id).find(':input').css("background","green");
                    $('.day-'+dia+"-"+id).find(':input').css("color","white"); 

                    //$("#estimados_"+id).css("background","green");
                    //$("#estimados_"+id).css("color","white");

                    success(response["texto"]);
                    //$('#respuesta').modal('show');
                    break;
                default:
                break;
            }
            setTimeout(function (){
                $('.day-'+dia+"-"+id).css("background","");
                $('.day-'+dia+"-"+id).find(':input').css("background","");
                $('.day-'+dia+"-"+id).find(':input').css("color","black");
            }, 5000);
        },
        error : function(jqXHR, textStatus, errorThrown) {
            App.unblockUI();
            if (jqXHR.status === 0) {
                alert('Not connect: Verify Network.');
            } else if (jqXHR.status == 404) {
                alert('Requested page not found [404]');
            } else if (jqXHR.status == 500) {
                alert('Internal Server Error [500].');
            } else if (textStatus === 'parsererror') {
                alert('Requested JSON parse failed.');
            } else if (textStatus === 'timeout') {
                alert('Time out error.');
            } else if (textStatus === 'abort') {
                alert('Ajax request aborted.');
            } else {
                alert('Uncaught Error: ' + jqXHR.responseText);
            }
        }
    });
}

function actualizar(id){
    var parametros = {
        "id" : id,
        "valor" : $("#estimados_"+id).val()
    };
    $.ajax({
        data: parametros,
        url: "estimaciones/actualizar",
        type: "post",
        dataType: "JSON",
        beforeSend: function () {
            App.blockUI();
        },
        success:  function (response) {
            App.unblockUI();
            switch(response["valor"]){
                case 'error':
                // Marcado de actualizacion
                    $('.estimados-'+id).css("background","red");
                    $('.estimados-'+id).find(':input').css("background","red");
                    $('.estimados-'+id).find(':input').css("color","white");
                    $("#estimados_"+id).val(response["anterior"]);
                //Llenado del modal
                    $("#titulo").html(response["titulo"]);
                    $("#texto").html(response["texto"]);
                    //$('#respuesta').modal('show');
                    validation(response["texto"]);
                    break;
                case 'correcto':
                // Marcado de actualizacion
                    $('.estimados-'+id).css("background","green");
                    $('.estimados-'+id).find(':input').css("background","green");
                    $('.estimados-'+id).find(':input').css("color","white");
                // Llenado de la estimacion cambiada
                    $("#pagar_"+id).html(response["estimacion"]);
                //Llenado por actividad
                    for (i = 0; i < response["ids"].length; i++) {
                        $("#pendiPagar_"+response["ids"][i]).html(response["pendiPagar"]);
                        $("#acuPagar_"+response["ids"][i]).html(response["acuPagar"]);
                        $("#acuLotes_"+response["ids"][i]).html(response["acuLotes"]);
                        $("#pendiLotes_"+response["ids"][i]).html(response["pendiLotes"]);
                    }
                // Llenado por categoria
                    $("td[id*='pendiPagarC_"+response["categoria"]+"']").html(response["pendiPagarC"]);
                    $("td[id*='acuPagarC_"+response["categoria"]+"']").html(response["acuPagarC"]);
                //Llenado del modal
                    $("#titulo").html(response["titulo"]);
                    $("#texto").html(response["texto"]);
                    //$('#respuesta').modal('show');
                    success(response["texto"]);
                    break
                default:
                break;
            }
            setTimeout(function (){
                $('.estimados-'+id).css("background","");
                $('.estimados-'+id).find(':input').css("background","");
                $('.estimados-'+id).find(':input').css("color","black");
            }, 5000);
        },
        error : function(jqXHR, textStatus, errorThrown) {
            App.unblockUI();
            if (jqXHR.status === 0) {
                alert('Not connect: Verify Network.');
            } else if (jqXHR.status == 404) {
                alert('Requested page not found [404]');
            } else if (jqXHR.status == 500) {
                alert('Internal Server Error [500].');
            } else if (textStatus === 'parsererror') {
                alert('Requested JSON parse failed.');
            } else if (textStatus === 'timeout') {
                alert('Time out error.');
            } else if (textStatus === 'abort') {
                alert('Ajax request aborted.');
            } else {
                alert('Uncaught Error: ' + jqXHR.responseText);
            }
        }
    });
}