$(document).ready(function() {
    // datatable
    // $('[data-ride="datatables"]').each(function() {
    //     var oTable = $(this).dataTable( {
    //         "bProcessing": true,
    //         "sAjaxSource": "depositos/listado",
    //         "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
    //         "sPaginationType": "full_numbers",
    //         "aoColumns": [
    //             { "mData": "fraccionamiento" },
    //             { "mData": "lote" },
    //             { "mData": "manzana" },
    //             { "mData": "cliente" },
    //             { "mData": "nss" },
    //             { "mData": "promotor" },
    //             { "mData": "precioVenta" },
    //             { "mData": "comision" },
    //             { "mData": "importeComision" },
    //             { "mData": "statusVivienda" },
    //             { "mData": "estatus" },
    //             { "mData": "acciones" }
    //         ],
    //         "aaSorting": []
    //     } );
    // });

    $('#sample_3').DataTable().destroy();

    // datatable
    $("#sample_3").each(function() {
        var oTable = $(this).dataTable( {
            //Inicia docs y languaje
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Depósitos"),
            //Termina docs y languaje
            "bProcessing": true,
            "sAjaxSource": "depositos/listado",
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            "aoColumns": [
                { "mData": "acciones" },
                { "mData": "statusVivienda" },
                { "mData": "estatus" },
                { "mData": "fraccionamiento" },
                { "mData": "lote" },
                { "mData": "manzana" },                
                { "mData": "totDepositos" },
                { "mData": "totalPagoComisiones" },
                { "mData": "totalPagoBonificacion" },
                { "mData": "lineaCredito" },
                { "mData": "cliente" },
                { "mData": "nss" },
                { "mData": "promotor" },
                { "mData": "avaluo" },
                { "mData": "ahorroVol" },
                { "mData": "precioVentaOci" },
                { "mData": "precioVenta" },
                { "mData": "sumaFinal" },
                { "mData": "difPropioPeculio" },
                { "mData": "numeroCredito" },
                { "mData": "resultado" },
                { "mData": "bonoEquipamiento" },
                { "mData": "saldo" },
                { "mData": "cierre" },
                { "mData": "tipoPromotor" },
                { "mData": "comision" },
                { "mData": "importeComision" },
                { "mData": "diferenciaVendedor" },
                { "mData": "netoVenta" },
                { "mData": "comentarios" },
                { "mData": "primerPagoPromotor" },
                { "mData": "fechaPrimerPagoPromotor" },
                { "mData": "segundoPagoPromotor" },
                { "mData": "fechaSegundoPagoPromotor" },
                { "mData": "primerPagoCoordinador" },
                { "mData": "fechaPrimerPagoCoordinador" },
                { "mData": "segundoPagoCoordinador" },
                { "mData": "fechaSegundoPagoCoordinador" },
                { "mData": "bonificacion" },
                { "mData": "fechaBonificacion" },
                { "mData": "pagoUno" },
                { "mData": "fechaPagoUno" },
                { "mData": "pagoDos" },
                { "mData": "fechaPagoDos" },
                { "mData": "pagoTres" },
                { "mData": "fechaPagoTres" },
                { "mData": "pagoCuatro" },
                { "mData": "fechaPagoCuatro"},
                { "mData": "pagoCinco" },
                { "mData": "fechaPagoCinco" },
                { "mData": "pagoSeis" },
                { "mData": "fechaPagoSeis" },
                { "mData": "pagoSiete"},
                { "mData": "fechaPagoSiete" },
                { "mData": "pagoOcho" },
                { "mData": "fechaPagoOcho"},
                { "mData": "pagoNueve"},
                { "mData": "fechaPagoNueve"},
                { "mData": "pagoDiez"},
                { "mData": "fechaPagoDiez"},
                { "mData": "pagoOnce" },
                { "mData": "fechaPagoOnce"}
           
                
            ],
            "aaSorting": []
        } );
    });



    $(".blockui-save").click(function(){App.blockUI(),window.setTimeout(function(){App.unblockUI(".blockui-content")},2e3)});
    /*CALCULO DE CAMPO RESULADO*/
    $(".sumaR").on("keydown keyup", function() {
        calculateSum();
    });
    $(".restaR").on("keydown keyup", function() {
        calculateSum();
    });
});


function calculateSum(){
    var sum = 0;
    var sum2 = 0;
    //iterate through each textboxes and add the values
    $(".sumaR").each(function() {
        var val1 = parseFloat(this.value.replace(/[^0-9-.]/g, ''));
        //add only if the value is number
        if (!isNaN(val1) && val1.length != 0) {
            $(this).css("background-color", "transparent");
            sum += parseFloat(val1);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (val1.length != 0){
            //$(this).css("background-color", "red");
        }
    });
    $(".restaR").each(function() {
        var val2 = parseFloat(this.value.replace(/[^0-9-.]/g, ''));
        //add only if the value is number
        if (!isNaN(val2) && val2.length != 0) {
            $(this).css("background-color", "transparent");
            sum2 += parseFloat(val2);
            //$(this).css("background-color", "#FEFFB0");
        }
        else if (val2.length != 0){
            //$(this).css("background-color", "red");
        }

    });

    var total = sum - sum2;
    var bonoPresupuesto = $('#bonoPresupuesto').val();
    var bonoP = parseFloat(bonoPresupuesto.replace(/[^0-9-.]/g, ''));
    var propVenta = total - bonoP;

    if (total > 0){
        $("#resultado").val(total);
        $("#resultado").formatCurrency();
    }else{
        $("#resultado").val(parseFloat(total).toFixed(2));
    }

    if (propVenta>0){
        $("#propVenta").val(propVenta);
        $("#propVenta").formatCurrency();
    }else{
        $("#propVenta").val(parseFloat(propVenta).toFixed(2));
    }
}

