$(document).ready(function() {

    $('#sample_3').DataTable().destroy();
    // datatable
    $("#sample_3").dataTable({
        //Inicia docs y languaje
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
        },
        
        buttons: getConfigColvis("Cortes"),
        //Termina docs y languaje
        "bProcessing": true,
        "sAjaxSource": "cortes/listado",
        "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
        "sPaginationType": "full_numbers",
        "aoColumns": [
            { "mData": "id" },
            { "mData": "semana" },
            { "mData": "fechaCorte" },
            { "mData": "txtstatus" },
            { "mData": "acciones" }
        ],
        "aaSorting": []
    });
});

async function changeStatus(id,estatus){
    Swal.fire({
    title: "Desea confirmar este corte?",
    showDenyButton: true,
    confirmButtonText: "Confirmar",
    denyButtonText: `No`
    }).then(async (result) => {
    /* Read more about isConfirmed, isDenied below */
    if (result.isConfirmed) {
        App.blockUI();
        let data=await ajax("cortes/changeStatus",{"id":id,"estatus":estatus});
        location.reload();
    } else if (result.isDenied) {
        Swal.fire("No se hizo ningún cambio", "", "info");
    }
    });
}
