$(document).ready(function() {
    $('.date-picker').datepicker({todayHighlight: true});
    $("#fecha_inicio").val('');
    $("#fecha_fin").val('');

    table();
    $("#aplicar").click(function(event) {
        table();
    });

    let oTable;
    $('.page-header.navbar.navbar-fixed-top, .page-header.navbar.navbar-static-top').css('z-index','0');

    var info=new Array();
    function table(){

        const numberFormat = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
            minimumFractionDigits: 2
        });

        var cont_TotMonto=0;
        var cont_TotPagos=0;
        var cont_TotSaldo=0;

        info =
        {
            fecha_inicio : ($("#fecha_inicio").val() != "") ? $("#fecha_inicio").val() : 0,
            fecha_fin : ($("#fecha_fin").val() != "") ? $("#fecha_fin").val() : 0
        };
        $('#sample_3').DataTable().destroy();
        $('#sample_3').DataTable({
            "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "Todo"]],
            //"lengthMenu": [[-1], ["Todo"]],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
            },
            buttons: getConfigColvis("Ventas de Contado"),
            // Processing indicator
            "processing": true,
            // Load data from an Ajax source
            "ajax": {
                "url": "contado/listado/",
                "type": "POST",
                "data": {
                    "info": info
                }
            },
            "fnCreatedRow": function( nRow, aData, iDataIndex ) {

                cont_TotMonto+=($.isNumeric(aData["monto_"])) ? parseFloat(aData["monto_"]) : 0;
                cont_TotPagos+=($.isNumeric(aData["pagos_"])) ? parseFloat(aData["pagos_"]) : 0;
                cont_TotSaldo+=($.isNumeric(aData["saldo_"])) ? parseFloat(aData["saldo_"]) : 0;
            },
            "fnDrawCallback": function() {
                $("#cont_TotMonto").text(numberFormat.format(cont_TotMonto));
                $("#cont_TotPagos").text(numberFormat.format(cont_TotPagos));
                $("#cont_TotSaldo").text(numberFormat.format(cont_TotSaldo));
    
                cont_TotMonto=0;
                cont_TotPagos=0;
                cont_TotSaldo=0;
            },
            // DataTables server-side processing mode
            "serverSide": true,
            "serverMethod": "post",
            // Initial no order.
            "order": [],
            "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
            "sPaginationType": "full_numbers",
            //Set column definition initialisation properties
            "aoColumns": [
                { "mData": "acciones" },
             /*   { "mData": "id" },*/
               /* { "mData": "idAltaVenta" },*/ 
                { "mData": "monto" },
                { "mData": "pagos" },
                { "mData": "saldo" },
                { "mData": "statusCuenta" },
                { "mData": "fraccionamiento" },
                { "mData": "manzana" },
                { "mData": "lote" },
                { "mData": "nOficial" },
                { "mData": "prospecto" },
                { "mData": "nomPromotor" },
                { "mData": "prototipo" },
                { "mData": "supTerreno" },
                { "mData": "plazo" },
                { "mData": "fecha" },
            ],
            "aaSorting": []
        });
    }

    $("#idTienda").change(function (event) {
        let idSelect = $(this).attr('id');
        if($(this).val() != 0){
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'yellow' );
        }else{
            $('[aria-labelledby="select2-' + idSelect + '-container"]').css( 'background-color', 'white' );
        }
    });

    $(document).on("click", '.detalle', function (event) {
        let idTienda = ($(this).data('tienda') != "") ? $(this).data('tienda') : 0;
        let fecha_inicio = ($("#fecha_inicio").val() != "") ? $("#fecha_inicio").val() : 0;
        let fecha_fin = ($("#fecha_fin").val() != "") ? $("#fecha_fin").val() : 0;
        window.location.href="rtienda/detalle/"+idTienda+"/"+fecha_inicio+"/"+fecha_fin;
    });
    
    $(".sumar").on("keydown keyup", function() {
        calculate();
    });
    $(".restar").on("keydown keyup", function() {
        calculate();
    });
});
