$(document).ready(function() {
	//FUNCIONES DE CUENTAS POR cobrar EN EL HEADER
	$("#btn_cuentas_cobrar").click(function() {
        $.post('proveedores/get_proveedores',function(d){
            html='<option value="0" selected>Seleccione un proveedor</option>';
            for(var i = 0;i< d.length;i++){
                html += '<option value="'+ d[i].id +'">'+d[i].razon_social+'</option>';
            }
            $("#proveedor_cobrar").html(html);
        },"json");
        //Reparacion de select2 para modal
        $.fn.modal.Constructor.prototype.enforceFocus = function() {};
        $('#generar_orden_cobro').text("Generar");
        $('#generar_orden_cobro').data("id",0);
        $('#generar_orden_cobro').data("status",1);
        $("#modal_cuentas_cobrar").modal("show");
	});

    $("#area_cobrar").change(function(){
    	var area;
        var id_area = $(this).val();
        switch(id_area){
            case '1':
                area = 'rentas';
                obtener_proyecto = false;
                $('#content_proyecto_cobrar').hide('slow');
                break;
            case '2':
                area = 'documentales';
                obtener_proyecto = true;
                $('#content_proyecto_cobrar').show('slow');
                break;
            case '3':
                area = 'producciones';
                obtener_proyecto = true;
                $('#content_proyecto_cobrar').show('slow');
                break;
            case '5':
                area = 'transmisiones';
                obtener_proyecto = true;
                $('#content_proyecto_cobrar').show('slow');
                break;
            case '6':
                area = 'venta';
                obtener_proyecto = false;
                $('#content_proyecto_cobrar').hide('slow');
                break;
            case '7':
                area = 'admon';
                obtener_proyecto = false;
                $('#content_proyecto_cobrar').hide('slow');
                break;
            default:
                obtener_proyecto = false;
            break;
        }
        if(obtener_proyecto){
            $.post(area+'/get_proyectos',{id_area:id_area},function(d){
                html='<option value="0" selected>Seleccione un proyecto</option>';
                for(var i = 0;i< d.length;i++){
                    html += '<option value="'+ d[i].id +'">'+d[i].titulo+'</option>';
                }
                $("#proyecto_cobrar").html(html);
            },"json");
        }
    });

    $("#subtotal_cobrar").on("keydown keyup", function() {
       //if($.isNumeric($("#subtotal").val())){
            $("#iva_cobrar").val($("#subtotal_cobrar").val()*0.16)
            $("#total_cobrar").text("$" + (($("#subtotal_cobrar").val() * 1) + ($("#subtotal_cobrar").val()*0.16)))
            $("#monto_cobrar").val((($("#subtotal_cobrar").val() * 1) + ($("#subtotal_cobrar").val()*0.16)))
       //}
    });

    $('#generar_orden_cobro').click(function(){
        if($(this).data("status") == 1){
            generarOrden('cobrar/generar_orden',this);
        }else if($(this).data("status") == 2){
            generarOrden('cobrar/actualizar_orden',this);
        }
    });

    function generarOrden(url,context){
        var l = Ladda.create(context);
        var validation = '';
        var id = $('#generar_orden_cobro').data("id");
        var area = $('#area_cobrar').val();
        var proyecto_cobrar = $("#proyecto_cobrar").val();
        var cuenta_cobrar = $('#cuenta_cobrar').val();
        var concepto_cobrar = $('#concepto_cobrar').val();
        var monto_cobrar = $('#monto_cobrar').val();
        var num_factura = $('#num_factura_cobrar').val();
        var descripcion = $('#descripcion_cobrar').val();

        var subtotal = $('#subtotal_cobrar').val();
        var moneda = $('#moneda_cobrar').val();
        var categoria = $('#categoria_cobrar').val();
        var iva = $('#iva_cobrar').val();
        var forma_pago = $('#forma_pago_cobrar').val();
        var descripcion = $('#descripcion_cobrar').val();
        var idCliente = $("#cliente_cobrar").val();
        var idContacto = $("#cliente_cobrar option:selected").attr('data-idCliente');

        validation += (concepto_cobrar != "") ? "" : error("#content_concepto_cobrar","Es necesario ingresar el concepto");
        validation += (area!='')?"":error("#content_area_cobrar",'Es necesario seleccionar un área');
        validation += (cuenta_cobrar!='')?"":error("#content_cuenta_cobrar","Es necesario seleccionar una cuenta");
        validation += (concepto_cobrar!='')?"":error("#content_concepto_cobrar","Es necesario un concepto");
        validation += (subtotal!='')?"":error("#content_subtotal_cobrar","Es necesario el subtotal");
        validation += (moneda!='')?"":error("#content_moneda_cobrar","Es necesario una moneda");
        validation += (categoria!='')?"":error("#content_categoria_cobrar","Es necesario una categoría");
        validation += (iva!='')?"":error("#content_iva_cobrar","Es necesario el IVA");
        validation += (forma_pago!='')?"":error("#content_forma_pago_cobrar","Es necesario una forma de pago");
        //validation += (monto_cobrar!='')?"":error("#content_monto_cobrar","Es necesario un monto");
        validation += (idCliente != '')? "":error("#divcliente_cobrar","Es necesario seleccionar un cliente");
        l.start();

        if (validation == ""){
            $.ajax({
                url: url,
                type: 'POST',
                dataType: 'json',
                data: {
                    id_area: area,
                    id_proyecto: proyecto_cobrar,
                    id_cuenta: cuenta_cobrar,
                    concepto: concepto_cobrar,
                    monto:monto_cobrar,
                    num_factura:num_factura,
                    descripcion: descripcion,
                    subtotal: subtotal,
                    moneda: moneda,
                    categoria: categoria,
                    iva: iva,
                    forma_pago: forma_pago,
                    idCliente: idCliente,
                    idContacto: idContacto,
                    id: id
                },success : function(data){
                    if (data.success == true){
                        clear();
                        $('#modal_cuentas_cobrar').modal("hide");
                        window.location.reload();
                    }else{
                        alert('no se insertó');
                    }
                }
            });
        }else{
            l.stop();
        }
    }

    //Verificamos el check de inversion
    $("#inversion_cobrar").click(function() {
        if ($(this).is(':checked')){
            $(this).val(2);
        }else{
            $(this).val('');
        }
    });

    //TERMINA FUNCIONES CUENTAS POR COBRAR
});

function clear(){
    $("#area_cobrar, #proyecto_cobrar, #proveedor_cobrar, #concepto_cobrar, #monto_cobrar, #rubro_dproyecto_cobrar, #descripcion_cobrar").val("");
    $("#content_descripcion_cobrar, #content_area_cobrar, #content_proyecto_cobrar, #content_concepto_cobrar, #content_monto_cobrar").find('.help-block-error').text("");
}

function error(div, msj){
        $(div).find('.help-block-error').text(msj);
        $(div).find('.help-block-error').css({
            color: 'red'
        });
        return "error";
}

function open_modal_cobrar(){
    $("#modal_cuentas_cobrar").modal("show");
}

function edit_modal_cobrar(id){
    $('#generar_orden_cobro').data("id",id);
    $('#generar_orden_cobro').data("status",2);
    $('#generar_orden_cobro').text("Actualizar");

    $.ajax({
        url: 'cobrar/getOrden',
        type: 'POST',
        dataType: 'JSON',
        data: {
            id: id
        },success:function(data){
            var cliente=0;
            if(data.idContacto != "" && data.idContacto != 0){
                cliente=data.idContacto;
            }else{
                cliente=data.idCliente;
            }
            setValSelect("#cliente_cobrar", cliente);
            setValSelect("#area_cobrar", data.idArea);
            setValSelect("#cuenta_cobrar", data.idCuenta);
            $('#concepto_cobrar').val(data.concepto);
            $('#monto_cobrar').val(data.monto);
            $('#total_cobrar').text("$" + data.monto);
            $('#num_factura_cobrar').val(data.num_factura);
            $('#descripcion_cobrar').val(data.descripcion);

            $('#subtotal_cobrar').val(data.subtotal);
            $('#moneda_cobrar').val(data.moneda);
            $('#categoria_cobrar').val(data.categoria);
            $('#iva_cobrar').val(data.iva);
            $('#forma_pago_cobrar').val(data.forma_pago);
            //Abriendo modal
            $("#modal_cuentas_cobrar").modal("show");
            setTimeout(function(){
                setValSelect("#proyecto_cobrar", data.idProyecto);
            },2000);
        }
    });
}

function setValSelect(select, val){
    $(select).val(val);
    $(select).find('option[value="' + val + '"]').prop('selected',true);
    $(select).trigger('change');
}

var modal="#modal_cargo_cuenta_cobrar";
function cobrar(id, controlador){
    //alert(id);
    $(modal).modal("show");
    $.ajax({
        url: 'cobrar/getOrden',
        type: 'POST',
        dataType: 'JSON',
        data: {
            id: id
        },success:function(data){
            setValSelect("#cuenta", data.idCuenta);
            var html='  <tr>'+
                            '<td>'+ getArea(data.idArea) +'</td>'+
                            '<td>'+ data.concepto +'</td>'+
                            '<td>'+ data.descripcion +'</td>'+
                            '<td>'+ data.idProyecto +'</td>'+
                        '</tr>';
            $(modal).find("#total").text(data.monto);
            $(modal).data("id",data.id);
            $("#detalle_body").html(html);
        }
    });
}

$(modal).find("#cobrar").click(function(event){
    var l = Ladda.create(this);
    var validation="";
    var id=$(modal).data("id");
    var idCuenta=$(modal).find('#cuenta').val();
    var inversion_cobrar = $('#inversion_cobrar').val();
    validation += (idCuenta != '')? "":error("#content-cuenta-modal-cobrar","Es necesario seleccionar una cuenta");

    l.start();
    if(validation == ""){
        $.ajax({
            url: 'cobrar/generarCobro',
            type: 'POST',
            dataType: 'JSON',
            data: {
                id: id,
                idCuenta: idCuenta,
                inversion_cobrar:inversion_cobrar
            },success:function(data){
                window.location.reload();
            }
        });
    }else{
        l.stop();
    }
});

function getArea(estatus){
        var valor="";
        switch (estatus) {
            case "1":
                valor = 'Rentas';
                break;
            case "2":
                valor = 'Docs';
                break;
            case "3":
                valor = 'Producciones';
                break;
            case "5":
                valor = 'Transmisiones';
                break;
            case "7":
                valor = 'Administración';
                break;
            default:
                valor = '';
                break;
        }
        return valor;
}


