$(document).ready(function() {
    var info=new Array();
    table();

    $("#aplicar").click(function(event) {
        table();
    });

    //Función que generá todo las consultas con filtros del reporte
    function table(){
        //Inicializando variables
        var title="Cartas";
        var n=0;
        var filtros="";
        //Array que guarda los filtros
        info =
          {
            statusCarta: $("#statusCarta").val(),
            tipo: $("#tipo").val(),
            idUsuario: $("#idUsuario").val(),
            fecha_inicio: $("#fecha_inicio").val(),
            fecha_fin: $("#fecha_fin").val()
        };
        //Agrega texto de los filtros
        filtros="FILTROS: ";
        filtros+= ($("#statusCarta option:selected").text() != "" && $("#statusCarta option:selected").text() != "Seleccione") ? " > Estatus: "+$("#statusCarta option:selected").text() : "";
        filtros+= ($("#tipo option:selected").text() != "" && $("#tipo option:selected").text() != "Seleccione") ? " > Tipo de Activo: "+$("#tipo option:selected").text() : "";
        filtros+= ($("#idUsuario option:selected").text() != "" && $("#idUsuario option:selected").text() != "Seleccione") ? " > Usuario: "+$("#idUsuario option:selected").text() : "";
        filtros+= (info['fecha_inicio'] != "" && info['fecha_fin'] != "") ? " > Fecha inicio: "+info['fecha_inicio']+" - Fecha fin: "+info['fecha_fin'] : "";
        $("#filtros").text(filtros);

        // Armado del datatable pero primero lo destruye
        $('#sample_3').DataTable().destroy();
        $('#sample_3').each(function() {
            var oTable = $(this).dataTable( {
                //Opciones del lenguaje
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.10.13/i18n/Spanish.json"
                },
                //Opciones de exportación de datos
                buttons: getConfigColvis("Asignación de Activos"),
                //Configuración general del AJAX
                "bProcessing": true,
                "sAjaxSource": "cartas/listado",
                "sDom": "<'row'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
                "sPaginationType": "full_numbers",
                //Función que envia los filtros
                "fnServerParams": function ( aoData ) {
                     aoData.push(
                            { "name": "info", "value":  info }
                        );
                },
                //Función que recorre toda la info que se obtiene por respuesta
                "fnCreatedRow": function( nRow, aData, iDataIndex ) {
                    console.log("Process");
                },
                //Función que indica la finalización del proceso
                "fnInitComplete": function (oSettings, json) {
                    console.log("End");
                },
                //Columnas que se mostrarán en la vista
                "aoColumns": [
                    { "mData": "idActivo" },
                    { "mData": "tipoActivo" },
                    { "mData": "idUsuario" },
                    { "mData": "notas" },
                    { "mData": "fechaAsignacion" },
                    { "mData": "fechaDesasignacion" },
                    { "mData": "pdfCarta" },
                    { "mData": "statusCarta" },
                    { "mData": "acciones" }
                ],
                "aaSorting": []
            } );
        });
    }
});
