function _defaultDoc(data){
    return {
        id: data.id,
        steps: [
            {
            title: "Opciones",
            content: "Muestra las opciones de exportar a CSV y ocultar columnas de los "+plural(data.name),
            target: document.querySelector("div.actions"),
            placement: "left",
            },
            {
            title: "Nuevo",
            content: "Crea nuevo "+data.name,
            target: document.querySelector("a.btn.btn-circle.btn-default.btn-sm"),
            placement: "left",
            showPrevButton: true
            },
            {
            title: "Listado",
            content: "Muestra todos o una parte de los "+pluralizar(data.name),
            target: document.querySelector(".table-responsive"),
            placement: "top",
            showPrevButton: true
            }
        ]
    }
}

function _defaultMatDoc(data){
    return {
        id: data.id,
        steps: [
            {
            title: "Sincronizar",
            content: "Sincroniza los "+plural(data.name)+" con Microsip",
            target: document.querySelector("a#blockui_sample_4_1"),
            placement: "left",
            },
            {
            title: "Exportar Excel",
            content: "Exporta un excel con todos los "+pluralizar(data.name),
            target: document.querySelector("a.btn.btn-circle.btn-default.btn-sm"),
            placement: "left",
            showPrevButton: true
            },
            {
            title: "Listado",
            content: "Muestra todos o una parte de los "+pluralizar(data.name),
            target: document.querySelector(".table-responsive"),
            placement: "top",
            showPrevButton: true
            }
        ]
    }
}
let _catalogo="Selecciona tu %i del catálogo de %c";
let _titulo="Ingresa un titulo para tu %m";
let _guardar="Presione %i para guardar su %m";
function _newPptoObra(data){
    return {
        id: data.id,
        steps: [
            {
            title: "Fraccionamiento",
            content: _catalogo.replace('%i','fraccionamiento').replace('%c','fraccionamientos'),
            target: document.querySelector("#idFraccionamiento"),
            placement: "top",
            showPrevButton: true
            },
            {
            title: "Prototipo",
            content: _catalogo.replace('%i','prototipo').replace('%c','prototipos'),
            target: document.querySelector("#idPrototipo"),
            placement: "top",
            showPrevButton: true
            },
            {
            title: "Titulo",
            content: _titulo.replace('%m',data.name),
            target: document.querySelector("#titulo"),
            placement: "top",
            showPrevButton: true
            },
            {
            title: "Continuar",
            content: _guardar.replace('%i','Continuar').replace('%m',data.name),
            target: document.querySelector("button.btn.blue.blockui-save.btn-circle"),
            placement: "left",
            showPrevButton: true
            }
        ]
    }
}
