<?php

    class Mpaquete extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "paquetes";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".titulo
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idPrototipo
            ,".$this->alias.".idManoObra
            ,".$this->alias.".idConstructor
            ,".$this->alias.".idResidentes
            ,".$this->alias.".manzana
            ,".$this->alias.".rango_lotes
            ,".$this->alias.".porcentaje_retencion
            ,".$this->alias.".anticipo
            ,".$this->alias.".fecha_inicio
            ,".$this->alias.".fecha_fin
            ,".$this->alias.".carta
            ,".$this->alias.".statusPaquete
            ,".$this->alias.".fecha_inicio_real
            ,".$this->alias.".pdf
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'titulo' => '',
                'idFraccionamiento' => '',
                'idPrototipo' => '',
                'idManoObra' => '',
                'idConstructor' => '',
                'idResidentes' => '',
                'manzana' => '',
                'rango_lotes' => '',
                'porcentaje_retencion' => '',
                'anticipo' => '',
                'fecha_inicio' => '',
                'fecha_fin' => '',
                'carta' => '',
                'statusPaquete' => '',
                'fecha_inicio_real' => '',
                'pdf' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['titulo'] = $r->row()->titulo;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idPrototipo'] = $r->row()->idPrototipo;
                $array['idManoObra'] = $r->row()->idManoObra;
                $array['idConstructor'] = $r->row()->idConstructor;
                $array['idResidentes'] = $r->row()->idResidentes;
                $array['manzana'] = $r->row()->manzana;
                $array['rango_lotes'] = $r->row()->rango_lotes;
                $array['porcentaje_retencion'] = $r->row()->porcentaje_retencion;
                $array['anticipo'] = $r->row()->anticipo;
                $array['fecha_inicio'] = $r->row()->fecha_inicio;
                $array['fecha_fin'] = $r->row()->fecha_fin;
                $array['carta'] = $r->row()->carta;
                $array['statusPaquete'] = $r->row()->statusPaquete;
                $array['fecha_inicio_real'] = $r->row()->fecha_inicio_real;
                $array['pdf'] = $r->row()->pdf;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdFraccionamientoPrototipo($idFraccionamiento, $idPrototipo)
        {
            $this->db->select($this->selectDefault, FALSE);
            $arrayWhere = array($this->alias . '.idFraccionamiento' => $idFraccionamiento, $this->alias . '.idPrototipo' => $idPrototipo);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getByIdResidente($idResidentes)
        {
            $this->db->select($this->selectDefault, FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $arrayWhere = array('dp.idResidente' => $idResidentes);
            $this->db->join('detalle_paquete AS dp', 'dp.idPaquete = ' . $this->alias . '.id');
            $this->db->where($arrayWhere);
            $this->db->group_by($this->alias . '.id');
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getByIdManoObra($idManoObra){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $arrayWhere = array($this->alias.'.idManoObra' => $idManoObra);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
    }