<?php

    class Mfotosvivienda extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "fotosvivienda";
            $this->alias = 'fv';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idSupercategoria
            ,".$this->alias.".idProyecto
            ,".$this->alias.".tipo
            ,".$this->alias.".foto
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idSupercategoria' => '',
                'idProyecto' => '',
                'tipo' => '',
                'foto' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idSupercategoria'] = $r->row()->idSupercategoria;
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['tipo'] = $r->row()->tipo;
                $array['foto'] = $r->row()->foto;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        
        function getAllByIdProyIdSuperC($idProyecto, $idSupercategoria, $count = false){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true, $this->alias.'.idProyecto' => $idProyecto, $this->alias.'.idSupercategoria' => $idSupercategoria);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                if( $count ){
                    return $query->num_rows();
                }else{
                    return $query;
                }
            }
            else{
                return 0;
            }
        }
    }