<?php

    class Mdetallepaquete extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "detalle_paquete";
            $this->alias = 'd';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idProyecto
            ,".$this->alias.".idResidente
            ,".$this->alias.".rango_lotes
            ,".$this->alias.".statusAsignado
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

            $this->selectDefault2 = "".
                $this->alias.".id
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idProyecto
            ,(SELECT lote FROM proyectos WHERE id = ".$this->alias.".idProyecto) AS titulo
            ,".$this->alias.".idResidente
            ,".$this->alias.".rango_lotes
            ,".$this->alias.".statusAsignado
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPaquete' => '',
                'idProyecto' => '',
                'idResidente' => '',
                'rango_lotes' => '',
                'statusAsignado' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['idResidente'] = $r->row()->idResidente;
                $array['rango_lotes'] = $r->row()->rango_lotes;
                $array['statusAsignado'] = $r->row()->statusAsignado;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPaqueteIdProyecto($idPaquete, $idProyecto){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete, $this->alias.'.idProyecto' => $idProyecto);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getByIdResidente($idPaquete, $idResidente){
            $this->db->select($this->selectDefault2,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete, $this->alias.'.idResidente' => $idResidente);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getResidentesByIdPaquete($idPaquete){
            $this->db->select($this->alias.'.idResidente',FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $this->db->group_by("idResidente");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }
    }