<?php
    class Mavanceobra extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "avanceobra";
            $this->alias = 'a';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idEstimado
            ,".$this->alias.".lotes
            ,".$this->alias.".dia_lotes
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }


        // Populate values
        private function _populateValues($r){
            $array = array(
                'id' => '',
                'idEstimado' => '',
                'lotes' => '',
                'dia_lotes' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idEstimado'] = $r->row()->idEstimado;
                $array['lotes'] = $r->row()->lotes;
                $array['dia_lotes'] = $r->row()->dia_lotes;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getByIdEstimado($idEstimado){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idEstimado' => $idEstimado);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getIdsByIdPresupuesto($idPresupuesto){
            $this->db->select($this->alias . '.id',FALSE);
            $arrayWhere = $this->alias . '.idEstimado IN(SELECT e.id FROM estimados_programa as e WHERE e.idPresupuesto = '. $idPresupuesto . ')';
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllByIdPresuSinIdEstiLikeLt($idPresupuesto, $idEstimaciones, $lt){
            $this->db->select($this->alias . '.id,'.$this->alias.'.lotes',FALSE);
            $arrayWhere = $this->alias . ".idEstimado IN(SELECT e.id FROM estimados_programa as e WHERE e.idPresupuesto = " . $idPresupuesto . " AND e.idEstimaciones != " . $idEstimaciones . ") AND " . $this->alias . ".lotes LIKE '%" . $lt . "%'";
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllLotesByIdPresupuesto($idPresupuesto){
            $this->db->select($this->alias . '.lotes',FALSE);
            $arrayWhere = $this->alias . ".idEstimado IN(SELECT e.id FROM estimados_programa as e WHERE e.idPresupuesto = " . $idPresupuesto . ") AND " . $this->alias . ".lotes IS NOT NULL";
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }