<?php
class Musuario extends MY_Model{

	public function __construct(){
		parent :: __construct();
		$this->table = "usuarios";
        $this->alias = 'u';

        $this->selectDefault = "".
            $this->alias.".id
        ,".$this->alias.".rol
        ,".$this->alias.".usuario
        ,".$this->alias.".password
        ,".$this->alias.".nombre
        ,".$this->alias.".apellidoP
        ,".$this->alias.".apellidoM
        ,CONCAT(".$this->alias.".nombre,' ',".$this->alias.".apellidoP,' ',".$this->alias.".apellidoM) as titulo
        ,".$this->alias.".email
        ,".$this->alias.".rfc
        ,".$this->alias.".curp
        ,".$this->alias.".calle
        ,".$this->alias.".colonia
        ,".$this->alias.".ciudad
        ,".$this->alias.".telFijo
        ,".$this->alias.".celular
        ,".$this->alias.".tipoPromotor
        ,".$this->alias.".comision
        ,".$this->alias.".fechaIngreso
        ,".$this->alias.".motivoBaja
        ,".$this->alias.".statusBaja
        ,".$this->alias.".created_by
        ,".$this->alias.".status
        ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

        $this->SelectResult = "".
        $this->alias.".id,"
        ."CONCAT(".$this->alias.".nombre,' ',".$this->alias.".apellidoP) as titulo";


	}

    private function _populateValues($r)
    {
        $array = array(
            'id' => '',
            'rol' => '',
            'usuario' => '',
            'password' => '',
            'nombre' => '',
            'apellidoP' => '',
            'apellidoM' => '',
            'email' => '',
            'rfc' => '',
            'curp' => '',
            'calle' => '',
            'colonia' => '',
            'ciudad' => '',
            'fijo' => '',
            'celular' => '',
            'tipo' => '',
            'comision' => '',
            'fechaIngreso' => '',
            'motivoBaja' => '',
            'statusBaja' => '',
            'created_by' => '',
            'status' => '',
            'txtstatus' => ''
        );

        if (!is_numeric($r)) {
            $array['id'] = $r->row()->id;
            $array['rol'] = $r->row()->rol;
            $array['usuario'] = $r->row()->usuario;
            $array['password'] = $r->row()->password;
            $array['nombre'] = $r->row()->nombre;
            $array['apellidoP'] = $r->row()->apellidoP;
            $array['apellidoM'] = $r->row()->apellidoM;
            $array['email'] = $r->row()->email;
            $array['rfc'] = $r->row()->rfc;
            $array['curp'] = $r->row()->curp;
            $array['calle'] = $r->row()->calle;
            $array['colonia'] = $r->row()->colonia;
            $array['ciudad'] = $r->row()->ciudad;
            $array['telFijo'] = $r->row()->telFijo;
            $array['celular'] = $r->row()->celular;
            $array['tipoPromotor'] = $r->row()->tipoPromotor;
            $array['comision'] = $r->row()->comision;
            $array['fechaIngreso'] = $r->row()->fechaIngreso;
            $array['motivoBaja'] = $r->row()->motivoBaja;
            $array['statusBaja'] = $r->row()->statusBaja;
            $array['created_by'] = $r->row()->created_by;
            $array['status'] = $r->row()->status;
            $array['txtstatus'] = $r->row()->txtstatus;

        }
            $array['msg'] = '';
        return $array;
    }

	public function checkUser($u,$p){
		return $this->db->query("
        SELECT u.id
            ,u.status
            ,u.email
            ,u.rol
        FROM ".$this->table." AS u
        WHERE u.email = '".$u."'
        OR u.usuario = '".$u."'
        AND u.password = '".$p."'
        AND (u.rol = 1 OR u.rol = 5 OR u.rol = 9 OR u.rol = 14)
		");
	}

    public function chekEmail($email){
        $q = $this->db->query("
        SELECT u.id
        ,u.email
            ,u.status
            ,u.usuario
        FROM ".$this->table." AS u
        WHERE u.email = '".$email."'
        ");
        if ($q->num_rows() > 0){
            return $q->row()->id;
        } else {
            return 0;
        }
    }

    public function chekEmailAndUser($email,$user=''){
        $q = $this->db->query("
        SELECT u.id
        ,u.email
            ,u.status
            ,u.usuario
        FROM ".$this->table." AS u
        WHERE u.email = '".$email."'
        OR u.usuario = '".$user."'
        ");
        if ($q->num_rows() > 0){
            return $q->row()->id;
        } else {
            return 0;
        }
    }

    function getGerente(){
       $query = $this->db->query("SELECT u.id FROM usuarios AS u, fraccionamientosxusuarios as fxu WHERE idUsuario=u.id AND u.status = 1 AND u.rol=4 AND idFraccionamiento=".$_SESSION["viv"]["idFraccionamiento"]);
        if($query->num_rows() > 0){
            $query=$query->row();
            return $query->id;
        }else{
            return 0;
        }
    }

    function getGerente2($id=null){
       $query = $this->db->query("SELECT u.id FROM usuarios AS u, fraccionamientosxusuarios as fxu WHERE idUsuario=u.id AND u.status = 1 AND u.rol=4 AND idFraccionamiento=".$id);
        if($query->num_rows() > 0){
            $query=$query->row();
            return $query->id;
        }else{
            return 0;
        }
    }

    function getList(){
        $this->db->select("id, usuario, rol, IF(status > 0,'Activo','Inactivo') AS txtstatus",FALSE);
        $arrayWhere = array('status' => true);
        $this->db->where($arrayWhere);
        $this->db->group_by(array("id"));
        $this->db->order_by("usuario", "desc");
        $query = $this->db->get($this->table);
        return $query;
    }

	function getById($id){
        $this->db->select($this->selectDefault, FALSE);
        $arrayWhere = array($this->alias.'.id' => $id);
        $this->db->where($arrayWhere);
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
             return $this->_populateValues($query);
        }
        else {
            return 0;
        }
	}

    function getByRol($rol){
        $this->db->select($this->selectDefault, FALSE);
        $arrayWhere = array($this->alias.'.rol' => $rol);
        $this->db->where($arrayWhere);
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
             return $$query;
        }
        else {
            return 0;
        }
    }

    function getNombre(){
        $this->db->select("id, nombre, apellidoP, apellidoM",FALSE);
        $arrayWhere = array('status' => true);
        $this->db->where($arrayWhere);
        $this->db->group_by(array("id"));
        $this->db->order_by("usuario", "desc");
        $query = $this->db->get($this->table);
        if($query->num_rows()>0){
            $nombre = $query->row()->nombre;
            $apellidoPaterno = $query->row()->apellidoPaterno;
            $apellidoMaterno = $query->row()->apellidoMaterno;
            $usuario = $nombre." ".$apellidoPaterno." ".$apellidoMaterno;
            return $usuario;
        }
        return '';
    }

    function getAll($activosInactivos=false){
        $this->db->select($this->selectDefault,FALSE);
        $arrayWhere = array($this->alias.'.status' => true);
        if ($activosInactivos==false){
           $this->db->where($arrayWhere);
        }        
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getForActivo(){ //query para obtener todos los usuarios a quienes se les asinarán activos del sistema sin incluir administradores 
        $this->db->select($this->selectDefault,FALSE);
        $arrayWhere = array($this->alias.'.status' => true);
        //$this->db->where($arrayWhere);
        $this->db->where($this->alias.'.rol !=',1);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getPromotores(){
        $id=$_SESSION['viv']['id'];
        $idFraccionamiento=$_SESSION['viv']['idFraccionamiento'];
        $query="";
        $rol=$_SESSION['viv']['rol'];
        if($rol == 4){
            $query = $this->db->query("SELECT * FROM usuarios WHERE rol=2 AND created_by LIKE '%$id%' AND id IN (SELECT idUsuario FROM fraccionamientosxusuarios) ORDER BY id DESC");
        }else{
            $query = $this->db->query("SELECT * FROM usuarios WHERE rol=2 AND id IN (SELECT idUsuario FROM fraccionamientosxusuarios) ORDER BY id DESC");
        }
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getPromotoresBySelectResult(){
        $this->db->select($this->SelectResult,FALSE);
        // $arrayWhere = array($this->alias.'.rol' => 2, $this->alias.'.status' => true, $this->alias.'.created_by' => $_SESSION[$this->nsession]['id']);
        $arrayWhere = array($this->alias.'.rol' => 2, $this->alias.'.status' => true, 'fxu.idFraccionamiento' => $_SESSION[$this->nsession]['idFraccionamiento']);
        $this->db->where($arrayWhere);
        $id=$_SESSION[$this->nsession]['id'];
        if ( $_SESSION[$this->nsession]['rol'] == 4 ) {
            $this->db->like($this->alias.'.created_by', '%$id%');
        }
        if ( $_SESSION[$this->nsession]['rol'] == 2 ) {
            $this->db->where($this->alias.'.id', $_SESSION[$this->nsession]['id']);
        }
        $this->db->join("fraccionamientosxusuarios fxu", "fxu.idUsuario=u.id");
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getPromotoresBySelectResult2($id){
        $this->db->select($this->SelectResult,FALSE);
        // $arrayWhere = array($this->alias.'.rol' => 2, $this->alias.'.status' => true, $this->alias.'.created_by' => $_SESSION[$this->nsession]['id']);
        $arrayWhere = array($this->alias.'.rol' => 2, $this->alias.'.status' => true, 'fxu.idFraccionamiento' => $id);
        $this->db->where($arrayWhere);
        $id=$_SESSION[$this->nsession]['id'];
        if ( $_SESSION[$this->nsession]['rol'] == 4 ) {
            $this->db->like($this->alias.'.created_by', $id,'both');
        }
        if ( $_SESSION[$this->nsession]['rol'] == 2 ) {
            $this->db->where($this->alias.'.id', $_SESSION[$this->nsession]['id']);
        }
        $this->db->join("fraccionamientosxusuarios fxu", "fxu.idUsuario=u.id");
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getBestPromedioPromotoresByIdF($id = null){
            $query = $this->db->query(
                "
                SELECT idPromotor AS id, (SELECT CONCAT(nombre,' ',apellidoP) FROM usuarios WHERE id=idPromotor) titulo,(SUM(tiempo) / COUNT(idPromotor)) promedio FROM prospectos WHERE idFraccionamiento = $id GROUP BY idPromotor ORDER BY promedio ASC 
                "
            );
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }


    function getPromotoresBySelectResultAll(){//para tomar promotores al no existir un fraccinamiento en la BD
        $this->db->select($this->SelectResult,FALSE);
        $arrayWhere = array($this->alias.'.rol' => 2, $this->alias.'.status' => true);
        $this->db->where($arrayWhere);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }
    
    function getTecnicaBySelectResult(){
        $this->db->select($this->SelectResult,FALSE);
        $arrayWhere = array($this->alias.'.rol' => 5, $this->alias.'.status' => true);
        $this->db->where($arrayWhere);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getGteVBySelectResult(){ //Gte. Ventas
        $this->db->select($this->SelectResult,FALSE);
        $arrayWhere = array($this->alias.'.rol' => 4, $this->alias.'.status' => true);
        $this->db->where($arrayWhere);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getGestoriaBySelectResult(){
        $this->db->select($this->SelectResult,FALSE);
        $arrayWhere = array($this->alias.'.rol' => 3, $this->alias.'.status' => true);
        $this->db->where($arrayWhere);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getPostventaBySelectResult(){
        $this->db->select($this->SelectResult,FALSE);
        $arrayWhere = array($this->alias.'.rol' => 6, $this->alias.'.status' => true);
        $this->db->where($arrayWhere);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getContabilidadBySelectResult(){
        $this->db->select($this->SelectResult,FALSE);
        $arrayWhere = array($this->alias.'.rol' => 7, $this->alias.'.status' => true);
        $this->db->where($arrayWhere);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getMercaBySelectResult(){
        $this->db->select($this->SelectResult,FALSE);
        $arrayWhere = array($this->alias.'.rol' => 8, $this->alias.'.status' => true);
        $this->db->where($arrayWhere);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getResidenteObraBySelectResult(){
        $this->db->select($this->SelectResult,FALSE);
        $arrayWhere = array($this->alias.'.rol' => 9, $this->alias.'.status' => true);
        $this->db->where($arrayWhere);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    //Uso en blackboard
    function getEmails($ids){
        $this->db->select($this->alias.".email", FALSE);
        if (count($ids)>0){
            $this->db->where_in($this->alias.".id",$ids);
        }else{
            $this->db->where($this->alias.".id",$ids);
        }
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
             return $query;
        }
        else {
            return 0;
        }
    }
    function getEmailLike($ids){
        $this->db->select($this->alias.".nombre,".$this->alias.".apellidoP,".$this->alias.".email", FALSE);

        $this->db->where_in($this->alias.".id",$ids);

        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
             return $query;
        }
        else {
            return 0;
        }
    }
    function getDelegadosBlackboard($ids=null){
        $this->db->select($this->SelectResult,FALSE);
        $arrayWhere = array($this->alias.'.status' => true);
        $this->db->where_in($this->alias.".id",$ids);
        $this->db->order_by($this->alias.'.id', "desc");
        $query = $this->db->get($this->table.' AS '.$this->alias);
        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }

    function getFraccionamientos(){
        $rol=$_SESSION["viv"]["rol"];
        $id=$_SESSION["viv"]["id"];

        $query="SELECT * FROM fraccionamientos WHERE status=1 ";
        if($rol != 1){
            $query.="AND id IN (SELECT idFraccionamiento FROM fraccionamientosxusuarios WHERE idUsuario=$id)";
        }
        $query=$this->db->query($query);

        if($query->num_rows()>0){
            return $query;
        }else{
            return 0;
        }
    }


}