<?php

    class Mpresupuestomo extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "presupuesto_mo";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idManoObra
            ,".$this->alias.".idActividadPrototipo
            ,".$this->alias.".precioUnitario
            ,".$this->alias.".importe
            ,".$this->alias.".pctjeActividad
            ,".$this->alias.".lotesCompletados
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idManoObra' => '',
                'idActividadPrototipo' => '',
                'precioUnitario' => '',
                'importe' => '',
                'pctjeActividad' => '',
                'lotesCompletados' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idManoObra'] = $r->row()->idManoObra;
                $array['idActividadPrototipo'] = $r->row()->idActividadPrototipo;
                $array['precioUnitario'] = $r->row()->precioUnitario;
                $array['importe'] = $r->row()->importe;
                $array['pctjeActividad'] = $r->row()->pctjeActividad;
                $array['lotesCompletados'] = $r->row()->lotesCompletados;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getSumTotalUnitario($idManoObra){
            $this->db->select_sum($this->alias.'.precioUnitario');
            $arrayWhere = array($this->alias.'.idManoObra' => $idManoObra);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->row()->precioUnitario > 0){
                return $query->row()->precioUnitario;
            }else{
                return 0;
            }
        }

        function getByidManoObraIdActividadPrototipo($idManoObra, $idActProt){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idManoObra' => $idManoObra,
                $this->alias.'.idActividadPrototipo' => $idActProt);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdManoObra($idManoObra){
            $this->db->select($this->selectDefault, FALSE);
            $arrayWhere = array($this->alias . '.idManoObra' => $idManoObra);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias . '.id', "asc");
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }
    }