<?php

    class Mpaquetepresupuesto extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "paquete_presupuesto";
            $this->alias = 'pp';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idPresupuestoMO
            ,".$this->alias.".lotesCompletados
            ,".$this->alias.".lotes
            ,".$this->alias.".acumulado
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPaquete' => '',
                'idPresupuestoMO' => '',
                'lotesCompletados' => '',
                'lotes' => '',
                'acumulado' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['idPresupuestoMO'] = $r->row()->idPresupuestoMO;
                $array['lotesCompletados'] = $r->row()->lotesCompletados;
                $array['lotes'] = $r->row()->lotes;
                $array['acumulado'] = $r->row()->acumulado;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPaqueteIdPresupuesto($idPaquete, $idPresupuestoMO){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete, $this->alias.'.idPresupuestoMO' => $idPresupuestoMO, $this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdPaquete($idPaquete){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPaquete' => $idPaquete);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        public function getCantidadesByIdAvance($idAvance=0,$lt=0,$mza=0){
            $query="SELECT act.cantidad, ppto.acumulado FROM avanceobra ao LEFT JOIN estimados_programa dos ON dos.id=ao.idEstimado LEFT JOIN 
            estimaciones_programa ones ON ones.id=dos.idEstimaciones LEFT JOIN estimacion_programa ion ON ion.id=ones.idEstimacion LEFT JOIN paquete_presupuesto ppto 
            ON ppto.idPresupuestoMO AND ppto.idPresupuestoMO=dos.idPresupuesto AND ppto.idPaquete=ion.idPaquete LEFT JOIN presupuesto_mo pmo ON pmo.id=dos.idPresupuesto
            LEFT JOIN actividadesprototipo act ON act.id=pmo.idActividadPrototipo WHERE ao.id=$idAvance
            ";
            $query=$this->db->query($query);

            if($query->num_rows() > 0){
                $res["cantidad"]=$query->row()->cantidad;
                //validacion de no existentes
                $acumulado=($query->row()->acumulado) ? json_decode($query->row()->acumulado,true) : [];
                //calculo de cantidades
                $keyAc=array_search($lt.'/'.$mza, array_column($acumulado, 'lote'));
                $res["acumulado"]=(is_numeric($keyAc)) ? $acumulado[$keyAc]['avance'] : 0;
                return $res;
            }else{
                return 0;
            }
        }
    }