<?php
    class Mestimados extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "estimados_programa";
            $this->alias = 'e';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idPresupuesto
            ,".$this->alias.".idEstimaciones
            ,".$this->alias.".estimacion
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idPresupuesto' => '',
                'idEstimaciones' => '',
                'estimacion' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idPresupuesto'] = $r->row()->idPresupuesto;
                $array['idEstimaciones'] = $r->row()->idEstimaciones;
                $array['estimacion'] = $r->row()->estimacion;
                $array['status'] = $r->row()->status;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getAllByIdPresupuesto($idPresupuesto){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPresupuesto' => $idPresupuesto);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAllByIdEstimaciones($idEstimaciones){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idEstimaciones' => $idEstimaciones);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getLotesGuardados($idPresupuesto){
            $this->db->select($this->alias.'.estimacion');
            $arrayWhere = array($this->alias.'.idPresupuesto' => $idPresupuesto);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByIdPresupuestoAndIdEstimaciones($idPresupuesto, $idEstimaciones){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idPresupuesto' => $idPresupuesto, $this->alias.'.idEstimaciones' => $idEstimaciones);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }
    }