<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');
// Validation default parameters
$config = array(
    // Fraccionamientos
    'fraccionamientos' => array(
        array(
            'field' => 'titulo',
            'label' => 'Título',
            'rules' => 'required'
        ),
        array(
            'field' => 'personal[]',
            'label' => 'Éste Personal',
            'rules' => 'trim'
        )

    ),
    // Categoría
    'cartas' => array(
        array(
            'field' => 'idActivo',
            'label' => 'Activo',
            'rules' => 'required'
        ),
        array(
            'field' => 'notas',
            'label' => 'Notas',
            'rules' => 'trim'
        ),
        array(
            'field' => 'idUsuario',
            'label' => 'Usuario',
            'rules' => 'required'
        )
    ),
    // Categoría
    'categoria' => array(
        array(
            'field' => 'titulo',
            'label' => 'Título',
            'rules' => 'required'
        )
    ),
    // Lugares Prospección
    'lugares_prospeccion' => array(
        array(
            'field' => 'titulo',
            'label' => 'Título',
            'rules' => 'required'
        )
    ),
    // Vehículos
    'vehiculos' => array(
        array(
            'field' => 'marca',
            'label' => 'Marca',
            'rules' => 'required'
        ),
        array(
            'field' => 'serie',
            'label' => '# Serie',
            'rules' => 'required'
        ),
        array(
            'field' => 'anio',
            'label' => 'Año',
            'rules' => 'required'
        ),
        array(
            'field' => 'vigenciaPoliza',
            'label' => 'Vigencia de Poliza',
            'rules' => 'required'
        ),
        array(
            'field' => 'modelo',
            'label' => 'Modelo',
            'rules' => 'required'
        ),
        array(
            'field' => 'inventarioInterno',
            'label' => 'Inventario Interno',
            'rules' => 'required'
        ),
        array(
            'field' => 'placas',
            'label' => 'Placas',
            'rules' => 'required'
        ),
        array(
            'field' => 'diasMantenimiento',
            'label' => 'Días de Mantenimiento',
            'rules' => 'required'
        )
    ),
    // Electronica
    'electronica' => array(
        array(
            'field' => 'marca',
            'label' => 'Marca',
            'rules' => 'required'
        ),
        array(
            'field' => 'serie',
            'label' => '# Serie',
            'rules' => 'required'
        ),
        array(
            'field' => 'accesorios',
            'label' => 'Accesorios',
            'rules' => 'required'
        ),
        array(
            'field' => 'modelo',
            'label' => 'Modelo',
            'rules' => 'required'
        ),
        array(
            'field' => 'inventarioInterno',
            'label' => 'Inventario Interno',
            'rules' => 'required'
        ),
        array(
            'field' => 'idCategoria',
            'label' => 'Categoría',
            'rules' => 'required'
        )
    ),
    // Mobiliario
    'mobiliario' => array(
        array(
            'field' => 'descripcion',
            'label' => 'Descripción',
            'rules' => 'required'
        ),
        array(
            'field' => 'inventarioInterno',
            'label' => 'Inventario Interno',
            'rules' => 'required'
        )
    ),
    // otros
    'otros' => array(
        array(
            'field' => 'descripcion',
            'label' => 'Descripción',
            'rules' => 'required'
        ),
        array(
            'field' => 'serie',
            'label' => 'Serie',
            'rules' => 'required'
        ),
        array(
            'field' => 'inventarioInterno',
            'label' => 'Inventario Interno',
            'rules' => 'required'
        )
    ),
    // Proyectos
    'proyectos' => array(
        array(
            'field' => 'idFraccionamiento',
            'label' => 'Fraccionamiento',
            'rules' => 'required'
        ),
        array(
            'field' => 'lote',
            'label' => 'Lote',
            'rules' => 'required'
        ),
        array(
            'field' => 'manzana',
            'label' => 'Manzana',
            'rules' => 'trim'
        ),
        array(
            'field' => 'calle',
            'label' => 'Calle',
            'rules' => 'trim'
        ),
        array(
            'field' => 'nOficial',
            'label' => 'N Oficial',
            'rules' => 'trim'
        ),
        array(
            'field' => 'cuv',
            'label' => 'CUV',
            'rules' => 'trim'
        ),
        array(
            'field' => 'claveCatastral',
            'label' => 'Clave Catastral',
            'rules' => 'trim'
        ),
        array(
            'field' => 'supTerreno',
            'label' => 'Superficie Terreno',
            'rules' => 'trim'
        ),
        array(
            'field' => 'supConstruccion',
            'label' => 'Superficie Construcción',
            'rules' => 'trim'
        ),
        array(
            'field' => 'idPrototipo',
            'label' => 'Prototipo',
            'rules' => 'trim'
        ),
        array(
            'field' => 'precioVenta',
            'label' => 'Precio Venta',
            'rules' => 'trim|validateInt'
        ),
        array(
            'field' => 'statusProyecto',
            'label' => 'Estatus Proyecto',
            'rules' => 'trim'
        ),
        array(
            'field' => 'puntaje',
            'label' => 'Puntaje',
            'rules' => 'trim'
        ),
        array(
            'field' => 'porcentajeAvance',
            'label' => 'Porcentaje Avance',
            'rules' => 'trim|numeric'
        ),
        array(
            'field' => 'contratista',
            'label' => 'Contratista',
            'rules' => 'trim'
        ),
        array(
            'field' => 'avaluo',
            'label' => 'Avaluo',
            'rules' => 'trim|validateInt'
        ),
        array(
            'field' => 'unidadVerificadora',
            'label' => 'Unidad Verificadora',
            'rules' => 'trim'
        ),
        array(
            'field' => 'lineaCredito',
            'label' => 'Línea de Crédito',
            'rules' => 'trim'
        ),
        array(
            'field' => 'tipoVialidad',
            'label' => 'Tipo de vialidad',
            'rules' => 'trim'
        ),
        array(
            'field' => 'nombreVialidad',
            'label' => 'Nombre de vialidad',
            'rules' => 'trim'
        ),
        array(
            'field' => 'nivel',
            'label' => 'Nivel',
            'rules' => 'trim'
        ),
        array(
            'field' => 'estacionamiento',
            'label' => 'Estacionamiento',
            'rules' => 'trim'
        ),
        array(
            'field' => 'tipoPrimeraVialidad',
            'label' => 'Tipo de vialidad',
            'rules' => 'trim'
        ),
        array(
            'field' => 'primeraEntreVialidad',
            'label' => 'Nombre de vialidad',
            'rules' => 'trim'
        ),
        array(
            'field' => 'tipoSegundaVialidad',
            'label' => 'Tipo de vialidad',
            'rules' => 'trim'
        ),
        array(
            'field' => 'segundaEntreVialidad',
            'label' => 'Nombre de vialidad',
            'rules' => 'trim'
        ),
        array(
            'field' => 'tipoVialidadPosterior',
            'label' => 'Tipo de vialidad',
            'rules' => 'trim'
        ),
        array(
            'field' => 'nombreVialidadPosterior',
            'label' => 'Nombre de vialidad',
            'rules' => 'trim'
        ),
        array(
            'field' => 'metrosFrente',
            'label' => 'Metros de frente',
            'rules' => 'trim'
        ),
        array(
            'field' => 'orientacion',
            'label' => 'Orientacion',
            'rules' => 'trim'
        )

    ),
    /* usuarios*/
    'usuarios' => array(
        array(
            'field' => 'rol',
            'label' => 'Rol',
            'rules' => 'required'
        ),
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'required'
        ),
        array(
            'field' => 'apellidoP',
            'label' => 'Apellido Paterno',
            'rules' => 'required'
        ),
        array(
            'field' => 'apellidoM',
            'label' => 'Apellido Materno',
            'rules' => 'trim'
        ),
        array(
            'field' => 'usuario',
            'label' => 'Usuario',
            'rules' => 'required|min_length[3]'
        ),
        array(
            'field' => 'password',
            'label' => 'Password',
            'rules' => 'required|min_length[3]'
        ),
        array(
            'field'   => 'password_2',
            'label'   => 'Confirmar Password',
            'rules'   => 'trim|required|matches[password]|min_length[3]'
        ),
        array(
            'field' => 'email',
            'label' => 'Email',
            'rules' => 'required|valid_email'
        ),
        array(
            'field' => 'rfc',
            'label' => 'RFC',
            'rules' => 'trim'
        ),
        array(
            'field' => 'curp',
            'label' => 'CURP',
            'rules' => 'trim'
        ),
        array(
            'field' => 'calle',
            'label' => 'Calle',
            'rules' => 'trim'
        ),
        array(
            'field' => 'colonia',
            'label' => 'Colonia',
            'rules' => 'trim'
        ),
        array(
            'field' => 'ciudad',
            'label' => 'Ciudad',
            'rules' => 'trim'
        ),
        array(
            'field' => 'telFijo',
            'label' => 'Teléfono Fijo',
            'rules' => 'trim'
        ),
        array(
            'field' => 'celular',
            'label' => 'Celular',
            'rules' => 'trim'
        ),
        array(
            'field' => 'tipoPromotor',
            'label' => 'Tipo de Promotor',
            'rules' => 'trim'
        ),
        array(
            'field' => 'comision',
            'label' => 'Comisión',
            'rules' => 'trim'
        )
    ),
    'usuarios_editar' => array(
        array(
            'field' => 'rol',
            'label' => 'Rol',
            'rules' => 'required'
        ),
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'required'
        ),
        array(
            'field' => 'usuario',
            'label' => 'Usuario',
            'rules' => 'required'
        ),
        array(
            'field' => 'password',
            'label' => 'Password',
            'rules' => 'trim'
        ),
        array(
            'field'   => 'password_2',
            'label'   => 'Confirmar Password',
            'rules'   => 'trim'
        ),
        array(
            'field' => 'email',
            'label' => 'Email',
            'rules' => 'required|valid_email'
        )
    ),
    'usuarios_externos' => array(
        array(
            'field' => 'rol',
            'label' => 'Rol',
            'rules' => 'required'
        ),
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'required'
        ),
        array(
            'field' => 'usuario',
            'label' => 'Usuario',
            'rules' => 'trim'
        ),
        array(
            'field' => 'password',
            'label' => 'Password',
            'rules' => 'trim'
        ),
        array(
            'field'   => 'password_2',
            'label'   => 'Confirmar Password',
            'rules'   => 'trim'
        ),
        array(
            'field' => 'email',
            'label' => 'Email',
            'rules' => 'trim|valid_email'
        )
    ),
    'prospectos' => array(
        array(
            'field' => 'idFraccionamiento',
            'label' => 'Fraccionamiento',
            'rules' => 'required'
        ),
        array(
            'field' => 'idPromotor',
            'label' => 'Promotor',
            'rules' => 'required'
        ),
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'required'
        ),
        array(
            'field' => 'apellidoP',
            'label' => 'Apellido Paterno',
            'rules' => 'required'
        ),
        array(
            'field' => 'apellidoM',
            'label' => 'Apellido Materno',
            'rules' => 'trim'
        ),
        array(
            'field' => 'rfc',
            'label' => 'RFC',
            'rules' => 'trim|exact_length[13]|alpha_numeric'
        ),
         array(
            'field' => 'curp',
            'label' => 'CURP',
            'rules' => 'trim|exact_length[18]|alpha_numeric'
        ),
        array(
            'field' => 'telefono',
            'label' => 'Teléfono',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fecha',
            'label' => 'Fecha',
            'rules' => 'required'
        ),
        array(
            'field' => 'fechaNac',
            'label' => 'Fecha de Nacimiento',
            'rules' => 'required'
        ),
        array(
            'field' => 'paisNac',
            'label' => 'País de Nacimiento',
            'rules' => 'required'
        ),
        array(
            'field' => 'lugarProspeccion',
            'label' => 'Lugar de Prospección',
            'rules' => 'trim'
        ),
        array(
            'field' => 'otroLugar',
            'label' => 'Otro Lugar de Prospección',
            'rules' => 'trim'
        ),
        array(
            'field' => 'nss',
            'label' => 'NSS',
            'rules' => 'trim|exact_length[11]'//'required|exact_length[11]'
        ),
        array(
            'field' => 'statusProspecto',
            'label' => 'Status Prospecto',
            'rules' => 'trim'
        ),
        /*array(
            'field' => 'prototipo',
            'label' => 'Prototipo',
            'rules' => 'required'
        ),*/
        array(
            'field' => 'idPrototipo',
            'label' => 'Prototipo',
            'rules' => 'required'
        ),
        array(
            'field' => 'comentario',
            'label' => 'Comentarios',
            'rules' => 'trim'
        ),
          array(
            'field' => 'puntaje',
            'label' => 'Puntaje',
            'rules' => 'trim'
        ),
          array(
            'field' => 'valorCredito',
            'label' => 'Valor Credito',
            'rules' => 'trim'
        ),
          array(
            'field' => 'statusProspecto',
            'label' => 'Status Prospecto',
            'rules' => 'trim'
        ),
        
    ),
    'recopilacion' => array( //antes era publicidad_prospeccion
        array(
            'field' => 'idFraccionamiento',
            'label' => 'Fraccionamiento',
            'rules' => 'required'
        ),
        array(
            'field' => 'idPromotor',
            'label' => 'Promotor',
            'rules' => 'required'
        ),
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'trim'
        ),
        array(
            'field' => 'apellidoP',
            'label' => 'Apellido Paterno',
            'rules' => 'trim'
        ),
        array(
            'field' => 'apellidoM',
            'label' => 'Apellido Materno',
            'rules' => 'trim'
        ),
        array(
            'field' => 'rfc',
            'label' => 'RFC',
            'rules' => 'trim'
        ),
        array(
            'field' => 'telefono',
            'label' => 'Teléfono',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fecha',
            'label' => 'Fecha',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fechaAtencion',
            'label' => 'Fecha',
            'rules' => 'trim'
        ),
        array(
            'field' => 'horaAtencion',
            'label' => 'Fecha',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fechaNac',
            'label' => 'Fecha de Nacimiento',
            'rules' => 'trim'
        ),
        array(
            'field' => 'paisNac',
            'label' => 'País de Nacimiento',
            'rules' => 'required'
        ),
        array(
            'field' => 'lugarProspeccion',
            'label' => 'Lugar de Prospección',
            'rules' => 'trim'
        ),
        array(
            'field' => 'otroLugar',
            'label' => 'Otro Lugar de Prospección',
            'rules' => 'trim'
        ),
        array(
            'field' => 'nss',
            'label' => 'NSS',
            'rules' => 'trim|exact_length[11]'//'required|exact_length[11]'
        ),
        array(
            'field' => 'statusProspecto',
            'label' => 'Status Prospecto',
            'rules' => 'trim'
        ),
        array(
            'field' => 'idPrototipo',
            'label' => 'Prototipo',
            'rules' => 'required'
        ),
        array(
            'field' => 'comentario',
            'label' => 'Comentarios',
            'rules' => 'trim'
        ),
    ),
    'reasignacion' => array(
        array(
            'field' => 'idFraccionamiento',
            'label' => 'Fraccionamiento',
            'rules' => 'required'
        ),
        array(
            'field' => 'idPromotor',
            'label' => 'Promotor',
            'rules' => 'required'
        ),
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'required'
        ),
        array(
            'field' => 'apellidoP',
            'label' => 'Apellido Paterno',
            'rules' => 'required'
        ),
        array(
            'field' => 'apellidoM',
            'label' => 'Apellido Materno',
            'rules' => 'trim'
        ),
        array(
            'field' => 'rfc',
            'label' => 'RFC',
            'rules' => 'trim'
        ),
        array(
            'field' => 'telefono',
            'label' => 'Teléfono',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fecha',
            'label' => 'Fecha',
            'rules' => 'required'
        ),
        array(
            'field' => 'fechaNac',
            'label' => 'Fecha de Nacimiento',
            'rules' => 'trim'
        ),
        array(
            'field' => 'lugarProspeccion',
            'label' => 'Lugar de Prospección',
            'rules' => 'trim'
        ),
        array(
            'field' => 'otroLugar',
            'label' => 'Otro Lugar de Prospección',
            'rules' => 'trim'
        ),
        array(
            'field' => 'nss',
            'label' => 'NSS',
            'rules' => 'trim|exact_length[11]'//'required|exact_length[11]'
        ),
        array(
            'field' => 'statusProspecto',
            'label' => 'Status Prospecto',
            'rules' => 'trim'
        ),
        /*array(
            'field' => 'prototipo',
            'label' => 'Prototipo',
            'rules' => 'required'
        ),*/
        array(
            'field' => 'idPrototipo',
            'label' => 'Prototipo',
            'rules' => 'required'
        ),
        array(
            'field' => 'comentario',
            'label' => 'Comentarios',
            'rules' => 'trim'
        ),
    ),
    'prospectosfb' => array(
        array(
            'field' => 'idFraccionamiento',
            'label' => 'Fraccionamiento',
            'rules' => 'required'
        ),
        array(
            'field' => 'idPromotor',
            'label' => 'Promotor',
            'rules' => 'required'
        ),
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'required'
        ),
        array(
            'field' => 'apellidoP',
            'label' => 'Apellido Paterno',
            'rules' => 'required'
        ),
        array(
            'field' => 'apellidoM',
            'label' => 'Apellido Materno',
            'rules' => 'trim'
        ),
        array(
            'field' => 'rfc',
            'label' => 'RFC',
            'rules' => 'trim|exact_length[13]|alpha_numeric'
        ),
        array(
            'field' => 'curp',
            'label' => 'CURP',
            'rules' => 'trim|exact_length[18]|alpha_numeric'
        ),
        array(
            'field' => 'nss',
            'label' => 'NSS',
            'rules' => 'trim|exact_length[11]'//'required|exact_length[11]'
        ),
        array(
            'field' => 'telefono',
            'label' => 'Teléfono',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fecha',
            'label' => 'Fecha',
            'rules' => 'required'
        ),
        array(
            'field' => 'fechaNac',
            'label' => 'Fecha de Nacimiento',
            'rules' => 'required'
        ),
        array(
            'field' => 'paisNac',
            'label' => 'País de Nacimiento',
            'rules' => 'required'
        ),
        array(
            'field' => 'lugarProspeccion',
            'label' => 'Lugar de Prospección',
            'rules' => 'trim'
        ),
        array(
            'field' => 'otroLugar',
            'label' => 'Otro Lugar de Prospección',
            'rules' => 'trim'
        ),
        /*array(
            'field' => 'nss',
            'label' => 'NSS',
            'rules' => 'required|exact_length[11]'
        ),*/
        array(
            'field' => 'statusProspecto',
            'label' => 'Status Prospecto',
            'rules' => 'trim'
        ),
        /*array(
            'field' => 'prototipo',
            'label' => 'Prototipo',
            'rules' => 'required'
        ),*/
        array(
            'field' => 'idPrototipo',
            'label' => 'Prototipo',
            'rules' => 'required'
        ),
        array(
            'field' => 'comentario',
            'label' => 'Comentarios',
            'rules' => 'trim'
        ),
    ),
    'alta_venta' => array(
        array(
            'field' => 'idProspecto',
            'label' => 'Prospecto',
            'rules' => 'required'
        ),
        array(
            'field' => 'idProyecto',
            'label' => 'Lote',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fecha',
            'label' => 'Fecha',
            'rules' => 'required'
        ),
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'required'
        ),
        array(
            'field' => 'apellidoP',
            'label' => 'Apellido Paterno',
            'rules' => 'required'
        ),
        array(
            'field' => 'apellidoM',
            'label' => 'Apellido Materno',
            'rules' => 'trim'
        ),
        array(
            'field' => 'genero',
            'label' => 'Género',
            'rules' => 'required'
        ),
        array(
            'field' => 'rfc',
            'label' => 'RFC',
            'rules' => 'trim'
        ),
        array(
            'field' => 'telefono',
            'label' => 'Teléfono',
            'rules' => 'trim'
        ),
        array(
            'field' => 'nss',
            'label' => 'NSS',
            'rules' => 'trim|exact_length[11]'
        ),
        array(
            'field' => 'fechaNac',
            'label' => 'Fecha de Nacimiento',
            'rules' => 'trim'
        ),
        array(
            'field' => 'statusProspecto',
            'label' => 'Status Prospecto',
            'rules' => 'trim'
        ),
        array(
            'field' => 'monto',
            'label' => 'Monto de Crédito',
            'rules' => 'numeric'
        ),
        array(
            'field' => 'subCuenta',
            'label' => 'SubCuenta',
            'rules' => 'numeric'
        ),
        array(
            'field' => 'gastosOperacion',
            'label' => 'Gastos de Operación',
            'rules' => 'numeric'
        ),
        array(
            'field' => 'total',
            'label' => 'Total',
            'rules' => 'trim'//numeric
        ),
        array(
            'field' => 'fecha Cambio',
            'label' => 'fecha Cambio',
            'rules' => 'trim'//numeric
        ),
        array(
            'field' => 'telR1',
            'label' => 'Primer Teléfono de Referencia',
            'rules' => 'trim'//numeric
        ),
        array(
            'field' => 'telR2',
            'label' => 'Segundo Teléfono de Referencia',
            'rules' => 'trim|differs[telR1]'//numeric
        ),
        array(
            'field' => 'celR1',
            'label' => 'Celular de Referencia',
            'rules' => 'trim'//numeric
        ),
        array(
            'field' => 'celR2',
            'label' => 'Celular de Referencia',
            'rules' => 'trim|differs[celR1]'//numeric
        ),

        array(
            'field' => 'fechaPreca',
            'label' => 'Fecha de Preca',
            'rules' => 'trim'
        )

    ),
    'validacion_venta' => array(
        array(
            'field' => 'statusValidacion2',
            'label' => 'Estatus Validación',
            'rules' => 'required'
        ),
        array(
            'field' => 'idProyecto',
            'label' => 'Lote',
            'rules' => 'required'
        ),
        array(
            'field' => 'revisionMontos',
            'label' => 'Revisión de Montos',
            'rules' => 'required'
        ),
        array(
            'field' => 'motivo',
            'label' => 'Motivo',
            'rules' => 'trim'
        ),
        array(
            'field' => 'tipoCredito',
            'label' => 'Tipo de Credito',
            'rules' => 'required'
        ),
        array(
            'field' => 'diferencia',
            'label' => 'Diferencia',
            'rules' => 'trim|validateInt'
        ),
        array(
            'field' => 'bonoEquipamiento',
            'label' => 'Bono de Equipamiento',
            'rules' => 'trim|validateInt'
        ),
        array(
            'field' => 'numPagare',
            'label' => 'N°',
            'rules' => 'trim'
        ),
        array(
            'field' => 'montoPagare',
            'label' => 'Monto Pagaré',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fechaPagoPagare',
            'label' => 'Fecha Pago',
            'rules' => 'trim'
        ),
        array(
            'field' => 'numSeriePagare',
            'label' => 'Numerada al',
            'rules' => 'trim'
        ),
        array(
            'field' => 'interesPagare',
            'label' => 'Interés moratorio',
            'rules' => 'trim'
        ),
        array(
            'field' => 'idNotaria',
            'label' => 'Notaría',
            'rules' => 'required'
        )
    ),
    'gestoria' => array(
        array(
            'field' => 'statusGestoria',
            'label' => 'Estatus',
            'rules' => 'required'
        ),
        array(
            'field' => 'numeroFolio',
            'label' => 'Número de Folio',
            'rules' => 'trim'
        ),
        array(
            'field' => 'numeroCredito',
            'label' => 'Número de Crédito',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fechaIngreso',
            'label' => 'Fecha de Ingreso',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fechaFirma',
            'label' => 'Fecha de Firma',
            'rules' => 'trim'
        ),
        array(
            'field' => 'precioVentaOci',
            'label' => 'Precio Venta OCI',
            'rules' => 'trim'
        ),
        array(
            'field' => 'montoOci',
            'label' => 'Monto OCI',
            'rules' => 'trim'
        ),
        array(
            'field' => 'subCuenta',
            'label' => 'Subcuenta',
            'rules' => 'trim'
        ),
        array(
            'field' => 'gastosTitulacion',
            'label' => 'Gastos de Titulación',
            'rules' => 'trim'
        ),
        array(
            'field' => 'ahorroVol',
            'label' => 'Ahorro Voluntario',
            'rules' => 'trim'
        ),
        array(
            'field' => 'seguroCalidad',
            'label' => 'Seguro Calidad',
            'rules' => 'trim'
        ),
        array(
            'field' => 'subsidio',
            'label' => 'Subsidio',
            'rules' => 'trim'
        ),
        array(
            'field' => 'total',
            'label' => 'Total',
            'rules' => 'trim'
        ),
        array(
            'field' => 'ronda',
            'label' => 'Ronda',
            'rules' => 'trim'
        )

    ),
    'comisiones_bonos' => array(
        array(
            'field' => 'comision',
            'label' => 'Comisión',
            'rules' => 'required'
        ),
        array(
            'field' => 'resultado',
            'label' => 'Resultado',
            'rules' => 'trim'
        ),
        array(
            'field' => 'importeComision',
            'label' => 'Importe de Comision',
            'rules' => 'trim'
        ),
        array(
            'field' => 'diferenciaVendedor',
            'label' => 'Diferencia a cubrir',
            'rules' => 'trim'
        ),
        array(
            'field' => 'primerPagoPromotor',
            'label' => 'Primer Pago',
            'rules' => 'required|numeric'
        )

    ),
    'autorizaciones' => array(
        array(
            'field' => 'montoTotal',
            'label' => 'Monto Total',
            'rules' => 'trim'//'required|validateInt'
        ),
        array(
            'field' => 'difPropioPeculio',
            'label' => 'Dif Propio Peculio',
            'rules' => 'trim'//'required|validateInt'
        ),
        array(
            'field' => 'resultado',
            'label' => 'Resultado',
            'rules' => 'trim'//'required|validateInt'
        ),
        array(
            'field' => 'propVenta',
            'label' => 'Prop de Venta',
            'rules' => 'trim'//'required|validateInt'
        ),
        array(
            'field' => 'autorizacion',
            'label' => 'Autorización',
            'rules' => 'trim'//'required'
        )

    ),
    'depositos' => array(
        array(
            'field' => 'montoTotal',
            'label' => 'Monto Total',
            'rules' => 'trim'//'required|validateInt'
        ),
        array(
            'field' => 'difPropioPeculio',
            'label' => 'Dif Propio Peculio',
            'rules' => 'trim'//'required|validateInt'
        ),
        array(
            'field' => 'resultado',
            'label' => 'Resultado',
            'rules' => 'trim'//'required|validateInt'
        ),
        array(
            'field' => 'propVenta',
            'label' => 'Prop de Venta',
            'rules' => 'trim'//'required|validateInt'
        ),
        array(
            'field' => 'autorizacion',
            'label' => 'Autorización',
            'rules' => 'trim'//'required'
        ),
        array(
            'field' => 'depositoInfonavit',
            'label' => 'Depóito Infonavit',
            'rules' => 'trim'//'required|validateInt'
        ),
        array(
            'field' => 'depositoConavi',
            'label' => 'Depóito Conavi',
            'rules' => 'trim'//'required|validateInt'
        ),
        array(
            'field' => 'fechaDeposito',
            'label' => 'Fecha Depósito',
            'rules' => 'trim'//'required'
        ),
        array(
            'field' => 'cuentaDepositada',
            'label' => 'Cuenta Depositada',
            'rules' => 'trim'//'required'
        )

    ),
    'entrega' => array(
        array(
            'field' => 'fechaEntrega',
            'label' => 'Fecha Entrega',
            'rules' => 'required'
        ),
        array(
            'field' => 'v_regadera',
            'label' => 'Regadera ecológica',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_inodoro',
            'label' => 'Inodoro ecológico',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_lavabo',
            'label' => 'Lavabo c/llave ecológica',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_fregadero',
            'label' => 'Fregadero',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_gas_estufa',
            'label' => 'Gas p/estufa',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_lavadero',
            'label' => 'Lavadero',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_aguafria_drenaje',
            'label' => 'Agua fría y drenaje',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_aguafriacaliente_boiler',
            'label' => 'Agua fría/caliente',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_gas_tanque',
            'label' => 'Gas p/tanque',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_registro_sanitario',
            'label' => 'Registro sanitario',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_acometida',
            'label' => 'Acometida C.F.E.',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_base_medidor',
            'label' => 'Base p/medidor',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_centro_carga',
            'label' => 'Centro de carga',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_varilla_tierra',
            'label' => 'Varilla de tierra',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_timbre',
            'label' => 'Timbre',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_apagadores',
            'label' => 'Apagadores',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_toma_corriente',
            'label' => 'Toma corrientes',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_television',
            'label' => 'Televisión',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_marcos_puertas',
            'label' => 'Marcos de puertas',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_ventanas_aluminio',
            'label' => 'Ventanas de aluminio',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_cisterna',
            'label' => 'Cisterna de 1,100 litros',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_pasamanos_escalera',
            'label' => 'Pasamanos de escalera',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_vidrios_normales',
            'label' => 'Vidrios normales',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_mosquiteros',
            'label' => 'Mosquiteros',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_puertas_interiores',
            'label' => 'Puertas de interiores',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_puertas_exteriores',
            'label' => 'Puertas de exteriores',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_chapas_int_ext',
            'label' => 'Chapas interiores y exteriores',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_llaves_int_ext',
            'label' => 'Llaves interiores y exteriores',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_acabado_exterior',
            'label' => 'Acabado exterior',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_acabado_interior',
            'label' => 'Acabado interior',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_proteccion_balcon',
            'label' => 'Protección balcon',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_banquetas',
            'label' => 'Banquetas',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_vitropiso',
            'label' => 'Vitropiso zoclo',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_azulejo_baño',
            'label' => 'Azulejo p/baño',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_azulejo_cocina',
            'label' => 'Azulejo p/cocina',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_bardas_medianeras',
            'label' => 'Bardas medianeras',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_impermeabilizacion',
            'label' => 'Impermiabilización',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_focos_ahorradores',
            'label' => 'Focos ahorradores',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_ahorradores_agua',
            'label' => 'Ahorradores de agua',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_boiler',
            'label' => 'Calentador de paso',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_hidroneumatico',
            'label' => 'Hidroneumático',
            'rules' => 'trim'
        ),
        array(
            'field' => 'v_garantias',
            'label' => 'Garantías',
            'rules' => 'trim'
        )
    ),
    'postventa' => array(
        array(
            'field' => 'instElectricas',
            'label' => 'Inst. Electricas',
            'rules' => 'trim'
        )
    ),

    'blackboard' => array(
        array(
            'field' => 'asunto',
            'label' => 'Asunto',
            'rules' => 'required'
        ),
        array(
            'field' => 'proyecto',
            'label' => 'Proyecto',
            'rules' => 'required'
        ),
        array(
            'field' => 'delegado',
            'label' => 'Nombre Delegado',
            'rules' => 'trim'
        ),
        array(
            'field' => 'mail',
            'label' => 'Email Delegado',
            'rules' => 'trim'
        ),
        array(
            'field' => 'fechaInicio',
            'label' => 'Fecha de inicio',
            'rules' => 'required'
        ),
        array(
            'field' => 'fechaTermino',
            'label' => 'Fecha de termino',
            'rules' => 'required'
        )
    ),
    'prototipos' => array(
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoCimentacion',
            'label' => 'Costo cimentación',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceCimentacion',
            'label' => 'Avance cimentación',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoAlbPlantaBaja',
            'label' => 'Costo albañilería p. baja',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceAlbPlantaBaja',
            'label' => 'Avance albañilería p. baja',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoLosaEntrepiso',
            'label' => 'Costo losa de entrepiso',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceLosaEntrepiso',
            'label' => 'Avance losa de entrepiso',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoAlbPrimerNivel',
            'label' => 'Costo albañilería primer nivel',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceAlbPrimerNivel',
            'label' => 'Avance albañilería primer nivel',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoLosaPrimerNivel',
            'label' => 'Costo losa de primer nivel',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceLosaPrimerNivel',
            'label' => 'Avance losa de primer nivel',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoAzotea',
            'label' => 'Costo azotea',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceAzotea',
            'label' => 'Avance azotea',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoFachada',
            'label' => 'Costo fachada',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceFachada',
            'label' => 'Avance fachada',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoAcabados',
            'label' => 'Costo acabados',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceAcabados',
            'label' => 'Avance acabados',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoPisos',
            'label' => 'Costo pisos',
            'rules' => 'required'
        ),
        array(
            'field' => 'avancePisos',
            'label' => 'Avance pisos',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoInstHidroGas',
            'label' => 'Costo Inst. Hidro gas',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceInstHidroGas',
            'label' => 'Avance Inst. Hidro gas',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoCanceleria',
            'label' => 'Costo Cancelería',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceCanceleria',
            'label' => 'Avance Cancelería',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoElectrica',
            'label' => 'Costo Eléctrica',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceElectrica',
            'label' => 'Avance Eléctrica',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoObraExterior',
            'label' => 'Costo Obra Exterior',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceObraExterior',
            'label' => 'Avance Obra Exterior',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoBardas',
            'label' => 'Costo Bardas',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceBardas',
            'label' => 'Avance Bardas',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoLimpieza',
            'label' => 'Costo Limpieza',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceLimpieza',
            'label' => 'Avance Limpieza',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoExtra',
            'label' => 'Costo Extra',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceExtra',
            'label' => 'Avance Extra',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoImpermeabilizacion',
            'label' => 'Costo Impermiabilización',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceImpermeabilizacion',
            'label' => 'Avance Impermiabilización',
            'rules' => 'required'
        ),
        array(
            'field' => 'costoEcotecnologias',
            'label' => 'Costo Ecotecnologías',
            'rules' => 'required'
        ),
        array(
            'field' => 'avanceEcotecnologias',
            'label' => 'Avance Ecotecnologías',
            'rules' => 'required'
        )
    ),
    'notaria' => array(
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'required'
        ),
        array(
            'field' => 'telefono',
            'label' => 'Teléfono',
            'rules' => 'required'
        ),
        array(
            'field' => 'email',
            'label' => 'Email',
            'rules' => 'required|valid_email'
        )
    ),

    'avaluos' => array(
        array(
            'field' => 'titulo',
            'label' => 'Titulo',
            'rules' => 'required'
        )
    ),

    'unidad_valuadora' => array(
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'required'
        ),
        array(
            'field' => 'telefono',
            'label' => 'Teléfono',
            'rules' => 'required'
        ),
        array(
            'field' => 'email',
            'label' => 'Email',
            'rules' => 'required|valid_email'
        )
    ),

);


