<div class="page-bar">
    <ul class="page-breadcrumb">
        <li><a href="inicio">Home</a><i class="fa fa-circle"></i></li>
        <li><a href="<?php echo $this->router->class; ?>"><?php echo ucfirst($this->router->class); ?></a><i class="fa fa-circle"></i></li>
        <li><span>Detalle</span></li>
    </ul>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-green-haze">
                    <i class="fa fa-file-text-o font-green-haze"></i>
                    <span class="caption-subject bold uppercase"> Detalle de Proyecto</span>
                </div>
                <div class="actions">
                    <a href="<?php echo $this->router->class.'/imprimirAvance/'.$id; ?>" class="btn btn-default"><i class="fa fa-print"></i> Imprimir</a>
                    <a href="<?php echo (is_numeric($module) ? $this->router->class : $module); ?>" class="btn btn-default"><i class="fa fa-backward"></i> Regresar</a>
                </div>
            </div>
            <div class="portlet-body form">
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6 col-sm-6 col-xs-12">
        <!-- BEGIN SAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title" style="border-bottom: 1px solid #f2a930;">
                <div class="caption fc-3">
                    <i class="fa fa-user font-green fc-3"></i>
                    <span class="caption-subject font-green bold uppercase fc-3">Datos Generales</span>
                </div>

            </div>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-hover">
                        <!-- <thead>
                            <tr>
                                <th> Propiedad </th>
                                <th> Valor </th>
                            </tr>
                        </thead> -->
                        <tbody>
                            <tr>
                                <td> Manzana </td>
                                <td> <?php echo $manzana; ?> </td> 
                            </tr>
                            <tr>
                                <td> Lote </td>
                                <td> <?php echo $lote; ?> </td> 
                            </tr>
                            <tr>
                                <td> Número Oficial </td>
                                <td> <?php echo $nOficial; ?> </td> 
                            </tr>
                            <tr>
                                <td> Calle </td>
                                <td> <?php echo $calle; ?> </td> 
                            </tr>
                            <tr>
                                <td> # Paquete </td>
                                <td> <?php echo $numPaquete; ?> </td> 
                            </tr>
                            <tr>
                                <td> CUV </td>
                                <td> <?php echo $cuv; ?> </td> 
                            </tr>
                            <tr>
                                <td> Clave Catastral </td>
                                <td> <?php echo $claveCatastral; ?> </td> 
                            </tr>
                            <tr>
                                <td> Superficie Terreno </td>
                                <td> <?php echo $supTerreno; ?> m<sup>2</sup></td> 
                            </tr>
                            <tr>
                                <td> Superficie Construcción </td>
                                <td> <?php echo $supConstruccion; ?> m<sup>2</sup></td> 
                            </tr>
                            <tr>
                                <td> Prototipo </td>
                                <!-- <td> <?php // echo $mprototipoxfraccionamiento->getCampo('titulo',$idPrototipo); ?></td> -->
                                <td> <?php echo $mprototipos->getCampo('nombre',$idPrototipo); ?></td>
                            </tr>
                            <tr>
                                <td> Precio Venta </td>
                                <td> <?php echo precio_format($precioVenta); ?> </td> 
                            </tr>
                            <tr>
                                <td> Puntaje </td>
                                <td> <?php echo $puntaje; ?> </td> 
                            </tr>
                            <tr>
                                <td> Estatus </td>
                                <td> <?php echo $statusProyecto; ?> </td> 
                            </tr>
                            <tr>
                                <td> Porcentaje Avance </td>
                                <td> <?php echo $porcentajeAvance; ?> %</td> 
                            </tr>
                            <tr>
                                <td> Fecha DTU </td>
                                <td> <?php echo date_format(new DateTime($fechaDtu), 'd/m/Y'); ?> </td> 
                            </tr>
                            <tr>
                                <td> Fecha Vencimiento </td>
                                <td> <?php echo date_format(new DateTime($fechaVencimiento), 'd/m/Y'); ?> </td> 
                            </tr>
                            <tr>
                                <td> Contratista </td>
                                <td> <?php echo $contratista; ?> </td> 
                            </tr>
                            <tr>
                                <td> Avalúo </td>
                                <td> <?php echo precio_format($avaluo); ?> </td> 
                            </tr>
                            <tr>
                                <td> Unidad Veridficadora </td>
                                <td> <?php echo $unidadVerificadora; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Linea de crédito </td>
                                <td> <?php echo $lineaCredito; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Tipo de vialidad </td>
                                <td> <?php echo $tipoVialidad; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Nombre de vialidad </td>
                                <td> <?php echo $nombreVialidad; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Nivel </td>
                                <td> <?php echo $nivel; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Estacionamiento </td>
                                <td> <?php echo $estacionamiento; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Tipo de vialidad </td>
                                <td> <?php echo $tipoPrimeraVialidad; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Nombre de la primera entre vialidad </td>
                                <td> <?php echo $primeraEntreVialidad; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Tipo de vialidad </td>
                                <td> <?php echo $tipoSegundaVialidad; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Nombre de la segunda entre vialidad </td>
                                <td> <?php echo $segundaEntreVialidad; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Tipo de vialidad </td>
                                <td> <?php echo $tipoVialidadPosterior; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Nombre de la vialidad posterior </td>
                                <td> <?php echo $nombreVialidadPosterior; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Metros frente lote </td>
                                <td> <?php echo $metrosFrente; ?> </td> 
                            </tr>                          
                            <tr>
                                <td> Orientacion </td>
                                <td> <?php echo $orientacion; ?> </td> 
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- END SAMPLE TABLE PORTLET-->
    </div>

    <?php 
    if ($etapa_alta_venta == true){
    ?>
    <div class="col-xs-12 col-sm-6 col-md-6">
        <div class="portlet light bordered">
            <div class="portlet-title" style="border-bottom: 1px solid #f2a930;">
                <div class="caption fc-3">
                    <i class="fa fa-user font-green fc-3"></i>
                    <span class="caption-subject font-green bold uppercase fc-3">Alta de Venta</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-hover">
                        <!-- <thead>
                            <tr>
                                <th> Propiedad </th>
                                <th> Valor </th>
                            </tr>
                        </thead> -->
                        <tbody>
                            <tr>
                                <td> Fecha </td>
                                <td> <?php echo date_format(new DateTime($detalle_venta['fecha']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Prospecto </td>
                                <td> <?php echo $detalle_venta['nombre']." ".$detalle_venta['apellidoP']." ".$detalle_venta['apellidoM']; ?> </td> 
                            </tr>
                            <tr>
                                <td> RFC </td>
                                <td> <?php echo $detalle_venta['rfc']; ?> </td> 
                            </tr>  
                            <tr>
                                <td> Teléfono </td>
                                <td> <?php echo $detalle_venta['telefono']; ?> </td> 
                            </tr>
                            <tr>
                                <td> NSS </td>
                                <td> <?php echo $detalle_venta['nss']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Fecha de Nacimiento </td>
                                <td> <?php echo date_format(new DateTime($detalle_venta['fechaNac']), 'd/m/Y'); ?> </td> 
                            </tr>
                            <tr>
                                <td> Comentario </td>
                                <td> <?php echo $detalle_venta['descripcion']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Promotor </td>
                                <td> <?php echo (isset($detalle_venta['idPromotor']))?$mpromotor->getCampo('nombre',$detalle_venta['idPromotor'])." ".$mpromotor->getCampo('apellidoP',$detalle_venta['idPromotor'])." ".$mpromotor->getCampo('apellidoM',$detalle_venta['idPromotor']):''; ?> </td> 
                            </tr>
                            <!-- <tr>
                                <td> Precio de Venta </td>
                                <td> <?php //echo number_format($detalle_venta['precioVenta']); ?> </td> 
                            </tr> -->
                            <tr>
                                <td> Monto </td>
                                <td> <?php echo precio_format($detalle_venta['monto']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Subcuenta </td>
                                <td> <?php echo precio_format($detalle_venta['subCuenta']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Gastos de Operación </td>
                                <td> <?php echo precio_format($detalle_venta['gastosOperacion']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Fecha Preca </td>
                                <td> <?php echo date_format(new DateTime($detalle_venta['fechaPreca']), 'd/m/Y'); ?> </td> 
                            </tr>
                            <!-- Aqui se valida si alguno de los campos de los anexos esta vacío o no-->
                            <?php
                            if(isset($detalle_venta['pdf_1']) && $detalle_venta['pdf_1']!=''){
                                $clase_pdf1 = "fa fa-check";
                                $ruta_pdf1  = "<a href='uploads/alta_venta/".$detalle_venta['pdf_1']."' target='_blank'><i class='fa fa-eye' style='font-size: 18px;'></i> Ver Documento</a>";
                            }else{
                                $clase_pdf1 = "fa fa-ban";
                                $ruta_pdf1  = "<i class='fa fa-eye-slash' style='font-size: 18px;'></i> No Existe Documento";
                            }
                            if(isset($detalle_venta['pdf_2']) && $detalle_venta['pdf_2']!=''){
                                $clase_pdf2 = "fa fa-check";
                                $ruta_pdf2  = "<a href='uploads/alta_venta/".$detalle_venta['pdf_2']."' target='_blank'><i class='fa fa-eye' style='font-size: 18px;'></i> Ver Documento</a>";
                            }else{
                                $clase_pdf2 = "fa fa-ban";
                                $ruta_pdf2  = "<i class='fa fa-eye-slash' style='font-size: 18px;'></i> No Existe Documento";
                            }
                            if(isset($detalle_venta['pdf_3']) && $detalle_venta['pdf_3']!=''){
                                $clase_pdf3 = "fa fa-check";
                                $ruta_pdf3  = "<a href='uploads/alta_venta/".$detalle_venta['pdf_3']."' target='_blank'><i class='fa fa-eye' style='font-size: 18px;'></i> Ver Documento</a>";
                            }else{
                                $clase_pdf3 = "fa fa-ban";
                                $ruta_pdf3  = "<i class='fa fa-eye-slash' style='font-size: 18px;'></i> No Existe Documento";
                            }
                            if(isset($detalle_venta['pdf_4']) && $detalle_venta['pdf_4']!=''){
                                $clase_pdf4 = "fa fa-check";
                                $ruta_pdf4  = "<a href='uploads/alta_venta/".$detalle_venta['pdf_4']."' target='_blank'><i class='fa fa-eye' style='font-size: 18px;'></i> Ver Documento</a>";
                            }else{
                                $clase_pdf4 = "fa fa-ban";
                                $ruta_pdf4  = "<i class='fa fa-eye-slash' style='font-size: 18px;'></i> No Existe Documento";
                            }
                            if(isset($detalle_venta['pdf_5']) && $detalle_venta['pdf_5']!=''){
                                $clase_pdf5 = "fa fa-check";
                                $ruta_pdf5  = "<a href='uploads/alta_venta/".$detalle_venta['pdf_5']."' target='_blank'><i class='fa fa-eye' style='font-size: 18px;'></i> Ver Documento</a>";
                            }else{
                                $clase_pdf5 = "fa fa-ban";
                                $ruta_pdf5  = "<i class='fa fa-eye-slash' style='font-size: 18px;'></i> No Existe Documento";
                            }
                            if(isset($detalle_venta['pdf_6']) && $detalle_venta['pdf_6']!=''){
                                $clase_pdf6 = "fa fa-check";
                                $ruta_pdf6  = "<a href='uploads/alta_venta/".$detalle_venta['pdf_6']."' target='_blank'><i class='fa fa-eye' style='font-size: 18px;'></i> Ver Documento</a>";
                            }else{
                                $clase_pdf6 = "fa fa-ban";
                                $ruta_pdf6  = "<i class='fa fa-eye-slash' style='font-size: 18px;'></i> No Existe Documento";
                            }
                            if(isset($detalle_venta['pdf_7']) && $detalle_venta['pdf_7']!=''){
                                $clase_pdf7 = "fa fa-check";
                                $ruta_pdf7  = "<a href='uploads/alta_venta/".$detalle_venta['pdf_7']."' target='_blank'><i class='fa fa-eye' style='font-size: 18px;'></i> Ver Documento</a>";
                            }else{
                                $clase_pdf7 = "fa fa-ban";
                                $ruta_pdf7  = "<i class='fa fa-eye-slash' style='font-size: 18px;'></i> No Existe Documento";
                            }
                            if(isset($detalle_venta['pdf_16']) && $detalle_venta['pdf_16']!=''){
                                $clase_pdf16 = "fa fa-check";
                                $ruta_pdf16  = "<a href='uploads/alta_venta/".$detalle_venta['pdf_16']."' target='_blank'><i class='fa fa-eye' style='font-size: 18px;'></i> Ver Documento</a>";
                            }else{
                                $clase_pdf16 = "fa fa-ban";
                                $ruta_pdf16  = "<i class='fa fa-eye-slash' style='font-size: 18px;'></i> No Existe Documento";
                            }

                            /*En esta seccion se valida unicamente el campo pdf_1 ya que en este se suben todos los anexos*/
                            if($detalle_venta['id']>=396):                                
                            ?>
                            <tr>
                                <td rowspan="7">
                                    <div class="col-md-3">
                                        <ul style="list-style-type: none;padding: 0px;font-size: 10.5px;width: 120px;">
                                            <li>Acta <i class="<?php echo $clase_pdf1;?>"></i></li>
                                            <li>INE <i class="<?php echo $clase_pdf1;?>"></i></li>
                                            <li>CURP <i class="<?php echo $clase_pdf1;?>"></i></li>
                                            <li>Bansefi <i class="<?php echo $clase_pdf1;?>"></i></li>
                                            <li>Precalificación <i class="<?php echo $clase_pdf1;?>"></i></li>
                                            <li>Curso <i class="<?php echo $clase_pdf1;?>"></i></li>
                                            <li>Solicitud <i class="<?php echo $clase_pdf1;?>"></i></li>
                                            <li>C. Domicilio <i class="<?php echo $clase_pdf1;?>"></i></li>
                                        </ul>
                                    </div>
                                </td>
                                <td><?php echo $ruta_pdf1;?></td>
                            </tr>                              
                            <?php
                            else:
                            ?>
                            <tr>
                                <td> Acta de Nacimiento </td>
                                <td> <?php echo $ruta_pdf1;?> </td> 
                            </tr>
                            <tr>
                                <td> IFE </td>
                                <td> <?php echo $ruta_pdf2;?> </td> 
                            </tr>
                            <tr>
                                <td> Bansefi </td>
                                <td> <?php echo $ruta_pdf3;?> </td> 
                            </tr>
                            <tr>
                                <td> Curp </td>
                                <td> <?php echo $ruta_pdf4;?> </td> 
                            </tr>
                            <tr>
                                <td> Precalificación </td>
                                <td> <?php echo $ruta_pdf5;?> </td> 
                            </tr>
                            <tr>
                                <td> Curso </td>
                                <td> <?php echo $ruta_pdf6;?> </td> 
                            </tr>
                            <tr>
                                <td> Solicitud de Crédito </td>
                                <td> <?php echo $ruta_pdf7;?> </td> 
                            </tr>
                            <tr>
                                <td> C. Domicilio </td>
                                <td> <?php echo $ruta_pdf16;?> </td> 
                            </tr>
                            <?php
                            endif;
                            ?>
                            <!-- Finaliza la validacion de anexos -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
</div>

<div class="row">
    <?php 
    if ($etapa_validacion_venta == true){
    ?>
    <div class="col-md-6 col-sm-6 col-xs-12">
        <div class="portlet light bordered">
            <div class="portlet-title" style="border-bottom: 1px solid #f2a930;">
                <div class="caption fc-3">
                    <i class="fa fa-user font-green fc-3"></i>
                    <span class="caption-subject font-green bold uppercase fc-3">Validación de Venta</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-hover">
                        <!-- <thead>
                            <tr>
                                <th> Propiedad </th>
                                <th> Valor </th>
                            </tr>
                        </thead> -->
                        <tbody>
                            <tr>
                                <td> Revisión de Montos </td>
                                <td> <?php echo $detalle_venta['revisionMontos']; ?> </td> 
                            </tr>  
                            <tr>
                                <td> Motivo </td>
                                <td> <?php echo $detalle_venta['motivo']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Tipo de Crédito </td>
                                <td> <?php echo $detalle_venta['tipoCredito']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Diferencia </td>
                                <td> <?php echo precio_format($detalle_venta['diferencia']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Bono de Equipamiento </td>
                                <td> <?php echo precio_format($detalle_venta['bonoEquipamiento']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Notaria </td>
                                <td> <?php //echo $detalle_venta['notaria']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Acta de Nacimiento </td>
                                <td> <?php echo ($detalle_venta['statusPdf_1'] == 1)?'<i class="fa fa-check-square-o fc-3" style="font-size:18px;"></i>':'<i class="fa fa-close fc-3" style="font-size:18px;"></i>'; ?> </td> 
                            </tr>
                            <tr>
                                <td> IFE </td>
                                <td> <?php echo ($detalle_venta['statusPdf_2'] == 1)?'<i class="fa fa-check-square-o fc-3" style="font-size:18px;"></i>':'<i class="fa fa-close fc-3" style="font-size:18px;"></i>'; ?> </td> 
                            </tr>
                            <tr>
                                <td> RFC </td>
                                <td> <?php echo ($detalle_venta['statusPdf_3'] == 1)?'<i class="fa fa-check-square-o fc-3" style="font-size:18px;"></i>':'<i class="fa fa-close fc-3" style="font-size:18px;"></i>'; ?> </td> 
                            </tr>
                            <tr>
                                <td> CURP </td>
                                <td> <?php echo ($detalle_venta['statusPdf_4'] == 1)?'<i class="fa fa-check-square-o fc-3" style="font-size:18px;"></i>':'<i class="fa fa-close fc-3" style="font-size:18px;"></i>'; ?> </td> 
                            </tr>
                            <tr>
                                <td> Precalificación </td>
                                <td> <?php echo ($detalle_venta['statusPdf_5'] == 1)?'<i class="fa fa-check-square-o fc-3" style="font-size:18px;"></i>':'<i class="fa fa-close fc-3" style="font-size:18px;"></i>'; ?> </td> 
                            </tr>
                            <tr>
                                <td> Curso </td>
                                <td> <?php echo ($detalle_venta['statusPdf_6'] == 1)?'<i class="fa fa-check-square-o fc-3" style="font-size:18px;"></i>':'<i class="fa fa-close fc-3" style="font-size:18px;"></i>'; ?> </td> 
                            </tr>
                            <tr>
                                <td> Solicitud de Crédito </td>
                                <td> <?php echo ($detalle_venta['statusPdf_7'] == 1)?'<i class="fa fa-check-square-o fc-3" style="font-size:18px;"></i>':'<i class="fa fa-close fc-3" style="font-size:18px;"></i>'; ?> </td> 
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php 
    } 

    if ($etapa_gestoria == true){
    ?>

    <div class="col-md-6 col-sm-6 col-xs-12">
        <div class="portlet light bordered">
            <div class="portlet-title" style="border-bottom: 1px solid #f2a930;">
                <div class="caption fc-3">
                    <i class="fa fa-user font-green fc-3"></i>
                    <span class="caption-subject font-green bold uppercase fc-3">Gestoría</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-hover">
                        <!-- <thead>
                            <tr>
                                <th> Propiedad </th>
                                <th> Valor </th>
                            </tr>
                        </thead> -->
                        <tbody>
                            <tr>
                                <td> Estatus </td>
                                <td> <?php echo $detalle_venta['statusGestoria']; ?> </td> 
                            </tr>  
                            <tr>
                                <td> ¿Aplica Folio? </td>
                                <td> <?php echo ($detalle_venta['aplicaFolio'] == 1)?'Si':'No'; ?> </td> 
                            </tr>
                            <?php if($detalle_venta['aplicaFolio'] == 1) { ?>
                            <tr>
                                <td> Número de Folio </td>
                                <td> <?php echo $detalle_venta['numeroFolio']; ?> </td> 
                            </tr>
                            <?php } ?>
                            <tr>
                                <td> Número de Crédito </td>
                                <td> <?php echo $detalle_venta['numeroCredito']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Fecha de Ingreso </td>
                                <td> <?php echo date_format(new DateTime($detalle_venta['fechaIngreso']), 'd/m/Y'); ?> </td> 
                            </tr>
                            <tr>
                                <td> Certificado de Libertad </td>
                                <td> <?php echo $detalle_venta['certificadoLibertad']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Costancia de No Adeudo </td>
                                <td> <?php echo $detalle_venta['constanciaNoAdeudo']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Precio Venta OCI </td>
                                <td> <?php echo precio_format($detalle_venta['precioVentaOci']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Monto OCI </td>
                                <td> <?php echo precio_format($detalle_venta['montoOci']); ?> </td> 
                            </tr>
                            <tr>
                                <td> SubCuenta </td>
                                <td> <?php echo precio_format($detalle_venta['subCuenta']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Gastos de Tutulación </td>
                                <td> <?php echo precio_format($detalle_venta['gastosTitulacion']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Ahorro Voluntario </td>
                                <td> <?php echo precio_format($detalle_venta['ahorroVol']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Subsidio </td>
                                <td> <?php echo precio_format($detalle_venta['subsidio']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Suma Final </td>
                                <td> <?php echo precio_format($detalle_venta['sumaFinal']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Fecha de Firma </td>
                                <td> <?php echo date_format(new DateTime($detalle_venta['fechaFirma']), 'd/m/Y'); ?> </td> 
                            </tr>
                            <tr>
                                <td> Escritura </td>
                                <td> <a href="uploads/alta_venta/gestoria/<?php echo $detalle_venta['pdf_8']; ?>" target="_blank"><i class="fa fa-eye" style="font-size: 18px;"></i> Ver Documento<!-- <img src="img/pdf.png"> --></a> </td> 
                            </tr>
                            <tr>
                                <td> Carta de Instrucción </td>
                                <td> <a href="uploads/alta_venta/gestoria/<?php echo $detalle_venta['pdf_9']; ?>" target="_blank"><i class="fa fa-eye" style="font-size: 18px;"></i> Ver Documento<!-- <img src="img/pdf.png"> --></a> </td> 
                            </tr>
                            <tr>
                                <td> No Adeuda Agua </td>
                                <td> <a href="uploads/alta_venta/gestoria/<?php echo $detalle_venta['pdf_10']; ?>" target="_blank"><i class="fa fa-eye" style="font-size: 18px;"></i> Ver Documento<!-- <img src="img/pdf.png"> --></a> </td> 
                            </tr>
                            <tr>
                                <td> Certificado LIB o G </td>
                                <td> <a href="uploads/alta_venta/gestoria/<?php echo $detalle_venta['pdf_11']; ?>" target="_blank"><i class="fa fa-eye" style="font-size: 18px;"></i> Ver Documento<!-- <img src="img/pdf.png"> --></a> </td> 
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>

</div>

<div class="row">
    <?php if ( $etapa_comisionbono == true ) { 
    ?>
    <div class="col-md-6 col-sm-6 col-xs-12">
        <div class="portlet light bordered">
            <div class="portlet-title" style="border-bottom: 1px solid #f2a930;">
                <div class="caption fc-3">
                    <i class="fa fa-user font-green fc-3"></i>
                    <span class="caption-subject font-green bold uppercase fc-3">Comisiones o bono</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-hover">
                        <!-- <thead>
                            <tr>
                                <th> Propiedad </th>
                                <th> Valor </th>
                            </tr>
                        </thead> -->
                        <tbody>
                            <tr>
                                <td> Valor Avalúo </td>
                                <td> <?php echo precio_format($detalle_venta['avaluo']); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Precio venta OCI </td>
                                <td> <?php echo precio_format($detalle_venta['precioVentaOci']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Precio venta empresa </td>
                                <td> <?php echo precio_format($detalle_venta['precioVenta']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Monto final </td>
                                <td> <?php echo precio_format($detalle_venta['sumaFinal']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Dif propio peculio </td>
                                <td> <?php echo precio_format($detalle_comisionbono['difPropioPeculio']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Número de crédito </td>
                                <td> <?php echo $detalle_venta['numeroCredito']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Resultado </td>
                                <td> <?php echo precio_format($detalle_comisionbono['resultado']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Bono presupuesto inicial </td>
                                <td> <?php echo precio_format($detalle_venta['bonoEquipamiento']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Saldo </td>
                                <td> <?php echo precio_format($detalle_comisionbono['saldo']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Cierre </td>
                                <td> <?php echo precio_format($detalle_comisionbono['cierre']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Tipo de promotor </td>
                                <td> <?php echo $mpromotor->getCampo("tipoPromotor",$detalle_venta['idPromotor']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Comisión % </td>
                                <td> <?php echo $mpromotor->getCampo("comision",$detalle_venta['idPromotor']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Importe comisión </td>
                                <td> <?php echo precio_format($detalle_comisionbono['importeComision']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Nombre promotor </td>
                                <td> <?php echo $mpromotor->getCampo('nombre',$detalle_venta['idPromotor'])." ".$mpromotor->getCampo('apellidoP',$detalle_venta['idPromotor'])." ".$mpromotor->getCampo('apellidoM',$detalle_venta['idPromotor']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Neto de venta </td>
                                <td> <?php echo precio_format($detalle_comisionbono['netoVenta']); ?> </td> 
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php  
    } 
    if ( $etapa_autorizaciones == true ) {  
    ?>
    <div class="col-md-6 col-sm-6 col-xs-12">
        <div class="portlet light bordered">
            <div class="portlet-title" style="border-bottom: 1px solid #f2a930;">
                <div class="caption fc-3">
                    <i class="fa fa-user font-green fc-3"></i>
                    <span class="caption-subject font-green bold uppercase fc-3">Autorizaciones</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-hover">
                        <!-- <thead>
                            <tr>
                                <th> Propiedad </th>
                                <th> Valor </th>
                            </tr>
                        </thead> -->
                        <tbody>
                            <tr>
                                <td> Monto total </td>
                                <td> <?php echo precio_format($detalle_autorizaciones['montoTotal']); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Dif propio peculio </td>
                                <td> <?php echo precio_format($detalle_autorizaciones['difPropPeculio']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Resultado </td>
                                <td> <?php echo precio_format($detalle_autorizaciones['resultado']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Bono presupuesto </td>
                                <td> <?php echo precio_format($detalle_venta['bonoEquipamiento']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Prop de venta </td>
                                <td> <?php echo precio_format($detalle_autorizaciones['propVenta']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Precio de venta </td>
                                <td> <?php echo precio_format($detalle_venta['precioVenta']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Autorización </td>
                                <td> <?php echo $detalle_autorizaciones['statusAutorizacion']; ?> </td> 
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php  
    } ?>
</div>

<div class="row">
    <?php if ( $etapa_deposito == true ) {  
    ?>
    <div class="col-md-6 col-sm-6 col-xs-12">
        <div class="portlet light bordered">
            <div class="portlet-title" style="border-bottom: 1px solid #f2a930;">
                <div class="caption fc-3">
                    <i class="fa fa-user font-green fc-3"></i>
                    <span class="caption-subject font-green bold uppercase fc-3">Deposito</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-hover">
                        <!-- <thead>
                            <tr>
                                <th> Propiedad </th>
                                <th> Valor </th>
                            </tr>
                        </thead> -->
                        <tbody>
                            <tr>
                                <td> Número de crédito </td>
                                <td> <?php echo $detalle_venta['numeroCredito']; ?> </td> 
                            </tr>  
                            <tr>
                                <td> Monto total </td>
                                <td> <?php echo precio_format($detalle_deposito['montoTotal']); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Dif propio peculio </td>
                                <td> <?php echo precio_format($detalle_deposito['difPropPeculio']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Resultado </td>
                                <td> <?php echo precio_format($detalle_deposito['resultado']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Bono presupuesto </td>
                                <td> <?php echo precio_format($detalle_venta['bonoEquipamiento']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Prop de venta </td>
                                <td> <?php echo precio_format($detalle_deposito['propVenta']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Precio de venta </td>
                                <td> <?php echo precio_format($detalle_venta['precioVenta']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Autorización </td>
                                <td> <?php echo $detalle_autorizaciones['statusAutorizacion']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Depósito Infonavit </td>
                                <td> <?php echo precio_format($detalle_deposito['depositoInfonavit']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Depósito conavi </td>
                                <td> <?php echo precio_format($detalle_deposito['depositoConavi']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Fecha Depósito </td>
                                <td> <?php echo date_format(new DateTime($detalle_deposito['fechaDeposito']), 'd/m/Y'); ?> </td> 
                            </tr>
                            <tr>
                                <td> Cuenta depositada </td>
                                <td> <?php echo $detalle_deposito['cuentaDepositada']; ?> </td> 
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php  
    } 
    if ( $etapa_entrega == true ) {  
    ?>
    <div class="col-md-6 col-sm-6 col-xs-12">
        <div class="portlet light bordered">
            <div class="portlet-title" style="border-bottom: 1px solid #f2a930;">
                <div class="caption fc-3">
                    <i class="fa fa-user font-green fc-3"></i>
                    <span class="caption-subject font-green bold uppercase fc-3">Entrega</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-hover">
                        <!-- <thead>
                            <tr>
                                <th> Propiedad </th>
                                <th> Valor </th>
                            </tr>
                        </thead> -->
                        <tbody>
                            <tr>
                                <td> Lote </td>
                                <td> <?php echo $detalle_venta['lote']; ?> </td> 
                            </tr>  
                            <tr>
                                <td> Manzana </td>
                                <td> <?php echo $detalle_venta['manzana']; ?> </td> 
                            </tr>  
                            <tr>
                                <td> Número oficial </td>
                                <td> <?php echo $detalle_venta['nOficial']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Calle </td>
                                <td> <?php echo $detalle_venta['calle']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Nombres </td>
                                <td> <?php echo $detalle_venta['nombre']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Apellido paterno </td>
                                <td> <?php echo $detalle_venta['apellidoP']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Apellido Materno </td>
                                <td> <?php echo $detalle_venta['apellidoM']; ?> </td> 
                            </tr>
                            <tr>
                                <td> RFC </td>
                                <td> <?php echo $detalle_venta['rfc']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Teléfono </td>
                                <td> <?php echo $detalle_venta['telefono']; ?> </td> 
                            </tr>
                            <tr>
                                <td> NSS </td>
                                <td> <?php echo $detalle_venta['nss']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Fecha de nacimiento </td>
                                <td> <?php echo date_format(new DateTime($detalle_venta['fechaNac']), 'd/m/Y'); ?> </td> 
                            </tr>
                            <tr>
                                <td> Estatus </td>
                                <td> <?php echo $detalle_venta['statusProyecto']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Promotor </td>
                                <td> <?php echo $mpromotor->getCampo('nombre',$detalle_venta['idPromotor'])." ".$mpromotor->getCampo('apellidoP',$detalle_venta['idPromotor'])." ".$mpromotor->getCampo('apellidoM',$detalle_venta['idPromotor']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Fecha de entrega </td>
                                <td> <?php echo date_format(new DateTime($detalle_entrega['fechaEntrega']), 'd/m/Y'); ?> </td> 
                            </tr>
                            <tr>
                                <td> ENTREGA DE VIVIENDA </td>
                                <td> <a href="uploads/alta_venta/entrega/<?php echo $detalle_entrega['pdf_12']; ?>" target="_blank"><i class="fa fa-eye" style="font-size: 18px;"></i> Ver Documento</a> </td> 
                            </tr>
                            <tr>
                                <td> REGLAMENTO DE FRACCIONAMIENTO </td>
                                <td> <a href="uploads/alta_venta/entrega/<?php echo $detalle_entrega['pdf_13']; ?>" target="_blank"><i class="fa fa-eye" style="font-size: 18px;"></i> Ver Documento</a> </td> 
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php
    } ?>
</div>
<div class="row">
    <?php if ( $etapa_encuesta == true ) {
    ?>
    <div class="col-md-6 col-sm-6 col-xs-12">
        <div class="portlet light bordered">
            <div class="portlet-title" style="border-bottom: 1px solid #f2a930;">
                <div class="caption fc-3">
                    <i class="fa fa-user font-green fc-3"></i>
                    <span class="caption-subject font-green bold uppercase fc-3">Encuesta</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-hover">
                        <!-- <thead>
                            <tr>
                                <th> Propiedad </th>
                                <th> Valor </th>
                            </tr>
                        </thead> -->
                        <tbody>
                            <tr>
                                <td> FECHA </td>
                                <td> <?php echo date_format(new DateTime($detalle_encuesta['fecha']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> ¿CÓMO CALIFICA EL TRATO DEL ASESOR DE VENTA? </td>
                                <td> <?php echo type_qualification_selected($detalle_encuesta['tratoAsesor']); ?> </td> 
                            </tr>  
                            <?php if ( $detalle_encuesta['tratoAsesor'] < 4 ) { ?>
                            <tr>
                                <td> ¿POR QUE? </td>
                                <td> <?php echo $detalle_encuesta['tratoAsesorWhy']; ?> </td> 
                            </tr>  
                            <?php } ?>
                            <tr>
                                <td> ¿CÓMO SE ENTERO DE NOSOTROS? </td>
                                <td> <?php echo radio_info_we($detalle_encuesta['nosotros']);  echo ($detalle_encuesta['nosotros'] == 8 ? ': '.$detalle_encuesta['nosotrosOtro'] : ''); ?> </td> 
                            </tr>
                            <tr>
                                <td> ¿SE MOSTRÓ LA CASA MUESTRA? </td>
                                <td> <?php echo ($detalle_encuesta['casaMuestra'] == 1 ? 'SI' : 'NO'); ?> </td> 
                            </tr>
                            <tr>
                                <td> ¿SE MOSTRÓ LA VIVIENDA A ADQUIRIR? </td>
                                <td> <?php echo ($detalle_encuesta['viviendaAdquirir'] == 1 ? 'SI' : 'NO'); ?> </td> 
                            </tr>
                            <tr>
                                <td> ¿LE EXPLICARON SOBRE EL TIEMPO DE TRÁMITE DE SU CRÉDITO? </td>
                                <td> <?php echo ($detalle_encuesta['tiempoTramite'] == 1 ? 'SI' : 'NO'); ?> </td> 
                            </tr>
                            <tr>
                                <td> ¿QUE GRADO DE ACEPTACIÓN ENCUENTRA NUESTRO FRACCIONAMIENTO? </td>
                                <td> <?php echo type_qualification_selected($detalle_encuesta['gradoAceptacionFracc']); ?> </td> 
                            </tr>
                            <tr>
                                <td> ¿CUÁL FUE LA RAZÓN POR LA QUE FUIMOS SU ELECCIÓN? </td>
                                <td> <?php echo $detalle_encuesta['razonEleccion']; ?> </td> 
                            </tr>
                            <tr>
                                <td> ¿QUE MEJORAS HARÍA A LA VIVIENDA? </td>
                                <td> <?php echo $detalle_encuesta['mejorasVivienda']; ?> </td> 
                            </tr>
                            <tr>
                                <td> ¿QUE MEJORAS HARÍA AL FRACCIONAMIENTO? </td>
                                <td> <?php echo $detalle_encuesta['mejorasfracc']; ?> </td> 
                            </tr>
                            <tr>
                                <td> ¿CUÁL FUE LA CONDICIÓN DE ENTREGA DE SU VIVIENDA? </td>
                                <td> <?php echo type_qualification_selected($detalle_encuesta['condicionEntregaVivienda']); ?> </td> 
                            </tr>
                            <?php if ( $detalle_encuesta['condicionEntregaVivienda'] < 4 ) { ?>
                            <tr>
                                <td> ¿POR QUE? </td>
                                <td> <?php echo $detalle_encuesta['condicionEntregaViviendaWhy']; ?> </td> 
                            </tr>
                            <?php } ?>
                            <tr>
                                <td> ¿NOS RECOMENDARÍA O COMPRARÍA NUEVAMENTE? </td>
                                <td> <?php echo ($detalle_encuesta['recomendacionCompra'] == 1 ? 'SI' : 'NO'); ?> </td> 
                            </tr>
                            <?php if ( $detalle_encuesta['recomendacionCompra'] == 2 ) { ?>
                            <tr>
                                <td> ¿POR QUE? </td>
                                <td> <?php echo $detalle_encuesta['recomendacionCompraWhy']; ?> </td> 
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php
    } 
    if ( $etapa_postventa == true ) {
    ?>
    <div class="col-md-6 col-sm-6 col-xs-12">
        <div class="portlet light bordered">
            <div class="portlet-title" style="border-bottom: 1px solid #f2a930;">
                <div class="caption fc-3">
                    <i class="fa fa-user font-green fc-3"></i>
                    <span class="caption-subject font-green bold uppercase fc-3">Postventa</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-hover">
                        <!-- <thead>
                            <tr>
                                <th> Propiedad </th>
                                <th> Valor </th>
                            </tr>
                        </thead> -->
                        <tbody>
                            <tr>
                                <td> Lote </td>
                                <td> <?php echo $detalle_venta['lote']; ?> </td> 
                            </tr>  
                            <tr>
                                <td> Manzana </td>
                                <td> <?php echo $detalle_venta['manzana']; ?> </td> 
                            </tr>  
                            <tr>
                                <td> Número oficial </td>
                                <td> <?php echo $detalle_venta['nOficial']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Calle </td>
                                <td> <?php echo $detalle_venta['calle']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Nombres </td>
                                <td> <?php echo $detalle_venta['nombre']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Apellido paterno </td>
                                <td> <?php echo $detalle_venta['apellidoP']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Apellido Materno </td>
                                <td> <?php echo $detalle_venta['apellidoM']; ?> </td> 
                            </tr>
                            <tr>
                                <td> RFC </td>
                                <td> <?php echo $detalle_venta['rfc']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Teléfono </td>
                                <td> <?php echo $detalle_venta['telefono']; ?> </td> 
                            </tr>
                            <tr>
                                <td> NSS </td>
                                <td> <?php echo $detalle_venta['nss']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Fecha de nacimiento </td>
                                <td> <?php echo date_format(new DateTime($detalle_venta['fechaNac']), 'd/m/Y'); ?> </td> 
                            </tr>
                            <tr>
                                <td> Estatus </td>
                                <td> <?php echo $detalle_venta['statusProyecto']; ?> </td> 
                            </tr>
                            <tr>
                                <td> Promotor </td>
                                <td> <?php echo $mpromotor->getCampo('nombre',$detalle_venta['idPromotor'])." ".$mpromotor->getCampo('apellidoP',$detalle_venta['idPromotor'])." ".$mpromotor->getCampo('apellidoM',$detalle_venta['idPromotor']); ?> </td> 
                            </tr>
                            <tr>
                                <td> Fecha de entrega </td>
                                <td> <?php echo date_format(new DateTime($detalle_entrega['fechaEntrega']), 'd/m/Y'); ?> </td> 
                            </tr>
                            <tr>
                                <td> Inst. Eléctricas </td>
                                <td> <?php echo date_format(new DateTime($detalle_postventa['instElectricas']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Inst. Hidráulicas </td>
                                <td> <?php echo date_format(new DateTime($detalle_postventa['instHidraulicas']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Inst. Sanitarias </td>
                                <td> <?php echo date_format(new DateTime($detalle_postventa['instSanitarias']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Inst. Gas </td>
                                <td> <?php echo date_format(new DateTime($detalle_postventa['instGas']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Cancelería </td>
                                <td> <?php echo $detalle_postventa['canceleria']; ?> </td> 
                            </tr>  
                            <tr>
                                <td> Impermeabilización </td>
                                <td> <?php echo date_format(new DateTime($detalle_postventa['impermeabilizacion']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Acabados </td>
                                <td> <?php echo date_format(new DateTime($detalle_postventa['acabados']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Estructural </td>
                                <td> <?php echo date_format(new DateTime($detalle_postventa['estructural']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Accesorios </td>
                                <td> <?php echo date_format(new DateTime($detalle_postventa['accesorios']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Calentador Agua </td>
                                <td> <?php echo date_format(new DateTime($detalle_postventa['calentadorAgua']), 'd/m/Y'); ?> </td> 
                            </tr>  
                            <tr>
                                <td> Escritura </td>
                                <td> <a href="uploads/alta_venta/postventa/<?php echo $detalle_postventa['pdf_14']; ?>" target="_blank"><i class="fa fa-eye" style="font-size: 18px;"></i> Ver Documento<!-- <img src="img/pdf.png"> --></a> </td> 
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php
    } ?>
</div>

<style type="text/css">
.table-scrollable{
    border: 1px solid #0CAE50;
}
.table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th{
    border-top: 1px solid #0CAE50;
}
.table > thead > tr > th{
    border-bottom: 1px solid #0CAE50;
}
</style>