<?php

    class mcliente extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "clientes";
            $this->alias = 'c';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".nombre
            ,".$this->alias.".apellido
            ,".$this->alias.".direccion
            ,".$this->alias.".cp
            ,".$this->alias.".telefono
            ,".$this->alias.".celular
            ,".$this->alias.".email
            ,".$this->alias.".estado
            ,".$this->alias.".ciudad
            ,".$this->alias.".pais
            ,".$this->alias.".razon_social
            ,".$this->alias.".tipo_persona
            ,".$this->alias.".rfc
            ,".$this->alias.".info
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'nombre' => '',
                'apellido' => '',
                'direccion' => '',
                'cp' => '',
                'telefono' => '',
                'celular' => '',
                'email' => '',
                'estado' => '',
                'ciudad' => '',
                'pais' => '',
                'razon_social' => '',
                'tipo_persona' => '',
                'rfc' => '',
                'completarInfo' => '',
                'status' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['nombre'] = $r->row()->nombre;
                $array['apellido'] = $r->row()->apellido;
                $array['direccion'] = $r->row()->direccion;
                $array['cp'] = $r->row()->cp;
                $array['telefono'] = $r->row()->telefono;
                $array['celular'] = $r->row()->celular;
                $array['email'] = $r->row()->email;
                $array['estado'] = $r->row()->estado;
                $array['ciudad'] = $r->row()->ciudad;
                $array['pais'] = $r->row()->pais;
                $array['razon_social'] = $r->row()->razon_social;
                $array['tipo_persona'] = $r->row()->tipo_persona;
                $array['rfc'] = $r->row()->rfc;
                //completarInfo es el campo info en la tabla de clientes
                $array['completarInfo'] = $r->row()->info;
                $array['status'] = $r->row()->status;

            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getCliAndCon(){
            $query=$this->db->query("
            SELECT c.id, (null) as idCliente,c.nombre,c.apellido
            FROM clientes as c
                UNION
                SELECT pc.id,pc.idCliente,pc.nombre,pc.apellido
                FROM personas_contacto as pc
            ");

            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getCliente($id){
            $query=$this->db->query("
            SELECT c.id,c.nombre,c.apellido
            FROM clientes as c
            where c.id = ".$id."
            ");

            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

    }