<?php
    class mtasks extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "tasks";
            $this->alias = 'n';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".url_func
            ,".$this->alias.".idItem
            ,".$this->alias.".periodo
            ,".$this->alias.".descripcion
            ,".$this->alias.".tipo
            ,".$this->alias.".status
            ,".$this->alias.".created";
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query->row();
            }else{
                return 0;
            }
        }

        function getByStatus($status){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => $status);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }