<?php

class mrtest extends MY_Model{

    var $column_order = array("id");

    var $column_search = array("titulo","costo","fecha_inicio","fecha_fin","moneda","created");
    var $order = array('id' => 'desc'); // default order
    var $info;
    var $query="";

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    ///////////Inician funciones de carga del lado del servidor///////////
    private function _get_datatables_query(){
        //Inicia query customizada
        $this->query="SELECT p.*, (SELECT count(id) from detalle_paquete where idPaquete = p.id) as lotes FROM paquetes p INNER JOIN estimacion_programa e ON e.idPaquete = p.id 
        INNER JOIN mano_obra m ON m.id = p.idManoObra INNER JOIN detalle_paquete dp ON dp.idPaquete = p.id WHERE p.status = 1 ";
        //Adaptación especial para que trabaje con UNION
        $i=0;
        
        foreach ($this->column_search as $item){
            if($_POST['search']['value']) {

                if($i===0){
                    $query.=" AND (p.".$item." LIKE '%".$_POST['search']['value']."%'";
                }else{
                    $query.=" OR p.".$item." LIKE '%".$_POST['search']['value']."%'";
                }
                if(count($this->column_search) - 1 == $i) //last loop
                    $query.=")";
            }
            $i++;
        }
        //Termina adaptación especial

        //Llamando a la función que creará los filtros
        $this->createFilters();

        $this->query.= " GROUP BY dp.idPaquete";
        //Adaptación genérica, no se modifica.
        if(isset($_POST['order'])){
            $this->query.=" ORDER BY p.".$this->column_order[$_POST['order']['0']['column']]." ".$_POST['order']['0']['dir'];
        }else if(isset($this->order)){
            $order = $this->order;
            $this->query.=" ORDER BY p.".key($order)." ".$order[key($order)];
        }
        //Termina adaptación genérica
    }

    function get_datatables(){
        $this->info=$_REQUEST["info"];
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->query.=" LIMIT ".$_POST['start'].",".$_POST['length'];
        /*echo $this->query;
        exit();*/
        $this->query = $this->db->query($this->query);
        if($this->query->num_rows() > 0){
            return $this->query;
        }else{
            return 0;
        }
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $this->query = $this->db->query($this->query);
        return $this->query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        $this->query = $this->db->query($this->query);
        return $this->query->num_rows();
    }
    ////////////Terminan de carga del del lado del servidor////////////

    //Función para filtros automáticos
    public function createFilters(){
        foreach ($this->info as $key => $val) {
            if($val != "" AND $val != 0){
                switch($key){
                    case 'fecha_inicio': $fecha1 = $val;
                        if(isset($fecha2)){
                            $this->query.=" AND ( (p.fecha_inicio BETWEEN '{$fecha1}' AND '{$fecha2}' ) ";
                            $this->query.=" OR (p.fecha_fin BETWEEN '{$fecha1}' AND '{$fecha2}' ) )";
                        }
                        break;
                    case 'fecha_fin': $fecha2 = $val;
                        if(isset($fecha1)){
                            $this->query.=" AND ( (p.fecha_inicio BETWEEN '{$fecha1}' AND '{$fecha2}' ) ";
                            $this->query.=" OR (p.fecha_fin BETWEEN '{$fecha1}' AND '{$fecha2}' ) )";
                        }
                        break;
                    case 'idResidente': $this->query.= " AND dp.{$key} = {$val}";
                        break;
                    case 'idFraccionamiento': $this->query.= " AND m.{$key} = {$val}";
                        break;
                    case 'idPrototipo': $this->query.= " AND m.{$key} = {$val}";
                        break;
                    default: $this->query.=" AND p.{$key} = {$val} ";
                        break;
                }
            }
        }
    }

}
