<?php

    class mrequisiciones_detalle extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "requisiciones_detalle";
            $this->alias = 'req';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idRequisicion
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".idAlmacen
            ,".$this->alias.".idPaquete
            ,".$this->alias.".idMaterial
            ,".$this->alias.".idProyecto
            ,".$this->alias.".idArticulo
            ,".$this->alias.".cantidad
            ,".$this->alias.".idPresupuesto
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r){
            $array = array(
                'id' => '',
                'idRequisicion' => '',
                'idEmpresa' => '',
                'idAlmacen' => '',
                'idPaquete' => '',
                'idMaterial' => '',
                'idProyecto' => '',
                'idArticulo' => '',
                'cantidad' => '',
                'idPresupuesto' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idRequisicion'] = $r->row()->idRequisicion;
                $array['idEmpresa'] = $r->row()->idEmpresa;
                $array['idAlmacen'] = $r->row()->idAlmacen;
                $array['idPaquete'] = $r->row()->idPaquete;
                $array['idMaterial'] = $r->row()->idMaterial;
                $array['idProyecto'] = $r->row()->idProyecto;
                $array['idArticulo'] = $r->row()->idArticulo;
                $array['cantidad'] = $r->row()->cantidad;
                $array['idPresupuesto'] = $r->row()->idPresupuesto;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "asc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByIdRequisicion($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idRequisicion' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }