<?php

class mrcontado extends MY_Model{

    public function __construct(){
        parent::__construct();
        //Variables de subquerys

        //Variables globales
        $this->column_order = array(
            0 => 'cliente',
            1 => 'fraccionamiento',
            2 => 'manzana',
            3 => 'lote',
            4 => 'nOficial',
            5 => 'prototipo',
            6 => 'supTerreno',
            7 => 'cc.plazos',
            8 => 'cc.monto',
            9 => 'cd.importe',
            10 => 'cc.pagos',
            11 => 'cd.saldo',
            12 => 'cd.movimiento',
            14 => 'cd.statusDetalle',
        );
        $this->column_search = array(
            'cd.id',
            '(SELECT supTerreno FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))',
            '(SELECT UPPER(nombre) FROM prototipos WHERE id = (SELECT idPrototipo FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)))',
            '(SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)))',
            '(SELECT ronda FROM gestoria WHERE idAltaVenta = cc.idAltaVenta)',
            '(SELECT manzana FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))',
            '(SELECT lote FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))',
            '(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta))',
            '(SELECT UPPER(CONCAT(nombre," ",apellidoP," ",apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta)))',
            '(SELECT nOficial FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))',
            'cc.plazos',
            'cc.monto',
            'cd.importe',
            'cc.pagos',
            'cd.saldo',
            'cd.movimiento',
            'cd.statusDetalle',
        );
        $this->order = array('id' => 'DESC');
        $this->info="";
        $this->query="";
    }

    ///////////Inician funciones de carga del lado del servidor///////////
    private function _get_datatables_query(){
        //Inicia query customizada
        $this->query="SELECT
                        cd.id,
                        (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta) AS idProyecto,
                        (SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta) AS idProspecto,
                        (SELECT idPromotor FROM prospectos WHERE id = (SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS idPromotor,
                        (SELECT idPrototipo FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS idPrototipo,
                        (SELECT idFraccionamiento FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS idFraccionamiento,
                        (SELECT supTerreno FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS supTerreno,
                        (SELECT UPPER(nombre) FROM prototipos WHERE id = (SELECT idPrototipo FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))) AS prototipo,
                        (SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))) AS fraccionamiento,
                        (SELECT ronda FROM gestoria WHERE idAltaVenta = cc.idAltaVenta) AS ronda,
                        (SELECT manzana FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS manzana,
                        (SELECT lote FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS lote,
                        (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS cliente,
                        (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta))) AS promotor,
                        (SELECT nOficial FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS nOficial,
                        cc.plazos,
                        cc.monto,
                        cd.importe,
                        cc.pagos,
                        cd.saldo,
                        cd.movimiento,
                        cd.comprobante,
                        cd.statusDetalle
                    FROM contado_cuentas AS cc INNER JOIN contado_detalle AS cd ON cc.id = cd.idCuenta
                    WHERE cc.status = 1 AND cd.tipo = 1";

        //Adaptación especial para que trabaje con UNION
        $i=0;
        foreach ($this->column_search as $item){
            if($_POST['search']['value']) {

                if($i===0){
                    $this->query.=" AND (".$item." LIKE '%".$_POST['search']['value']."%'";
                }else{
                    $this->query.=" OR ".$item." LIKE '%".$_POST['search']['value']."%'";
                }
                if(count($this->column_search) - 1 == $i) //last loop
                    $this->query.=")";
            }
            $i++;
        }
        //Termina adaptación especial

        //Llamando a la función que creará los filtros
        $this->createFilters();
        //Adaptación genérica, no se modifica.
        if(isset($_POST['order'])){
            $this->query.=" ORDER BY ".$this->column_order[$_POST['order']['0']['column']]." ".$_POST['order']['0']['dir'];
        }else if(isset($this->order)){
            $order = $this->order;
            $this->query.=" ORDER BY ".key($order)." ".$order[key($order)];
        }
        //Termina adaptación genérica
    }

    function get_datatables(){
        $this->info=$_REQUEST["info"];
        $this->_get_datatables_query();

        if($_POST['length'] != -1)
        $this->query.=" LIMIT ".$_POST['start'].",".$_POST['length'];
        $this->query = $this->db->query($this->query);

        if($this->query->num_rows() > 0){
            return $this->query;
        }else{
            return 0;
        }
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $this->query = $this->db->query($this->query);
        return $this->query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        $this->query = $this->db->query($this->query);
        return $this->query->num_rows();
    }
    ////////////Terminan de carga del del lado del servidor////////////

    //Función para filtros automáticos
    public function createFilters(){
        foreach ($this->info as $key => $val) {
            if($val != "" AND $val != 0){
                switch($key){
                    case 'fecha_inicio': 
                        $fecha_inicio = date_format(new DateTime($val),"Y-m-d");
                        break;
                    case 'fecha_fin': 
                        $fecha_fin = date_format(new DateTime($val),"Y-m-d");
                        if ($fecha_inicio != "" && $fecha_fin != "") {
                            if($fecha_inicio != $fecha_fin){
                                $this->query.=" AND cd.fecha >= '$fecha_inicio' AND cd.fecha <= '$fecha_fin' + INTERVAL 1 DAY ";
                            }else{
                                $this->query.=" AND DATE(cd.fecha) = DATE('$fecha_inicio') ";
                            }
                        }
                        break;
                    case 'fraccionamiento': 
                        $this->query.=" AND (SELECT idFraccionamiento FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))=$val ";
                        break;
                    case 'promotor': 
                        $this->query.=" AND (SELECT idPromotor FROM prospectos WHERE id = (SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta))=$val ";
                        break;
                    case 'manzana': 
                        $this->query.=" AND (SELECT manzana FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))=$val ";
                        break;
                    case 'prototipo': 
                        $this->query.=" AND (SELECT idPrototipo FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))=$val ";
                        break;
                    case 'status': 
                        $this->query.=" AND cd.statusDetalle=$val ";
                        break;
                    /*default: $this->query.=" AND {cc.$key} = {$val} ";
                        break;*/
                }
            }
        }
    }

    public function getAllExcel()
    {
        $query = $this->db->query("SELECT
                                    cd.id,
                                    (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta) AS idProyecto,
                                    (SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta) AS idProspecto,
                                    (SELECT idPromotor FROM prospectos WHERE id = (SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS idPromotor,
                                    (SELECT idPrototipo FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS idPrototipo,
                                    (SELECT idFraccionamiento FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS idFraccionamiento,
                                    (SELECT supTerreno FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS supTerreno,
                                    (SELECT UPPER(nombre) FROM prototipos WHERE id = (SELECT idPrototipo FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))) AS prototipo,
                                    (SELECT UPPER(titulo) FROM fraccionamientos WHERE id = (SELECT idFraccionamiento FROM proyectos WHERE id = (SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta))) AS fraccionamiento,
                                    (SELECT ronda FROM gestoria WHERE idAltaVenta = cc.idAltaVenta) AS ronda,
                                    (SELECT manzana FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS manzana,
                                    (SELECT lote FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS lote,
                                    (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS cliente,
                                    (SELECT UPPER(CONCAT(nombre,' ',apellidoP,' ',apellidoM)) FROM usuarios WHERE id=(SELECT idPromotor FROM prospectos WHERE id=(SELECT idProspecto FROM alta_venta WHERE id = cc.idAltaVenta))) AS promotor,
                                    (SELECT nOficial FROM proyectos WHERE id=(SELECT idProyecto FROM alta_venta WHERE id = cc.idAltaVenta)) AS nOficial,
                                    cc.plazos,
                                    cc.monto,
                                    cd.importe,
                                    cc.pagos,
                                    cd.saldo,
                                    cd.movimiento,
                                    cd.comprobante,
                                    cd.statusDetalle
                                FROM contado_cuentas AS cc INNER JOIN contado_detalle AS cd ON cc.id = cd.idCuenta
                                WHERE cc.status = 1 AND cd.tipo = 1");
        if($query->num_rows() > 0){
            return $query;
        }else{
            return 0;
        }
    }

}
