<?php
    class mproveedor extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "proveedores";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".nombre
            ,".$this->alias.".clave
            ,".$this->alias.".contacto1
            ,".$this->alias.".contacto2
            ,".$this->alias.".rfc
            ,".$this->alias.".moneda_id
            ,".$this->alias.".moneda
            ,".$this->alias.".ciudad_id
            ,".$this->alias.".ciudad
            ,".$this->alias.".cp
            ,".$this->alias.".telefono1
            ,".$this->alias.".telefono2
            ,".$this->alias.".email
            ,".$this->alias.".estatus";

            $this->selectResult = "".
                $this->alias.".id
                ,".$this->alias.".nombre as titulo";

        }


        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idEmpresa' => '',
                'nombre' => '',
                'clave' => '',
                'contacto1' => '',
                'contacto2' => '',
                'rfc' => '',
                'moneda_id' => '',
                'moneda' => '',
                'ciudad_id' => '',
                'ciudad' => '',
                'cp' => '',
                'telefono1' => '',
                'telefono2' => '',
                'email' => '',
                'estatus' => '',
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idEmpresa'] = $r->row()->idEmpresa;
                $array['nombre'] = $r->row()->nombre;
                $array['clave'] = $r->row()->clave;
                $array['contacto1'] = $r->row()->contacto1;
                $array['contacto2'] = $r->row()->contacto2;
                $array['rfc'] = $r->row()->rfc;
                $array['moneda_id'] = $r->row()->moneda_id;
                $array['moneda'] = $r->row()->moneda;
                $array['ciudad_id'] = $r->row()->ciudad_id;
                $array['ciudad'] = $r->row()->ciudad;
                $array['cp'] = $r->row()->cp;
                $array['telefono1'] = $r->row()->telefono1;
                $array['telefono2'] = $r->row()->telefono2;
                $array['email'] = $r->row()->email;
                $array['estatus'] = $r->row()->estatus;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }  

        function getAllFiltro($idEmpresa){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.idEmpresa' => $idEmpresa);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }  

        function getAllExcelRows(){
            $id = $_SESSION["viv"]['idEmpresa'];
             $query=$this->db->query("
                SELECT `nombre`,`clave`,`rfc`,`ciudad`,`cp`,`email` 
                FROM `proveedores`
                WHERE `idEmpresa`= $id ORDER BY  id  DESC "
            );
             
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getTableHead($table){
             $query=$this->db->query("SHOW COLUMNS FROM  $table");

            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

         function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            return 0;
        }

        function getByNombre($nombre,$idEmpresa){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.nombre' => $nombre,$this->alias.'.idEmpresa' => $idEmpresa);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getSelectResult($idEmpresa=0){
            $idEmpresa=($idEmpresa==0) ? $_SESSION["viv"]["idEmpresa"] : $idEmpresa;
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.estatus' => 'ACTIVO',$this->alias.'.idEmpresa' => $idEmpresa);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function valInsert($id,$idEmpresa){
            $query=$this->db->query("SELECT id FROM proveedores WHERE id=$id AND idEmpresa=$idEmpresa");
            return ($query->num_rows()>0) ? false : true;
        }

        function valUpdate($id,$data){
            $search="";
            foreach ($data as $key => $val) {
                switch ($key) {
                    case 'id':
                        $id=$val;
                        break;
                    default:
                        $search .=' AND '.$key.'="'.$val.'"';
                }
            }
            $query=$this->db->query("SELECT id FROM proveedores WHERE id=$id $search");
            return ($query->num_rows()>0) ? false : true;
        }


        // var $table = 'logs';
        var $column_order = array(null, 'nombre','clave','rfc','ciudad','cp','idEmpresa'); //set column field database for datatable orderable
        var $column_search = array('nombre','clave','rfc','ciudad','cp','idEmpresa'); //set column field database for datatable searchable
        var $order = array('id' => 'desc'); // default order



     

        private function _get_datatables_query()
        {

         $this->db->from($this->table);
        


        if($_SESSION["viv"]["idEmpresa"] > 0){
             $id=$_SESSION["viv"]["idEmpresa"];
             $arrayWhere = array('idEmpresa' => $id);
             $this->db->where($arrayWhere);

        }

            $i = 0;

            foreach ($this->column_search as $item) // loop column
            {
                if($_POST['search']['value']) // if datatable send POST for search
                {

                    if($i===0) // first loop
                    {
                        $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                        $this->db->like($item, $_POST['search']['value']);
                    }
                    else
                    {
                        $this->db->or_like($item, $_POST['search']['value']);
                    }

                    if(count($this->column_search) - 1 == $i) //last loop
                        $this->db->group_end(); //close bracket
                }
                $i++;
            }

            if(isset($_POST['order'])) // here order processing
            {
                $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
            }
            else if(isset($this->order))
            {
                $order = $this->order;
                $this->db->order_by(key($order), $order[key($order)]);
            }



        }
        
        function get_datatables()
        {
            $this->_get_datatables_query();
            if($_POST['length'] != -1)
            $this->db->limit($_POST['length'], $_POST['start']);
            $query = $this->db->get();
            return $query->result();
        }                   

        function count_filtered()
        {
            $this->_get_datatables_query();
            $query = $this->db->get();
            return $query->num_rows();
        }

        public function count_all()
        {
            $this->db->from($this->table);
            return $this->db->count_all_results();
        }
       
    }