<?php

    class Mprototipos extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "prototipos";
            $this->alias = 'pt';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".nombre
            ,".$this->alias.".estimaciones
            ,".$this->alias.".superficieM2
            ,".$this->alias.".costoCimentacion
            ,".$this->alias.".avanceCimentacion
            ,".$this->alias.".costoAlbPlantaBaja
            ,".$this->alias.".avanceAlbPlantaBaja
            ,".$this->alias.".costoLosaEntrepiso
            ,".$this->alias.".avanceLosaEntrepiso
            ,".$this->alias.".costoAlbPrimerNivel
            ,".$this->alias.".avanceAlbPrimerNivel
            ,".$this->alias.".costoLosaPrimerNivel
            ,".$this->alias.".avanceLosaPrimerNivel
            ,".$this->alias.".costoAzotea
            ,".$this->alias.".avanceAzotea
            ,".$this->alias.".costoFachada
            ,".$this->alias.".avanceFachada
            ,".$this->alias.".costoAcabados
            ,".$this->alias.".avanceAcabados
            ,".$this->alias.".costoPisos
            ,".$this->alias.".avancePisos
            ,".$this->alias.".costoInstHidroGas
            ,".$this->alias.".avanceInstHidroGas
            ,".$this->alias.".costoCanceleria
            ,".$this->alias.".avanceCanceleria
            ,".$this->alias.".costoElectrica
            ,".$this->alias.".avanceElectrica
            ,".$this->alias.".costoObraExterior
            ,".$this->alias.".avanceObraExterior
            ,".$this->alias.".costoBardas
            ,".$this->alias.".avanceBardas
            ,".$this->alias.".costoLimpieza
            ,".$this->alias.".avanceLimpieza
            ,".$this->alias.".costoExtra
            ,".$this->alias.".avanceExtra
            ,".$this->alias.".costoImpermeabilizacion
            ,".$this->alias.".avanceImpermeabilizacion
            ,".$this->alias.".costoEcotecnologias
            ,".$this->alias.".avanceEcotecnologias
            ,".$this->alias.".pdf_1
            ,".$this->alias.".nombre AS titulo
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'nombre' => '',
                'estimaciones' => '',
                'superficieM2' => '',
                'costoCimentacion' => '',
                'avanceCimentacion' => '',
                'costoAlbPlantaBaja' => '',
                'avanceAlbPlantaBaja' => '',
                'costoLosaEntrepiso' => '',
                'avanceLosaEntrepiso' => '',
                'costoAlbPrimerNivel' => '',
                'avanceAlbPrimerNivel' => '',
                'costoLosaPrimerNivel' => '',
                'avanceLosaPrimerNivel' => '',
                'costoAzotea' => '',
                'avanceAzotea' => '',
                'costoFachada' => '',
                'avanceFachada' => '',
                'costoAcabados' => '',
                'avanceAcabados' => '',
                'costoPisos' => '',
                'avancePisos' => '',
                'costoInstHidroGas' => '',
                'avanceInstHidroGas' => '',
                'costoCanceleria' => '',
                'avanceCanceleria' => '',
                'costoElectrica' => '',
                'avanceElectrica' => '',
                'costoObraExterior' => '',
                'avanceObraExterior' => '',
                'costoBardas' => '',
                'avanceBardas' => '',
                'costoLimpieza' => '',
                'avanceLimpieza' => '',
                'costoExtra' => '',
                'avanceExtra' => '',
                'costoImpermeabilizacion' => '',
                'avanceImpermeabilizacion' => '',
                'costoEcotecnologias' => '',
                'avanceEcotecnologias' => '',
                'pdf_1' => '',
                'titulo' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['nombre'] = $r->row()->nombre;
                $array['estimaciones'] = $r->row()->estimaciones;
                $array['superficieM2'] = $r->row()->superficieM2;
                $array['costoCimentacion'] = $r->row()->costoCimentacion;
                $array['avanceCimentacion'] = $r->row()->avanceCimentacion;
                $array['costoAlbPlantaBaja'] = $r->row()->costoAlbPlantaBaja;
                $array['avanceAlbPlantaBaja'] = $r->row()->avanceAlbPlantaBaja;
                $array['costoLosaEntrepiso'] = $r->row()->costoLosaEntrepiso;
                $array['avanceLosaEntrepiso'] = $r->row()->avanceLosaEntrepiso;
                $array['costoAlbPrimerNivel'] = $r->row()->costoAlbPrimerNivel;
                $array['avanceAlbPrimerNivel'] = $r->row()->avanceAlbPrimerNivel;
                $array['costoLosaPrimerNivel'] = $r->row()->costoLosaPrimerNivel;
                $array['avanceLosaPrimerNivel'] = $r->row()->avanceLosaPrimerNivel;
                $array['costoAzotea'] = $r->row()->costoAzotea;
                $array['avanceAzotea'] = $r->row()->avanceAzotea;
                $array['costoFachada'] = $r->row()->costoFachada;
                $array['avanceFachada'] = $r->row()->avanceFachada;
                $array['costoAcabados'] = $r->row()->costoAcabados;
                $array['avanceAcabados'] = $r->row()->avanceAcabados;
                $array['costoPisos'] = $r->row()->costoPisos;
                $array['avancePisos'] = $r->row()->avancePisos;
                $array['costoInstHidroGas'] = $r->row()->costoInstHidroGas;
                $array['avanceInstHidroGas'] = $r->row()->avanceInstHidroGas;
                $array['costoCanceleria'] = $r->row()->costoCanceleria;
                $array['avanceCanceleria'] = $r->row()->avanceCanceleria;
                $array['costoElectrica'] = $r->row()->costoElectrica;
                $array['avanceElectrica'] = $r->row()->avanceElectrica;
                $array['costoObraExterior'] = $r->row()->costoObraExterior;
                $array['avanceObraExterior'] = $r->row()->avanceObraExterior;
                $array['costoBardas'] = $r->row()->costoBardas;
                $array['avanceBardas'] = $r->row()->avanceBardas;
                $array['costoLimpieza'] = $r->row()->costoLimpieza;
                $array['avanceLimpieza'] = $r->row()->avanceLimpieza;
                $array['costoExtra'] = $r->row()->costoExtra;
                $array['avanceExtra'] = $r->row()->avanceExtra;
                $array['costoImpermeabilizacion'] = $r->row()->costoImpermeabilizacion;
                $array['avanceImpermeabilizacion'] = $r->row()->avanceImpermeabilizacion;
                $array['costoEcotecnologias'] = $r->row()->costoEcotecnologias;
                $array['avanceEcotecnologias'] = $r->row()->avanceEcotecnologias;
                $array['pdf_1'] = $r->row()->pdf_1;
                $array['titulo'] = $r->row()->titulo;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByTitulo($titulo){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.nombre' => $titulo);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                $query=$query->row();
                return $query->id;
            }else{
                return 0;
            }
        }

    }