<?php

    class Mpresupuestos extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "presupuestos";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
                ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idEmpresa
            ,".$this->alias.".idPrototipo
            ,".$this->alias.".titulo
            ,".$this->alias.".idPmo
            ,".$this->alias.".idPmat
            ,".$this->alias.".statusPpto
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idFraccionamiento' => '',
                'idEmpresa' => '',
                'idPrototipo' => '',
                'titulo' => '',
                'idPmo' => '',
                'idPmat' => '',
                'statusPpto' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idEmpresa'] = $r->row()->idEmpresa;
                $array['idPrototipo'] = $r->row()->idPrototipo;
                $array['titulo'] = $r->row()->titulo;
                $array['idPmo'] = $r->row()->idPmo;
                $array['idPmat'] = $r->row()->idPmat;
                $array['statusPpto'] = $r->row()->statusPpto;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }    
    
        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByCond($where){
            $this->db->select($this->selectDefault,FALSE);
            $this->db->where($where);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
}