<?php

    class Mpresupuestomat extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "presupuesto_mat";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idMaterial
            ,".$this->alias.".idMateriales
            ,".$this->alias.".idProveedor
            ,".$this->alias.".clave
            ,".$this->alias.".clave_cat
            ,".$this->alias.".precioUnitario
            ,".$this->alias.".cantidad
            ,".$this->alias.".importe
            ,".$this->alias.".semana
            ,".$this->alias.".tipo
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idMaterial' => '',
                'idMateriales' => '',
                'idProveedor' => '',
                'clave' => '',
                'clave_cat' => '',
                'precioUnitario' => '',
                'cantidad' => '',
                'importe' => '',
                'semana' => '',
                'tipo' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idMaterial'] = $r->row()->idMaterial;
                $array['idMateriales'] = $r->row()->idMateriales;
                $array['idProveedor'] = $r->row()->idProveedor;
                $array['clave'] = $r->row()->clave;
                $array['clave_cat'] = $r->row()->clave_cat;
                $array['precioUnitario'] = $r->row()->precioUnitario;
                $array['cantidad'] = $r->row()->cantidad;
                $array['importe'] = $r->row()->importe;
                $array['semana'] = $r->row()->semana;
                $array['tipo'] = $r->row()->tipo;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }


        function getAllExcelRows(){
             $query=$this->db->query("
            SELECT `idMaterial`,`idMateriales`,`precioUnitario`,`importe`
            FROM `presupuesto_mat`
            ");
             
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getSumTotalUnitario($idMaterial){
            $this->db->select_sum($this->alias.'.importe');
            $arrayWhere = array($this->alias.'.idMaterial' => $idMaterial);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->row()->importe > 0){
                return $query->row()->importe;
            }else{
                return 0;
            }
        }

        function getByIdMaterialIdMaterialesPrototipo($idMaterial, $idMatProt){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idMaterial' => $idMaterial,
                $this->alias.'.idMateriales' => $idMatProt);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdMaterial($idMaterial, $filtroSemana=0){
            $this->db->select($this->selectDefault, FALSE);
            if($filtroSemana > 0){
                $arrayWhere = array($this->alias . '.idMaterial' => $idMaterial, $this->alias . '.semana' => $filtroSemana);
            }else{
                $arrayWhere = array($this->alias . '.idMaterial' => $idMaterial);
            }
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias . '.semana', "asc");
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getByIdMaterial2($idMaterial, $filtroSemana, $idOrdenCompra){
            $query = $this->db->query("SELECT p.id, p.idMaterial, p.idMateriales, p.idProveedor, p.precioUnitario, p.importe, d.unidades, d.precio_unitario, p.semana, p.status 
                                        FROM presupuesto_mat AS p INNER JOIN detalle_orden AS d ON p.id = d.idPresupuestoMat 
                                        WHERE p.idMaterial = $idMaterial AND p.semana = $filtroSemana AND d.id_orden_compra = $idOrdenCompra ORDER BY p.id ASC");
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getByIdMaterialSemanaPaquete($idMaterial, $filtroSemana, $idPaquete){
            $this->db->select($this->selectDefault, FALSE);
            if($filtroSemana > -1){
                $arrayWhere = array($this->alias . '.idMaterial' => $idMaterial, $this->alias . '.semana' => $filtroSemana);
            }else{
                $arrayWhere = array($this->alias . '.idMaterial' => $idMaterial);
            }
            $this->db->where($arrayWhere);
            //$this->db->where($this->alias . '.id NOT IN (SELECT d.idPresupuestoMat FROM orden_compra AS o INNER JOIN detalle_orden AS d WHERE o.idMaterial = '. $idMaterial .' AND d.idPresupuestoMat = p.id AND o.idPaquete = '.$idPaquete.')');
            $this->db->order_by($this->alias . '.id', "asc");
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getMaterialJoinOc($idEmpresa,$idPaquete,$semana="",$tipoAlmacen=0){
            $almacen=$this->malmacenes->getByIdPaquete($idEmpresa,$idPaquete);
            $id_almacen=(!is_numeric($almacen)) ? $almacen->id : 0;
            $filter="";
            if ($semana != "") {
                $filter.=" AND pmat.semana=".$semana;
            }
            if($tipoAlmacen==1){
                $filter.=" AND mate.idPaquete = '$idPaquete'";
            }else if($tipoAlmacen==2){
                $filter.=" AND FIND_IN_SET(mate.idPaquete,'$idPaquete')";
            }
            $query="
                (
                    SELECT 
                        1 tipo,
                        doc.id_articulo,
                        pmat.id idPresupuesto,
                        pmat.idProveedor,
                        prov.nombre proveedor,
                        pmat.semana,
                        pmat.clave clave,
                        mat.nombre articulo,
                        mat.unidad_compra unidad,
                        cmat.categoria categoria_mat,
                        cmat.clave clave_mat,
                        AVG(DISTINCT pmat.precioUnitario) precio_unitario,
                        (SUM(DISTINCT mact.cantidad + pmat.id) - SUM(DISTINCT pmat.id) ) unidades_viv,
                        (SUM(DISTINCT (mact.cantidad * paq.nLotes)  + pmat.id) - SUM(DISTINCT pmat.id)) unidades_paq,
                        (SUM(DISTINCT (mact.cantidad*pmat.precioUnitario) * paq.nLotes + pmat.id) - SUM(DISTINCT pmat.id)) importe_paq,
                        ( SUM(DISTINCT (doc.unidades -doc.unidades_devueltas) + doc.id) - SUM(DISTINCT doc.id) ) comprado,
                        ((SUM(DISTINCT (mact.cantidad * paq.nLotes)  + pmat.id) - SUM(DISTINCT pmat.id)) - ( SUM(DISTINCT (doc.unidades - doc.unidades_devueltas) + doc.id) - SUM(DISTINCT doc.id) )) pendiente
                    FROM presupuesto_mat pmat
                    LEFT JOIN categorias_mat cmat ON CONVERT(cmat.clave USING utf8) = CONVERT(pmat.clave_cat USING utf8)
                    LEFT JOIN proveedores prov ON prov.id=pmat.idProveedor AND prov.idEmpresa=$idEmpresa
                    LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
                    LEFT JOIN material mate ON mate.id=pmat.idMaterial AND mate.idEmpresa=$idEmpresa
                    LEFT JOIN paquetes paq ON paq.id=mate.idPaquete

                    LEFT JOIN almacenes al ON al.idEmpresa=$idEmpresa AND al.id=$id_almacen
                    LEFT JOIN materiales mat ON mat.id=mact.idMaterial AND mat.idEmpresa=$idEmpresa
                    LEFT JOIN detalle_orden doc ON doc.id_articulo=mact.idMaterial AND CONVERT(doc.clave_articulo USING utf8) = CONVERT(pmat.clave USING utf8) AND doc.idEmpresa=$idEmpresa AND doc.id_almacen=$id_almacen
                    LEFT JOIN orden_compra oc ON oc.idEmpresa=$idEmpresa AND oc.id=doc.id_orden_compra
                    WHERE oc.estatus != 'CANCELADA' AND doc.idEmpresa=$idEmpresa AND oc.id_almacen=$id_almacen $filter
                    GROUP BY pmat.clave_cat, pmat.clave, mact.idMaterial, pmat.idProveedor
                )
                UNION ALL
                (
                    SELECT 
                        2 tipo,
                        mact.idMaterial id_articulo,
                        pmat.id idPresupuesto,
                        pmat.idProveedor,
                        prov.nombre proveedor,
                        pmat.semana,
                        pmat.clave clave,
                        mat.nombre articulo,
                        mat.unidad_compra unidad,
                        cmat.categoria categoria_mat,
                        cmat.clave clave_mat,
                        AVG(DISTINCT pmat.precioUnitario) precio_unitario,
                        ( SUM(DISTINCT mact.cantidad + mact.id) - SUM(DISTINCT mact.id) ) unidades_viv,
                        ROUND((( SUM(DISTINCT (mact.cantidad*pmat.precioUnitario) * paq.nLotes + pmat.id) - SUM(DISTINCT pmat.id) ) / AVG(DISTINCT pmat.precioUnitario)),2) unidades_paq,
                        ( SUM(DISTINCT (mact.cantidad*pmat.precioUnitario) * paq.nLotes + pmat.id) - SUM(DISTINCT pmat.id) ) importe_paq,
                        0 comprado,
                        ROUND((( SUM(DISTINCT (mact.cantidad*pmat.precioUnitario) * paq.nLotes + pmat.id) - SUM(DISTINCT pmat.id) ) / AVG(DISTINCT pmat.precioUnitario)),2) pendiente
                    FROM presupuesto_mat pmat 
                    LEFT JOIN categorias_mat cmat ON CONVERT(cmat.clave USING utf8) = CONVERT(pmat.clave_cat USING utf8)
                    LEFT JOIN proveedores prov ON prov.id=pmat.idProveedor AND prov.idEmpresa=$idEmpresa
                    LEFT JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
                    LEFT JOIN material mate ON mate.id=pmat.idMaterial AND mate.idEmpresa=$idEmpresa
                    LEFT JOIN paquetes paq ON paq.id=mate.idPaquete

                    LEFT JOIN almacenes al ON al.idEmpresa=$idEmpresa AND al.id=$id_almacen
                    LEFT JOIN materiales mat ON mat.id=mact.idMaterial AND mat.idEmpresa=$idEmpresa
                    LEFT OUTER JOIN detalle_orden doc ON doc.id_articulo=mact.idMaterial AND CONVERT(doc.clave_articulo USING utf8) = CONVERT(pmat.clave USING utf8) AND doc.idEmpresa=$idEmpresa AND doc.id_almacen=$id_almacen
                    LEFT OUTER JOIN orden_compra oc ON oc.idEmpresa=$idEmpresa AND oc.id=doc.id_orden_compra AND oc.id_almacen=$id_almacen
                    WHERE (oc.estatus = 'CANCELADA' OR (doc.id IS NULL AND oc.id IS NULL)) AND mate.idEmpresa=$idEmpresa $filter
                    GROUP BY pmat.clave_cat ,pmat.clave, mact.idMaterial, pmat.idProveedor
                )";
            $query.=" ORDER BY idProveedor, clave_mat, id_articulo, tipo";
            $query=$this->db->query($query);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getSumTotalImporte($idMaterial)
        {
            $this->db->select_sum($this->alias . '.importe');
            $arrayWhere = array($this->alias . '.idMaterial' => $idMaterial);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->row()->importe > 0) {
                return $query->row()->importe;
            } else {
                return 0;
            }
        }

        function getByIdMaterialSemanaIn($idMaterial, $filtroSemana){
            $this->db->select($this->selectDefault, FALSE);
            if($filtroSemana > 0){
                $arrayWhere = array($this->alias . '.idMaterial' => $idMaterial, $this->alias . '.semana' => $filtroSemana);
            }else{
                $arrayWhere = array($this->alias . '.idMaterial' => $idMaterial);
            }
            $this->db->where($arrayWhere);
            $this->db->where($this->alias . '.id IN (SELECT d.idPresupuestoMat FROM orden_compra AS o INNER JOIN detalle_orden AS d WHERE o.idMaterial = '. $idMaterial .' AND d.idPresupuestoMat = p.id)');
            $this->db->order_by($this->alias . '.id', "asc");
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getByIdMaterialSemanaIn2($idPaquete, $semana="",$tipoAlmacen=0){
            $filter="";
            if ($semana != "") {
                $filter.=" AND pmat.semana=".$semana;
            }
            if($tipoAlmacen==1){
                $filter.=" AND mat.idPaquete = '$idPaquete'";
            }else if($tipoAlmacen==2){
                $filter.=" AND FIND_IN_SET(mat.idPaquete,'$idPaquete')";
            }
            $query=$this->db->query(
                "SELECT pmat.id, pmat.idProveedor, pmat.precioUnitario, mact.idMaterial, pmat.semana, cmat.id idCategoria, cmat.categoria 
                FROM presupuesto_mat pmat
                INNER JOIN materialesactividadprototipo mact ON mact.id=pmat.idMateriales
                INNER JOIN material mat ON mat.id=pmat.idMaterial
                LEFT JOIN categorias_mat cmat ON CONVERT(pmat.clave_cat USING utf8) = CONVERT(cmat.clave USING utf8)
                WHERE pmat.status $filter 
                GROUP BY pmat.id
                ORDER BY pmat.idProveedor");
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getSemanasByIdMaterial($idMaterial)
        {
            $this->db->select($this->alias . '.semana');
            $arrayWhere = array($this->alias . '.idMaterial' => $idMaterial);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.semana', "asc");
            $this->db->group_by($this->alias.'.semana');
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }
        
        function getByIdMatMat2SemProv($idMaterial, $idMateriales, $filtroSemana, $proveedor){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idMaterial' => $idMaterial, 'map.idMaterial' => $idMateriales, $this->alias.'.semana' => $filtroSemana, $this->alias.'.idProveedor' => $proveedor);
            $this->db->where($arrayWhere);
            $this->db->join('materialesactividadprototipo map', $this->alias.'.idMateriales = map.id');
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
    }