<?php

    class mpostventa extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "postventa";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idAltaVenta
            ,".$this->alias.".instElectricas
            ,".$this->alias.".instHidraulicas
            ,".$this->alias.".instSanitarias
            ,".$this->alias.".instGas
            ,".$this->alias.".canceleria
            ,".$this->alias.".impermeabilizacion
            ,".$this->alias.".acabados
            ,".$this->alias.".estructural
            ,".$this->alias.".accesorios
            ,".$this->alias.".calentadorAgua
            ,".$this->alias.".pdf_14
            ,".$this->alias.".statusIncidencia
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idAltaVenta' => '',
                'instElectricas' => '',
                'instHidraulicas' => '',
                'instSanitarias' => '',
                'instGas' => '',
                'canceleria' => '',
                'impermeabilizacion' => '',
                'acabados' => '',
                'estructural' => '',
                'accesorios' => '',
                'calentadorAgua' => '',
                'pdf_14' => '',
                'statusIncidencia' => '',
                'status' => '',
                'txtstatus' => ''
            );
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idAltaVenta'] = $r->row()->idAltaVenta;
                $array['instElectricas'] = $r->row()->instElectricas;
                $array['instHidraulicas'] = $r->row()->instHidraulicas;
                $array['instSanitarias'] = $r->row()->instSanitarias;
                $array['instGas'] = $r->row()->instGas;
                $array['canceleria'] = $r->row()->canceleria;
                $array['impermeabilizacion'] = $r->row()->impermeabilizacion;
                $array['acabados'] = $r->row()->acabados;
                $array['estructural'] = $r->row()->estructural;
                $array['accesorios'] = $r->row()->accesorios;
                $array['calentadorAgua'] = $r->row()->calentadorAgua;
                $array['pdf_14'] = $r->row()->pdf_14;
                $array['statusIncidencia'] = $r->row()->statusIncidencia;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
            $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }else{
                return 0;
            }
        }

        function getByIdAltaVenta($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdAV($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.idAltaVenta' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
    }