<?php

    class mpostulaciones extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "postulaciones";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".idArea
            ,".$this->alias.".idPuesto
            ,".$this->alias.".nombre
            ,".$this->alias.".telefono
            ,".$this->alias.".ciudad
            ,".$this->alias.".nivel
            ,".$this->alias.".anos
            ,".$this->alias.".salario
            ,".$this->alias.".licencia
            ,".$this->alias.".pdf
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }
        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'idArea' => '',
                'idPuesto' => '',
                'nombre' => '',
                'telefono' => '',
                'ciudad' => '',
                'nivel' => '',
                'anos' => '',
                'salario' => '',
                'licencia' => '',
                'pdf' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['idArea'] = $r->row()->idArea;
                $array['idPuesto'] = $r->row()->idPuesto;
                $array['nombre'] = $r->row()->nombre;
                $array['telefono'] = $r->row()->telefono;
                $array['ciudad'] = $r->row()->ciudad;
                $array['nivel'] = $r->row()->nivel;
                $array['anos'] = $r->row()->anos;
                $array['salario'] = $r->row()->salario;
                $array['licencia'] = $r->row()->licencia;
                $array['pdf'] = $r->row()->pdf;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;
            }
                $array['msg'] = '';
            return $array;
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
    }