<?php
    class mpersonal extends MY_Model{
        protected $CI;
        public function __construct(){
            parent :: __construct();
            $this->CI =& get_instance();
            $this->table = "personal";
            $this->alias = 'p';

            $this->selectDefault = "".
             $this->alias.".id
            ,".$this->alias.".nombre
            ,".$this->alias.".apellido
            ,".$this->alias.".direccion
            ,".$this->alias.".emergencia
            ,".$this->alias.".pertenece_a
            ,".$this->alias.".celular
            ,".$this->alias.".idArea
            ,".$this->alias.".email
            ,".$this->alias.".idPuesto
            ,".$this->alias.".precio
            ,".$this->alias.".foto
            ,".$this->alias.".thumbnail
            ,".$this->alias.".status
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";
        }

        private function _populateValues($r)
        {
            $this->CI->load->helper('tools');
            $array = array(
                'id' => '',
                'nombre' => '',
                'apellido' => '',
                'direccion' => '',
                'emergencia' => '',
                'pertenece_a' => '',
                'celular' => '',
                'idArea' => '',
                'email' => '',
                'idPuesto' => '',
                'precio' => '',
                'status' => '',
                'txtstatus' => ''
            );
            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['nombre'] = $r->row()->nombre;
                $array['apellido'] = $r->row()->apellido;
                $array['direccion'] = $r->row()->direccion;
                $array['emergencia'] = $r->row()->emergencia;
                $array['pertenece_a'] = $r->row()->pertenece_a;
                $array['celular'] = $r->row()->celular;
                $array['idArea'] = $r->row()->idArea;
                $array['email'] = $r->row()->email;
                $array['idPuesto'] = $r->row()->idPuesto;
                $array['precio'] = $r->row()->precio;
                $array['status'] = $r->row()->status;
                $array['txtstatus'] = $r->row()->txtstatus;

            }
            return $array;
        }

        private function _listado($q)
        {
            $this->CI->load->helper('tools');
            $this->CI->load->model(array('mareas'));
            $this->CI->load->model(array('mpuestos'));
            //$this->CI->load->model(array('mpolizas'));
            $permisos=permisos("personal");

            if (!is_numeric($q)){
                foreach ($q->result() as $row){
                    $array['aaData'][] = array(
                        'foto' => fotoTable($row->foto,$row->thumbnail,'uploads/personal/'),
                        'nombre' => $row->nombre." ".$row->apellido,
                        'direccion' => $row->direccion,
                        'celular' => $row->celular,
                        'email' => $row->email,
                        'area' => $this->mareas->getCampo("titulo",$row->idArea),
                        'puesto' => $this->mpuestos->getCampo("titulo",$row->idPuesto),
                        // 'idPuesto' => $row->idPuesto,
                        'precio' => $row->precio,
                        'acciones' => (in_array($this->config->item('rol'), $permisos[0])) ? acciones($row->id,$this->router->class) : ""
                        );
                }
            }else{
                $array['aaData'][] = array(
                    'foto' => 'No hay registros',
                    'nombre' => 'No hay registros',
                    'direccion' => 'No hay registros',
                    'celular' => 'No hay registros',
                    'email' => 'No hay registros',
                    'area' => 'No hay registros',
                    'puesto' => 'No hay registros',
                    'precio' => 'No hay registros',
                    'acciones' => 'No hay registros'
                    );
            }
            return $array;
        }

        function getLista($puesto){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            if($puesto != ""){
                $this->db->where($this->alias.'.idPuesto =',$puesto);
            }
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_listado($query);
            }else{
                return $this->_listado(0);
            }
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }
        function getPersonal(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query->result();
            }else{
                return 0;
            }
        }


    }