<?php

    class Mpaquete extends MY_Model{

        public function __construct(){
            parent :: __construct();
            $this->table = "paquetes";
            $this->alias = 'p';

            $this->selectDefault = "".
                $this->alias.".id
            ,".$this->alias.".titulo
            ,".$this->alias.".idFraccionamiento
            ,".$this->alias.".idPrototipo
            ,".$this->alias.".idManoObra
            ,".$this->alias.".idConstructor
            ,".$this->alias.".idResidentes
            ,".$this->alias.".manzana
            ,".$this->alias.".rango_lotes
            ,".$this->alias.".porcentaje_retencion
            ,".$this->alias.".anticipo
            ,".$this->alias.".fecha_inicio
            ,".$this->alias.".tipo
            ,".$this->alias.".tipoEstimacion
            ,".$this->alias.".tipoLote
            ,".$this->alias.".pdf
            ,".$this->alias.".pdf_1
            ,".$this->alias.".pdf_2
            ,".$this->alias.".fecha_inicio_real
            ,".$this->alias.".fecha_fin
            ,".$this->alias.".status
            ,".$this->alias.".statusPaquete
            ,IF(".$this->alias.".status > 0,'Activo','Inactivo') AS txtstatus";

              $this->selectResult = "".
                $this->alias.".id
            ,".$this->alias.".titulo as titulo";
        }

        // Populate values
        private function _populateValues($r)
        {
            $array = array(
                'id' => '',
                'titulo' => '',
                'idFraccionamiento' => '',
                'idPrototipo' => '',
                'idManoObra' => '',
                'idConstructor' => '',
                'idResidentes' => '',
                'manzana' => '',
                'rango_lotes' => '',
                'porcentaje_retencion' => '',
                'anticipo' => '',
                'fecha_inicio' => '',
                'tipo' => '',
                'tipoEstimacion' => '',
                'tipoLote' => '',
                'pdf' => '',
                'pdf_1' => '',
                'pdf_2' => '',
                'fecha_fin' => '',
                'statusPaquete' => '',
                'status' => '',
                'txtstatus' => ''
            );

            if (!is_numeric($r)) {
                $array['id'] = $r->row()->id;
                $array['titulo'] = $r->row()->titulo;
                $array['idFraccionamiento'] = $r->row()->idFraccionamiento;
                $array['idPrototipo'] = $r->row()->idPrototipo;
                $array['idManoObra'] = $r->row()->idManoObra;
                $array['idConstructor'] = $r->row()->idConstructor;
                $array['idResidentes'] = $r->row()->idResidentes;
                $array['manzana'] = $r->row()->manzana;
                $array['rango_lotes'] = $r->row()->rango_lotes;
                $array['porcentaje_retencion'] = $r->row()->porcentaje_retencion;
                $array['anticipo'] = $r->row()->anticipo;
                $array['fecha_inicio'] = $r->row()->fecha_inicio;
                $array['tipo'] = $r->row()->tipo;
                $array['tipoEstimacion'] = $r->row()->tipoEstimacion;
                $array['tipoLote'] = $r->row()->tipoLote;
                $array['pdf'] = $r->row()->pdf;
                $array['pdf_1'] = $r->row()->pdf_1;
                $array['pdf_2'] = $r->row()->pdf_2;
                $array['fecha_inicio_real'] = $r->row()->fecha_inicio_real;
                $array['fecha_fin'] = $r->row()->fecha_fin;
                $array['status'] = $r->row()->status;
                $array['statusPaquete'] = $r->row()->statusPaquete;
                $array['txtstatus'] = $r->row()->txtstatus;
            }            

            $array['msg'] = '';
            return $array;

        }

        function getSelectResult(){
            $this->db->select($this->selectResult,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getByExistInArranque($idEmpresa=0,$idArranque=0,$idPaquetes=0){
            $filter="";
            $filter2="";
            if($idArranque > 0 && $idPaquetes > 0){
                $filter.=" OR (FIND_IN_SET(paq.id,'$idPaquetes') AND mate.idEmpresa=$idEmpresa)";
            }
            if($idEmpresa > 0){
                $filter2.=" AND mate.idEmpresa=$idEmpresa";
            }
            $query=$this->db->query("SELECT DISTINCT paq.id, paq.titulo FROM paquetes paq
            LEFT JOIN material mate ON mate.idPaquete=paq.id
            LEFT OUTER JOIN arranque arr ON FIND_IN_SET(paq.id,arr.idPaquetes)
            WHERE (arr.id IS NULL $filter) $filter2");

            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getAll(){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }

        function getById($id){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.id' => $id);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getByIdFraccionamientoPrototipo($idFraccionamiento, $idPrototipo, $subQuery = false, $nameTable = '')
        {
            $this->db->select($this->selectDefault, FALSE);
            $arrayWhere = array($this->alias . '.idFraccionamiento' => $idFraccionamiento, $this->alias . '.idPrototipo' => $idPrototipo);
            $this->db->where($arrayWhere);
            if($subQuery == true && $nameTable != ''){
                $this->db->where($this->alias . '.id NOT IN (SELECT idPaquete FROM '. $nameTable .')');
            }
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getByIdFraccionamientoPrototipo2($idFraccionamiento, $idPrototipo)
        {
            $this->db->select($this->selectDefault, FALSE);
            $this->db->where($this->alias . '.idFraccionamiento = ' . $idFraccionamiento . ' AND ' . $this->alias . '.idPrototipo = ' . $idPrototipo . ' AND ' . $this->alias. '.id NOT IN (SELECT idPaquete FROM estimacion)');
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }
        
        function getByIdManoObra($idMO){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $arrayWhere = array($this->alias.'.idManoObra' => $idMO);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $this->_populateValues($query);
            }
            else{
                return 0;
            }
        }

        function getAllByNotInEstimacion()
        {
            $this->db->select($this->selectDefault, FALSE);
            $this->db->where($this->alias . '.id NOT IN (SELECT idPaquete FROM estimacion_programa) AND '.$this->alias.'.status = 1');
            $this->db->order_by($this->alias.'.id', "desc");
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getAllByStatusPaquete2()
        {
            $this->db->select($this->selectDefault, FALSE);
            $arrayWhere = array($this->alias.'.status' => true, $this->alias . '.statusPaquete' => 2);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table . ' AS ' . $this->alias);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }

        function getAllByTipo($tipo=1){
            $query=$this->db->query("SELECT paq.* FROM paquetes paq
            LEFT JOIN arranque arr ON FIND_IN_SET(paq.id, arr.idPaquetes)
            WHERE arr.estatus_arranque=2 AND paq.tipo=$tipo");
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }
       
        function getByIdFraccionamientoPrototipo3($idFraccionamiento, $idPrototipo)
        {
            $query="SELECT id,titulo FROM paquetes WHERE idManoObra IN 
            (SElECT id FROM mano_obra WHERE idFraccionamiento=$idFraccionamiento AND idPrototipo=$idPrototipo) 
            AND id NOT IN (SELECT idPaquete FROM material) ORDER BY id DESC";
            $query = $this->db->query($query);
            if ($query->num_rows() > 0) {
                return $query;
            } else {
                return 0;
            }
        }
        
        function getAllByIdManoObra($idMO){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $arrayWhere = array($this->alias.'.idManoObra' => $idMO);
            $this->db->where($arrayWhere);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }
            else{
                return 0;
            }
        }

        function getSelectResultInIds($ids){
            //$this->db->select($this->selectResult,FALSE);
            //$arrayWhere = array($this->alias.'.status' => true);
            //$this->db->where($arrayWhere);
            //$this->db->where_in($this->alias.'.id', $ids);
            //$this->db->order_by($this->alias.'.id', "desc");
            //$query = $this->db->get($this->table.' AS '.$this->alias);
            $idEmpresa=$_SESSION[$this->nsession]["idEmpresa"];
            $query=$this->db->query("SELECT * FROM paquetes WHERE status=1 AND id 
            IN (SELECT idPaquete FROM material WHERE idEmpresa=$idEmpresa)");
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
        
        function getInIds($ids){
            $this->db->select($this->selectDefault,FALSE);
            $arrayWhere = array($this->alias.'.status' => true);
            $this->db->where($arrayWhere);
            $this->db->where_in($this->alias.'.id', $ids);
            $query = $this->db->get($this->table.' AS '.$this->alias);
            if($query->num_rows()>0){
                return $query;
            }else{
                return 0;
            }
        }
    }